# include "Intrinsics.h"
# include "yyIntrinsics.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 33 "Intrinsics.puma"


# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"
# include "DefTable.h"

# define MODULE "Intrinsics"



static void yyExit () { Exit (1); }

void (* Intrinsics_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Intrinsics, routine %s failed\n", yyFunction);
 Intrinsics_Exit ();
}

bool IntrFuncElemental ARGS((tIdent name));
bool IntrFuncRed ARGS((tIdent name));
bool IntrFuncLocRed ARGS((tIdent name));
bool IntrFuncScan ARGS((tIdent name));
bool IntrFuncScatter ARGS((tIdent name));
bool IntrFuncDalib ARGS((tIdent name));
bool IntrFuncInquiry ARGS((tIdent name));
bool IntrFuncShape ARGS((tIdent name));
bool IntrSerialRoutine ARGS((tIdent name));
bool IntrPureRoutine ARGS((tIdent name));
int GetIntrinsicClass ARGS((tDefinitions obj));
int GetIntrinsicKind ARGS((tDefinitions obj));

bool IntrFuncElemental
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 55 "Intrinsics.puma"
  {
# line 57 "Intrinsics.puma"
   if (! ((GetIntrinsicClass (GetIntrinsicObject (name)) == kELEMENTAL))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IntrFuncRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 62 "Intrinsics.puma"
  {
# line 64 "Intrinsics.puma"
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kREDUCTION))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IntrFuncLocRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 69 "Intrinsics.puma"
  {
# line 71 "Intrinsics.puma"
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kLOCREDUCTION))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IntrFuncScan
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 76 "Intrinsics.puma"
  {
# line 78 "Intrinsics.puma"
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kSCAN))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IntrFuncScatter
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 83 "Intrinsics.puma"
  {
# line 85 "Intrinsics.puma"
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kSCATTER))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IntrFuncDalib
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("CSHIFT"))) {
# line 100 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("EOSHIFT"))) {
# line 101 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("MATMUL"))) {
# line 102 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_NUMBER"))) {
# line 103 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_SEED"))) {
# line 104 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("HPF_ALIGNMENT"))) {
# line 106 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("HPF_DISTRIBUTION"))) {
# line 107 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("HPF_TEMPLATE"))) {
# line 108 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("HPF_SUBGRID_INFO"))) {
# line 109 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_ALIGNMENT"))) {
# line 111 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_DISTRIBUTION"))) {
# line 112 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TEMPLATE"))) {
# line 113 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("ABSTRACT_TO_PHYSICAL"))) {
# line 115 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("PHYSICAL_TO_ABSTRACT"))) {
# line 116 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TO_LOCAL"))) {
# line 118 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_TO_GLOBAL"))) {
# line 119 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
# line 121 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
# line 122 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("SORT_DOWN"))) {
# line 124 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("SORT_UP"))) {
# line 125 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("DATE_AND_TIME"))) {
# line 127 "Intrinsics.puma"
   return true;

  }
# line 129 "Intrinsics.puma"
  {
# line 130 "Intrinsics.puma"
   if (! ((IntrFuncScan (name)))) goto yyL22;
  }
   return true;
yyL22:;

# line 133 "Intrinsics.puma"
  {
# line 134 "Intrinsics.puma"
   if (! ((IntrFuncScatter (name)))) goto yyL23;
  }
   return true;
yyL23:;

  if (equaltIdent (name, IsIdent ("PACK"))) {
# line 137 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
# line 138 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
# line 139 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
# line 141 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("PROCESSORS_SHAPE"))) {
# line 142 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_PROCS_SHAPE"))) {
# line 143 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_NUM_PROCS"))) {
# line 144 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_SIZE"))) {
# line 146 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_SHAPE"))) {
# line 147 "Intrinsics.puma"
   return true;

  }
  return false;
}

bool IntrFuncInquiry
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 151 "Intrinsics.puma"
  {
# line 152 "Intrinsics.puma"
   if (! ((GetIntrinsicClass (GetIntrinsicObject (name)) == kINQUIRY))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IntrFuncShape
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
# line 157 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("PROCESSORS_SHAPE"))) {
# line 158 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_PROCS_SHAPE"))) {
# line 159 "Intrinsics.puma"
   return true;

  }
  return false;
}

bool IntrSerialRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("CPU_TIME"))) {
# line 171 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("SYSTEM_CLOCK"))) {
# line 174 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("DATE_AND_TIME"))) {
# line 177 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("PACK"))) {
# line 180 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
# line 183 "Intrinsics.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
# line 186 "Intrinsics.puma"
   return true;

  }
  return false;
}

bool IntrPureRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 197 "Intrinsics.puma"
  {
# line 198 "Intrinsics.puma"
   if (! ((IntrFuncElemental (name)))) goto yyL1;
  }
   return true;
yyL1:;

# line 201 "Intrinsics.puma"
  {
# line 202 "Intrinsics.puma"
   if (! ((IntrFuncInquiry (name)))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

int GetIntrinsicClass
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 213 "Intrinsics.puma"
  {
# line 214 "Intrinsics.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return - 1;
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 218 "Intrinsics.puma"
   return obj->FuncObject.decl->INTRINSIC_DECL.class;

  }
  }
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kINTRINSIC_DECL) {
# line 222 "Intrinsics.puma"
   return obj->ProcObject.decl->INTRINSIC_DECL.class;

  }
  }
# line 226 "Intrinsics.puma"
   return - 1;

}

int GetIntrinsicKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 238 "Intrinsics.puma"
  {
# line 239 "Intrinsics.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return - 1;
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 243 "Intrinsics.puma"
   return obj->FuncObject.decl->INTRINSIC_DECL.kind;

  }
  }
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kINTRINSIC_DECL) {
# line 247 "Intrinsics.puma"
   return obj->ProcObject.decl->INTRINSIC_DECL.kind;

  }
  }
# line 251 "Intrinsics.puma"
   return - 1;

}

void BeginIntrinsics ()
{
}

void CloseIntrinsics ()
{
}
