# include "InterProc.h"
# include "yyInterProc.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"
# include "CallGraph.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 21 "InterProc.puma"


# undef  DEBUG

# define MODULE "InterProc"
# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Traverse.h"

# include "Common.h"
# include "Types.h"           /* ArrayFormals, ... */

# include "Calling.h"
# include "CallGraphFns.h"
# include "Nesting.h"
# include "Objects.h"

typedef void CallFunction ();

static int overlap_update;

static int  ip_update;         /* used globally for terminating  */
static int  ip_phases;         /* counts phases                  */

static char CalledRoutine  [MAXID_LENGTH];
static char CallingRoutine [MAXID_LENGTH];



static void yyExit () { Exit (1); }

void (* InterProc_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module InterProc, routine %s failed\n", yyFunction);
 InterProc_Exit ();
}

void Interprocedural ARGS((tTree t));
static void IP_Analysis ARGS((tTree t));
static void Dummy ARGS((tDefinitions actual_obj, tDefinitions formal_obj));
static void BottomUp ARGS((tCallGraph t, CallFunction f));
static void TopDown ARGS((tCallGraph t, CallFunction f));
static void UnMark ARGS((tCallGraph c));
static void ApplyToCalls ARGS((tDefinitions obj, CallFunction f));
static void DoFunction ARGS((tTree t));
static void SetSameOverlap ARGS((tDefinitions actual_obj, tDefinitions formal_obj));
static tDefinitions GetCommonReference ARGS((tDefinitions common_obj));
static void ProtocolUpdate ARGS((tDefinitions actual_obj, tDefinitions formal_obj, int kind));
static void SetSameOverlapFormals ARGS((tTree actuallist, tTree dummylist));
static void SetSameOverlapSize ARGS((tTree actual, tTree dummy));

void Interprocedural
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 60 "InterProc.puma"

char msg[100];

  if (t->Kind == kCOMP_UNIT) {
# line 70 "InterProc.puma"
  {
# line 72 "InterProc.puma"
   open_protocol ("adaptor.ipa");
# line 77 "InterProc.puma"
   FullTraverseAST (t->COMP_UNIT.COMP_ELEMENTS, IP_Analysis);
# line 79 "InterProc.puma"
 if (protocol_errors () == 0)

       {  BeginCalling ();
          Calling (t);
          CloseCalling ();

          

          do {

             ip_update = 0;

             UnMark (TheCallGraph);
             print_protocol ("INTERPROCEDURAL : TOP DOWN (start)");
             TopDown (TheCallGraph, DoFunction);
             print_protocol ("INTERPROCEDURAL : TOP DOWN (end)");
             sprintf (msg, "  there were %d updates\n", ip_update);
             print_protocol (msg);

             if (ip_update != 0)

               { ip_update = 0;
                 UnMark (TheCallGraph);
                 print_protocol ("INTERPROCEDURAL : BOTTOM UP (start)");
                 BottomUp (TheCallGraph, DoFunction);
                 print_protocol ("INTERPROCEDURAL : BOTTOM UP (end)");
                 sprintf (msg, "  there were %d updates\n", ip_update);
                 print_protocol (msg);
               }
 
          } while (ip_update != 0);

       }

    
# line 115 "InterProc.puma"
   close_protocol ();
  }
   return;

  }
;
}

static void IP_Analysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
# line 130 "InterProc.puma"
  {
# line 132 "InterProc.puma"
   CheckCommonDescriptors (t, Dummy);
  }
   return;

  }
  if (t->Kind == kCALL_STMT) {
# line 135 "InterProc.puma"
  {
# line 137 "InterProc.puma"
   CheckActualDescriptors (t, Dummy);
  }
   return;

  }
  if (t->Kind == kFUNC_CALL_EXP) {
# line 140 "InterProc.puma"
  {
# line 142 "InterProc.puma"
   CheckActualDescriptors (t, Dummy);
  }
   return;

  }
;
}

static void Dummy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_obj, register tDefinitions formal_obj)
# else
(actual_obj, formal_obj)
 register tDefinitions actual_obj;
 register tDefinitions formal_obj;
# endif
{
  if (formal_obj->Kind == kVarObject) {
  if (formal_obj->VarObject.Kind->Kind == kVarCommon) {
# line 147 "InterProc.puma"
  {
# line 151 "InterProc.puma"
   formal_obj->VarObject.Kind->VarCommon.ref_obj = actual_obj;
  }
   return;

  }
  }
# line 154 "InterProc.puma"
   return;

;
}

static void BottomUp
# if defined __STDC__ | defined __cplusplus
(register tCallGraph t, CallFunction f)
# else
(t, f)
 register tCallGraph t;
 CallFunction f;
# endif
{
# line 173 "InterProc.puma"
  {
# line 174 "InterProc.puma"
   if (! ((t == NoCallGraph))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kCallGraph) {
# line 177 "InterProc.puma"
  {
# line 179 "InterProc.puma"

#ifdef DEBUG
    printf ("Bottom Up Visting of all Nodes\n");
#endif 
    
# line 185 "InterProc.puma"
   UnMark (t->CallGraph.UserNodes);
# line 186 "InterProc.puma"
   BottomUp (t->CallGraph.UserNodes, f);
  }
   return;

  }
  if (t->Kind == kCallNodeList) {
# line 189 "InterProc.puma"
  {
# line 190 "InterProc.puma"
   BottomUp (t->CallNodeList.Elem, f);
# line 191 "InterProc.puma"
   BottomUp (t->CallNodeList.Next, f);
  }
   return;

  }
  if (t->Kind == kCallNode) {
# line 194 "InterProc.puma"
  {
# line 195 "InterProc.puma"
   if (! ((t->CallNode.unitkind == 2))) goto yyL4;
  }
   return;
yyL4:;

# line 198 "InterProc.puma"
  {
# line 200 "InterProc.puma"
   if (! ((t->CallNode.unitkind == 1))) goto yyL5;
  {
# line 202 "InterProc.puma"
   ApplyToCalls (t->CallNode.val, f);
# line 204 "InterProc.puma"
   t->CallNode.unitkind = 2;
  }
  }
   return;
yyL5:;

# line 207 "InterProc.puma"
  {
# line 209 "InterProc.puma"
   if (! ((UnitKind (t->CallNode.val) == 0))) goto yyL6;
  {
# line 213 "InterProc.puma"
   t->CallNode.unitkind = 1;
# line 215 "InterProc.puma"
   BottomUp (t->CallNode.calling, f);
# line 217 "InterProc.puma"
   ApplyToCalls (t->CallNode.val, f);
# line 219 "InterProc.puma"
   t->CallNode.unitkind = 2;
  }
  }
   return;
yyL6:;

  }
  if (t->Kind == kCallEdgeList) {
# line 222 "InterProc.puma"
  {
# line 223 "InterProc.puma"
   BottomUp (t->CallEdgeList.Node, f);
# line 224 "InterProc.puma"
   BottomUp (t->CallEdgeList.Next, f);
  }
   return;

  }
;
}

static void TopDown
# if defined __STDC__ | defined __cplusplus
(register tCallGraph t, CallFunction f)
# else
(t, f)
 register tCallGraph t;
 CallFunction f;
# endif
{
# line 243 "InterProc.puma"
  {
# line 244 "InterProc.puma"
   if (! ((t == NoCallGraph))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kCallGraph) {
# line 247 "InterProc.puma"
  {
# line 249 "InterProc.puma"

#ifdef DEBUG
    printf ("Top Down Visting of all Nodes\n");
#endif 
    
# line 255 "InterProc.puma"
   UnMark (t->CallGraph.UserNodes);
# line 256 "InterProc.puma"
   TopDown (t->CallGraph.UserNodes, f);
  }
   return;

  }
  if (t->Kind == kCallNodeList) {
# line 259 "InterProc.puma"
  {
# line 260 "InterProc.puma"
   TopDown (t->CallNodeList.Elem, f);
# line 261 "InterProc.puma"
   TopDown (t->CallNodeList.Next, f);
  }
   return;

  }
  if (t->Kind == kCallNode) {
# line 264 "InterProc.puma"
  {
# line 265 "InterProc.puma"
   if (! ((t->CallNode.unitkind == 2))) goto yyL4;
  }
   return;
yyL4:;

# line 268 "InterProc.puma"
  {
# line 270 "InterProc.puma"
   if (! ((t->CallNode.unitkind == 1))) goto yyL5;
  {
# line 272 "InterProc.puma"
   ApplyToCalls (t->CallNode.val, f);
# line 274 "InterProc.puma"
   t->CallNode.unitkind = 2;
  }
  }
   return;
yyL5:;

# line 277 "InterProc.puma"
  {
# line 279 "InterProc.puma"
   if (! ((UnitKind (t->CallNode.val) == 0))) goto yyL6;
  {
# line 283 "InterProc.puma"
   t->CallNode.unitkind = 1;
# line 285 "InterProc.puma"
   TopDown (t->CallNode.called_by, f);
# line 287 "InterProc.puma"
   ApplyToCalls (t->CallNode.val, f);
# line 289 "InterProc.puma"
   t->CallNode.unitkind = 2;
  }
  }
   return;
yyL6:;

  }
  if (t->Kind == kCallEdgeList) {
# line 292 "InterProc.puma"
  {
# line 294 "InterProc.puma"
   TopDown (t->CallEdgeList.Node, f);
# line 295 "InterProc.puma"
   TopDown (t->CallEdgeList.Next, f);
  }
   return;

  }
;
}

static void UnMark
# if defined __STDC__ | defined __cplusplus
(register tCallGraph c)
# else
(c)
 register tCallGraph c;
# endif
{
# line 306 "InterProc.puma"
  {
# line 307 "InterProc.puma"
   if (! ((c == NoCallGraph))) goto yyL1;
  }
   return;
yyL1:;

  if (c->Kind == kCallGraph) {
# line 310 "InterProc.puma"
  {
# line 311 "InterProc.puma"
   UnMark (c->CallGraph.UserNodes);
# line 312 "InterProc.puma"
   UnMark (c->CallGraph.IntrinsicNodes);
# line 313 "InterProc.puma"
   UnMark (c->CallGraph.ExternalNodes);
  }
   return;

  }
  if (c->Kind == kCallNodeList) {
# line 316 "InterProc.puma"
  {
# line 317 "InterProc.puma"
   UnMark (c->CallNodeList.Elem);
# line 318 "InterProc.puma"
   UnMark (c->CallNodeList.Next);
  }
   return;

  }
  if (c->Kind == kCallNode) {
# line 321 "InterProc.puma"
  {
# line 322 "InterProc.puma"
   c->CallNode.unitkind = 0;
  }
   return;

  }
;
}

static void ApplyToCalls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, CallFunction f)
# else
(obj, f)
 register tDefinitions obj;
 CallFunction f;
# endif
{
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kPROGRAM_DECL) {
# line 335 "InterProc.puma"
  {
# line 337 "InterProc.puma"
   if (! ((obj->ProcObject.decl->PROGRAM_DECL.PROGRAM_BODY != NoTree))) goto yyL1;
  {
# line 339 "InterProc.puma"
   GetString (obj->ProcObject.Ident, CallingRoutine);
# line 340 "InterProc.puma"
   NestOpenUnitObj (obj);
# line 341 "InterProc.puma"
   FullTraverseAST (obj->ProcObject.decl->PROGRAM_DECL.PROGRAM_BODY, f);
# line 342 "InterProc.puma"
   NestCloseUnitObj (obj);
  }
  }
   return;
yyL1:;

  }
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
# line 345 "InterProc.puma"
  {
# line 347 "InterProc.puma"
   if (! ((obj->ProcObject.decl->PROC_DECL.PROC_BODY != NoTree))) goto yyL2;
  {
# line 349 "InterProc.puma"
   GetString (obj->ProcObject.Ident, CallingRoutine);
# line 350 "InterProc.puma"
   NestOpenUnitObj (obj);
# line 351 "InterProc.puma"
   FullTraverseAST (obj->ProcObject.decl->PROC_DECL.PROC_BODY, f);
# line 352 "InterProc.puma"
   NestCloseUnitObj (obj);
  }
  }
   return;
yyL2:;

  }
  }
  if (obj->Kind == kFuncObject) {
# line 355 "InterProc.puma"
  {
# line 357 "InterProc.puma"
   GetString (obj->FuncObject.Ident, CallingRoutine);
# line 358 "InterProc.puma"
   NestOpenUnitObj (obj);
# line 359 "InterProc.puma"
   FullTraverseAST (obj->FuncObject.decl, f);
# line 360 "InterProc.puma"
   NestCloseUnitObj (obj);
  }
   return;

  }
;
}

static void DoFunction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
# line 378 "InterProc.puma"
  {
# line 380 "InterProc.puma"
   CheckCommonDescriptors (t, SetSameOverlap);
  }
   return;

  }
  if (t->Kind == kCALL_STMT) {
# line 383 "InterProc.puma"
  {
# line 387 "InterProc.puma"
   GetString (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, CalledRoutine);
# line 392 "InterProc.puma"
   CheckActualDescriptors (t, SetSameOverlap);
  }
   return;

  }
  if (t->Kind == kFUNC_CALL_EXP) {
# line 395 "InterProc.puma"
  {
# line 399 "InterProc.puma"
   GetString (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, CalledRoutine);
# line 400 "InterProc.puma"
   CheckActualDescriptors (t, SetSameOverlap);
  }
   return;

  }
;
}

static void SetSameOverlap
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_obj, register tDefinitions formal_obj)
# else
(actual_obj, formal_obj)
 register tDefinitions actual_obj;
 register tDefinitions formal_obj;
# endif
{
# line 414 "InterProc.puma"
  {
# line 416 "InterProc.puma"
   if (! ((VarRank (actual_obj) != VarRank (formal_obj)))) goto yyL1;
  {
# line 420 "InterProc.puma"
 if (semantic_check == 0)
       warning_protocol ("no overlap update: rank of dummy/actual mismatch");
     else
       error_protocol ("no overlap update: rank of dummy/actual mismatch");
    obj_protocol ("actual : ", actual_obj);
    obj_protocol ("dummy  : ", formal_obj);
  
  }
  }
   return;
yyL1:;

# line 429 "InterProc.puma"
  {
# line 431 "InterProc.puma"
   if (! ((VarRank (formal_obj) == 0))) goto yyL2;
  }
   return;
yyL2:;

# line 434 "InterProc.puma"
 {
  tDefinitions ref_actual_obj;
  {
# line 436 "InterProc.puma"
   overlap_update = 0;
# line 438 "InterProc.puma"
   SetSameOverlapFormals (ArrayFormals (actual_obj), ArrayFormals (formal_obj));
# line 441 "InterProc.puma"
   ProtocolUpdate (actual_obj, formal_obj, overlap_update);
# line 443 "InterProc.puma"
 if (overlap_update) ip_update++; 
# line 455 "InterProc.puma"

# line 457 "InterProc.puma"
 if ( IsVarCommon(actual_obj) && IsVarDummy(formal_obj))
    
     {   ref_actual_obj = GetCommonReference (actual_obj);

         if (ref_actual_obj != NoObject)

            SetSameOverlap (actual_obj, ref_actual_obj);
     }
  
  }
   return;
 }

;
}

static tDefinitions GetCommonReference
# if defined __STDC__ | defined __cplusplus
(register tDefinitions common_obj)
# else
(common_obj)
 register tDefinitions common_obj;
# endif
{
  if (common_obj->Kind == kVarObject) {
  if (common_obj->VarObject.Kind->Kind == kVarCommon) {
# line 470 "InterProc.puma"
   return common_obj->VarObject.Kind->VarCommon.ref_obj;

  }
  }
# line 474 "InterProc.puma"
  {
# line 475 "InterProc.puma"
   obj_error_protocol ("common object expected ", common_obj);
# line 476 "InterProc.puma"
   failure_protocol (MODULE, "GetCommonReference", common_obj->Object.decl);
  }
   return NoObject;

}

static void ProtocolUpdate
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_obj, register tDefinitions formal_obj, register int kind)
# else
(actual_obj, formal_obj, kind)
 register tDefinitions actual_obj;
 register tDefinitions formal_obj;
 register int kind;
# endif
{
# line 482 "InterProc.puma"

char msg[100];

# line 486 "InterProc.puma"
  {
# line 489 "InterProc.puma"
   goto yyL1;
  }
yyL1:;

# line 492 "InterProc.puma"
  {
# line 494 "InterProc.puma"
 if (kind == 1)
        print_protocol ("inherited overlap from formal");
      else if (kind == 2)
       print_protocol ("inherited overlap from actual");
     else 
       print_protocol ("now same overlap");

     if (IsVarDummy (formal_obj))
       { sprintf (msg, "   by calling subroutine %s in %s", 
                       CalledRoutine, CallingRoutine);
         print_protocol (msg);
       }
      else
         print_protocol ("   from reference common");

     obj_protocol ("actual : ", actual_obj);
     obj_protocol ("formal : ", formal_obj);
  
  }
   return;

;
}

static void SetSameOverlapFormals
# if defined __STDC__ | defined __cplusplus
(register tTree actuallist, register tTree dummylist)
# else
(actuallist, dummylist)
 register tTree actuallist;
 register tTree dummylist;
# endif
{
  if (actuallist->Kind == kSHAPE_LIST) {
  if (dummylist->Kind == kSHAPE_LIST) {
# line 526 "InterProc.puma"
  {
# line 528 "InterProc.puma"
   SetSameOverlapSize (actuallist->SHAPE_LIST.Elem, dummylist->SHAPE_LIST.Elem);
# line 529 "InterProc.puma"
   SetSameOverlapFormals (actuallist->SHAPE_LIST.Next, dummylist->SHAPE_LIST.Next);
  }
   return;

  }
  }
  if (actuallist->Kind == kSHAPE_EMPTY) {
  if (dummylist->Kind == kSHAPE_EMPTY) {
# line 532 "InterProc.puma"
   return;

  }
  }
# line 537 "InterProc.puma"
  {
# line 538 "InterProc.puma"
   failure2_protocol (MODULE, "SetSameOverlapFormals", actuallist, dummylist);
  }
   return;

;
}

static void SetSameOverlapSize
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree dummy)
# else
(actual, dummy)
 register tTree actual;
 register tTree dummy;
# endif
{
  if (Tree_IsType (actual, kSHAPE_SPEC)) {
  if (Tree_IsType (dummy, kSHAPE_SPEC)) {
# line 553 "InterProc.puma"
  {
# line 556 "InterProc.puma"
   SetSameOverlapSize (actual->SHAPE_SPEC.Overlap, dummy->SHAPE_SPEC.Overlap);
  }
   return;

  }
  }
  if (actual->Kind == kOVERLAP_SPEC) {
  if (dummy->Kind == kOVERLAP_SPEC) {
# line 561 "InterProc.puma"
  {
# line 563 "InterProc.puma"
 if (actual->OVERLAP_SPEC.left_size < dummy->OVERLAP_SPEC.left_size)  { actual->OVERLAP_SPEC.left_size = dummy->OVERLAP_SPEC.left_size;  overlap_update = overlap_update | 1; }
    if (dummy->OVERLAP_SPEC.left_size < actual->OVERLAP_SPEC.left_size)  { dummy->OVERLAP_SPEC.left_size = actual->OVERLAP_SPEC.left_size;  overlap_update = overlap_update | 2; }
    if (actual->OVERLAP_SPEC.right_size < dummy->OVERLAP_SPEC.right_size)  { actual->OVERLAP_SPEC.right_size = dummy->OVERLAP_SPEC.right_size;  overlap_update = overlap_update | 1; }
    if (dummy->OVERLAP_SPEC.right_size < actual->OVERLAP_SPEC.right_size)  { dummy->OVERLAP_SPEC.right_size = actual->OVERLAP_SPEC.right_size;  overlap_update = overlap_update | 2; }
  
  }
   return;

  }
  }
# line 570 "InterProc.puma"
  {
# line 571 "InterProc.puma"
   failure2_protocol (MODULE, "SetSameOverlapSize", actual, dummy);
  }
   return;

;
}

void BeginInterProc ()
{
}

void CloseInterProc ()
{
}
