# include "Inquiry.h"
# include "yyInquiry.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 19 "Inquiry.puma"


# define MODULE "Inquiry"

# include <stdio.h>
# include <string.h>
# include "protocol.h"
# include "Idents.h"
# include "StringMem.h"

# include "DefTable.h"

# include "Objects.h"
# include "Types.h"
# include "Expressions.h"
# include "Transform.h"
# include "Rank.h"
# include "Intrinsics.h"
# include "MakeRagged.h"

# include "precision.h"



static void yyExit () { Exit (1); }

void (* Inquiry_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Inquiry, routine %s failed\n", yyFunction);
 Inquiry_Exit ();
}

tTree TranslateInquiryCall ARGS((tTree f));
static tTree Translate ARGS((tTree f, tIdent name, tTree params));
static tTree MakeIndexSizeExp ARGS((tTree t, int dim));
static tTree MultExtensions ARGS((tTree t));
static tTree MakeBoundExp ARGS((tTree t, int dim, int kind));
static tTree BoundValue ARGS((tTree t, int kind));
static tTree SizeValue ARGS((tTree t));
static tTree GetIndexSlice ARGS((tTree indexes, int n));
static void GetExpSlice ARGS((tTree exp, bool * yyP2, tTree * yyP1));
static void TranslateDotProduct ARGS((tTree p, tTree params));
static tTree ParamToExp ARGS((tTree param));
static tTree MakeConjgExp ARGS((tTree param));
static void SetIntrinsicObj ARGS((tTree p));
static tTree MakeHuge ARGS((int kind, int size));
static tTree MakeTiny ARGS((int size));
static tTree MakeEpsilon ARGS((int size));
static tTree MakeGlobalBounds ARGS((tTree exp));

tTree TranslateInquiryCall
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kFUNC_CALL_EXP) {
# line 58 "Inquiry.puma"
  {
# line 60 "Inquiry.puma"
   if (! ((! IsIntrCall (f)))) goto yyL1;
  }
   return f;
yyL1:;

# line 64 "Inquiry.puma"
 {
  tTree exp;
  {
# line 66 "Inquiry.puma"

# line 68 "Inquiry.puma"
   if (! ((IntrFuncInquiry (f->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL2;
  {
# line 70 "Inquiry.puma"
   tree_protocol ("translate inquiry call : ", f);
# line 71 "Inquiry.puma"
   exp = Translate (f, f->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, f->FUNC_CALL_EXP.FUNC_PARAMS);
# line 72 "Inquiry.puma"
   tree_protocol ("inquiry expression is  : ", exp);
  }
  }
  {
   return exp;
  }
 }
yyL2:;

# line 76 "Inquiry.puma"
  {
# line 78 "Inquiry.puma"
   if (! ((f->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("DOT_PRODUCT")))) goto yyL3;
  {
# line 80 "Inquiry.puma"
   tree_protocol ("translate dotproduct : ", f);
# line 81 "Inquiry.puma"
   TranslateDotProduct (f->FUNC_CALL_EXP.FUNC_ID, f->FUNC_CALL_EXP.FUNC_PARAMS);
# line 82 "Inquiry.puma"
   tree_protocol ("new call is : ", f);
  }
  }
   return f;
yyL3:;

  }
# line 86 "Inquiry.puma"
   return f;

}

static tTree Translate
# if defined __STDC__ | defined __cplusplus
(register tTree f, register tIdent name, register tTree params)
# else
(f, name, params)
 register tTree f;
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 100 "Inquiry.puma"
 {
  type_rec x_type;
  {
# line 102 "Inquiry.puma"
   if (! ((name == IsIdent ("KIND")))) goto yyL1;
  {
# line 104 "Inquiry.puma"

# line 106 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
  }
  }
  {
   return MakeConstant (x_type . type_size);
  }
 }
yyL1:;

# line 115 "Inquiry.puma"
 {
  type_rec x_type;
  int val;
  {
# line 117 "Inquiry.puma"
   if (! ((name == IsIdent ("DIGITS")))) goto yyL2;
  {
# line 119 "Inquiry.puma"

# line 121 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
# line 123 "Inquiry.puma"

# line 125 "Inquiry.puma"
 if (x_type.type_kind == kINTEGER_TYPE)
        val = int_digits (x_type.type_size);
      else
        val = real_digits (x_type.type_size);
   
  }
  }
  {
   return MakeConstant (val);
  }
 }
yyL2:;

# line 138 "Inquiry.puma"
 {
  type_rec x_type;
  {
# line 140 "Inquiry.puma"
   if (! ((name == IsIdent ("EPSILON")))) goto yyL3;
  {
# line 142 "Inquiry.puma"

# line 144 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
  }
  }
  {
   return MakeEpsilon (x_type . type_size);
  }
 }
yyL3:;

# line 153 "Inquiry.puma"
 {
  type_rec x_type;
  {
# line 155 "Inquiry.puma"
   if (! ((name == IsIdent ("HUGE")))) goto yyL4;
  {
# line 157 "Inquiry.puma"

# line 159 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
  }
  }
  {
   return MakeHuge (x_type . type_kind, x_type . type_size);
  }
 }
yyL4:;

# line 168 "Inquiry.puma"
 {
  type_rec x_type;
  {
# line 170 "Inquiry.puma"
   if (! ((name == IsIdent ("MINEXPONENT")))) goto yyL5;
  {
# line 172 "Inquiry.puma"

# line 174 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
  }
  }
  {
   return MakeConstant (real_minexponent (x_type . type_size));
  }
 }
yyL5:;

# line 183 "Inquiry.puma"
 {
  type_rec x_type;
  {
# line 185 "Inquiry.puma"
   if (! ((name == IsIdent ("MAXEXPONENT")))) goto yyL6;
  {
# line 187 "Inquiry.puma"

# line 189 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
  }
  }
  {
   return MakeConstant (real_maxexponent (x_type . type_size));
  }
 }
yyL6:;

# line 198 "Inquiry.puma"
 {
  type_rec x_type;
  {
# line 200 "Inquiry.puma"
   if (! ((name == IsIdent ("PRECISION")))) goto yyL7;
  {
# line 202 "Inquiry.puma"

# line 204 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
  }
  }
  {
   return MakeConstant (real_precision (x_type . type_size));
  }
 }
yyL7:;

# line 213 "Inquiry.puma"
  {
# line 215 "Inquiry.puma"
   if (! ((name == IsIdent ("RADIX")))) goto yyL8;
  }
   return MakeConstant (2);
yyL8:;

# line 224 "Inquiry.puma"
 {
  type_rec x_type;
  int val;
  {
# line 226 "Inquiry.puma"
   if (! ((name == IsIdent ("RANGE")))) goto yyL9;
  {
# line 228 "Inquiry.puma"

# line 230 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
# line 232 "Inquiry.puma"

# line 234 "Inquiry.puma"
 if (x_type.type_kind == kINTEGER_TYPE)
        val = int_range (x_type.type_size);
      else
        val = real_range (x_type.type_size);
   
  }
  }
  {
   return MakeConstant (val);
  }
 }
yyL9:;

# line 246 "Inquiry.puma"
 {
  type_rec x_type;
  {
# line 248 "Inquiry.puma"
   if (! ((name == IsIdent ("TINY")))) goto yyL10;
  {
# line 250 "Inquiry.puma"

# line 252 "Inquiry.puma"
   GetParamType (params->BTP_LIST.Elem, & x_type);
  }
  }
  {
   return MakeTiny (x_type . type_size);
  }
 }
yyL10:;

# line 317 "Inquiry.puma"
 {
  tTree exp;
  int dim;
  {
# line 319 "Inquiry.puma"
   if (! ((name == IsIdent ("SHAPE")))) goto yyL15;
  {
# line 321 "Inquiry.puma"

# line 322 "Inquiry.puma"

# line 324 "Inquiry.puma"
 exp = mBTE_EMPTY ();
     for (dim=TreeRank(params->BTP_LIST.Elem); dim>=1; dim--)
        exp = mBTE_LIST (MakeIndexSizeExp (params->BTP_LIST.Elem, dim), exp);
     exp = mARRAY_EXP (exp);
   
  }
  }
  {
   return exp;
  }
 }
yyL15:;

# line 337 "Inquiry.puma"
 {
  tTree exp;
  int dim;
  {
# line 339 "Inquiry.puma"
   if (! ((name == IsIdent ("GLOBAL_SHAPE")))) goto yyL16;
  {
# line 341 "Inquiry.puma"

# line 342 "Inquiry.puma"

# line 344 "Inquiry.puma"
 exp = mBTE_EMPTY ();
     for (dim=TreeRank(params->BTP_LIST.Elem); dim>=1; dim--)
        exp = mBTE_LIST (MakeIndexSizeExp (params->BTP_LIST.Elem, dim), exp);
     exp = mARRAY_EXP (exp);
   
  }
  }
  {
   return MakeGlobalBounds (exp);
  }
 }
yyL16:;

  }
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 261 "Inquiry.puma"
  {
# line 263 "Inquiry.puma"
   if (! ((name == IsIdent ("SIZE")))) goto yyL11;
  }
   return MakeIndexSizeExp (params->BTP_LIST.Elem, 0);
yyL11:;

# line 272 "Inquiry.puma"
  {
# line 274 "Inquiry.puma"
   if (! ((name == IsIdent ("GLOBAL_SIZE")))) goto yyL12;
  }
   return MakeGlobalBounds (MakeIndexSizeExp (params->BTP_LIST.Elem, 0));
yyL12:;

# line 357 "Inquiry.puma"
 {
  tTree exp;
  int dim;
  {
# line 359 "Inquiry.puma"
   if (! ((name == IsIdent ("LBOUND")))) goto yyL17;
  {
# line 361 "Inquiry.puma"

# line 362 "Inquiry.puma"

# line 364 "Inquiry.puma"
 exp = mBTE_EMPTY ();
     for (dim=TreeRank(params->BTP_LIST.Elem); dim>=1; dim--)
        exp = mBTE_LIST (MakeBoundExp (params->BTP_LIST.Elem, dim, 0), exp);
     exp = mARRAY_EXP (exp);
   
  }
  }
  {
   return exp;
  }
 }
yyL17:;

# line 390 "Inquiry.puma"
 {
  tTree exp;
  int dim;
  {
# line 392 "Inquiry.puma"
   if (! ((name == IsIdent ("UBOUND")))) goto yyL19;
  {
# line 394 "Inquiry.puma"

# line 395 "Inquiry.puma"

# line 397 "Inquiry.puma"
 exp = mBTE_EMPTY ();
     for (dim=TreeRank(params->BTP_LIST.Elem); dim>=1; dim--)
        exp = mBTE_LIST (MakeBoundExp (params->BTP_LIST.Elem, dim, 1), exp);
     exp = mARRAY_EXP (exp);
   
  }
  }
  {
   return exp;
  }
 }
yyL19:;

  }
  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 283 "Inquiry.puma"
 {
  bool found;
  int dim_val;
  {
# line 285 "Inquiry.puma"
   if (! ((name == IsIdent ("SIZE")))) goto yyL13;
  {
# line 287 "Inquiry.puma"

# line 288 "Inquiry.puma"

# line 290 "Inquiry.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, & found, & dim_val);
# line 291 "Inquiry.puma"
   if (! ((found))) goto yyL13;
  }
  }
  {
   return MakeIndexSizeExp (params->BTP_LIST.Elem, dim_val);
  }
 }
yyL13:;

# line 300 "Inquiry.puma"
 {
  bool found;
  int dim_val;
  {
# line 302 "Inquiry.puma"
   if (! ((name == IsIdent ("GLOBAL_SIZE")))) goto yyL14;
  {
# line 304 "Inquiry.puma"

# line 305 "Inquiry.puma"

# line 307 "Inquiry.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, & found, & dim_val);
# line 308 "Inquiry.puma"
   if (! ((found))) goto yyL14;
  }
  }
  {
   return MakeGlobalBounds (MakeIndexSizeExp (params->BTP_LIST.Elem, dim_val));
  }
 }
yyL14:;

# line 373 "Inquiry.puma"
 {
  bool found;
  int dim_val;
  {
# line 375 "Inquiry.puma"
   if (! ((name == IsIdent ("LBOUND")))) goto yyL18;
  {
# line 377 "Inquiry.puma"

# line 378 "Inquiry.puma"

# line 380 "Inquiry.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, & found, & dim_val);
# line 381 "Inquiry.puma"
   if (! ((found))) goto yyL18;
  }
  }
  {
   return MakeBoundExp (params->BTP_LIST.Elem, dim_val, 0);
  }
 }
yyL18:;

# line 406 "Inquiry.puma"
 {
  bool found;
  int dim_val;
  {
# line 408 "Inquiry.puma"
   if (! ((name == IsIdent ("UBOUND")))) goto yyL20;
  {
# line 410 "Inquiry.puma"

# line 411 "Inquiry.puma"

# line 413 "Inquiry.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, & found, & dim_val);
# line 414 "Inquiry.puma"
   if (! ((found))) goto yyL20;
  }
  }
  {
   return MakeBoundExp (params->BTP_LIST.Elem, dim_val, 1);
  }
 }
yyL20:;

  }
  }
  }
# line 419 "Inquiry.puma"
   return f;

}

static tTree MakeIndexSizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dim)
# else
(t, dim)
 register tTree t;
 register int dim;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 432 "Inquiry.puma"
   return MakeIndexSizeExp (t->VAR_PARAM.V, dim);

  }
  if (t->Kind == kADDR) {
  if (t->ADDR.E->Kind == kFUNC_CALL_EXP) {
# line 437 "Inquiry.puma"
  {
# line 439 "Inquiry.puma"
   if (! ((IsIntrCall (t->ADDR.E)))) goto yyL2;
  {
# line 440 "Inquiry.puma"
   if (! ((t->ADDR.E->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("PROCESSORS_SHAPE")))) goto yyL2;
  }
  }
   return mRANK_EXP (0);
yyL2:;

# line 444 "Inquiry.puma"
  {
# line 446 "Inquiry.puma"
   if (! ((IsIntrCall (t->ADDR.E)))) goto yyL3;
  {
# line 447 "Inquiry.puma"
   if (! ((t->ADDR.E->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("ACTIVE_PROCS_SHAPE")))) goto yyL3;
  }
  }
   return mRANK_EXP (1);
yyL3:;

  }
  }
  if (t->Kind == kINDEXED_VAR) {
  if (equalint (dim, 0)) {
# line 451 "Inquiry.puma"
  {
# line 453 "Inquiry.puma"
   if (! ((IsTreeAccess (t->INDEXED_VAR.IND_VAR)))) goto yyL4;
  {
# line 455 "Inquiry.puma"
   error_protocol ("illegal argument for intrinsic SIZE");
# line 456 "Inquiry.puma"
   tree_protocol ("illegal argument : ", t);
  }
  }
   return t;
yyL4:;

  }
  if (equalint (dim, 0)) {
# line 460 "Inquiry.puma"
   return MultExtensions (t->INDEXED_VAR.IND_EXPS);

  }
# line 465 "Inquiry.puma"
   return SizeValue (GetIndexSlice (t->INDEXED_VAR.IND_EXPS, dim));

  }
  if (t->Kind == kUSED_VAR) {
# line 470 "Inquiry.puma"
  {
# line 472 "Inquiry.puma"
   if (! ((TreeRank (t) == 0))) goto yyL7;
  }
   return MakeConstant (1);
yyL7:;

  }
# line 476 "Inquiry.puma"
  {
# line 478 "Inquiry.puma"
   error_protocol ("illegal argument for intrinsic SIZE");
# line 479 "Inquiry.puma"
   tree_protocol ("illegal argument : ", t);
  }
   return t;

}

static tTree MultExtensions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 491 "Inquiry.puma"

tTree size_exp, index_exp;

  if (t->Kind == kBTE_LIST) {
# line 495 "Inquiry.puma"
  {
# line 497 "Inquiry.puma"
   if (! ((TreeRank (t->BTE_LIST.Elem) == 0))) goto yyL1;
  }
   return MultExtensions (t->BTE_LIST.Next);
yyL1:;

# line 501 "Inquiry.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 503 "Inquiry.puma"
   GetExpSlice (t->BTE_LIST.Elem, & yyV1, & yyV2);
# line 504 "Inquiry.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 509 "Inquiry.puma"
 index_exp = MultExtensions (t->BTE_LIST.Next);
     size_exp  = SizeValue (yyV2);
     if (index_exp != NoTree)
       size_exp = mOP_EXP (mOP_TIMES (), index_exp, size_exp);
   
  }
  }
  {
   return size_exp;
  }
 }
yyL2:;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 517 "Inquiry.puma"
   return NoTree;

  }
# line 521 "Inquiry.puma"
  {
# line 522 "Inquiry.puma"
   failure_protocol (MODULE, "MultExtensions", t);
  }
   return NoTree;

}

static tTree MakeBoundExp
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dim, register int kind)
# else
(t, dim, kind)
 register tTree t;
 register int dim;
 register int kind;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 534 "Inquiry.puma"
   return MakeBoundExp (t->VAR_PARAM.V, dim, kind);

  }
  if (t->Kind == kINDEXED_VAR) {
# line 539 "Inquiry.puma"
   return BoundValue (GetIndexSlice (t->INDEXED_VAR.IND_EXPS, dim), kind);

  }
# line 544 "Inquiry.puma"
  {
# line 546 "Inquiry.puma"
   error_protocol ("could not translate inquiry");
# line 547 "Inquiry.puma"
   tree_protocol ("is not a variable : ", t);
  }
   return mDUMMY_EXP ();

}

static tTree BoundValue
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int kind)
# else
(t, kind)
 register tTree t;
 register int kind;
# endif
{
  if (t->Kind == kSLICE_EXP) {
  if (equalint (kind, 0)) {
# line 559 "Inquiry.puma"
   return t->SLICE_EXP.START;

  }
  if (equalint (kind, 1)) {
# line 564 "Inquiry.puma"
   return t->SLICE_EXP.STOP;

  }
  }
# line 569 "Inquiry.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 571 "Inquiry.puma"
   GetExpSlice (t, & yyV1, & yyV2);
# line 572 "Inquiry.puma"
   if (! ((yyV1))) goto yyL3;
  }
  {
   return BoundValue (yyV2, kind);
  }
 }
yyL3:;

# line 576 "Inquiry.puma"
  {
# line 577 "Inquiry.puma"
   error_protocol ("could not translate bound inquiry");
# line 578 "Inquiry.puma"
   tree_protocol ("problem with : ", t);
  }
   return t;

}

static tTree SizeValue
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSLICE_EXP) {
# line 590 "Inquiry.puma"
   return MakeSliceExp (t->SLICE_EXP.START, t->SLICE_EXP.STOP);

  }
# line 595 "Inquiry.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 597 "Inquiry.puma"
   GetExpSlice (t, & yyV1, & yyV2);
# line 598 "Inquiry.puma"
   if (! ((yyV1))) goto yyL2;
  }
  {
   return SizeValue (yyV2);
  }
 }
yyL2:;

# line 602 "Inquiry.puma"
  {
# line 603 "Inquiry.puma"
   error_protocol ("could not translate size inquiry");
# line 604 "Inquiry.puma"
   tree_protocol ("problem with : ", t);
  }
   return t;

}

static tTree GetIndexSlice
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int n)
# else
(indexes, n)
 register tTree indexes;
 register int n;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
  if (equalint (n, 1)) {
# line 616 "Inquiry.puma"
  {
# line 617 "Inquiry.puma"
   if (! ((TreeRank (indexes->BTE_LIST.Elem) > 0))) goto yyL1;
  }
   return indexes->BTE_LIST.Elem;
yyL1:;

  }
# line 621 "Inquiry.puma"
  {
# line 622 "Inquiry.puma"
   if (! ((TreeRank (indexes->BTE_LIST.Elem) > 0))) goto yyL2;
  }
   return GetIndexSlice (indexes->BTE_LIST.Next, n - 1);
yyL2:;

# line 626 "Inquiry.puma"
  {
# line 627 "Inquiry.puma"
   if (! ((TreeRank (indexes->BTE_LIST.Elem) == 0))) goto yyL3;
  }
   return GetIndexSlice (indexes->BTE_LIST.Next, n);
yyL3:;

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 631 "Inquiry.puma"
  {
# line 632 "Inquiry.puma"
   error_protocol ("could not translate inquiry");
  }
   return mDUMMY_EXP ();

  }
 yyAbort ("GetIndexSlice");
}

static void GetExpSlice
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register bool * yyP2, register tTree * yyP1)
# else
(exp, yyP2, yyP1)
 register tTree exp;
 register bool * yyP2;
 register tTree * yyP1;
# endif
{
# line 648 "Inquiry.puma"
  {
# line 649 "Inquiry.puma"
   if (! ((TreeRank (exp) != 1))) goto yyL1;
  }
   * yyP2 = false;
   * yyP1 = exp;
   return;
yyL1:;

  if (exp->Kind == kSLICE_EXP) {
# line 652 "Inquiry.puma"
   * yyP2 = true;
   * yyP1 = exp;
   return;

  }
  if (exp->Kind == kVAR_EXP) {
  if (exp->VAR_EXP.V->Kind == kINDEXED_VAR) {
# line 655 "Inquiry.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 657 "Inquiry.puma"
   GetExpSlice (GetIndexSlice (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS, 1), & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  }
  if (exp->Kind == kOP_EXP) {
# line 660 "Inquiry.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 662 "Inquiry.puma"
   if (! ((TreeRank (exp->OP_EXP.OPND1) == 1))) goto yyL4;
  {
# line 663 "Inquiry.puma"
   GetExpSlice (exp->OP_EXP.OPND1, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL4:;

# line 666 "Inquiry.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 668 "Inquiry.puma"
   if (! ((TreeRank (exp->OP_EXP.OPND2) == 1))) goto yyL5;
  {
# line 669 "Inquiry.puma"
   GetExpSlice (exp->OP_EXP.OPND2, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL5:;

  }
  if (exp->Kind == kOP1_EXP) {
# line 672 "Inquiry.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 674 "Inquiry.puma"
   GetExpSlice (exp->OP1_EXP.OPND, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
# line 677 "Inquiry.puma"
   * yyP2 = false;
   * yyP1 = exp;
   return;

;
}

static void TranslateDotProduct
# if defined __STDC__ | defined __cplusplus
(register tTree p, register tTree params)
# else
(p, params)
 register tTree p;
 register tTree params;
# endif
{
  if (p->Kind == kPROC_OBJ) {
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 690 "Inquiry.puma"
 {
  tTree exp;
  type_rec rt;
  {
# line 692 "Inquiry.puma"

# line 694 "Inquiry.puma"

# line 696 "Inquiry.puma"
 exp = ParamToExp (params->BTP_LIST.Elem);
     GetExpType (exp, &rt);

     if (rt.type_kind == kBOOLEAN_TYPE)
        p->PROC_OBJ.Ident = MakeIdent ("ANY", 3);
       else 
        p->PROC_OBJ.Ident = MakeIdent ("SUM", 3);

     SetIntrinsicObj  (p);   

     

     if (rt.type_kind == kCOMPLEX_TYPE)
        exp = MakeConjgExp (params->BTP_LIST.Elem);

     if (rt.type_kind == kBOOLEAN_TYPE)
        exp  = mOP_EXP (mOP_AND(), exp, ParamToExp (params->BTP_LIST.Next->BTP_LIST.Elem));
      else
        exp  = mOP_EXP (mOP_TIMES(), exp, ParamToExp (params->BTP_LIST.Next->BTP_LIST.Elem));

     params->BTP_LIST.Elem = ExpToVarParam (exp);
     params->BTP_LIST.Next = mBTP_LIST (mNO_PARAM(kDUMMY_TYPE), 
              mBTP_LIST (mNO_PARAM(kDUMMY_TYPE), mBTP_EMPTY()));
   
  }
   return;
 }

  }
  }
  }
;
}

static tTree ParamToExp
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
# line 730 "Inquiry.puma"
   return param->VAR_PARAM.V->ADDR.E;

  }
# line 734 "Inquiry.puma"
   return mVAR_EXP (param->VAR_PARAM.V);

  }
# line 738 "Inquiry.puma"
  {
# line 739 "Inquiry.puma"
   failure_protocol (MODULE, "DOT_PRODUCT: ParamToExp", param);
  }
   return NoTree;

}

static tTree MakeConjgExp
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
# line 751 "Inquiry.puma"
 {
  tIdent name;
  tTree p;
  tTree params;
  {
# line 753 "Inquiry.puma"

# line 754 "Inquiry.puma"

# line 755 "Inquiry.puma"

# line 757 "Inquiry.puma"
 name = MakeIdent ("CONJG", 5);
     p = mPROC_OBJ (name);
     SetIntrinsicObj (p);   

     params = mBTP_LIST (param, mBTP_EMPTY ());
     p      = mFUNC_CALL_EXP (p, params);
   
  }
  {
   return p;
  }
 }

}

static void SetIntrinsicObj
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
  if (p->Kind == kPROC_OBJ) {
# line 770 "Inquiry.puma"
  {
# line 772 "Inquiry.puma"
   p->PROC_OBJ.Object = GetIntrinsicObject (p->PROC_OBJ.Ident);
  }
   return;

  }
;
}

static tTree MakeHuge
# if defined __STDC__ | defined __cplusplus
(register int kind, register int size)
# else
(kind, size)
 register int kind;
 register int size;
# endif
{
# line 781 "Inquiry.puma"

char val[100];

# line 785 "Inquiry.puma"
  {
# line 787 "Inquiry.puma"
   if (! ((kind == kINTEGER_TYPE))) goto yyL1;
  {
# line 788 "Inquiry.puma"
   if (! ((size == 4))) goto yyL1;
  }
  }
   return mCONST_EXP (mINT_CONSTANT (2147483647));
yyL1:;

# line 792 "Inquiry.puma"
  {
# line 794 "Inquiry.puma"
   if (! ((kind == kREAL_TYPE))) goto yyL2;
  {
# line 796 "Inquiry.puma"
   real_huge (val, size);
  }
  }
   return mCONST_EXP (mREAL_CONSTANT (PutString (val, strlen (val)), size));
yyL2:;

 yyAbort ("MakeHuge");
}

static tTree MakeTiny
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
# line 805 "Inquiry.puma"

char val[100];

# line 809 "Inquiry.puma"
  {
# line 811 "Inquiry.puma"
   real_tiny (val, size);
  }
   return mCONST_EXP (mREAL_CONSTANT (PutString (val, strlen (val)), size));

}

static tTree MakeEpsilon
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
# line 821 "Inquiry.puma"

char val[100];

# line 825 "Inquiry.puma"
  {
# line 827 "Inquiry.puma"
   real_epsilon (val, size);
  }
   return mCONST_EXP (mREAL_CONSTANT (PutString (val, strlen (val)), size));

}

static tTree MakeGlobalBounds
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kARRAY_EXP) {
# line 846 "Inquiry.puma"
  {
# line 848 "Inquiry.puma"
 exp->ARRAY_EXP.ELEMENTS = MakeGlobalBounds (exp->ARRAY_EXP.ELEMENTS); 
  }
   return exp;

  }
  if (exp->Kind == kBTE_LIST) {
# line 853 "Inquiry.puma"
  {
# line 855 "Inquiry.puma"
 exp->BTE_LIST.Elem = MakeGlobalBounds (exp->BTE_LIST.Elem); 
# line 856 "Inquiry.puma"
 exp->BTE_LIST.Next = MakeGlobalBounds (exp->BTE_LIST.Next); 
  }
   return exp;

  }
  if (exp->Kind == kBTE_EMPTY) {
# line 861 "Inquiry.puma"
   return exp;

  }
  if (exp->Kind == kOP_EXP) {
# line 866 "Inquiry.puma"
  {
# line 868 "Inquiry.puma"
 exp->OP_EXP.OPND1 = MakeGlobalBounds (exp->OP_EXP.OPND1); 
# line 869 "Inquiry.puma"
 exp->OP_EXP.OPND2 = MakeGlobalBounds (exp->OP_EXP.OPND2); 
  }
   return exp;

  }
  if (exp->Kind == kCONST_EXP) {
# line 874 "Inquiry.puma"
   return exp;

  }
  if (exp->Kind == kBOUND_EXP) {
# line 879 "Inquiry.puma"
   return mBOUND_EXP (exp->BOUND_EXP.VAR, exp->BOUND_EXP.dim, exp->BOUND_EXP.kind, 2);

  }
# line 886 "Inquiry.puma"
  {
# line 887 "Inquiry.puma"
   failure_protocol (MODULE, "MakeGlobalBounds", exp);
  }
   return exp;

}

void BeginInquiry ()
{
}

void CloseInquiry ()
{
}
