# include "InitAllocate.h"
# include "yyInitAllocate.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 38 "InitAllocate.puma"


# define MODULE "InitAllocate"

# define DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "DefTable.h"

# include "Transform.h"    /* AppendDECLS */
# include "Expressions.h"  /* MakeConstant */
# include "FArguments.h"   /* IsPointerDummy */
# include "Types.h"

# include "Shapes.h"      
# include "MakeLoops.h"
# include "Nesting.h"
# include "Objects.h"
# include "Distributions.h"

# include "protocol.h"

# include "Temporary.h"

static tTree NewInitStatements;
static tTree NewExitStatements;

static bool IsMain;          /* indicates a main unit */



static void yyExit () { Exit (1); }

void (* InitAllocate_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module InitAllocate, routine %s failed\n", yyFunction);
 InitAllocate_Exit ();
}

void InitAllocate ARGS((tTree t, tTree unit));
static void InsertNewStatements ARGS((tTree body, tTree unit));
static void FindTheAllocates ARGS((tTree decls));
static void ConsiderArray ARGS((tTree t, tDefinitions Obj));
static void ConsiderDerivedType ARGS((tDefinitions var, tTree base_type));
static void ConsiderDerivedTypeComponents ARGS((tDefinitions t));
static void MakeDspStatements ARGS((int line, tIdent name, tTree indexes, int kind));
static void MakeAllocStatements ARGS((int line, tIdent name, tTree indexes));
static tTree CreateDspStmt ARGS((int line, tIdent name, tTree indexes, int kind));
static tTree FreeDspStmt ARGS((int line, tIdent name, int kind));
static tTree MakeAllocate ARGS((int line, tIdent name, tTree indexes));
static tTree MakeExpList ARGS((tTree t, tIdent name, int pos));
static tTree MakeDeallocate ARGS((int line, tIdent name));
static void CheckAllocate ARGS((tDefinitions obj, bool * doit, bool * alloc, int * kind));
static bool InheritDescriptor ARGS((tDefinitions obj, int kind));
static void UpdateStatements ARGS((tTree stmt_list, tDefinitions var));
static tTree UpdateStat ARGS((tTree stmt, tDefinitions var));
static void UpdateParams ARGS((tTree t, tTree var));
static void GetVarShape ARGS((tDefinitions var, struct_shape * yyP2, tTree * yyP1));
static tTree MakeRecord ARGS((tTree var, tTree component));

void InitAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree unit)
# else
(t, unit)
 register tTree t;
 register tTree unit;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 92 "InitAllocate.puma"
  {
# line 94 "InitAllocate.puma"
   IsMain = IsMainUnit (unit);
# line 96 "InitAllocate.puma"
   TemporaryInit (t);
# line 98 "InitAllocate.puma"
   NewInitStatements = NoTree;
# line 99 "InitAllocate.puma"
   NewExitStatements = mACF_EMPTY ();
# line 101 "InitAllocate.puma"
   FindTheAllocates (t->BODY_NODE.DECLS);
# line 103 "InitAllocate.puma"
 

      tree_protocol ("new inits : \n", NewInitStatements);
      tree_protocol ("new exits : \n", NewExitStatements);

    
# line 110 "InitAllocate.puma"
   InsertNewStatements (t, unit);
# line 112 "InitAllocate.puma"
   TemporaryDone (t);
  }
   return;

  }
# line 115 "InitAllocate.puma"
  {
# line 117 "InitAllocate.puma"
   failure_protocol (MODULE, "InitAllocate", t);
  }
   return;

;
}

static void InsertNewStatements
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree unit)
# else
(body, unit)
 register tTree body;
 register tTree unit;
# endif
{
  if (unit->Kind == kBLOCK_DATA_DECL) {
# line 128 "InitAllocate.puma"
   return;

  }
  if (body->Kind == kBODY_NODE) {
  if (unit->Kind == kMODULE_DECL) {
# line 131 "InitAllocate.puma"
  {
# line 135 "InitAllocate.puma"
 body->BODY_NODE.STATS = CombineACF (NewInitStatements, body->BODY_NODE.STATS); 
  }
   return;

  }
# line 138 "InitAllocate.puma"
  {
# line 140 "InitAllocate.puma"
 body->BODY_NODE.STATS = CombineACF (body->BODY_NODE.STATS, NewExitStatements);
     body->BODY_NODE.STATS = CombineACF (NewInitStatements, body->BODY_NODE.STATS);

   
  }
   return;

  }
;
}

static void FindTheAllocates
# if defined __STDC__ | defined __cplusplus
(register tTree decls)
# else
(decls)
 register tTree decls;
# endif
{
  if (decls->Kind == kDECL_LIST) {
# line 154 "InitAllocate.puma"
  {
# line 156 "InitAllocate.puma"
   FindTheAllocates (decls->DECL_LIST.Elem);
# line 157 "InitAllocate.puma"
   FindTheAllocates (decls->DECL_LIST.Next);
  }
   return;

  }
  if (decls->Kind == kDECL_EMPTY) {
# line 160 "InitAllocate.puma"
   return;

  }
  if (decls->Kind == kVAR_DECL) {
  if (decls->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 163 "InitAllocate.puma"
  {
# line 165 "InitAllocate.puma"
   ConsiderArray (decls, GetLocalObject (decls->VAR_DECL.Ident));
# line 166 "InitAllocate.puma"
   ConsiderDerivedType (GetLocalObject (decls->VAR_DECL.Ident), GetBaseType (decls->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE));
  }
   return;

  }
# line 169 "InitAllocate.puma"
  {
# line 171 "InitAllocate.puma"
   ConsiderDerivedType (GetLocalObject (decls->VAR_DECL.Ident), GetBaseType (decls->VAR_DECL.VAL));
  }
   return;

  }
  if (decls->Kind == kTEMPLATE_DECL) {
# line 174 "InitAllocate.puma"
  {
# line 176 "InitAllocate.puma"
   ConsiderArray (decls, GetLocalObject (decls->TEMPLATE_DECL.Ident));
  }
   return;

  }
  if (decls->Kind == kPROCESSORS_DECL) {
# line 179 "InitAllocate.puma"
  {
# line 181 "InitAllocate.puma"
   ConsiderArray (decls, GetLocalObject (decls->PROCESSORS_DECL.Ident));
  }
   return;

  }
  if (decls->Kind == kRAGGED_DECL) {
# line 184 "InitAllocate.puma"
  {
# line 186 "InitAllocate.puma"
   ConsiderArray (decls, GetLocalObject (decls->RAGGED_DECL.Ident));
  }
   return;

  }
# line 189 "InitAllocate.puma"
   return;

;
}

static void ConsiderArray
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions Obj)
# else
(t, Obj)
 register tTree t;
 register tDefinitions Obj;
# endif
{
# line 206 "InitAllocate.puma"
  {
# line 207 "InitAllocate.puma"
   if (! ((Obj == NoObject))) goto yyL1;
  {
# line 208 "InitAllocate.puma"
   failure_protocol (MODULE, "ConsiderArray: no object", t);
  }
  }
   return;
yyL1:;

  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 211 "InitAllocate.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 213 "InitAllocate.puma"
   CheckAllocate (Obj, & yyV1, & yyV2, & yyV3);
# line 215 "InitAllocate.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 217 "InitAllocate.puma"
   MakeDspStatements (t->VAR_DECL.Line, t->VAR_DECL.Ident, t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES, yyV3);
# line 219 "InitAllocate.puma"
   if (! ((yyV2))) goto yyL2;
  {
# line 221 "InitAllocate.puma"
   MakeAllocStatements (t->VAR_DECL.Line, t->VAR_DECL.Ident, t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
  }
  }
  }
   return;
 }
yyL2:;

  }
  }
  if (t->Kind == kTEMPLATE_DECL) {
# line 224 "InitAllocate.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 226 "InitAllocate.puma"
   CheckAllocate (Obj, & yyV1, & yyV2, & yyV3);
# line 228 "InitAllocate.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 230 "InitAllocate.puma"
   MakeDspStatements (t->TEMPLATE_DECL.Line, t->TEMPLATE_DECL.Ident, t->TEMPLATE_DECL.DIMENSIONS, yyV3);
  }
  }
   return;
 }
yyL3:;

  }
  if (t->Kind == kPROCESSORS_DECL) {
# line 235 "InitAllocate.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 237 "InitAllocate.puma"
   CheckAllocate (Obj, & yyV1, & yyV2, & yyV3);
# line 239 "InitAllocate.puma"
   if (! ((yyV1))) goto yyL4;
  {
# line 241 "InitAllocate.puma"
   MakeDspStatements (t->PROCESSORS_DECL.Line, t->PROCESSORS_DECL.Ident, t->PROCESSORS_DECL.DIMENSIONS, yyV3);
  }
  }
   return;
 }
yyL4:;

  }
  if (t->Kind == kRAGGED_DECL) {
# line 246 "InitAllocate.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 248 "InitAllocate.puma"
   CheckAllocate (Obj, & yyV1, & yyV2, & yyV3);
# line 250 "InitAllocate.puma"
   if (! ((yyV1))) goto yyL5;
  {
# line 252 "InitAllocate.puma"
   MakeDspStatements (t->RAGGED_DECL.Line, t->RAGGED_DECL.Ident, t->RAGGED_DECL.DIMENSIONS, yyV3);
  }
  }
   return;
 }
yyL5:;

  }
# line 257 "InitAllocate.puma"
   return;

;
}

static void ConsiderDerivedType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var, register tTree base_type)
# else
(var, base_type)
 register tDefinitions var;
 register tTree base_type;
# endif
{
  if (base_type->Kind == kTYPE_ID) {
  if (base_type->TYPE_ID.ID->TYPE_OBJ.Object->Kind == kTypeObject) {
# line 275 "InitAllocate.puma"
 {
  tTree help_init;
  tTree help_exit;
  {
# line 277 "InitAllocate.puma"

# line 278 "InitAllocate.puma"

# line 280 "InitAllocate.puma"
 help_init = NewInitStatements;  NewInitStatements = NoTree;
     help_exit = NewExitStatements;  NewExitStatements = mACF_EMPTY();

     

     ConsiderDerivedTypeComponents (base_type->TYPE_ID.ID->TYPE_OBJ.Object);

     

     UpdateStatements (NewInitStatements, var);
     UpdateStatements (NewExitStatements, var);

     NewInitStatements = CombineACF (NewInitStatements, help_init);
     NewExitStatements = CombineACF (help_exit, NewExitStatements);

   
  }
   return;
 }

  }
# line 299 "InitAllocate.puma"
  {
# line 301 "InitAllocate.puma"
   failure_protocol (MODULE, "ConsiderDerivedType", base_type);
  }
   return;

  }
# line 304 "InitAllocate.puma"
   return;

;
}

static void ConsiderDerivedTypeComponents
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kTypeObject) {
  if (t->TypeObject.decl->Kind == kTYPE_DECL) {
  if (t->TypeObject.decl->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
# line 311 "InitAllocate.puma"
  {
# line 313 "InitAllocate.puma"
   NestOpenType (t->TypeObject.decl->TYPE_DECL.VAL);
# line 314 "InitAllocate.puma"
   FindTheAllocates (t->TypeObject.decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS);
# line 315 "InitAllocate.puma"
   NestCloseType (t->TypeObject.decl->TYPE_DECL.VAL);
  }
   return;

  }
  }
  }
# line 318 "InitAllocate.puma"
  {
# line 319 "InitAllocate.puma"
   failure_protocol (MODULE, "ConsiderDerivedTypeComponents", t->Object.decl);
  }
   return;

;
}

static void MakeDspStatements
# if defined __STDC__ | defined __cplusplus
(register int line, register tIdent name, register tTree indexes, register int kind)
# else
(line, name, indexes, kind)
 register int line;
 register tIdent name;
 register tTree indexes;
 register int kind;
# endif
{
# line 344 "InitAllocate.puma"
 {
  tTree stmt;
  {
# line 346 "InitAllocate.puma"

# line 348 "InitAllocate.puma"
   stmt = CreateDspStmt (line, name, indexes, kind);
# line 349 "InitAllocate.puma"
   NewInitStatements = CombineACF (NewInitStatements, mACF_LIST (stmt, NoTree));
# line 352 "InitAllocate.puma"
   stmt = FreeDspStmt (line, name, kind);
# line 353 "InitAllocate.puma"
   NewExitStatements = CombineACF (stmt, NewExitStatements);
  }
   return;
 }

;
}

static void MakeAllocStatements
# if defined __STDC__ | defined __cplusplus
(register int line, register tIdent name, register tTree indexes)
# else
(line, name, indexes)
 register int line;
 register tIdent name;
 register tTree indexes;
# endif
{
# line 364 "InitAllocate.puma"
 {
  tTree stmt;
  {
# line 366 "InitAllocate.puma"

# line 368 "InitAllocate.puma"
   stmt = MakeAllocate (line, name, indexes);
# line 369 "InitAllocate.puma"
   NewInitStatements = CombineACF (NewInitStatements, mACF_LIST (stmt, NoTree));
# line 372 "InitAllocate.puma"
   stmt = MakeDeallocate (line, name);
# line 373 "InitAllocate.puma"
   NewExitStatements = CombineACF (stmt, NewExitStatements);
  }
   return;
 }

;
}

static tTree CreateDspStmt
# if defined __STDC__ | defined __cplusplus
(register int line, register tIdent name, register tTree indexes, register int kind)
# else
(line, name, indexes, kind)
 register int line;
 register tIdent name;
 register tTree indexes;
 register int kind;
# endif
{
# line 387 "InitAllocate.puma"
 {
  tTree t;
  {
# line 389 "InitAllocate.puma"
   if (! ((InheritDescriptor (GetLocalObject (name), kind)))) goto yyL1;
  {
# line 391 "InitAllocate.puma"

# line 393 "InitAllocate.puma"
 t  = mVAR_OBJ (0, name);
      SetVarObject (t);
      t = mUSED_VAR (t);
      t = mACF_BASIC (mINHERIT_DSP_STMT (t, indexes, kind, safety));
      LineACFNode (t, line);
    
  }
  }
  {
   return t;
  }
 }
yyL1:;

# line 403 "InitAllocate.puma"
 {
  tTree t;
  {
# line 405 "InitAllocate.puma"

# line 407 "InitAllocate.puma"
 t  = mVAR_OBJ (0, name);
      SetVarObject (t);
      t = mUSED_VAR (t);
      t = mACF_BASIC (mCREATE_DSP_STMT (t, indexes, kind));
      LineACFNode (t, line);
    
  }
  {
   return t;
  }
 }

}

static tTree FreeDspStmt
# if defined __STDC__ | defined __cplusplus
(register int line, register tIdent name, register int kind)
# else
(line, name, kind)
 register int line;
 register tIdent name;
 register int kind;
# endif
{
# line 428 "InitAllocate.puma"
  {
# line 430 "InitAllocate.puma"
   if (! ((InheritDescriptor (GetLocalObject (name), kind)))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 435 "InitAllocate.puma"
 {
  tTree t;
  {
# line 437 "InitAllocate.puma"

# line 439 "InitAllocate.puma"
 t = mVAR_OBJ (0, name);
     SetVarObject (t);
     t = mUSED_VAR (t);
     t = mACF_BASIC (mFREE_DSP_STMT (t, kind));
     LineACFNode (t, line);
   
  }
  {
   return t;
  }
 }

}

static tTree MakeAllocate
# if defined __STDC__ | defined __cplusplus
(register int line, register tIdent name, register tTree indexes)
# else
(line, name, indexes)
 register int line;
 register tIdent name;
 register tTree indexes;
# endif
{
# line 459 "InitAllocate.puma"
 {
  tTree t;
  {
# line 461 "InitAllocate.puma"

# line 463 "InitAllocate.puma"
 t  = mVAR_OBJ (0, name);
      SetVarObject (t);
      t = mINDEXED_VAR (mUSED_VAR (t), MakeExpList (indexes, name, 1));
      t = mBTP_LIST (mVAR_PARAM (t), mBTP_EMPTY());
      t = mACF_BASIC (mALLOCATE_STMT (t, mDUMMY_VAR()));
      LineACFNode (t, line);
    
  }
  {
   return t;
  }
 }

}

static tTree MakeExpList
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register int pos)
# else
(t, name, pos)
 register tTree t;
 register tIdent name;
 register int pos;
# endif
{
  if (t->Kind == kSHAPE_LIST) {
# line 475 "InitAllocate.puma"
   return mBTE_LIST (MakeExpList (t->SHAPE_LIST.Elem, name, pos), MakeExpList (t->SHAPE_LIST.Next, name, pos + 1));

  }
  if (t->Kind == kSHAPE_EMPTY) {
# line 481 "InitAllocate.puma"
   return mBTE_EMPTY ();

  }
  if (t->Kind == kEXPLICIT_SHAPE) {
# line 488 "InitAllocate.puma"
   return (mSLICE_EXP (CopyTree (t->EXPLICIT_SHAPE.LOWER), CopyTree (t->EXPLICIT_SHAPE.UPPER), mDUMMY_EXP ()));

  }
# line 493 "InitAllocate.puma"
  {
# line 495 "InitAllocate.puma"
   failure_protocol (MODULE, "MakeExpList", t);
  }
   return NoTree;

}

static tTree MakeDeallocate
# if defined __STDC__ | defined __cplusplus
(register int line, register tIdent name)
# else
(line, name)
 register int line;
 register tIdent name;
# endif
{
# line 509 "InitAllocate.puma"
 {
  tTree t;
  {
# line 511 "InitAllocate.puma"

# line 513 "InitAllocate.puma"
 t = mVAR_OBJ (0, name);
      SetVarObject (t);
      t = mUSED_VAR (t);
      t = mBTP_LIST (mVAR_PARAM (t), mBTP_EMPTY());
      t = mACF_BASIC (mDEALLOCATE_STMT (t, mDUMMY_VAR()));
      LineACFNode (t, line);
    
  }
  {
   return t;
  }
 }

}

static void CheckAllocate
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register bool * doit, register bool * alloc, register int * kind)
# else
(obj, doit, alloc, kind)
 register tDefinitions obj;
 register bool * doit;
 register bool * alloc;
 register int * kind;
# endif
{
  if (obj->Kind == kRaggedObject) {
# line 540 "InitAllocate.puma"
   * doit = true;
   * alloc = false;
   * kind = kALLOCATE_DSP;
   return;

  }
  if (obj->Kind == kVarObject) {
# line 543 "InitAllocate.puma"
  {
# line 545 "InitAllocate.puma"
   if (! ((obj->VarObject.tree))) goto yyL2;
  }
   * doit = true;
   * alloc = false;
   * kind = kALLOCATE_DSP;
   return;
yyL2:;

  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 554 "InitAllocate.puma"
  {
# line 555 "InitAllocate.puma"
   if (! ((obj->VarObject.Kind->VarLocal.dynamic == arr_automatic))) goto yyL3;
  }
   * doit = true;
   * alloc = true;
   * kind = kALLOCATE_DSP;
   return;
yyL3:;

# line 564 "InitAllocate.puma"
  {
# line 566 "InitAllocate.puma"
   if (! ((IsVarAllocatable (obj)))) goto yyL4;
  }
   * doit = true;
   * alloc = false;
   * kind = kALLOCATE_DSP;
   return;
yyL4:;

# line 575 "InitAllocate.puma"
  {
# line 577 "InitAllocate.puma"
   if (! ((obj->VarObject.Kind->VarLocal.dynamic == arr_fixed_size))) goto yyL5;
  {
# line 578 "InitAllocate.puma"
   if (! (((VarDistribution (obj) != 0) || IsDynamic (obj)))) goto yyL5;
  }
  }
   * doit = true;
   * alloc = true;
   * kind = kALLOCATE_DSP;
   return;
yyL5:;

# line 587 "InitAllocate.puma"
  {
# line 588 "InitAllocate.puma"
   if (! ((obj->VarObject.Kind->VarLocal.dynamic == arr_fixed_size))) goto yyL6;
  {
# line 589 "InitAllocate.puma"
   if (! ((VarDistribution (obj) == 2))) goto yyL6;
  }
  }
   * doit = true;
   * alloc = true;
   * kind = kALLOCATE_DSP;
   return;
yyL6:;

# line 598 "InitAllocate.puma"
  {
# line 599 "InitAllocate.puma"
   if (! ((obj->VarObject.Kind->VarLocal.dynamic == arr_fixed_size))) goto yyL7;
  }
   * doit = true;
   * alloc = false;
   * kind = kSTATIC_DSP;
   return;
yyL7:;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 611 "InitAllocate.puma"
  {
# line 613 "InitAllocate.puma"
   if (! (((obj->VarObject.Kind->VarDummy.dynamic == arr_fixed_size) || (obj->VarObject.Kind->VarDummy.dynamic == arr_automatic)))) goto yyL8;
  {
# line 615 "InitAllocate.puma"
   if (! ((! IsPointerDummy (obj)))) goto yyL8;
  }
  }
   * doit = true;
   * alloc = false;
   * kind = kDUMMY_DSP;
   return;
yyL8:;

# line 618 "InitAllocate.puma"
  {
# line 620 "InitAllocate.puma"
   if (! (((obj->VarObject.Kind->VarDummy.dynamic == arr_fixed_size) || (obj->VarObject.Kind->VarDummy.dynamic == arr_automatic)))) goto yyL9;
  }
   * doit = true;
   * alloc = false;
   * kind = kSTATIC_DSP;
   return;
yyL9:;

# line 629 "InitAllocate.puma"
  {
# line 631 "InitAllocate.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL10;
  {
# line 632 "InitAllocate.puma"
   if (! (((obj->VarObject.Kind->VarDummy.dynamic == arr_allocatable) || (obj->VarObject.Kind->VarDummy.dynamic == arr_assumed_shape)))) goto yyL10;
  }
  }
   * doit = true;
   * alloc = false;
   * kind = kLOCAL_DSP;
   return;
yyL10:;

# line 635 "InitAllocate.puma"
  {
# line 636 "InitAllocate.puma"
   if (! (((obj->VarObject.Kind->VarDummy.dynamic == arr_allocatable) || (obj->VarObject.Kind->VarDummy.dynamic == arr_assumed_shape)))) goto yyL11;
  }
   * doit = true;
   * alloc = false;
   * kind = kASSUMED_DSP;
   return;
yyL11:;

  }
  if (obj->VarObject.Kind->Kind == kVarCommon) {
# line 653 "InitAllocate.puma"
  {
# line 654 "InitAllocate.puma"
   if (! ((VarDistribution (obj) == 1))) goto yyL12;
  {
# line 655 "InitAllocate.puma"
   if (! ((IsMain))) goto yyL12;
  }
  }
   * doit = true;
   * alloc = true;
   * kind = kALLOCATE_DSP;
   return;
yyL12:;

# line 658 "InitAllocate.puma"
  {
# line 659 "InitAllocate.puma"
   if (! ((VarDistribution (obj) == 2))) goto yyL13;
  {
# line 660 "InitAllocate.puma"
   if (! ((IsMain))) goto yyL13;
  }
  }
   * doit = true;
   * alloc = true;
   * kind = kALLOCATE_DSP;
   return;
yyL13:;

# line 663 "InitAllocate.puma"
  {
# line 664 "InitAllocate.puma"
   if (! ((VarDistribution (obj) == 1))) goto yyL14;
  }
   * doit = true;
   * alloc = false;
   * kind = kDUMMY_DSP;
   return;
yyL14:;

# line 667 "InitAllocate.puma"
  {
# line 668 "InitAllocate.puma"
   if (! ((VarDistribution (obj) == 2))) goto yyL15;
  }
   * doit = true;
   * alloc = false;
   * kind = kDUMMY_DSP;
   return;
yyL15:;

# line 671 "InitAllocate.puma"
   * doit = true;
   * alloc = false;
   * kind = kSTATIC_DSP;
   return;

  }
  }
  if (obj->Kind == kTemplateObject) {
# line 680 "InitAllocate.puma"
  {
# line 682 "InitAllocate.puma"
   if (! ((VarDistribution (obj) == 0))) goto yyL17;
  }
   * doit = true;
   * alloc = false;
   * kind = kTEMPLATE_DSP;
   return;
yyL17:;

# line 685 "InitAllocate.puma"
  {
# line 687 "InitAllocate.puma"
   if (! ((! IsVarAllocatable (obj)))) goto yyL18;
  }
   * doit = true;
   * alloc = false;
   * kind = kTEMPLATE_DSP;
   return;
yyL18:;

  }
  if (obj->Kind == kTopologyObject) {
# line 690 "InitAllocate.puma"
   * doit = true;
   * alloc = false;
   * kind = kTOPOLOGY_DSP;
   return;

  }
# line 693 "InitAllocate.puma"
   * doit = false;
   * alloc = false;
   * kind = kALLOCATE_DSP;
   return;

;
}

static bool InheritDescriptor
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int kind)
# else
(obj, kind)
 register tDefinitions obj;
 register int kind;
# endif
{
# line 708 "InitAllocate.puma"
  {
# line 710 "InitAllocate.puma"
   if (! ((safety == 0))) goto yyL1;
  {
# line 711 "InitAllocate.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 714 "InitAllocate.puma"
  {
# line 716 "InitAllocate.puma"
   if (! ((safety == 0))) goto yyL2;
  {
# line 717 "InitAllocate.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return true;
yyL2:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Kind == kRangeDistribution) {
# line 728 "InitAllocate.puma"
   return true;

  }
  }
  return false;
}

static void UpdateStatements
# if defined __STDC__ | defined __cplusplus
(register tTree stmt_list, register tDefinitions var)
# else
(stmt_list, var)
 register tTree stmt_list;
 register tDefinitions var;
# endif
{
# line 739 "InitAllocate.puma"
  {
# line 740 "InitAllocate.puma"
   if (! ((stmt_list == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (stmt_list->Kind == kACF_LIST) {
# line 743 "InitAllocate.puma"
  {
# line 745 "InitAllocate.puma"
 stmt_list->ACF_LIST.Elem = UpdateStat (stmt_list->ACF_LIST.Elem, var); 
# line 746 "InitAllocate.puma"
   UpdateStatements (stmt_list->ACF_LIST.Next, var);
  }
   return;

  }
;
}

static tTree UpdateStat
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tDefinitions var)
# else
(stmt, var)
 register tTree stmt;
 register tDefinitions var;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
# line 751 "InitAllocate.puma"
 {
  struct_shape yyV1;
  tTree yyV2;
  {
# line 753 "InitAllocate.puma"
   GetVarShape (var, & yyV1, & yyV2);
# line 754 "InitAllocate.puma"
   UpdateParams (stmt->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS, yyV2);
  }
  {
   return MakeOuterLoops (stmt->ACF_BASIC.Line, & yyV1, stmt, GEN_DO_SERIAL);
  }
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
# line 759 "InitAllocate.puma"
 {
  struct_shape yyV1;
  tTree yyV2;
  {
# line 761 "InitAllocate.puma"
   GetVarShape (var, & yyV1, & yyV2);
# line 762 "InitAllocate.puma"
   UpdateParams (stmt->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS, yyV2);
  }
  {
   return MakeOuterLoops (stmt->ACF_BASIC.Line, & yyV1, stmt, GEN_DO_SERIAL);
  }
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCREATE_DSP_STMT) {
# line 767 "InitAllocate.puma"
 {
  struct_shape yyV1;
  tTree yyV2;
  {
# line 769 "InitAllocate.puma"
   GetVarShape (var, & yyV1, & yyV2);
# line 770 "InitAllocate.puma"
 stmt->ACF_BASIC.BASIC_STMT->CREATE_DSP_STMT.VAR = MakeRecord (yyV2, stmt->ACF_BASIC.BASIC_STMT->CREATE_DSP_STMT.VAR); 
  }
  {
   return MakeOuterLoops (stmt->ACF_BASIC.Line, & yyV1, stmt, GEN_DO_SERIAL);
  }
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kFREE_DSP_STMT) {
# line 775 "InitAllocate.puma"
 {
  struct_shape yyV1;
  tTree yyV2;
  {
# line 777 "InitAllocate.puma"
   GetVarShape (var, & yyV1, & yyV2);
# line 778 "InitAllocate.puma"
 stmt->ACF_BASIC.BASIC_STMT->FREE_DSP_STMT.VAR = MakeRecord (yyV2, stmt->ACF_BASIC.BASIC_STMT->FREE_DSP_STMT.VAR); 
  }
  {
   return MakeOuterLoops (stmt->ACF_BASIC.Line, & yyV1, stmt, GEN_DO_SERIAL);
  }
 }

  }
  }
# line 783 "InitAllocate.puma"
  {
# line 785 "InitAllocate.puma"
   failure_protocol (MODULE, "UpdateStat", stmt);
  }
   return NoTree;

}

static void UpdateParams
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree var)
# else
(t, var)
 register tTree t;
 register tTree var;
# endif
{
  if (t->Kind == kBTP_LIST) {
# line 791 "InitAllocate.puma"
  {
# line 793 "InitAllocate.puma"
   UpdateParams (t->BTP_LIST.Elem, var);
# line 794 "InitAllocate.puma"
   UpdateParams (t->BTP_LIST.Next, var);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 797 "InitAllocate.puma"
   return;

  }
  if (t->Kind == kVAR_PARAM) {
# line 800 "InitAllocate.puma"
  {
# line 802 "InitAllocate.puma"
 t->VAR_PARAM.V = MakeRecord (var, t->VAR_PARAM.V); 
  }
   return;

  }
;
}

static void GetVarShape
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var, struct_shape * yyP2, register tTree * yyP1)
# else
(var, yyP2, yyP1)
 register tDefinitions var;
 struct_shape * yyP2;
 register tTree * yyP1;
# endif
{
# line 807 "InitAllocate.puma"
 {
  struct_shape shp;
  tTree var_tree;
  {
# line 809 "InitAllocate.puma"

# line 810 "InitAllocate.puma"

# line 812 "InitAllocate.puma"
 var_tree = mVAR_OBJ (0, var->Object.Ident);
      var_tree->VAR_OBJ.Object = var;
      var_tree = mUSED_VAR (var_tree);
      var_tree = MakeFullShape (var_tree);
      GetActualShape (var_tree, &shp);
      SetActualShape (var_tree, &shp);
    
  }
   * yyP2 = shp;
   * yyP1 = var_tree;
   return;
 }

;
}

static tTree MakeRecord
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree component)
# else
(var, component)
 register tTree var;
 register tTree component;
# endif
{
  if (component->Kind == kUSED_VAR) {
# line 832 "InitAllocate.puma"
 {
  tTree new;
  {
# line 834 "InitAllocate.puma"

# line 836 "InitAllocate.puma"
 new = mREC_COMP (component->USED_VAR.VARNAME->VAR_OBJ.Ident);
     new->REC_COMP.Object = component->USED_VAR.VARNAME->VAR_OBJ.Object;
     new = mSELECTED_VAR (var, new);
   
  }
  {
   return new;
  }
 }

  }
  if (component->Kind == kINDEXED_VAR) {
# line 844 "InitAllocate.puma"
  {
# line 846 "InitAllocate.puma"
 component->INDEXED_VAR.IND_VAR = MakeRecord (var, component->INDEXED_VAR.IND_VAR); 
  }
   return component;

  }
  if (component->Kind == kSELECTED_VAR) {
# line 851 "InitAllocate.puma"
  {
# line 853 "InitAllocate.puma"
 component->SELECTED_VAR.SELEC_VAR = MakeRecord (var, component->SELECTED_VAR.SELEC_VAR); 
  }
   return component;

  }
# line 858 "InitAllocate.puma"
  {
# line 860 "InitAllocate.puma"
   failure_protocol (MODULE, "MakeRecord", component);
  }
   return NoTree;

}

void BeginInitAllocate ()
{
}

void CloseInitAllocate ()
{
}
