# include "ImplMapping.h"
# include "yyImplMapping.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 26 "ImplMapping.puma"


# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"
# include "SemMap.h"

# include "DefTable.h"

# include "Traverse.h"
# include "Objects.h"       /* IsTypeObj      */
# include "Types.h"         /* GetBaseType    */

# include "DerivedTypes.h"  /* IsExplicitlyMappedType */

# define MODULE "ImplMapping"



static void yyExit () { Exit (1); }

void (* ImplMapping_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ImplMapping, routine %s failed\n", yyFunction);
 ImplMapping_Exit ();
}

void ImplMapping ARGS((tTree t));
static bool Stop_IMPL_MAPPING ARGS((tTree t));
static tTree Do_IMPL_MAPPING ARGS((tTree t));
static void UpdateDecl ARGS((tTree old, tTree new));
static bool HasImplicitMapping ARGS((tDefinitions t));
static void GetImplicitMapping ARGS((tDefinitions v, int * yyP1));
static tTree MakeDistributeDirective ARGS((int kind, int rank));
static bool IsCharacterArray ARGS((tTree t));
static bool IsMappedTypeArray ARGS((tTree t));
static void SetDistributeDirective ARGS((tDefinitions obj, int kind, tTree decl));
static tDefinitions MakeDeclDistribution ARGS((tDefinitions d, tTree decl));
static void MakeDistributions ARGS((tDefinitions t));
static void CheckDefaultObjects ARGS((tDefinitions t));
static void EvalDistributedObjects ARGS((tDefinitions t));
static void EvalAlignedObjects ARGS((tDefinitions t));
static void VerifyDistribution ARGS((tDefinitions v));

void ImplMapping
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
# line 56 "ImplMapping.puma"
 {
  tTree result;
  {
# line 58 "ImplMapping.puma"

# line 60 "ImplMapping.puma"
   open_protocol ("adaptor.dist");
# line 62 "ImplMapping.puma"
 t->COMP_UNIT.COMP_ELEMENTS = ReplaceAST (t->COMP_UNIT.COMP_ELEMENTS, Stop_IMPL_MAPPING, 
                                              Do_IMPL_MAPPING);

     

     t->COMP_UNIT.USED_ELEMENTS   = ReplaceAST (t->COMP_UNIT.USED_ELEMENTS  , Stop_IMPL_MAPPING, 
                                              Do_IMPL_MAPPING);

   
# line 72 "ImplMapping.puma"
   close_protocol ();
  }
   return;
 }

  }
;
}

static bool Stop_IMPL_MAPPING
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LIST) {
# line 87 "ImplMapping.puma"
   return true;

  }
  if (t->Kind == kCOMMON_DECL) {
# line 90 "ImplMapping.puma"
   return true;

  }
  return false;
}

static tTree Do_IMPL_MAPPING
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 106 "ImplMapping.puma"
  {
# line 108 "ImplMapping.puma"
   MakeDistributions (GetCurrentScope ());
  }
   return t;

  }
  if (t->Kind == kRECORD_TYPE) {
# line 112 "ImplMapping.puma"
 {
  tDefinitions tobj;
  {
# line 116 "ImplMapping.puma"

# line 118 "ImplMapping.puma"
   tobj = GetLocalObject (t->RECORD_TYPE.Name);
# line 120 "ImplMapping.puma"
   MakeDistributions (tobj->TypeObject.Components);
  }
  {
   return t;
  }
 }

  }
  if (t->Kind == kVAR_DECL) {
# line 124 "ImplMapping.puma"
 {
  tDefinitions obj;
  int yyV1;
  tTree decl;
  {
# line 126 "ImplMapping.puma"

# line 128 "ImplMapping.puma"
   obj = GetLocalObject (t->VAR_DECL.Ident);
# line 130 "ImplMapping.puma"
   if (! ((HasImplicitMapping (obj)))) goto yyL3;
  {
# line 132 "ImplMapping.puma"
   GetImplicitMapping (obj, & yyV1);
# line 134 "ImplMapping.puma"

# line 136 "ImplMapping.puma"
   decl = MakeDistributeDirective (yyV1, VarRank (obj));
# line 138 "ImplMapping.puma"
   UpdateDecl (t, decl);
# line 140 "ImplMapping.puma"
   SetDistributeDirective (obj, yyV1, decl);
# line 142 "ImplMapping.puma"
   if (! ((decl != NoTree))) goto yyL3;
  {
# line 144 "ImplMapping.puma"
   tree_protocol ("new distribute directive : ", decl);
  }
  }
  }
  {
   return mDECL_LIST (t, mDECL_LIST (decl, NoTree));
  }
 }
yyL3:;

  }
  if (t->Kind == kTEMPLATE_DECL) {
# line 149 "ImplMapping.puma"
 {
  tDefinitions obj;
  int yyV1;
  tTree decl;
  {
# line 151 "ImplMapping.puma"

# line 153 "ImplMapping.puma"
   obj = GetLocalObject (t->TEMPLATE_DECL.Ident);
# line 155 "ImplMapping.puma"
   if (! ((HasImplicitMapping (obj)))) goto yyL4;
  {
# line 157 "ImplMapping.puma"
   GetImplicitMapping (obj, & yyV1);
# line 159 "ImplMapping.puma"

# line 161 "ImplMapping.puma"
   decl = MakeDistributeDirective (yyV1, VarRank (obj));
# line 163 "ImplMapping.puma"
   UpdateDecl (t, decl);
# line 165 "ImplMapping.puma"
   SetDistributeDirective (obj, yyV1, decl);
# line 167 "ImplMapping.puma"
   if (! ((decl != NoTree))) goto yyL4;
  {
# line 169 "ImplMapping.puma"
   tree_protocol ("new distribute directive : ", decl);
  }
  }
  }
  {
   return mDECL_LIST (t, mDECL_LIST (decl, NoTree));
  }
 }
yyL4:;

  }
# line 174 "ImplMapping.puma"
   return t;

}

static void UpdateDecl
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree new)
# else
(old, new)
 register tTree old;
 register tTree new;
# endif
{
# line 188 "ImplMapping.puma"
  {
# line 190 "ImplMapping.puma"
   if (! ((new == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (old->Kind == kVAR_DECL) {
  if (Tree_IsType (new, kDECL_NODE)) {
# line 193 "ImplMapping.puma"
  {
# line 195 "ImplMapping.puma"
 new->DECL_NODE.Ident = old->VAR_DECL.Ident; new->DECL_NODE.Line = old->VAR_DECL.Line; 
  }
   return;

  }
  }
  if (old->Kind == kTEMPLATE_DECL) {
  if (Tree_IsType (new, kDECL_NODE)) {
# line 198 "ImplMapping.puma"
  {
# line 200 "ImplMapping.puma"
 new->DECL_NODE.Ident = old->TEMPLATE_DECL.Ident; new->DECL_NODE.Line = old->TEMPLATE_DECL.Line; 
  }
   return;

  }
  }
;
}

static bool HasImplicitMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Kind == kDefaultDistribution) {
# line 211 "ImplMapping.puma"
   return true;

  }
  }
  if (t->Kind == kTemplateObject) {
  if (t->TemplateObject.Dist->Kind == kDefaultDistribution) {
# line 214 "ImplMapping.puma"
   return true;

  }
  }
  return false;
}

static void GetImplicitMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v, register int * yyP1)
# else
(v, yyP1)
 register tDefinitions v;
 register int * yyP1;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarCommon) {
# line 235 "ImplMapping.puma"
 {
  tDefinitions Obj;
  {
# line 237 "ImplMapping.puma"

# line 238 "ImplMapping.puma"
   Obj = GetDeclEntry (v->VarObject.Kind->VarCommon.Block, GetCommonEntries ());
# line 239 "ImplMapping.puma"
   if (! ((Obj->CommonObject.sequence == 1))) goto yyL1;
  }
   * yyP1 = 0;
   return;
 }
yyL1:;

  }
# line 246 "ImplMapping.puma"
  {
# line 248 "ImplMapping.puma"
   if (! ((IsVarAssumedSize (v)))) goto yyL2;
  }
   * yyP1 = 0;
   return;
yyL2:;

# line 255 "ImplMapping.puma"
  {
# line 257 "ImplMapping.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL3;
  }
   * yyP1 = 0;
   return;
yyL3:;

# line 264 "ImplMapping.puma"
  {
# line 266 "ImplMapping.puma"
   if (! ((ddefault_kind == DDEFAULT_REPLICATED))) goto yyL4;
  }
   * yyP1 = 0;
   return;
yyL4:;

  if (v->VarObject.Dist->Kind == kDefaultDistribution) {
# line 273 "ImplMapping.puma"
  {
# line 275 "ImplMapping.puma"
   if (! ((v->VarObject.Dist->DefaultDistribution.inherited))) goto yyL5;
  }
   * yyP1 = 2;
   return;
yyL5:;

  }
# line 282 "ImplMapping.puma"
  {
# line 284 "ImplMapping.puma"
   if (! ((IsCharacterArray (v->VarObject.decl)))) goto yyL6;
  }
   * yyP1 = 0;
   return;
yyL6:;

# line 292 "ImplMapping.puma"
  {
# line 294 "ImplMapping.puma"
   if (! ((IsMappedTypeArray (v->VarObject.decl)))) goto yyL7;
  }
   * yyP1 = 0;
   return;
yyL7:;

# line 301 "ImplMapping.puma"
  {
# line 303 "ImplMapping.puma"
   if (! ((VarRank (v) == 0))) goto yyL8;
  }
   * yyP1 = 0;
   return;
yyL8:;

# line 310 "ImplMapping.puma"
  {
# line 312 "ImplMapping.puma"
   if (! ((IsTypeObj (v->VarObject.in)))) goto yyL9;
  }
   * yyP1 = 0;
   return;
yyL9:;

# line 319 "ImplMapping.puma"
   * yyP1 = 1;
   return;

  }
  if (v->Kind == kTemplateObject) {
# line 326 "ImplMapping.puma"
  {
# line 328 "ImplMapping.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL11;
  }
   * yyP1 = 0;
   return;
yyL11:;

# line 335 "ImplMapping.puma"
  {
# line 337 "ImplMapping.puma"
   if (! ((ddefault_kind == DDEFAULT_REPLICATED))) goto yyL12;
  }
   * yyP1 = 0;
   return;
yyL12:;

# line 340 "ImplMapping.puma"
   * yyP1 = 1;
   return;

  }
# line 343 "ImplMapping.puma"
   * yyP1 = 0;
   return;

;
}

static tTree MakeDistributeDirective
# if defined __STDC__ | defined __cplusplus
(register int kind, register int rank)
# else
(kind, rank)
 register int kind;
 register int rank;
# endif
{
# line 359 "ImplMapping.puma"

int i;
tTree decl;

# line 364 "ImplMapping.puma"
  {
# line 366 "ImplMapping.puma"
   if (! ((rank == 0))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 371 "ImplMapping.puma"
  {
# line 373 "ImplMapping.puma"
   if (! ((kind == 0))) goto yyL2;
  {
# line 375 "ImplMapping.puma"
 

     decl = mDIST_EMPTY ();
     for (i=0; i<rank; i++)
        decl = mDIST_LIST (mSERIAL_DISTRIBUTION (), decl);

     decl = mNODE_DISTRIBUTION (0, decl);

     decl = mDISTRIBUTE_DECL (DefaultId(), 0, decl,
                              mDEFAULT_PROCESSOR_ARRAY());
   
  }
  }
   return decl;
yyL2:;

# line 390 "ImplMapping.puma"
  {
# line 392 "ImplMapping.puma"
   if (! ((kind == 1))) goto yyL3;
  {
# line 394 "ImplMapping.puma"
 

     decl = mDIST_EMPTY ();
     for (i=0; i<rank; i++)
        decl = mDIST_LIST (mBLOCK_DISTRIBUTION (mDUMMY_EXP()), decl);

     decl = mNODE_DISTRIBUTION (0, decl);

     decl = mDISTRIBUTE_DECL (DefaultId(), 0, decl,
                              mDEFAULT_PROCESSOR_ARRAY());
   
  }
  }
   return decl;
yyL3:;

# line 409 "ImplMapping.puma"
  {
# line 411 "ImplMapping.puma"
   if (! ((kind == 2))) goto yyL4;
  {
# line 413 "ImplMapping.puma"
 

     decl = mDIST_EMPTY ();
     for (i=0; i<rank; i++)
        decl = mDIST_LIST (mANY_DIM_DISTRIBUTION (), decl);

     decl = mNODE_DISTRIBUTION (0, decl);

     decl = mRANGE_LIST (decl, mRANGE_EMPTY ());

     decl = mRANGE_DECL (DefaultId(), 0, decl);

   
  }
  }
   return decl;
yyL4:;

# line 430 "ImplMapping.puma"
  {
# line 432 "ImplMapping.puma"
   failure_protocol (MODULE, "MakeDistributeDirective", NoTree);
  }
   return NoTree;

}

static bool IsCharacterArray
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
# line 444 "ImplMapping.puma"
  {
# line 445 "ImplMapping.puma"
   if (! ((IsCharacterArray (GetBaseType (t->VAR_DECL.VAL))))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
# line 448 "ImplMapping.puma"
  {
# line 449 "ImplMapping.puma"
   if (! ((IsCharacterArray (GetBaseType (t->VAR_PARAM_DECL.VAL))))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kSTRING_TYPE) {
# line 452 "ImplMapping.puma"
   return true;

  }
  return false;
}

static bool IsMappedTypeArray
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
# line 463 "ImplMapping.puma"
  {
# line 465 "ImplMapping.puma"
   if (! ((IsExplicitlyMappedType (GetBaseType (t->VAR_DECL.VAL))))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
# line 468 "ImplMapping.puma"
  {
# line 470 "ImplMapping.puma"
   if (! ((IsExplicitlyMappedType (GetBaseType (t->VAR_PARAM_DECL.VAL))))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

static void SetDistributeDirective
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int kind, register tTree decl)
# else
(obj, kind, decl)
 register tDefinitions obj;
 register int kind;
 register tTree decl;
# endif
{
# line 485 "ImplMapping.puma"
  {
# line 487 "ImplMapping.puma"
   if (! ((decl == NoTree))) goto yyL1;
  {
# line 488 "ImplMapping.puma"
   MakeObjReplicated (obj);
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
# line 493 "ImplMapping.puma"
  {
# line 495 "ImplMapping.puma"
 obj->VarObject.Dist = MakeDeclDistribution (obj->VarObject.Dist, decl); 
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
# line 498 "ImplMapping.puma"
  {
# line 500 "ImplMapping.puma"
 obj->TemplateObject.Dist = MakeDeclDistribution (obj->TemplateObject.Dist, decl); 
  }
   return;

  }
# line 503 "ImplMapping.puma"
  {
# line 505 "ImplMapping.puma"
   obj_error_protocol ("internal distribute directive for illegal obj", obj);
# line 506 "ImplMapping.puma"
   failure_protocol (MODULE, "SetDistributeDirective", decl);
  }
   return;

;
}

static tDefinitions MakeDeclDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tTree decl)
# else
(d, decl)
 register tDefinitions d;
 register tTree decl;
# endif
{
# line 517 "ImplMapping.puma"
   return mDeclDistribution (d->Distribution.dynamic, d->Distribution.shared, d->Distribution.inherited, decl);

}

static void MakeDistributions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
# line 538 "ImplMapping.puma"
  {
# line 540 "ImplMapping.puma"
   CheckDefaultObjects (t);
# line 541 "ImplMapping.puma"
   EvalDistributedObjects (t);
# line 542 "ImplMapping.puma"
   EvalAlignedObjects (t);
  }
   return;

;
}

static void CheckDefaultObjects
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kENTRY_LIST) {
# line 553 "ImplMapping.puma"
  {
# line 554 "ImplMapping.puma"
   VerifyDistribution (t->ENTRY_LIST.Elem);
# line 555 "ImplMapping.puma"
   CheckDefaultObjects (t->ENTRY_LIST.Next);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 558 "ImplMapping.puma"
   return;

  }
;
}

static void EvalDistributedObjects
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kENTRY_LIST) {
# line 569 "ImplMapping.puma"
  {
# line 570 "ImplMapping.puma"
   EvalDistributedObjects (t->ENTRY_LIST.Elem);
# line 571 "ImplMapping.puma"
   EvalDistributedObjects (t->ENTRY_LIST.Next);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 574 "ImplMapping.puma"
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Kind == kDeclDistribution) {
  if (t->VarObject.Dist->DeclDistribution.decl->Kind == kDISTRIBUTE_DECL) {
# line 577 "ImplMapping.puma"
  {
# line 578 "ImplMapping.puma"
   EvalObjDistribution (t);
# line 579 "ImplMapping.puma"
   obj_protocol ("evaluated distribution : ", t);
  }
   return;

  }
  if (t->VarObject.Dist->DeclDistribution.decl->Kind == kRANGE_DECL) {
# line 587 "ImplMapping.puma"
  {
# line 588 "ImplMapping.puma"
   EvalObjDistribution (t);
# line 589 "ImplMapping.puma"
   obj_protocol ("evaluated range : ", t);
  }
   return;

  }
  }
  }
  if (t->Kind == kTemplateObject) {
  if (t->TemplateObject.Dist->Kind == kDeclDistribution) {
  if (t->TemplateObject.Dist->DeclDistribution.decl->Kind == kDISTRIBUTE_DECL) {
# line 582 "ImplMapping.puma"
  {
# line 583 "ImplMapping.puma"
   EvalObjDistribution (t);
# line 584 "ImplMapping.puma"
   obj_protocol ("evaluated distribution : ", t);
  }
   return;

  }
  }
  }
;
}

static void EvalAlignedObjects
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kENTRY_LIST) {
# line 600 "ImplMapping.puma"
  {
# line 601 "ImplMapping.puma"
   EvalAlignedObjects (t->ENTRY_LIST.Elem);
# line 602 "ImplMapping.puma"
   EvalAlignedObjects (t->ENTRY_LIST.Next);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 605 "ImplMapping.puma"
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Kind == kDeclDistribution) {
  if (t->VarObject.Dist->DeclDistribution.decl->Kind == kALIGN_DECL) {
# line 608 "ImplMapping.puma"
  {
# line 609 "ImplMapping.puma"
   EvalObjDistribution (t);
# line 610 "ImplMapping.puma"
   obj_protocol ("evaluated alignment : ", t);
  }
   return;

  }
  }
  }
;
}

static void VerifyDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Dist->Kind == kDefaultDistribution) {
# line 623 "ImplMapping.puma"
  {
# line 625 "ImplMapping.puma"
   MakeObjReplicated (v);
  }
   return;

  }
  }
# line 628 "ImplMapping.puma"
   return;

;
}

void BeginImplMapping ()
{
}

void CloseImplMapping ()
{
}
