# include "ImplDefs.h"
# include "yyImplDefs.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 37 "ImplDefs.puma"


# undef DEBUG

# include <stdlib.h>

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Transform.h"      /* MakeRealType, ... */
# include "Types.h"          /* IsDummyType       */
# include "Objects.h"        /* IsVarResult       */

# define MODULE "ImplDefs"

/*********************************************************************
*                                                                    * 
*    I M P L I C I T   T Y P E S   T A B L E                         * 
*                                                                    * 
*********************************************************************/

static tTree dummy_type = NoTree;
static tTree int_type   = NoTree;
static tTree real_type  = NoTree;    /* predefined types */

static int table_stack_top = -1;

typedef struct

    { tTree impl_table [26];   /* A - Z */

      bool global_save_attribute;
      bool global_public_attribute;
      bool global_private_attribute;
      bool global_sequence_attribute;
      bool global_nosequence_attribute;

    } ImplicitTable;

tTree impl_table [26];   /* A - Z */

bool global_save_attribute;
bool global_public_attribute;
bool global_private_attribute;
bool global_sequence_attribute;
bool global_nosequence_attribute;

#define MAX_TABLES 128
#define NO_TABLE ((ImplicitTable *) 0)

static ImplicitTable *table_stack [MAX_TABLES];

static void init_stack ()

{ int i;

  for (i=0; i<MAX_TABLES; i++) table_stack [i] = NO_TABLE;

} /* init_stack */

static void make_stack_entry (pos) 

int pos;

{ if (pos >= MAX_TABLES)

     failure_protocol (MODULE, "too high SUBPROGRAM nesting", NoTree);

  if (table_stack [pos] != NO_TABLE) return;  /* entry exists, reuse it */

  table_stack [pos] = (ImplicitTable *) malloc (sizeof(ImplicitTable));

} /* make_stack_entry */

        /*************************************************
        *  void push_context (ImplicitTable *table)      * 
        *************************************************/

static void push_context (table)

ImplicitTable *table;

{ int i;

  for (i=0; i<26; i++) 
      table->impl_table [i] = impl_table[i];

  table->global_save_attribute       = global_save_attribute;
  table->global_public_attribute     = global_public_attribute;
  table->global_private_attribute    = global_private_attribute;
  table->global_sequence_attribute   = global_sequence_attribute;
  table->global_nosequence_attribute = global_nosequence_attribute;

} /* push_context */

        /*************************************************
        *  void pop_context (ImplicitTable *table)       * 
        *************************************************/

static void pop_context (table)

ImplicitTable *table;

{ int i;

  for (i=0; i<26; i++) 
      impl_table [i] = table->impl_table[i];

  global_save_attribute       = table->global_save_attribute;
  global_public_attribute     = table->global_public_attribute;
  global_private_attribute    = table->global_private_attribute;
  global_sequence_attribute   = table->global_sequence_attribute;
  global_nosequence_attribute = table->global_nosequence_attribute;

} /* push_context */

static int check_impl_char (c)
char c;
{ return ( (c >= 'A') && (c <= 'Z') ); }




static void yyExit () { Exit (1); }

void (* ImplDefs_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ImplDefs, routine %s failed\n", yyFunction);
 ImplDefs_Exit ();
}

void InitImplicitTable ARGS(());
void PushImplicitTable ARGS(());
void PopImplicitTable ARGS(());
void CharSetImplicitTable ARGS((char first, char last, tTree val));
void SetImplicitTable ARGS((tIdent first, tIdent last, tTree val));
static tTree GetImplicitTable ARGS((tIdent name));
void CheckImplicitDecls ARGS((tDefinitions t));
static tTree ReplaceDummyType ARGS((tTree t, tTree newval));

void InitImplicitTable
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 172 "ImplDefs.puma"
  {
# line 173 "ImplDefs.puma"
 int i;

    real_type  = MakeRealType (default_real_size);
    int_type   = MakeIntegerType (default_int_size);
    dummy_type = mDUMMY_TYPE ();

    table_stack_top = 0;

    init_stack ();
  
  }
   return;

;
}

void PushImplicitTable
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 195 "ImplDefs.puma"
  {
# line 197 "ImplDefs.puma"
 if (table_stack_top >= 0)

       { make_stack_entry (table_stack_top);

         

         push_context (table_stack[table_stack_top]);

       }

    table_stack_top++;

#ifdef DEBUG
    printf ("PushImplicitTable, stack_top = %d\n", table_stack_top);
#endif

    

    CharSetImplicitTable ('A','H', real_type);
    CharSetImplicitTable ('I','N', int_type);
    CharSetImplicitTable ('O','Z', real_type);
    global_save_attribute       = false;
    global_public_attribute     = false;
    global_private_attribute    = false;
    global_sequence_attribute   = false;
    global_nosequence_attribute = false;
  
  }
   return;

;
}

void PopImplicitTable
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 228 "ImplDefs.puma"
  {
# line 230 "ImplDefs.puma"
 if (table_stack_top > 0)

       pop_context (table_stack[table_stack_top-1]);
       
    table_stack_top--;

#ifdef DEBUG
    printf ("PopImplicitTable, stack_top = %d\n", table_stack_top);
#endif

  
  }
   return;

;
}

void CharSetImplicitTable
# if defined __STDC__ | defined __cplusplus
(register char first, register char last, register tTree val)
# else
(first, last, val)
 register char first;
 register char last;
 register tTree val;
# endif
{
# line 253 "ImplDefs.puma"
  {
# line 255 "ImplDefs.puma"
 char i;
    char m[100];
    if (!check_impl_char (first) || !check_impl_char (last))
      { sprintf (m, "Implicit Declaration: %c - %c not valid\\n",
                    first, last);
        simple_error_protocol (m);
      }
    for (i=first;i<=last;i++)
        impl_table[i-'A'] = val;
  
  }
   return;

;
}

void SetImplicitTable
# if defined __STDC__ | defined __cplusplus
(register tIdent first, register tIdent last, register tTree val)
# else
(first, last, val)
 register tIdent first;
 register tIdent last;
 register tTree val;
# endif
{
# line 277 "ImplDefs.puma"
  {
# line 279 "ImplDefs.puma"
 char cf, cl, name[100];
    GetString (first, name);
    cf = name[0];
    GetString (last, name);
    cl = name[0];
    CharSetImplicitTable (cf, cl, val);
  
  }
   return;

;
}

static tTree GetImplicitTable
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 290 "ImplDefs.puma"
 {
  tTree t;
  {
# line 292 "ImplDefs.puma"

# line 294 "ImplDefs.puma"
 char c, word[100];
     GetString (name, word);
     c = word[0];
     if (check_impl_char (c))
        t = impl_table[c-'A'];
      else
        t = dummy_type;
   
  }
  {
   return t;
  }
 }

}

void CheckImplicitDecls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
# line 313 "ImplDefs.puma"
 
char string[50], msg[100]; 

  if (t->Kind == kENTRY_LIST) {
# line 317 "ImplDefs.puma"
  {
# line 319 "ImplDefs.puma"
   CheckImplicitDecls (t->ENTRY_LIST.Elem);
# line 320 "ImplDefs.puma"
   CheckImplicitDecls (t->ENTRY_LIST.Next);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 323 "ImplDefs.puma"
   return;

  }
  if (Definitions_IsType (t, kObject)) {
# line 326 "ImplDefs.puma"
  {
# line 328 "ImplDefs.puma"
   if (! ((t->Object.private == Default))) goto yyL3;
  {
# line 330 "ImplDefs.puma"
 if (global_private_attribute)
         t->Object.private = Private; 
      else if (global_public_attribute)
         t->Object.private = Public;
   
# line 336 "ImplDefs.puma"
   goto yyL3;
  }
  }
yyL3:;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.decl->Kind == kVAR_DECL) {
# line 339 "ImplDefs.puma"
  {
# line 341 "ImplDefs.puma"
   if (! ((IsDummyType (t->VarObject.decl->VAR_DECL.VAL)))) goto yyL4;
  {
# line 343 "ImplDefs.puma"
   set_protocol_stmt (t->VarObject.decl);
# line 344 "ImplDefs.puma"
   stmt_protocol ("implicitly defined variable");
# line 346 "ImplDefs.puma"
 t->VarObject.decl->VAR_DECL.VAL = ReplaceDummyType (t->VarObject.decl->VAR_DECL.VAL, GetImplicitTable (t->VarObject.Ident));
     GetString (t->VarObject.Ident, string);
     sprintf (msg, "var %s is implicitly defined, type = ",string);
     tree_warning_protocol (msg, t->VarObject.decl->VAR_DECL.VAL);
   
  }
  }
   return;
yyL4:;

  }
  if (t->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 353 "ImplDefs.puma"
  {
# line 355 "ImplDefs.puma"
   if (! ((IsDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL)))) goto yyL5;
  {
# line 356 "ImplDefs.puma"
   if (! ((IsVarResult (t)))) goto yyL5;
  {
# line 358 "ImplDefs.puma"
 t->VarObject.decl->VAR_PARAM_DECL.VAL = ReplaceDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL, GetImplicitTable (t->VarObject.Ident));
     GetString (t->VarObject.Ident, string);
     sprintf (msg, "function result %s is implicitly defined, type = ",string);
     tree_warning_protocol (msg, t->VarObject.decl->VAR_PARAM_DECL.VAL);
   
  }
  }
  }
   return;
yyL5:;

# line 365 "ImplDefs.puma"
  {
# line 367 "ImplDefs.puma"
   if (! ((IsDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL)))) goto yyL6;
  {
# line 369 "ImplDefs.puma"
 t->VarObject.decl->VAR_PARAM_DECL.VAL = ReplaceDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL, GetImplicitTable (t->VarObject.Ident));
     GetString (t->VarObject.Ident, string);
     sprintf (msg, "dummy %s is implicitly defined, type = ",string);
     tree_warning_protocol (msg, t->VarObject.decl->VAR_PARAM_DECL.VAL);
   
  }
  }
   return;
yyL6:;

  }
  }
  if (t->Kind == kFuncObject) {
  if (t->FuncObject.decl->Kind == kFUNC_DECL) {
# line 376 "ImplDefs.puma"
  {
# line 379 "ImplDefs.puma"
   if (! ((t->FuncObject.decl->FUNC_DECL.RESULT_ID == DefaultId ()))) goto yyL7;
  {
# line 380 "ImplDefs.puma"
   if (! ((IsDummyType (t->FuncObject.decl->FUNC_DECL.RESULT_TYPE)))) goto yyL7;
  {
# line 382 "ImplDefs.puma"
 t->FuncObject.decl->FUNC_DECL.RESULT_TYPE = ReplaceDummyType (t->FuncObject.decl->FUNC_DECL.RESULT_TYPE, GetImplicitTable (t->FuncObject.Ident));
     GetString (t->FuncObject.Ident, string);
     sprintf (msg, "function %s is implicitly defined, type = ",
                    string);
     tree_warning_protocol (msg, t->FuncObject.decl->FUNC_DECL.RESULT_TYPE);
   
  }
  }
  }
   return;
yyL7:;

# line 390 "ImplDefs.puma"
   return;

  }
  if (t->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 395 "ImplDefs.puma"
  {
# line 397 "ImplDefs.puma"
   if (! ((IsDummyType (t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE)))) goto yyL9;
  {
# line 399 "ImplDefs.puma"
 t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE = ReplaceDummyType (t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE, GetImplicitTable (t->FuncObject.Ident));
     GetString (t->FuncObject.Ident, string);
     sprintf (msg, "statement function %s is implicitly defined, type = ",
                    string);
     tree_warning_protocol (msg, t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE);
   
  }
  }
   return;
yyL9:;

  }
  }
;
}

static tTree ReplaceDummyType
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree newval)
# else
(t, newval)
 register tTree t;
 register tTree newval;
# endif
{
  if (t->Kind == kDUMMY_TYPE) {
# line 415 "ImplDefs.puma"
   return newval;

  }
  if (t->Kind == kALIGN_TYPE) {
  if (newval->Kind == kDUMMY_TYPE) {
# line 420 "ImplDefs.puma"
   return int_type;

  }
# line 425 "ImplDefs.puma"
   return newval;

  }
  if (t->Kind == kARRAY_TYPE) {
  if (t->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
# line 430 "ImplDefs.puma"
   return mARRAY_TYPE (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, newval);

  }
  }
# line 434 "ImplDefs.puma"
   return t;

}

void BeginImplDefs ()
{
}

void CloseImplDefs ()
{
}
