# include "HomeTemps.h"
# include "yyHomeTemps.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 41 "HomeTemps.puma"


# undef DEBUG

# include "Idents.h"
# include "protocol.h"

# include "Descriptor.h"      /* PrintableDescriptorVar  */
# include "DefTable.h"        /* GetDefaultTopology      */

# include "TreeOps.h"
# include "Expressions.h"     /* ResolveExpression       */
# include "Nesting.h"         /* GetLoopId, ...          */
# include "ParNest.h"         /* GetParNestACF, ...      */
# include "MoveControl.h"

# define MODULE "HomeTemps"



static void yyExit () { Exit (1); }

void (* HomeTemps_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module HomeTemps, routine %s failed\n", yyFunction);
 HomeTemps_Exit ();
}

void HomeTempVar ARGS((tTree var, pvar home_vard, pvar new_var));
void FullHomeTemp ARGS((tTree exp, pvar home_vard, pvar new_var));
static void FindHomeTempVar ARGS((tTree var, pvar home_vard, pvar new_var));
static void ReplicateForHome ARGS((pvar vard));
static void MakeNestDescriptor ARGS((tTree var, pvar vard));
static void AddNewDimension ARGS((tTree var, pvar vard, tTree loop));
static void AlignToHome ARGS((pvar new_var, pvar home_var));
static void GetSourceAlignment ARGS((tTree index, pvar home_var, int * yyP3, int * yyP2, int * yyP1));

void HomeTempVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, pvar new_var)
# else
(var, home_vard, new_var)
 register tTree var;
 pvar home_vard;
 pvar new_var;
# endif
{
# line 81 "HomeTemps.puma"
  {
# line 83 "HomeTemps.puma"
   FindHomeTempVar (var, home_vard, new_var);
# line 85 "HomeTemps.puma"
   SetExpType (var, new_var);
# line 87 "HomeTemps.puma"
 

    if (!VDIsOwner (home_vard, new_var))

      { error_protocol ("illegal new variable created (not local)");
        tree_protocol ("var = ", var);
        tree_protocol ("home = ", PrintableDescriptorVar (home_vard));
        tree_protocol ("new_var = ", PrintableDescriptorVar (new_var));
      }

    if (!VDIsSingleOwner (home_vard, new_var))

      { 
      }


    if (new_var->actual_rank != TreeRank (var))

      { 

        error_protocol ("illegal new variable created (rank problem)");
        tree_protocol ("var = ", var);
        tree_protocol ("home = ", PrintableDescriptorVar (home_vard));
        tree_protocol ("new_var = ", PrintableDescriptorVar (new_var));
      }
  
  }
   return;

;
}

void FullHomeTemp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home_vard, pvar new_var)
# else
(exp, home_vard, new_var)
 register tTree exp;
 pvar home_vard;
 pvar new_var;
# endif
{
# line 136 "HomeTemps.puma"
  {
# line 138 "HomeTemps.puma"
   MakeNestDescriptor (exp, new_var);
# line 140 "HomeTemps.puma"
   AlignToHome (new_var, home_vard);
# line 142 "HomeTemps.puma"
   SetExpType (exp, new_var);
  }
   return;

;
}

static void FindHomeTempVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, pvar new_var)
# else
(var, home_vard, new_var)
 register tTree var;
 pvar home_vard;
 pvar new_var;
# endif
{
# line 154 "HomeTemps.puma"
 {
  bool found;
  {
# line 156 "HomeTemps.puma"
   if (! ((home_vard -> topology_rank == 0))) goto yyL1;
  {
# line 158 "HomeTemps.puma"

# line 160 "HomeTemps.puma"
   GetVarDescriptor (var, & found, new_var);
# line 161 "HomeTemps.puma"
   if (! ((found))) goto yyL1;
  {
# line 163 "HomeTemps.puma"
 new_var->topology_rank = 0;
    new_var->topology_obj  = GetDefaultTopology (0);

    if (!found)
       error_protocol ("no descriptor for replicated variable");
  
  }
  }
  }
   return;
 }
yyL1:;

# line 170 "HomeTemps.puma"
 {
  bool found;
  {
# line 172 "HomeTemps.puma"
   if (! ((home_vard -> topology_rank == - 1))) goto yyL2;
  {
# line 174 "HomeTemps.puma"

# line 176 "HomeTemps.puma"
   GetVarDescriptor (var, & found, new_var);
# line 177 "HomeTemps.puma"
   if (! ((found))) goto yyL2;
  {
# line 179 "HomeTemps.puma"
 new_var->topology_rank = -1;
    new_var->topology_obj  = GetDefaultTopology (-1);

    if (!found)
       error_protocol ("no descriptor for home variable");
  
  }
  }
  }
   return;
 }
yyL2:;

# line 187 "HomeTemps.puma"
  {
# line 189 "HomeTemps.puma"
   if (! ((TreeRank (var) == 0))) goto yyL3;
  {
# line 191 "HomeTemps.puma"
   MakeNestDescriptor (var, new_var);
# line 193 "HomeTemps.puma"
   AlignToHome (new_var, home_vard);
  }
  }
   return;
yyL3:;

# line 196 "HomeTemps.puma"
  {
# line 198 "HomeTemps.puma"
   if (! ((TreeRank (var) == 0))) goto yyL4;
  {
# line 200 "HomeTemps.puma"
 *new_var = *home_vard; 
# line 202 "HomeTemps.puma"
   ReplicateForHome (new_var);
  }
  }
   return;
yyL4:;

# line 205 "HomeTemps.puma"
  {
# line 207 "HomeTemps.puma"
 *new_var = *home_vard; 
  }
   return;

;
}

static void ReplicateForHome
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 218 "HomeTemps.puma"
  {
# line 220 "HomeTemps.puma"
 int idim;

    for (idim=0; idim<vard->formal_rank; idim++)

       { int is_range;
          tTree lb, ub;


         lb = vard->actual_shape[idim][0];
         ub = vard->actual_shape[idim][1];

         if (lb != ub) is_range = 1;
           else if (TreeRank (lb) == 0) is_range = 1;
           else is_range = 0;

         if (is_range)

           { 

           }
 
       }
  
  }
   return;

;
}

static void MakeNestDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar vard)
# else
(var, vard)
 register tTree var;
 pvar vard;
# endif
{
# line 262 "HomeTemps.puma"
  {
# line 264 "HomeTemps.puma"
 int i;

     MakeReplicatedDescriptor (vard);

     for (i=1; i<=GetParNestingDepth (); i++)

       AddNewDimension (var, vard, GetParNestACF (i));

   
  }
   return;

;
}

static void AddNewDimension
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar vard, register tTree loop)
# else
(var, vard, loop)
 register tTree var;
 pvar vard;
 register tTree loop;
# endif
{
# line 277 "HomeTemps.puma"
  {
# line 279 "HomeTemps.puma"
   if (! ((IsCountLoop (loop)))) goto yyL1;
  {
# line 283 "HomeTemps.puma"
   AddDescriptorDimension (vard, mVAR_EXP (GetLoopId (loop)), GetLoopSlice (loop), kSERIAL_DIM);
  }
  }
   return;
yyL1:;

;
}

static void AlignToHome
# if defined __STDC__ | defined __cplusplus
(pvar new_var, pvar home_var)
# else
(new_var, home_var)
 pvar new_var;
 pvar home_var;
# endif
{
# line 299 "HomeTemps.puma"
  {
# line 301 "HomeTemps.puma"
 int i;

#ifdef DEBUG
      printf ("align to home of new var descriptor\n");
      printf ("var descriptor is : \n");
      PrintVarDescriptor (new_var);
      printf ("home descriptor is : \n");
      PrintVarDescriptor (home_var);
#endif

      new_var->topology_obj  = home_var->topology_obj;
      new_var->topology_rank = home_var->topology_rank;
      new_var->template_obj  = home_var->template_obj;
      new_var->template_rank = home_var->template_rank;

      

      for (i=0; i<new_var->topology_rank; i++)

        { new_var->on_index_dim[i] = 0; 
          new_var->on_temp_dim[i]  = home_var->on_temp_dim[i];
          new_var->on_kind[i]      = home_var->on_kind[i];
          new_var->on_size[i]      = home_var->on_size[i];
          new_var->on_val[i]       = home_var->on_val[i];
          new_var->on_range[i][0]  = home_var->on_range[i][0];
          new_var->on_range[i][1]  = home_var->on_range[i][1];
        }

      

      for (i=0; i<new_var->formal_rank; i++)

      { int home_dim, home_mult, home_add;

        GetSourceAlignment (new_var->actual_shape[i][0], home_var,
                            &home_dim, &home_mult, &home_add);

#ifdef DEBUG
        printf ("index dim %d aligned to home, dim %d, mult = %d, add = %d\n",
                 i+1, home_dim, home_mult, home_add);
#endif

        if (home_dim > 0)

        { int kind;
          tTree size;
          int top_dim, temp_dim;
          int add, mult;

          kind     = home_var->distribution_kind [home_dim-1];
          size     = home_var->distribution_size [home_dim-1];
          top_dim  = home_var->topology_dim [home_dim-1];
          temp_dim = home_var->template_dim [home_dim-1];
          mult     = home_var->align_mult   [home_dim-1];
          add      = home_var->align_add    [home_dim-1];

          new_var->distribution_kind[i] = kind;
          new_var->distribution_size[i] = size;
          new_var->topology_dim     [i] = top_dim;
          new_var->template_dim     [i] = temp_dim;

          

          new_var->align_mult       [i] = home_mult * mult;
          new_var->align_add        [i] = mult * home_add + add;
 
          new_var->formal_shape [i][0] = home_var->formal_shape[home_dim-1][0];
          new_var->formal_shape [i][0] = home_var->formal_shape[home_dim-1][0];

          if (top_dim > 0)

           { new_var->on_index_dim [top_dim-1]    = i + 1;
             new_var->on_temp_dim  [top_dim-1]    = temp_dim;
             new_var->on_kind      [top_dim-1]    = kind;
             new_var->on_size      [top_dim-1]    = size;
             new_var->on_val       [top_dim-1]    = NoTree;
             new_var->on_range     [top_dim-1][0] = new_var->formal_shape[i][0];
             new_var->on_range     [top_dim-1][1] = new_var->formal_shape[i][1];
           }

        }  

      }

#ifdef DEBUG
    printf ("new var descriptor is : \n");
    PrintVarDescriptor (new_var);
#endif

    
  }
   return;

;
}

static void GetSourceAlignment
# if defined __STDC__ | defined __cplusplus
(register tTree index, pvar home_var, register int * yyP3, register int * yyP2, register int * yyP1)
# else
(index, home_var, yyP3, yyP2, yyP1)
 register tTree index;
 pvar home_var;
 register int * yyP3;
 register int * yyP2;
 register int * yyP1;
# endif
{
# line 399 "HomeTemps.puma"
 {
  int home_dim;
  int home_mult;
  int home_add;
  int i;
  {
# line 401 "HomeTemps.puma"

# line 402 "HomeTemps.puma"

# line 403 "HomeTemps.puma"

# line 405 "HomeTemps.puma"

# line 407 "HomeTemps.puma"
 home_dim = 0;
 
     for (i=0; i<home_var->formal_rank; i++)

       { bool  found;
         int   mult, add;
         tTree var;
 
         ResolveExpression (home_var->actual_shape[i][0],
                            &found, &mult, &add, &var);

         if (found && mult)

           { if (TreeVarName (var) == TreeVarName (index))

              { home_dim = i+1;
                home_mult = mult;
                home_add  = add;
              }

           }  

       }  

   
  }
   * yyP3 = home_dim;
   * yyP2 = home_mult;
   * yyP1 = home_add;
   return;
 }

;
}

void BeginHomeTemps ()
{
}

void CloseHomeTemps ()
{
}
