# include "HomeDescriptor.h"
# include "yyHomeDescriptor.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 47 "HomeDescriptor.puma"


# undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "DefTable.h"

# include "Expressions.h"        /* ResolveExpression */
# include "Nesting.h"            /* GetOuterLoop, ... */
# include "ParNest.h"            /* GetOuterLoop, ... */
# include "Extraction.h"
# include "MoveDescriptor.h"
# include "Loops.h"
# include "Rank.h"
# include "Distributions.h"
# include "TreeOps.h"
# include "Descriptor.h"

# define MODULE "HomeDescriptor"



static void yyExit () { Exit (1); }

void (* HomeDescriptor_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module HomeDescriptor, routine %s failed\n", yyFunction);
 HomeDescriptor_Exit ();
}

void MakeNoDescriptor ARGS((pvar vard));
void MakeReplicatedDescriptor ARGS((pvar vard));
void MakeHostDescriptor ARGS((pvar vard));
void MakeClauseDescriptor ARGS((tTree home_clause, pvar vard));
void MakeParLoopNestDescriptor ARGS((pvar vard));
static void AddParallelDimension ARGS((pvar vard, tTree loop));
bool IsNoDescriptor ARGS((pvar vard));
bool IsReplicatedDescriptor ARGS((pvar vard));
bool IsHostDescriptor ARGS((pvar vard));
bool IsProcDescriptor ARGS((pvar vard));
bool NoReplicationDescriptor ARGS((pvar vard));
bool IsFullLoopDescriptor ARGS((pvar vard));
bool IsParallelLoopDescriptor ARGS((pvar home, tTree loop));
bool IsParallelHomeDescriptor ARGS((pvar d1));
static bool DescriptorLinearDependency ARGS((pvar d, tTree loop));
static bool IsLinearDependent ARGS((tTree exp, tTree id));
static bool ResolveIsVariable ARGS((tTree var));
void UnionHomeDescriptor ARGS((pvar vard1, pvar vard2));
static void UnionTopDims ARGS((pvar vard1, pvar vard2, int top_dim));
void MakeSerialDescriptor ARGS((pvar home, bool * yyP1));
bool IsSerialDescriptor ARGS((pvar home));

void MakeNoDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 83 "HomeDescriptor.puma"
  {
# line 85 "HomeDescriptor.puma"
 vard->formal_rank    = -1;
     vard->actual_rank    = 0;
     vard->var_tree       = NoTree;
     vard->var_obj        = NoObject;
     vard->reach_info     = NoTree;
     vard->shared         = 0;
     vard->template_rank  = 0;
     vard->template_obj   = NoObject;
     vard->topology_obj   = NoObject;
     vard->topology_rank  = 0;
     vard->type_kind      = kDUMMY_TYPE;
     vard->type_size      = 0;
     vard->expanded       = false;
   
  }
   return;

;
}

void MakeReplicatedDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 111 "HomeDescriptor.puma"
  {
# line 113 "HomeDescriptor.puma"
 vard->formal_rank    = 0;
     vard->actual_rank    = 0;
     vard->var_tree       = NoTree;
     vard->var_obj        = NoObject;
     vard->shared         = 0;
     vard->topology_obj   = GetDefaultTopology (0);
     vard->topology_rank  = 0;
     vard->template_rank  = 0;
     vard->template_obj   = NoObject;
     vard->reach_info     = NoTree;
     vard->type_kind      = kDUMMY_TYPE;
     vard->type_size      = 0;
     vard->expanded       = false;
   
  }
   return;

;
}

void MakeHostDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 139 "HomeDescriptor.puma"
  {
# line 141 "HomeDescriptor.puma"
 vard->formal_rank    = 0;
     vard->actual_rank    = 0;
     vard->shared         = 0;
     vard->topology_obj   = GetDefaultTopology (-1);
     vard->topology_rank  = -1;
     vard->template_rank  = 0;
     vard->template_obj   = NoObject;
     vard->var_tree       = NoTree;
     vard->var_obj        = NoObject;
     vard->reach_info     = NoTree;
     vard->type_kind      = kDUMMY_TYPE;
     vard->type_size      = 0;
     vard->expanded       = false;
   
  }
   return;

;
}

void MakeClauseDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree home_clause, pvar vard)
# else
(home_clause, vard)
 register tTree home_clause;
 pvar vard;
# endif
{
  if (home_clause->Kind == kON_VAR_CLAUSE) {
# line 168 "HomeDescriptor.puma"
  {
# line 170 "HomeDescriptor.puma"
   SetVarDescriptor (home_clause->ON_VAR_CLAUSE.ON_VAR, vard);
  }
   return;

  }
  if (home_clause->Kind == kON_PROC_CLAUSE) {
# line 173 "HomeDescriptor.puma"
  {
# line 175 "HomeDescriptor.puma"
   SetProcDescriptor (home_clause->ON_PROC_CLAUSE.ON_PROC, vard);
  }
   return;

  }
  if (home_clause->Kind == kON_HOST_CLAUSE) {
# line 178 "HomeDescriptor.puma"
  {
# line 180 "HomeDescriptor.puma"
   MakeHostDescriptor (vard);
  }
   return;

  }
  if (home_clause->Kind == kON_ALL_CLAUSE) {
# line 183 "HomeDescriptor.puma"
  {
# line 185 "HomeDescriptor.puma"
   MakeReplicatedDescriptor (vard);
  }
   return;

  }
# line 188 "HomeDescriptor.puma"
  {
# line 190 "HomeDescriptor.puma"
   failure_protocol (MODULE, "MakeClauseDescriptor", home_clause);
  }
   return;

;
}

void MakeParLoopNestDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 213 "HomeDescriptor.puma"
  {
# line 215 "HomeDescriptor.puma"
   if (! ((OuterLoops () <= 0))) goto yyL1;
  {
# line 217 "HomeDescriptor.puma"
   MakeNoDescriptor (vard);
  }
  }
   return;
yyL1:;

# line 220 "HomeDescriptor.puma"
  {
# line 222 "HomeDescriptor.puma"
 int i;

     MakeReplicatedDescriptor (vard);

     for (i=1; i<=GetParNestingDepth (); i++)

       AddParallelDimension (vard, GetParNestACF (i));

   
  }
   return;

;
}

static void AddParallelDimension
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tTree loop)
# else
(vard, loop)
 pvar vard;
 register tTree loop;
# endif
{
# line 235 "HomeDescriptor.puma"
  {
# line 237 "HomeDescriptor.puma"
   if (! ((IsParallelLoop (loop)))) goto yyL1;
  {
# line 238 "HomeDescriptor.puma"
   if (! ((IsExtractableRange (GetLoopSlice (loop))))) goto yyL1;
  {
# line 240 "HomeDescriptor.puma"
   AddDescriptorDimension (vard, GetLoopId (loop), GetLoopSlice (loop), kBLOCK_DIM);
  }
  }
  }
   return;
yyL1:;

;
}

bool IsNoDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 257 "HomeDescriptor.puma"
  {
# line 258 "HomeDescriptor.puma"
   if (! ((vard -> formal_rank == - 1))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IsReplicatedDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 263 "HomeDescriptor.puma"
  {
# line 265 "HomeDescriptor.puma"
   if (! ((SameTopologyObject (vard -> topology_obj, GetDefaultTopology (0))))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IsHostDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 270 "HomeDescriptor.puma"
  {
# line 271 "HomeDescriptor.puma"
   if (! ((vard -> formal_rank == 0))) goto yyL1;
  {
# line 272 "HomeDescriptor.puma"
   if (! ((SameTopologyObject (vard -> topology_obj, GetDefaultTopology (- 1))))) goto yyL1;
  }
  }
   return true;
yyL1:;

  return false;
}

bool IsProcDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 277 "HomeDescriptor.puma"
  {
# line 278 "HomeDescriptor.puma"
   if (! ((vard -> topology_obj == vard -> template_obj))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool NoReplicationDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 291 "HomeDescriptor.puma"
  {
# line 293 "HomeDescriptor.puma"
   if (! ((IsReplicatedDescriptor (vard)))) goto yyL1;
  {
# line 294 "HomeDescriptor.puma"
   return false;
  }
  }
yyL1:;

# line 297 "HomeDescriptor.puma"
  {
# line 298 "HomeDescriptor.puma"
   if (! ((IsHostDescriptor (vard)))) goto yyL2;
  }
   return true;
yyL2:;

# line 301 "HomeDescriptor.puma"
  {
# line 302 "HomeDescriptor.puma"
   if (! ((vard -> topology_obj == NoObject))) goto yyL3;
  }
   return true;
yyL3:;

# line 305 "HomeDescriptor.puma"
 {
  bool no_replication;
  {
# line 307 "HomeDescriptor.puma"

# line 309 "HomeDescriptor.puma"
 int  i;

     no_replication = true;

     for (i=0; i < vard->topology_rank; i++)

       if (vard->on_val[i] == NoTree) no_replication = false;

   
# line 319 "HomeDescriptor.puma"
   if (! ((no_replication))) goto yyL4;
  }
   return true;
 }
yyL4:;

  return false;
}

bool IsFullLoopDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 327 "HomeDescriptor.puma"
 {
  bool okay;
  int dim;
  {
# line 329 "HomeDescriptor.puma"
   if (! ((vard -> var_tree == NoTree))) goto yyL1;
  {
# line 330 "HomeDescriptor.puma"
   if (! ((vard -> template_obj == NoObject))) goto yyL1;
  {
# line 332 "HomeDescriptor.puma"

# line 333 "HomeDescriptor.puma"

# line 335 "HomeDescriptor.puma"
 okay = true;

     for (dim = 1; dim <= vard->formal_rank; dim++)

        { if (vard->actual_shape[dim-1][0] != vard->formal_shape[dim-1][0])
             okay = false;
          if (vard->actual_shape[dim-1][1] != vard->formal_shape[dim-1][1])
             okay = false;
          if (vard->actual_shape[dim-1][2] != NoTree)
             okay = false;

        } 
   
# line 349 "HomeDescriptor.puma"
   if (! ((okay))) goto yyL1;
  }
  }
  }
   return true;
 }
yyL1:;

  return false;
}

bool IsParallelLoopDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar home, register tTree loop)
# else
(home, loop)
 pvar home;
 register tTree loop;
# endif
{
# line 369 "HomeDescriptor.puma"
  {
# line 371 "HomeDescriptor.puma"
   if (! ((DescriptorLinearDependency (home, loop)))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

bool IsParallelHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar d1)
# else
(d1)
 pvar d1;
# endif
{
# line 376 "HomeDescriptor.puma"
 {
  bool okay;
  int i;
  {
# line 378 "HomeDescriptor.puma"

# line 379 "HomeDescriptor.puma"

# line 381 "HomeDescriptor.puma"
 

#ifdef DEBUG
     printf ("check whether is home descriptor : \n");
     PrintVarDescriptor (d1);
#endif

     okay = true;
     for (i=1; i <= OuterLoops(); i++)
       okay = okay && DescriptorLinearDependency (d1, GetOuterLoop(i));

   
# line 394 "HomeDescriptor.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool DescriptorLinearDependency
# if defined __STDC__ | defined __cplusplus
(pvar d, register tTree loop)
# else
(d, loop)
 pvar d;
 register tTree loop;
# endif
{
# line 399 "HomeDescriptor.puma"
  {
# line 400 "HomeDescriptor.puma"
   if (! ((! IsParallelLoop (loop)))) goto yyL1;
  }
   return true;
yyL1:;

# line 403 "HomeDescriptor.puma"
 {
  bool okay;
  int i;
  tTree id;
  tTree index;
  {
# line 405 "HomeDescriptor.puma"

# line 406 "HomeDescriptor.puma"

# line 407 "HomeDescriptor.puma"

# line 408 "HomeDescriptor.puma"

# line 410 "HomeDescriptor.puma"
 okay = false;
     id   = GetLoopId (loop);

     for (i=0; i<d->formal_rank; i++)
       { index = d->actual_shape[i][0];
         okay = okay || (IsLinearDependent (index, id));
#ifdef DEBUG
         FileUnparse (stdout, index);
         printf (" is linear dependent (okay = %d) for ", okay);
         FileUnparse (stdout, id); printf ("\n");
#endif
       }
   
# line 423 "HomeDescriptor.puma"
   if (! ((okay))) goto yyL2;
  }
   return true;
 }
yyL2:;

  return false;
}

static bool IsLinearDependent
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id)
# else
(exp, id)
 register tTree exp;
 register tTree id;
# endif
{
# line 436 "HomeDescriptor.puma"
 {
  tTree var;
  int stride;
  int base;
  bool found;
  {
# line 438 "HomeDescriptor.puma"

# line 439 "HomeDescriptor.puma"

# line 440 "HomeDescriptor.puma"

# line 441 "HomeDescriptor.puma"

# line 443 "HomeDescriptor.puma"
   ResolveExpression (exp, & found, & stride, & base, & var);
# line 444 "HomeDescriptor.puma"
   if (! ((found))) goto yyL1;
  {
# line 445 "HomeDescriptor.puma"
   if (! ((stride != 0))) goto yyL1;
  {
# line 447 "HomeDescriptor.puma"
   if (! ((ResolveIsVariable (var)))) goto yyL1;
  {
# line 449 "HomeDescriptor.puma"
   if (! ((TreeVarName (var) == TreeVarName (id)))) goto yyL1;
  }
  }
  }
  }
   return true;
 }
yyL1:;

  return false;
}

static bool ResolveIsVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (Tree_IsType (var, kBT_VAR)) {
# line 454 "HomeDescriptor.puma"
   return true;

  }
  if (var->Kind == kVAR_EXP) {
# line 457 "HomeDescriptor.puma"
   return true;

  }
  if (var->Kind == kFUNC_CALL_EXP) {
# line 460 "HomeDescriptor.puma"
  {
# line 461 "HomeDescriptor.puma"
   return false;
  }

  }
  return false;
}

void UnionHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
# line 478 "HomeDescriptor.puma"
  {
# line 480 "HomeDescriptor.puma"
   if (! ((VDIsSubSet (vard2, vard1)))) goto yyL1;
  }
   return;
yyL1:;

# line 483 "HomeDescriptor.puma"
  {
# line 485 "HomeDescriptor.puma"
   if (! ((VDIsSubSet (vard1, vard2)))) goto yyL2;
  {
# line 487 "HomeDescriptor.puma"
 *vard1 = *vard2; 
  }
  }
   return;
yyL2:;

# line 498 "HomeDescriptor.puma"
 {
  int top_dim;
  {
# line 500 "HomeDescriptor.puma"

# line 502 "HomeDescriptor.puma"

#ifdef DEBUG
     printf ("Union of two homes\n");
     PrintVarDescriptor (vard1);
     PrintVarDescriptor (vard2);
#endif
   
# line 510 "HomeDescriptor.puma"
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL3;
  {
# line 512 "HomeDescriptor.puma"
   MakeTemplateDescriptor (vard1);
# line 513 "HomeDescriptor.puma"
   MakeTemplateDescriptor (vard2);
# line 515 "HomeDescriptor.puma"
 for (top_dim = 1; top_dim <= VarRank (vard1->topology_obj); top_dim ++)

        UnionTopDims (vard1, vard2, top_dim);

     vard1->var_tree = NoTree;

#ifdef DEBUG
     printf ("result of union is :\n");
     PrintVarDescriptor (vard1);
#endif

   
  }
  }
   return;
 }
yyL3:;

# line 529 "HomeDescriptor.puma"
  {
# line 531 "HomeDescriptor.puma"
   MakeReplicatedDescriptor (vard1);
  }
   return;

;
}

static void UnionTopDims
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
# line 543 "HomeDescriptor.puma"
 {
  int idim1;
  int idim2;
  {
# line 545 "HomeDescriptor.puma"

# line 546 "HomeDescriptor.puma"

# line 548 "HomeDescriptor.puma"
 idim1 = vard1->on_index_dim [top_dim-1];
     idim2 = vard2->on_index_dim [top_dim-1];

     

     if (idim1 == 0)

        { 

        }

       else if (idim2 == 0)

        { 

          ReplicateDescriptorDimension (vard1, idim1);

        }

       else

        { bool found;
          int  diff;

          

          VDIsTopDimAligned (vard1, vard2, top_dim, &found, &diff);

          if (!found || (diff != 0))

             

             ReplicateDescriptorDimension (vard1, idim1);

         }
   
  }
   return;
 }

;
}

void MakeSerialDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar home, register bool * yyP1)
# else
(home, yyP1)
 pvar home;
 register bool * yyP1;
# endif
{
# line 594 "HomeDescriptor.puma"
  {
# line 596 "HomeDescriptor.puma"
   if (! ((IsHostDescriptor (home)))) goto yyL1;
  }
   * yyP1 = true;
   return;
yyL1:;

# line 599 "HomeDescriptor.puma"
  {
# line 601 "HomeDescriptor.puma"
   if (! ((IsReplicatedDescriptor (home)))) goto yyL2;
  {
# line 602 "HomeDescriptor.puma"
   MakeHostDescriptor (home);
  }
  }
   * yyP1 = true;
   return;
yyL2:;

# line 605 "HomeDescriptor.puma"
  {
# line 607 "HomeDescriptor.puma"
   if (! ((IsNoDescriptor (home)))) goto yyL3;
  {
# line 608 "HomeDescriptor.puma"
   MakeHostDescriptor (home);
  }
  }
   * yyP1 = true;
   return;
yyL3:;

# line 611 "HomeDescriptor.puma"
  {
# line 613 "HomeDescriptor.puma"
   if (! ((home -> topology_obj == GetDefaultTopology (0)))) goto yyL4;
  {
# line 614 "HomeDescriptor.puma"
   MakeHostDescriptor (home);
  }
  }
   * yyP1 = true;
   return;
yyL4:;

# line 617 "HomeDescriptor.puma"
 {
  bool okay;
  {
# line 619 "HomeDescriptor.puma"

# line 621 "HomeDescriptor.puma"
 int i;

     okay = true;
     for (i=0; i<home->topology_rank; i++)

        { tTree val = home->on_val[i];

          if (val == NoTree)
             okay = false;                  

           else if (TreeRank (home->on_val[i]) > 0)
             okay = false;
        }
   
# line 635 "HomeDescriptor.puma"
   if (! ((okay))) goto yyL5;
  }
   * yyP1 = true;
   return;
 }
yyL5:;

# line 638 "HomeDescriptor.puma"
  {
# line 640 "HomeDescriptor.puma"
   printf ("could not serialize : \n");
# line 641 "HomeDescriptor.puma"
   PrintVarDescriptor (home);
# line 642 "HomeDescriptor.puma"
   MakeTemplateDescriptor (home);
# line 643 "HomeDescriptor.puma"
   printf ("template : \n");
# line 644 "HomeDescriptor.puma"
   PrintVarDescriptor (home);
  }
   * yyP1 = false;
   return;

;
}

bool IsSerialDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar home)
# else
(home)
 pvar home;
# endif
{
# line 661 "HomeDescriptor.puma"
  {
# line 663 "HomeDescriptor.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return true;
yyL1:;

# line 666 "HomeDescriptor.puma"
  {
# line 668 "HomeDescriptor.puma"
   if (! ((IsHostDescriptor (home)))) goto yyL2;
  }
   return true;
yyL2:;

# line 671 "HomeDescriptor.puma"
  {
# line 673 "HomeDescriptor.puma"
   if (! ((IsNoDescriptor (home)))) goto yyL3;
  {
# line 674 "HomeDescriptor.puma"
   return false;
  }
  }
yyL3:;

# line 677 "HomeDescriptor.puma"
  {
# line 679 "HomeDescriptor.puma"
   if (! ((home -> topology_obj == NoObject))) goto yyL4;
  {
# line 680 "HomeDescriptor.puma"
   if (! ((home -> template_inherited == 1))) goto yyL4;
  {
# line 682 "HomeDescriptor.puma"
   return false;
  }
  }
  }
yyL4:;

# line 685 "HomeDescriptor.puma"
 {
  bool okay;
  {
# line 687 "HomeDescriptor.puma"
   if (! ((home -> topology_obj != GetDefaultTopology (0)))) goto yyL5;
  {
# line 689 "HomeDescriptor.puma"

# line 691 "HomeDescriptor.puma"
 int i;

     okay = true;

     for (i=0; i<home->topology_rank; i++)

        { tTree val = home->on_val[i];

          if (val == NoTree)
             okay = false;                  

           else if (TreeRank (home->on_val[i]) > 0)
             okay = false;
        }
   
# line 706 "HomeDescriptor.puma"
   if (! ((okay))) goto yyL5;
  }
  }
   return true;
 }
yyL5:;

  return false;
}

void BeginHomeDescriptor ()
{
}

void CloseHomeDescriptor ()
{
}
