# include "GlobalComm.h"
# include "yyGlobalComm.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 28 "GlobalComm.puma"


# undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "DefTable.h"
# include "Transform.h"

# include "VarDescriptor.h"
# include "Distributions.h"
# include "Descriptor.h"

# include "Ownership.h"   /* BetterOnSelection                */
# include "VarComm.h"     /* IsLocalVarRead, IsLocalVarWrite  */
# include "FArguments.h"  /* IsOnlyReadParam                  */

# include "Extraction.h"
# include "Nesting.h"
# include "ParNest.h"

# define MODULE "GlobalComm"



static void yyExit () { Exit (1); }

void (* GlobalComm_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module GlobalComm, routine %s failed\n", yyFunction);
 GlobalComm_Exit ();
}

tTree GlobalCommunication ARGS((tTree stmt));
static tTree ExtractGlobalComm ARGS((tTree stmt, pvar home));
static tTree ExtractParamComm ARGS((tTree params, pvar home));
static tTree ExtractWriteVarComm ARGS((tTree var, pvar home));
static void ApplyHomeChange ARGS((tTree stmts, pvar inner_home, pvar outer_home));
static tTree MakeBroadcast ARGS((tTree bc_vars));
static tTree ParameterBroadcast ARGS((tTree p));
static tTree ControlSpecBroadcast ARGS((tTree p));
static tTree ReadSpecBroadcast ARGS((tTree p));
static tTree NameListVars ARGS((tTree names));
static void VectorizeGlobalComm ARGS((tTree stmts, pvar home, tTree id, tTree slice));
static void VectorizeVarList ARGS((tTree vars, tTree id, tTree slice, bool * yyP1));
static void SummarizeGlobalComm ARGS((tTree stmts, pvar home, tTree loop));

tTree GlobalCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
# line 68 "GlobalComm.puma"
 {
  var_descriptor outer_home;
  {
# line 70 "GlobalComm.puma"

# line 72 "GlobalComm.puma"
   MakeReplicatedDescriptor (& outer_home);
  }
  {
   return ExtractGlobalComm (stmt, & outer_home);
  }
 }

  }
# line 77 "GlobalComm.puma"
  {
# line 79 "GlobalComm.puma"
   failure_protocol (MODULE, "GlobalCommunication", stmt);
  }
   return NoTree;

}

static tTree ExtractGlobalComm
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home)
# else
(stmt, home)
 register tTree stmt;
 pvar home;
# endif
{

  switch (stmt->Kind) {
  case kACF_HOME:
  if (stmt->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
# line 98 "GlobalComm.puma"
 {
  var_descriptor on_home;
  tTree global_comm;
  {
# line 100 "GlobalComm.puma"

# line 102 "GlobalComm.puma"
   MakeHostDescriptor (& on_home);
# line 104 "GlobalComm.puma"

# line 106 "GlobalComm.puma"
   IncParNesting (stmt);
# line 108 "GlobalComm.puma"
   global_comm = ExtractGlobalComm (stmt->ACF_HOME.HOME_BODY, & on_home);
# line 110 "GlobalComm.puma"
   DecParNesting (stmt);
# line 114 "GlobalComm.puma"
   ApplyHomeChange (global_comm, & on_home, home);
  }
  {
   return global_comm;
  }
 }

  }
  if (stmt->ACF_HOME.HOME_VAR->Kind == kON_PROC_CLAUSE) {
# line 125 "GlobalComm.puma"
 {
  var_descriptor on_home;
  tTree global_comm;
  {
# line 127 "GlobalComm.puma"

# line 129 "GlobalComm.puma"
   SetProcDescriptor (stmt->ACF_HOME.HOME_VAR->ON_PROC_CLAUSE.ON_PROC, & on_home);
# line 131 "GlobalComm.puma"

# line 133 "GlobalComm.puma"
   IncParNesting (stmt);
# line 135 "GlobalComm.puma"
   global_comm = ExtractGlobalComm (stmt->ACF_HOME.HOME_BODY, & on_home);
# line 137 "GlobalComm.puma"
   DecParNesting (stmt);
# line 141 "GlobalComm.puma"
   ApplyHomeChange (global_comm, & on_home, home);
  }
  {
   return global_comm;
  }
 }

  }
  if (stmt->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
# line 152 "GlobalComm.puma"
 {
  var_descriptor on_home;
  tTree global_comm;
  {
# line 154 "GlobalComm.puma"

# line 156 "GlobalComm.puma"
   SetVarDescriptor (stmt->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
# line 158 "GlobalComm.puma"

# line 160 "GlobalComm.puma"
   IncParNesting (stmt);
# line 162 "GlobalComm.puma"
   global_comm = ExtractGlobalComm (stmt->ACF_HOME.HOME_BODY, & on_home);
# line 164 "GlobalComm.puma"
   DecParNesting (stmt);
# line 168 "GlobalComm.puma"
   ApplyHomeChange (global_comm, & on_home, home);
  }
  {
   return global_comm;
  }
 }

  }
  break;
  case kACF_LIST:
# line 179 "GlobalComm.puma"
   return (CombineACF (ExtractGlobalComm (stmt->ACF_LIST.Elem, home), ExtractGlobalComm (stmt->ACF_LIST.Next, home)));

  case kACF_EMPTY:
# line 185 "GlobalComm.puma"
   return NoTree;

  case kACF_DUMMY:
# line 190 "GlobalComm.puma"
   return NoTree;

  case kACF_IF:
# line 195 "GlobalComm.puma"
   return (CombineACF (ExtractGlobalComm (stmt->ACF_IF.THEN_PART, home), ExtractGlobalComm (stmt->ACF_IF.ELSE_PART, home)));

  case kACF_WHILE:
# line 207 "GlobalComm.puma"
 {
  tTree communication;
  {
# line 209 "GlobalComm.puma"

# line 211 "GlobalComm.puma"
   communication = ExtractGlobalComm (stmt->ACF_WHILE.WHILE_BODY, home);
# line 213 "GlobalComm.puma"
 if (communication != NoTree)

         { set_protocol_stmt (stmt);
           error_protocol (
               "cannot extract global communication from DO WHILE loop");
           tree_protocol ("global communication : ", communication);
         }
    
  }
  {
   return NoTree;
  }
 }

  case kACF_DO:
  if (stmt->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
# line 234 "GlobalComm.puma"
 {
  var_descriptor body_home;
  tTree communication;
  {
# line 236 "GlobalComm.puma"

# line 238 "GlobalComm.puma"
   SetVarDescriptor (stmt->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, & body_home);
# line 240 "GlobalComm.puma"

# line 242 "GlobalComm.puma"
   communication = ExtractGlobalComm (stmt->ACF_DO.DO_BODY, & body_home);
# line 244 "GlobalComm.puma"
   VectorizeGlobalComm (communication, & body_home, stmt->ACF_DO.DO_ID, stmt->ACF_DO.DO_RANGE);
  }
  {
   return communication;
  }
 }

  }
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
# line 255 "GlobalComm.puma"
 {
  tTree communication;
  {
# line 257 "GlobalComm.puma"

# line 259 "GlobalComm.puma"
   communication = ExtractGlobalComm (stmt->ACF_DO.DO_BODY, home);
# line 261 "GlobalComm.puma"
   SummarizeGlobalComm (communication, home, stmt);
  }
  {
   return communication;
  }
 }

  }
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kPARDO_INFO) {
# line 266 "GlobalComm.puma"
 {
  tTree communication;
  {
# line 268 "GlobalComm.puma"

# line 270 "GlobalComm.puma"
   communication = ExtractGlobalComm (stmt->ACF_DO.DO_BODY, home);
# line 272 "GlobalComm.puma"
   SummarizeGlobalComm (communication, home, stmt);
  }
  {
   return communication;
  }
 }

  }
  break;
  case kACF_TASK_REGION:
# line 283 "GlobalComm.puma"
 {
  tTree comm_stmts;
  {
# line 285 "GlobalComm.puma"

# line 287 "GlobalComm.puma"
   IncParNesting (stmt);
# line 289 "GlobalComm.puma"
   comm_stmts = ExtractGlobalComm (stmt->ACF_TASK_REGION.TASK_BODY, home);
# line 291 "GlobalComm.puma"
   DecParNesting (stmt);
  }
  {
   return comm_stmts;
  }
 }

  case kACF_NEW:
# line 302 "GlobalComm.puma"
 {
  tTree comm_stmts;
  {
# line 304 "GlobalComm.puma"

# line 306 "GlobalComm.puma"
   IncParNesting (stmt);
# line 308 "GlobalComm.puma"
   comm_stmts = ExtractGlobalComm (stmt->ACF_NEW.NEW_BODY, home);
# line 310 "GlobalComm.puma"
   DecParNesting (stmt);
  }
  {
   return comm_stmts;
  }
 }

  case kACF_REDUCTION:
# line 325 "GlobalComm.puma"
 {
  tTree comm_stmts;
  {
# line 327 "GlobalComm.puma"

# line 329 "GlobalComm.puma"
   IncParNesting (stmt);
# line 331 "GlobalComm.puma"
   comm_stmts = ExtractGlobalComm (stmt->ACF_REDUCTION.REDUCTION_BODY, home);
# line 333 "GlobalComm.puma"
   DecParNesting (stmt);
  }
  {
   return CombineACF (comm_stmts, ExtractWriteVarComm (stmt->ACF_REDUCTION.REDUCTION_VAR, home));
  }
 }

  case kACF_RESIDENT:
# line 344 "GlobalComm.puma"
 {
  tTree comm_stmts;
  {
# line 346 "GlobalComm.puma"

# line 348 "GlobalComm.puma"
   IncParNesting (stmt);
# line 350 "GlobalComm.puma"
   comm_stmts = ExtractGlobalComm (stmt->ACF_RESIDENT.RESIDENT_BODY, home);
# line 352 "GlobalComm.puma"
   DecParNesting (stmt);
  }
  {
   return comm_stmts;
  }
 }

  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 363 "GlobalComm.puma"
   return ExtractWriteVarComm (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home);

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCTION_STMT) {
# line 370 "GlobalComm.puma"
   return ExtractWriteVarComm (stmt->ACF_BASIC.BASIC_STMT->REDUCTION_STMT.ELEMS, home);

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 381 "GlobalComm.puma"
   return ExtractParamComm (stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, home);

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 396 "GlobalComm.puma"
  {
# line 398 "GlobalComm.puma"
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == MakeIdent ("INQUIRE", 7)))) goto yyL19;
  }
   return MakeBroadcast (ControlSpecBroadcast (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS));
yyL19:;

# line 403 "GlobalComm.puma"
  {
# line 405 "GlobalComm.puma"
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == MakeIdent ("OPEN", 4)))) goto yyL20;
  }
   return MakeBroadcast (ControlSpecBroadcast (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS));
yyL20:;

# line 416 "GlobalComm.puma"
  {
# line 418 "GlobalComm.puma"
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == MakeIdent ("READ", 4)))) goto yyL21;
  }
   return MakeBroadcast (CombineBTV (ReadSpecBroadcast (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS), ParameterBroadcast (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS)));
yyL21:;

# line 430 "GlobalComm.puma"
   return NoTree;

  }
# line 441 "GlobalComm.puma"
   return NoTree;

  }

# line 446 "GlobalComm.puma"
  {
# line 448 "GlobalComm.puma"
   failure_protocol (MODULE, "ExtractGlobalComm", stmt);
  }
   return NoTree;

}

static tTree ExtractParamComm
# if defined __STDC__ | defined __cplusplus
(register tTree params, pvar home)
# else
(params, home)
 register tTree params;
 pvar home;
# endif
{
  if (params->Kind == kBTP_LIST) {
# line 460 "GlobalComm.puma"
   return CombineACF (ExtractParamComm (params->BTP_LIST.Elem, home), ExtractParamComm (params->BTP_LIST.Next, home));

  }
  if (params->Kind == kBTP_EMPTY) {
# line 466 "GlobalComm.puma"
   return NoTree;

  }
  if (params->Kind == kVAR_PARAM) {
  if (params->VAR_PARAM.V->Kind == kADDR) {
# line 471 "GlobalComm.puma"
   return NoTree;

  }
# line 476 "GlobalComm.puma"
  {
# line 478 "GlobalComm.puma"
   if (! ((params->VAR_PARAM.intent == IntentIn))) goto yyL4;
  }
   return NoTree;
yyL4:;

# line 483 "GlobalComm.puma"
   return ExtractWriteVarComm (params->VAR_PARAM.V, home);

  }
# line 488 "GlobalComm.puma"
   return NoTree;

}

static tTree ExtractWriteVarComm
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kBTV_LIST) {
# line 501 "GlobalComm.puma"
   return CombineACF (ExtractWriteVarComm (var->BTV_LIST.Elem, home), ExtractWriteVarComm (var->BTV_LIST.Next, home));

  }
  if (var->Kind == kBTV_EMPTY) {
# line 507 "GlobalComm.puma"
   return NoTree;

  }
# line 518 "GlobalComm.puma"
  {
# line 520 "GlobalComm.puma"
   tree_protocol ("broadcast variable is : ", var);
# line 521 "GlobalComm.puma"
   tree_protocol ("broadcast home is : ", PrintableDescriptorVar (home));
# line 523 "GlobalComm.puma"
   goto yyL3;
  }
yyL3:;

# line 540 "GlobalComm.puma"
  {
# line 542 "GlobalComm.puma"
   if (! ((IsReplicatedDescriptor (home)))) goto yyL4;
  {
# line 544 "GlobalComm.puma"
   tree_protocol ("no broadcast, replicated home : ", var);
  }
  }
   return NoTree;
yyL4:;

  if (var->Kind == kREMOTE_VAR) {
# line 555 "GlobalComm.puma"
   return NoTree;

  }
# line 566 "GlobalComm.puma"
  {
# line 568 "GlobalComm.puma"
   if (! ((IsLocalVarWrite (var, home)))) goto yyL6;
  {
# line 570 "GlobalComm.puma"
   tree_protocol ("no broadcast, local write is : ", var);
  }
  }
   return NoTree;
yyL6:;

# line 575 "GlobalComm.puma"
  {
# line 577 "GlobalComm.puma"
   if (! ((IsIndShadowVariable (var, home)))) goto yyL7;
  {
# line 579 "GlobalComm.puma"
   tree_protocol ("no broadcast, ind shadow is : ", var);
  }
  }
   return NoTree;
yyL7:;

# line 584 "GlobalComm.puma"
 {
  var_descriptor vard;
  {
# line 586 "GlobalComm.puma"

# line 588 "GlobalComm.puma"
   SetVarDescriptor (var, & vard);
# line 589 "GlobalComm.puma"
   if (! ((NoReplicationDescriptor (& vard)))) goto yyL8;
  {
# line 591 "GlobalComm.puma"
   tree_protocol ("no broadcast, single incarnation: ", var);
  }
  }
  {
   return NoTree;
  }
 }
yyL8:;

# line 603 "GlobalComm.puma"
 {
  tTree bc_vars;
  {
# line 605 "GlobalComm.puma"
   if (! ((IsLocalVarRead (var, home)))) goto yyL9;
  {
# line 607 "GlobalComm.puma"

#ifdef DEBUG
     printf ("broadcast needed for : ");
     FileUnparse (stdout, var);
     printf (" on home ");
     FileUnparse (stdout, PrintableDescriptorVar (home));
     printf ("\n");
#endif 
   
# line 617 "GlobalComm.puma"

# line 619 "GlobalComm.puma"
   bc_vars = mBTV_LIST (CopyTree (var), mBTV_EMPTY ());
  }
  }
  {
   return mACF_BASIC (mBROADCAST_STMT (bc_vars, NoTree, mON_EMPTY ()));
  }
 }
yyL9:;

# line 627 "GlobalComm.puma"
  {
# line 629 "GlobalComm.puma"
   error_protocol ("broadcast on non-local variables");
# line 630 "GlobalComm.puma"
   tree_protocol ("illegal variable is : ", var);
# line 631 "GlobalComm.puma"
   tree_protocol ("broadcast home is : ", PrintableDescriptorVar (home));
  }
   return NoTree;

}

static void ApplyHomeChange
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, pvar inner_home, pvar outer_home)
# else
(stmts, inner_home, outer_home)
 register tTree stmts;
 pvar inner_home;
 pvar outer_home;
# endif
{
# line 646 "GlobalComm.puma"
  {
# line 648 "GlobalComm.puma"
   if (! ((stmts == NoTree))) goto yyL1;
  {
# line 650 "GlobalComm.puma"

#ifdef DEBUG
    printf ("call of ApllyHomeChange\n");
    printf ("   inner home : ");
    FileUnparse (stdout, PrintableDescriptorVar (inner_home));
    printf ("\n");
    printf ("   outer home : ");
    FileUnparse (stdout, PrintableDescriptorVar (outer_home));
    printf ("\n");
#endif
  
  }
  }
   return;
yyL1:;

  if (stmts->Kind == kACF_LIST) {
# line 663 "GlobalComm.puma"
  {
# line 665 "GlobalComm.puma"
   ApplyHomeChange (stmts->ACF_LIST.Next, inner_home, outer_home);
# line 666 "GlobalComm.puma"
   ApplyHomeChange (stmts->ACF_LIST.Elem, inner_home, outer_home);
  }
   return;

  }
  if (stmts->Kind == kACF_EMPTY) {
# line 669 "GlobalComm.puma"
   return;

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kBROADCAST_STMT) {
# line 672 "GlobalComm.puma"
  {
# line 674 "GlobalComm.puma"
   BetterOnSelection (stmts->ACF_BASIC.BASIC_STMT, inner_home, outer_home);
  }
   return;

  }
  }
;
}

static tTree MakeBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree bc_vars)
# else
(bc_vars)
 register tTree bc_vars;
# endif
{
# line 684 "GlobalComm.puma"
   return mACF_BASIC (mBROADCAST_STMT (CompleteBTVs (bc_vars), NoTree, mON_EMPTY ()));

}

static tTree ParameterBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
  if (p->Kind == kBTP_LIST) {
# line 701 "GlobalComm.puma"
   return CombineBTV (ParameterBroadcast (p->BTP_LIST.Elem), ParameterBroadcast (p->BTP_LIST.Next));

  }
  if (p->Kind == kBTP_EMPTY) {
# line 707 "GlobalComm.puma"
   return NoTree;

  }
  if (p->Kind == kVAR_PARAM) {
# line 712 "GlobalComm.puma"
  {
# line 714 "GlobalComm.puma"
   if (! ((IsOnlyReadParam (p)))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 719 "GlobalComm.puma"
  {
# line 721 "GlobalComm.puma"
   if (! ((TreeWriteDistribution (p->VAR_PARAM.V) == 2))) goto yyL4;
  }
   return NoTree;
yyL4:;

# line 725 "GlobalComm.puma"
  {
# line 727 "GlobalComm.puma"
   if (! ((TreeWriteDistribution (p->VAR_PARAM.V) == 0))) goto yyL5;
  }
   return CopyTree (p->VAR_PARAM.V);
yyL5:;

# line 731 "GlobalComm.puma"
   return NoTree;

  }
  if (p->Kind == kNO_PARAM) {
# line 736 "GlobalComm.puma"
   return NoTree;

  }
  if (p->Kind == kFUNC_PARAM) {
# line 740 "GlobalComm.puma"
   return NoTree;

  }
  if (p->Kind == kPROC_PARAM) {
# line 744 "GlobalComm.puma"
   return NoTree;

  }
# line 748 "GlobalComm.puma"
  {
# line 749 "GlobalComm.puma"
   failure_protocol (MODULE, "ParameterBroadcast", p);
  }
   return NoTree;

}

static tTree ControlSpecBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
  if (p->Kind == kBTP_LIST) {
# line 763 "GlobalComm.puma"
   return CombineBTV (ControlSpecBroadcast (p->BTP_LIST.Elem), ControlSpecBroadcast (p->BTP_LIST.Next));

  }
  if (p->Kind == kBTP_EMPTY) {
# line 768 "GlobalComm.puma"
   return NoTree;

  }
  if (p->Kind == kNAMED_PARAM) {
# line 772 "GlobalComm.puma"
  {
# line 773 "GlobalComm.puma"
   if (! ((p->NAMED_PARAM.Name == MakeIdent ("EXISTS", 6)))) goto yyL3;
  }
   return ParameterBroadcast (p->NAMED_PARAM.VAL);
yyL3:;

# line 777 "GlobalComm.puma"
  {
# line 778 "GlobalComm.puma"
   if (! ((p->NAMED_PARAM.Name == MakeIdent ("IOSTAT", 6)))) goto yyL4;
  }
   return ParameterBroadcast (p->NAMED_PARAM.VAL);
yyL4:;

# line 782 "GlobalComm.puma"
   return NoTree;

  }
  if (p->Kind == kVAR_PARAM) {
# line 786 "GlobalComm.puma"
   return NoTree;

  }
# line 790 "GlobalComm.puma"
  {
# line 791 "GlobalComm.puma"
   failure_protocol (MODULE, "ControlSpecBroadcast", p);
  }
   return NoTree;

}

static tTree ReadSpecBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
  if (p->Kind == kBTP_LIST) {
# line 807 "GlobalComm.puma"
   return CombineBTV (ReadSpecBroadcast (p->BTP_LIST.Elem), ReadSpecBroadcast (p->BTP_LIST.Next));

  }
  if (p->Kind == kBTP_EMPTY) {
# line 812 "GlobalComm.puma"
   return NoTree;

  }
  if (p->Kind == kNAMED_PARAM) {
# line 816 "GlobalComm.puma"
  {
# line 817 "GlobalComm.puma"
   if (! ((p->NAMED_PARAM.Name == MakeIdent ("IOSTAT", 6)))) goto yyL3;
  }
   return ParameterBroadcast (p->NAMED_PARAM.VAL);
yyL3:;

# line 821 "GlobalComm.puma"
   return ReadSpecBroadcast (p->NAMED_PARAM.VAL);

  }
  if (p->Kind == kVAR_PARAM) {
# line 825 "GlobalComm.puma"
  {
# line 826 "GlobalComm.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL5;
  }
   return NoTree;
yyL5:;

  if (p->VAR_PARAM.V->Kind == kUSED_VAR) {
  if (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kNameListObject) {
  if (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->NameListObject.decl->Kind == kNAMELIST_DECL) {
# line 830 "GlobalComm.puma"
   return NameListVars (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->NameListObject.decl->NAMELIST_DECL.IDS);

  }
  }
  }
# line 838 "GlobalComm.puma"
   return NoTree;

  }
# line 842 "GlobalComm.puma"
  {
# line 843 "GlobalComm.puma"
   failure_protocol (MODULE, "ReadSpecBroadcast", p);
  }
   return NoTree;

}

static tTree NameListVars
# if defined __STDC__ | defined __cplusplus
(register tTree names)
# else
(names)
 register tTree names;
# endif
{
  if (names->Kind == kDECL_LIST) {
# line 855 "GlobalComm.puma"
   return CombineBTV (NameListVars (names->DECL_LIST.Elem), NameListVars (names->DECL_LIST.Next));

  }
  if (names->Kind == kDECL_EMPTY) {
# line 860 "GlobalComm.puma"
   return NoTree;

  }
  if (names->Kind == kVAR_DECL) {
# line 864 "GlobalComm.puma"
  {
# line 866 "GlobalComm.puma"
   if (! ((VarDistribution (GetLocalObject (names->VAR_DECL.Ident)) == - 1))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 870 "GlobalComm.puma"
 {
  tTree newvar;
  tDefinitions Obj;
  {
# line 872 "GlobalComm.puma"

# line 873 "GlobalComm.puma"

# line 875 "GlobalComm.puma"
   Obj = GetLocalObject (names->VAR_DECL.Ident);
# line 877 "GlobalComm.puma"
   if (! ((VarDistribution (Obj) == 0))) goto yyL4;
  {
# line 879 "GlobalComm.puma"
 newvar = mVAR_OBJ (names->VAR_DECL.Line, names->VAR_DECL.Ident);
      newvar->VAR_OBJ.Object = Obj;
      newvar = mUSED_VAR (newvar);
    
  }
  }
  {
   return newvar;
  }
 }
yyL4:;

# line 887 "GlobalComm.puma"
  {
# line 889 "GlobalComm.puma"
   if (! ((VarDistribution (GetLocalObject (names->VAR_DECL.Ident)) == 1))) goto yyL5;
  {
# line 891 "GlobalComm.puma"
   error_protocol ("distributed variable in namelist");
# line 892 "GlobalComm.puma"
   tree_protocol ("illegal variable is ", names);
  }
  }
   return NoTree;
yyL5:;

  }
# line 896 "GlobalComm.puma"
  {
# line 897 "GlobalComm.puma"
   failure_protocol (MODULE, "NameListVars", names);
  }
   return NoTree;

}

static void VectorizeGlobalComm
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, pvar home, register tTree id, register tTree slice)
# else
(stmts, home, id, slice)
 register tTree stmts;
 pvar home;
 register tTree id;
 register tTree slice;
# endif
{
# line 917 "GlobalComm.puma"
  {
# line 919 "GlobalComm.puma"
   if (! ((stmts == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (stmts->Kind == kACF_LIST) {
# line 922 "GlobalComm.puma"
  {
# line 924 "GlobalComm.puma"
   set_protocol_stmt (stmts->ACF_LIST.Elem);
# line 925 "GlobalComm.puma"
   VectorizeGlobalComm (stmts->ACF_LIST.Elem, home, id, slice);
# line 926 "GlobalComm.puma"
   VectorizeGlobalComm (stmts->ACF_LIST.Next, home, id, slice);
  }
   return;

  }
  if (stmts->Kind == kACF_EMPTY) {
# line 929 "GlobalComm.puma"
   return;

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kBROADCAST_STMT) {
# line 932 "GlobalComm.puma"
 {
  bool yyV1;
  {
# line 934 "GlobalComm.puma"
   tree_protocol ("vectorize bc : ", stmts->ACF_BASIC.BASIC_STMT);
# line 935 "GlobalComm.puma"
   tree_protocol ("id           : ", id);
# line 936 "GlobalComm.puma"
   tree_protocol ("slice        : ", slice);
# line 937 "GlobalComm.puma"
   tree_protocol ("home         : ", PrintableDescriptorVar (home));
# line 939 "GlobalComm.puma"
   VectorizeVarList (stmts->ACF_BASIC.BASIC_STMT->BROADCAST_STMT.ELEMS, id, slice, & yyV1);
# line 941 "GlobalComm.puma"
 if (yyV1 != 1)

        { 

          OnIdUpdate (stmts->ACF_BASIC.BASIC_STMT, home, id);
        }
   
  }
   return;
 }

  }
  }
# line 950 "GlobalComm.puma"
  {
# line 952 "GlobalComm.puma"
   failure_protocol (MODULE, "VectorizeGlobalComm", stmts);
  }
   return;

;
}

static void VectorizeVarList
# if defined __STDC__ | defined __cplusplus
(register tTree vars, register tTree id, register tTree slice, register bool * yyP1)
# else
(vars, id, slice, yyP1)
 register tTree vars;
 register tTree id;
 register tTree slice;
 register bool * yyP1;
# endif
{
  if (vars->Kind == kBTV_EMPTY) {
# line 963 "GlobalComm.puma"
   * yyP1 = 0;
   return;

  }
  if (vars->Kind == kBTV_LIST) {
# line 966 "GlobalComm.puma"
 {
  int done;
  bool yyV1;
  {
# line 968 "GlobalComm.puma"

# line 970 "GlobalComm.puma"
   MakeVectorVar (vars->BTV_LIST.Elem, id, slice, & done);
# line 977 "GlobalComm.puma"
 if (done == -1)

         { error_protocol ("could not vectorize global communication");
           tree_protocol  ("illegal variable : ", vars->BTV_LIST.Elem);
           tree_protocol  ("loop id :          ", id);
         }
    
# line 985 "GlobalComm.puma"
   VectorizeVarList (vars->BTV_LIST.Next, id, slice, & yyV1);
  }
   * yyP1 = done;
   return;
 }

  }
# line 988 "GlobalComm.puma"
  {
# line 990 "GlobalComm.puma"
   failure_protocol (MODULE, "VectorizeVarList", vars);
  }
   * yyP1 = 0;
   return;

;
}

static void SummarizeGlobalComm
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, pvar home, register tTree loop)
# else
(stmts, home, loop)
 register tTree stmts;
 pvar home;
 register tTree loop;
# endif
{
# line 1002 "GlobalComm.puma"
  {
# line 1004 "GlobalComm.puma"
   if (! ((stmts == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (stmts->Kind == kACF_LIST) {
# line 1007 "GlobalComm.puma"
  {
# line 1009 "GlobalComm.puma"
   set_protocol_stmt (stmts->ACF_LIST.Elem);
# line 1011 "GlobalComm.puma"
   SummarizeGlobalComm (stmts->ACF_LIST.Elem, home, loop);
# line 1012 "GlobalComm.puma"
   SummarizeGlobalComm (stmts->ACF_LIST.Next, home, loop);
  }
   return;

  }
  if (stmts->Kind == kACF_EMPTY) {
# line 1015 "GlobalComm.puma"
   return;

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kBROADCAST_STMT) {
# line 1018 "GlobalComm.puma"
  {
# line 1020 "GlobalComm.puma"
   error_protocol ("cannot summarize global broadcast in serial loop");
# line 1021 "GlobalComm.puma"
   tree_protocol ("serial loop : \n", loop);
  }
   return;

  }
  }
# line 1024 "GlobalComm.puma"
  {
# line 1026 "GlobalComm.puma"
   failure_protocol (MODULE, "SummarizeGlobalComm", stmts);
  }
   return;

;
}

void BeginGlobalComm ()
{
}

void CloseGlobalComm ()
{
}
