# include "Fusion.h"
# include "yyFusion.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 28 "Fusion.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Transform.h"     /* CombineACF */

# include "ReplaceExp.h"    /* RenameLoopId */

# include "StmtDeps.h"      /* FusionDependence */
# include "Expressions.h"

# define  MODULE  "Fusion"



static void yyExit () { Exit (1); }

void (* Fusion_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Fusion, routine %s failed\n", yyFunction);
 Fusion_Exit ();
}

bool CanBeFused ARGS((tTree stmt1, tTree stmt2));
static bool SameOnTopology ARGS((tTree topology1, tTree topology2));
static bool SameSpecs ARGS((tTree speclist1, tTree speclist2));
static bool SameInfo ARGS((tTree info1, tTree info2));
tTree Fusion ARGS((tTree stmt1, tTree stmt2));

bool CanBeFused
# if defined __STDC__ | defined __cplusplus
(register tTree stmt1, register tTree stmt2)
# else
(stmt1, stmt2)
 register tTree stmt1;
 register tTree stmt2;
# endif
{
  if (stmt1->Kind == kACF_ON) {
  if (stmt2->Kind == kACF_ON) {
# line 55 "Fusion.puma"
 {
  Predicate p;
  {
# line 58 "Fusion.puma"
   if (! ((stmt2->ACF_ON.Label == 0))) goto yyL1;
  {
# line 60 "Fusion.puma"
   if (! ((SameOnTopology (stmt1->ACF_ON.ON_HOME, stmt2->ACF_ON.ON_HOME)))) goto yyL1;
  {
# line 61 "Fusion.puma"
   if (! ((SameSpecs (stmt1->ACF_ON.ON_SPECS, stmt2->ACF_ON.ON_SPECS)))) goto yyL1;
  {
# line 63 "Fusion.puma"

# line 65 "Fusion.puma"
   FusionDependence (stmt1, stmt2, & p);
# line 67 "Fusion.puma"
   if (! ((PIsFalse (& p)))) goto yyL1;
  }
  }
  }
  }
   return true;
 }
yyL1:;

  }
  }
  if (stmt1->Kind == kACF_DO) {
  if (stmt2->Kind == kACF_DO) {
# line 70 "Fusion.puma"
 {
  Predicate p;
  {
# line 73 "Fusion.puma"
   if (! ((stmt2->ACF_DO.Label == 0))) goto yyL2;
  {
# line 76 "Fusion.puma"
   if (! ((SameInfo (stmt1->ACF_DO.DO_DEP_INFO, stmt2->ACF_DO.DO_DEP_INFO)))) goto yyL2;
  {
# line 77 "Fusion.puma"
   if (! ((EqualExpression (stmt1->ACF_DO.DO_RANGE, stmt2->ACF_DO.DO_RANGE)))) goto yyL2;
  {
# line 79 "Fusion.puma"

# line 81 "Fusion.puma"
   FusionDependence (stmt1, stmt2, & p);
# line 83 "Fusion.puma"
   if (! ((PIsFalse (& p)))) goto yyL2;
  }
  }
  }
  }
   return true;
 }
yyL2:;

  }
  }
  if (stmt1->Kind == kACF_BARRIER) {
  if (stmt2->Kind == kACF_BARRIER) {
# line 86 "Fusion.puma"
   return true;

  }
  }
  return false;
}

static bool SameOnTopology
# if defined __STDC__ | defined __cplusplus
(register tTree topology1, register tTree topology2)
# else
(topology1, topology2)
 register tTree topology1;
 register tTree topology2;
# endif
{
  if (topology1->Kind == kON_ALL) {
  if (topology2->Kind == kON_ALL) {
# line 97 "Fusion.puma"
   return true;

  }
  }
  if (topology1->Kind == kON_HOST) {
  if (topology2->Kind == kON_HOST) {
# line 100 "Fusion.puma"
   return true;

  }
  }
  if (topology1->Kind == kON_VAR) {
  if (topology2->Kind == kON_VAR) {
# line 103 "Fusion.puma"
  {
# line 105 "Fusion.puma"
   if (! ((topology1->ON_VAR.topid == topology2->ON_VAR.topid))) goto yyL3;
  {
# line 106 "Fusion.puma"
   if (! ((topology1->ON_VAR.tempid == topology2->ON_VAR.tempid))) goto yyL3;
  }
  }
   return true;
yyL3:;

  }
  }
  return false;
}

static bool SameSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree speclist1, register tTree speclist2)
# else
(speclist1, speclist2)
 register tTree speclist1;
 register tTree speclist2;
# endif
{
  if (speclist1->Kind == kON_EMPTY) {
  if (speclist2->Kind == kON_EMPTY) {
# line 119 "Fusion.puma"
   return true;

  }
  }
  if (speclist1->Kind == kON_LIST) {
  if (speclist2->Kind == kON_LIST) {
# line 122 "Fusion.puma"
  {
# line 124 "Fusion.puma"
   if (! ((SameSpecs (speclist1->ON_LIST.Elem, speclist2->ON_LIST.Elem)))) goto yyL2;
  {
# line 125 "Fusion.puma"
   if (! ((SameSpecs (speclist1->ON_LIST.Next, speclist2->ON_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  }
  if (speclist1->Kind == kON_SPEC) {
  if (speclist2->Kind == kON_SPEC) {
# line 128 "Fusion.puma"
  {
# line 131 "Fusion.puma"
   if (! ((speclist1->ON_SPEC.top_dim == speclist2->ON_SPEC.top_dim))) goto yyL3;
  {
# line 132 "Fusion.puma"
   if (! ((EqualExpression (speclist1->ON_SPEC.ON_VAL, speclist2->ON_SPEC.ON_VAL)))) goto yyL3;
  }
  }
   return true;
yyL3:;

  }
  }
  return false;
}

static bool SameInfo
# if defined __STDC__ | defined __cplusplus
(register tTree info1, register tTree info2)
# else
(info1, info2)
 register tTree info1;
 register tTree info2;
# endif
{
  if (info1->Kind == kON_INFO) {
  if (info2->Kind == kON_INFO) {
# line 137 "Fusion.puma"
  {
# line 140 "Fusion.puma"
   if (! ((info1->ON_INFO.on_id == info2->ON_INFO.on_id))) goto yyL1;
  {
# line 141 "Fusion.puma"
   if (! ((info1->ON_INFO.on_dim == info2->ON_INFO.on_dim))) goto yyL1;
  {
# line 142 "Fusion.puma"
   if (! ((info1->ON_INFO.base == info2->ON_INFO.base))) goto yyL1;
  {
# line 143 "Fusion.puma"
   if (! ((info1->ON_INFO.stride == info2->ON_INFO.stride))) goto yyL1;
  }
  }
  }
  }
   return true;
yyL1:;

  }
  }
  if (info1->Kind == kSERIAL_INFO) {
  if (info2->Kind == kSERIAL_INFO) {
# line 146 "Fusion.puma"
   return true;

  }
  }
  if (info1->Kind == kINDEP_INFO) {
  if (info2->Kind == kINDEP_INFO) {
# line 149 "Fusion.puma"
  {
# line 151 "Fusion.puma"
   if (! ((info1->INDEP_INFO.selection == info2->INDEP_INFO.selection))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  return false;
}

tTree Fusion
# if defined __STDC__ | defined __cplusplus
(register tTree stmt1, register tTree stmt2)
# else
(stmt1, stmt2)
 register tTree stmt1;
 register tTree stmt2;
# endif
{
  if (stmt1->Kind == kACF_ON) {
  if (stmt2->Kind == kACF_ON) {
# line 177 "Fusion.puma"
  {
# line 179 "Fusion.puma"
 stmt1->ACF_ON.ON_BODY = CombineACF (stmt1->ACF_ON.ON_BODY, stmt2->ACF_ON.ON_BODY); 
  }
   return stmt1;

  }
  }
  if (stmt1->Kind == kACF_DO) {
  if (stmt2->Kind == kACF_DO) {
# line 184 "Fusion.puma"
  {
# line 187 "Fusion.puma"
   RenameLoopId (stmt2->ACF_DO.DO_BODY, stmt2->ACF_DO.DO_ID, stmt1->ACF_DO.DO_ID);
# line 189 "Fusion.puma"
 stmt1->ACF_DO.DO_BODY = CombineACF (stmt1->ACF_DO.DO_BODY, stmt2->ACF_DO.DO_BODY); 
  }
   return stmt1;

  }
  }
  if (stmt1->Kind == kACF_BARRIER) {
  if (stmt2->Kind == kACF_BARRIER) {
# line 194 "Fusion.puma"
   return stmt1;

  }
  }
 yyAbort ("Fusion");
}

void BeginFusion ()
{
}

void CloseFusion ()
{
}
