# include "FindHome.h"
# include "yyFindHome.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 42 "FindHome.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "ParNest.h"        /* IsNewVariable   */
# include "Descriptor.h"     
# include "Objects.h"
# include "HomeDescriptor.h"
# include "MoveControl.h"
# include "Accepted.h"
# include "Rank.h"
# include "Distributions.h"
# include "ArrayData.h"

# define MODULE "FindHome"

# undef DEBUG



static void yyExit () { Exit (1); }

void (* FindHome_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module FindHome, routine %s failed\n", yyFunction);
 FindHome_Exit ();
}

void GetHomeDescriptor ARGS((tTree t, pvar good_home));
void FindHome ARGS((tTree t, pvar min_home, pvar good_home));
static void FindParamHome ARGS((tTree t, pvar min_home, pvar good_home));
static void FindParamListHome ARGS((tTree t, pvar min_home, pvar good_home));
static void FindExpHome ARGS((tTree exp, pvar min_home, pvar good_home));
static void FindVarHome ARGS((tTree var, pvar min_home, pvar good_home));
static void FindReadVarHome ARGS((tTree var, pvar min_home, pvar good_home));
static void FindWriteVarHome ARGS((tTree var, pvar min_home, pvar good_home));
static void FindDescriptorHome ARGS((tTree t, pvar min_home, pvar good_home));
static void ChooseHome ARGS((pvar home1, pvar home2));
static void ChooseBestHome ARGS((pvar home1, pvar home2));
static void UnionHome ARGS((pvar home1, pvar home2));
static void ExpandHomes ARGS((pvar min_home, pvar good_home, tTree id));
static void PrintHomes ARGS((tTree t, pvar min_home, pvar good_home));
void FindSerialHome ARGS((tTree stmt, pvar home, bool * yyP1));

void GetHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar good_home)
# else
(t, good_home)
 register tTree t;
 pvar good_home;
# endif
{
# line 78 "FindHome.puma"
 {
  var_descriptor min_home;
  {
# line 80 "FindHome.puma"

# line 82 "FindHome.puma"
   FindHome (t, & min_home, good_home);
# line 84 "FindHome.puma"

#ifdef DEBUG
     printf ("GetHomeDescriptor of this tree is : \n");
     FileUnparse (stdout, t);
     PrintVarDescriptor (good_home);
#endif
   
  }
   return;
 }

;
}

void FindHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 108 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 110 "FindHome.puma"

# line 111 "FindHome.puma"

# line 113 "FindHome.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 115 "FindHome.puma"
   FindHome (t->ACF_LIST.Elem, min_home, good_home);
# line 116 "FindHome.puma"
   FindHome (t->ACF_LIST.Next, & min_home1, & good_home1);
# line 118 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 119 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  case kACF_EMPTY:
# line 122 "FindHome.puma"
  {
# line 124 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 125 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
   return;

  case kACF_FORALL:
# line 128 "FindHome.puma"
  {
# line 130 "FindHome.puma"
 t->Kind = kACF_DO; 
# line 132 "FindHome.puma"
   FindHome (t, min_home, good_home);
  }
   return;

  case kACF_DO:
# line 135 "FindHome.puma"
  {
# line 137 "FindHome.puma"
   IncParNesting (t);
# line 139 "FindHome.puma"
   FindHome (t->ACF_DO.DO_BODY, min_home, good_home);
# line 141 "FindHome.puma"
   set_protocol_stmt (t);
# line 143 "FindHome.puma"
   ExpandHomes (min_home, good_home, t->ACF_DO.DO_ID);
# line 145 "FindHome.puma"
   DecParNesting (t);
  }
   return;

  case kACF_IF:
# line 148 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 150 "FindHome.puma"

# line 151 "FindHome.puma"

# line 153 "FindHome.puma"
   IncParNesting (t);
# line 155 "FindHome.puma"
   FindHome (t->ACF_IF.THEN_PART, min_home, good_home);
# line 156 "FindHome.puma"
   FindHome (t->ACF_IF.ELSE_PART, & min_home1, & good_home1);
# line 158 "FindHome.puma"
   DecParNesting (t);
# line 160 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 161 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
# line 163 "FindHome.puma"
   FindExpHome (t->ACF_IF.IF_EXP, & min_home1, & good_home1);
# line 165 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 166 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  case kACF_WHERE:
# line 169 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 171 "FindHome.puma"

# line 172 "FindHome.puma"

# line 174 "FindHome.puma"
   FindHome (t->ACF_WHERE.TRUE_PART, min_home, good_home);
# line 175 "FindHome.puma"
   FindHome (t->ACF_WHERE.FALSE_PART, & min_home1, & good_home1);
# line 177 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 178 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
# line 180 "FindHome.puma"
   FindExpHome (t->ACF_WHERE.WHERE_EXP, & min_home1, & good_home1);
# line 182 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 183 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  case kACF_WHILE:
# line 186 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 188 "FindHome.puma"

# line 189 "FindHome.puma"

# line 191 "FindHome.puma"
   FindHome (t->ACF_WHILE.WHILE_BODY, min_home, good_home);
# line 192 "FindHome.puma"
   FindExpHome (t->ACF_WHILE.WHILE_EXP, & min_home1, & good_home1);
# line 194 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 195 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  case kACF_NEW:
# line 198 "FindHome.puma"
  {
# line 200 "FindHome.puma"
   IncParNesting (t);
# line 201 "FindHome.puma"
   FindHome (t->ACF_NEW.NEW_BODY, min_home, good_home);
# line 202 "FindHome.puma"
   DecParNesting (t);
  }
   return;

  case kACF_RESIDENT:
# line 205 "FindHome.puma"
  {
# line 207 "FindHome.puma"
   IncParNesting (t);
# line 208 "FindHome.puma"
   FindHome (t->ACF_RESIDENT.RESIDENT_BODY, min_home, good_home);
# line 209 "FindHome.puma"
   DecParNesting (t);
  }
   return;

  case kACF_TASK_REGION:
# line 212 "FindHome.puma"
  {
# line 214 "FindHome.puma"
   IncParNesting (t);
# line 215 "FindHome.puma"
   FindHome (t->ACF_TASK_REGION.TASK_BODY, min_home, good_home);
# line 216 "FindHome.puma"
   DecParNesting (t);
  }
   return;

  case kACF_REDUCTION:
# line 219 "FindHome.puma"
  {
# line 221 "FindHome.puma"
   IncParNesting (t);
# line 222 "FindHome.puma"
   FindHome (t->ACF_REDUCTION.REDUCTION_BODY, min_home, good_home);
# line 223 "FindHome.puma"
   DecParNesting (t);
  }
   return;

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
# line 232 "FindHome.puma"
  {
# line 234 "FindHome.puma"
   IncParNesting (t);
# line 236 "FindHome.puma"
   FindHome (t->ACF_HOME.HOME_BODY, min_home, good_home);
# line 238 "FindHome.puma"
   DecParNesting (t);
# line 242 "FindHome.puma"
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, good_home);
  }
   return;

  }
  break;
  case kACF_BASIC:
# line 245 "FindHome.puma"
  {
# line 247 "FindHome.puma"
   SetActualData (t);
# line 249 "FindHome.puma"
   FindHome (t->ACF_BASIC.BASIC_STMT, min_home, good_home);
  }
   return;

  case kREDUCE_STMT:
  if (t->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
  if (t->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 258 "FindHome.puma"
  {
# line 260 "FindHome.puma"
   FindParamHome (t->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, min_home, good_home);
# line 265 "FindHome.puma"
 if (IsNoDescriptor (good_home))
      MakeParLoopNestDescriptor (good_home);

#ifdef DEBUG
    PrintHomes (t, min_home, good_home);
#endif 

  
  }
   return;

  }
  }
  break;
  case kASSIGN_STMT:
# line 277 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 279 "FindHome.puma"

# line 280 "FindHome.puma"

# line 284 "FindHome.puma"
   FindWriteVarHome (t->ASSIGN_STMT.ASSIGN_VAR, min_home, good_home);
# line 285 "FindHome.puma"
   FindExpHome (t->ASSIGN_STMT.ASSIGN_EXP, & min_home1, & good_home1);
# line 287 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 288 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
# line 290 "FindHome.puma"

#ifdef DEBUG
    PrintHomes (t, min_home, good_home);
#endif
  
  }
   return;
 }

  case kIO_STMT:
# line 299 "FindHome.puma"
  {
# line 303 "FindHome.puma"
   MakeHostDescriptor (good_home);
# line 304 "FindHome.puma"
   MakeNoDescriptor (min_home);
  }
   return;

  case kCALL_STMT:
# line 309 "FindHome.puma"
  {
# line 311 "FindHome.puma"
   if (! ((IsPureCall (t)))) goto yyL17;
  {
# line 313 "FindHome.puma"
   FindParamListHome (t->CALL_STMT.CALL_PARAMS, min_home, good_home);
# line 315 "FindHome.puma"

#ifdef DEBUG
    PrintHomes (t, min_home, good_home);
#endif 
  
  }
  }
   return;
yyL17:;

# line 322 "FindHome.puma"
 {
  bool yyV1;
  {
# line 324 "FindHome.puma"
   if (! ((IsSerialCall (t)))) goto yyL18;
  {
# line 326 "FindHome.puma"
   stmt_protocol ("check for serial home");
# line 328 "FindHome.puma"
   FindSerialHome (t->CALL_STMT.CALL_PARAMS, min_home, & yyV1);
# line 329 "FindHome.puma"
   if (! ((yyV1))) goto yyL18;
  {
# line 331 "FindHome.puma"
   tree_protocol ("serial home found : ", PrintableDescriptorVar (min_home));
# line 333 "FindHome.puma"
 *good_home = *min_home; 
  }
  }
  }
   return;
 }
yyL18:;

# line 336 "FindHome.puma"
  {
# line 338 "FindHome.puma"
   if (! ((IsSerialCall (t)))) goto yyL19;
  {
# line 340 "FindHome.puma"
   MakeHostDescriptor (min_home);
# line 341 "FindHome.puma"
   MakeHostDescriptor (good_home);
  }
  }
   return;
yyL19:;

# line 344 "FindHome.puma"
 {
  tTree home_clause;
  {
# line 346 "FindHome.puma"
   if (! ((HasUserHome ()))) goto yyL20;
  {
# line 348 "FindHome.puma"

# line 350 "FindHome.puma"
   home_clause = GetUserHome ();
# line 352 "FindHome.puma"
   MakeClauseDescriptor (home_clause, min_home);
# line 353 "FindHome.puma"
   MakeClauseDescriptor (home_clause, good_home);
  }
  }
   return;
 }
yyL20:;

# line 356 "FindHome.puma"
  {
# line 358 "FindHome.puma"
   if (! ((UserIndependent ()))) goto yyL21;
  {
# line 360 "FindHome.puma"
   FindParamListHome (t->CALL_STMT.CALL_PARAMS, min_home, good_home);
  }
  }
   return;
yyL21:;

# line 365 "FindHome.puma"
  {
# line 367 "FindHome.puma"
   MakeReplicatedDescriptor (min_home);
# line 368 "FindHome.puma"
   MakeReplicatedDescriptor (good_home);
  }
   return;

  case kALLOCATE_STMT:
# line 374 "FindHome.puma"
  {
# line 376 "FindHome.puma"
   FindDescriptorHome (t->ALLOCATE_STMT.PARAMS, min_home, good_home);
  }
   return;

  case kDEALLOCATE_STMT:
# line 379 "FindHome.puma"
  {
# line 381 "FindHome.puma"
   FindDescriptorHome (t->DEALLOCATE_STMT.PARAMS, min_home, good_home);
  }
   return;

  case kCREATE_DSP_STMT:
# line 384 "FindHome.puma"
  {
# line 386 "FindHome.puma"
   FindDescriptorHome (t->CREATE_DSP_STMT.VAR, min_home, good_home);
  }
   return;

  case kFREE_DSP_STMT:
# line 389 "FindHome.puma"
  {
# line 391 "FindHome.puma"
   FindDescriptorHome (t->FREE_DSP_STMT.VAR, min_home, good_home);
  }
   return;

  }

# line 394 "FindHome.puma"
  {
# line 396 "FindHome.puma"
   stmt_protocol ("executed by ALL");
# line 398 "FindHome.puma"
   MakeReplicatedDescriptor (good_home);
# line 399 "FindHome.puma"
   MakeReplicatedDescriptor (min_home);
  }
   return;

;
}

static void FindParamHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
# line 410 "FindHome.puma"
  {
# line 412 "FindHome.puma"
   FindExpHome (t->VAR_PARAM.V->ADDR.E, min_home, good_home);
  }
   return;

  }
# line 415 "FindHome.puma"
  {
# line 417 "FindHome.puma"
   if (! (((t->VAR_PARAM.intent == IntentOut) || (t->VAR_PARAM.intent == IntentInOut)))) goto yyL2;
  {
# line 418 "FindHome.puma"
   FindWriteVarHome (t->VAR_PARAM.V, min_home, good_home);
  }
  }
   return;
yyL2:;

# line 421 "FindHome.puma"
  {
# line 423 "FindHome.puma"
   FindReadVarHome (t->VAR_PARAM.V, min_home, good_home);
  }
   return;

  }
# line 428 "FindHome.puma"
  {
# line 430 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 431 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
   return;

;
}

static void FindParamListHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
  if (t->Kind == kBTP_LIST) {
# line 442 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 444 "FindHome.puma"

# line 445 "FindHome.puma"

# line 447 "FindHome.puma"
   FindParamHome (t->BTP_LIST.Elem, min_home, good_home);
# line 448 "FindHome.puma"
   FindParamListHome (t->BTP_LIST.Next, & min_home1, & good_home1);
# line 450 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 451 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  }
# line 454 "FindHome.puma"
  {
# line 456 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 457 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
   return;

;
}

static void FindExpHome
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar min_home, pvar good_home)
# else
(exp, min_home, good_home)
 register tTree exp;
 pvar min_home;
 pvar good_home;
# endif
{
  if (exp->Kind == kBTE_LIST) {
# line 468 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 470 "FindHome.puma"

# line 471 "FindHome.puma"

# line 473 "FindHome.puma"
   FindExpHome (exp->BTE_LIST.Elem, min_home, good_home);
# line 474 "FindHome.puma"
   FindExpHome (exp->BTE_LIST.Next, & min_home1, & good_home1);
# line 476 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 477 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  }
  if (exp->Kind == kOP_EXP) {
# line 480 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 482 "FindHome.puma"

# line 483 "FindHome.puma"

# line 485 "FindHome.puma"
   FindExpHome (exp->OP_EXP.OPND1, min_home, good_home);
# line 486 "FindHome.puma"
   FindExpHome (exp->OP_EXP.OPND2, & min_home1, & good_home1);
# line 488 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 489 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  }
  if (exp->Kind == kOP1_EXP) {
# line 492 "FindHome.puma"
  {
# line 494 "FindHome.puma"
   FindExpHome (exp->OP1_EXP.OPND, min_home, good_home);
  }
   return;

  }
  if (exp->Kind == kVAR_EXP) {
# line 497 "FindHome.puma"
  {
# line 499 "FindHome.puma"
   FindReadVarHome (exp->VAR_EXP.V, min_home, good_home);
  }
   return;

  }
  if (exp->Kind == kFUNC_CALL_EXP) {
# line 502 "FindHome.puma"
  {
# line 504 "FindHome.puma"
   if (! ((IsPureCall (exp)))) goto yyL5;
  {
# line 506 "FindHome.puma"
   FindParamListHome (exp->FUNC_CALL_EXP.FUNC_PARAMS, min_home, good_home);
  }
  }
   return;
yyL5:;

# line 509 "FindHome.puma"
  {
# line 511 "FindHome.puma"
   if (! ((IsSerialCall (exp)))) goto yyL6;
  {
# line 513 "FindHome.puma"
   FindParamListHome (exp->FUNC_CALL_EXP.FUNC_PARAMS, min_home, good_home);
# line 515 "FindHome.puma"
   MakeNoDescriptor (min_home);
  }
  }
   return;
yyL6:;

# line 520 "FindHome.puma"
  {
# line 522 "FindHome.puma"
   tree_protocol ("function call requires replicated execution : ", exp);
# line 524 "FindHome.puma"
   MakeReplicatedDescriptor (min_home);
# line 525 "FindHome.puma"
   MakeReplicatedDescriptor (good_home);
  }
   return;

  }
# line 528 "FindHome.puma"
  {
# line 530 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 531 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
   return;

;
}

static void FindVarHome
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar min_home, pvar good_home)
# else
(var, min_home, good_home)
 register tTree var;
 pvar min_home;
 pvar good_home;
# endif
{
# line 554 "FindHome.puma"
  {
# line 556 "FindHome.puma"
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  {
# line 558 "FindHome.puma"
   SetVarDescriptor (var, good_home);
# line 559 "FindHome.puma"
   MakeNoDescriptor (min_home);
  }
  }
   return;
yyL1:;

  if (var->Kind == kINDEXED_VAR) {
# line 562 "FindHome.puma"
  {
# line 566 "FindHome.puma"
   FindExpHome (var->INDEXED_VAR.IND_EXPS, min_home, good_home);
  }
   return;

  }
# line 569 "FindHome.puma"
  {
# line 571 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 572 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
   return;

;
}

static void FindReadVarHome
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar min_home, pvar good_home)
# else
(var, min_home, good_home)
 register tTree var;
 pvar min_home;
 pvar good_home;
# endif
{
# line 594 "FindHome.puma"
  {
# line 596 "FindHome.puma"
   if (! ((IsNewVariable (var)))) goto yyL1;
  {
# line 597 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 598 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
  }
   return;
yyL1:;

# line 601 "FindHome.puma"
  {
# line 603 "FindHome.puma"
   FindVarHome (var, min_home, good_home);
# line 605 "FindHome.puma"
   if (! ((IsParallelHomeDescriptor (good_home)))) goto yyL2;
  }
   return;
yyL2:;

# line 608 "FindHome.puma"
  {
# line 610 "FindHome.puma"
   FindVarHome (var, min_home, good_home);
# line 612 "FindHome.puma"
   if (! ((! IsNoDescriptor (good_home)))) goto yyL3;
  {
# line 613 "FindHome.puma"
   if (! ((TreeWriteDistribution (var) == 1))) goto yyL3;
  {
# line 614 "FindHome.puma"
   MakeNoDescriptor (min_home);
  }
  }
  }
   return;
yyL3:;

# line 617 "FindHome.puma"
  {
# line 619 "FindHome.puma"
   MakeParLoopNestDescriptor (good_home);
# line 620 "FindHome.puma"
   MakeNoDescriptor (min_home);
  }
   return;

;
}

static void FindWriteVarHome
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar min_home, pvar good_home)
# else
(var, min_home, good_home)
 register tTree var;
 pvar min_home;
 pvar good_home;
# endif
{
# line 639 "FindHome.puma"
  {
# line 641 "FindHome.puma"
   if (! ((IsNewVariable (var)))) goto yyL1;
  {
# line 643 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 644 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
  }
   return;
yyL1:;

  if (var->Kind == kUSED_VAR) {
# line 647 "FindHome.puma"
  {
# line 651 "FindHome.puma"
   if (! ((TreeRank (var->USED_VAR.VARNAME) == 0))) goto yyL2;
  {
# line 652 "FindHome.puma"
   if (! ((TreeWriteDistribution (var->USED_VAR.VARNAME) == 0))) goto yyL2;
  {
# line 654 "FindHome.puma"
 if (IsParallelMasked ())

        { MakeNoDescriptor (min_home);
          MakeReplicatedDescriptor (good_home);
        }
   
      else

        { MakeNoDescriptor (min_home);
          MakeNoDescriptor (good_home);
        }
   
  }
  }
  }
   return;
yyL2:;

  }
# line 668 "FindHome.puma"
  {
# line 670 "FindHome.puma"
   FindVarHome (var, min_home, good_home);
# line 672 "FindHome.puma"
   if (! ((IsParallelHomeDescriptor (good_home)))) goto yyL3;
  }
   return;
yyL3:;

# line 675 "FindHome.puma"
  {
# line 677 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 678 "FindHome.puma"
   MakeReplicatedDescriptor (good_home);
  }
   return;

;
}

static void FindDescriptorHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 694 "FindHome.puma"
  {
# line 696 "FindHome.puma"
   FindDescriptorHome (t->VAR_PARAM.V, min_home, good_home);
  }
   return;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 699 "FindHome.puma"
  {
# line 701 "FindHome.puma"
   FindDescriptorHome (t->INDEXED_VAR.IND_VAR, min_home, good_home);
  }
   return;

  }
  if (t->Kind == kSELECTED_VAR) {
# line 704 "FindHome.puma"
  {
# line 706 "FindHome.puma"
   MakeReplicatedDescriptor (min_home);
# line 707 "FindHome.puma"
   MakeReplicatedDescriptor (good_home);
  }
   return;

  }
  if (t->Kind == kUSED_VAR) {
# line 710 "FindHome.puma"
  {
# line 712 "FindHome.puma"
   if (! ((IsNewVariable (t)))) goto yyL4;
  {
# line 714 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 715 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
  }
   return;
yyL4:;

# line 718 "FindHome.puma"
  {
# line 720 "FindHome.puma"
   stmt_protocol ("ALLOCATE/DEALLOCATE replicated (not NEW)");
# line 721 "FindHome.puma"
   tree_protocol ("due to this variable : ", t);
# line 723 "FindHome.puma"
   MakeReplicatedDescriptor (min_home);
# line 724 "FindHome.puma"
   MakeReplicatedDescriptor (good_home);
  }
   return;

  }
  if (t->Kind == kBTP_LIST) {
# line 727 "FindHome.puma"
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
# line 729 "FindHome.puma"

# line 730 "FindHome.puma"

# line 732 "FindHome.puma"
   FindDescriptorHome (t->BTP_LIST.Elem, min_home, good_home);
# line 733 "FindHome.puma"
   FindDescriptorHome (t->BTP_LIST.Next, & min_home1, & good_home1);
# line 735 "FindHome.puma"
   UnionHome (min_home, & min_home1);
# line 736 "FindHome.puma"
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  }
  if (t->Kind == kBTP_EMPTY) {
# line 739 "FindHome.puma"
  {
# line 741 "FindHome.puma"
   MakeNoDescriptor (min_home);
# line 742 "FindHome.puma"
   MakeNoDescriptor (good_home);
  }
   return;

  }
# line 745 "FindHome.puma"
  {
# line 747 "FindHome.puma"
   tree_error_protocol ("unknown structure for ALLOCATE/..", t);
# line 749 "FindHome.puma"
   MakeReplicatedDescriptor (min_home);
# line 750 "FindHome.puma"
   MakeReplicatedDescriptor (good_home);
  }
   return;

;
}

static void ChooseHome
# if defined __STDC__ | defined __cplusplus
(pvar home1, pvar home2)
# else
(home1, home2)
 pvar home1;
 pvar home2;
# endif
{
# line 769 "FindHome.puma"
  {
# line 771 "FindHome.puma"

#ifdef DEBUG
     printf ("CHOOSE of ");
     FileUnparse (stdout, PrintableDescriptorVar (home1));
     printf (" and "); 
     FileUnparse (stdout, PrintableDescriptorVar (home2));
     printf (" = ");
#endif
     ChooseBestHome (home1, home2);
#ifdef DEBUG
     FileUnparse (stdout, PrintableDescriptorVar (home1));
     printf ("\n");
#endif 
   
  }
   return;

;
}

static void ChooseBestHome
# if defined __STDC__ | defined __cplusplus
(pvar home1, pvar home2)
# else
(home1, home2)
 pvar home1;
 pvar home2;
# endif
{
# line 795 "FindHome.puma"
  {
# line 797 "FindHome.puma"
   if (! ((IsNoDescriptor (home1)))) goto yyL1;
  {
# line 798 "FindHome.puma"
 *home1 = *home2; 
  }
  }
   return;
yyL1:;

# line 801 "FindHome.puma"
  {
# line 803 "FindHome.puma"
   if (! ((IsNoDescriptor (home2)))) goto yyL2;
  }
   return;
yyL2:;

# line 814 "FindHome.puma"
  {
# line 816 "FindHome.puma"
   if (! ((home1 -> var_tree != NoTree))) goto yyL3;
  {
# line 817 "FindHome.puma"
   if (! ((home2 -> var_tree == NoTree))) goto yyL3;
  }
  }
   return;
yyL3:;

# line 820 "FindHome.puma"
  {
# line 822 "FindHome.puma"
   if (! ((home1 -> var_tree == NoTree))) goto yyL4;
  {
# line 823 "FindHome.puma"
   if (! ((home2 -> var_tree != NoTree))) goto yyL4;
  {
# line 825 "FindHome.puma"
 *home1 = *home2; 
  }
  }
  }
   return;
yyL4:;

# line 843 "FindHome.puma"
  {
# line 845 "FindHome.puma"
   if (! ((IsParallelHomeDescriptor (home1)))) goto yyL5;
  {
# line 846 "FindHome.puma"
   if (! ((! IsParallelHomeDescriptor (home2)))) goto yyL5;
  }
  }
   return;
yyL5:;

# line 849 "FindHome.puma"
  {
# line 851 "FindHome.puma"
   if (! ((! IsParallelHomeDescriptor (home1)))) goto yyL6;
  {
# line 852 "FindHome.puma"
   if (! ((IsParallelHomeDescriptor (home2)))) goto yyL6;
  {
# line 854 "FindHome.puma"
 *home1 = *home2; 
  }
  }
  }
   return;
yyL6:;

# line 863 "FindHome.puma"
  {
# line 865 "FindHome.puma"
   if (! ((home1 -> topology_rank > 0))) goto yyL7;
  {
# line 866 "FindHome.puma"
   if (! ((home2 -> topology_rank == 0))) goto yyL7;
  }
  }
   return;
yyL7:;

# line 869 "FindHome.puma"
  {
# line 871 "FindHome.puma"
   if (! ((home1 -> topology_rank == 0))) goto yyL8;
  {
# line 872 "FindHome.puma"
   if (! ((home2 -> topology_rank > 0))) goto yyL8;
  {
# line 874 "FindHome.puma"
 *home1 = *home2; 
  }
  }
  }
   return;
yyL8:;

# line 877 "FindHome.puma"
   return;

;
}

static void UnionHome
# if defined __STDC__ | defined __cplusplus
(pvar home1, pvar home2)
# else
(home1, home2)
 pvar home1;
 pvar home2;
# endif
{
# line 897 "FindHome.puma"
  {
# line 899 "FindHome.puma"

#ifdef DEBUG
     printf ("UNION of ");
     FileUnparse (stdout, PrintableDescriptorVar (home1));
     printf (" and "); 
     FileUnparse (stdout, PrintableDescriptorVar (home2));
     printf (" = ");
#endif
     UnionHomeDescriptor (home1, home2);
#ifdef DEBUG
     FileUnparse (stdout, PrintableDescriptorVar (home1));
     printf ("\n");
#endif 
   
  }
   return;

;
}

static void ExpandHomes
# if defined __STDC__ | defined __cplusplus
(pvar min_home, pvar good_home, register tTree id)
# else
(min_home, good_home, id)
 pvar min_home;
 pvar good_home;
 register tTree id;
# endif
{
# line 923 "FindHome.puma"
 {
  bool okay;
  {
# line 925 "FindHome.puma"

# line 927 "FindHome.puma"

#ifdef DEBUG
     printf ("EXPAND of min_home ");
     FileUnparse (stdout, PrintableDescriptorVar (min_home));
     printf (" = ");
#endif

     ExpandDescriptor (min_home, id, &okay);

#ifdef DEBUG
     FileUnparse (stdout, PrintableDescriptorVar (min_home));
     printf ("\n");
#endif 

     if (!okay)

       { stmt_protocol ("minimal home of loop body not expanded");
         tree_protocol ("minimal home of loop body is : ", 
                         MakeDescriptorVar (min_home));
         MakeReplicatedDescriptor (min_home);
       }

#ifdef DEBUG
     printf ("EXPAND of good_home ");
     FileUnparse (stdout, PrintableDescriptorVar (good_home));
     printf (" = ");
#endif

     ExpandDescriptor (good_home, id, &okay);

#ifdef DEBUG
     FileUnparse (stdout, PrintableDescriptorVar (good_home));
     printf ("\n");
#endif 

     if (!okay)

       { stmt_protocol ("good home of loop body not expanded");
         tree_protocol ("good home of loop body is : ", 
                         MakeDescriptorVar (good_home));
         MakeReplicatedDescriptor (good_home);
       }
   
  }
   return;
 }

;
}

static void PrintHomes
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
# line 980 "FindHome.puma"
  {
# line 982 "FindHome.puma"
 
#ifdef DEBUG
      printf ("HOME of ");
      FileUnparse (stdout, t);
      printf (" is min = ");
      FileUnparse (stdout, PrintableDescriptorVar (min_home));
      printf (" and good = ");
      FileUnparse (stdout, PrintableDescriptorVar (good_home));
      printf ("\n");
#endif 
   
  }
   return;

;
}

void FindSerialHome
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home, register bool * yyP1)
# else
(stmt, home, yyP1)
 register tTree stmt;
 pvar home;
 register bool * yyP1;
# endif
{
  if (stmt->Kind == kCALL_STMT) {
# line 1005 "FindHome.puma"
 {
  bool yyV1;
  {
# line 1007 "FindHome.puma"
   FindSerialHome (stmt->CALL_STMT.CALL_PARAMS, home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (stmt->Kind == kASSIGN_STMT) {
  if (stmt->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 1010 "FindHome.puma"
 {
  var_descriptor min_home;
  {
# line 1012 "FindHome.puma"

# line 1014 "FindHome.puma"
   FindVarHome (stmt->ASSIGN_STMT.ASSIGN_VAR, & min_home, home);
# line 1016 "FindHome.puma"
   if (! ((IsNoDescriptor (& min_home)))) goto yyL2;
  {
# line 1017 "FindHome.puma"
   if (! ((IsSerialDescriptor (home)))) goto yyL2;
  {
# line 1018 "FindHome.puma"
   if (! ((! CountCommunication (home, stmt->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL2;
  {
# line 1019 "FindHome.puma"
   if (! ((! CountCommunication (home, stmt->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  }
  }
  }
  }
   * yyP1 = true;
   return;
 }
yyL2:;

  }
  }
  if (stmt->Kind == kBTP_LIST) {
# line 1022 "FindHome.puma"
 {
  var_descriptor min_home;
  {
# line 1024 "FindHome.puma"

# line 1026 "FindHome.puma"
   FindParamListHome (stmt, & min_home, home);
# line 1028 "FindHome.puma"
   if (! ((IsNoDescriptor (& min_home)))) goto yyL3;
  {
# line 1029 "FindHome.puma"
   if (! ((IsSerialDescriptor (home)))) goto yyL3;
  {
# line 1030 "FindHome.puma"
   if (! ((! CountCommunication (home, stmt)))) goto yyL3;
  }
  }
  }
   * yyP1 = true;
   return;
 }
yyL3:;

  }
# line 1033 "FindHome.puma"
   * yyP1 = false;
   return;

;
}

void BeginFindHome ()
{
}

void CloseFindHome ()
{
}
