# include "FinalCode.h"
# include "yyFinalCode.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 27 "FinalCode.puma"


# include <stdio.h>
# include <string.h>

# include "protocol.h"
# include "Idents.h"

# include "Objects.h"
# include "TreeOps.h"
# include "Transform.h"
# include "Expressions.h"
# include "Dalib.h" 
# include "Types.h"         /* TreeType */
# include "Nesting.h"
# include "Traverse.h"
# include "Reductions.h"    /* GetGlobalOp, GetReductionZero */

# include "SMParallel.h"    /* AutoScope                     */

# include "CodeGeneral.h"

/*********************************************************************
*                                                                    *
*  Note : NewHelpVars of Module 'Dalib' is also used                 *
*                                                                    *
*********************************************************************/

static tTree NewInitStatements;

# define MODULE "FinalCode"



static void yyExit () { Exit (1); }

void (* FinalCode_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module FinalCode, routine %s failed\n", yyFunction);
 FinalCode_Exit ();
}

void FinalCode ARGS((tTree t));
static void FinalBodyCode ARGS((tTree body));
static bool StopCode ARGS((tTree t));
static tTree ChangeCode ARGS((tTree t));
static void RemoveOverlaps ARGS((tTree t));
static tTree TranslateRankExp ARGS((int kind));
static tTree TranslateBoundExp ARGS((tTree t));
static tIdent GetBoundId ARGS((int kind, int local));
static void GenTraceStatements ARGS((tTree body, tIdent subroutine_name));
static void MakeFinalIntrFuncCall ARGS((tTree func_call));
static bool IsKindIntrinsic ARGS((tIdent name));
static void RemoveKindParam ARGS((tTree params));
static void RemoveIndexBackParam ARGS((tTree params));
static bool IsFalseParam ARGS((tTree t));
static void MakeFullParam ARGS((tTree param));
static bool IsDalibRoutine ARGS((tIdent name));
static tIdent MakeDalibRoutine ARGS((tIdent name));
static void SetInitStmt ARGS((tTree body));
static tTree NotPresentArgument ARGS(());
static tTree NotPresentString ARGS(());
static void MakeFinalIntrSubCall ARGS((tTree call));
static tIdent MakeTypedDalibRoutine ARGS((tIdent name, tTree params));
static void GenModuleInit ARGS((tTree body, tIdent module_name));
static tIdent MakeInitRoutineName ARGS((tIdent module_name));
static tIdent MakeInitVarName ARGS((tIdent module_name));
static tTree MakeModuleInitCall ARGS((tIdent module_name));

void FinalCode
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 69 "FinalCode.puma"
  {
# line 71 "FinalCode.puma"
   open_protocol ("adaptor.final");
# line 72 "FinalCode.puma"
   FinalCode (t->COMP_UNIT.COMP_ELEMENTS);
# line 73 "FinalCode.puma"
   close_protocol ();
  }
   return;

  case kUNIT_LIST:
# line 76 "FinalCode.puma"
  {
# line 78 "FinalCode.puma"
   FinalCode (t->UNIT_LIST.Elem);
# line 79 "FinalCode.puma"
   FinalCode (t->UNIT_LIST.Next);
  }
   return;

  case kUNIT_EMPTY:
# line 82 "FinalCode.puma"
   return;

  case kPROGRAM_DECL:
# line 85 "FinalCode.puma"
  {
# line 87 "FinalCode.puma"
   NestOpenUnit (t);
# line 88 "FinalCode.puma"
   GenTraceStatements (t->PROGRAM_DECL.PROGRAM_BODY, t->PROGRAM_DECL.Ident);
# line 89 "FinalCode.puma"
   FinalBodyCode (t->PROGRAM_DECL.PROGRAM_BODY);
# line 90 "FinalCode.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 93 "FinalCode.puma"
  {
# line 96 "FinalCode.puma"
   NestOpenUnit (t);
# line 98 "FinalCode.puma"
   GenTraceStatements (t->PROC_DECL.PROC_BODY, t->PROC_DECL.Ident);
# line 100 "FinalCode.puma"
   FinalBodyCode (t->PROC_DECL.PROC_BODY);
# line 102 "FinalCode.puma"
 t->PROC_DECL.IsPure = false;        
      t->PROC_DECL.HPFExtrinsic  = DefaultId();  
    
# line 106 "FinalCode.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 109 "FinalCode.puma"
  {
# line 113 "FinalCode.puma"
   NestOpenUnit (t);
# line 115 "FinalCode.puma"
   GenTraceStatements (t->FUNC_DECL.FUNC_BODY, t->FUNC_DECL.Ident);
# line 117 "FinalCode.puma"
   FinalBodyCode (t->FUNC_DECL.FUNC_BODY);
# line 119 "FinalCode.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 122 "FinalCode.puma"
  {
# line 124 "FinalCode.puma"
   NestOpenUnit (t);
# line 126 "FinalCode.puma"
   FinalBodyCode (t->MODULE_DECL.MODULE_BODY);
# line 128 "FinalCode.puma"
   GenModuleInit (t->MODULE_DECL.MODULE_BODY, t->MODULE_DECL.Ident);
# line 130 "FinalCode.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 133 "FinalCode.puma"
  {
# line 135 "FinalCode.puma"
   NestOpenUnit (t);
# line 137 "FinalCode.puma"
   FinalBodyCode (t->BLOCK_DATA_DECL.DATA_BODY);
# line 139 "FinalCode.puma"
   NestCloseUnit (t);
  }
   return;

  }

# line 142 "FinalCode.puma"
  {
# line 143 "FinalCode.puma"
   failure_protocol (MODULE, "FinalCode", t);
  }
   return;

;
}

static void FinalBodyCode
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 154 "FinalCode.puma"
  {
# line 156 "FinalCode.puma"
   RemoveOverlaps (body->BODY_NODE.DECLS);
# line 158 "FinalCode.puma"
   NewHelpVars = mDECL_EMPTY ();
# line 159 "FinalCode.puma"
   NewInitStatements = NoTree;
# line 161 "FinalCode.puma"
 body->BODY_NODE.DECLS = ReplaceAST (body->BODY_NODE.DECLS, StopCode, ChangeCode); 
      body->BODY_NODE.STATS = ReplaceAST (body->BODY_NODE.STATS, StopCode, ChangeCode);

      

      body->BODY_NODE.STATS = CombineACF (NewInitStatements, body->BODY_NODE.STATS);

      

      if (IsMainUnit (GetCurrentUnit ()))
  
          SetInitStmt (body);

      body->BODY_NODE.DECLS = AppendDECLS (body->BODY_NODE.DECLS, NewHelpVars);
    
# line 177 "FinalCode.puma"
   FinalCode (body->BODY_NODE.INTERNALS);
  }
   return;

  }
# line 180 "FinalCode.puma"
  {
# line 181 "FinalCode.puma"
   failure_protocol (MODULE, "FinalBodyCode", body);
  }
   return;

;
}

static bool StopCode
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 186 "FinalCode.puma"
  {
# line 187 "FinalCode.puma"
   return false;
  }

}

static tTree ChangeCode
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kUSE_DECL:
# line 200 "FinalCode.puma"
  {
# line 202 "FinalCode.puma"
   if (! ((t->USE_DECL.use == IsIdent ("HPF_LIBRARY")))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 207 "FinalCode.puma"
  {
# line 209 "FinalCode.puma"
   if (! ((t->USE_DECL.use == IsIdent ("HPF_LOCAL_LIBRARY")))) goto yyL2;
  }
   return NoTree;
yyL2:;

# line 214 "FinalCode.puma"
  {
# line 216 "FinalCode.puma"
   if (! ((t->USE_DECL.use == IsIdent ("HPF_TASK_LIBRARY")))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 221 "FinalCode.puma"
  {
# line 223 "FinalCode.puma"
   NewInitStatements = CombineACF (MakeModuleInitCall (t->USE_DECL.use), NewInitStatements);
  }
   return t;

  case kONLY_USE_DECL:
# line 229 "FinalCode.puma"
  {
# line 231 "FinalCode.puma"
   NewInitStatements = CombineACF (MakeModuleInitCall (t->ONLY_USE_DECL.use), NewInitStatements);
  }
   return t;

  case kVAR_DECL:
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 237 "FinalCode.puma"
  {
# line 239 "FinalCode.puma"
   RemoveOverlaps (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
  }
   return t;

  }
  break;
  case kTEMPLATE_DECL:
# line 243 "FinalCode.puma"
  {
# line 245 "FinalCode.puma"
   RemoveOverlaps (t->TEMPLATE_DECL.DIMENSIONS);
  }
   return t;

  case kBOUND_EXP:
# line 249 "FinalCode.puma"
   return TranslateBoundExp (t);

  case kRANK_EXP:
# line 254 "FinalCode.puma"
   return TranslateRankExp (t->RANK_EXP.kind);

  case kCALL_STMT:
# line 259 "FinalCode.puma"
  {
# line 261 "FinalCode.puma"
   if (! ((IsIntrCall (t)))) goto yyL10;
  {
# line 263 "FinalCode.puma"
   MakeFinalIntrSubCall (t);
  }
  }
   return t;
yyL10:;

  break;
  case kFUNC_CALL_EXP:
# line 268 "FinalCode.puma"
  {
# line 270 "FinalCode.puma"
   if (! ((IsIntrCall (t)))) goto yyL11;
  {
# line 272 "FinalCode.puma"
   MakeFinalIntrFuncCall (t);
  }
  }
   return t;
yyL11:;

  break;
  case kNO_PARAM:
# line 277 "FinalCode.puma"
  {
# line 279 "FinalCode.puma"
   if (! ((t->NO_PARAM.type == kSTRING_TYPE))) goto yyL12;
  }
   return NotPresentString ();
yyL12:;

# line 284 "FinalCode.puma"
   return NotPresentArgument ();

  case kACF_PARALLEL:
# line 289 "FinalCode.puma"
  {
# line 291 "FinalCode.puma"
   AutoScope (t);
  }
   return FinalSM (t);

  }

# line 296 "FinalCode.puma"
   return t;

}

static void RemoveOverlaps
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHAPE_LIST) {
# line 310 "FinalCode.puma"
  {
# line 311 "FinalCode.puma"
   RemoveOverlaps (t->SHAPE_LIST.Elem);
# line 312 "FinalCode.puma"
   RemoveOverlaps (t->SHAPE_LIST.Next);
  }
   return;

  }
  if (Tree_IsType (t, kSHAPE_SPEC)) {
# line 315 "FinalCode.puma"
  {
# line 316 "FinalCode.puma"
   RemoveOverlaps (t->SHAPE_SPEC.Overlap);
  }
   return;

  }
  if (t->Kind == kOVERLAP_SPEC) {
# line 319 "FinalCode.puma"
  {
# line 320 "FinalCode.puma"
   t->OVERLAP_SPEC.left_size = 0;
# line 321 "FinalCode.puma"
   t->OVERLAP_SPEC.right_size = 0;
  }
   return;

  }
;
}

static tTree TranslateRankExp
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
# line 335 "FinalCode.puma"
 {
  tTree call;
  tIdent name;
  {
# line 337 "FinalCode.puma"

# line 338 "FinalCode.puma"

# line 340 "FinalCode.puma"
 if (kind == 0)
       name = MakeDalibId ("processors_rank");
     else
       name = MakeDalibId ("active_procs_rank");
    DefineNewHelpFn (name);
    call = mFUNC_CALL_EXP (mPROC_OBJ (name), mBTP_EMPTY ());
  
  }
  {
   return call;
  }
 }

}

static tTree TranslateBoundExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBOUND_EXP) {
# line 359 "FinalCode.puma"
 {
  tTree call;
  tIdent name;
  {
# line 361 "FinalCode.puma"

# line 362 "FinalCode.puma"

# line 364 "FinalCode.puma"
 call = mBTP_LIST (ExpToVarParam (MakeConstant(t->BOUND_EXP.dim)), mBTP_EMPTY ());
     call = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (t->BOUND_EXP.VAR, "_DSP")), call);
     name = GetBoundId (t->BOUND_EXP.kind, t->BOUND_EXP.local);
     DefineNewHelpFn (name);
     call = mFUNC_CALL_EXP (mPROC_OBJ (name), call);
   
  }
  {
   return call;
  }
 }

  }
# line 373 "FinalCode.puma"
  {
# line 374 "FinalCode.puma"
   failure_protocol (MODULE, "TranslateBoundExp", t);
  }
   return NoTree;

}

static tIdent GetBoundId
# if defined __STDC__ | defined __cplusplus
(register int kind, register int local)
# else
(kind, local)
 register int kind;
 register int local;
# endif
{
# line 390 "FinalCode.puma"
  {
# line 392 "FinalCode.puma"
   if (! ((kind == 0))) goto yyL1;
  {
# line 393 "FinalCode.puma"
   if (! ((local == 0))) goto yyL1;
  }
  }
   return MakeDalibId ("lbound");
yyL1:;

# line 398 "FinalCode.puma"
  {
# line 400 "FinalCode.puma"
   if (! ((kind == 0))) goto yyL2;
  {
# line 401 "FinalCode.puma"
   if (! ((local == 1))) goto yyL2;
  }
  }
   return MakeDalibId ("local_lbound");
yyL2:;

# line 406 "FinalCode.puma"
  {
# line 408 "FinalCode.puma"
   if (! ((kind == 0))) goto yyL3;
  {
# line 409 "FinalCode.puma"
   if (! ((local == 2))) goto yyL3;
  }
  }
   return MakeDalibId ("global_lbound");
yyL3:;

# line 414 "FinalCode.puma"
  {
# line 416 "FinalCode.puma"
   if (! ((kind == 1))) goto yyL4;
  {
# line 417 "FinalCode.puma"
   if (! ((local == 0))) goto yyL4;
  }
  }
   return MakeDalibId ("ubound");
yyL4:;

# line 421 "FinalCode.puma"
  {
# line 423 "FinalCode.puma"
   if (! ((kind == 1))) goto yyL5;
  {
# line 424 "FinalCode.puma"
   if (! ((local == 1))) goto yyL5;
  }
  }
   return MakeDalibId ("local_ubound");
yyL5:;

# line 429 "FinalCode.puma"
  {
# line 431 "FinalCode.puma"
   if (! ((kind == 1))) goto yyL6;
  {
# line 432 "FinalCode.puma"
   if (! ((local == 2))) goto yyL6;
  }
  }
   return MakeDalibId ("global_ubound");
yyL6:;

# line 437 "FinalCode.puma"
  {
# line 439 "FinalCode.puma"
   failure_protocol (MODULE, "GetBoundId", NoTree);
  }
   return MakeDalibId ("unknown");

}

static void GenTraceStatements
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tIdent subroutine_name)
# else
(body, subroutine_name)
 register tTree body;
 register tIdent subroutine_name;
# endif
{
# line 458 "FinalCode.puma"

char subroutine_string [256];
int  subroutine_length;
tStringRef ref;

  if (body->Kind == kBODY_NODE) {
# line 464 "FinalCode.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 466 "FinalCode.puma"

# line 467 "FinalCode.puma"

# line 469 "FinalCode.puma"
 stmt = mPROC_OBJ (MakeDalibId ("start_subroutine"));
 
    GetString (subroutine_name, subroutine_string);
    subroutine_length = strlen (subroutine_string);
 
    ref = PutString (subroutine_string, subroutine_length);
 
    params = mBTP_EMPTY ();
    params = mBTP_LIST (ExpToVarParam (MakeConstant (subroutine_length)),
                        params);
    params = mBTP_LIST (ExpToVarParam (mCONST_EXP (mSTRING_CONSTANT (ref))),
                        params);
 
    stmt = mACF_BASIC (mCALL_STMT (stmt, params));
 
    body->BODY_NODE.STATS = mACF_LIST (stmt, body->BODY_NODE.STATS);
 
    stmt = mPROC_OBJ (MakeDalibId ("end_subroutine"));
    stmt = mACF_BASIC (mCALL_STMT (stmt, mBTP_EMPTY()));
    stmt = mACF_LIST (stmt, mACF_EMPTY());
 
    body->BODY_NODE.STATS = CombineACF (body->BODY_NODE.STATS, stmt);
 
  
  }
   return;
 }

  }
# line 495 "FinalCode.puma"
  {
# line 496 "FinalCode.puma"
   failure_protocol (MODULE, "GenTraceStatements", body);
  }
   return;

;
}

static void MakeFinalIntrFuncCall
# if defined __STDC__ | defined __cplusplus
(register tTree func_call)
# else
(func_call)
 register tTree func_call;
# endif
{
  if (func_call->Kind == kFUNC_CALL_EXP) {
# line 510 "FinalCode.puma"
  {
# line 512 "FinalCode.puma"
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("NUMBER_OF_PROCESSORS")))) goto yyL1;
  {
# line 514 "FinalCode.puma"
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibId ("all_procs");
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
   
  }
  }
   return;
yyL1:;

# line 519 "FinalCode.puma"
  {
# line 521 "FinalCode.puma"
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("ACTIVE_NUM_PROCS")))) goto yyL2;
  {
# line 523 "FinalCode.puma"
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibId ("active_procs");
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
   
  }
  }
   return;
yyL2:;

# line 528 "FinalCode.puma"
  {
# line 530 "FinalCode.puma"
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("MY_PROCESSOR")))) goto yyL3;
  {
# line 532 "FinalCode.puma"
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibId ("my_processor");
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
   
  }
  }
   return;
yyL3:;

# line 537 "FinalCode.puma"
  {
# line 539 "FinalCode.puma"
   if (! ((IsKindIntrinsic (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL4;
  {
# line 540 "FinalCode.puma"
   RemoveKindParam (func_call->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL4:;

# line 543 "FinalCode.puma"
  {
# line 545 "FinalCode.puma"
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("INDEX")))) goto yyL5;
  {
# line 546 "FinalCode.puma"
   RemoveIndexBackParam (func_call->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL5:;

# line 549 "FinalCode.puma"
  {
# line 551 "FinalCode.puma"
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("PRESENT")))) goto yyL6;
  {
# line 553 "FinalCode.puma"
   MakeFullParam (func_call->FUNC_CALL_EXP.FUNC_PARAMS);
# line 555 "FinalCode.puma"
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibRoutine (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
    
  }
  }
   return;
yyL6:;

# line 560 "FinalCode.puma"
  {
# line 562 "FinalCode.puma"
   if (! ((IsDalibRoutine (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL7;
  {
# line 564 "FinalCode.puma"
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibRoutine (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
    
  }
  }
   return;
yyL7:;

# line 569 "FinalCode.puma"
   return;

  }
# line 572 "FinalCode.puma"
  {
# line 573 "FinalCode.puma"
   failure_protocol (MODULE, "MakeFinalIntrFuncCall", func_call);
  }
   return;

;
}

static bool IsKindIntrinsic
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("AINT"))) {
# line 586 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("INT"))) {
# line 587 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("ANINT"))) {
# line 588 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("NINT"))) {
# line 589 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("CHAR"))) {
# line 590 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("CMPLX"))) {
# line 591 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("REAL"))) {
# line 592 "FinalCode.puma"
   return true;

  }
  return false;
}

static void RemoveKindParam
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 596 "FinalCode.puma"
  {
# line 598 "FinalCode.puma"
 params->BTP_LIST.Next = params->BTP_LIST.Next->BTP_LIST.Next; 
  }
   return;

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 601 "FinalCode.puma"
  {
# line 603 "FinalCode.puma"
 params->BTP_LIST.Next->BTP_LIST.Next = params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next; 
  }
   return;

  }
  }
  }
  }
;
}

static void RemoveIndexBackParam
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 616 "FinalCode.puma"
  {
# line 618 "FinalCode.puma"
   if (! ((IsFalseParam (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem)))) goto yyL1;
  {
# line 619 "FinalCode.puma"
 params->BTP_LIST.Next->BTP_LIST.Next = params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next; 
  }
  }
   return;
yyL1:;

  }
  }
  }
  }
;
}

static bool IsFalseParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
  if (t->VAR_PARAM.V->ADDR.E->Kind == kCONST_EXP) {
  if (t->VAR_PARAM.V->ADDR.E->CONST_EXP.C->Kind == kBOOL_CONSTANT) {
  if (equalint (t->VAR_PARAM.V->ADDR.E->CONST_EXP.C->BOOL_CONSTANT.value, 0)) {
# line 624 "FinalCode.puma"
   return true;

  }
  }
  }
  }
  }
  return false;
}

static void MakeFullParam
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (param->BTP_LIST.Elem->VAR_PARAM.V->Kind == kINDEXED_VAR) {
# line 635 "FinalCode.puma"
  {
# line 637 "FinalCode.puma"
 param->BTP_LIST.Elem->VAR_PARAM.V = param->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_VAR; 
  }
   return;

  }
  }
  }
;
}

static bool IsDalibRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("PRESENT"))) {
# line 653 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("ALLOCATED"))) {
# line 656 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_INT_KIND"))) {
# line 659 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_REAL_KIND"))) {
# line 662 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("VERIFY"))) {
# line 667 "FinalCode.puma"
   return true;

  }
# line 670 "FinalCode.puma"
  {
# line 671 "FinalCode.puma"
   if (! ((target_language == FORTRAN_90))) goto yyL6;
  {
# line 672 "FinalCode.puma"
   return false;
  }
  }
yyL6:;

  if (equaltIdent (name, IsIdent ("CEILING"))) {
# line 675 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("FLOOR"))) {
# line 678 "FinalCode.puma"
   return true;

  }
  if (equaltIdent (name, IsIdent ("LEN_TRIM"))) {
# line 681 "FinalCode.puma"
   return true;

  }
  return false;
}

static tIdent MakeDalibRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 697 "FinalCode.puma"
 char new_name [100]; 
# line 699 "FinalCode.puma"
  {
# line 703 "FinalCode.puma"
   GetString (name, new_name);
  }
   return MakeDalibId (new_name);

}

static void SetInitStmt
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 723 "FinalCode.puma"
 {
  tTree stmt;
  tTree param;
  {
# line 725 "FinalCode.puma"

# line 726 "FinalCode.puma"

# line 728 "FinalCode.puma"
 stmt  = mPROC_OBJ (MakeDalibId ("set_present"));
    param = mBTP_LIST (NotPresentString(), mBTP_EMPTY());
    param = mBTP_LIST (NotPresentArgument(), param);
    stmt  = mACF_BASIC (mCALL_STMT (stmt, param));
    body->BODY_NODE.STATS = mACF_LIST (stmt, body->BODY_NODE.STATS);

    stmt  = mPROC_OBJ (MakeDalibId ("init"));
    param = mBTP_EMPTY ();
    param = mBTP_LIST (ExpToVarParam (MakeConstant (default_addr_size)), 
                       param);
    param = mBTP_LIST (ExpToVarParam (MakeConstant (default_real_size)), 
                       param);
    param = mBTP_LIST (ExpToVarParam (MakeConstant (default_int_size)), 
                       param);
    stmt  = mACF_BASIC (mCALL_STMT (stmt, param));
    body->BODY_NODE.STATS = mACF_LIST (stmt, body->BODY_NODE.STATS);
 
    stmt = mPROC_OBJ (MakeDalibId ("exit"));
    stmt = mACF_BASIC (mCALL_STMT (stmt, mBTP_EMPTY()));
    stmt = mACF_LIST (stmt, mACF_EMPTY());
 
    body->BODY_NODE.STATS = CombineACF (body->BODY_NODE.STATS, stmt);
 
  
  }
   return;
 }

  }
# line 754 "FinalCode.puma"
  {
# line 756 "FinalCode.puma"
   failure_protocol (MODULE, "SetInitStmt", body);
  }
   return;

;
}

static tTree NotPresentArgument
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 772 "FinalCode.puma"
 {
  tTree param;
  {
# line 773 "FinalCode.puma"

# line 775 "FinalCode.puma"
 DefineNewCommonVar (MakeDalibId ("data0"), MakeDalibId ("0"));
     param = mVAR_OBJ (0, MakeDalibId ("0"));
     param = mVAR_PARAM (mUSED_VAR (param));
   
  }
  {
   return param;
  }
 }

}

static tTree NotPresentString
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 785 "FinalCode.puma"
 {
  tTree param;
  {
# line 786 "FinalCode.puma"

# line 788 "FinalCode.puma"
 DefineNewCommonVar (MakeDalibId ("data1"), MakeDalibId ("1"));
     param = mVAR_OBJ (0, MakeDalibId ("1"));
     param = mVAR_PARAM (mUSED_VAR (param));
   
  }
  {
   return param;
  }
 }

}

static void MakeFinalIntrSubCall
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
# line 806 "FinalCode.puma"

char string[50];
int  op, len, up;
tIdent func_id;

  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 812 "FinalCode.puma"
 {
  tTree new_params;
  tTree new_param;
  {
# line 814 "FinalCode.puma"
   if (! ((IntrFuncScan (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident)))) goto yyL1;
  {
# line 816 "FinalCode.puma"

# line 817 "FinalCode.puma"

# line 819 "FinalCode.puma"
 GetString (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident, string);
      len = strlen (string);

      if (string[len-6] == 'P')
         up = 1;                         
        else
         up = 0;                         

      if (TreeListLength (call->CALL_STMT.CALL_PARAMS) == 12)
        { if (up)
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_prefix_array");
           else
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_suffix_array");
        }
       else if (TreeListLength (call->CALL_STMT.CALL_PARAMS) == 10)
        { if (up)
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_prefix_mask");
           else
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_suffix_mask");
        }
       else 
        { if (up)
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_prefix_copy");
           else
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_suffix_copy");
        }

      func_id = MakeIdent (string, len-7);    

      new_params = call->CALL_STMT.CALL_PARAMS;

      

      if (TreeListLength (call->CALL_STMT.CALL_PARAMS) > 8)

       { new_param  = GetReductionZero (TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), func_id);
         new_param  = ExpToVarParam (new_param);
         new_params = mBTP_LIST (new_param, new_params);

         op = GetGlobalOp (TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), func_id);

         new_param  = ExpToVarParam (MakeConstant (op));
         new_params = mBTP_LIST (new_param, new_params);

         call->CALL_STMT.CALL_PARAMS    = new_params;
       }

    
  }
  }
   return;
 }
yyL1:;

# line 869 "FinalCode.puma"
 {
  int op;
  tTree type;
  {
# line 871 "FinalCode.puma"
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("MATMUL")))) goto yyL2;
  {
# line 873 "FinalCode.puma"

# line 874 "FinalCode.puma"

# line 876 "FinalCode.puma"
  

      type = TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);

      if (type->Kind != kBOOLEAN_TYPE)
          op = GetGlobalOp (TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), IsIdent ("SUM"));
        else
          op = GetGlobalOp (TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), IsIdent ("ANY"));

      call->CALL_STMT.CALL_PARAMS  = mBTP_LIST (ExpToVarParam (MakeConstant (op)), call->CALL_STMT.CALL_PARAMS);

      call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = MakeDalibRoutine (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident);
    
  }
  }
   return;
 }
yyL2:;

  }
  }
# line 891 "FinalCode.puma"
  {
# line 893 "FinalCode.puma"
 call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = MakeTypedDalibRoutine (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident, call->CALL_STMT.CALL_PARAMS); 
  }
   return;

  }
;
}

static tIdent MakeTypedDalibRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
# line 905 "FinalCode.puma"

char tstring[256];
tIdent typed_name;
type_rec t;

  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 911 "FinalCode.puma"
  {
# line 913 "FinalCode.puma"
   if (! (((name == IsIdent ("GRADE_UP")) || (name == IsIdent ("GRADE_DOWN")) || (name == IsIdent ("SORT_DOWN")) || (name == IsIdent ("SORT_UP"))))) goto yyL1;
  {
# line 919 "FinalCode.puma"
 GetString (name, tstring);
     GetParamType (params->BTP_LIST.Next->BTP_LIST.Elem, &t);
     if (t.type_kind == kREAL_TYPE) strcat (tstring, "_R");
     if (t.type_kind == kCOMPLEX_TYPE) strcat (tstring, "_C");
     if (t.type_kind == kBOOLEAN_TYPE) strcat (tstring, "_L");
     if (t.type_kind == kINTEGER_TYPE) strcat (tstring, "_I");
     if (t.type_kind == kSTRING_TYPE) strcat (tstring, "_S");
     typed_name = IsIdent (tstring);
   
  }
  }
   return MakeDalibRoutine (typed_name);
yyL1:;

# line 932 "FinalCode.puma"
  {
# line 934 "FinalCode.puma"
   if (! (((name == IsIdent ("SORT_UP")) || (name == IsIdent ("SORT_DOWN"))))) goto yyL2;
  {
# line 937 "FinalCode.puma"
 GetString (name, tstring);
     GetParamType (params->BTP_LIST.Next->BTP_LIST.Elem, &t);
     if (t.type_kind == kREAL_TYPE) strcat (tstring, "_R");
     if (t.type_kind == kSTRING_TYPE) strcat (tstring, "_S");
     if (t.type_kind == kINTEGER_TYPE) strcat (tstring, "_I");
     typed_name = IsIdent (tstring);
   
  }
  }
   return MakeDalibRoutine (typed_name);
yyL2:;

  }
  }
# line 948 "FinalCode.puma"
   return MakeDalibRoutine (name);

}

static void GenModuleInit
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tIdent module_name)
# else
(body, module_name)
 register tTree body;
 register tIdent module_name;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 963 "FinalCode.puma"
 {
  tTree init_unit;
  tIdent init_name;
  tTree init_decls;
  tTree init_decl;
  tTree init_var;
  tTree init_exp;
  {
# line 965 "FinalCode.puma"

# line 966 "FinalCode.puma"

# line 967 "FinalCode.puma"

# line 968 "FinalCode.puma"

# line 969 "FinalCode.puma"

# line 970 "FinalCode.puma"

# line 972 "FinalCode.puma"
 init_name  = MakeInitVarName (module_name);
      init_var   = mUSED_VAR (mVAR_OBJ (0, init_name));

      /******************************************************
      *   INTEGER*4 INIT_H1_<module_name>                   *
      *   DATA INIT_H1_M0 / 0 /                             *
      ******************************************************/

      init_decls = mDECL_EMPTY ();
      init_decl  = mDATA_DECL (DefaultId(), 0,
                               mBTV_LIST (CopyTree (init_var), mBTV_EMPTY()),
                               mBTE_LIST (MakeConstant (0), mBTE_EMPTY ()));
      init_decls = mDECL_LIST (init_decl, init_decls);
      init_decl  = mVAR_DECL (init_name, 0, 
                              MakeIntegerType (default_int_size));
      init_decls = mDECL_LIST (init_decl, init_decls);

      body->BODY_NODE.DECLS      = AppendDECLS (body->BODY_NODE.DECLS, init_decls);

      /******************************************************
      *  IF (INIT_H1_<module_name> .eq. 0) THEN             *
      *     INIT_H1_<module_name> = 1                       *
      *     <other initialization>                          *
      *  END IF                                             *
      ******************************************************/

      init_exp  = mOP_EXP (mOP_EQ(), mVAR_EXP (init_var), MakeConstant (0));

      init_unit = mASSIGN_STMT (CopyTree(init_var), MakeConstant (1));
      init_unit = mACF_LIST (mACF_BASIC (init_unit), body->BODY_NODE.STATS);
      init_unit = mACF_IF (init_exp, init_unit, mACF_EMPTY ());
      init_unit = mACF_LIST (init_unit, mACF_EMPTY());

      init_name = MakeInitRoutineName (module_name);
      init_unit = mBODY_NODE (mDECL_EMPTY (), init_unit, mUNIT_EMPTY ());
      init_unit = mPROC_DECL (init_name, 0, mDECL_EMPTY(), init_unit);
      body->BODY_NODE.INTERNALS = mUNIT_LIST (init_unit, body->BODY_NODE.INTERNALS);

      

      body->BODY_NODE.STATS = mACF_EMPTY ();

    
  }
   return;
 }

  }
;
}

static tIdent MakeInitRoutineName
# if defined __STDC__ | defined __cplusplus
(register tIdent module_name)
# else
(module_name)
 register tIdent module_name;
# endif
{
# line 1025 "FinalCode.puma"
 {
  tIdent init_name;
  {
# line 1027 "FinalCode.puma"

# line 1029 "FinalCode.puma"
 char string [50], string1[60];

    GetString (module_name, string);
    sprintf (string1, "INIT_H0_%s", string);
    init_name = IsIdent (string1);
  
  }
  {
   return init_name;
  }
 }

}

static tIdent MakeInitVarName
# if defined __STDC__ | defined __cplusplus
(register tIdent module_name)
# else
(module_name)
 register tIdent module_name;
# endif
{
# line 1047 "FinalCode.puma"
 {
  tIdent init_name;
  {
# line 1049 "FinalCode.puma"

# line 1051 "FinalCode.puma"
 char string [50], string1[60];

    GetString (module_name, string);
    sprintf (string1, "INIT_H1_%s", string);
    init_name = IsIdent (string1);
  
  }
  {
   return init_name;
  }
 }

}

static tTree MakeModuleInitCall
# if defined __STDC__ | defined __cplusplus
(register tIdent module_name)
# else
(module_name)
 register tIdent module_name;
# endif
{
# line 1071 "FinalCode.puma"
 {
  tTree init_call;
  tIdent init_name;
  {
# line 1073 "FinalCode.puma"

# line 1074 "FinalCode.puma"

# line 1076 "FinalCode.puma"
 init_name = MakeInitRoutineName (module_name);
     init_call = mPROC_OBJ (init_name);
     init_call = mCALL_STMT (init_call, mBTP_EMPTY());
     init_call = mACF_BASIC (init_call);
   
  }
  {
   return init_call;
  }
 }

}

void BeginFinalCode ()
{
}

void CloseFinalCode ()
{
}
