# include "Extraction.h"
# include "yyExtraction.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 22 "Extraction.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Nesting.h"    /* IsParallelLoop,  ... */
# include "ParNest.h"
# include "TreeOps.h" 
# include "Dependences.h"
# include "Shapes.h"
# include "Loops.h"

# define MODULE "Extraction"

# undef DEBUG

static tTree LoopNest1 [MAX_FORALL];
static tTree LoopNest2 [MAX_FORALL];
static int Nest1;
static int Nest2;
static int CommonLoops;

static tTree extract_var;
static bool  extract_read;
static bool  extract_before;
static bool  extract_loops;

       /*************************************************
       *                                                *
       *  Variables for describing problems             *
       *                                                *
       *************************************************/

static tTree problem_var;
static tTree problem_stmt;



static void yyExit () { Exit (1); }

void (* Extraction_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Extraction, routine %s failed\n", yyFunction);
 Extraction_Exit ();
}

bool IsExtractableVar ARGS((tTree var, bool is_read, bool before));
bool IsExtractableRange ARGS((tTree exp));
static bool AreExtractableVarIndexes ARGS((tTree var));
static bool IsExtractableExp ARGS((tTree exp));
static bool IsExtractable ARGS((tTree stmt));
static bool IsNotLoopId ARGS((tTree var, tTree id));
static bool NoVarDependences ARGS((tTree var1, bool is_read1, tTree var2, bool is_read2));
static bool NoExpDependences ARGS((tTree var, tTree exp));
static bool NoParamDependences ARGS((tTree var, tTree params));
static void SetCurrentNesting ARGS(());
static void IncNesting2 ARGS((tTree loop));
static void DecNesting2 ARGS((tTree loop));
static bool IsLoop ARGS((tTree loop));
static bool NoLoopDependences ARGS((tTree var1, bool is_read1, tTree var2, bool is_read2));
static tTree GetVariable ARGS((tTree var));
static void MyDependences ARGS((tTree v1, ptree loops1, int n1, tTree v2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void ExtractTestPredicate ARGS((int CommonLoops, Predicate * yyP1));
static void LexicalOrder ARGS((tTree v1, tTree v2, tTree stmt, int * yyP2));
static void LexOrder ARGS((tTree v1, tTree v2, tTree stmt, bool * yyP5, bool * yyP4, int * yyP3));
static void Combine ARGS((bool found1a, bool found2a, int kinda, bool found1b, bool found2b, int kindb, int new_kind, bool * yyP8, bool * yyP7, int * yyP6));
void ExtractVarFromLoop ARGS((tTree var, tTree loop, tTree * yyP10, bool * yyP9));
bool IsParallelInvariant ARGS((tTree exp));
static bool IsInvariantExp ARGS((tTree exp));
static bool IsInvariant ARGS((tTree stmt));

bool IsExtractableVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register bool is_read, register bool before)
# else
(var, is_read, before)
 register tTree var;
 register bool is_read;
 register bool before;
# endif
{
# line 80 "Extraction.puma"
  {
# line 82 "Extraction.puma"
   if (! ((GetParNestingDepth () == 0))) goto yyL1;
  }
   return true;
yyL1:;

# line 85 "Extraction.puma"
  {
# line 87 "Extraction.puma"
   extract_var = var;
# line 88 "Extraction.puma"
   extract_read = is_read;
# line 89 "Extraction.puma"
   extract_before = before;
# line 90 "Extraction.puma"
   extract_loops = true;
# line 92 "Extraction.puma"
   problem_var = NoTree;
# line 93 "Extraction.puma"
   problem_stmt = NoTree;
# line 95 "Extraction.puma"
   SetCurrentNesting ();
# line 99 "Extraction.puma"
   if (! ((IsExtractable (GetParNestACF (1))))) goto yyL2;
  {
# line 101 "Extraction.puma"
   if (! ((AreExtractableVarIndexes (var)))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 104 "Extraction.puma"
  {
# line 106 "Extraction.puma"
   if (! ((problem_var != NoTree))) goto yyL3;
  {
# line 108 "Extraction.puma"
   tree_protocol ("this variable : ", problem_var);
# line 109 "Extraction.puma"
   tree_protocol ("cannot be extracted due to :\n", problem_stmt);
# line 111 "Extraction.puma"
   return false;
  }
  }
yyL3:;

  return false;
}

bool IsExtractableRange
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 130 "Extraction.puma"
  {
# line 132 "Extraction.puma"
   extract_before = true;
# line 133 "Extraction.puma"
   extract_loops = false;
# line 135 "Extraction.puma"
   SetCurrentNesting ();
# line 137 "Extraction.puma"
   if (! ((IsExtractableExp (exp)))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

static bool AreExtractableVarIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 151 "Extraction.puma"
  {
# line 153 "Extraction.puma"
   if (! ((AreExtractableVarIndexes (var->INDEXED_VAR.IND_VAR)))) goto yyL1;
  {
# line 154 "Extraction.puma"
   if (! ((AreExtractableVarIndexes (var->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
# line 157 "Extraction.puma"
   return true;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 160 "Extraction.puma"
  {
# line 162 "Extraction.puma"
   if (! ((AreExtractableVarIndexes (var->SELECTED_VAR.SELEC_VAR)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 165 "Extraction.puma"
  {
# line 167 "Extraction.puma"
   if (! ((IsExtractableExp (var->SUBSTRING_VAR.IND_EXP)))) goto yyL4;
  {
# line 168 "Extraction.puma"
   if (! ((AreExtractableVarIndexes (var->SUBSTRING_VAR.IND_VAR)))) goto yyL4;
  }
  }
   return true;
yyL4:;

  }
  if (var->Kind == kBTE_LIST) {
# line 171 "Extraction.puma"
  {
# line 173 "Extraction.puma"
   if (! ((IsExtractableExp (var->BTE_LIST.Elem)))) goto yyL5;
  {
# line 174 "Extraction.puma"
   if (! ((AreExtractableVarIndexes (var->BTE_LIST.Next)))) goto yyL5;
  }
  }
   return true;
yyL5:;

  }
  if (var->Kind == kBTE_EMPTY) {
# line 177 "Extraction.puma"
   return true;

  }
  return false;
}

static bool IsExtractableExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
# line 188 "Extraction.puma"
  {
# line 190 "Extraction.puma"
   if (! ((IsExtractableExp (exp->OP_EXP.OPND1)))) goto yyL1;
  {
# line 191 "Extraction.puma"
   if (! ((IsExtractableExp (exp->OP_EXP.OPND2)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  break;
  case kSLICE_EXP:
# line 194 "Extraction.puma"
  {
# line 196 "Extraction.puma"
   if (! ((IsExtractableExp (exp->SLICE_EXP.START)))) goto yyL2;
  {
# line 197 "Extraction.puma"
   if (! ((IsExtractableExp (exp->SLICE_EXP.STOP)))) goto yyL2;
  {
# line 198 "Extraction.puma"
   if (! ((IsExtractableExp (exp->SLICE_EXP.INC)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  break;
  case kDUMMY_EXP:
# line 201 "Extraction.puma"
   return true;

  case kCONST_EXP:
# line 204 "Extraction.puma"
   return true;

  case kBOUND_EXP:
# line 207 "Extraction.puma"
   return true;

  case kRANK_EXP:
# line 210 "Extraction.puma"
   return true;

  case kOP1_EXP:
# line 213 "Extraction.puma"
  {
# line 215 "Extraction.puma"
   if (! ((IsExtractableExp (exp->OP1_EXP.OPND)))) goto yyL7;
  }
   return true;
yyL7:;

  break;
  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
# line 218 "Extraction.puma"
  {
# line 220 "Extraction.puma"
   if (! ((extract_loops))) goto yyL8;
  }
   return true;
yyL8:;

  }
# line 223 "Extraction.puma"
  {
# line 225 "Extraction.puma"
   extract_var = exp->VAR_EXP.V;
# line 226 "Extraction.puma"
   extract_read = true;
# line 231 "Extraction.puma"
   if (! ((IsExtractable (GetParNestACF (1))))) goto yyL9;
  {
# line 235 "Extraction.puma"
   if (! ((AreExtractableVarIndexes (exp->VAR_EXP.V)))) goto yyL9;
  }
  }
   return true;
yyL9:;

  break;
  }

  return false;
}

static bool IsExtractable
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
# line 256 "Extraction.puma"
  {
# line 258 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_LIST.Elem)))) goto yyL1;
  {
# line 259 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  break;
  case kACF_EMPTY:
# line 262 "Extraction.puma"
   return true;

  case kACF_DO:
# line 265 "Extraction.puma"
  {
# line 267 "Extraction.puma"
   if (! ((IsNotLoopId (extract_var, stmt->ACF_DO.DO_ID)))) goto yyL3;
  {
# line 268 "Extraction.puma"
   IncNesting2 (stmt);
# line 269 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_DO.DO_BODY)))) goto yyL3;
  {
# line 270 "Extraction.puma"
   DecNesting2 (stmt);
  }
  }
  }
   return true;
yyL3:;

  break;
  case kACF_FORALL:
# line 273 "Extraction.puma"
  {
# line 275 "Extraction.puma"
   if (! ((IsNotLoopId (extract_var, stmt->ACF_FORALL.FORALL_ID)))) goto yyL4;
  {
# line 276 "Extraction.puma"
   IncNesting2 (stmt);
# line 277 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_FORALL.FORALL_BODY)))) goto yyL4;
  {
# line 278 "Extraction.puma"
   DecNesting2 (stmt);
  }
  }
  }
   return true;
yyL4:;

  break;
  case kACF_WHILE:
# line 281 "Extraction.puma"
  {
# line 283 "Extraction.puma"
   IncNesting2 (stmt);
# line 284 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_WHILE.WHILE_BODY)))) goto yyL5;
  {
# line 285 "Extraction.puma"
   DecNesting2 (stmt);
  }
  }
   return true;
yyL5:;

  break;
  case kACF_IF:
# line 288 "Extraction.puma"
  {
# line 290 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_IF.THEN_PART)))) goto yyL6;
  {
# line 291 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_IF.ELSE_PART)))) goto yyL6;
  }
  }
   return true;
yyL6:;

  break;
  case kACF_HOME:
# line 294 "Extraction.puma"
  {
# line 296 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_HOME.HOME_BODY)))) goto yyL7;
  }
   return true;
yyL7:;

  break;
  case kACF_NEW:
# line 299 "Extraction.puma"
  {
# line 301 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_NEW.NEW_BODY)))) goto yyL8;
  }
   return true;
yyL8:;

  break;
  case kACF_RESIDENT:
# line 304 "Extraction.puma"
  {
# line 306 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_RESIDENT.RESIDENT_BODY)))) goto yyL9;
  }
   return true;
yyL9:;

  break;
  case kACF_REDUCTION:
# line 309 "Extraction.puma"
  {
# line 311 "Extraction.puma"
   if (! ((IsExtractable (stmt->ACF_REDUCTION.REDUCTION_BODY)))) goto yyL10;
  }
   return true;
yyL10:;

  break;
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 314 "Extraction.puma"
  {
# line 316 "Extraction.puma"
   if (! ((NoVarDependences (extract_var, extract_read, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, false)))) goto yyL11;
  {
# line 317 "Extraction.puma"
   if (! ((NoExpDependences (extract_var, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL11;
  }
  }
   return true;
yyL11:;

# line 320 "Extraction.puma"
  {
# line 322 "Extraction.puma"
 if (problem_var == NoTree)

       { problem_var  = extract_var;
         problem_stmt = stmt;
       }
  
# line 329 "Extraction.puma"
   return false;
  }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 332 "Extraction.puma"
  {
# line 334 "Extraction.puma"
   if (! ((NoParamDependences (extract_var, stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS)))) goto yyL13;
  }
   return true;
yyL13:;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 337 "Extraction.puma"
  {
# line 339 "Extraction.puma"
   if (! ((NoParamDependences (extract_var, stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS)))) goto yyL14;
  }
   return true;
yyL14:;

  }
# line 342 "Extraction.puma"
   return true;

  }

# line 347 "Extraction.puma"
  {
# line 349 "Extraction.puma"
   if (! ((problem_var == NoTree))) goto yyL16;
  {
# line 351 "Extraction.puma"
   problem_var = extract_var;
# line 352 "Extraction.puma"
   problem_stmt = stmt;
# line 354 "Extraction.puma"
   return false;
  }
  }
yyL16:;

  return false;
}

static bool IsNotLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id)
# else
(var, id)
 register tTree var;
 register tTree id;
# endif
{
# line 367 "Extraction.puma"
  {
# line 368 "Extraction.puma"
   if (! ((extract_loops))) goto yyL1;
  }
   return true;
yyL1:;

# line 371 "Extraction.puma"
  {
# line 372 "Extraction.puma"
   if (! ((TreeVarName (id) != TreeVarName (var)))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

static bool NoVarDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register bool is_read1, register tTree var2, register bool is_read2)
# else
(var1, is_read1, var2, is_read2)
 register tTree var1;
 register bool is_read1;
 register tTree var2;
 register bool is_read2;
# endif
{
# line 384 "Extraction.puma"
  {
# line 386 "Extraction.puma"
   if (! ((var1 == var2))) goto yyL1;
  }
   return true;
yyL1:;

# line 389 "Extraction.puma"
  {
# line 391 "Extraction.puma"
   if (! ((TreeVarName (var1) != TreeVarName (var2)))) goto yyL2;
  }
   return true;
yyL2:;

# line 394 "Extraction.puma"
  {
# line 396 "Extraction.puma"
   if (! ((NoLoopDependences (var1, is_read1, var2, is_read2)))) goto yyL3;
  }
   return true;
yyL3:;

  return false;
}

static bool NoExpDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
# line 407 "Extraction.puma"
  {
# line 409 "Extraction.puma"
   if (! ((NoExpDependences (var, exp->OP_EXP.OPND1)))) goto yyL1;
  {
# line 410 "Extraction.puma"
   if (! ((NoExpDependences (var, exp->OP_EXP.OPND2)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  break;
  case kSLICE_EXP:
# line 413 "Extraction.puma"
  {
# line 415 "Extraction.puma"
   if (! ((NoExpDependences (var, exp->SLICE_EXP.START)))) goto yyL2;
  {
# line 416 "Extraction.puma"
   if (! ((NoExpDependences (var, exp->SLICE_EXP.STOP)))) goto yyL2;
  {
# line 417 "Extraction.puma"
   if (! ((NoExpDependences (var, exp->SLICE_EXP.INC)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  break;
  case kDUMMY_EXP:
# line 420 "Extraction.puma"
   return true;

  case kCONST_EXP:
# line 423 "Extraction.puma"
   return true;

  case kOP1_EXP:
# line 426 "Extraction.puma"
  {
# line 428 "Extraction.puma"
   if (! ((NoExpDependences (var, exp->OP1_EXP.OPND)))) goto yyL5;
  }
   return true;
yyL5:;

  break;
  case kVAR_EXP:
# line 431 "Extraction.puma"
  {
# line 433 "Extraction.puma"
   if (! ((NoVarDependences (var, extract_read, exp->VAR_EXP.V, true)))) goto yyL6;
  }
   return true;
yyL6:;

  break;
  case kFUNC_CALL_EXP:
# line 436 "Extraction.puma"
  {
# line 438 "Extraction.puma"
   if (! ((NoParamDependences (var, exp->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL7;
  }
   return true;
yyL7:;

  break;
  }

  return false;
}

static bool NoParamDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree params)
# else
(var, params)
 register tTree var;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
# line 449 "Extraction.puma"
  {
# line 451 "Extraction.puma"
   if (! ((NoParamDependences (var, params->BTP_LIST.Elem)))) goto yyL1;
  {
# line 452 "Extraction.puma"
   if (! ((NoParamDependences (var, params->BTP_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  if (params->Kind == kBTP_EMPTY) {
# line 455 "Extraction.puma"
   return true;

  }
  if (params->Kind == kNO_PARAM) {
# line 458 "Extraction.puma"
   return true;

  }
  if (params->Kind == kVAR_PARAM) {
  if (params->VAR_PARAM.V->Kind == kADDR) {
# line 461 "Extraction.puma"
  {
# line 463 "Extraction.puma"
   if (! ((NoExpDependences (var, params->VAR_PARAM.V->ADDR.E)))) goto yyL4;
  }
   return true;
yyL4:;

  }
# line 466 "Extraction.puma"
  {
# line 468 "Extraction.puma"
   if (! ((params->VAR_PARAM.intent == IntentIn))) goto yyL5;
  {
# line 470 "Extraction.puma"
   if (! ((NoVarDependences (var, extract_read, params->VAR_PARAM.V, true)))) goto yyL5;
  }
  }
   return true;
yyL5:;

# line 473 "Extraction.puma"
  {
# line 475 "Extraction.puma"
   if (! ((NoVarDependences (var, extract_read, params->VAR_PARAM.V, false)))) goto yyL6;
  }
   return true;
yyL6:;

  }
  return false;
}

static void SetCurrentNesting
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 488 "Extraction.puma"
 {
  int depth;
  int i;
  {
# line 490 "Extraction.puma"

# line 491 "Extraction.puma"

# line 493 "Extraction.puma"
   depth = GetParNestingDepth ();
# line 495 "Extraction.puma"
 Nest1 = 0;
     for (i=1; i <= depth; i++)
       { tTree loop;
         loop = GetParNestACF (i);
         if (IsLoop (loop))
            LoopNest1 [Nest1++] = loop;
       }
     Nest2 = 0;
     CommonLoops = 0;
   
  }
   return;
 }

;
}

static void IncNesting2
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
# line 509 "Extraction.puma"
  {
# line 511 "Extraction.puma"
 LoopNest2 [Nest2++] = loop; 
  }
   return;

;
}

static void DecNesting2
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
# line 516 "Extraction.puma"
  {
# line 518 "Extraction.puma"
 Nest2--; 
  }
   return;

;
}

static bool IsLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
# line 523 "Extraction.puma"
   return true;

  }
  if (loop->Kind == kACF_FORALL) {
# line 526 "Extraction.puma"
   return true;

  }
  if (loop->Kind == kACF_WHILE) {
# line 529 "Extraction.puma"
   return true;

  }
  return false;
}

static bool NoLoopDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register bool is_read1, register tTree var2, register bool is_read2)
# else
(var1, is_read1, var2, is_read2)
 register tTree var1;
 register bool is_read1;
 register tTree var2;
 register bool is_read2;
# endif
{
# line 541 "Extraction.puma"
  {
# line 543 "Extraction.puma"
   if (! ((is_read1 && is_read2))) goto yyL1;
  }
   return true;
yyL1:;

# line 546 "Extraction.puma"
 {
  bool no_deps;
  tTree v1;
  tTree v2;
  {
# line 548 "Extraction.puma"

# line 550 "Extraction.puma"

# line 551 "Extraction.puma"

# line 553 "Extraction.puma"
 int i, dim;

     int order;

     PredVector pv;
     Predicate  P;

     v1 = GetVariable (var1);
     v2 = GetVariable (var2);

     LexicalOrder (v1, v2, GetParNestACF (1), &order);

     

     CommonLoops = 0;

     for (i=0; i<Nest1; i++)

        { if (i<Nest2)
             if (LoopNest1[i] == LoopNest2[i])
                CommonLoops ++;
        }

     no_deps = true;

     ExtractTestPredicate (CommonLoops, &P);
     
     dim = P.p_dim;

     for (i=0; i<dim; i++)

        { 

          pv = P.p_arr[i];

          MyDependences (v1, LoopNest1, Nest1,
                         v2, LoopNest2, Nest2,
                         CommonLoops, 0, &pv);

          if (PVIsZero (&pv) || (CommonLoops == 0))

             { if (order == 1)   

                 { if (!extract_before) no_deps = false; }

               if (order == -1)   

                 { if (extract_before) no_deps = false; }

             }
          
           else if (!PVIsFalse (&pv)) 

             no_deps = false;
        }

#ifdef DEBUG
     printf ("deps for ");
     FileUnparse (stdout, v1);
     printf (" and ");
     FileUnparse (stdout, v2);
     printf (" = %d (order = %d)\n", !no_deps, order);
#endif 

   
# line 619 "Extraction.puma"
   if (! ((no_deps))) goto yyL2;
  }
   return true;
 }
yyL2:;

  return false;
}

static tTree GetVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
# line 624 "Extraction.puma"
   return var->REMOTE_VAR.VAR;

  }
# line 629 "Extraction.puma"
   return var;

}

static void MyDependences
# if defined __STDC__ | defined __cplusplus
(register tTree v1, ptree loops1, register int n1, register tTree v2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(v1, loops1, n1, v2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree v1;
 ptree loops1;
 register int n1;
 register tTree v2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
  if (v1->Kind == kUSED_VAR) {
  if (v2->Kind == kUSED_VAR) {
# line 645 "Extraction.puma"
   return;

  }
  }
# line 648 "Extraction.puma"
  {
# line 650 "Extraction.puma"
   Dependences (v1, loops1, n1, v2, loops2, n2, CommonLoops, ConstLoops, p);
  }
   return;

;
}

static void ExtractTestPredicate
# if defined __STDC__ | defined __cplusplus
(register int CommonLoops, Predicate * yyP1)
# else
(CommonLoops, yyP1)
 register int CommonLoops;
 Predicate * yyP1;
# endif
{
# line 661 "Extraction.puma"
 {
  Predicate P;
  {
# line 663 "Extraction.puma"

# line 665 "Extraction.puma"
 int k, j;
     PredVector PV;
     char str[100];

     PMakeFalse (&P);

     for (k=0; k<=CommonLoops; k++)

       { 

         PVMakeForLoopNest (CommonLoops, CommonLoops, k, &PV);

         for (j=0; j < CommonLoops; j++)

            if (IsParallelLoop (LoopNest1[j]))
  
               PVAndComponent (&PV, j+1, 0, 0);

         POrVector (&P, &PV);

       }

#ifdef DEBUG
      strcpy (str, "");
      POut (str, &P);
      printf ("ExtractTestPredicate (n=%d): %s\n", CommonLoops, str); 
#endif 

   
  }
   * yyP1 = P;
   return;
 }

;
}

static void LexicalOrder
# if defined __STDC__ | defined __cplusplus
(register tTree v1, register tTree v2, register tTree stmt, register int * yyP2)
# else
(v1, v2, stmt, yyP2)
 register tTree v1;
 register tTree v2;
 register tTree stmt;
 register int * yyP2;
# endif
{
# line 710 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 712 "Extraction.puma"
   LexOrder (v1, v2, stmt, & yyV1, & yyV2, & yyV3);
# line 714 "Extraction.puma"
 if (!yyV1) 
       tree_error_protocol ("var1 not found for lexical order : ", v1);
     if (!yyV2) 
       tree_error_protocol ("var2 not found for lexical order : ", v2);
     if (!(yyV1 && yyV2))
       tree_protocol ("considered statement :\n", stmt);
   
  }
   * yyP2 = yyV3;
   return;
 }

;
}

static void LexOrder
# if defined __STDC__ | defined __cplusplus
(register tTree v1, register tTree v2, register tTree stmt, register bool * yyP5, register bool * yyP4, register int * yyP3)
# else
(v1, v2, stmt, yyP5, yyP4, yyP3)
 register tTree v1;
 register tTree v2;
 register tTree stmt;
 register bool * yyP5;
 register bool * yyP4;
 register int * yyP3;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
# line 725 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  {
# line 727 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 728 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_LIST.Next, & yyV4, & yyV5, & yyV6);
# line 730 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kACF_DO:
# line 734 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  {
# line 736 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_DO.DO_RANGE, & yyV1, & yyV2, & yyV3);
# line 737 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_DO.DO_BODY, & yyV4, & yyV5, & yyV6);
# line 741 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kACF_FORALL:
# line 745 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  {
# line 748 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_FORALL.FORALL_RANGE, & yyV1, & yyV2, & yyV3);
# line 749 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_FORALL.FORALL_BODY, & yyV4, & yyV5, & yyV6);
# line 753 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kACF_HOME:
# line 757 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 759 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_HOME.HOME_BODY, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kACF_RESIDENT:
# line 762 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 764 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_RESIDENT.RESIDENT_BODY, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kACF_REDUCTION:
# line 767 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 769 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_REDUCTION.REDUCTION_BODY, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kACF_NEW:
# line 772 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 774 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_NEW.NEW_BODY, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kACF_WHILE:
# line 777 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  {
# line 779 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_WHILE.WHILE_EXP, & yyV1, & yyV2, & yyV3);
# line 780 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_WHILE.WHILE_BODY, & yyV4, & yyV5, & yyV6);
# line 784 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kACF_IF:
# line 788 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  bool yyV10;
  bool yyV11;
  int yyV12;
  bool yyV13;
  bool yyV14;
  int yyV15;
  {
# line 791 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_IF.IF_EXP, & yyV1, & yyV2, & yyV3);
# line 792 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_IF.THEN_PART, & yyV4, & yyV5, & yyV6);
# line 793 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_IF.ELSE_PART, & yyV7, & yyV8, & yyV9);
# line 797 "Extraction.puma"
   Combine (yyV4, yyV5, yyV6, yyV7, yyV8, yyV9, 0, & yyV10, & yyV11, & yyV12);
# line 802 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV10, yyV11, yyV12, 1, & yyV13, & yyV14, & yyV15);
  }
   * yyP5 = yyV13;
   * yyP4 = yyV14;
   * yyP3 = yyV15;
   return;
 }

  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 806 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  {
# line 808 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, & yyV1, & yyV2, & yyV3);
# line 809 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, & yyV4, & yyV5, & yyV6);
# line 813 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 817 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 819 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 822 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 824 "Extraction.puma"
   LexOrder (v1, v2, stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  }
  break;
  case kBTP_LIST:
# line 827 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  {
# line 829 "Extraction.puma"
   LexOrder (v1, v2, stmt->BTP_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 830 "Extraction.puma"
   LexOrder (v1, v2, stmt->BTP_LIST.Next, & yyV4, & yyV5, & yyV6);
# line 834 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 0, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kVAR_PARAM:
  if (stmt->VAR_PARAM.V->Kind == kADDR) {
# line 838 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 840 "Extraction.puma"
   LexOrder (v1, v2, stmt->VAR_PARAM.V->ADDR.E, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  }
# line 843 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 845 "Extraction.puma"
   LexOrder (v1, v2, stmt->VAR_PARAM.V, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kOP_EXP:
# line 848 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  {
# line 850 "Extraction.puma"
   LexOrder (v1, v2, stmt->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3);
# line 851 "Extraction.puma"
   LexOrder (v1, v2, stmt->OP_EXP.OPND2, & yyV4, & yyV5, & yyV6);
# line 855 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 0, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kOP1_EXP:
# line 859 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 861 "Extraction.puma"
   LexOrder (v1, v2, stmt->OP1_EXP.OPND, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kFUNC_CALL_EXP:
# line 864 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 866 "Extraction.puma"
   LexOrder (v1, v2, stmt->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kSLICE_EXP:
# line 869 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  bool yyV10;
  bool yyV11;
  int yyV12;
  bool yyV13;
  bool yyV14;
  int yyV15;
  {
# line 871 "Extraction.puma"
   LexOrder (v1, v2, stmt->SLICE_EXP.START, & yyV1, & yyV2, & yyV3);
# line 872 "Extraction.puma"
   LexOrder (v1, v2, stmt->SLICE_EXP.STOP, & yyV4, & yyV5, & yyV6);
# line 873 "Extraction.puma"
   LexOrder (v1, v2, stmt->SLICE_EXP.INC, & yyV7, & yyV8, & yyV9);
# line 877 "Extraction.puma"
   Combine (yyV4, yyV5, yyV6, yyV7, yyV8, yyV9, 0, & yyV10, & yyV11, & yyV12);
# line 882 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV10, yyV11, yyV12, 0, & yyV13, & yyV14, & yyV15);
  }
   * yyP5 = yyV13;
   * yyP4 = yyV14;
   * yyP3 = yyV15;
   return;
 }

  case kVAR_EXP:
# line 886 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 888 "Extraction.puma"
   LexOrder (v1, v2, stmt->VAR_EXP.V, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kREMOTE_VAR:
# line 891 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  {
# line 893 "Extraction.puma"
   LexOrder (v1, v2, stmt->REMOTE_VAR.VAR, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kUSED_VAR:
# line 896 "Extraction.puma"
   * yyP5 = (v1 == stmt);
   * yyP4 = (v2 == stmt);
   * yyP3 = 0;
   return;

  case kINDEXED_VAR:
# line 899 "Extraction.puma"
 {
  bool found1a;
  bool found2a;
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  {
# line 901 "Extraction.puma"

# line 902 "Extraction.puma"

# line 904 "Extraction.puma"
   found1a = (stmt == v1);
# line 905 "Extraction.puma"
   found2a = (stmt == v2);
# line 907 "Extraction.puma"
   LexOrder (v1, v2, stmt->INDEXED_VAR.IND_EXPS, & yyV1, & yyV2, & yyV3);
# line 911 "Extraction.puma"
   Combine (found1a, found2a, 0, yyV1, yyV2, yyV3, - 1, & yyV4, & yyV5, & yyV6);
  }
   * yyP5 = yyV4;
   * yyP4 = yyV5;
   * yyP3 = yyV6;
   return;
 }

  case kBTE_LIST:
# line 915 "Extraction.puma"
 {
  bool yyV1;
  bool yyV2;
  int yyV3;
  bool yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  bool yyV8;
  int yyV9;
  {
# line 917 "Extraction.puma"
   LexOrder (v1, v2, stmt->BTE_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 918 "Extraction.puma"
   LexOrder (v1, v2, stmt->BTE_LIST.Next, & yyV4, & yyV5, & yyV6);
# line 922 "Extraction.puma"
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 0, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  }

# line 926 "Extraction.puma"
   * yyP5 = false;
   * yyP4 = false;
   * yyP3 = 0;
   return;

;
}

static void Combine
# if defined __STDC__ | defined __cplusplus
(register bool found1a, register bool found2a, register int kinda, register bool found1b, register bool found2b, register int kindb, register int new_kind, register bool * yyP8, register bool * yyP7, register int * yyP6)
# else
(found1a, found2a, kinda, found1b, found2b, kindb, new_kind, yyP8, yyP7, yyP6)
 register bool found1a;
 register bool found2a;
 register int kinda;
 register bool found1b;
 register bool found2b;
 register int kindb;
 register int new_kind;
 register bool * yyP8;
 register bool * yyP7;
 register int * yyP6;
# endif
{
# line 956 "Extraction.puma"
  {
# line 958 "Extraction.puma"
   if (! ((found1a))) goto yyL1;
  {
# line 959 "Extraction.puma"
   if (! ((found1b))) goto yyL1;
  {
# line 961 "Extraction.puma"
   failure_protocol (MODULE, "Combine: v1 in two constructs", NoTree);
  }
  }
  }
   * yyP8 = true;
   * yyP7 = found2a || found2b;
   * yyP6 = 0;
   return;
yyL1:;

# line 964 "Extraction.puma"
  {
# line 966 "Extraction.puma"
   if (! ((found2a))) goto yyL2;
  {
# line 967 "Extraction.puma"
   if (! ((found2b))) goto yyL2;
  {
# line 969 "Extraction.puma"
   failure_protocol (MODULE, "Combine: v2 in two constructs", NoTree);
  }
  }
  }
   * yyP8 = found1a || found1b;
   * yyP7 = true;
   * yyP6 = 0;
   return;
yyL2:;

# line 974 "Extraction.puma"
  {
# line 976 "Extraction.puma"
   if (! ((found1a))) goto yyL3;
  {
# line 977 "Extraction.puma"
   if (! ((found2a))) goto yyL3;
  }
  }
   * yyP8 = found1a;
   * yyP7 = found2a;
   * yyP6 = kinda;
   return;
yyL3:;

# line 982 "Extraction.puma"
  {
# line 984 "Extraction.puma"
   if (! ((found1b))) goto yyL4;
  {
# line 985 "Extraction.puma"
   if (! ((found2b))) goto yyL4;
  }
  }
   * yyP8 = found1b;
   * yyP7 = found2b;
   * yyP6 = kindb;
   return;
yyL4:;

# line 990 "Extraction.puma"
  {
# line 992 "Extraction.puma"
   if (! ((found1a))) goto yyL5;
  {
# line 993 "Extraction.puma"
   if (! ((found2b))) goto yyL5;
  }
  }
   * yyP8 = found1a;
   * yyP7 = found2b;
   * yyP6 = new_kind;
   return;
yyL5:;

# line 998 "Extraction.puma"
  {
# line 1000 "Extraction.puma"
   if (! ((found2a))) goto yyL6;
  {
# line 1001 "Extraction.puma"
   if (! ((found1b))) goto yyL6;
  }
  }
   * yyP8 = found2a;
   * yyP7 = found1b;
   * yyP6 = - new_kind;
   return;
yyL6:;

# line 1006 "Extraction.puma"
   * yyP8 = found1a || found1b;
   * yyP7 = found2a || found2b;
   * yyP6 = 0;
   return;

;
}

void ExtractVarFromLoop
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree loop, register tTree * yyP10, register bool * yyP9)
# else
(var, loop, yyP10, yyP9)
 register tTree var;
 register tTree loop;
 register tTree * yyP10;
 register bool * yyP9;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 1022 "Extraction.puma"
   * yyP10 = var;
   * yyP9 = true;
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 1025 "Extraction.puma"
   * yyP10 = MakeFullShape (var->INDEXED_VAR.IND_VAR);
   * yyP9 = false;
   return;

  }
# line 1028 "Extraction.puma"
  {
# line 1030 "Extraction.puma"
   error_protocol ("failure for var accesses within a loop");
# line 1031 "Extraction.puma"
   tree_protocol ("variable access : ", var);
  }
   * yyP10 = var;
   * yyP9 = false;
   return;

;
}

bool IsParallelInvariant
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 1045 "Extraction.puma"
  {
# line 1047 "Extraction.puma"
   if (! ((GetParNestingDepth () == 0))) goto yyL1;
  }
   return true;
yyL1:;

# line 1050 "Extraction.puma"
  {
# line 1052 "Extraction.puma"
   SetCurrentNesting ();
# line 1054 "Extraction.puma"
   if (! ((IsInvariantExp (exp)))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

static bool IsInvariantExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
# line 1059 "Extraction.puma"
  {
# line 1061 "Extraction.puma"
   if (! ((IsInvariantExp (exp->OP_EXP.OPND1)))) goto yyL1;
  {
# line 1062 "Extraction.puma"
   if (! ((IsInvariantExp (exp->OP_EXP.OPND2)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  break;
  case kOP1_EXP:
# line 1065 "Extraction.puma"
  {
# line 1067 "Extraction.puma"
   if (! ((IsInvariantExp (exp->OP1_EXP.OPND)))) goto yyL2;
  }
   return true;
yyL2:;

  break;
  case kCONST_EXP:
# line 1070 "Extraction.puma"
   return true;

  case kVAR_EXP:
# line 1073 "Extraction.puma"
  {
# line 1075 "Extraction.puma"
   extract_var = exp->VAR_EXP.V;
# line 1077 "Extraction.puma"
   if (! ((IsInvariant (GetParNestACF (1))))) goto yyL4;
  }
   return true;
yyL4:;

  break;
  case kSLICE_EXP:
# line 1080 "Extraction.puma"
  {
# line 1082 "Extraction.puma"
   if (! ((IsInvariantExp (exp->SLICE_EXP.START)))) goto yyL5;
  {
# line 1083 "Extraction.puma"
   if (! ((IsInvariantExp (exp->SLICE_EXP.STOP)))) goto yyL5;
  {
# line 1084 "Extraction.puma"
   if (! ((IsInvariantExp (exp->SLICE_EXP.INC)))) goto yyL5;
  }
  }
  }
   return true;
yyL5:;

  break;
  case kDUMMY_EXP:
# line 1087 "Extraction.puma"
   return true;

  case kFUNC_CALL_EXP:
# line 1090 "Extraction.puma"
   return true;

  }

  return false;
}

static bool IsInvariant
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
# line 1095 "Extraction.puma"
  {
# line 1097 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_LIST.Elem)))) goto yyL1;
  {
# line 1098 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  break;
  case kACF_EMPTY:
# line 1101 "Extraction.puma"
   return true;

  case kACF_DO:
# line 1104 "Extraction.puma"
  {
# line 1106 "Extraction.puma"
   if (! ((TreeVarName (extract_var) != TreeVarName (stmt->ACF_DO.DO_ID)))) goto yyL3;
  {
# line 1108 "Extraction.puma"
   IncNesting2 (stmt);
# line 1109 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_DO.DO_BODY)))) goto yyL3;
  {
# line 1110 "Extraction.puma"
   DecNesting2 (stmt);
  }
  }
  }
   return true;
yyL3:;

  break;
  case kACF_FORALL:
# line 1113 "Extraction.puma"
  {
# line 1115 "Extraction.puma"
   if (! ((TreeVarName (extract_var) != TreeVarName (stmt->ACF_FORALL.FORALL_ID)))) goto yyL4;
  {
# line 1117 "Extraction.puma"
   IncNesting2 (stmt);
# line 1118 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_FORALL.FORALL_BODY)))) goto yyL4;
  {
# line 1119 "Extraction.puma"
   DecNesting2 (stmt);
  }
  }
  }
   return true;
yyL4:;

  break;
  case kACF_WHILE:
# line 1122 "Extraction.puma"
  {
# line 1124 "Extraction.puma"
   IncNesting2 (stmt);
# line 1125 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_WHILE.WHILE_BODY)))) goto yyL5;
  {
# line 1126 "Extraction.puma"
   DecNesting2 (stmt);
  }
  }
   return true;
yyL5:;

  break;
  case kACF_IF:
# line 1129 "Extraction.puma"
  {
# line 1131 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_IF.THEN_PART)))) goto yyL6;
  {
# line 1132 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_IF.ELSE_PART)))) goto yyL6;
  }
  }
   return true;
yyL6:;

  break;
  case kACF_HOME:
# line 1135 "Extraction.puma"
  {
# line 1137 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_HOME.HOME_BODY)))) goto yyL7;
  }
   return true;
yyL7:;

  break;
  case kACF_NEW:
# line 1140 "Extraction.puma"
  {
# line 1142 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_NEW.NEW_BODY)))) goto yyL8;
  }
   return true;
yyL8:;

  break;
  case kACF_RESIDENT:
# line 1145 "Extraction.puma"
  {
# line 1147 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_RESIDENT.RESIDENT_BODY)))) goto yyL9;
  }
   return true;
yyL9:;

  break;
  case kACF_REDUCTION:
# line 1150 "Extraction.puma"
  {
# line 1152 "Extraction.puma"
   if (! ((IsInvariant (stmt->ACF_REDUCTION.REDUCTION_BODY)))) goto yyL10;
  }
   return true;
yyL10:;

  break;
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 1155 "Extraction.puma"
  {
# line 1157 "Extraction.puma"
   if (! ((TreeVarName (extract_var) != TreeVarName (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL11;
  }
   return true;
yyL11:;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 1160 "Extraction.puma"
   return true;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 1163 "Extraction.puma"
   return true;

  }
# line 1166 "Extraction.puma"
  {
# line 1168 "Extraction.puma"
   return false;
  }

  }

  return false;
}

void BeginExtraction ()
{
}

void CloseExtraction ()
{
}
