# include "Expressions.h"
# include "yyExpressions.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 46 "Expressions.puma"


# include "Tree.h"
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"
# include "precision.h"

# define MODULE "Expressions"

# include "Types.h"            /* GetExpType for KIND  */
# include "Objects.h"
# include "Intrinsics.h"

       /*************************************************
       *                                                *
       *   power(base, n) returns base ** n             *
       *                                                *
       *************************************************/

int power (base, n)
int base, n;
{ int i, p;
  
  p = 1;
  for (i=1; i<=n; ++i)
     p = p * base;
  return p;
}



static void yyExit () { Exit (1); }

void (* Expressions_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Expressions, routine %s failed\n", yyFunction);
 Expressions_Exit ();
}

void GetIntConstValue ARGS((tTree exp, bool * found, int * val));
static void GetOptParamValue ARGS((tTree param, int dval, bool * yyP2, int * yyP1));
void GetConstDifference ARGS((tTree exp1, tTree exp2, bool * found, int * val));
void ResolveExpression ARGS((tTree exp, bool * found, int * a, int * b, tTree * var));
static void MergeVars ARGS((int a1, tTree v1, int a2, tTree v2, bool * ok, tTree * var));
bool EqualExpression ARGS((tTree e1, tTree e2));
bool EqualIndexes ARGS((tTree indexes1, tTree indexes2));
static bool EqualParameters ARGS((tTree paramlist1, tTree paramlist2));
tTree MakeNotExp ARGS((tTree e));
void SliceIncrement ARGS((tTree exp, bool * yyP4, int * yyP3));
tTree MakeSliceExp ARGS((tTree start, tTree stop));
tTree MakeRangeExp ARGS((tTree start, tTree stop, tTree inc));
tTree AddConstant ARGS((tTree exp, int c));
tTree MakeConstant ARGS((int n));
tTree MultConstant ARGS((tTree exp, int c));
tTree DivConstant ARGS((tTree exp, int c));
tTree MinusExpression ARGS((tTree exp));
tTree InverseExpression ARGS((tTree exp));
bool IsStride1 ARGS((tTree stride));

void GetIntConstValue
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register bool * found, register int * val)
# else
(exp, found, val)
 register tTree exp;
 register bool * found;
 register int * val;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 90 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 91 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 92 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 + yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 95 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 96 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 97 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 - yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 100 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 101 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 102 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 * yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
# line 105 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 106 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 107 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
# line 108 "Expressions.puma"
 if (yyV4 == 0) 
        { yyV3 = false;
          yyV4   = 1;
        }
   
  }
   * found = yyV1 && yyV3;
   * val = yyV2 / yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_EXPO) {
# line 115 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 116 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 117 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
# line 118 "Expressions.puma"
 if (yyV4 < 0) yyV3 = false; 
  }
   * found = yyV1 && yyV3;
   * val = power (yyV2, yyV4);
   return;
 }

  }
  break;
  case kOP1_EXP:
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 121 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 122 "Expressions.puma"
   GetIntConstValue (exp->OP1_EXP.OPND, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = - yyV2;
   return;
 }

  }
  break;
  case kVAR_EXP:
# line 125 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 126 "Expressions.puma"
   GetIntConstValue (exp->VAR_EXP.V, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kUSED_VAR:
# line 129 "Expressions.puma"
  {
# line 134 "Expressions.puma"
   if (! ((exp->USED_VAR.VARNAME->VAR_OBJ.Object == NoObject))) goto yyL8;
  }
   * found = false;
   * val = 0;
   return;
yyL8:;

  if (exp->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kVarObject) {
  if (exp->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->Kind == kVarParameter) {
# line 137 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 140 "Expressions.puma"
   GetIntConstValue (exp->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->VarParameter.Val, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  }
  }
  break;
  case kVAR_PARAM:
# line 143 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 144 "Expressions.puma"
   GetIntConstValue (exp->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kADDR:
# line 147 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 148 "Expressions.puma"
   GetIntConstValue (exp->ADDR.E, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kCONST_EXP:
  if (exp->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 151 "Expressions.puma"
   * found = true;
   * val = exp->CONST_EXP.C->INT_CONSTANT.value;
   return;

  }
  break;
  case kFUNC_CALL_EXP:
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 154 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 157 "Expressions.puma"
   if (! ((IsIntrCall (exp)))) goto yyL13;
  {
# line 158 "Expressions.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SELECTED_REAL_KIND")))) goto yyL13;
  {
# line 159 "Expressions.puma"
   GetOptParamValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, 0, & yyV1, & yyV2);
# line 160 "Expressions.puma"
   GetOptParamValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, 0, & yyV3, & yyV4);
# line 161 "Expressions.puma"
   if (! ((yyV1 && yyV3))) goto yyL13;
  }
  }
  }
   * found = true;
   * val = selected_real_kind (yyV2, yyV4);
   return;
 }
yyL13:;

  }
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 166 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 169 "Expressions.puma"
   if (! ((IsIntrCall (exp)))) goto yyL14;
  {
# line 170 "Expressions.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SELECTED_REAL_KIND")))) goto yyL14;
  {
# line 171 "Expressions.puma"
   GetOptParamValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, 0, & yyV1, & yyV2);
# line 172 "Expressions.puma"
   if (! ((yyV1))) goto yyL14;
  }
  }
  }
   * found = true;
   * val = selected_real_kind (yyV2, 0);
   return;
 }
yyL14:;

  }
# line 175 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 178 "Expressions.puma"
   if (! ((IsIntrCall (exp)))) goto yyL15;
  {
# line 179 "Expressions.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SELECTED_INT_KIND")))) goto yyL15;
  {
# line 180 "Expressions.puma"
   GetIntConstValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, & yyV1, & yyV2);
# line 181 "Expressions.puma"
   if (! ((yyV1))) goto yyL15;
  }
  }
  }
   * found = true;
   * val = selected_int_kind (yyV2);
   return;
 }
yyL15:;

  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 190 "Expressions.puma"
 {
  type_rec rtype;
  {
# line 193 "Expressions.puma"
   if (! ((IsIntrCall (exp)))) goto yyL16;
  {
# line 194 "Expressions.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("KIND")))) goto yyL16;
  {
# line 196 "Expressions.puma"

# line 198 "Expressions.puma"
   GetExpType (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, & rtype);
  }
  }
  }
   * found = true;
   * val = rtype . type_size;
   return;
 }
yyL16:;

  }
  }
  break;
  }

# line 201 "Expressions.puma"
   * found = false;
   * val = 0;
   return;

;
}

static void GetOptParamValue
# if defined __STDC__ | defined __cplusplus
(register tTree param, register int dval, register bool * yyP2, register int * yyP1)
# else
(param, dval, yyP2, yyP1)
 register tTree param;
 register int dval;
 register bool * yyP2;
 register int * yyP1;
# endif
{
  if (param->Kind == kNO_PARAM) {
# line 206 "Expressions.puma"
   * yyP2 = true;
   * yyP1 = dval;
   return;

  }
  if (param->Kind == kVAR_PARAM) {
# line 209 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 211 "Expressions.puma"
   GetIntConstValue (param, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
# line 214 "Expressions.puma"
   * yyP2 = false;
   * yyP1 = 0;
   return;

;
}

void GetConstDifference
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register tTree exp2, register bool * found, register int * val)
# else
(exp1, exp2, found, val)
 register tTree exp1;
 register tTree exp2;
 register bool * found;
 register int * val;
# endif
{
# line 231 "Expressions.puma"
  {
# line 232 "Expressions.puma"
   if (! (((exp1 == NoTree) || (exp2 == NoTree)))) goto yyL1;
  {
# line 233 "Expressions.puma"
   printf ("Illegal Call of GetConstDifference with NoTree\n");
# line 234 "Expressions.puma"
   kill_in_protocol ();
  }
  }
   * found = false;
   * val = 0;
   return;
yyL1:;

# line 237 "Expressions.puma"
  {
# line 239 "Expressions.puma"
   if (! ( EqualExpression (exp1, exp2 )  == true)) goto yyL2;
  }
   * found = true;
   * val = 0;
   return;
yyL2:;

# line 242 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  bool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  bool yyV9;
  tTree yyV10;
  {
# line 243 "Expressions.puma"
   ResolveExpression (exp1, & yyV1, & yyV2, & yyV3, & yyV4);
# line 244 "Expressions.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 245 "Expressions.puma"
   ResolveExpression (exp2, & yyV5, & yyV6, & yyV7, & yyV8);
# line 246 "Expressions.puma"
   if (! ((yyV5))) goto yyL3;
  {
# line 247 "Expressions.puma"
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
# line 248 "Expressions.puma"
   if (! ((yyV9 == true))) goto yyL3;
  {
# line 249 "Expressions.puma"
   if (! ((yyV2 == yyV6))) goto yyL3;
  }
  }
  }
  }
   * found = true;
   * val = yyV3 - yyV7;
   return;
 }
yyL3:;

  if (exp1->Kind == kSLICE_EXP) {
  if (exp2->Kind == kSLICE_EXP) {
# line 252 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 254 "Expressions.puma"
   GetConstDifference (exp1->SLICE_EXP.START, exp2->SLICE_EXP.START, & yyV1, & yyV2);
# line 255 "Expressions.puma"
   if (! ((yyV1 == true))) goto yyL4;
  {
# line 256 "Expressions.puma"
   GetConstDifference (exp1->SLICE_EXP.STOP, exp2->SLICE_EXP.STOP, & yyV3, & yyV4);
# line 257 "Expressions.puma"
   if (! ((yyV3 == true))) goto yyL4;
  {
# line 258 "Expressions.puma"
   if (! ((yyV2 == yyV4))) goto yyL4;
  {
# line 259 "Expressions.puma"
   if (! (EqualExpression (exp1->SLICE_EXP.INC, exp2->SLICE_EXP.INC))) goto yyL4;
  }
  }
  }
  }
   * found = true;
   * val = yyV2;
   return;
 }
yyL4:;

  }
  }
# line 262 "Expressions.puma"
   * found = false;
   * val = 0;
   return;

;
}

void ResolveExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register bool * found, register int * a, register int * b, register tTree * var)
# else
(exp, found, a, b, var)
 register tTree exp;
 register bool * found;
 register int * a;
 register int * b;
 register tTree * var;
# endif
{
# line 287 "Expressions.puma"
  {
# line 288 "Expressions.puma"
   if (! ((exp == NoTree))) goto yyL1;
  {
# line 289 "Expressions.puma"
   printf ("Call of ResolveExpression with NoTree\n");
# line 290 "Expressions.puma"
   kill_in_protocol ();
  }
  }
   * found = false;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;
yyL1:;

# line 293 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 294 "Expressions.puma"
   GetIntConstValue (exp, & yyV1, & yyV2);
# line 295 "Expressions.puma"
   if (! ((yyV1))) goto yyL2;
  }
   * found = true;
   * a = 0;
   * b = yyV2;
   * var = NoTree;
   return;
 }
yyL2:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 298 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  bool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  bool yyV9;
  tTree yyV10;
  {
# line 299 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3, & yyV4);
# line 300 "Expressions.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 301 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND2, & yyV5, & yyV6, & yyV7, & yyV8);
# line 302 "Expressions.puma"
   if (! ((yyV5))) goto yyL3;
  {
# line 303 "Expressions.puma"
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
# line 304 "Expressions.puma"
   if (! ((yyV9))) goto yyL3;
  }
  }
  }
   * found = true;
   * a = yyV2 + yyV6;
   * b = yyV3 + yyV7;
   * var = yyV10;
   return;
 }
yyL3:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 307 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  bool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  bool yyV9;
  tTree yyV10;
  {
# line 308 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3, & yyV4);
# line 309 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND2, & yyV5, & yyV6, & yyV7, & yyV8);
# line 310 "Expressions.puma"
   if (! ((yyV1 && yyV5))) goto yyL4;
  {
# line 311 "Expressions.puma"
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
# line 312 "Expressions.puma"
   if (! ((yyV9))) goto yyL4;
  }
  }
   * found = true;
   * a = yyV2 - yyV6;
   * b = yyV3 - yyV7;
   * var = yyV10;
   return;
 }
yyL4:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 315 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  int yyV5;
  tTree yyV6;
  {
# line 316 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 317 "Expressions.puma"
   if (! ((yyV1))) goto yyL5;
  {
# line 318 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND2, & yyV3, & yyV4, & yyV5, & yyV6);
# line 319 "Expressions.puma"
   if (! ((yyV3))) goto yyL5;
  }
  }
   * found = true;
   * a = yyV2 * yyV4;
   * b = yyV2 * yyV5;
   * var = yyV6;
   return;
 }
yyL5:;

# line 322 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  int yyV5;
  tTree yyV6;
  {
# line 323 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 324 "Expressions.puma"
   if (! ((yyV1))) goto yyL6;
  {
# line 325 "Expressions.puma"
   ResolveExpression (exp->OP_EXP.OPND1, & yyV3, & yyV4, & yyV5, & yyV6);
# line 326 "Expressions.puma"
   if (! ((yyV3))) goto yyL6;
  }
  }
   * found = yyV3 && yyV1;
   * a = yyV2 * yyV4;
   * b = yyV2 * yyV5;
   * var = yyV6;
   return;
 }
yyL6:;

  }
  }
  if (exp->Kind == kOP1_EXP) {
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 329 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  {
# line 330 "Expressions.puma"
   ResolveExpression (exp->OP1_EXP.OPND, & yyV1, & yyV2, & yyV3, & yyV4);
# line 331 "Expressions.puma"
   if (! ((yyV1))) goto yyL7;
  }
   * found = yyV1;
   * a = - yyV2;
   * b = - yyV3;
   * var = yyV4;
   return;
 }
yyL7:;

  }
  }

  switch (exp->Kind) {
  case kBOUND_EXP:
# line 334 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kVAR_EXP:
# line 337 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp->VAR_EXP.V;
   return;

  case kVAR_PARAM:
# line 340 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp->VAR_PARAM.V;
   return;

  case kUSED_VAR:
# line 343 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kINDEXED_VAR:
# line 346 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kLOOP_VAR:
# line 349 "Expressions.puma"
   * found = true;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kBT_EXP:
  case kDUMMY_EXP:
  case kCONST_EXP:
  case kOP_EXP:
  case kOP1_EXP:
  case kSLICE_EXP:
  case kFUNC_CALL_EXP:
  case kNAMED_EXP:
  case kDO_EXP:
  case kTYPE_EXP:
  case kARRAY_EXP:
  case kPERM_EXP:
  case kRANK_EXP:
# line 352 "Expressions.puma"
   * found = false;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

  case kBT_PARAM:
  case kVALUE_PARAM:
  case kNAMED_PARAM:
  case kPROC_PARAM:
  case kFUNC_PARAM:
  case kFORMAT_PARAM:
  case kRETURN_PARAM:
  case kNO_PARAM:
# line 355 "Expressions.puma"
   * found = false;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

  case kBT_VAR:
  case kDUMMY_VAR:
  case kSUBSTRING_VAR:
  case kSELECTED_VAR:
  case kPERM_VAR:
  case kADDR:
  case kDO_VAR:
  case kREMOTE_VAR:
# line 358 "Expressions.puma"
   * found = false;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

  }

# line 361 "Expressions.puma"
  {
# line 363 "Expressions.puma"
   failure_protocol (MODULE, "ReplaceExp", exp);
  }
   * found = false;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

;
}

static void MergeVars
# if defined __STDC__ | defined __cplusplus
(register int a1, register tTree v1, register int a2, register tTree v2, register bool * ok, register tTree * var)
# else
(a1, v1, a2, v2, ok, var)
 register int a1;
 register tTree v1;
 register int a2;
 register tTree v2;
 register bool * ok;
 register tTree * var;
# endif
{
  if (equalint (a1, 0)) {
# line 369 "Expressions.puma"
   * ok = true;
   * var = v2;
   return;

  }
  if (equalint (a2, 0)) {
# line 372 "Expressions.puma"
   * ok = true;
   * var = v1;
   return;

  }
# line 375 "Expressions.puma"
  {
# line 376 "Expressions.puma"
   if (! ( EqualExpression (v1, v2)  == true)) goto yyL3;
  }
   * ok = true;
   * var = v1;
   return;
yyL3:;

# line 379 "Expressions.puma"
   * ok = false;
   * var = NoTree;
   return;

;
}

bool EqualExpression
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2)
# else
(e1, e2)
 register tTree e1;
 register tTree e2;
# endif
{
# line 391 "Expressions.puma"
 {
  bool found;
  int val1;
  int val2;
  {
# line 393 "Expressions.puma"

# line 394 "Expressions.puma"

# line 395 "Expressions.puma"

# line 397 "Expressions.puma"
 GetIntConstValue (e1, &found, &val1); 
# line 398 "Expressions.puma"
   if (! ((found))) goto yyL1;
  {
# line 399 "Expressions.puma"
 GetIntConstValue (e2, &found, &val2); 
# line 400 "Expressions.puma"
   if (! ((found))) goto yyL1;
  {
# line 401 "Expressions.puma"
   if (! ((val1 == val2))) goto yyL1;
  }
  }
  }
   return true;
 }
yyL1:;


  switch (e1->Kind) {
  case kSLICE_EXP:
  if (e2->Kind == kSLICE_EXP) {
# line 404 "Expressions.puma"
  {
# line 406 "Expressions.puma"
   if (! ((EqualExpression (e1->SLICE_EXP.START, e2->SLICE_EXP.START)))) goto yyL2;
  {
# line 407 "Expressions.puma"
   if (! ((EqualExpression (e1->SLICE_EXP.STOP, e2->SLICE_EXP.STOP)))) goto yyL2;
  {
# line 408 "Expressions.puma"
   if (! ((EqualExpression (e1->SLICE_EXP.INC, e2->SLICE_EXP.INC)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  }
  break;
  case kDUMMY_EXP:
  if (e2->Kind == kDUMMY_EXP) {
# line 411 "Expressions.puma"
   return true;

  }
  break;
  case kVAR_EXP:
  if (e2->Kind == kVAR_EXP) {
# line 414 "Expressions.puma"
  {
# line 415 "Expressions.puma"
   if (! (EqualExpression (e1->VAR_EXP.V, e2->VAR_EXP.V))) goto yyL4;
  }
   return true;
yyL4:;

  }
  break;
  case kSELECTED_VAR:
  if (e2->Kind == kSELECTED_VAR) {
# line 418 "Expressions.puma"
  {
# line 421 "Expressions.puma"
   if (! ((e1->SELECTED_VAR.SELECTOR->REC_COMP.Object == e2->SELECTED_VAR.SELECTOR->REC_COMP.Object))) goto yyL5;
  {
# line 422 "Expressions.puma"
   if (! (EqualExpression (e1->SELECTED_VAR.SELEC_VAR, e2->SELECTED_VAR.SELEC_VAR))) goto yyL5;
  }
  }
   return true;
yyL5:;

  }
  break;
  case kINDEXED_VAR:
  if (e2->Kind == kINDEXED_VAR) {
# line 427 "Expressions.puma"
  {
# line 429 "Expressions.puma"
   if (! ((EqualExpression (e1->INDEXED_VAR.IND_VAR, e2->INDEXED_VAR.IND_VAR)))) goto yyL6;
  {
# line 430 "Expressions.puma"
   if (! ((EqualIndexes (e1->INDEXED_VAR.IND_EXPS, e2->INDEXED_VAR.IND_EXPS)))) goto yyL6;
  }
  }
   return true;
yyL6:;

  }
  break;
  case kUSED_VAR:
  if (e2->Kind == kUSED_VAR) {
# line 433 "Expressions.puma"
  {
# line 434 "Expressions.puma"
   if (! (EqualExpression (e1->USED_VAR.VARNAME, e2->USED_VAR.VARNAME))) goto yyL7;
  }
   return true;
yyL7:;

  }
  break;
  case kLOOP_VAR:
  if (e2->Kind == kLOOP_VAR) {
# line 437 "Expressions.puma"
  {
# line 438 "Expressions.puma"
   if (! (EqualExpression (e1->LOOP_VAR.LOOP_VARNAME, e2->LOOP_VAR.LOOP_VARNAME))) goto yyL8;
  }
   return true;
yyL8:;

  }
  break;
  case kVAR_OBJ:
  if (e2->Kind == kVAR_OBJ) {
# line 441 "Expressions.puma"
  {
# line 443 "Expressions.puma"
   if (! ((e1->VAR_OBJ.Ident == e2->VAR_OBJ.Ident))) goto yyL9;
  }
   return true;
yyL9:;

  }
  break;
  case kOP_EXP:
  if (e2->Kind == kOP_EXP) {
# line 447 "Expressions.puma"
  {
# line 449 "Expressions.puma"
   if (! (e1->OP_EXP.EXP_OP -> Kind == e2->OP_EXP.EXP_OP -> Kind)) goto yyL10;
  {
# line 450 "Expressions.puma"
   if (! (EqualExpression (e1->OP_EXP.OPND1, e2->OP_EXP.OPND1))) goto yyL10;
  {
# line 451 "Expressions.puma"
   if (! (EqualExpression (e1->OP_EXP.OPND2, e2->OP_EXP.OPND2))) goto yyL10;
  }
  }
  }
   return true;
yyL10:;

  }
  break;
  case kOP1_EXP:
  if (e2->Kind == kOP1_EXP) {
# line 454 "Expressions.puma"
  {
# line 456 "Expressions.puma"
   if (! (e1->OP1_EXP.EXP_OP1 -> Kind == e2->OP1_EXP.EXP_OP1 -> Kind)) goto yyL11;
  {
# line 457 "Expressions.puma"
   if (! (EqualExpression (e1->OP1_EXP.OPND, e2->OP1_EXP.OPND))) goto yyL11;
  }
  }
   return true;
yyL11:;

  }
  break;
  case kBOUND_EXP:
  if (e2->Kind == kBOUND_EXP) {
# line 460 "Expressions.puma"
  {
# line 462 "Expressions.puma"
   if (! ((e1->BOUND_EXP.dim == e2->BOUND_EXP.dim))) goto yyL12;
  {
# line 463 "Expressions.puma"
   if (! ((e1->BOUND_EXP.kind == e2->BOUND_EXP.kind))) goto yyL12;
  {
# line 464 "Expressions.puma"
   if (! ((e1->BOUND_EXP.local == e2->BOUND_EXP.local))) goto yyL12;
  {
# line 465 "Expressions.puma"
   if (! ((EqualExpression (e1->BOUND_EXP.VAR, e2->BOUND_EXP.VAR)))) goto yyL12;
  }
  }
  }
  }
   return true;
yyL12:;

  }
  break;
  case kRANK_EXP:
  if (e2->Kind == kRANK_EXP) {
# line 471 "Expressions.puma"
  {
# line 473 "Expressions.puma"
   if (! ((e1->RANK_EXP.kind == e2->RANK_EXP.kind))) goto yyL13;
  }
   return true;
yyL13:;

  }
  break;
  case kFUNC_CALL_EXP:
  if (e2->Kind == kFUNC_CALL_EXP) {
# line 476 "Expressions.puma"
  {
# line 479 "Expressions.puma"
   if (! ((IsPureCall (e1)))) goto yyL14;
  {
# line 480 "Expressions.puma"
   if (! ((IsPureCall (e2)))) goto yyL14;
  {
# line 481 "Expressions.puma"
   if (! ((e1->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == e2->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object))) goto yyL14;
  {
# line 482 "Expressions.puma"
   if (! ((EqualParameters (e1->FUNC_CALL_EXP.FUNC_PARAMS, e2->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL14;
  }
  }
  }
  }
   return true;
yyL14:;

# line 493 "Expressions.puma"
  {
# line 496 "Expressions.puma"
   if (! ((IsIntrCall (e1)))) goto yyL16;
  {
# line 497 "Expressions.puma"
   if (! ((IsIntrCall (e2)))) goto yyL16;
  {
# line 498 "Expressions.puma"
   if (! ((e1->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == e2->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object))) goto yyL16;
  {
# line 499 "Expressions.puma"
   if (! ((IntrFuncInquiry (e1->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL16;
  {
# line 500 "Expressions.puma"
   if (! ((EqualParameters (e1->FUNC_CALL_EXP.FUNC_PARAMS, e2->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL16;
  }
  }
  }
  }
  }
   return true;
yyL16:;

  }
  if (e1->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_EMPTY) {
  if (e2->Kind == kFUNC_CALL_EXP) {
  if (e2->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_EMPTY) {
# line 485 "Expressions.puma"
  {
# line 488 "Expressions.puma"
   if (! ((IsIntrCall (e1)))) goto yyL15;
  {
# line 489 "Expressions.puma"
   if (! ((IsIntrCall (e2)))) goto yyL15;
  {
# line 490 "Expressions.puma"
   if (! ((e1->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == e2->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object))) goto yyL15;
  }
  }
  }
   return true;
yyL15:;

  }
  }
  }
  break;
  }

  return false;
}

bool EqualIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes1, register tTree indexes2)
# else
(indexes1, indexes2)
 register tTree indexes1;
 register tTree indexes2;
# endif
{
  if (indexes1->Kind == kBTE_LIST) {
  if (indexes2->Kind == kBTE_LIST) {
# line 506 "Expressions.puma"
  {
# line 508 "Expressions.puma"
   if (! ((EqualExpression (indexes1->BTE_LIST.Elem, indexes2->BTE_LIST.Elem)))) goto yyL1;
  {
# line 509 "Expressions.puma"
   if (! ((EqualIndexes (indexes1->BTE_LIST.Next, indexes2->BTE_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  if (indexes1->Kind == kBTE_EMPTY) {
  if (indexes2->Kind == kBTE_EMPTY) {
# line 512 "Expressions.puma"
   return true;

  }
  }
  return false;
}

static bool EqualParameters
# if defined __STDC__ | defined __cplusplus
(register tTree paramlist1, register tTree paramlist2)
# else
(paramlist1, paramlist2)
 register tTree paramlist1;
 register tTree paramlist2;
# endif
{
  if (paramlist1->Kind == kBTP_LIST) {
  if (paramlist2->Kind == kBTP_LIST) {
# line 518 "Expressions.puma"
  {
# line 520 "Expressions.puma"
   if (! ((EqualParameters (paramlist1->BTP_LIST.Elem, paramlist2->BTP_LIST.Elem)))) goto yyL1;
  {
# line 521 "Expressions.puma"
   if (! ((EqualParameters (paramlist1->BTP_LIST.Next, paramlist2->BTP_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  if (paramlist1->Kind == kBTP_EMPTY) {
  if (paramlist2->Kind == kBTP_EMPTY) {
# line 524 "Expressions.puma"
   return true;

  }
  }
  if (paramlist1->Kind == kNO_PARAM) {
  if (paramlist2->Kind == kNO_PARAM) {
# line 527 "Expressions.puma"
   return true;

  }
  }
  if (paramlist1->Kind == kVAR_PARAM) {
  if (paramlist1->VAR_PARAM.V->Kind == kADDR) {
  if (paramlist2->Kind == kVAR_PARAM) {
  if (paramlist2->VAR_PARAM.V->Kind == kADDR) {
# line 530 "Expressions.puma"
  {
# line 532 "Expressions.puma"
   if (! ((EqualExpression (paramlist1->VAR_PARAM.V->ADDR.E, paramlist2->VAR_PARAM.V->ADDR.E)))) goto yyL4;
  }
   return true;
yyL4:;

  }
  }
  }
  if (paramlist2->Kind == kVAR_PARAM) {
# line 535 "Expressions.puma"
  {
# line 537 "Expressions.puma"
   if (! ((EqualExpression (paramlist1->VAR_PARAM.V, paramlist2->VAR_PARAM.V)))) goto yyL5;
  }
   return true;
yyL5:;

  }
  }
  return false;
}

tTree MakeNotExp
# if defined __STDC__ | defined __cplusplus
(register tTree e)
# else
(e)
 register tTree e;
# endif
{
  if (e->Kind == kOP1_EXP) {
  if (e->OP1_EXP.EXP_OP1->Kind == kOP1_NOT) {
# line 548 "Expressions.puma"
   return e->OP1_EXP.OPND;

  }
  }
  if (e->Kind == kOP_EXP) {
  if (e->OP_EXP.EXP_OP->Kind == kOP_LT) {
# line 552 "Expressions.puma"
  {
# line 553 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_GE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_LE) {
# line 557 "Expressions.puma"
  {
# line 558 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_GT ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_GT) {
# line 562 "Expressions.puma"
  {
# line 563 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_LE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_GE) {
# line 567 "Expressions.puma"
  {
# line 568 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_LT ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_EQ) {
# line 572 "Expressions.puma"
  {
# line 573 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_NE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_NE) {
# line 577 "Expressions.puma"
  {
# line 578 "Expressions.puma"
   e->OP_EXP.EXP_OP = mOP_NE ();
  }
   return e;

  }
  }
# line 582 "Expressions.puma"
   return mOP1_EXP (mOP1_NOT (), e);

}

void SliceIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register bool * yyP4, register int * yyP3)
# else
(exp, yyP4, yyP3)
 register tTree exp;
 register bool * yyP4;
 register int * yyP3;
# endif
{
  if (exp->Kind == kSLICE_EXP) {
# line 588 "Expressions.puma"
 {
  bool found;
  int val;
  {
# line 590 "Expressions.puma"

# line 591 "Expressions.puma"

# line 592 "Expressions.puma"
 if (exp->SLICE_EXP.INC == NoTree)
        { found = true;
          val   = 1;
        }
       else if (exp->SLICE_EXP.INC->Kind == kDUMMY_EXP)
        { found = true;
          val   = 1;
        }
       else
        GetIntConstValue (exp->SLICE_EXP.INC, &found, &val);
    
  }
   * yyP4 = found;
   * yyP3 = val;
   return;
 }

  }
# line 605 "Expressions.puma"
  {
# line 607 "Expressions.puma"
   failure_protocol (MODULE, "SliceIncrement", exp);
  }
   * yyP4 = false;
   * yyP3 = 0;
   return;

;
}

tTree MakeSliceExp
# if defined __STDC__ | defined __cplusplus
(register tTree start, register tTree stop)
# else
(start, stop)
 register tTree start;
 register tTree stop;
# endif
{
# line 620 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 621 "Expressions.puma"
   GetIntConstValue (start, & yyV1, & yyV2);
# line 622 "Expressions.puma"
   if (! ((yyV1))) goto yyL1;
  }
  {
   return AddConstant (stop, 1 - yyV2);
  }
 }
yyL1:;

# line 626 "Expressions.puma"
   return AddConstant (mOP_EXP (mOP_MINUS (), stop, start), 1);

}

tTree MakeRangeExp
# if defined __STDC__ | defined __cplusplus
(register tTree start, register tTree stop, register tTree inc)
# else
(start, stop, inc)
 register tTree start;
 register tTree stop;
 register tTree inc;
# endif
{
# line 643 "Expressions.puma"
  {
# line 644 "Expressions.puma"
   if (! ((inc == NoTree))) goto yyL1;
  }
   return MakeSliceExp (start, stop);
yyL1:;

  if (inc->Kind == kDUMMY_EXP) {
# line 648 "Expressions.puma"
   return MakeSliceExp (start, stop);

  }
# line 653 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  tTree new;
  {
# line 655 "Expressions.puma"
   GetIntConstValue (start, & yyV1, & yyV2);
# line 656 "Expressions.puma"
   GetIntConstValue (inc, & yyV3, & yyV4);
# line 658 "Expressions.puma"

# line 660 "Expressions.puma"
 if (yyV1)
         new = AddConstant (stop, yyV2);
       else
         new = mOP_EXP (mOP_MINUS(), stop, start);
      if (yyV3)
         new = DivConstant (new, yyV4);
       else
         new = mOP_EXP (mOP_DIVIDE (), new, inc);
    
  }
  {
   return AddConstant (new, 1);
  }
 }

}

tTree AddConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c)
# else
(exp, c)
 register tTree exp;
 register int c;
# endif
{
  if (equalint (c, 0)) {
# line 684 "Expressions.puma"
   return exp;

  }
# line 688 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 689 "Expressions.puma"
   GetIntConstValue (exp, & yyV1, & yyV2);
# line 690 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL2;
  }
  {
   return MakeConstant (c + yyV2);
  }
 }
yyL2:;

  if (exp->Kind == kSLICE_EXP) {
# line 694 "Expressions.puma"
  {
# line 696 "Expressions.puma"
   exp->SLICE_EXP.START = AddConstant (exp->SLICE_EXP.START, c);
# line 697 "Expressions.puma"
   exp->SLICE_EXP.STOP = AddConstant (exp->SLICE_EXP.STOP, c);
  }
   return exp;

  }
  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 707 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 708 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 709 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL4;
  }
  {
   return AddConstant (exp->OP_EXP.OPND2, c + yyV2);
  }
 }
yyL4:;

# line 713 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 714 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 715 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL5;
  }
  {
   return AddConstant (exp->OP_EXP.OPND1, c + yyV2);
  }
 }
yyL5:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 719 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 720 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 721 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL6;
  }
  {
   return AddConstant (exp->OP_EXP.OPND1, c - yyV2);
  }
 }
yyL6:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
# line 727 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 728 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 729 "Expressions.puma"
   if (! (yyV1 == true)) goto yyL7;
  {
# line 730 "Expressions.puma"
 exp->OP_EXP.OPND1 = AddConstant (exp->OP_EXP.OPND1, c*yyV2); 
  }
  }
  {
   return exp;
  }
 }
yyL7:;

  }
  }
# line 734 "Expressions.puma"
  {
# line 735 "Expressions.puma"
   if (! ((c > 0))) goto yyL8;
  }
   return mOP_EXP (mOP_PLUS (), exp, mCONST_EXP (mINT_CONSTANT (c)));
yyL8:;

# line 739 "Expressions.puma"
  {
# line 740 "Expressions.puma"
   if (! (c < 0)) goto yyL9;
  }
   return mOP_EXP (mOP_MINUS (), exp, mCONST_EXP (mINT_CONSTANT (- c)));
yyL9:;

 yyAbort ("AddConstant");
}

tTree MakeConstant
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
# line 746 "Expressions.puma"
  {
# line 747 "Expressions.puma"
   if (! ((n >= 0))) goto yyL1;
  }
   return mCONST_EXP (mINT_CONSTANT (n));
yyL1:;

# line 751 "Expressions.puma"
   return mOP1_EXP (mOP1_SIGN (), mCONST_EXP (mINT_CONSTANT (- n)));

}

tTree MultConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c)
# else
(exp, c)
 register tTree exp;
 register int c;
# endif
{
  if (equalint (c, 0)) {
# line 762 "Expressions.puma"
   return MakeConstant (0);

  }
  if (equalint (c, 1)) {
# line 766 "Expressions.puma"
   return exp;

  }
# line 770 "Expressions.puma"
  {
# line 771 "Expressions.puma"
   if (! ((c < 0))) goto yyL3;
  }
   return MinusExpression (MultConstant (exp, - c));
yyL3:;

# line 775 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 776 "Expressions.puma"
   GetIntConstValue (exp, & yyV1, & yyV2);
# line 777 "Expressions.puma"
   if (! ((yyV1))) goto yyL4;
  }
  {
   return MakeConstant (c * yyV2);
  }
 }
yyL4:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 781 "Expressions.puma"
  {
# line 782 "Expressions.puma"
 exp->OP_EXP.OPND1 = MultConstant (exp->OP_EXP.OPND1, c);
     exp->OP_EXP.OPND2 = MultConstant (exp->OP_EXP.OPND2, c);
   
  }
   return exp;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 788 "Expressions.puma"
  {
# line 789 "Expressions.puma"
 exp->OP_EXP.OPND1 = MultConstant (exp->OP_EXP.OPND1, c);
     exp->OP_EXP.OPND2 = MultConstant (exp->OP_EXP.OPND2, c);
   
  }
   return exp;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 795 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 796 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 797 "Expressions.puma"
   if (! ((yyV1))) goto yyL7;
  {
# line 798 "Expressions.puma"
 exp->OP_EXP.OPND1 = MakeConstant (c * yyV2); 
  }
  }
  {
   return exp;
  }
 }
yyL7:;

# line 802 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 803 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 804 "Expressions.puma"
   if (! ((yyV1))) goto yyL8;
  {
# line 805 "Expressions.puma"
 exp->OP_EXP.OPND2 = MakeConstant (c * yyV2); 
  }
  }
  {
   return exp;
  }
 }
yyL8:;

  }
  }
# line 809 "Expressions.puma"
   return mOP_EXP (mOP_TIMES (), exp, MakeConstant (c));

}

tTree DivConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c)
# else
(exp, c)
 register tTree exp;
 register int c;
# endif
{
  if (equalint (c, 0)) {
# line 828 "Expressions.puma"
   return MakeConstant (0);

  }
  if (equalint (c, 1)) {
# line 832 "Expressions.puma"
   return exp;

  }
# line 836 "Expressions.puma"
  {
# line 837 "Expressions.puma"
   if (! ((c < 0))) goto yyL3;
  }
   return MinusExpression (DivConstant (exp, - c));
yyL3:;

  if (exp->Kind == kCONST_EXP) {
  if (exp->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 841 "Expressions.puma"
  {
# line 842 "Expressions.puma"
   if (! ((exp->CONST_EXP.C->INT_CONSTANT.value % c == 0))) goto yyL4;
  {
# line 843 "Expressions.puma"
   exp->CONST_EXP.C->INT_CONSTANT.value = exp->CONST_EXP.C->INT_CONSTANT.value / c;
  }
  }
   return exp;
yyL4:;

  }
  }
  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 847 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 848 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 849 "Expressions.puma"
   if (! ((yyV2 % c == 0))) goto yyL5;
  {
# line 850 "Expressions.puma"
 exp->OP_EXP.OPND1 = DivConstant (exp->OP_EXP.OPND1, c);
     exp->OP_EXP.OPND2 = MakeConstant (yyV2 / c);
   
  }
  }
  {
   return exp;
  }
 }
yyL5:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 856 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 857 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 858 "Expressions.puma"
   if (! ((yyV2 == c))) goto yyL6;
  }
  {
   return exp->OP_EXP.OPND2;
  }
 }
yyL6:;

# line 862 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 863 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 864 "Expressions.puma"
   if (! ((yyV2 % c == 0))) goto yyL7;
  {
# line 865 "Expressions.puma"
 exp->OP_EXP.OPND1 = DivConstant (exp->OP_EXP.OPND1, c); 
  }
  }
  {
   return exp;
  }
 }
yyL7:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 869 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 870 "Expressions.puma"
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
# line 871 "Expressions.puma"
   if (! ((yyV2 % c == 0))) goto yyL8;
  {
# line 872 "Expressions.puma"
 exp->OP_EXP.OPND1 = DivConstant (exp->OP_EXP.OPND1, c);
     exp->OP_EXP.OPND2 = MakeConstant (yyV2 / c);
   
  }
  }
  {
   return exp;
  }
 }
yyL8:;

  }
  }
# line 878 "Expressions.puma"
   return mOP_EXP (mOP_DIVIDE (), exp, MakeConstant (c));

}

tTree MinusExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 892 "Expressions.puma"
 {
  tTree he;
  {
# line 894 "Expressions.puma"

# line 896 "Expressions.puma"
 he = exp->OP_EXP.OPND1;
     exp->OP_EXP.OPND1 = exp->OP_EXP.OPND2;
     exp->OP_EXP.OPND2 = he;
   
  }
  {
   return exp;
  }
 }

  }
  }
  if (exp->Kind == kOP1_EXP) {
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 903 "Expressions.puma"
   return exp->OP1_EXP.OPND;

  }
  }
# line 907 "Expressions.puma"
   return mOP1_EXP (mOP1_SIGN (), exp);

}

tTree InverseExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
# line 921 "Expressions.puma"
 {
  tTree he;
  {
# line 923 "Expressions.puma"

# line 925 "Expressions.puma"
 he = exp->OP_EXP.OPND1;
     exp->OP_EXP.OPND1 = exp->OP_EXP.OPND2;
     exp->OP_EXP.OPND2 = he;
   
  }
  {
   return exp;
  }
 }

  }
  }
# line 932 "Expressions.puma"
   return mOP_EXP (mOP_DIVIDE (), MakeConstant (1), exp);

}

bool IsStride1
# if defined __STDC__ | defined __cplusplus
(register tTree stride)
# else
(stride)
 register tTree stride;
# endif
{
# line 944 "Expressions.puma"
  {
# line 945 "Expressions.puma"
   if (! ((stride == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

  if (stride->Kind == kDUMMY_EXP) {
# line 948 "Expressions.puma"
   return true;

  }
# line 951 "Expressions.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 953 "Expressions.puma"
   GetIntConstValue (stride, & yyV1, & yyV2);
# line 954 "Expressions.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 955 "Expressions.puma"
   if (! ((yyV2 == 1))) goto yyL3;
  }
  }
   return true;
 }
yyL3:;

  return false;
}

void BeginExpressions ()
{
}

void CloseExpressions ()
{
}
