# include "Expansion.h"
# include "yyExpansion.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 52 "Expansion.puma"


# undef DEBUG

# include "Idents.h"
# include "protocol.h"

# include "Nesting.h"       /* OuterLoops, GetLoopId, ... */
# include "ParNest.h"
# include "TreeOps.h"       /* IsForallLoop, IsIndepLoop  */
# include "Expressions.h"   /* MakeConstant               */
# include "Invariant.h"     /* ResolveLoopVar             */

# define MODULE "Expansion"



static void yyExit () { Exit (1); }

void (* Expansion_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Expansion, routine %s failed\n", yyFunction);
 Expansion_Exit ();
}

void NoExpansion ARGS((pvar vard));
void FullExpansion ARGS((pvar vard));
void ForallExpansion ARGS((pvar vard));
void ParallelExpansion ARGS((pvar vard));
static void Expansion ARGS((pvar vard, tTree id, tTree range));
static void ExpandDim ARGS((pvar vard, int dim, tTree id, tTree range));
static bool HasId ARGS((tIdent id, tTree e1, tTree e2));
static void GetDimSpec ARGS((pvar vard, int dim, tTree * yyP4, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void SetDimSpec ARGS((pvar vard, int dim, tTree lb, tTree ub));
static void ExpandIt ARGS((tTree actual_lb, tTree actual_ub, tTree formal_lb, tTree formal_ub, tTree id, tTree range, tTree * yyP6, tTree * yyP5));
static void MakeExpansionRange ARGS((tTree lb, tTree ub, tTree inc, tTree full_lb, tTree full_ub, tTree * yyP8, tTree * yyP7));
static bool IsPositive ARGS((tTree inc));
static bool IsNegative ARGS((tTree inc));

void NoExpansion
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 77 "Expansion.puma"
  {
# line 79 "Expansion.puma"
 int dim;
 
    for (dim=0; dim < vard->formal_rank; dim++)

      { tTree lb, ub, inc, f_lb, f_ub, e_lb, e_ub;

        lb  = vard->actual_shape[dim][0];
        ub  = vard->actual_shape[dim][1];
        inc = vard->actual_shape[dim][2];

        f_lb = vard->formal_shape[dim][0];
        f_ub = vard->formal_shape[dim][1];

        MakeExpansionRange (lb, ub, inc, f_lb, f_ub, &e_lb, &e_ub);

        vard->expand_shape[dim][0] = e_lb;
        vard->expand_shape[dim][1] = e_ub;
      }

    vard->expanded = true;

  
  }
   return;

;
}

void FullExpansion
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 116 "Expansion.puma"
  {
# line 118 "Expansion.puma"
 int dim;
 
    for (dim=0; dim < vard->formal_rank; dim++)

      { tTree f_lb, f_ub;

        f_lb = vard->alloc_shape[dim][0];
        f_ub = vard->alloc_shape[dim][1];

        vard->expand_shape[dim][0] = f_lb;
        vard->expand_shape[dim][1] = f_ub;
      }

    vard->expanded = true;

  
  }
   return;

;
}

void ForallExpansion
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 161 "Expansion.puma"
  {
# line 163 "Expansion.puma"
 int n;
    tTree loop;

    NoExpansion (vard);      

    

    for (n = OuterLoops(); n >= 1; n--)

       if (IsForallLoop (loop = GetOuterLoop (n)))

          Expansion (vard, GetLoopId (loop), GetLoopSlice (loop));
  
  }
   return;

;
}

void ParallelExpansion
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 195 "Expansion.puma"
  {
# line 198 "Expansion.puma"
 int n;
    tTree loop;

    NoExpansion (vard);      

    

    for (n = GetParNestingDepth (); n >= 1; n--)

       if (IsCountLoop (loop = GetParNestACF (n)))

          Expansion (vard, GetLoopId (loop), GetLoopSlice (loop));

  
  }
   return;

;
}

static void Expansion
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tTree id, register tTree range)
# else
(vard, id, range)
 pvar vard;
 register tTree id;
 register tTree range;
# endif
{
# line 225 "Expansion.puma"
 {
  int dim;
  {
# line 227 "Expansion.puma"

# line 229 "Expansion.puma"
 for (dim=1; dim <= vard->formal_rank; dim++)

        ExpandDim (vard, dim, id, range);
   
  }
   return;
 }

;
}

static void ExpandDim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim, register tTree id, register tTree range)
# else
(vard, dim, id, range)
 pvar vard;
 register int dim;
 register tTree id;
 register tTree range;
# endif
{
# line 247 "Expansion.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 249 "Expansion.puma"
   GetDimSpec (vard, dim, & yyV1, & yyV2, & yyV3, & yyV4);
# line 252 "Expansion.puma"
   if (! ((HasId (TreeVarName (id), yyV1, yyV2)))) goto yyL1;
  {
# line 256 "Expansion.puma"
   ExpandIt (yyV1, yyV2, yyV3, yyV4, id, range, & yyV5, & yyV6);
# line 259 "Expansion.puma"
   SetDimSpec (vard, dim, yyV5, yyV6);
  }
  }
   return;
 }
yyL1:;

;
}

static bool HasId
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree e1, register tTree e2)
# else
(id, e1, e2)
 register tIdent id;
 register tTree e1;
 register tTree e2;
# endif
{
# line 272 "Expansion.puma"
  {
# line 272 "Expansion.puma"
   if (! ((IsVarInExp (id, e1)))) goto yyL1;
  }
   return true;
yyL1:;

# line 273 "Expansion.puma"
  {
# line 273 "Expansion.puma"
   if (! ((IsVarInExp (id, e2)))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

static void GetDimSpec
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim, register tTree * yyP4, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(vard, dim, yyP4, yyP3, yyP2, yyP1)
 pvar vard;
 register int dim;
 register tTree * yyP4;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 283 "Expansion.puma"
   * yyP4 = vard -> expand_shape [dim - 1] [0];
   * yyP3 = vard -> expand_shape [dim - 1] [1];
   * yyP2 = vard -> formal_shape [dim - 1] [0];
   * yyP1 = vard -> formal_shape [dim - 1] [1];
   return;

;
}

static void SetDimSpec
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim, register tTree lb, register tTree ub)
# else
(vard, dim, lb, ub)
 pvar vard;
 register int dim;
 register tTree lb;
 register tTree ub;
# endif
{
# line 295 "Expansion.puma"
  {
# line 298 "Expansion.puma"
 vard->expand_shape[dim-1][0] = lb;
    vard->expand_shape[dim-1][1] = ub;
  
  }
   return;

;
}

static void ExpandIt
# if defined __STDC__ | defined __cplusplus
(register tTree actual_lb, register tTree actual_ub, register tTree formal_lb, register tTree formal_ub, register tTree id, register tTree range, register tTree * yyP6, register tTree * yyP5)
# else
(actual_lb, actual_ub, formal_lb, formal_ub, id, range, yyP6, yyP5)
 register tTree actual_lb;
 register tTree actual_ub;
 register tTree formal_lb;
 register tTree formal_ub;
 register tTree id;
 register tTree range;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
# line 313 "Expansion.puma"
 {
  tTree new_lb;
  tTree new_ub;
  tTree new_inc;
  bool found;
  int val;
  tTree yyV1;
  tTree yyV2;
  {
# line 315 "Expansion.puma"
   if (! ((actual_lb == actual_ub))) goto yyL1;
  {
# line 317 "Expansion.puma"

# line 318 "Expansion.puma"

# line 319 "Expansion.puma"

# line 321 "Expansion.puma"

# line 322 "Expansion.puma"

# line 324 "Expansion.puma"
   ResolveLoopVar (actual_lb, id, & found, & val);
# line 325 "Expansion.puma"
   if (! ((found))) goto yyL1;
  {
# line 327 "Expansion.puma"
   MakeVector (CopyTree (actual_lb), id, val, range, & new_lb, & new_ub, & new_inc);
# line 330 "Expansion.puma"
   MakeExpansionRange (new_lb, new_ub, new_inc, formal_lb, formal_ub, & yyV1, & yyV2);
  }
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL1:;

# line 334 "Expansion.puma"
   * yyP6 = formal_lb;
   * yyP5 = formal_ub;
   return;

;
}

static void MakeExpansionRange
# if defined __STDC__ | defined __cplusplus
(register tTree lb, register tTree ub, register tTree inc, register tTree full_lb, register tTree full_ub, register tTree * yyP8, register tTree * yyP7)
# else
(lb, ub, inc, full_lb, full_ub, yyP8, yyP7)
 register tTree lb;
 register tTree ub;
 register tTree inc;
 register tTree full_lb;
 register tTree full_ub;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
# line 351 "Expansion.puma"
  {
# line 353 "Expansion.puma"
   if (! ((lb == ub))) goto yyL1;
  }
   * yyP8 = lb;
   * yyP7 = ub;
   return;
yyL1:;

# line 356 "Expansion.puma"
  {
# line 358 "Expansion.puma"
   if (! ((IsPositive (inc)))) goto yyL2;
  }
   * yyP8 = lb;
   * yyP7 = ub;
   return;
yyL2:;

# line 361 "Expansion.puma"
  {
# line 363 "Expansion.puma"
   if (! ((IsNegative (inc)))) goto yyL3;
  }
   * yyP8 = ub;
   * yyP7 = lb;
   return;
yyL3:;

# line 366 "Expansion.puma"
   * yyP8 = full_lb;
   * yyP7 = full_ub;
   return;

;
}

static bool IsPositive
# if defined __STDC__ | defined __cplusplus
(register tTree inc)
# else
(inc)
 register tTree inc;
# endif
{
# line 379 "Expansion.puma"
  {
# line 380 "Expansion.puma"
   if (! ((inc == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

  if (inc->Kind == kDUMMY_EXP) {
# line 383 "Expansion.puma"
   return true;

  }
# line 386 "Expansion.puma"
 {
  bool found;
  int val;
  {
# line 388 "Expansion.puma"

# line 389 "Expansion.puma"

# line 391 "Expansion.puma"
   GetIntConstValue (inc, & found, & val);
# line 392 "Expansion.puma"
   if (! ((found))) goto yyL3;
  {
# line 393 "Expansion.puma"
   if (! ((val > 0))) goto yyL3;
  }
  }
   return true;
 }
yyL3:;

  return false;
}

static bool IsNegative
# if defined __STDC__ | defined __cplusplus
(register tTree inc)
# else
(inc)
 register tTree inc;
# endif
{
# line 406 "Expansion.puma"
 {
  bool found;
  int val;
  {
# line 408 "Expansion.puma"

# line 409 "Expansion.puma"

# line 411 "Expansion.puma"
   GetIntConstValue (inc, & found, & val);
# line 412 "Expansion.puma"
   if (! ((found))) goto yyL1;
  {
# line 413 "Expansion.puma"
   if (! ((val < 0))) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

  return false;
}

void BeginExpansion ()
{
}

void CloseExpansion ()
{
}
