# include "ExpNormal.h"
# include "yyExpNormal.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 58 "ExpNormal.puma"


# include "Tree.h"
# include "Idents.h"
# include "StringMem.h"

# define MODULE "ExpNormal"
# undef DEBUG

void PrintNormRecord (s, e, loops, n)
char s[];
ExpNormRecord e;
tTree loops[];
int n;

{  int i;
   printf ("Normalized Expression %s in %d loops: %d", s, n, e.vals[0]);
   for (i=1; i<=n;i++)
     printf (" + %d*I%d", e.vals[i], i);
   printf ("\n");
}



static void yyExit () { Exit (1); }

void (* ExpNormal_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ExpNormal, routine %s failed\n", yyFunction);
 ExpNormal_Exit ();
}

void ExpNormal ARGS((tTree e, ptree loops, int n, bool * yyP2, ExpNormRecord * yyP1));
static bool IsLoopVar ARGS((tIdent name, tTree loop));
static void ForIdUpperBound ARGS((tTree slice, ptree loops, int m, bool * yyP4, ExpNormRecord * yyP3));
static void ForIdLowerBound ARGS((tTree slice, ptree loops, int m, bool * yyP6, ExpNormRecord * yyP5));
static void GetStrideValue ARGS((tTree stride, bool * yyP8, int * yyP7));
static void ExpUpperBound ARGS((ExpNormRecord e, ptree loops, int n, int ConstLoops, bool * yyP10, ExpNormRecord * yyP9));
static void ExpLowerBound ARGS((ExpNormRecord e, ptree loops, int n, int ConstLoops, bool * yyP12, ExpNormRecord * yyP11));
bool ExpDifferent ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int ConstLoops));
void DiffUppBound ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, bool * yyP14, int * yyP13));
void DiffLowBound ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, bool * yyP16, int * yyP15));
static int my_min ARGS((int n1, int n2));

void ExpNormal
# if defined __STDC__ | defined __cplusplus
(register tTree e, ptree loops, register int n, register bool * yyP2, ExpNormRecord * yyP1)
# else
(e, loops, n, yyP2, yyP1)
 register tTree e;
 ptree loops;
 register int n;
 register bool * yyP2;
 ExpNormRecord * yyP1;
# endif
{
# line 97 "ExpNormal.puma"

int i;

# line 107 "ExpNormal.puma"
 {
  int c;
  bool found;
  ExpNormRecord val;
  {
# line 108 "ExpNormal.puma"

# line 109 "ExpNormal.puma"

# line 110 "ExpNormal.puma"

# line 111 "ExpNormal.puma"
   GetIntConstValue (e, & found, & c);
# line 112 "ExpNormal.puma"
   if (! (found)) goto yyL1;
  {
# line 113 "ExpNormal.puma"
 for (i=1;i<=n;i++) val.vals[i] = 0;
     val.vals[0] = c;
   
  }
  }
   * yyP2 = found;
   * yyP1 = val;
   return;
 }
yyL1:;

  if (e->Kind == kOP_EXP) {
  if (e->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 124 "ExpNormal.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  {
# line 125 "ExpNormal.puma"
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV1, & yyV2);
# line 126 "ExpNormal.puma"
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV3, & yyV4);
# line 127 "ExpNormal.puma"
 if (yyV1 && yyV3)
       { for (i=0; i<=n; i++)
            yyV2.vals[i] += yyV4.vals[i];
       }
   
  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = yyV2;
   return;
 }

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 134 "ExpNormal.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  {
# line 135 "ExpNormal.puma"
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV1, & yyV2);
# line 136 "ExpNormal.puma"
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV3, & yyV4);
# line 137 "ExpNormal.puma"
 if (yyV1 && yyV3)
       { for (i=0; i<=n; i++)
            yyV2.vals[i] -= yyV4.vals[i];
       }
   
  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = yyV2;
   return;
 }

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 144 "ExpNormal.puma"
 {
  int c;
  bool found1;
  bool yyV1;
  ExpNormRecord yyV2;
  {
# line 145 "ExpNormal.puma"

# line 146 "ExpNormal.puma"

# line 147 "ExpNormal.puma"
   GetIntConstValue (e->OP_EXP.OPND1, & found1, & c);
# line 148 "ExpNormal.puma"
   if (! (found1)) goto yyL4;
  {
# line 149 "ExpNormal.puma"
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV1, & yyV2);
# line 152 "ExpNormal.puma"
 if (yyV1) { for (i=0;i<=n;i++) yyV2.vals[i] *= c; } 
  }
  }
   * yyP2 = found1 && yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL4:;

# line 155 "ExpNormal.puma"
 {
  int c;
  bool found2;
  bool yyV1;
  ExpNormRecord yyV2;
  {
# line 157 "ExpNormal.puma"

# line 158 "ExpNormal.puma"

# line 159 "ExpNormal.puma"
   GetIntConstValue (e->OP_EXP.OPND2, & found2, & c);
# line 161 "ExpNormal.puma"
   if (! (found2)) goto yyL5;
  {
# line 163 "ExpNormal.puma"
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV1, & yyV2);
# line 166 "ExpNormal.puma"
 if (yyV1) { for (i=0;i<=n;i++) yyV2.vals[i] *= c; } 
  }
  }
   * yyP2 = yyV1 && found2;
   * yyP1 = yyV2;
   return;
 }
yyL5:;

  }
  }
  if (e->Kind == kOP1_EXP) {
  if (e->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 169 "ExpNormal.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  {
# line 170 "ExpNormal.puma"
   ExpNormal (e->OP1_EXP.OPND, loops, n, & yyV1, & yyV2);
# line 171 "ExpNormal.puma"
 if (yyV1)
       { for (i=0; i<=n; i++)
            yyV2.vals[i] = -yyV2.vals[i];
       }
   
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  }
  if (e->Kind == kVAR_EXP) {
  if (e->VAR_EXP.V->Kind == kLOOP_VAR) {
# line 178 "ExpNormal.puma"
 {
  bool found;
  ExpNormRecord val;
  {
# line 179 "ExpNormal.puma"

# line 180 "ExpNormal.puma"

# line 181 "ExpNormal.puma"
 found = false;
     val.vals[0] = 0;
     for (i=1; i<= n; i++)
       { if (IsLoopVar (e->VAR_EXP.V->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, loops[i-1]))
            { val.vals[i] = 1;
              found  = true;
            }
           else
            val.vals[i] = 0;
       }
   
  }
   * yyP2 = found;
   * yyP1 = val;
   return;
 }

  }
  if (e->VAR_EXP.V->Kind == kUSED_VAR) {
# line 194 "ExpNormal.puma"
 {
  bool found;
  ExpNormRecord val;
  {
# line 195 "ExpNormal.puma"

# line 196 "ExpNormal.puma"

# line 197 "ExpNormal.puma"
 found = false;
     val.vals[0] = 0;
     for (i=1; i<= n; i++)
       { if (IsLoopVar (e->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, loops[i-1]))
            { val.vals[i] = 1;
              found  = true;
            }
           else
            val.vals[i] = 0;
       }
   
  }
   * yyP2 = found;
   * yyP1 = val;
   return;
 }

  }
  }
  if (e->Kind == kSLICE_EXP) {
# line 218 "ExpNormal.puma"
 {
  ExpNormRecord val;
  {
# line 219 "ExpNormal.puma"

  }
   * yyP2 = false;
   * yyP1 = val;
   return;
 }

  }
# line 222 "ExpNormal.puma"
 {
  ExpNormRecord val;
  {
# line 224 "ExpNormal.puma"

  }
   * yyP2 = false;
   * yyP1 = val;
   return;
 }

;
}

static bool IsLoopVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree loop)
# else
(name, loop)
 register tIdent name;
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
# line 230 "ExpNormal.puma"
  {
# line 231 "ExpNormal.puma"
   if (! ((IsLoopVar (name, loop->ACF_DO.DO_ID)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (loop->Kind == kACF_FORALL) {
# line 234 "ExpNormal.puma"
  {
# line 235 "ExpNormal.puma"
   if (! ((IsLoopVar (name, loop->ACF_FORALL.FORALL_ID)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (loop->Kind == kUSED_VAR) {
# line 238 "ExpNormal.puma"
  {
# line 239 "ExpNormal.puma"
   if (! ((name == loop->USED_VAR.VARNAME->VAR_OBJ.Ident))) goto yyL3;
  }
   return true;
yyL3:;

  }
  if (loop->Kind == kLOOP_VAR) {
# line 242 "ExpNormal.puma"
  {
# line 243 "ExpNormal.puma"
   if (! ((name == loop->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

static void ForIdUpperBound
# if defined __STDC__ | defined __cplusplus
(register tTree slice, ptree loops, register int m, register bool * yyP4, ExpNormRecord * yyP3)
# else
(slice, loops, m, yyP4, yyP3)
 register tTree slice;
 ptree loops;
 register int m;
 register bool * yyP4;
 ExpNormRecord * yyP3;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
# line 264 "ExpNormal.puma"
 {
  ExpNormRecord r;
  bool yyV1;
  int yyV2;
  {
# line 266 "ExpNormal.puma"

# line 270 "ExpNormal.puma"
   GetStrideValue (slice->SLICE_EXP.INC, & yyV1, & yyV2);
# line 271 "ExpNormal.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 275 "ExpNormal.puma"
 
     if (yyV2 > 0)
       { 
         ExpNormal (slice->SLICE_EXP.STOP, loops, m-1, &yyV1, &r);
       }
     else 
       { 
         ExpNormal (slice->SLICE_EXP.START, loops, m-1, &yyV1, &r);
       }

# ifdef DEBUG
     printf ("Lower bound for loop variable %d found\n", m);
     PrintNormRecord ("low", r, loops, m-1);
# endif 

   
  }
  }
   * yyP4 = yyV1;
   * yyP3 = r;
   return;
 }
yyL1:;

  }
# line 293 "ExpNormal.puma"
 {
  ExpNormRecord r;
  {
# line 295 "ExpNormal.puma"

# line 297 "ExpNormal.puma"

# ifdef DEBUG
     printf ("Upper bound for loop variable %d not found\n", m);
# endif 
   
  }
   * yyP4 = false;
   * yyP3 = r;
   return;
 }

;
}

static void ForIdLowerBound
# if defined __STDC__ | defined __cplusplus
(register tTree slice, ptree loops, register int m, register bool * yyP6, ExpNormRecord * yyP5)
# else
(slice, loops, m, yyP6, yyP5)
 register tTree slice;
 ptree loops;
 register int m;
 register bool * yyP6;
 ExpNormRecord * yyP5;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
# line 307 "ExpNormal.puma"
 {
  ExpNormRecord r;
  bool yyV1;
  int yyV2;
  {
# line 309 "ExpNormal.puma"

# line 313 "ExpNormal.puma"
   GetStrideValue (slice->SLICE_EXP.INC, & yyV1, & yyV2);
# line 314 "ExpNormal.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 318 "ExpNormal.puma"
 
     if (yyV2 < 0)
       { 
         ExpNormal (slice->SLICE_EXP.STOP, loops, m-1, &yyV1, &r);
       }
     else 
       { 
         ExpNormal (slice->SLICE_EXP.START, loops, m-1, &yyV1, &r);
       }

# ifdef DEBUG
     printf ("Lower bound for loop variable %d found\n", m);
     PrintNormRecord ("low", r, loops, m-1);
# endif 

   
  }
  }
   * yyP6 = yyV1;
   * yyP5 = r;
   return;
 }
yyL1:;

  }
# line 336 "ExpNormal.puma"
 {
  ExpNormRecord r;
  {
# line 338 "ExpNormal.puma"

# line 340 "ExpNormal.puma"

# ifdef DEBUG
     printf ("Lower bound for loop variable %d not found\n", m);
# endif 
   
  }
   * yyP6 = false;
   * yyP5 = r;
   return;
 }

;
}

static void GetStrideValue
# if defined __STDC__ | defined __cplusplus
(register tTree stride, register bool * yyP8, register int * yyP7)
# else
(stride, yyP8, yyP7)
 register tTree stride;
 register bool * yyP8;
 register int * yyP7;
# endif
{
# line 355 "ExpNormal.puma"
  {
# line 356 "ExpNormal.puma"
   if (! ((IsStride1 (stride)))) goto yyL1;
  }
   * yyP8 = true;
   * yyP7 = 1;
   return;
yyL1:;

# line 359 "ExpNormal.puma"
 {
  bool found;
  int val;
  {
# line 361 "ExpNormal.puma"

# line 362 "ExpNormal.puma"

# line 364 "ExpNormal.puma"
   GetIntConstValue (stride, & found, & val);
  }
   * yyP8 = found;
   * yyP7 = val;
   return;
 }

;
}

static void ExpUpperBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, register int ConstLoops, register bool * yyP10, ExpNormRecord * yyP9)
# else
(e, loops, n, ConstLoops, yyP10, yyP9)
 ExpNormRecord e;
 ptree loops;
 register int n;
 register int ConstLoops;
 register bool * yyP10;
 ExpNormRecord * yyP9;
# endif
{
# line 389 "ExpNormal.puma"
 {
  bool found;
  ExpNormRecord bound;
  ExpNormRecord h;
  int k;
  int i;
  int a;
  {
# line 391 "ExpNormal.puma"

# line 392 "ExpNormal.puma"

# line 393 "ExpNormal.puma"

# line 394 "ExpNormal.puma"

# line 395 "ExpNormal.puma"

# line 396 "ExpNormal.puma"

# line 399 "ExpNormal.puma"
 found = true;
     bound = e;     

# ifdef DEBUG
     printf ("Call of ExpUpperBound, ConstLoops = %d\n", ConstLoops);
     PrintNormRecord ("e", e, loops, n);
# endif 

     k     = n;
     while (found && (k > ConstLoops))
      { 
        a = bound.vals[k];
        if (a > 0)
         { 
           ForIdUpperBound (GetLoopSlice(loops[k-1]),loops,k,&found,&h);
           if (found)
             { 
               for (i=0; i<=k-1; i++)
                  bound.vals[i] += a * h.vals[i];
             }
         } 
        else if (a < 0)
         { 
           ForIdLowerBound (GetLoopSlice(loops[k-1]),loops,k,&found,&h);
           if (found)
             { 
               for (i=0; i<=k-1; i++)
                  bound.vals[i] += a * h.vals[i];
             }
         } 
        k = k - 1;
      } 
   
# ifdef DEBUG
     if (found)
       { printf ("Upper Bound found\n");
         PrintNormRecord ("up", bound, loops, ConstLoops);
       }
      else
         printf ("Upper Bound not found\n");
# endif 

   
  }
   * yyP10 = found;
   * yyP9 = bound;
   return;
 }

;
}

static void ExpLowerBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, register int ConstLoops, register bool * yyP12, ExpNormRecord * yyP11)
# else
(e, loops, n, ConstLoops, yyP12, yyP11)
 ExpNormRecord e;
 ptree loops;
 register int n;
 register int ConstLoops;
 register bool * yyP12;
 ExpNormRecord * yyP11;
# endif
{
# line 450 "ExpNormal.puma"
 {
  bool found;
  ExpNormRecord bound;
  ExpNormRecord h;
  int k;
  int i;
  int a;
  {
# line 452 "ExpNormal.puma"

# line 453 "ExpNormal.puma"

# line 454 "ExpNormal.puma"

# line 455 "ExpNormal.puma"

# line 456 "ExpNormal.puma"

# line 457 "ExpNormal.puma"

# line 459 "ExpNormal.puma"
 found = true;
     bound = e;     

# ifdef DEBUG
     printf ("Call of ExpLowerBound, ConstLoops = %d\n", ConstLoops);
     PrintNormRecord ("e", e, loops, n);
# endif

     k     = n;
     while (found && (k > ConstLoops))
      { 
        a = bound.vals[k];
        if (a > 0)
         { 
           ForIdLowerBound (GetLoopSlice(loops[k-1]),loops,k,&found,&h);
           if (found)
             { 
               for (i=0; i<=k-1; i++)
                  bound.vals[i] += a * h.vals[i];
             }
         } 
        else if (a < 0)
         { 
           ForIdUpperBound (GetLoopSlice(loops[k-1]),loops,k,&found,&h);
           if (found)
             { 
               for (i=0; i<=k-1; i++)
                  bound.vals[i] += a * h.vals[i];
             }
         } 
        k = k - 1;
      } 

# ifdef DEBUG
     if (found)
       { printf ("Lower Bound found\n");
         PrintNormRecord ("low", bound, loops, ConstLoops);
       }
      else
         printf ("Lower Bound not found\n");
# endif 
   
  }
   * yyP12 = found;
   * yyP11 = bound;
   return;
 }

;
}

bool ExpDifferent
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int ConstLoops)
# else
(e1, loops1, n1, e2, loops2, n2, ConstLoops)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int ConstLoops;
# endif
{
# line 516 "ExpNormal.puma"

int i;

# line 520 "ExpNormal.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  bool yyV5;
  ExpNormRecord yyV6;
  {
# line 529 "ExpNormal.puma"
   ExpUpperBound (e1, loops1, n1, ConstLoops, & yyV1, & yyV2);
# line 530 "ExpNormal.puma"
   if (! (yyV1)) goto yyL1;
  {
# line 537 "ExpNormal.puma"
   ExpLowerBound (e2, loops2, n2, ConstLoops, & yyV3, & yyV4);
# line 538 "ExpNormal.puma"
   if (! (yyV3)) goto yyL1;
  {
# line 545 "ExpNormal.puma"
 for (i=0; i<=ConstLoops; i++)
        yyV4.vals[i] -= yyV2.vals[i];
     
   
# line 553 "ExpNormal.puma"
   ExpLowerBound (yyV4, loops1, ConstLoops, 0, & yyV5, & yyV6);
# line 554 "ExpNormal.puma"
   if (! (yyV5)) goto yyL1;
  {
# line 561 "ExpNormal.puma"
   if (! ( yyV6.vals[0]  > 0)) goto yyL1;
  }
  }
  }
  }
   return true;
 }
yyL1:;

# line 564 "ExpNormal.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  bool yyV5;
  ExpNormRecord yyV6;
  {
# line 573 "ExpNormal.puma"
   ExpLowerBound (e1, loops1, n1, ConstLoops, & yyV1, & yyV2);
# line 574 "ExpNormal.puma"
   if (! (yyV1)) goto yyL2;
  {
# line 581 "ExpNormal.puma"
   ExpUpperBound (e2, loops2, n2, ConstLoops, & yyV3, & yyV4);
# line 582 "ExpNormal.puma"
   if (! (yyV3)) goto yyL2;
  {
# line 589 "ExpNormal.puma"
 for (i=0; i<=ConstLoops; i++)
        yyV2.vals[i] -= yyV4.vals[i];
     
   
# line 597 "ExpNormal.puma"
   ExpLowerBound (yyV2, loops1, ConstLoops, 0, & yyV5, & yyV6);
# line 598 "ExpNormal.puma"
   if (! (yyV5)) goto yyL2;
  {
# line 605 "ExpNormal.puma"
   if (! ( yyV6.vals[0]  > 0)) goto yyL2;
  }
  }
  }
  }
   return true;
 }
yyL2:;

  return false;
}

void DiffUppBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, register bool * yyP14, register int * yyP13)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, yyP14, yyP13)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 register bool * yyP14;
 register int * yyP13;
# endif
{
# line 638 "ExpNormal.puma"

int i;

# line 642 "ExpNormal.puma"
 {
  bool found;
  int val;
  int m;
  ExpNormRecord H1;
  ExpNormRecord H2;
  {
# line 644 "ExpNormal.puma"

# line 645 "ExpNormal.puma"

# line 646 "ExpNormal.puma"

# line 648 "ExpNormal.puma"

# line 649 "ExpNormal.puma"

# line 652 "ExpNormal.puma"
 

#ifdef DEBUG
    printf ("Call of DiffUppBound, n1 = %d, n2 = %d, Common = %d, Const = %d\n",
             n1, n2, CommonLoops, ConstLoops);
#endif

    

    for (i=0; i<= n1; i++) H1.vals[i] = - e1.vals[i]; 

    H2 = e2;
   
    m = my_min (n1, n2);

    found = true;

    

    

    if (n1 > m)  
       ExpUpperBound (H1, loops1, n1, m, &found, &H1); 

    if (n2 > m) 
       ExpUpperBound (H2, loops2, n2, m, &found, &H2); 

    

    for (i=CommonLoops+1; i<=m; i++)
       found = (found && ( H1.vals[i] + H2.vals[i] == 0));
   
# line 685 "ExpNormal.puma"
   if (! ((found))) goto yyL1;
  {
# line 687 "ExpNormal.puma"
 
     for (i=0; i<=CommonLoops; i++)
        H1.vals[i] += H2.vals[i];
     ExpUpperBound (H1, loops1, CommonLoops, 0, &found, &H2);
     
     if (found)
        val = H2.vals[0];
   
  }
  }
   * yyP14 = found;
   * yyP13 = val;
   return;
 }
yyL1:;

# line 699 "ExpNormal.puma"
   * yyP14 = false;
   * yyP13 = 0;
   return;

;
}

void DiffLowBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, register bool * yyP16, register int * yyP15)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, yyP16, yyP15)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 register bool * yyP16;
 register int * yyP15;
# endif
{
# line 707 "ExpNormal.puma"

int i;

# line 711 "ExpNormal.puma"
 {
  bool found;
  int val;
  int m;
  ExpNormRecord H1;
  ExpNormRecord H2;
  {
# line 713 "ExpNormal.puma"

# line 714 "ExpNormal.puma"

# line 715 "ExpNormal.puma"

# line 717 "ExpNormal.puma"

# line 718 "ExpNormal.puma"

# line 726 "ExpNormal.puma"
 for (i=0; i<= n1; i++) H1.vals[i] = - e1.vals[i]; 
# line 727 "ExpNormal.puma"
   H2 = e2;
# line 729 "ExpNormal.puma"
   m = my_min (n1, n2);
# line 731 "ExpNormal.puma"
   found = true;
# line 733 "ExpNormal.puma"
 

     

     if (n1 > m)  
       ExpLowerBound (H1, loops1, n1, m, &found, &H1); 
     if (n2 > m) 
       ExpLowerBound (H2, loops2, n2, m, &found, &H2); 

     

     for (i=CommonLoops+1; i<=m; i++)
       found = (found && ( H1.vals[i] + H2.vals[i] == 0));
   
# line 748 "ExpNormal.puma"
   if (! ((found))) goto yyL1;
  {
# line 750 "ExpNormal.puma"
 
     for (i=0; i<=CommonLoops; i++)
        H1.vals[i] += H2.vals[i];
     ExpLowerBound (H1, loops1, CommonLoops, 0, &found, &H2);
     
     if (found)
        val = H2.vals[0];
   
  }
  }
   * yyP16 = found;
   * yyP15 = val;
   return;
 }
yyL1:;

# line 760 "ExpNormal.puma"
   * yyP16 = false;
   * yyP15 = 0;
   return;

;
}

static int my_min
# if defined __STDC__ | defined __cplusplus
(register int n1, register int n2)
# else
(n1, n2)
 register int n1;
 register int n2;
# endif
{
# line 771 "ExpNormal.puma"
  {
# line 772 "ExpNormal.puma"
   if (! ((n1 > n2))) goto yyL1;
  }
   return n2;
yyL1:;

# line 776 "ExpNormal.puma"
   return n1;

}

void BeginExpNormal ()
{
}

void CloseExpNormal ()
{
}
