# include "ExpDescriptor.h"
# include "yyExpDescriptor.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 39 "ExpDescriptor.puma"


# undef DEBUG

# include <stdio.h>
# include "protocol.h"
# include "Idents.h"
# include "StringMem.h"

# include "TreeOps.h"           /* TreeListGet, ... */
# include "Objects.h"           /* GetFuncVarObj    */
# include "Accepted.h"

# include "Distributions.h"     /* DimListLength, ... */
# include "Types.h"             /* GetExpType, ... */
# include "Expressions.h"       /* GetExpType, ... */
# include "Rank.h"
# include "Intrinsics.h"
# include "Reductions.h"

# include "UserFunctions.h"     /* ActualizeExpression */

# include "Nesting.h"           /* GetLoopId, ...      */
# include "Descriptor.h"        /* advanced operations for descriptors */
# include "HomeDescriptor.h"

# define MODULE "ExpDescriptor"



static void yyExit () { Exit (1); }

void (* ExpDescriptor_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ExpDescriptor, routine %s failed\n", yyFunction);
 ExpDescriptor_Exit ();
}

void GetVarDescriptor ARGS((tTree var, bool * yyP2, var_descriptor * yyP1));
static void IndexDescriptor ARGS((tTree indexes, bool * yyP4, var_descriptor * yyP3));
void SetExpType ARGS((tTree exp, pvar vard));
void GetExpDescriptor ARGS((tTree exp, bool * yyP6, var_descriptor * yyP5));
static void GetIntrFuncDescriptor ARGS((tTree f, tTree params, bool * yyP8, var_descriptor * yyP7));
void GetParamDescriptor ARGS((tTree param, bool * yyP10, var_descriptor * yyP9));
static void GetParamListDescriptor ARGS((tTree paramlist, bool * yyP12, var_descriptor * yyP11));
static void GetMatMulDescriptor ARGS((tTree array_a, tTree array_b, bool * yyP14, var_descriptor * yyP13));
static void GetDimValue ARGS((tTree params, int * yyP15));
static void SetAssumedShape ARGS((pvar vard, tTree actual, bool * yyP16));
void GetDummyVarDescriptor ARGS((tTree actual, tDefinitions dummy, tTree call, bool * yyP18, var_descriptor * yyP17));
static void GetUserFuncDescriptor ARGS((tTree f, bool * yyP20, var_descriptor * yyP19));
static void GetStmtFuncDescriptor ARGS((tTree p, bool * yyP22, var_descriptor * yyP21));
static bool IsEnumExp ARGS((tTree exp));
static void GetReshapeDescriptor ARGS((tTree shape, tTree order, bool * yyP24, var_descriptor * yyP23));

void GetVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register bool * yyP2, var_descriptor * yyP1)
# else
(var, yyP2, yyP1)
 register tTree var;
 register bool * yyP2;
 var_descriptor * yyP1;
# endif
{
# line 82 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 84 "ExpDescriptor.puma"

# line 86 "ExpDescriptor.puma"
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  {
# line 87 "ExpDescriptor.puma"
   SetVarDescriptor (var, & vard);
  }
  }
   * yyP2 = true;
   * yyP1 = vard;
   return;
 }
yyL1:;

  if (var->Kind == kINDEXED_VAR) {
# line 90 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 92 "ExpDescriptor.puma"
   IndexDescriptor (var->INDEXED_VAR.IND_EXPS, & yyV1, & yyV2);
# line 93 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 94 "ExpDescriptor.puma"
   SetExpType (var, & yyV2);
# line 96 "ExpDescriptor.puma"

#ifdef DEBUG
   printf ("got var descriptor via the indexes for ");
   FileUnparse (stdout, var); printf ("\n");
   PrintVarDescriptor (&yyV2);
#endif 
   
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL2:;

  }
# line 105 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 107 "ExpDescriptor.puma"

  }
   * yyP2 = false;
   * yyP1 = vard;
   return;
 }

;
}

static void IndexDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register bool * yyP4, var_descriptor * yyP3)
# else
(indexes, yyP4, yyP3)
 register tTree indexes;
 register bool * yyP4;
 var_descriptor * yyP3;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 120 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 122 "ExpDescriptor.puma"
   GetExpDescriptor (indexes->BTE_LIST.Elem, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  }
# line 125 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  bool yyV3;
  var_descriptor yyV4;
  {
# line 127 "ExpDescriptor.puma"
   GetExpDescriptor (indexes->BTE_LIST.Elem, & yyV1, & yyV2);
# line 128 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 130 "ExpDescriptor.puma"
   IndexDescriptor (indexes->BTE_LIST.Next, & yyV3, & yyV4);
# line 131 "ExpDescriptor.puma"
   if (! ((yyV3))) goto yyL2;
  {
# line 133 "ExpDescriptor.puma"
   ProductDescriptors (& yyV2, & yyV4);
  }
  }
  }
   * yyP4 = true;
   * yyP3 = yyV2;
   return;
 }
yyL2:;

  }
# line 136 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 138 "ExpDescriptor.puma"

  }
   * yyP4 = false;
   * yyP3 = vard;
   return;
 }

;
}

void SetExpType
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard)
# else
(exp, vard)
 register tTree exp;
 pvar vard;
# endif
{
# line 152 "ExpDescriptor.puma"
 {
  type_rec t;
  {
# line 154 "ExpDescriptor.puma"

# line 156 "ExpDescriptor.puma"
 GetExpType (exp, &t);
    vard->type_kind = t.type_kind;
    vard->type_size = t.type_size;
  
  }
   return;
 }

;
}

void GetExpDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register bool * yyP6, var_descriptor * yyP5)
# else
(exp, yyP6, yyP5)
 register tTree exp;
 register bool * yyP6;
 var_descriptor * yyP5;
# endif
{
  if (exp->Kind == kVAR_EXP) {
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
# line 177 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 179 "ExpDescriptor.puma"

# line 181 "ExpDescriptor.puma"
   MakeLoopVarDescriptor (exp, & vard);
  }
   * yyP6 = true;
   * yyP5 = vard;
   return;
 }

  }
# line 184 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 186 "ExpDescriptor.puma"
   GetVarDescriptor (exp->VAR_EXP.V, & yyV1, & yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  if (exp->Kind == kSLICE_EXP) {
# line 189 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 191 "ExpDescriptor.puma"

# line 193 "ExpDescriptor.puma"
   MakeSliceDescriptor (exp, & vard);
  }
   * yyP6 = true;
   * yyP5 = vard;
   return;
 }

  }
  if (exp->Kind == kOP1_EXP) {
# line 196 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 198 "ExpDescriptor.puma"
   GetExpDescriptor (exp->OP1_EXP.OPND, & yyV1, & yyV2);
# line 199 "ExpDescriptor.puma"
   SetExpType (exp, & yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  if (exp->Kind == kOP_EXP) {
# line 202 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  bool yyV3;
  var_descriptor yyV4;
  {
# line 204 "ExpDescriptor.puma"
   GetExpDescriptor (exp->OP_EXP.OPND1, & yyV1, & yyV2);
# line 205 "ExpDescriptor.puma"
   GetExpDescriptor (exp->OP_EXP.OPND2, & yyV3, & yyV4);
# line 207 "ExpDescriptor.puma"
 if (yyV1 && yyV3)
       CombineDescriptors (&yyV2, &yyV4);
   
# line 211 "ExpDescriptor.puma"
   SetExpType (exp, & yyV2);
  }
   * yyP6 = (yyV1 && yyV3);
   * yyP5 = yyV2;
   return;
 }

  }
# line 214 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 216 "ExpDescriptor.puma"
   if (! ((TreeRank (exp) == 0))) goto yyL6;
  {
# line 218 "ExpDescriptor.puma"

# line 222 "ExpDescriptor.puma"
   MakeReplicatedDescriptor (& vard);
# line 224 "ExpDescriptor.puma"
   SetExpType (exp, & vard);
  }
  }
   * yyP6 = true;
   * yyP5 = vard;
   return;
 }
yyL6:;

  if (exp->Kind == kFUNC_CALL_EXP) {
# line 227 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 229 "ExpDescriptor.puma"
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL7;
  {
# line 231 "ExpDescriptor.puma"
   GetIntrFuncDescriptor (exp->FUNC_CALL_EXP.FUNC_ID, exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
# line 235 "ExpDescriptor.puma"
   SetExpType (exp, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL7:;

# line 238 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 242 "ExpDescriptor.puma"

# line 244 "ExpDescriptor.puma"
   if (! ((IsPureCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL8;
  }
   * yyP6 = false;
   * yyP5 = vard;
   return;
 }
yyL8:;

# line 247 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 249 "ExpDescriptor.puma"
   if (! ((IsUserCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL9;
  {
# line 251 "ExpDescriptor.puma"
   GetUserFuncDescriptor (exp, & yyV1, & yyV2);
# line 253 "ExpDescriptor.puma"
 if (IsSerialCall (exp->FUNC_CALL_EXP.FUNC_ID))
        yyV2.topology_rank = -1;
   
# line 257 "ExpDescriptor.puma"
   SetExpType (exp, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL9:;

# line 260 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 262 "ExpDescriptor.puma"
   if (! ((IsStmtCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL10;
  {
# line 264 "ExpDescriptor.puma"
   GetStmtFuncDescriptor (exp->FUNC_CALL_EXP.FUNC_ID, & yyV1, & yyV2);
# line 266 "ExpDescriptor.puma"
   SetExpType (exp, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL10:;

  }
  if (exp->Kind == kARRAY_EXP) {
# line 269 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 271 "ExpDescriptor.puma"
   if (! ((IsEnumExp (exp->ARRAY_EXP.ELEMENTS)))) goto yyL11;
  {
# line 273 "ExpDescriptor.puma"
   GetExpDescriptor (mSLICE_EXP (MakeConstant (1), MakeConstant (TreeListLength (exp->ARRAY_EXP.ELEMENTS)), mDUMMY_EXP ()), & yyV1, & yyV2);
# line 278 "ExpDescriptor.puma"
   SetExpType (exp, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL11:;

  if (exp->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (exp->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 281 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 283 "ExpDescriptor.puma"
   GetExpDescriptor (exp->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem, & yyV1, & yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  }
  }
  if (exp->Kind == kDO_EXP) {
  if (exp->DO_EXP.BODY->Kind == kBTE_LIST) {
  if (exp->DO_EXP.BODY->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 286 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 288 "ExpDescriptor.puma"
   if (! ((TreeRank (exp->DO_EXP.BODY->BTE_LIST.Elem) == 0))) goto yyL13;
  {
# line 289 "ExpDescriptor.puma"
   GetExpDescriptor (exp->DO_EXP.RANGE, & yyV1, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL13:;

# line 292 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 294 "ExpDescriptor.puma"

  }
   * yyP6 = false;
   * yyP5 = vard;
   return;
 }

  }
  }
  }
# line 297 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 299 "ExpDescriptor.puma"

  }
   * yyP6 = false;
   * yyP5 = vard;
   return;
 }

;
}

static void GetIntrFuncDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree f, register tTree params, register bool * yyP8, var_descriptor * yyP7)
# else
(f, params, yyP8, yyP7)
 register tTree f;
 register tTree params;
 register bool * yyP8;
 var_descriptor * yyP7;
# endif
{
  if (f->Kind == kPROC_OBJ) {
# line 317 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 319 "ExpDescriptor.puma"
   if (! ((IntrFuncElemental (f->PROC_OBJ.Ident)))) goto yyL1;
  {
# line 320 "ExpDescriptor.puma"
   GetParamListDescriptor (params, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL1:;

  if (params->Kind == kBTP_LIST) {
# line 323 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 325 "ExpDescriptor.puma"

# line 327 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("SHAPE")))) goto yyL2;
  {
# line 329 "ExpDescriptor.puma"
   MakeShapeDescriptor (MakeConstant (TreeRank (params->BTP_LIST.Elem)), & vard);
  }
  }
   * yyP8 = true;
   * yyP7 = vard;
   return;
 }
yyL2:;

  }
# line 332 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 334 "ExpDescriptor.puma"

# line 336 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("PROCESSORS_SHAPE")))) goto yyL3;
  {
# line 338 "ExpDescriptor.puma"
   MakeShapeDescriptor (mRANK_EXP (0), & vard);
  }
  }
   * yyP8 = true;
   * yyP7 = vard;
   return;
 }
yyL3:;

# line 341 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 343 "ExpDescriptor.puma"

# line 345 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("ACTIVE_PROCS_SHAPE")))) goto yyL4;
  {
# line 347 "ExpDescriptor.puma"
   MakeShapeDescriptor (mRANK_EXP (1), & vard);
  }
  }
   * yyP8 = true;
   * yyP7 = vard;
   return;
 }
yyL4:;

  if (params->Kind == kBTP_LIST) {
# line 350 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 352 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("CSHIFT")))) goto yyL5;
  {
# line 354 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL5:;

# line 357 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 359 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("TRANSPOSE")))) goto yyL6;
  {
# line 361 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
# line 363 "ExpDescriptor.puma"
 if (yyV1) TransposeDescriptor (&yyV2); 
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL6:;

# line 366 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 368 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("EOSHIFT")))) goto yyL7;
  {
# line 370 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL7:;

  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 373 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 376 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("MATMUL")))) goto yyL8;
  {
# line 378 "ExpDescriptor.puma"
   GetMatMulDescriptor (params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL8:;

  }
# line 381 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 383 "ExpDescriptor.puma"
   if (! (((f->PROC_OBJ.Ident == IsIdent ("MINLOC", 6)) || (f->PROC_OBJ.Ident == IsIdent ("MAXLOC", 6))))) goto yyL9;
  {
# line 386 "ExpDescriptor.puma"

# line 388 "ExpDescriptor.puma"
   MakeRepArray1Descriptor (& vard, TreeRank (params->BTP_LIST.Elem));
  }
  }
   * yyP8 = true;
   * yyP7 = vard;
   return;
 }
yyL9:;

# line 391 "ExpDescriptor.puma"
 {
  int dimval;
  bool yyV1;
  var_descriptor yyV2;
  {
# line 393 "ExpDescriptor.puma"
   if (! ((IntrFuncRed (f->PROC_OBJ.Ident)))) goto yyL10;
  {
# line 395 "ExpDescriptor.puma"

# line 397 "ExpDescriptor.puma"
   dimval = GetReductionDim (params);
# line 398 "ExpDescriptor.puma"
   if (! ((dimval > 0))) goto yyL10;
  {
# line 400 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
# line 401 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL10;
  {
# line 403 "ExpDescriptor.puma"
   RedVarDescriptor (& yyV2, dimval);
  }
  }
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL10:;

  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 406 "ExpDescriptor.puma"
 {
  int dimval;
  bool yyV1;
  var_descriptor yyV2;
  {
# line 409 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("SPREAD")))) goto yyL11;
  {
# line 411 "ExpDescriptor.puma"

# line 413 "ExpDescriptor.puma"
   dimval = GetReductionDim (params);
# line 414 "ExpDescriptor.puma"
   if (! ((dimval > 0))) goto yyL11;
  {
# line 416 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
# line 417 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL11;
  {
# line 419 "ExpDescriptor.puma"
   SpreadVarDescriptor (& yyV2, dimval, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
  }
  }
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL11:;

  }
  }
# line 422 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 424 "ExpDescriptor.puma"
   if (! (((f->PROC_OBJ.Ident == IsIdent ("GRADE_UP")) || (f->PROC_OBJ.Ident == IsIdent ("GRADE_DOWN"))))) goto yyL12;
  {
# line 427 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL12:;

# line 430 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 432 "ExpDescriptor.puma"
   if (! (((f->PROC_OBJ.Ident == IsIdent ("SORT_UP")) || (f->PROC_OBJ.Ident == IsIdent ("SORT_DOWN"))))) goto yyL13;
  {
# line 435 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL13:;

  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 438 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 441 "ExpDescriptor.puma"
   if (! ((f->PROC_OBJ.Ident == IsIdent ("RESHAPE")))) goto yyL14;
  {
# line 443 "ExpDescriptor.puma"
   GetReshapeDescriptor (params->BTP_LIST.Next->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL14:;

  }
  }
# line 446 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 448 "ExpDescriptor.puma"
   if (! ((IntrFuncScatter (f->PROC_OBJ.Ident)))) goto yyL15;
  {
# line 452 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL15:;

  }
# line 455 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 457 "ExpDescriptor.puma"
   if (! ((IntrFuncScan (f->PROC_OBJ.Ident)))) goto yyL16;
  {
# line 461 "ExpDescriptor.puma"
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
# line 463 "ExpDescriptor.puma"
 if (   (f->PROC_OBJ.Ident == IsIdent ("COUNT_PREFIX")) 
         || (f->PROC_OBJ.Ident == IsIdent ("COUNT_SUFFIX"))  )

      { yyV2.type_kind = kINTEGER_TYPE;
        yyV2.type_size = default_int_size; 
      }

   
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL16:;

  }
  }
# line 473 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 475 "ExpDescriptor.puma"

# line 476 "ExpDescriptor.puma"
   tree_warning_protocol ("no descriptor for intrinsic call of ", f);
  }
   * yyP8 = false;
   * yyP7 = vard;
   return;
 }

;
}

void GetParamDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree param, register bool * yyP10, var_descriptor * yyP9)
# else
(param, yyP10, yyP9)
 register tTree param;
 register bool * yyP10;
 var_descriptor * yyP9;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
# line 487 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 489 "ExpDescriptor.puma"
   GetExpDescriptor (param->VAR_PARAM.V->ADDR.E, & yyV1, & yyV2);
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   return;
 }

  }
# line 492 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 494 "ExpDescriptor.puma"
   GetVarDescriptor (param->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   return;
 }

  }
  if (param->Kind == kNO_PARAM) {
# line 497 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 499 "ExpDescriptor.puma"

# line 501 "ExpDescriptor.puma"
   MakeNoDescriptor (& vard);
  }
   * yyP10 = true;
   * yyP9 = vard;
   return;
 }

  }
# line 504 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 506 "ExpDescriptor.puma"

  }
   * yyP10 = false;
   * yyP9 = vard;
   return;
 }

;
}

static void GetParamListDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree paramlist, register bool * yyP12, var_descriptor * yyP11)
# else
(paramlist, yyP12, yyP11)
 register tTree paramlist;
 register bool * yyP12;
 var_descriptor * yyP11;
# endif
{
  if (paramlist->Kind == kBTP_LIST) {
# line 517 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  bool yyV3;
  var_descriptor yyV4;
  {
# line 519 "ExpDescriptor.puma"
   GetParamDescriptor (paramlist->BTP_LIST.Elem, & yyV1, & yyV2);
# line 520 "ExpDescriptor.puma"
   GetParamListDescriptor (paramlist->BTP_LIST.Next, & yyV3, & yyV4);
# line 522 "ExpDescriptor.puma"
 if (yyV1 && yyV3)
       CombineDescriptors (&yyV2, &yyV4);
   
  }
   * yyP12 = (yyV1 && yyV3);
   * yyP11 = yyV2;
   return;
 }

  }
  if (paramlist->Kind == kBTP_EMPTY) {
# line 527 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 529 "ExpDescriptor.puma"

# line 531 "ExpDescriptor.puma"
   MakeNoDescriptor (& vard);
  }
   * yyP12 = true;
   * yyP11 = vard;
   return;
 }

  }
# line 534 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 536 "ExpDescriptor.puma"

  }
   * yyP12 = false;
   * yyP11 = vard;
   return;
 }

;
}

static void GetMatMulDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree array_a, register tTree array_b, register bool * yyP14, var_descriptor * yyP13)
# else
(array_a, array_b, yyP14, yyP13)
 register tTree array_a;
 register tTree array_b;
 register bool * yyP14;
 var_descriptor * yyP13;
# endif
{
# line 542 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 544 "ExpDescriptor.puma"
   if (! ((TreeRank (array_b) == 1))) goto yyL1;
  {
# line 548 "ExpDescriptor.puma"
   GetParamDescriptor (array_a, & yyV1, & yyV2);
# line 549 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 551 "ExpDescriptor.puma"
   RedVarDescriptor (& yyV2, 2);
  }
  }
  }
   * yyP14 = true;
   * yyP13 = yyV2;
   return;
 }
yyL1:;

# line 554 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 556 "ExpDescriptor.puma"
   if (! ((TreeRank (array_a) == 1))) goto yyL2;
  {
# line 560 "ExpDescriptor.puma"
   GetParamDescriptor (array_b, & yyV1, & yyV2);
# line 561 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 563 "ExpDescriptor.puma"
   RedVarDescriptor (& yyV2, 1);
  }
  }
  }
   * yyP14 = true;
   * yyP13 = yyV2;
   return;
 }
yyL2:;

# line 566 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  bool yyV3;
  var_descriptor yyV4;
  {
# line 568 "ExpDescriptor.puma"
   if (! ((TreeRank (array_a) == 2))) goto yyL3;
  {
# line 569 "ExpDescriptor.puma"
   if (! ((TreeRank (array_b) == 2))) goto yyL3;
  {
# line 570 "ExpDescriptor.puma"
   GetParamDescriptor (array_a, & yyV1, & yyV2);
# line 571 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 572 "ExpDescriptor.puma"
   GetParamDescriptor (array_b, & yyV3, & yyV4);
# line 573 "ExpDescriptor.puma"
   if (! ((yyV3))) goto yyL3;
  {
# line 575 "ExpDescriptor.puma"

#ifdef DEBUG
   printf ("MatMul descriptor\n");
   printf ("array 1 : \n"); PrintVarDescriptor (&yyV2);
#endif
   RedVarDescriptor (&yyV2, 2);
#ifdef DEBUG
   printf ("array 1 reduced : \n"); PrintVarDescriptor (&yyV2);
   printf ("array 2 : \n"); PrintVarDescriptor (&yyV4);
#endif
   RedVarDescriptor (&yyV4, 1);
#ifdef DEBUG
   printf ("array 2 reduced  \n"); PrintVarDescriptor (&yyV4);
#endif
   ProductDescriptors (&yyV2, &yyV4);
#ifdef DEBUG
   printf ("d1 x d2 :  \n"); PrintVarDescriptor (&yyV2);
#endif
   
  }
  }
  }
  }
  }
   * yyP14 = true;
   * yyP13 = yyV2;
   return;
 }
yyL3:;

# line 596 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 598 "ExpDescriptor.puma"

  }
   * yyP14 = false;
   * yyP13 = vard;
   return;
 }

;
}

static void GetDimValue
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * yyP15)
# else
(params, yyP15)
 register tTree params;
 register int * yyP15;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 611 "ExpDescriptor.puma"
 {
  bool found;
  int val;
  {
# line 613 "ExpDescriptor.puma"

# line 614 "ExpDescriptor.puma"

# line 616 "ExpDescriptor.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, & found, & val);
# line 617 "ExpDescriptor.puma"
   if (! ((found))) goto yyL1;
  }
   * yyP15 = val;
   return;
 }
yyL1:;

  }
  }
  }
# line 620 "ExpDescriptor.puma"
   * yyP15 = - 1;
   return;

;
}

static void SetAssumedShape
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tTree actual, register bool * yyP16)
# else
(vard, actual, yyP16)
 pvar vard;
 register tTree actual;
 register bool * yyP16;
# endif
{
# line 632 "ExpDescriptor.puma"
 {
  int i;
  int rank;
  bool yyV1;
  var_descriptor yyV2;
  {
# line 634 "ExpDescriptor.puma"

# line 635 "ExpDescriptor.puma"

# line 637 "ExpDescriptor.puma"
   GetParamDescriptor (actual, & yyV1, & yyV2);
# line 639 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 651 "ExpDescriptor.puma"
   if (! ((yyV2 . actual_rank == vard -> formal_rank))) goto yyL1;
  {
# line 653 "ExpDescriptor.puma"
 rank= vard->formal_rank;

     for (i=0; i<rank; i++)

      { int act_pos;

        act_pos = GetFormalDim (&yyV2, i+1) - 1;

        

        if (!IsStride1 (yyV2.actual_shape[act_pos][2]))
           yyV1 = false;

        if (vard->formal_shape [i][0] == NoTree)
           vard->formal_shape [i][0] = yyV2.actual_shape[act_pos][0];
        if (vard->formal_shape [i][1] == NoTree)
           vard->formal_shape [i][1] = yyV2.actual_shape[act_pos][1];
      }
   
# line 673 "ExpDescriptor.puma"
   if (! ((yyV1))) goto yyL1;
  }
  }
  }
   * yyP16 = true;
   return;
 }
yyL1:;

# line 676 "ExpDescriptor.puma"
   * yyP16 = false;
   return;

;
}

void GetDummyVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tDefinitions dummy, register tTree call, register bool * yyP18, var_descriptor * yyP17)
# else
(actual, dummy, call, yyP18, yyP17)
 register tTree actual;
 register tDefinitions dummy;
 register tTree call;
 register bool * yyP18;
 var_descriptor * yyP17;
# endif
{
# line 694 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 696 "ExpDescriptor.puma"

# line 698 "ExpDescriptor.puma"
   if (! ((dummy == NoObject))) goto yyL1;
  {
# line 700 "ExpDescriptor.puma"
   error_protocol ("no dummy for actual argument");
# line 701 "ExpDescriptor.puma"
   tree_protocol ("actual argument : ", actual);
  }
  }
   * yyP18 = false;
   * yyP17 = vard;
   return;
 }
yyL1:;

# line 704 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  bool found;
  {
# line 706 "ExpDescriptor.puma"

# line 707 "ExpDescriptor.puma"

# line 711 "ExpDescriptor.puma"
 int i;
    bool done;
    tTree new;
 
    SetVarObjDescriptor (&vard, dummy, NoTree);  
 
    SetAssumedShape (&vard, actual, &done);

    found = done;

    if (!found)

       tree_protocol ("could not inherit shape: ", actual);

    
 
    for (i=0; i<vard.actual_rank; i++)
 
      { ActualizeExpression (vard.formal_shape[i][0], call, &done, &new);
        if (done) vard.formal_shape[i][0] = new;
        if (!done) 
          { found = false;
            tree_protocol ("could not actualize : ", vard.formal_shape[i][0]);
          }
        ActualizeExpression (vard.formal_shape[i][1], call, &done, &new);
        if (done) vard.formal_shape[i][1] = new;
        if (!done) 
          { found = false;
            tree_protocol ("could not actualize : ", vard.formal_shape[i][1]);
          }
        vard.actual_shape[i][0] = vard.formal_shape[i][0];
        vard.actual_shape[i][1] = vard.formal_shape[i][1];
        vard.actual_shape[i][2] = NoTree;
      };
 
    
 
    vard.template_obj = NoObject;
 
#ifdef DEBUG
    FileUnparse (stdout, actual);
    printf (" actual param gets the following descriptor\n");
    PrintVarDescriptor (&vard);
#endif
 
  
  }
   * yyP18 = found;
   * yyP17 = vard;
   return;
 }

;
}

static void GetUserFuncDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree f, register bool * yyP20, var_descriptor * yyP19)
# else
(f, yyP20, yyP19)
 register tTree f;
 register bool * yyP20;
 var_descriptor * yyP19;
# endif
{
  if (f->Kind == kFUNC_CALL_EXP) {
# line 772 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 776 "ExpDescriptor.puma"
   GetDummyVarDescriptor (NoTree, GetFuncVarObj (f->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object), f, & yyV1, & yyV2);
  }
   * yyP20 = yyV1;
   * yyP19 = yyV2;
   return;
 }

  }
# line 779 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 781 "ExpDescriptor.puma"

# line 783 "ExpDescriptor.puma"
   failure_protocol (MODULE, "GetUserFuncDescriptor", f);
  }
   * yyP20 = false;
   * yyP19 = vard;
   return;
 }

;
}

static void GetStmtFuncDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree p, register bool * yyP22, var_descriptor * yyP21)
# else
(p, yyP22, yyP21)
 register tTree p;
 register bool * yyP22;
 var_descriptor * yyP21;
# endif
{
  if (p->Kind == kPROC_OBJ) {
  if (p->PROC_OBJ.Object->Kind == kFuncObject) {
  if (p->PROC_OBJ.Object->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 796 "ExpDescriptor.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  {
# line 799 "ExpDescriptor.puma"
   GetExpDescriptor (p->PROC_OBJ.Object->FuncObject.decl->STMT_FUNC_DECL.FFUNC_BODY, & yyV1, & yyV2);
  }
   * yyP22 = yyV1;
   * yyP21 = yyV2;
   return;
 }

  }
  }
  }
;
}

static bool IsEnumExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kARRAY_EXP) {
# line 810 "ExpDescriptor.puma"
  {
# line 811 "ExpDescriptor.puma"
   if (! ((IsEnumExp (exp->ARRAY_EXP.ELEMENTS)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (exp->Kind == kBTE_LIST) {
# line 814 "ExpDescriptor.puma"
  {
# line 815 "ExpDescriptor.puma"
   if (! ((TreeRank (exp->BTE_LIST.Elem) == 0))) goto yyL2;
  {
# line 816 "ExpDescriptor.puma"
   if (! ((IsEnumExp (exp->BTE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (exp->Kind == kBTE_EMPTY) {
# line 819 "ExpDescriptor.puma"
   return true;

  }
  return false;
}

static void GetReshapeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree shape, register tTree order, register bool * yyP24, var_descriptor * yyP23)
# else
(shape, order, yyP24, yyP23)
 register tTree shape;
 register tTree order;
 register bool * yyP24;
 var_descriptor * yyP23;
# endif
{
  if (shape->Kind == kVAR_PARAM) {
  if (shape->VAR_PARAM.V->Kind == kADDR) {
  if (order->Kind == kNO_PARAM) {
# line 834 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 836 "ExpDescriptor.puma"
   if (! ((IsEnumExp (shape->VAR_PARAM.V->ADDR.E)))) goto yyL1;
  {
# line 838 "ExpDescriptor.puma"

# line 840 "ExpDescriptor.puma"
   MakeShapeDescriptor (shape->VAR_PARAM.V->ADDR.E, & vard);
  }
  }
   * yyP24 = true;
   * yyP23 = vard;
   return;
 }
yyL1:;

  }
  }
  }
# line 843 "ExpDescriptor.puma"
 {
  var_descriptor vard;
  {
# line 845 "ExpDescriptor.puma"

# line 847 "ExpDescriptor.puma"
   warning_protocol ("use RESHAPE (source, (/ n1, n2, .. /))");
  }
   * yyP24 = false;
   * yyP23 = vard;
   return;
 }

;
}

void BeginExpDescriptor ()
{
}

void CloseExpDescriptor ()
{
}
