# include "Distributions.h"
# include "yyDistributions.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 48 "Distributions.puma"


# include "Idents.h"

# include "Expressions.h"    /* ResolveExpression, IsVarInExp */

# include "Objects.h"        /* GetFuncVarObj                 */
# include "Types.h"          /* ArrayFormals                  */
# include "TreeOps.h"        /* TreeListGet                   */
# include "Nesting.h"
# include "Intrinsics.h"
# include "Rank.h"

# include "protocol.h"

# define MODULE "Distributions"



static void yyExit () { Exit (1); }

void (* Distributions_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Distributions, routine %s failed\n", yyFunction);
 Distributions_Exit ();
}

static int CodeDistribution ARGS((tDefinitions d));
int VarDistribution ARGS((tDefinitions v));
int TreeWriteDistribution ARGS((tTree var));
static int DistributionWriteIndexed ARGS((int write_dist, int read_dist));
static int DistributionWriteMerge ARGS((int write1, int write2));
int TreeReadDistribution ARGS((tTree exp));
static int DistributionReadMerge ARGS((int dist1, int dist2));
static int DistributionReadVar ARGS((int writedist));
tDefinitions GetTemplateObj ARGS((tDefinitions v));
tDefinitions GetTopologyObj ARGS((tDefinitions v));
tDefinitions DimListGet ARGS((tDefinitions list, int pos));
int DimListLength ARGS((tDefinitions d));
static int GetVarDim ARGS((tTree indexes, int var_dimension));
bool IsDistributedObj ARGS((tDefinitions obj));
bool IsAlignedObj ARGS((tDefinitions obj));
bool IsTranscriptiveObj ARGS((tDefinitions obj));
bool IsDynamic ARGS((tDefinitions obj));
static bool CollapsedAlignment ARGS((tDefinitions d, tDefinitions temp));
static bool IsCollapsed ARGS((tDefinitions template_list, tDefinitions target_list));
static bool IsCollapsedDim ARGS((tDefinitions template_dim, tDefinitions target_dim));
bool SameTopologyObject ARGS((tDefinitions t_obj1, tDefinitions t_obj2));
static bool SameSubProcs ARGS((tTree d1, tTree d2));
static bool SameProcessors ARGS((tTree d1, tTree d2));
static bool SameTarget ARGS((tTree t1, tTree t2));
bool IsFullTopologyObj ARGS((tDefinitions t));

static int CodeDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
# line 82 "Distributions.puma"
  {
# line 83 "Distributions.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return 0;
yyL1:;

  if (d->Kind == kReplicatedDistribution) {
# line 87 "Distributions.puma"
   return 0;

  }
# line 91 "Distributions.puma"
  {
# line 92 "Distributions.puma"
   if (! ((d->Distribution.shared == 1))) goto yyL3;
  }
   return 2;
yyL3:;

  if (d->Kind == kNodeDistribution) {
# line 96 "Distributions.puma"
   return 1;

  }
  if (d->Kind == kRangeDistribution) {
# line 100 "Distributions.puma"
   return 1;

  }
  if (d->Kind == kAlignDistribution) {
# line 106 "Distributions.puma"
  {
# line 108 "Distributions.puma"
   if (! ((CollapsedAlignment (d, d->AlignDistribution.template_obj)))) goto yyL6;
  }
   return 0;
yyL6:;

# line 112 "Distributions.puma"
   return 1;

  }
  if (d->Kind == kDefaultDistribution) {
# line 116 "Distributions.puma"
  {
# line 117 "Distributions.puma"
   error_protocol ("DefaultDistribution for CodeDistribution");
# line 118 "Distributions.puma"
   kill_in_protocol ();
  }
   return 0;

  }
  if (d->Kind == kDeclDistribution) {
# line 122 "Distributions.puma"
  {
# line 123 "Distributions.puma"
   error_protocol ("DeclDistribution for CodeDistribution");
# line 124 "Distributions.puma"
   kill_in_protocol ();
  }
   return 0;

  }
# line 128 "Distributions.puma"
  {
# line 129 "Distributions.puma"
   failure_protocol (MODULE, "CodeDistribution", NoTree);
  }
   return 0;

}

int VarDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 143 "Distributions.puma"
  {
# line 144 "Distributions.puma"
   if (! ((v == NoObject))) goto yyL1;
  }
   return 0;
yyL1:;

# line 150 "Distributions.puma"
  {
# line 151 "Distributions.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return 0;
yyL2:;

# line 155 "Distributions.puma"
  {
# line 156 "Distributions.puma"
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL3;
  }
   return 0;
yyL3:;

  if (v->Kind == kVarObject) {
# line 160 "Distributions.puma"
   return CodeDistribution (v->VarObject.Dist);

  }
  if (v->Kind == kTemplateObject) {
# line 165 "Distributions.puma"
   return CodeDistribution (v->TemplateObject.Dist);

  }
  if (v->Kind == kRaggedObject) {
# line 170 "Distributions.puma"
   return CodeDistribution (v->RaggedObject.Dist);

  }
  if (v->Kind == kProcObject) {
# line 175 "Distributions.puma"
   return 0;

  }
  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
# line 179 "Distributions.puma"
  {
# line 180 "Distributions.puma"
   if (! ((v->FuncObject.Kind == UserRoutine))) goto yyL8;
  }
   return VarDistribution (GetFuncVarObj (v));
yyL8:;

  }
  if (v->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 184 "Distributions.puma"
   return 0;

  }
  if (v->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 189 "Distributions.puma"
   return 0;

  }
  }
  if (v->Kind == kBlockObject) {
# line 194 "Distributions.puma"
  {
# line 195 "Distributions.puma"
   obj_error_protocol ("VarDistribution for BlockObject", v);
# line 196 "Distributions.puma"
   kill_in_protocol ();
  }
   return 0;

  }
# line 200 "Distributions.puma"
  {
# line 201 "Distributions.puma"
   obj_error_protocol ("Illegal Object for VarDistribution", v);
# line 202 "Distributions.puma"
   failure_protocol (MODULE, "VarDistribution", v->Object.decl);
  }
   return 0;

}

int TreeWriteDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{

  switch (var->Kind) {
  case kVAR_OBJ:
# line 222 "Distributions.puma"
  {
# line 224 "Distributions.puma"
   if (! ((var->VAR_OBJ.Reaching == NoTree))) goto yyL1;
  }
   return VarDistribution (var->VAR_OBJ.Object);
yyL1:;

  if (var->VAR_OBJ.Reaching->Kind == kREACHING_INFO) {
# line 228 "Distributions.puma"
   return CodeDistribution (var->VAR_OBJ.Reaching->REACHING_INFO.var_distribution);

  }
# line 232 "Distributions.puma"
   return VarDistribution (var->VAR_OBJ.Object);

  case kUSED_VAR:
# line 236 "Distributions.puma"
   return TreeWriteDistribution (var->USED_VAR.VARNAME);

  case kLOOP_VAR:
# line 240 "Distributions.puma"
   return 0;

  case kINDEXED_VAR:
# line 244 "Distributions.puma"
   return DistributionWriteIndexed (TreeWriteDistribution (var->INDEXED_VAR.IND_VAR), TreeReadDistribution (var->INDEXED_VAR.IND_EXPS));

  case kSUBSTRING_VAR:
# line 250 "Distributions.puma"
   return DistributionWriteIndexed (TreeWriteDistribution (var->SUBSTRING_VAR.IND_VAR), TreeReadDistribution (var->SUBSTRING_VAR.IND_EXP));

  case kSELECTED_VAR:
# line 256 "Distributions.puma"
   return TreeWriteDistribution (var->SELECTED_VAR.SELEC_VAR);

  case kPERM_VAR:
# line 260 "Distributions.puma"
   return TreeWriteDistribution (var->PERM_VAR.VAL);

  case kDO_VAR:
# line 264 "Distributions.puma"
   return DistributionWriteIndexed (TreeWriteDistribution (var->DO_VAR.BODY), TreeReadDistribution (var->DO_VAR.RANGE));

  case kBTV_LIST:
  if (var->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 270 "Distributions.puma"
   return TreeWriteDistribution (var->BTV_LIST.Elem);

  }
# line 275 "Distributions.puma"
   return DistributionWriteMerge (TreeWriteDistribution (var->BTV_LIST.Elem), TreeWriteDistribution (var->BTV_LIST.Next));

  case kBTV_EMPTY:
# line 281 "Distributions.puma"
   return 0;

  case kADDR:
# line 286 "Distributions.puma"
   return TreeReadDistribution (var->ADDR.E);

  }

# line 290 "Distributions.puma"
  {
# line 291 "Distributions.puma"
   failure_protocol (MODULE, "TreeWriteDistribution", var);
  }
   return 0;

}

static int DistributionWriteIndexed
# if defined __STDC__ | defined __cplusplus
(register int write_dist, register int read_dist)
# else
(write_dist, read_dist)
 register int write_dist;
 register int read_dist;
# endif
{
# line 303 "Distributions.puma"
  {
# line 304 "Distributions.puma"
   if (! ((read_dist == 0))) goto yyL1;
  }
   return write_dist;
yyL1:;

# line 308 "Distributions.puma"
  {
# line 309 "Distributions.puma"
   if (! ((read_dist == - 1))) goto yyL2;
  {
# line 310 "Distributions.puma"
   if (! ((write_dist == - 1))) goto yyL2;
  }
  }
   return - 1;
yyL2:;

# line 314 "Distributions.puma"
   return - 2;

}

static int DistributionWriteMerge
# if defined __STDC__ | defined __cplusplus
(register int write1, register int write2)
# else
(write1, write2)
 register int write1;
 register int write2;
# endif
{
# line 326 "Distributions.puma"
  {
# line 327 "Distributions.puma"
   if (! ((write1 == write2))) goto yyL1;
  }
   return write1;
yyL1:;

# line 331 "Distributions.puma"
   return - 2;

}

int TreeReadDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kBTE_LIST:
# line 349 "Distributions.puma"
   return DistributionReadMerge (TreeReadDistribution (exp->BTE_LIST.Elem), TreeReadDistribution (exp->BTE_LIST.Next));

  case kBTE_EMPTY:
# line 355 "Distributions.puma"
   return 0;

  case kARRAY_EXP:
# line 359 "Distributions.puma"
   return TreeReadDistribution (exp->ARRAY_EXP.ELEMENTS);

  case kTYPE_EXP:
# line 363 "Distributions.puma"
   return TreeReadDistribution (exp->TYPE_EXP.ELEMENTS);

  case kDUMMY_EXP:
# line 367 "Distributions.puma"
   return 0;

  case kCONST_EXP:
# line 372 "Distributions.puma"
   return 0;

  case kSLICE_EXP:
# line 377 "Distributions.puma"
   return DistributionReadMerge (TreeReadDistribution (exp->SLICE_EXP.START), DistributionReadMerge (TreeReadDistribution (exp->SLICE_EXP.STOP), TreeReadDistribution (exp->SLICE_EXP.INC)));

  case kOP_EXP:
# line 384 "Distributions.puma"
   return DistributionReadMerge (TreeReadDistribution (exp->OP_EXP.OPND1), TreeReadDistribution (exp->OP_EXP.OPND2));

  case kOP1_EXP:
# line 390 "Distributions.puma"
   return TreeReadDistribution (exp->OP1_EXP.OPND);

  case kVAR_EXP:
# line 394 "Distributions.puma"
   return DistributionReadVar (TreeWriteDistribution (exp->VAR_EXP.V));

  case kFUNC_CALL_EXP:
# line 399 "Distributions.puma"
  {
# line 401 "Distributions.puma"
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL11;
  {
# line 402 "Distributions.puma"
   if (! ((IntrFuncInquiry (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL11;
  }
  }
   return 0;
yyL11:;

# line 406 "Distributions.puma"
  {
# line 408 "Distributions.puma"
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL12;
  }
   return TreeReadDistribution (exp->FUNC_CALL_EXP.FUNC_PARAMS);
yyL12:;

# line 412 "Distributions.puma"
  {
# line 414 "Distributions.puma"
   if (! ((IsStmtCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL13;
  }
   return TreeReadDistribution (exp->FUNC_CALL_EXP.FUNC_PARAMS);
yyL13:;

# line 418 "Distributions.puma"
  {
# line 420 "Distributions.puma"
   if (! ((IsPureCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL14;
  }
   return TreeReadDistribution (exp->FUNC_CALL_EXP.FUNC_PARAMS);
yyL14:;

# line 424 "Distributions.puma"
   return - 2;

  case kDO_EXP:
# line 429 "Distributions.puma"
   return DistributionReadMerge (TreeReadDistribution (exp->DO_EXP.RANGE), TreeReadDistribution (exp->DO_EXP.BODY));

  case kBOUND_EXP:
# line 435 "Distributions.puma"
   return 0;

  case kRANK_EXP:
# line 439 "Distributions.puma"
   return 0;

  case kBTP_LIST:
# line 443 "Distributions.puma"
   return DistributionReadMerge (TreeReadDistribution (exp->BTP_LIST.Elem), TreeReadDistribution (exp->BTP_LIST.Next));

  case kBTP_EMPTY:
# line 449 "Distributions.puma"
   return 0;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
# line 453 "Distributions.puma"
   return TreeReadDistribution (exp->VAR_PARAM.V->ADDR.E);

  }
# line 457 "Distributions.puma"
   return DistributionReadVar (TreeWriteDistribution (exp->VAR_PARAM.V));

  case kNO_PARAM:
# line 462 "Distributions.puma"
   return 0;

  case kPROC_PARAM:
# line 466 "Distributions.puma"
   return 0;

  case kFUNC_PARAM:
# line 470 "Distributions.puma"
   return 0;

  }

# line 474 "Distributions.puma"
  {
# line 475 "Distributions.puma"
   failure_protocol (MODULE, "TreeReadDistribution", exp);
  }
   return 0;

}

static int DistributionReadMerge
# if defined __STDC__ | defined __cplusplus
(register int dist1, register int dist2)
# else
(dist1, dist2)
 register int dist1;
 register int dist2;
# endif
{
  if (equalint (dist2, 0)) {
# line 487 "Distributions.puma"
   return dist1;

  }
  if (equalint (dist1, 0)) {
# line 491 "Distributions.puma"
   return dist2;

  }
# line 495 "Distributions.puma"
  {
# line 496 "Distributions.puma"
   if (! ((dist1 == dist2))) goto yyL3;
  }
   return dist1;
yyL3:;

# line 500 "Distributions.puma"
   return - 2;

}

static int DistributionReadVar
# if defined __STDC__ | defined __cplusplus
(register int writedist)
# else
(writedist)
 register int writedist;
# endif
{
# line 512 "Distributions.puma"
  {
# line 513 "Distributions.puma"
   if (! ((writedist == 2))) goto yyL1;
  }
   return 0;
yyL1:;

# line 517 "Distributions.puma"
  {
# line 518 "Distributions.puma"
   if (! ((writedist == 1))) goto yyL2;
  }
   return - 2;
yyL2:;

# line 522 "Distributions.puma"
   return writedist;

}

tDefinitions GetTemplateObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Dist->Kind == kAlignDistribution) {
# line 536 "Distributions.puma"
   return v->VarObject.Dist->AlignDistribution.template_obj;

  }
  }
# line 541 "Distributions.puma"
   return v;

}

tDefinitions GetTopologyObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Dist->Kind == kNodeDistribution) {
# line 555 "Distributions.puma"
   return v->VarObject.Dist->NodeDistribution.top_obj;

  }
  }
  if (v->Kind == kTemplateObject) {
  if (v->TemplateObject.Dist->Kind == kNodeDistribution) {
# line 560 "Distributions.puma"
   return v->TemplateObject.Dist->NodeDistribution.top_obj;

  }
  }
  if (v->Kind == kRaggedObject) {
  if (v->RaggedObject.Dist->Kind == kNodeDistribution) {
# line 565 "Distributions.puma"
   return v->RaggedObject.Dist->NodeDistribution.top_obj;

  }
  }
# line 570 "Distributions.puma"
   return NoObject;

}

tDefinitions DimListGet
# if defined __STDC__ | defined __cplusplus
(register tDefinitions list, register int pos)
# else
(list, pos)
 register tDefinitions list;
 register int pos;
# endif
{
# line 584 "Distributions.puma"
  {
# line 585 "Distributions.puma"
   if (! ((pos <= 0))) goto yyL1;
  {
# line 586 "Distributions.puma"
   error_protocol ("DimListGet with pos < 0");
# line 587 "Distributions.puma"
   kill_in_protocol ();
  }
  }
   return NoObject;
yyL1:;

  if (list->Kind == kDIM_EMPTY) {
# line 591 "Distributions.puma"
  {
# line 592 "Distributions.puma"
   error_protocol ("DimListGet with empty list");
# line 593 "Distributions.puma"
   kill_in_protocol ();
  }
   return NoObject;

  }
  if (list->Kind == kDIM_LIST) {
  if (equalint (pos, 1)) {
# line 597 "Distributions.puma"
   return list->DIM_LIST.Elem;

  }
# line 601 "Distributions.puma"
   return DimListGet (list->DIM_LIST.Next, pos - 1);

  }
 yyAbort ("DimListGet");
}

int DimListLength
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
  if (d->Kind == kDIM_EMPTY) {
# line 607 "Distributions.puma"
   return 0;

  }
  if (d->Kind == kDIM_LIST) {
# line 611 "Distributions.puma"
   return 1 + DimListLength (d->DIM_LIST.Next);

  }
 yyAbort ("DimListLength");
}

static int GetVarDim
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int var_dimension)
# else
(indexes, var_dimension)
 register tTree indexes;
 register int var_dimension;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
# line 625 "Distributions.puma"
  {
# line 626 "Distributions.puma"
   if (! ((TreeRank (indexes->BTE_LIST.Elem) == 0))) goto yyL1;
  }
   return GetVarDim (indexes->BTE_LIST.Next, var_dimension) + 1;
yyL1:;

# line 630 "Distributions.puma"
  {
# line 631 "Distributions.puma"
   if (! ((var_dimension == 1))) goto yyL2;
  }
   return 1;
yyL2:;

# line 635 "Distributions.puma"
   return GetVarDim (indexes->BTE_LIST.Next, var_dimension - 1) + 1;

  }
# line 639 "Distributions.puma"
  {
# line 640 "Distributions.puma"
   failure_protocol (MODULE, "GetVarDim", indexes);
  }
   return 0;

}

bool IsDistributedObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kRaggedObject) {
  if (obj->RaggedObject.Dist->Kind == kNodeDistribution) {
# line 652 "Distributions.puma"
   return true;

  }
  }
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Kind == kNodeDistribution) {
# line 655 "Distributions.puma"
   return true;

  }
  }
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Kind == kNodeDistribution) {
# line 658 "Distributions.puma"
   return true;

  }
  }
  return false;
}

bool IsAlignedObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Kind == kAlignDistribution) {
# line 663 "Distributions.puma"
   return true;

  }
  if (obj->VarObject.Dist->Kind == kDeclDistribution) {
  if (obj->VarObject.Dist->DeclDistribution.decl->Kind == kALIGN_DECL) {
# line 666 "Distributions.puma"
   return true;

  }
  }
  }
  return false;
}

bool IsTranscriptiveObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Kind == kRangeDistribution) {
# line 671 "Distributions.puma"
   return true;

  }
  }
  return false;
}

bool IsDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 680 "Distributions.puma"
  {
# line 681 "Distributions.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 682 "Distributions.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
# line 685 "Distributions.puma"
  {
# line 686 "Distributions.puma"
   if (! ((obj->VarObject.Dist->Distribution.dynamic))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (obj->Kind == kTemplateObject) {
# line 689 "Distributions.puma"
  {
# line 690 "Distributions.puma"
   if (! ((obj->TemplateObject.Dist->Distribution.dynamic))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static bool CollapsedAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tDefinitions temp)
# else
(d, temp)
 register tDefinitions d;
 register tDefinitions temp;
# endif
{
# line 701 "Distributions.puma"
  {
# line 703 "Distributions.puma"
   if (! ((VarDistribution (temp) == 0))) goto yyL1;
  }
   return true;
yyL1:;

  if (d->Kind == kAlignDistribution) {
  if (temp->Kind == kTemplateObject) {
  if (temp->TemplateObject.Dist->Kind == kNodeDistribution) {
# line 706 "Distributions.puma"
  {
# line 709 "Distributions.puma"
   if (! ((IsCollapsed (temp->TemplateObject.Dist->NodeDistribution.ArrayList, d->AlignDistribution.TargetList)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  if (temp->Kind == kVarObject) {
  if (temp->VarObject.Dist->Kind == kNodeDistribution) {
# line 712 "Distributions.puma"
  {
# line 715 "Distributions.puma"
   if (! ((IsCollapsed (temp->VarObject.Dist->NodeDistribution.ArrayList, d->AlignDistribution.TargetList)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  }
  return false;
}

static bool IsCollapsed
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template_list, register tDefinitions target_list)
# else
(template_list, target_list)
 register tDefinitions template_list;
 register tDefinitions target_list;
# endif
{
  if (template_list->Kind == kDIM_LIST) {
  if (target_list->Kind == kDIM_LIST) {
# line 720 "Distributions.puma"
  {
# line 722 "Distributions.puma"
   if (! ((IsCollapsedDim (template_list->DIM_LIST.Elem, target_list->DIM_LIST.Elem)))) goto yyL1;
  {
# line 723 "Distributions.puma"
   if (! ((IsCollapsed (template_list->DIM_LIST.Next, target_list->DIM_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  if (template_list->Kind == kDIM_EMPTY) {
  if (target_list->Kind == kDIM_EMPTY) {
# line 726 "Distributions.puma"
   return true;

  }
  }
  return false;
}

static bool IsCollapsedDim
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template_dim, register tDefinitions target_dim)
# else
(template_dim, target_dim)
 register tDefinitions template_dim;
 register tDefinitions target_dim;
# endif
{
  if (template_dim->Kind == kSerialDimension) {
# line 732 "Distributions.puma"
   return true;

  }
  if (target_dim->Kind == kReplicatedDimension) {
# line 735 "Distributions.puma"
   return true;

  }
  return false;
}

bool SameTopologyObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t_obj1, register tDefinitions t_obj2)
# else
(t_obj1, t_obj2)
 register tDefinitions t_obj1;
 register tDefinitions t_obj2;
# endif
{
# line 747 "Distributions.puma"
  {
# line 749 "Distributions.puma"
   if (! ((t_obj1 == NoObject))) goto yyL1;
  {
# line 750 "Distributions.puma"
   return false;
  }
  }
yyL1:;

# line 753 "Distributions.puma"
  {
# line 755 "Distributions.puma"
   if (! ((t_obj2 == NoObject))) goto yyL2;
  {
# line 756 "Distributions.puma"
   return false;
  }
  }
yyL2:;

# line 759 "Distributions.puma"
  {
# line 761 "Distributions.puma"
   if (! ((t_obj1 == t_obj2))) goto yyL3;
  }
   return true;
yyL3:;

# line 764 "Distributions.puma"
  {
# line 767 "Distributions.puma"
   if (! ((t_obj1->TopologyObject.rank == t_obj2->TopologyObject.rank))) goto yyL4;
  {
# line 768 "Distributions.puma"
   if (! ((t_obj1->TopologyObject.Ident == DefaultId ()))) goto yyL4;
  {
# line 769 "Distributions.puma"
   if (! ((t_obj2->TopologyObject.Ident == DefaultId ()))) goto yyL4;
  }
  }
  }
   return true;
yyL4:;

# line 772 "Distributions.puma"
  {
# line 775 "Distributions.puma"
   if (! ((t_obj1->TopologyObject.Ident != DefaultId ()))) goto yyL5;
  {
# line 776 "Distributions.puma"
   if (! ((t_obj2->TopologyObject.Ident != DefaultId ()))) goto yyL5;
  {
# line 777 "Distributions.puma"
   if (! ((t_obj1->TopologyObject.rank == t_obj2->TopologyObject.rank))) goto yyL5;
  {
# line 778 "Distributions.puma"
   if (! ((SameProcessors (t_obj1->TopologyObject.decl, t_obj2->TopologyObject.decl) || SameSubProcs (t_obj1->TopologyObject.decl, t_obj2->TopologyObject.decl)))) goto yyL5;
  {
# line 779 "Distributions.puma"
   if (! ((SameTarget (t_obj1->TopologyObject.target, t_obj2->TopologyObject.target)))) goto yyL5;
  }
  }
  }
  }
  }
   return true;
yyL5:;

  return false;
}

static bool SameSubProcs
# if defined __STDC__ | defined __cplusplus
(register tTree d1, register tTree d2)
# else
(d1, d2)
 register tTree d1;
 register tTree d2;
# endif
{
  if (d1->Kind == kSUB_PROCS_DECL) {
  if (d2->Kind == kSUB_PROCS_DECL) {
# line 792 "Distributions.puma"
  {
# line 795 "Distributions.puma"
   if (! ((d1->SUB_PROCS_DECL.TOP->TOP_OBJ.Object == d2->SUB_PROCS_DECL.TOP->TOP_OBJ.Object))) goto yyL1;
  {
# line 796 "Distributions.puma"
   if (! ((EqualIndexes (d1->SUB_PROCS_DECL.DIMENSIONS, d2->SUB_PROCS_DECL.DIMENSIONS)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  return false;
}

static bool SameProcessors
# if defined __STDC__ | defined __cplusplus
(register tTree d1, register tTree d2)
# else
(d1, d2)
 register tTree d1;
 register tTree d2;
# endif
{
  if (d1->Kind == kPROCESSORS_DECL) {
  if (d2->Kind == kPROCESSORS_DECL) {
# line 801 "Distributions.puma"
  {
# line 803 "Distributions.puma"
   if (! ((SameProcessors (d1->PROCESSORS_DECL.DIMENSIONS, d2->PROCESSORS_DECL.DIMENSIONS)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  if (d1->Kind == kSHAPE_LIST) {
  if (d2->Kind == kSHAPE_LIST) {
# line 806 "Distributions.puma"
  {
# line 808 "Distributions.puma"
   if (! ((SameProcessors (d1->SHAPE_LIST.Elem, d2->SHAPE_LIST.Elem)))) goto yyL2;
  {
# line 809 "Distributions.puma"
   if (! ((SameProcessors (d1->SHAPE_LIST.Next, d2->SHAPE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  }
  if (d1->Kind == kSHAPE_EMPTY) {
  if (d2->Kind == kSHAPE_EMPTY) {
# line 812 "Distributions.puma"
   return true;

  }
  }
  if (d1->Kind == kEXPLICIT_SHAPE) {
  if (d2->Kind == kEXPLICIT_SHAPE) {
# line 815 "Distributions.puma"
 {
  bool found;
  int val1;
  int val2;
  {
# line 818 "Distributions.puma"

# line 819 "Distributions.puma"

# line 820 "Distributions.puma"

# line 822 "Distributions.puma"
   GetConstDifference (d1->EXPLICIT_SHAPE.LOWER, d2->EXPLICIT_SHAPE.LOWER, & found, & val1);
# line 823 "Distributions.puma"
   if (! ((found))) goto yyL4;
  {
# line 824 "Distributions.puma"
   GetConstDifference (d1->EXPLICIT_SHAPE.UPPER, d2->EXPLICIT_SHAPE.UPPER, & found, & val2);
# line 825 "Distributions.puma"
   if (! ((found))) goto yyL4;
  {
# line 826 "Distributions.puma"
   if (! ((val1 == val2))) goto yyL4;
  }
  }
  }
   return true;
 }
yyL4:;

  }
  }
  return false;
}

static bool SameTarget
# if defined __STDC__ | defined __cplusplus
(register tTree t1, register tTree t2)
# else
(t1, t2)
 register tTree t1;
 register tTree t2;
# endif
{
# line 840 "Distributions.puma"
  {
# line 842 "Distributions.puma"
   if (! ((t1 == NoTree))) goto yyL1;
  {
# line 843 "Distributions.puma"
   if (! ((t2 == NoTree))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 846 "Distributions.puma"
 {
  bool found;
  int val;
  {
# line 848 "Distributions.puma"
   if (! ((t1 == NoTree))) goto yyL2;
  {
# line 850 "Distributions.puma"

# line 851 "Distributions.puma"

# line 853 "Distributions.puma"
   GetIntConstValue (t2, & found, & val);
# line 854 "Distributions.puma"
   if (! ((found))) goto yyL2;
  {
# line 855 "Distributions.puma"
   if (! ((val == 1))) goto yyL2;
  }
  }
  }
   return true;
 }
yyL2:;

# line 858 "Distributions.puma"
 {
  bool found;
  int val;
  {
# line 860 "Distributions.puma"
   if (! ((t2 == NoTree))) goto yyL3;
  {
# line 862 "Distributions.puma"

# line 863 "Distributions.puma"

# line 865 "Distributions.puma"
   GetIntConstValue (t1, & found, & val);
# line 866 "Distributions.puma"
   if (! ((found))) goto yyL3;
  {
# line 867 "Distributions.puma"
   if (! ((val == 1))) goto yyL3;
  }
  }
  }
   return true;
 }
yyL3:;

# line 870 "Distributions.puma"
  {
# line 872 "Distributions.puma"
   if (! ((t1 != NoTree))) goto yyL4;
  {
# line 873 "Distributions.puma"
   if (! ((t2 != NoTree))) goto yyL4;
  {
# line 875 "Distributions.puma"
   if (! ((EqualExpression (t1, t2)))) goto yyL4;
  }
  }
  }
   return true;
yyL4:;

  return false;
}

bool IsFullTopologyObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
# line 886 "Distributions.puma"
  {
# line 887 "Distributions.puma"
   if (! ((t == NoObject))) goto yyL1;
  {
# line 888 "Distributions.puma"
   return false;
  }
  }
yyL1:;

# line 891 "Distributions.puma"
  {
# line 893 "Distributions.puma"
   if (! ((t->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  {
# line 894 "Distributions.puma"
   if (! ((t->TopologyObject.rank >= 0))) goto yyL2;
  }
  }
   return true;
yyL2:;

  return false;
}

void BeginDistributions ()
{
}

void CloseDistributions ()
{
}
