# include "Dependences.h"
# include "yyDependences.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 51 "Dependences.puma"


# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Invariant.h"     /* is var in _exp */
# include "Rank.h"
# include "TreeOps.h"
# include "Expressions.h"

# define MODULE "Dependences"
# undef DEBUG



static void yyExit () { Exit (1); }

void (* Dependences_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Dependences, routine %s failed\n", yyFunction);
 Dependences_Exit ();
}

void Dependences ARGS((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void IndexCompare ARGS((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void GetExpNormalization ARGS((tTree e, ptree loops, int n, bool * yyP2, ExpNormRecord * yyP1));
static void CheckDifferentIndex ARGS((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, pPredVector p));
static bool LoopIndependentExpression ARGS((tTree exp, ptree loops, int n));
static bool LoopVariant ARGS((tTree exp, tTree loop));
static void CheckDifferentModulo ARGS((tTree e1, tTree e2, pPredVector p));
static void FindMultiplicator ARGS((tTree e, bool * yyP5, int * yyP4, int * yyP3));
static void BuildModulo ARGS((int a, int c, int * yyP6));
static void GCD ARGS((int x1, int x2, int * yyP7));
static void CheckEqualIndex ARGS((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, pPredVector p));
static void GetLoopPos ARGS((tTree v, ptree loops, int n, bool * yyP9, int * yyP8));
static void ExpCompare ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void DeltaCheck ARGS((ExpNormRecord e, ptree loops, int n, bool flow, int low, bool fup, int up, pPredVector p));
static void MakeDelta ARGS((ExpNormRecord e, ptree loops, int n, pPredVector p, bool * yyP13, int * yyP12, int * yyP11, int * yyP10));
static void MakeNewPred ARGS((int delta, int pos, int val, bool flow, int low, bool fup, int up, pPredVector p));

void Dependences
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
# line 93 "Dependences.puma"

char PVString [100];

  if (e1->Kind == kINDEXED_VAR) {
  if (e1->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
  if (e2->Kind == kINDEXED_VAR) {
  if (e2->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 97 "Dependences.puma"
  {
# line 100 "Dependences.puma"
   if (! ((e1->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident == e2->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident))) goto yyL1;
  {
# line 102 "Dependences.puma"
 

# ifdef DEBUG
     printf ("Call of Dependences (common loops = %d, const = %d\n",
              CommonLoops, ConstLoops);
     printf ("e1 = "); FileUnparse (stdout, e1); printf (" in %d loops\n", n1);
     printf ("e2 = "); FileUnparse (stdout, e2); printf (" in %d loops\n", n2);
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Dependences : Predicate = %s\n", PVString);
# endif 

     IndexCompare (e1->INDEXED_VAR.IND_EXPS, loops1, n1, e2->INDEXED_VAR.IND_EXPS, loops2, n2,
                   CommonLoops, ConstLoops, p);

# ifdef DEBUG
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Dependences : ResultPredicate = %s\n", PVString);
# endif 
  
  }
  }
   return;
yyL1:;

  }
  }
  }
  }
# line 123 "Dependences.puma"
  {
# line 125 "Dependences.puma"
   failure2_protocol (MODULE, "Dependences", e1, e2);
  }
   return;

;
}

static void IndexCompare
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
# line 146 "Dependences.puma"

char PVString[100];

  if (e1->Kind == kBTE_LIST) {
  if (e2->Kind == kBTE_LIST) {
# line 150 "Dependences.puma"
 {
  bool yyV1;
  ExpNormRecord yyV2;
  bool yyV3;
  ExpNormRecord yyV4;
  {
# line 155 "Dependences.puma"
   IndexCompare (e1->BTE_LIST.Next, loops1, n1, e2->BTE_LIST.Next, loops2, n2, CommonLoops, ConstLoops, p);
# line 158 "Dependences.puma"
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
# line 160 "Dependences.puma"

#ifdef DEBUG 
     printf ("compare indexes ");
     FileUnparse (stdout, e1->BTE_LIST.Elem);
     printf (" and ");
     FileUnparse (stdout, e2->BTE_LIST.Elem);
     printf ("\n");
#endif
    
# line 172 "Dependences.puma"
   CheckDifferentIndex (e1->BTE_LIST.Elem, loops1, n1, e2->BTE_LIST.Elem, loops2, n2, p);
# line 173 "Dependences.puma"
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
# line 175 "Dependences.puma"
   CheckDifferentModulo (e1->BTE_LIST.Elem, e2->BTE_LIST.Elem, p);
# line 176 "Dependences.puma"
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
# line 178 "Dependences.puma"
   CheckEqualIndex (e1->BTE_LIST.Elem, loops1, n1, e2->BTE_LIST.Elem, loops2, n2, p);
# line 179 "Dependences.puma"
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
# line 183 "Dependences.puma"
   GetExpNormalization (e1->BTE_LIST.Elem, loops1, n1, & yyV1, & yyV2);
# line 184 "Dependences.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 186 "Dependences.puma"
   GetExpNormalization (e2->BTE_LIST.Elem, loops2, n2, & yyV3, & yyV4);
# line 187 "Dependences.puma"
   if (! ((yyV3))) goto yyL1;
  {
# line 191 "Dependences.puma"
   ExpCompare (yyV2, loops1, n1, yyV4, loops2, n2, CommonLoops, ConstLoops, p);
  }
  }
  }
  }
  }
  }
  }
   return;
 }
yyL1:;

# line 195 "Dependences.puma"
   return;

  }
  }
  if (e1->Kind == kBTE_EMPTY) {
  if (e2->Kind == kBTE_EMPTY) {
# line 201 "Dependences.puma"
   return;

  }
  }
# line 205 "Dependences.puma"
  {
# line 207 "Dependences.puma"
   failure2_protocol (MODULE, "IndexCompare", e1, e2);
  }
   return;

;
}

static void GetExpNormalization
# if defined __STDC__ | defined __cplusplus
(register tTree e, ptree loops, register int n, register bool * yyP2, ExpNormRecord * yyP1)
# else
(e, loops, n, yyP2, yyP1)
 register tTree e;
 ptree loops;
 register int n;
 register bool * yyP2;
 ExpNormRecord * yyP1;
# endif
{
# line 221 "Dependences.puma"
 {
  bool found;
  ExpNormRecord en;
  {
# line 223 "Dependences.puma"

# line 224 "Dependences.puma"

# line 226 "Dependences.puma"
   ExpNormal (e, loops, n, & found, & en);
  }
   * yyP2 = found;
   * yyP1 = en;
   return;
 }

;
}

static void CheckDifferentIndex
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 pPredVector p;
# endif
{
# line 242 "Dependences.puma"
 {
  bool found;
  int val;
  {
# line 246 "Dependences.puma"
   if (! ((TreeRank (e1) == 0))) goto yyL1;
  {
# line 247 "Dependences.puma"
   if (! ((TreeRank (e2) == 0))) goto yyL1;
  {
# line 249 "Dependences.puma"
   if (! ((LoopIndependentExpression (e1, loops1, n1)))) goto yyL1;
  {
# line 250 "Dependences.puma"
   if (! ((LoopIndependentExpression (e2, loops2, n2)))) goto yyL1;
  {
# line 252 "Dependences.puma"

# line 253 "Dependences.puma"

# line 255 "Dependences.puma"
   GetConstDifference (e1, e2, & found, & val);
# line 256 "Dependences.puma"
   if (! ((found))) goto yyL1;
  {
# line 257 "Dependences.puma"
   if (! ((val != 0))) goto yyL1;
  {
# line 259 "Dependences.puma"

#ifdef DEBUG
   printf ("index expression have constant difference : %d\n", val);
#endif 
  
# line 265 "Dependences.puma"
   PVSetFalse (p);
  }
  }
  }
  }
  }
  }
  }
   return;
 }
yyL1:;

;
}

static bool LoopIndependentExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp, ptree loops, register int n)
# else
(exp, loops, n)
 register tTree exp;
 ptree loops;
 register int n;
# endif
{
# line 278 "Dependences.puma"
 {
  bool ok;
  int i;
  {
# line 280 "Dependences.puma"

# line 281 "Dependences.puma"

# line 283 "Dependences.puma"
 ok = true;
    for (i= 0; i<n; i++)
        if (LoopVariant (exp, loops[i]))
           ok = false;
  
# line 288 "Dependences.puma"
   if (! ((ok))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool LoopVariant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree loop)
# else
(exp, loop)
 register tTree exp;
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
# line 293 "Dependences.puma"
  {
# line 295 "Dependences.puma"
   if (! ((IsVarInExp (TreeVarName (loop->ACF_FORALL.FORALL_ID), exp)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (loop->Kind == kACF_DO) {
# line 298 "Dependences.puma"
  {
# line 300 "Dependences.puma"
   if (! ((IsVarInExp (TreeVarName (loop->ACF_DO.DO_ID), exp)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

static void CheckDifferentModulo
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2, pPredVector p)
# else
(e1, e2, p)
 register tTree e1;
 register tTree e2;
 pPredVector p;
# endif
{
# line 313 "Dependences.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  bool yyV4;
  int yyV5;
  int yyV6;
  int yyV7;
  int yyV8;
  int yyV9;
  {
# line 315 "Dependences.puma"
   FindMultiplicator (e1, & yyV1, & yyV2, & yyV3);
# line 316 "Dependences.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 317 "Dependences.puma"
   FindMultiplicator (e2, & yyV4, & yyV5, & yyV6);
# line 318 "Dependences.puma"
   if (! ((yyV4))) goto yyL1;
  {
# line 320 "Dependences.puma"
 
#ifdef DEBUG
  printf ("compare modulo : e1 = %d * X + %d, e2 = %d * Y + %d\n",
           yyV2, yyV3, yyV5, yyV6);
#endif 
  
# line 327 "Dependences.puma"
   GCD (yyV2, yyV5, & yyV7);
# line 329 "Dependences.puma"
   BuildModulo (yyV3, yyV7, & yyV8);
# line 330 "Dependences.puma"
   BuildModulo (yyV6, yyV7, & yyV9);
# line 332 "Dependences.puma"
 
#ifdef DEBUG
  printf ("compare modulo %d, n1 = %d, n2 = %d\n", yyV7, yyV8, yyV9);
#endif 
  
# line 338 "Dependences.puma"
   if (! ((yyV8 != yyV9))) goto yyL1;
  {
# line 340 "Dependences.puma"
   PVSetFalse (p);
  }
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void FindMultiplicator
# if defined __STDC__ | defined __cplusplus
(register tTree e, register bool * yyP5, register int * yyP4, register int * yyP3)
# else
(e, yyP5, yyP4, yyP3)
 register tTree e;
 register bool * yyP5;
 register int * yyP4;
 register int * yyP3;
# endif
{
# line 353 "Dependences.puma"
 {
  bool found;
  int mult;
  int add;
  tTree var;
  int yyV1;
  {
# line 355 "Dependences.puma"

# line 356 "Dependences.puma"

# line 357 "Dependences.puma"

# line 358 "Dependences.puma"

# line 360 "Dependences.puma"
   ResolveExpression (e, & found, & mult, & add, & var);
# line 361 "Dependences.puma"
   if (! ((found))) goto yyL1;
  {
# line 365 "Dependences.puma"
   BuildModulo (add, mult, & yyV1);
  }
  }
   * yyP5 = true;
   * yyP4 = mult;
   * yyP3 = yyV1;
   return;
 }
yyL1:;

  if (e->Kind == kSLICE_EXP) {
# line 368 "Dependences.puma"
 {
  int a;
  int b;
  int c;
  tTree var;
  bool found;
  int yyV1;
  {
# line 370 "Dependences.puma"

# line 370 "Dependences.puma"

# line 370 "Dependences.puma"

# line 371 "Dependences.puma"

# line 372 "Dependences.puma"

# line 374 "Dependences.puma"
   GetLoopIncrement (e, & found, & c);
# line 375 "Dependences.puma"
   if (! ((found))) goto yyL2;
  {
# line 377 "Dependences.puma"
   ResolveExpression (e->SLICE_EXP.START, & found, & a, & b, & var);
# line 378 "Dependences.puma"
   if (! ((found))) goto yyL2;
  {
# line 380 "Dependences.puma"
   if (! ((a % c == 0))) goto yyL2;
  {
# line 381 "Dependences.puma"
   BuildModulo (b, c, & yyV1);
  }
  }
  }
  }
   * yyP5 = true;
   * yyP4 = c;
   * yyP3 = yyV1;
   return;
 }
yyL2:;

  }
# line 387 "Dependences.puma"
   * yyP5 = false;
   * yyP4 = 0;
   * yyP3 = 0;
   return;

;
}

static void BuildModulo
# if defined __STDC__ | defined __cplusplus
(register int a, register int c, register int * yyP6)
# else
(a, c, yyP6)
 register int a;
 register int c;
 register int * yyP6;
# endif
{
# line 398 "Dependences.puma"
  {
# line 399 "Dependences.puma"
   if (! ((c == 0))) goto yyL1;
  }
   * yyP6 = a;
   return;
yyL1:;

# line 402 "Dependences.puma"
 {
  int yyV1;
  {
# line 403 "Dependences.puma"
   if (! ((c < 0))) goto yyL2;
  {
# line 404 "Dependences.puma"
   BuildModulo (- a, - c, & yyV1);
  }
  }
   * yyP6 = yyV1;
   return;
 }
yyL2:;

# line 407 "Dependences.puma"
  {
# line 408 "Dependences.puma"
   if (! ((a >= 0))) goto yyL3;
  }
   * yyP6 = a % c;
   return;
yyL3:;

# line 411 "Dependences.puma"
  {
# line 412 "Dependences.puma"
   if (! ((a < 0))) goto yyL4;
  }
   * yyP6 = c + a % c;
   return;
yyL4:;

;
}

static void GCD
# if defined __STDC__ | defined __cplusplus
(register int x1, register int x2, register int * yyP7)
# else
(x1, x2, yyP7)
 register int x1;
 register int x2;
 register int * yyP7;
# endif
{
# line 423 "Dependences.puma"
 {
  int yyV1;
  {
# line 425 "Dependences.puma"
   if (! ((x1 < 0))) goto yyL1;
  {
# line 426 "Dependences.puma"
   GCD (- x1, x2, & yyV1);
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL1:;

# line 429 "Dependences.puma"
 {
  int yyV1;
  {
# line 431 "Dependences.puma"
   if (! ((x2 < 0))) goto yyL2;
  {
# line 432 "Dependences.puma"
   GCD (x1, - x2, & yyV1);
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL2:;

# line 435 "Dependences.puma"
  {
# line 436 "Dependences.puma"
   if (! ((x2 == 0))) goto yyL3;
  }
   * yyP7 = x1;
   return;
yyL3:;

# line 439 "Dependences.puma"
  {
# line 440 "Dependences.puma"
   if (! ((x1 == 0))) goto yyL4;
  }
   * yyP7 = x2;
   return;
yyL4:;

# line 443 "Dependences.puma"
  {
# line 444 "Dependences.puma"
   if (! ((x1 == x2))) goto yyL5;
  }
   * yyP7 = x1;
   return;
yyL5:;

# line 447 "Dependences.puma"
 {
  int yyV1;
  {
# line 448 "Dependences.puma"
   if (! ((x1 > x2))) goto yyL6;
  {
# line 449 "Dependences.puma"
   GCD (x1 % x2, x2, & yyV1);
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL6:;

# line 452 "Dependences.puma"
 {
  int yyV1;
  {
# line 453 "Dependences.puma"
   GCD (x1, x2 % x1, & yyV1);
  }
   * yyP7 = yyV1;
   return;
 }

;
}

static void CheckEqualIndex
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 pPredVector p;
# endif
{
# line 471 "Dependences.puma"
 {
  bool found;
  int a1;
  int a2;
  int b1;
  int b2;
  tTree var1;
  tTree var2;
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 475 "Dependences.puma"

# line 476 "Dependences.puma"

# line 477 "Dependences.puma"

# line 478 "Dependences.puma"

# line 479 "Dependences.puma"

# line 480 "Dependences.puma"

# line 481 "Dependences.puma"

# line 483 "Dependences.puma"
   ResolveExpression (e1, & found, & a1, & b1, & var1);
# line 484 "Dependences.puma"
   if (! ((found))) goto yyL1;
  {
# line 485 "Dependences.puma"
   ResolveExpression (e2, & found, & a2, & b2, & var2);
# line 486 "Dependences.puma"
   if (! ((found))) goto yyL1;
  {
# line 488 "Dependences.puma"
   if (! ((a1 == a2))) goto yyL1;
  {
# line 489 "Dependences.puma"
   if (! ((a1 != 0))) goto yyL1;
  {
# line 490 "Dependences.puma"
   if (! ((b1 == b2))) goto yyL1;
  {
# line 492 "Dependences.puma"
   GetLoopPos (var1, loops1, n1, & yyV1, & yyV2);
# line 493 "Dependences.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 494 "Dependences.puma"
   GetLoopPos (var2, loops2, n2, & yyV3, & yyV4);
# line 495 "Dependences.puma"
   if (! ((yyV3))) goto yyL1;
  {
# line 496 "Dependences.puma"
   if (! ((yyV2 == yyV4))) goto yyL1;
  {
# line 500 "Dependences.puma"
   PVAndComponent (p, yyV2, 0, 0);
# line 502 "Dependences.puma"

#ifdef DEBUG
    printf ("equal index from outer loop %d\n", yyV2);
#endif
  
  }
  }
  }
  }
  }
  }
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void GetLoopPos
# if defined __STDC__ | defined __cplusplus
(register tTree v, ptree loops, register int n, register bool * yyP9, register int * yyP8)
# else
(v, loops, n, yyP9, yyP8)
 register tTree v;
 ptree loops;
 register int n;
 register bool * yyP9;
 register int * yyP8;
# endif
{
# line 511 "Dependences.puma"
 {
  int pos;
  {
# line 513 "Dependences.puma"

# line 515 "Dependences.puma"
 int i;
    pos = 0;
    for (i=0; i<n; i++)
        if (EqualExpression (v, GetLoopId (loops[i])))
           pos = i+1;
  
# line 521 "Dependences.puma"
   if (! ((pos > 0))) goto yyL1;
  }
   * yyP9 = true;
   * yyP8 = pos;
   return;
 }
yyL1:;

# line 524 "Dependences.puma"
   * yyP9 = false;
   * yyP8 = 0;
   return;

;
}

static void ExpCompare
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
# line 542 "Dependences.puma"

char PVString[100];

# line 560 "Dependences.puma"
 {
  int low;
  int up;
  bool flow;
  bool fup;
  {
# line 562 "Dependences.puma"

# line 563 "Dependences.puma"

# line 564 "Dependences.puma"

# line 565 "Dependences.puma"

# line 567 "Dependences.puma"
 
# ifdef DEBUG
     printf ("Call of ExpCompare (loops n1 = %d, n2 = %d, common = %d, const = %d)\n",
              n1, n2, CommonLoops, ConstLoops);
     PrintNormRecord ("e1", e1, loops1, n1);
     PrintNormRecord ("e2", e2, loops2, n2);
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Predicate = %s\n", PVString);
# endif 

     if (ExpDifferent (e1, loops1, n1, e2, loops2, n2, ConstLoops))
       {  
          PVSetFalse (p);
# ifdef DEBUG
          printf ("ExpCompare: FALSE, both expressions are different\n");
          strcpy (PVString,""); PVOut (PVString, p);
          printf ("Result Predicate = %s\n", PVString);
# endif 
          return;
       }

# ifdef DEBUG
     printf ("Expressions are not absolute different, consider e1 - e2\n");
# endif 

     DiffLowBound (e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops,
                   &flow, &low);

     

     DiffUppBound (e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops,
                   &fup, &up);

     

# ifdef DEBUG
     if (flow)
        printf ("Difference has lower bound : %d\n", low);
      else
        printf ("Difference has no lower bound\n");
     if (fup)
        printf ("Difference has upper bound : %d\n", up);
      else
        printf ("Difference has no upper bound\n");
# endif 

     if ((!flow) || (!fup))
        PVSetNotExact (p);
      else if (low != up)
        PVSetNotExact (p);

     DeltaCheck (e1, loops1, n1, flow, low, fup, up, p);
     if (!PVIsFalse (p))
       DeltaCheck (e2, loops2, n2, flow, low, fup, up, p);

# ifdef DEBUG
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("ExpCompare: Final Result Predicate = %s\n", PVString);
# endif 
   
  }
   return;
 }

;
}

static void DeltaCheck
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, register bool flow, register int low, register bool fup, register int up, pPredVector p)
# else
(e, loops, n, flow, low, fup, up, p)
 ExpNormRecord e;
 ptree loops;
 register int n;
 register bool flow;
 register int low;
 register bool fup;
 register int up;
 pPredVector p;
# endif
{
# line 649 "Dependences.puma"

char PVString [100];

# line 653 "Dependences.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  {
# line 655 "Dependences.puma"

# ifdef DEBUG
   strcpy (PVString,""); PVOut (PVString, p);
   printf ("Call of DeltaCheck, p = %s\n", PVString);
   PrintNormRecord ("e", e, loops, n);
# endif
   
# line 663 "Dependences.puma"
   MakeDelta (e, loops, n, p, & yyV1, & yyV2, & yyV3, & yyV4);
# line 665 "Dependences.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 667 "Dependences.puma"

# ifdef DEBUG
     printf ("Delta Check okay, delta = %d, pos = %d, val = %d\n",
              yyV2, yyV3, yyV4);
# endif 
   
# line 674 "Dependences.puma"
   MakeNewPred (yyV2, yyV3, yyV4, flow, low, fup, up, p);
# line 676 "Dependences.puma"


# ifdef DEBUG
   strcpy (PVString,""); PVOut (PVString, p);
   printf ("Result of DeltaCheck, p = %s\n", PVString);
# endif
   
  }
  }
   return;
 }
yyL1:;

;
}

static void MakeDelta
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, pPredVector p, register bool * yyP13, register int * yyP12, register int * yyP11, register int * yyP10)
# else
(e, loops, n, p, yyP13, yyP12, yyP11, yyP10)
 ExpNormRecord e;
 ptree loops;
 register int n;
 pPredVector p;
 register bool * yyP13;
 register int * yyP12;
 register int * yyP11;
 register int * yyP10;
# endif
{
# line 694 "Dependences.puma"
 {
  bool okay;
  int delta;
  int pos;
  int val;
  {
# line 696 "Dependences.puma"

# line 697 "Dependences.puma"

# line 698 "Dependences.puma"

# line 699 "Dependences.puma"

# line 701 "Dependences.puma"
 int i, dim;
     bool found;
     int  eval, incval;
     int  p_low, p_up;

     dim    = PVGetDimension (p);

     

     okay  = true;
     delta = 0;
     pos   = 0;     

     for (i=1; i<=n; i++)

       { eval = e.vals[i];

         if ((eval != 0) && (i <= dim))

          { 

           PVGetComponent (p, i, &p_low, &p_up);

           if ((p_low != 0) || (p_up != 0))

             { 

               GetLoopIncrement (loops[i-1], &found, &incval);

               if ((!found) && (eval != 0))
                  okay = false;   

               eval *= incval;
             }

           if (p_low == p_up)

             {  

                delta += p_low * eval;
             }

           else
             { if (pos == 0)
                  { pos = i; val = eval; }
                else
                  okay = false; 
             }
         }
     } 

   
  }
   * yyP13 = okay;
   * yyP12 = delta;
   * yyP11 = pos;
   * yyP10 = val;
   return;
 }

;
}

static void MakeNewPred
# if defined __STDC__ | defined __cplusplus
(register int delta, register int pos, register int val, register bool flow, register int low, register bool fup, register int up, pPredVector p)
# else
(delta, pos, val, flow, low, fup, up, p)
 register int delta;
 register int pos;
 register int val;
 register bool flow;
 register int low;
 register bool fup;
 register int up;
 pPredVector p;
# endif
{
# line 767 "Dependences.puma"
  {
# line 769 "Dependences.puma"
   if (! ((pos == 0))) goto yyL1;
  {
# line 771 "Dependences.puma"
 
     if (fup)
        { if (delta + up < 0) PVSetFalse (p); }
     
     if (flow)
        { if (delta + low > 0) PVSetFalse (p); }
   
  }
  }
   return;
yyL1:;

# line 780 "Dependences.puma"
 {
  int p_low;
  int p_up;
  {
# line 782 "Dependences.puma"

# line 783 "Dependences.puma"

# line 785 "Dependences.puma"
   if (! ((val > 0))) goto yyL2;
  {
# line 789 "Dependences.puma"
 if (fup)
         p_low = (- up - delta) / val;
       else
         p_low = -MaxInt;

      if (flow)
         p_up  = (- low - delta) / val;
        else
         p_up  = MaxInt;

      PVAndComponent (p, pos, p_low, p_up);
      if (p_low != p_up) PVSetNotExact (p);
    
  }
  }
   return;
 }
yyL2:;

# line 804 "Dependences.puma"
 {
  int p_low;
  int p_up;
  {
# line 806 "Dependences.puma"

# line 807 "Dependences.puma"

# line 809 "Dependences.puma"
   if (! ((val < 0))) goto yyL3;
  {
# line 813 "Dependences.puma"
 if (fup)
         p_up = (- up - delta) / val;
       else
         p_up = MaxInt;

      if (flow)
         p_low  = (- low - delta) / val;
        else
         p_low  = -MaxInt;

      PVAndComponent (p, pos, p_low, p_up);
      if (p_low != p_up) PVSetNotExact (p);
    
  }
  }
   return;
 }
yyL3:;

;
}

void BeginDependences ()
{
}

void CloseDependences ()
{
}
