# include "DefTable.h"
# include "yyDefTable.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 49 "DefTable.puma"


# include <string.h>

# include "Idents.h"     
# include "StringMem.h"    /* GetString, ... */
# include "protocol.h"

static tScopes ScopeList;
static tScopes EmptyScopeList;        /* used for comparison */

static tEntries  UnitEntries;         /* tEntries form one Scope */
static tEntries  IntrinsicEntries;
static tEntries  ExternalEntries;
static tEntries  CommonEntries;

/* HPF_LIBRARY */

static tEntries  HPFLibEntries;
static tObject   HPFLibModule;

/* HPF_LOCAL_LIBRARY */

static tEntries  HPFLocalLibEntries;
static tObject   HPFLocalLibModule;

/* HPF_TASK_LIBRARY */

static tEntries  HPFTaskLibEntries;
static tObject   HPFTaskLibModule;

static tObject   DefaultTopologies [MAX_TORUS_RANK+2];

/* globally used for intrinsics */

static tEntries  LocalEntries;        /* local entries for intrinsics   */

static void DefTableError (msg)
char *msg;

{ fprintf (stderr, "SERIOUS ERROR in definition tables : %s\n", msg);
  kill_in_protocol ();

} /* DefTableError */

/**************************************************************************
*                                                                         *
*    Intrinsic Functions / Subroutines of FORTRAN                         *
*                                                                         *
**************************************************************************/

      /***********************************************************
      *                                                          *
      *  tObject MakeIntrProcObj (Name)                          *
      *                                                          *
      ***********************************************************/

static tObject MakeIntrProcObj (Name)

char * Name;

{ tIdent Id;
  tTree Decl;

  Id = MakeIdent (Name, strlen (Name));
  Decl = mINTRINSIC_DECL (Id, 0, DefaultId (), kSUBROUTINE, 0);
  return mProcObject (Id, Decl, Public, NoObject, 0, LocalEntries);

} /* MakeIntrProcObj */

      /***********************************************************
      *                                                          *
      *  tObject MakeIntrFuncObj (Name, GenName, class, kind)    *
      *                                                          *
      ***********************************************************/

static tObject MakeIntrFuncObj (Name, GenName, class, kind)

char * Name, * GenName;
int class;
int kind;

{ tIdent Id;
  tIdent GenId;    /* Generic Ident */
  tTree Decl;

  Id = MakeIdent (Name, strlen (Name));

  if (strlen (GenName) == 0)
     GenId = DefaultId ();
   else
     GenId = MakeIdent (GenName, strlen (GenName));

  Decl = mINTRINSIC_DECL (Id, 0, GenId, class, kind);

  return mFuncObject (Id, Decl, Public, NoObject, 0, LocalEntries);

} /* MakeIntrFuncObj */

      /***********************************************************
      *                                                          *
      *  tObject MakeIntrProcEntry (Name)                        *
      *                                                          *
      ***********************************************************/

static void MakeIntrProcEntry (Name)

char * Name;

{ IntrinsicEntries = mENTRY_LIST (MakeIntrProcObj (Name), 
                                  IntrinsicEntries);
} /* MakeIntrProcEntry */

      /***********************************************************
      *                                                          *
      *  tObject MakeIntrFuncEntry (Name, GenName, class, kind)  *
      *                                                          *
      ***********************************************************/

static void MakeIntrFuncEntry (Name, GenName, class, kind)

char * Name, * GenName;
int class;
int kind;

{ IntrinsicEntries = 

      mENTRY_LIST (MakeIntrFuncObj (Name, GenName, class, kind),
                   IntrinsicEntries);

} /* MakeIntrFuncEntry */

/**************************************************************************
*                                                                         *
*   HPF Library Functions / Subroutines                                   *
*                                                                         *
*   - currently handled like intrinsics (later via USE HPF_LIBRARY)       *
*   - or via USE HPF_LOCAL_LIBRARY                                        *
*                                                                         *
**************************************************************************/

static void MakeHPFLibProcEntry (Name)

char *Name;

{ HPFLibEntries = mENTRY_LIST (MakeIntrProcObj (Name), 
                               HPFLibEntries);

} /* MakeHPFLibProcEntry */

static void MakeHPFLibFuncEntry (Name, GenName, class, kind)

char * Name, * GenName;
int class;
int kind;

{ HPFLibEntries = mENTRY_LIST (MakeIntrFuncObj (Name, GenName, class, kind),
                               HPFLibEntries);

} /* MakeHPFLibFuncEntry */

static void MakeHPFLocalLibProcEntry (Name)

char *Name;

{ HPFLocalLibEntries = mENTRY_LIST (MakeIntrProcObj (Name), 
                                    HPFLocalLibEntries);

} /* MakeHPFLocalLibProcEntry */

static void MakeHPFLocalLibFuncEntry (Name, GenName, class, kind)

char * Name, * GenName;
int class;
int kind;

{ HPFLocalLibEntries = 

        mENTRY_LIST (MakeIntrFuncObj (Name, GenName, class, kind),
                     HPFLocalLibEntries);

} /* MakeHPFLocalLibFuncEntry */

static void MakeHPFTaskLibProcEntry (Name)

char *Name;

{ HPFTaskLibEntries = mENTRY_LIST (MakeIntrProcObj (Name), 
                                   HPFTaskLibEntries);

} /* MakeHPFTaskLibProcEntry */

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/

static void InitIntrinsicEntries ()

{ IntrinsicEntries  = mENTRY_EMPTY();   /* globally used for all entries */
  LocalEntries     = mENTRY_EMPTY();   /* globally used to save memory  */

    /****************************************
    *                                       *
    *  Conversional functions:              *
    *                                       *
    *  iabs    :  integer  ->   integer     *
    *  abs     :  real     ->   real        *
    *  dabs    :  double   ->   double      *
    *  cabs    :  complex  ->   real        *
    *  cdabs   :  dcomplex ->   double      *
    *                                       *
    *  aimag   :  complex  ->   real        *
    *  dimag   :  dcomplex ->   double      *
    *                                       *
    *  cmplx   :  <...>     ->  (d)complex  *
    *                                       *
    *  dble    :  <numeric> ->  double      *
    *                                       *
    *  dcmplx  :  <numeric> ->  dcomplex    *
    *                                       *
    *  dprod   :  real     ->   double      *
    *                                       *
    *  int     :  real     ->   integer     *
    *  ifix    :  real     ->   integer     *
    *  idint   :  double   ->   integer     *
    *                                       *
    *  nint    :  real     ->   integer     *
    *  idnint  :  double   ->   integer     *
    *                                       *
    *  real    :  integer  ->   real        *
    *  float   :  integer  ->   real        *
    *  sngl    :  double   ->   real        *
    *                                       *
    *  floor   :  real     ->   integer     *
    *  ceiling :  real     ->   integer     *
    *                                       *
    ****************************************/
 
    /****************************************
    *                                       *
    *  Numerical functions:                 *
    *                                       *
    *  aint   :   real      ->   real       *
    *  dint   :   double    ->   double     *
    *                                       *
    *  anint  :   real      ->   real       *
    *  dnint  :   double    ->   double     *
    *                                       *
    *  conjg  :   complex   ->   complex    *
    *  dconjg :   complex   ->   complex    *
    *                                       *
    *  idim   :   integer 2 ->   integer    *
    *  dim    :   real 2    ->   real       *
    *  ddim   :   double 2  ->   double     *
    *                                       *
    *  mod    :   integer 2  ->  integer    *
    *  amod   :   real 2     ->  real       *
    *  dmod   :   double 2   ->  double     *
    *                                       *
    *  isign  :   integer 2  ->  integer    *
    *  sign   :   real 2     ->  real       *
    *  dsign  :   double 2   ->  double     *
    *                                       *
    *  max    :   generic                   *
    *  max0   :   integer n  ->  integer    *
    *  amax1  :   real n     ->  real       *
    *  dmax1  :   double n   ->  double     *
    *  amax0  :   integer n  ->  real       *
    *  max1   :   real n     ->  real       *
    *                                       *
    *  min    :   generic                   *
    *  min0   :   integer n  ->  integer    *
    *  amin1  :   real n     ->  real       *
    *  dmin1  :   double n   ->  double     *
    *  amin0  :   integer n  ->  real       *
    *  min1   :   real n     ->  real       *
    *                                       *
    ****************************************/

  MakeIntrFuncEntry ("ABS", "ABS", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("IABS", "ABS", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("DABS", "ABS", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("CABS", "ABS", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("CDABS", "ABS", kELEMENTAL, kNUMERIC);  /* not std */

  MakeIntrFuncEntry ("AIMAG", "AIMAG", kELEMENTAL, kNUMERIC);  
  MakeIntrFuncEntry ("DIMAG", "AIMAG", kELEMENTAL, kNUMERIC);  /* not std */;

    /****************************************
    *                                       *
    *  Mathematical functions:              *
    *                                       *
    *  acos    :  real    ->   real         *
    *  dacos   :  double  ->   double       *
    *                                       *
    *  asin    :  real    ->   real         *
    *  dasin   :  double  ->   double       *
    *                                       *
    *  atan    :  real    ->   real         *
    *  datan   :  double  ->   double       *
    *                                       *
    *  atan2   :  real2   ->   real         *
    *  datan2  :  double2 ->   double       *
    *                                       *
    *  cos     :  real    ->   real         *
    *  dcos    :  double  ->   double       *
    *  ccos    :  complex ->   complex      *
    *  cdcos   :  dcomplex ->  dcomplex     *
    *                                       *
    *  cosh    :  real     ->  real         *
    *  dcosh   :  double   ->  double       *
    *                                       *
    *  exp     :  real    ->   real         *
    *  dexp    :  double  ->   double       *
    *  cexp    :  complex ->   complex      *
    *  cdexp   :  dcomplex ->  dcomplex     *
    *                                       *
    *  alog    :  real    ->   real         *
    *  dlog    :  double  ->   double       *
    *  clog    :  complex ->   complex      *
    *  cdlog   :  dcomplex ->  dcomplex     *
    *                                       *
    *  alog10  :  real   ->    real         *
    *  dlog10  :  double ->    double       *
    *                                       *
    *  sin     :  real    ->   real         *
    *  dsin    :  double  ->   double       *
    *  csin    :  complex ->   complex      *
    *  cdsin   :  dcomplex ->  dcomplex     *
    *                                       *
    *  sinh    :  real    ->   real         *
    *  dsinh   :  double  ->   double       *
    *                                       *
    *  sqrt    :  real    ->   real         *
    *  dsqrt   :  double  ->   double       *
    *  csqrt   :  complex ->   complex      *
    *  cdsqrt  :  dcomplex ->  dcomplex     *
    *                                       *
    *  tan     :  real    ->   real         *
    *  dtan    :  double  ->   double       *
    *                                       *
    *  tanh    :  real    ->   real         *
    *  dtanh   :  double  ->   double       *
    *                                       *
    ****************************************/

  MakeIntrFuncEntry ("ACOS", "ACOS", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DACOS", "ACOS", kELEMENTAL, kMATHEMATICAL); /* not std */

  MakeIntrFuncEntry ("COS", "COS", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DCOS", "COS", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CCOS", "COS", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CDCOS", "COS", kELEMENTAL, kMATHEMATICAL);

  MakeIntrFuncEntry ("COSH", "COSH", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DCOSH", "DCOSH", kELEMENTAL, kMATHEMATICAL);

  MakeIntrFuncEntry ("CMPLX", "CMPLX", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("DCMPLX", "CMPLX", kELEMENTAL, kNUMERIC);  /* not std */

  MakeIntrFuncEntry ("CONJG", "CONJG", kELEMENTAL, kNUMERIC);

  MakeIntrFuncEntry ("EXP", "EXP", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CEXP", "EXP", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DEXP", "EXP", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CDEXP", "EXP", kELEMENTAL, kMATHEMATICAL); /* not std */

  MakeIntrFuncEntry ("DBLE", "", kELEMENTAL, kNUMERIC);

  MakeIntrFuncEntry ("FLOAT", "REAL",  kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("REAL", "REAL", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("DREAL", "REAL", kELEMENTAL, kNUMERIC); /* not std */
  MakeIntrFuncEntry ("SNGL", "REAL", kELEMENTAL, kNUMERIC); /* not std */

  MakeIntrFuncEntry ("INT", "INT", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("IFIX", "INT", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("DINT", "INT", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("IDINT", "INT", kELEMENTAL, kNUMERIC);

  MakeIntrFuncEntry ("AINT", "AINT", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("NINT", "NINT", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("ANINT", "ANINT", kELEMENTAL, kNUMERIC);

  MakeIntrFuncEntry ("DIM", "DIM", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("DDIM", "DIM", kELEMENTAL, kNUMERIC);   

  MakeIntrFuncEntry ("LOG", "LOG", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("ALOG", "LOG", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CLOG", "LOG", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DLOG", "LOG", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CDLOG", "LOG", kELEMENTAL, kMATHEMATICAL); /* not std */

  MakeIntrFuncEntry ("LOG10", "LOG10", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("ALOG10", "LOG10", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DLOG10", "LOG10", kELEMENTAL, kMATHEMATICAL);

  /* note : MAX1 is INT (MAX (...)), AMAX0 is REAL (MAX (...)) */

  MakeIntrFuncEntry ("MAX", "", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("MAX0", "MAX", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("MAX1", "MAX", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("AMAX0", "MAX", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("AMAX1", "MAX", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("DMAX1", "MAX", kELEMENTAL, kNUMERIC);

  /* note : MIN1 is INT (MIN (...)), AMIN0 is REAL (MIN (...)) */

  MakeIntrFuncEntry ("MIN", "", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("MIN0", "MIN", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("MIN1", "MIN", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("AMIN0", "MIN", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("AMIN1", "MIN", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("DMIN1", "MIN", kELEMENTAL, kNUMERIC);

  MakeIntrFuncEntry ("MOD", "MOD", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("DMOD", "MOD", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("AMOD", "MOD", kELEMENTAL, kNUMERIC);

  MakeIntrFuncEntry ("MODULO", "", kELEMENTAL, kNUMERIC);

  MakeIntrFuncEntry ("SIGN", "SIGN", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("ISIGN", "SIGN", kELEMENTAL, kNUMERIC);
  MakeIntrFuncEntry ("DSIGN", "SIGN", kELEMENTAL, kNUMERIC);

  MakeIntrFuncEntry ("SIN", "SIN", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DSIN", "SIN", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CSIN", "SIN", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CDSIN", "SIN", kELEMENTAL, kMATHEMATICAL);

  MakeIntrFuncEntry ("ASIN", "ASIN", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DASIN", "ASIN", kELEMENTAL, kMATHEMATICAL);

  MakeIntrFuncEntry ("SINH", "SINH", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DSINH", "DSINH", kELEMENTAL, kMATHEMATICAL);

  MakeIntrFuncEntry ("SQRT", "SQRT", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DSQRT", "SQRT", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("CSQRT", "SQRT", kELEMENTAL, kMATHEMATICAL);

  MakeIntrFuncEntry ("TAN", "TAN", kELEMENTAL, kMATHEMATICAL);    
  MakeIntrFuncEntry ("DTAN", "DTAN", kELEMENTAL, kMATHEMATICAL);    

  MakeIntrFuncEntry ("TANH", "TANH", kELEMENTAL, kMATHEMATICAL);
  MakeIntrFuncEntry ("DTANH", "DTANH", kELEMENTAL, kMATHEMATICAL);

  MakeIntrFuncEntry ("ATAN", "ATAN", kELEMENTAL, kMATHEMATICAL);    
  MakeIntrFuncEntry ("DATAN", "ATAN", kELEMENTAL, kMATHEMATICAL);  

  MakeIntrFuncEntry ("ATAN2", "ATAN2", kELEMENTAL, kMATHEMATICAL);   
  MakeIntrFuncEntry ("DATAN2", "ATAN2", kELEMENTAL, kMATHEMATICAL); 

  /* F90 numeric fungins */

  MakeIntrFuncEntry ("FLOOR", "", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("CEILING", "", kELEMENTAL, kNUMERIC); 
  MakeIntrFuncEntry ("DPROD", "DPROC", kELEMENTAL, kNUMERIC); 

  /* char intrinsics */

  MakeIntrFuncEntry ("ICHAR", "ICHAR", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("CHAR", "CHAR", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("IACHAR", "", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("ACHAR", "", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("LEN", "", kELEMENTAL, kCHARACTER);

  MakeIntrFuncEntry ("INDEX", "", kELEMENTAL, kCHARACTER);

  MakeIntrFuncEntry ("LGT", "LGT", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("LGE", "LGE", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("LLT", "LLT", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("LLE", "LLE", kELEMENTAL, kCHARACTER);

  MakeIntrFuncEntry ("LEN_TRIM", "", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("SCAN", "", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("ADJUSTL", "", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("ADJUSTR", "", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("VERIFY", "", kELEMENTAL, kCHARACTER);

  MakeIntrFuncEntry ("REPEAT", "", kELEMENTAL, kCHARACTER);
  MakeIntrFuncEntry ("TRIM", "", kELEMENTAL, kCHARACTER);

  /* kind functions */

  MakeIntrFuncEntry ("KIND", "", kELEMENTAL, kKIND);
  MakeIntrFuncEntry ("SELECTED_INT_KIND", "", kELEMENTAL, kKIND);
  MakeIntrFuncEntry ("SELECTED_REAL_KIND", "", kELEMENTAL, kKIND);
  
  /* bit manipulation functions */

  MakeIntrFuncEntry ("IBSET", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("IBITS", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("IBCLR", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("IAND", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("IOR", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("IEOR", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("NOT", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("ISHFT", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("ISHFTC", "", kELEMENTAL, kBIT);
  MakeIntrFuncEntry ("BTEST", "", kELEMENTAL, kBIT);

  /* numeric inquiry functions */

  MakeIntrFuncEntry ("DIGITS", "", kINQUIRY, kFLOATING);
  MakeIntrFuncEntry ("EPSILON", "", kINQUIRY, kFLOATING);
  MakeIntrFuncEntry ("HUGE", "", kINQUIRY, kFLOATING);
  MakeIntrFuncEntry ("MAXEXPONENT", "", kINQUIRY, kFLOATING);
  MakeIntrFuncEntry ("MINEXPONENT", "", kINQUIRY, kFLOATING);
  MakeIntrFuncEntry ("PRECISION", "", kINQUIRY, kFLOATING);
  MakeIntrFuncEntry ("RADIX", "", kINQUIRY, kFLOATING);
  MakeIntrFuncEntry ("RANGE", "", kINQUIRY, kFLOATING);
  MakeIntrFuncEntry ("TINY", "", kINQUIRY, kFLOATING);

  /* floating-point manipulation functions */

  MakeIntrFuncEntry ("EXPONENT", "", kELEMENTAL, kFLOATING);
  MakeIntrFuncEntry ("FRACTION", "", kELEMENTAL, kFLOATING);
  MakeIntrFuncEntry ("NEAREST", "", kELEMENTAL, kFLOATING);
  MakeIntrFuncEntry ("RRSPACING", "", kELEMENTAL, kFLOATING);
  MakeIntrFuncEntry ("SCALE", "", kELEMENTAL, kFLOATING);
  MakeIntrFuncEntry ("SET_EXPONENT", "", kELEMENTAL, kFLOATING);
  MakeIntrFuncEntry ("SPACING", "", kELEMENTAL, kFLOATING);

  /* transfer function */

  MakeIntrFuncEntry ("TRANSFER", "", kTRANSFORMATIONAL, kTRANSFER);

  /* array inquiry functions */

  MakeIntrFuncEntry ("SIZE", "", kINQUIRY, 0);
  MakeIntrFuncEntry ("SHAPE", "", kINQUIRY, 0);
  MakeIntrFuncEntry ("UBOUND", "", kINQUIRY, 0);
  MakeIntrFuncEntry ("LBOUND", "", kINQUIRY, 0);

  MakeIntrFuncEntry ("ALLOCATED", "", kINQUIRY, 0);
  MakeIntrFuncEntry ("ASSOCIATED", "", kINQUIRY, 0);

  /* optional arguments */

  MakeIntrFuncEntry ("PRESENT", "", kINQUIRY, 0);

  /* array intrinsics */

  MakeIntrFuncEntry ("SPREAD", "", kTRANSFORMATIONAL, kCONSTRUCTION);
  MakeIntrFuncEntry ("PACK", "", kTRANSFORMATIONAL, kCONSTRUCTION);
  MakeIntrFuncEntry ("UNPACK", "", kTRANSFORMATIONAL, kCONSTRUCTION);

  MakeIntrFuncEntry ("ALL", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("ANY", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("COUNT", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("MAXVAL", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("MINVAL", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("SUM", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("PRODUCT", "", kTRANSFORMATIONAL, kREDUCTION);

  MakeIntrFuncEntry ("DOT_PRODUCT", "", kTRANSFORMATIONAL, kMULTIPLY);

  MakeIntrFuncEntry ("MATMUL", "", kTRANSFORMATIONAL, kMULTIPLY);

  /* HPF intrinsic functions */

  MakeIntrFuncEntry ("IALL", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("IANY", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("IPARITY", "", kTRANSFORMATIONAL, kREDUCTION);
  MakeIntrFuncEntry ("PARITY", "", kTRANSFORMATIONAL, kREDUCTION);

  /* array manipulation */

  MakeIntrFuncEntry ("TRANSPOSE", "", kTRANSFORMATIONAL, kMANIPULATION);
  MakeIntrFuncEntry ("EOSHIFT", "", kTRANSFORMATIONAL, kMANIPULATION);
  MakeIntrFuncEntry ("CSHIFT", "", kTRANSFORMATIONAL, kMANIPULATION);

  MakeIntrFuncEntry ("MINLOC", "", kTRANSFORMATIONAL, kLOCREDUCTION);
  MakeIntrFuncEntry ("MAXLOC", "", kTRANSFORMATIONAL, kLOCREDUCTION);

  MakeIntrFuncEntry ("RESHAPE", "", kTRANSFORMATIONAL, kCONSTRUCTION);
  MakeIntrFuncEntry ("MERGE", "", kELEMENTAL, kCONSTRUCTION);

  /* F90 intrinsic subroutines */

  MakeIntrProcEntry ("DATE_AND_TIME");
  MakeIntrProcEntry ("MVBITS");
  MakeIntrProcEntry ("RANDOM_NUMBER");
  MakeIntrProcEntry ("RANDOM_SEED");
  MakeIntrProcEntry ("SYSTEM_CLOCK");
  MakeIntrProcEntry ("CPU_TIME");

  /* HPF intrinsics */

  MakeIntrFuncEntry ("ILEN", "", kELEMENTAL, 0);
  MakeIntrFuncEntry ("NUMBER_OF_PROCESSORS", "", kINQUIRY, 0);
  MakeIntrFuncEntry ("PROCESSORS_SHAPE", "", kINQUIRY, 0);

  /* HPF intrinsics, approved extensions */

  MakeIntrFuncEntry ("ACTIVE_NUM_PROCS", "", kINQUIRY, 0);
  MakeIntrFuncEntry ("ACTIVE_PROCS_SHAPE", "", kINQUIRY, 0);

  /* HPF Library */

  MakeHPFLibProcEntry ("HPF_ALIGNMENT");
  MakeHPFLibProcEntry ("HPF_TEMPLATE");
  MakeHPFLibProcEntry ("HPF_DISTRIBUTION");
  MakeHPFLibProcEntry ("HPF_NUMBER_MAPPED");
  MakeHPFLibProcEntry ("HPF_MAP_ARRAY");

  /* new subgrid-inquiry routine */

  MakeHPFLibProcEntry ("HPF_SUBGRID_INFO");

  /* HPF bit manipulation functions */

  MakeHPFLibFuncEntry ("LEADZ", "", kELEMENTAL, 0);
  MakeHPFLibFuncEntry ("POPCNT", "", kELEMENTAL, 0);
  MakeHPFLibFuncEntry ("POPPAR", "", kELEMENTAL, 0);

  /* ..._SCATTER (array, base, idx1, ..., idxn [,mask]), rank (base) = n */

  MakeHPFLibFuncEntry ("ALL_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("ANY_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("COPY_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("COUNT_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("IALL_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("IANY_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("IPARITY_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("MINVAL_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("MAXVAL_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("PARITY_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("SUM_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);
  MakeHPFLibFuncEntry ("PRODUCT_SCATTER", "", kTRANSFORMATIONAL, kSCATTER);

  /* ..._PREFIX (array [,dim] [,mask] [,segment] [,exclusive]  */

  MakeHPFLibFuncEntry ("ALL_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("ANY_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("COPY_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("COUNT_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("IALL_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("IANY_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("IPARITY_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("MINVAL_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("MAXVAL_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("PARITY_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("PRODUCT_PREFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("SUM_PREFIX", "", kTRANSFORMATIONAL, kSCAN);

  /* ..._SUFFIX (array [,dim] [,mask] [,segment] [,exclusive]  */

  MakeHPFLibFuncEntry ("ALL_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("ANY_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("COPY_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("COUNT_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("IALL_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("IANY_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("IPARITY_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("MINVAL_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("MAXVAL_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("PARITY_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("PRODUCT_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);
  MakeHPFLibFuncEntry ("SUM_SUFFIX", "", kTRANSFORMATIONAL, kSCAN);

  MakeHPFLibFuncEntry ("GRADE_DOWN", "", kTRANSFORMATIONAL, kGRADE);
  MakeHPFLibFuncEntry ("GRADE_UP", "", kTRANSFORMATIONAL, kGRADE);

  MakeHPFLibFuncEntry ("SORT_DOWN", "", kTRANSFORMATIONAL, kSORT);
  MakeHPFLibFuncEntry ("SORT_UP", "", kTRANSFORMATIONAL, kSORT);

  /* USE HPF_LOCAL_LIBRARY */

  MakeHPFLocalLibProcEntry ("GLOBAL_ALIGNMENT");
  MakeHPFLocalLibProcEntry ("GLOBAL_DISTRIBUTION");
  MakeHPFLocalLibProcEntry ("GLOBAL_TEMPLATE");

  MakeHPFLocalLibProcEntry ("ABSTRACT_TO_PHYSICAL");
  MakeHPFLocalLibProcEntry ("PHYSICAL_TO_ABSTRACT");

  MakeHPFLocalLibProcEntry ("GLOBAL_TO_LOCAL");
  MakeHPFLocalLibProcEntry ("LOCAL_TO_GLOBAL");

  MakeHPFLocalLibFuncEntry ("GLOBAL_SIZE", "", kINQUIRY, 0);
  MakeHPFLocalLibFuncEntry ("GLOBAL_SHAPE", "", kINQUIRY, 0);

  MakeHPFLocalLibFuncEntry ("MY_PROCESSOR", "", kINQUIRY, 0);

  MakeHPFLocalLibFuncEntry ("LOCAL_BLKCNT", "", kPURE, 0);
  MakeHPFLocalLibFuncEntry ("LOCAL_LINDEX", "", kPURE, 0);
  MakeHPFLocalLibFuncEntry ("LOCAL_UINDEX", "", kPURE, 0);

  /* USE HPF_TASK_LIBRARY */

  MakeHPFTaskLibProcEntry ("HPF_TASK_INIT");
  MakeHPFTaskLibProcEntry ("HPF_TASK_EXIT");
  MakeHPFTaskLibProcEntry ("HPF_TASK_RANK");
  MakeHPFTaskLibProcEntry ("HPF_TASK_SIZE");
  MakeHPFTaskLibProcEntry ("HPF_SEND");
  MakeHPFTaskLibProcEntry ("HPF_RECV");
  MakeHPFTaskLibProcEntry ("HPF_SEND_INIT");
  MakeHPFTaskLibProcEntry ("HPF_RECV_INIT");
  MakeHPFTaskLibProcEntry ("HPF_TASK_COMM");

} /* InitIntrinsicEntries */



static void yyExit () { Exit (1); }

void (* DefTable_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module DefTable, routine %s failed\n", yyFunction);
 DefTable_Exit ();
}

static tDefinitions GetFirstScope ARGS((tDefinitions s));
static tDefinitions GetTailScopes ARGS((tDefinitions s));
void NewScope ARGS(());
void OpenScope ARGS((tDefinitions Scope));
void CloseScope ARGS(());
tDefinitions GetCurrentScope ARGS(());
tDefinitions GetExternalEntries ARGS(());
tDefinitions GetIntrinsicEntries ARGS(());
tDefinitions GetUnitEntries ARGS(());
tDefinitions GetCommonEntries ARGS(());
tDefinitions GetHPFLibrary ARGS(());
tDefinitions GetHPFLocalLibrary ARGS(());
tDefinitions GetHPFTaskLibrary ARGS(());
void InsertUnitEntry ARGS((tDefinitions Obj));
void InsertExternalEntry ARGS((tDefinitions Obj));
void InsertCommonEntry ARGS((tDefinitions Obj));
static void InsertEntryScopes ARGS((tDefinitions Obj, tDefinitions sl));
void InsertEntry ARGS((tDefinitions Obj));
static void ReplaceEntry ARGS((tIdent Name, tDefinitions New, tDefinitions scope));
void ChangeEntry ARGS((tIdent Name, tDefinitions Obj));
tDefinitions GetDeclEntry ARGS((tIdent Ident, tDefinitions Decls));
static tDefinitions GetDecl ARGS((tIdent Ident, tDefinitions sl));
tDefinitions GetLocalObject ARGS((tIdent Ident));
tDefinitions GetGlobalObject ARGS((tIdent Ident));
tDefinitions GetIntrinsicObject ARGS((tIdent Ident));
tDefinitions GetDefaultTopology ARGS((int rank));
tDefinitions RemoveHostAssociation ARGS(());
void ResetHostAssociation ARGS((tDefinitions HostAssociation));

static tDefinitions GetFirstScope
# if defined __STDC__ | defined __cplusplus
(register tDefinitions s)
# else
(s)
 register tDefinitions s;
# endif
{
# line 804 "DefTable.puma"
  {
# line 805 "DefTable.puma"
   if (! ((s == NoDefinitions))) goto yyL1;
  {
# line 806 "DefTable.puma"
   DefTableError ("GetFirstScope (NULL)");
  }
  }
   return NoEntries;
yyL1:;

  if (s->Kind == kSCOPE_EMPTY) {
# line 810 "DefTable.puma"
  {
# line 812 "DefTable.puma"
   DefTableError ("GetFirstScope (no scopes)");
  }
   return NoEntries;

  }
  if (s->Kind == kSCOPE_LIST) {
# line 816 "DefTable.puma"
   return s->SCOPE_LIST.Table;

  }
 yyAbort ("GetFirstScope");
}

static tDefinitions GetTailScopes
# if defined __STDC__ | defined __cplusplus
(register tDefinitions s)
# else
(s)
 register tDefinitions s;
# endif
{
# line 823 "DefTable.puma"
  {
# line 824 "DefTable.puma"
   if (! ((s == NoDefinitions))) goto yyL1;
  {
# line 825 "DefTable.puma"
   DefTableError ("GetTailScopes (NULL)");
  }
  }
   return NoDefinitions;
yyL1:;

  if (s->Kind == kSCOPE_EMPTY) {
# line 829 "DefTable.puma"
  {
# line 831 "DefTable.puma"
   DefTableError ("GetTailScopes (no scopes)");
  }
   return NoDefinitions;

  }
  if (s->Kind == kSCOPE_LIST) {
# line 835 "DefTable.puma"
   return s->SCOPE_LIST.Hidden;

  }
 yyAbort ("GetTailScopes");
}

void NewScope
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 848 "DefTable.puma"
  {
# line 850 "DefTable.puma"
   ScopeList = mSCOPE_LIST (mENTRY_EMPTY (), ScopeList);
  }
   return;

;
}

void OpenScope
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Scope)
# else
(Scope)
 register tDefinitions Scope;
# endif
{
# line 855 "DefTable.puma"
  {
# line 856 "DefTable.puma"
   if (! ((Scope == NoDefinitions))) goto yyL1;
  {
# line 858 "DefTable.puma"
   DefTableError ("OpenScope: illegal structure");
  }
  }
   return;
yyL1:;

  if (Scope->Kind == kENTRY_LIST) {
# line 861 "DefTable.puma"
  {
# line 863 "DefTable.puma"
   ScopeList = mSCOPE_LIST (Scope, ScopeList);
  }
   return;

  }
  if (Scope->Kind == kENTRY_EMPTY) {
# line 866 "DefTable.puma"
  {
# line 868 "DefTable.puma"
   ScopeList = mSCOPE_LIST (Scope, ScopeList);
  }
   return;

  }
# line 871 "DefTable.puma"
  {
# line 872 "DefTable.puma"
   DefTableError ("OpenScope: illegal structure");
  }
   return;

;
}

void CloseScope
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 877 "DefTable.puma"
  {
# line 878 "DefTable.puma"
   ScopeList = GetTailScopes (ScopeList);
  }
   return;

;
}

tDefinitions GetCurrentScope
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 883 "DefTable.puma"
  {
# line 884 "DefTable.puma"
   if (! ((ScopeList == EmptyScopeList))) goto yyL1;
  }
   return UnitEntries;
yyL1:;

# line 889 "DefTable.puma"
   return GetFirstScope (ScopeList);

}

tDefinitions GetExternalEntries
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 896 "DefTable.puma"
   return ExternalEntries;

}

tDefinitions GetIntrinsicEntries
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 902 "DefTable.puma"
   return IntrinsicEntries;

}

tDefinitions GetUnitEntries
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 908 "DefTable.puma"
   return UnitEntries;

}

tDefinitions GetCommonEntries
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 914 "DefTable.puma"
   return CommonEntries;

}

tDefinitions GetHPFLibrary
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 920 "DefTable.puma"
   return HPFLibModule;

}

tDefinitions GetHPFLocalLibrary
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 926 "DefTable.puma"
   return HPFLocalLibModule;

}

tDefinitions GetHPFTaskLibrary
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 932 "DefTable.puma"
   return HPFTaskLibModule;

}

void InsertUnitEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
# line 944 "DefTable.puma"
  {
# line 946 "DefTable.puma"
   UnitEntries = mENTRY_LIST (Obj, UnitEntries);
  }
   return;

;
}

void InsertExternalEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
# line 951 "DefTable.puma"
  {
# line 953 "DefTable.puma"
   ExternalEntries = mENTRY_LIST (Obj, ExternalEntries);
  }
   return;

;
}

void InsertCommonEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
# line 958 "DefTable.puma"
  {
# line 960 "DefTable.puma"
   CommonEntries = mENTRY_LIST (Obj, CommonEntries);
  }
   return;

;
}

static void InsertEntryScopes
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj, register tDefinitions sl)
# else
(Obj, sl)
 register tDefinitions Obj;
 register tDefinitions sl;
# endif
{
  if (sl->Kind == kSCOPE_LIST) {
# line 965 "DefTable.puma"
  {
# line 967 "DefTable.puma"
   sl->SCOPE_LIST.Table = mENTRY_LIST (Obj, sl->SCOPE_LIST.Table);
  }
   return;

  }
;
}

void InsertEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
# line 972 "DefTable.puma"
  {
# line 974 "DefTable.puma"
   if (! ((ScopeList == EmptyScopeList))) goto yyL1;
  {
# line 976 "DefTable.puma"
   InsertUnitEntry (Obj);
  }
  }
   return;
yyL1:;

# line 979 "DefTable.puma"
  {
# line 981 "DefTable.puma"
   InsertEntryScopes (Obj, ScopeList);
  }
   return;

;
}

static void ReplaceEntry
# if defined __STDC__ | defined __cplusplus
(register tIdent Name, register tDefinitions New, register tDefinitions scope)
# else
(Name, New, scope)
 register tIdent Name;
 register tDefinitions New;
 register tDefinitions scope;
# endif
{
# line 992 "DefTable.puma"
  {
# line 994 "DefTable.puma"
   if (! ((scope == NoEntries))) goto yyL1;
  {
# line 996 "DefTable.puma"
   DefTableError ("ReplaceEntry: NULL");
  }
  }
   return;
yyL1:;

  if (scope->Kind == kENTRY_LIST) {
# line 999 "DefTable.puma"
  {
# line 1001 "DefTable.puma"
   if (! ((scope->ENTRY_LIST.Elem->Object.Ident == Name))) goto yyL2;
  {
# line 1003 "DefTable.puma"
   scope->ENTRY_LIST.Elem = New;
  }
  }
   return;
yyL2:;

# line 1006 "DefTable.puma"
  {
# line 1008 "DefTable.puma"
   ReplaceEntry (Name, New, scope->ENTRY_LIST.Next);
  }
   return;

  }
  if (scope->Kind == kENTRY_EMPTY) {
# line 1011 "DefTable.puma"
  {
# line 1013 "DefTable.puma"
   DefTableError ("ReplaceEntry: old entry not found");
  }
   return;

  }
# line 1016 "DefTable.puma"
  {
# line 1018 "DefTable.puma"
   DefTableError ("ReplaceEntry: illegal structure");
  }
   return;

;
}

void ChangeEntry
# if defined __STDC__ | defined __cplusplus
(register tIdent Name, register tDefinitions Obj)
# else
(Name, Obj)
 register tIdent Name;
 register tDefinitions Obj;
# endif
{
# line 1023 "DefTable.puma"
  {
# line 1025 "DefTable.puma"
   ReplaceEntry (Name, Obj, GetFirstScope (ScopeList));
  }
   return;

;
}

tDefinitions GetDeclEntry
# if defined __STDC__ | defined __cplusplus
(register tIdent Ident, register tDefinitions Decls)
# else
(Ident, Decls)
 register tIdent Ident;
 register tDefinitions Decls;
# endif
{
# line 1038 "DefTable.puma"
  {
# line 1040 "DefTable.puma"
   if (! ((Decls == NoEntries))) goto yyL1;
  {
# line 1042 "DefTable.puma"
   DefTableError ("GetDeclEntry (NULL)");
  }
  }
   return NoObject;
yyL1:;

  if (Decls->Kind == kENTRY_EMPTY) {
# line 1046 "DefTable.puma"
   return NoObject;

  }
  if (Decls->Kind == kENTRY_LIST) {
# line 1051 "DefTable.puma"
  {
# line 1053 "DefTable.puma"
   if (! ((Ident == Decls->ENTRY_LIST.Elem->Object.Ident))) goto yyL3;
  }
   return Decls->ENTRY_LIST.Elem;
yyL3:;

# line 1058 "DefTable.puma"
   return GetDeclEntry (Ident, Decls->ENTRY_LIST.Next);

  }
# line 1063 "DefTable.puma"
  {
# line 1065 "DefTable.puma"
 char name[MAXID_LENGTH];
     GetString (Ident, name);
     printf ("internal error for definition table when finding %s\n", name);
     printf ("Decls has kind = %d\n", Decls->Kind);
     DefTableError ("GetDeclEntry (illegal entries)");
   
  }
   return NoObject;

}

static tDefinitions GetDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent Ident, register tDefinitions sl)
# else
(Ident, sl)
 register tIdent Ident;
 register tDefinitions sl;
# endif
{
  if (sl->Kind == kSCOPE_LIST) {
# line 1083 "DefTable.puma"
 {
  tDefinitions obj;
  {
# line 1085 "DefTable.puma"

# line 1087 "DefTable.puma"
   obj = GetDeclEntry (Ident, sl->SCOPE_LIST.Table);
# line 1089 "DefTable.puma"
   if (! ((obj != NoObject))) goto yyL1;
  }
  {
   return obj;
  }
 }
yyL1:;

# line 1094 "DefTable.puma"
   return GetDecl (Ident, sl->SCOPE_LIST.Hidden);

  }
  if (sl->Kind == kSCOPE_EMPTY) {
# line 1099 "DefTable.puma"
   return NoObject;

  }
# line 1104 "DefTable.puma"
  {
# line 1106 "DefTable.puma"
   DefTableError ("GetDecl (illegal scope list)");
  }
   return NoObject;

}

tDefinitions GetLocalObject
# if defined __STDC__ | defined __cplusplus
(register tIdent Ident)
# else
(Ident)
 register tIdent Ident;
# endif
{
# line 1120 "DefTable.puma"
   return GetDeclEntry (Ident, GetFirstScope (ScopeList));

}

tDefinitions GetGlobalObject
# if defined __STDC__ | defined __cplusplus
(register tIdent Ident)
# else
(Ident)
 register tIdent Ident;
# endif
{
# line 1126 "DefTable.puma"
   return GetDecl (Ident, ScopeList);

}

tDefinitions GetIntrinsicObject
# if defined __STDC__ | defined __cplusplus
(register tIdent Ident)
# else
(Ident)
 register tIdent Ident;
# endif
{
# line 1132 "DefTable.puma"
 {
  tDefinitions Obj;
  {
# line 1134 "DefTable.puma"

# line 1136 "DefTable.puma"
 Obj = GetDeclEntry (Ident, IntrinsicEntries);
     if (Obj == NoObject)
        Obj = GetDeclEntry (Ident, HPFLibEntries);
     if (Obj == NoObject)
        Obj = GetDeclEntry (Ident, HPFLocalLibEntries);
   
  }
  {
   return Obj;
  }
 }

}

tDefinitions GetDefaultTopology
# if defined __STDC__ | defined __cplusplus
(register int rank)
# else
(rank)
 register int rank;
# endif
{
# line 1148 "DefTable.puma"
  {
# line 1149 "DefTable.puma"
   if (! (((rank < - 1) || (rank > MAX_TORUS_RANK)))) goto yyL1;
  }
   return NoObject;
yyL1:;

# line 1153 "DefTable.puma"
   return DefaultTopologies [rank + 1];

}

tDefinitions RemoveHostAssociation
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 1165 "DefTable.puma"
 {
  tDefinitions sl;
  {
# line 1166 "DefTable.puma"

# line 1168 "DefTable.puma"
 sl = ScopeList;
      ScopeList = EmptyScopeList;
    
  }
  {
   return sl;
  }
 }

}

void ResetHostAssociation
# if defined __STDC__ | defined __cplusplus
(register tDefinitions HostAssociation)
# else
(HostAssociation)
 register tDefinitions HostAssociation;
# endif
{
# line 1177 "DefTable.puma"
  {
# line 1178 "DefTable.puma"
   ScopeList = HostAssociation;
  }
   return;

;
}

void BeginDefTable ()
{
# line 753 "DefTable.puma"


  UnitEntries        = mENTRY_EMPTY();
  HPFLibEntries      = mENTRY_EMPTY();
  HPFLocalLibEntries = mENTRY_EMPTY();
  HPFTaskLibEntries  = mENTRY_EMPTY();

  InitIntrinsicEntries ();

  ExternalEntries  = mENTRY_EMPTY();
  CommonEntries    = mENTRY_EMPTY();

  ScopeList = mSCOPE_EMPTY ();
  EmptyScopeList = ScopeList;    /* used for comparisons */

  { int i;
    for (i=-1; i<=MAX_TORUS_RANK; i++)
     DefaultTopologies[i+1] =
      mTopologyObject (DefaultId(), NoTree, Public, NoObject, i, NoTree, 0, 0);
  }

  HPFLibModule = mModuleObject (IsIdent ("HPF_LIBRARY"),
                                NoTree, Public, NoObject,
                                0, HPFLibEntries);

  HPFLocalLibModule = mModuleObject (IsIdent ("HPF_LOCAL_LIBRARY"),
                                     NoTree, Public, NoObject,
                                     0, HPFLocalLibEntries);

  HPFTaskLibModule = mModuleObject (IsIdent ("HPF_TASK_LIBRARY"),
                                     NoTree, Public, NoObject,
                                     0, HPFTaskLibEntries);


}

void CloseDefTable ()
{
# line 788 "DefTable.puma"


if (ScopeList != EmptyScopeList)
   { fprintf (stderr, "scopes not properly closed\n");
     kill_in_protocol ();
   }


}
