# include "Dalib.h"
# include "yyDalib.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 54 "Dalib.puma"


# include <stdio.h>
# include <string.h>

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Expressions.h"   /* MakeSliceExp */
# include "Types.h"         /* ArrayFormals */
# include "Transform.h"     /* ExpToVarParam */

# include "CodeGeneral.h"  

# define  MODULE "Dalib"

tTree NewHelpVars;         /* exported to CodeGeneral */



static void yyExit () { Exit (1); }

void (* Dalib_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Dalib, routine %s failed\n", yyFunction);
 Dalib_Exit ();
}

tIdent MakeDalibId ARGS((String name));
tIdent MakeDalibCId ARGS((String name, bool is_char));
tIdent MakeDalibId1 ARGS((String name, int n));
static tTree FormalSizeParameter ARGS((tTree t));
tTree MakeSizeExp ARGS((tTree t));
tTree MakeElemsExp ARGS((tTree t));
static tTree MakeIndexSizeExp ARGS((tTree t));
tTree DalibFormalSize ARGS((tTree t));
tTree DalibGlobalToLocal ARGS((tIdent id, int dim, tTree exp));

tIdent MakeDalibId
# if defined __STDC__ | defined __cplusplus
(String name)
# else
(name)
 String name;
# endif
{
# line 84 "Dalib.puma"

char s [100];

# line 88 "Dalib.puma"
  {
# line 90 "Dalib.puma"
 sprintf (s, "DALIB_%s", name); 
  }
   return MakeIdent (s, strlen (s));

}

tIdent MakeDalibCId
# if defined __STDC__ | defined __cplusplus
(String name, register bool is_char)
# else
(name, is_char)
 String name;
 register bool is_char;
# endif
{
# line 97 "Dalib.puma"

char s [100];

# line 101 "Dalib.puma"
  {
# line 103 "Dalib.puma"
   if (! ((is_char))) goto yyL1;
  {
# line 105 "Dalib.puma"
 sprintf (s, "DALIB_c%s", name); 
  }
  }
   return MakeIdent (s, strlen (s));
yyL1:;

# line 110 "Dalib.puma"
  {
# line 112 "Dalib.puma"
 sprintf (s, "DALIB_%s", name); 
  }
   return MakeIdent (s, strlen (s));

}

tIdent MakeDalibId1
# if defined __STDC__ | defined __cplusplus
(String name, register int n)
# else
(name, n)
 String name;
 register int n;
# endif
{
# line 119 "Dalib.puma"

char s [100];

# line 123 "Dalib.puma"
  {
# line 124 "Dalib.puma"
 sprintf (s, "DALIB_%s%d", name, n);
  
  }
   return MakeIdent (s, strlen (s));

}

static tTree FormalSizeParameter
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kEXPLICIT_SHAPE) {
# line 137 "Dalib.puma"
   return ExpToVarParam (MakeSliceExp (t->EXPLICIT_SHAPE.LOWER, t->EXPLICIT_SHAPE.UPPER));

  }
# line 141 "Dalib.puma"
  {
# line 142 "Dalib.puma"
   failure_protocol (MODULE, "FormalSizeParameter (no explicit shape)", t);
  }
   return NoTree;

}

tTree MakeSizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 162 "Dalib.puma"

tTree size_exp, index_exp;

  if (t->Kind == kLOOP_VAR) {
# line 166 "Dalib.puma"
   return MakeConstant (TreeSize (t));

  }
  if (t->Kind == kUSED_VAR) {
# line 171 "Dalib.puma"
   return MakeConstant (TreeSize (t));

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 176 "Dalib.puma"
  {
# line 177 "Dalib.puma"
 size_exp = MakeConstant (TreeSize (t));
     index_exp = MakeIndexSizeExp (t->INDEXED_VAR.IND_EXPS);
     if (index_exp != NoTree)
       size_exp = mOP_EXP (mOP_TIMES (), index_exp, size_exp);
   
  }
   return size_exp;

  }
  }
# line 185 "Dalib.puma"
  {
# line 186 "Dalib.puma"
   failure_protocol ("Dalib", "MakeSizeExp", t);
  }
   return NoTree;

}

tTree MakeElemsExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 192 "Dalib.puma"

tTree index_exp;

  if (t->Kind == kUSED_VAR) {
# line 196 "Dalib.puma"
   return MakeConstant (1);

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 200 "Dalib.puma"
  {
# line 201 "Dalib.puma"
 index_exp = MakeIndexSizeExp (t->INDEXED_VAR.IND_EXPS);
     if (index_exp == NoTree)
       index_exp = MakeConstant(1);
   
  }
   return index_exp;

  }
  }
# line 208 "Dalib.puma"
  {
# line 209 "Dalib.puma"
   failure_protocol ("Dalib", "MakeElemsExp", t);
  }
   return NoTree;

}

static tTree MakeIndexSizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 215 "Dalib.puma"

tTree size_exp, index_exp;

  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 219 "Dalib.puma"
  {
# line 223 "Dalib.puma"
 index_exp = MakeIndexSizeExp (t->BTE_LIST.Next);
     size_exp  = MakeSliceExp (t->BTE_LIST.Elem->SLICE_EXP.START, t->BTE_LIST.Elem->SLICE_EXP.STOP);
     if (index_exp != NoTree)
       size_exp = mOP_EXP (mOP_TIMES (), index_exp, size_exp);
   
  }
   return size_exp;

  }
# line 231 "Dalib.puma"
   return MakeIndexSizeExp (t->BTE_LIST.Next);

  }
  if (t->Kind == kBTE_EMPTY) {
# line 235 "Dalib.puma"
   return NoTree;

  }
# line 239 "Dalib.puma"
  {
# line 240 "Dalib.puma"
   failure_protocol ("Dalib", "MakeIndexSizeExp", t);
  }
   return NoTree;

}

tTree DalibFormalSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 256 "Dalib.puma"
   return DalibFormalSize (ArrayFormals (t->USED_VAR.VARNAME->VAR_OBJ.Object));

  }
  if (t->Kind == kSHAPE_EMPTY) {
# line 260 "Dalib.puma"
   return NoTree;

  }
  if (t->Kind == kSHAPE_LIST) {
# line 264 "Dalib.puma"
   return mBTP_LIST (FormalSizeParameter (t->SHAPE_LIST.Elem), DalibFormalSize (t->SHAPE_LIST.Next));

  }
# line 269 "Dalib.puma"
  {
# line 270 "Dalib.puma"
   failure_protocol ("Dalib", "DalibFormalSize", t);
  }
   return NoTree;

}

tTree DalibGlobalToLocal
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int dim, register tTree exp)
# else
(id, dim, exp)
 register tIdent id;
 register int dim;
 register tTree exp;
# endif
{
# line 276 "Dalib.puma"
 {
  tTree paramlist;
  tTree call;
  {
# line 278 "Dalib.puma"

# line 279 "Dalib.puma"

# line 281 "Dalib.puma"
 paramlist = mBTP_EMPTY ();
    paramlist = mBTP_LIST (ExpToVarParam (exp), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (dim)), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (id, "_DSP")),
                           paramlist);

    call = mPROC_OBJ (MakeDalibId ("addr"));
    DefineNewHelpFn (MakeDalibId ("addr"));
    call = mFUNC_CALL_EXP (call, paramlist);
  
  }
  {
   return call;
  }
 }

}

void BeginDalib ()
{
}

void CloseDalib ()
{
}
