# include "ControlFlow.h"
# include "yyControlFlow.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 21 "ControlFlow.puma"


# define MODULE "ControlFlow"

# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Types.h"
# include "Transform.h"     /* ReplaceACF */
# include "Nesting.h"

# include "Expressions.h"   /* MakeConstant                 */
# include "Temporary.h"     /* TemporaryInit, TemporaryDone */

/*********************************************************************
*                                                                    * 
*  Global Data for Control Flow Analysis                             * 
*                                                                    * 
*********************************************************************/

int MaxLabel;
int NoReturns;

void SetMaxLabel (label)
int label;
{ if (label > MaxLabel) MaxLabel = label;
} /* SetMaxLabel */

/* global data for labels in IO statements */

int end_label;
int err_label;
int eor_label;

tTree io_stat;

bool is_label;



static void yyExit () { Exit (1); }

void (* ControlFlow_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ControlFlow, routine %s failed\n", yyFunction);
 ControlFlow_Exit ();
}

void ControlFlow ARGS((tTree t));
static void CheckUpLabels ARGS((tTree t));
static tTree RemoveLastReturn ARGS((tTree t));
static tTree AppendEndLabel ARGS((tTree t, int label));
static tTree ContinueStmt ARGS((int label));
static void ReplaceReturn ARGS((tTree t, int gotolabel));
static tTree NormalizeCF ARGS((tTree t));
static void GetCaseDefault ARGS((tTree t, tTree * yyP2, tTree * yyP1));
static tTree TranslateCase ARGS((tTree t, tTree def_stmts));
static tTree MakeIf ARGS((tTree s, tTree exp, tTree else_part, int label, int line));
static tTree TransCaseExp ARGS((tTree exp, tTree selector));
static tTree TranslateLoop ARGS((tTree t));
static tTree MakeWhileLoop ARGS((tTree t));
static void FindExitOrCycle ARGS((tTree t, tIdent name, int level, bool * yyP4, bool * yyP3));
static void ReplaceExitCycle ARGS((tTree t, tIdent name, int level, int exit_label, int cycle_label));
static tTree TranslateIOStmt ARGS((tTree t));
static void AnalyseIOSpecs ARGS((tTree specs));
static int GetLabel ARGS((tTree t));
static void GetIOStat ARGS((tTree t));
static tTree UpdateIOSpecs ARGS((tTree specs));
static bool IsLabelSpec ARGS((tTree spec));
static tTree MakeJumpStmt ARGS((tTree op, int value, int label));

void ControlFlow
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 71 "ControlFlow.puma"
  {
# line 73 "ControlFlow.puma"
   open_protocol ("adaptor.cf");
# line 74 "ControlFlow.puma"
   ControlFlow (t->COMP_UNIT.COMP_ELEMENTS);
# line 75 "ControlFlow.puma"
   close_protocol ();
  }
   return;

  case kUNIT_EMPTY:
# line 80 "ControlFlow.puma"
   return;

  case kUNIT_LIST:
# line 83 "ControlFlow.puma"
  {
# line 84 "ControlFlow.puma"
   ControlFlow (t->UNIT_LIST.Elem);
# line 85 "ControlFlow.puma"
   ControlFlow (t->UNIT_LIST.Next);
  }
   return;

  case kPROGRAM_DECL:
# line 94 "ControlFlow.puma"
  {
# line 96 "ControlFlow.puma"
   NestOpenUnit (t);
# line 97 "ControlFlow.puma"
   ControlFlow (t->PROGRAM_DECL.PROGRAM_BODY);
# line 98 "ControlFlow.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 101 "ControlFlow.puma"
  {
# line 103 "ControlFlow.puma"
   NestOpenUnit (t);
# line 104 "ControlFlow.puma"
   ControlFlow (t->PROC_DECL.PROC_BODY);
# line 105 "ControlFlow.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 108 "ControlFlow.puma"
  {
# line 110 "ControlFlow.puma"
   NestOpenUnit (t);
# line 111 "ControlFlow.puma"
   ControlFlow (t->FUNC_DECL.FUNC_BODY);
# line 112 "ControlFlow.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 115 "ControlFlow.puma"
  {
# line 117 "ControlFlow.puma"
   NestOpenUnit (t);
# line 118 "ControlFlow.puma"
   ControlFlow (t->MODULE_DECL.MODULE_BODY);
# line 119 "ControlFlow.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 122 "ControlFlow.puma"
  {
# line 124 "ControlFlow.puma"
   NestOpenUnit (t);
# line 125 "ControlFlow.puma"
   ControlFlow (t->BLOCK_DATA_DECL.DATA_BODY);
# line 126 "ControlFlow.puma"
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
# line 139 "ControlFlow.puma"
  {
# line 141 "ControlFlow.puma"
   TemporaryInit (t);
# line 145 "ControlFlow.puma"
   MaxLabel = 0;
# line 146 "ControlFlow.puma"
   NoReturns = 0;
# line 150 "ControlFlow.puma"
   CheckUpLabels (t->BODY_NODE.STATS);
# line 154 "ControlFlow.puma"
 if (NoReturns > 0)
        t->BODY_NODE.STATS = RemoveLastReturn (t->BODY_NODE.STATS);  
# line 159 "ControlFlow.puma"
 if (NoReturns > 0)
        { MaxLabel ++;
          t->BODY_NODE.STATS = AppendEndLabel (t->BODY_NODE.STATS, MaxLabel);
          ReplaceReturn (t->BODY_NODE.STATS, MaxLabel);   }
   
# line 167 "ControlFlow.puma"
 if (NoReturns > 0)
       simple_error_protocol ("not all returns removed");
   
# line 171 "ControlFlow.puma"
 t->BODY_NODE.STATS = NormalizeCF (t->BODY_NODE.STATS); 
# line 173 "ControlFlow.puma"
   TemporaryDone (t);
# line 175 "ControlFlow.puma"
   ControlFlow (t->BODY_NODE.INTERNALS);
  }
   return;

  }

;
}

static void CheckUpLabels
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 189 "ControlFlow.puma"
  {
# line 190 "ControlFlow.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 191 "ControlFlow.puma"
   CheckUpLabels (t->ACF_LIST.Elem);
# line 192 "ControlFlow.puma"
   CheckUpLabels (t->ACF_LIST.Next);
  }
   return;

  case kACF_EMPTY:
# line 195 "ControlFlow.puma"
   return;

  case kACF_DUMMY:
# line 198 "ControlFlow.puma"
  {
# line 199 "ControlFlow.puma"
   SetMaxLabel (t->ACF_DUMMY.Label);
  }
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kRETURN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
# line 202 "ControlFlow.puma"
  {
# line 203 "ControlFlow.puma"
   SetMaxLabel (t->ACF_BASIC.Label);
# line 204 "ControlFlow.puma"
   NoReturns = NoReturns + 1;
  }
   return;

  }
# line 207 "ControlFlow.puma"
  {
# line 208 "ControlFlow.puma"
   SetMaxLabel (t->ACF_BASIC.Label);
# line 209 "ControlFlow.puma"
   error_protocol ("Alternative return is rejected\n");
  }
   return;

  }
# line 212 "ControlFlow.puma"
  {
# line 213 "ControlFlow.puma"
   SetMaxLabel (t->ACF_BASIC.Label);
  }
   return;

  case kACF_IF:
# line 216 "ControlFlow.puma"
  {
# line 217 "ControlFlow.puma"
   SetMaxLabel (t->ACF_IF.Label);
# line 218 "ControlFlow.puma"
   CheckUpLabels (t->ACF_IF.THEN_PART);
# line 219 "ControlFlow.puma"
   CheckUpLabels (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 222 "ControlFlow.puma"
  {
# line 223 "ControlFlow.puma"
   SetMaxLabel (t->ACF_WHERE.Label);
# line 224 "ControlFlow.puma"
   CheckUpLabels (t->ACF_WHERE.TRUE_PART);
# line 225 "ControlFlow.puma"
   CheckUpLabels (t->ACF_WHERE.FALSE_PART);
  }
   return;

  case kACF_CASE:
# line 228 "ControlFlow.puma"
  {
# line 229 "ControlFlow.puma"
   SetMaxLabel (t->ACF_CASE.Label);
# line 230 "ControlFlow.puma"
   CheckUpLabels (t->ACF_CASE.CASE_ALTS);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 233 "ControlFlow.puma"
  {
# line 234 "ControlFlow.puma"
   CheckUpLabels (t->SELECTED_ACF_LIST.Elem);
# line 235 "ControlFlow.puma"
   CheckUpLabels (t->SELECTED_ACF_LIST.Next);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 238 "ControlFlow.puma"
   return;

  case kSELECTED_ACF_NODE:
# line 241 "ControlFlow.puma"
  {
# line 243 "ControlFlow.puma"
   CheckUpLabels (t->SELECTED_ACF_NODE.SELECT_ACFS);
  }
   return;

  case kACF_LOOP:
# line 246 "ControlFlow.puma"
  {
# line 248 "ControlFlow.puma"
   SetMaxLabel (t->ACF_LOOP.Label);
# line 249 "ControlFlow.puma"
   CheckUpLabels (t->ACF_LOOP.LOOP_BODY);
  }
   return;

  case kACF_WHILE:
# line 252 "ControlFlow.puma"
  {
# line 254 "ControlFlow.puma"
   SetMaxLabel (t->ACF_WHILE.Label);
# line 255 "ControlFlow.puma"
   CheckUpLabels (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_FORALL:
# line 258 "ControlFlow.puma"
  {
# line 260 "ControlFlow.puma"
   SetMaxLabel (t->ACF_FORALL.Label);
# line 261 "ControlFlow.puma"
   CheckUpLabels (t->ACF_FORALL.FORALL_BODY);
  }
   return;

  case kACF_DO:
# line 264 "ControlFlow.puma"
  {
# line 266 "ControlFlow.puma"
   SetMaxLabel (t->ACF_DO.Label);
# line 267 "ControlFlow.puma"
   CheckUpLabels (t->ACF_DO.DO_BODY);
  }
   return;

  case kACF_HOME:
# line 270 "ControlFlow.puma"
  {
# line 272 "ControlFlow.puma"
   SetMaxLabel (t->ACF_HOME.Label);
# line 273 "ControlFlow.puma"
   CheckUpLabels (t->ACF_HOME.HOME_BODY);
  }
   return;

  case kACF_NEW:
# line 276 "ControlFlow.puma"
  {
# line 278 "ControlFlow.puma"
   SetMaxLabel (t->ACF_NEW.Label);
# line 279 "ControlFlow.puma"
   CheckUpLabels (t->ACF_NEW.NEW_BODY);
  }
   return;

  case kACF_RESIDENT:
# line 282 "ControlFlow.puma"
  {
# line 284 "ControlFlow.puma"
   SetMaxLabel (t->ACF_RESIDENT.Label);
# line 285 "ControlFlow.puma"
   CheckUpLabels (t->ACF_RESIDENT.RESIDENT_BODY);
  }
   return;

  case kACF_REDUCTION:
# line 288 "ControlFlow.puma"
  {
# line 290 "ControlFlow.puma"
   SetMaxLabel (t->ACF_REDUCTION.Label);
# line 291 "ControlFlow.puma"
   CheckUpLabels (t->ACF_REDUCTION.REDUCTION_BODY);
  }
   return;

  case kACF_TASK_REGION:
# line 294 "ControlFlow.puma"
  {
# line 296 "ControlFlow.puma"
   SetMaxLabel (t->ACF_TASK_REGION.Label);
# line 297 "ControlFlow.puma"
   CheckUpLabels (t->ACF_TASK_REGION.TASK_BODY);
  }
   return;

  case kACF_ENTRY:
# line 300 "ControlFlow.puma"
  {
# line 302 "ControlFlow.puma"
   SetMaxLabel (t->ACF_ENTRY.Label);
  }
   return;

  }

# line 305 "ControlFlow.puma"
  {
# line 306 "ControlFlow.puma"
   failure_protocol (MODULE, "CheckUpLabels", t);
  }
   return;

;
}

static tTree RemoveLastReturn
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_BASIC) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kRETURN_STMT) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 320 "ControlFlow.puma"
  {
# line 323 "ControlFlow.puma"
   NoReturns = NoReturns - 1;
  }
   return ReplaceACF (t, NoTree, t->ACF_LIST.Next);

  }
  }
  }
  }
# line 329 "ControlFlow.puma"
  {
# line 330 "ControlFlow.puma"
 t->ACF_LIST.Next = RemoveLastReturn (t->ACF_LIST.Next); 
  }
   return t;

  }
  if (t->Kind == kACF_EMPTY) {
# line 334 "ControlFlow.puma"
   return t;

  }
 yyAbort ("RemoveLastReturn");
}

static tTree AppendEndLabel
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int label)
# else
(t, label)
 register tTree t;
 register int label;
# endif
{
  if (t->Kind == kACF_EMPTY) {
# line 350 "ControlFlow.puma"
   return mACF_LIST (ContinueStmt (label), t);

  }
  if (t->Kind == kACF_LIST) {
# line 354 "ControlFlow.puma"
  {
# line 355 "ControlFlow.puma"
 t->ACF_LIST.Next = AppendEndLabel (t->ACF_LIST.Next, label); 
  }
   return t;

  }
 yyAbort ("AppendEndLabel");
}

static tTree ContinueStmt
# if defined __STDC__ | defined __cplusplus
(register int label)
# else
(label)
 register int label;
# endif
{
# line 367 "ControlFlow.puma"
 {
  tTree stmt;
  {
# line 369 "ControlFlow.puma"

# line 371 "ControlFlow.puma"
 stmt = mACF_DUMMY();
      SetACFNode (stmt, label, 0);
    
  }
  {
   return stmt;
  }
 }

}

static void ReplaceReturn
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int gotolabel)
# else
(t, gotolabel)
 register tTree t;
 register int gotolabel;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 391 "ControlFlow.puma"
  {
# line 392 "ControlFlow.puma"
   ReplaceReturn (t->ACF_LIST.Elem, gotolabel);
# line 393 "ControlFlow.puma"
   ReplaceReturn (t->ACF_LIST.Next, gotolabel);
  }
   return;

  case kACF_EMPTY:
# line 396 "ControlFlow.puma"
   return;

  case kACF_DUMMY:
# line 399 "ControlFlow.puma"
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kRETURN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
# line 402 "ControlFlow.puma"
  {
# line 403 "ControlFlow.puma"
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (gotolabel); 
# line 404 "ControlFlow.puma"
   NoReturns = NoReturns - 1;
  }
   return;

  }
# line 407 "ControlFlow.puma"
   return;

  }
# line 411 "ControlFlow.puma"
   return;

  case kACF_IF:
# line 414 "ControlFlow.puma"
  {
# line 415 "ControlFlow.puma"
   ReplaceReturn (t->ACF_IF.THEN_PART, gotolabel);
# line 416 "ControlFlow.puma"
   ReplaceReturn (t->ACF_IF.ELSE_PART, gotolabel);
  }
   return;

  case kACF_WHERE:
# line 419 "ControlFlow.puma"
  {
# line 420 "ControlFlow.puma"
   ReplaceReturn (t->ACF_WHERE.TRUE_PART, gotolabel);
# line 421 "ControlFlow.puma"
   ReplaceReturn (t->ACF_WHERE.FALSE_PART, gotolabel);
  }
   return;

  case kACF_CASE:
# line 424 "ControlFlow.puma"
  {
# line 425 "ControlFlow.puma"
   ReplaceReturn (t->ACF_CASE.CASE_ALTS, gotolabel);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 428 "ControlFlow.puma"
  {
# line 429 "ControlFlow.puma"
   ReplaceReturn (t->SELECTED_ACF_LIST.Elem, gotolabel);
# line 430 "ControlFlow.puma"
   ReplaceReturn (t->SELECTED_ACF_LIST.Next, gotolabel);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 433 "ControlFlow.puma"
   return;

  case kSELECTED_ACF_NODE:
# line 436 "ControlFlow.puma"
  {
# line 437 "ControlFlow.puma"
   ReplaceReturn (t->SELECTED_ACF_NODE.SELECT_ACFS, gotolabel);
  }
   return;

  case kACF_LOOP:
# line 440 "ControlFlow.puma"
  {
# line 441 "ControlFlow.puma"
   ReplaceReturn (t->ACF_LOOP.LOOP_BODY, gotolabel);
  }
   return;

  case kACF_WHILE:
# line 444 "ControlFlow.puma"
  {
# line 445 "ControlFlow.puma"
   ReplaceReturn (t->ACF_WHILE.WHILE_BODY, gotolabel);
  }
   return;

  case kACF_FORALL:
# line 448 "ControlFlow.puma"
  {
# line 450 "ControlFlow.puma"
   ReplaceReturn (t->ACF_FORALL.FORALL_BODY, gotolabel);
  }
   return;

  case kACF_DO:
# line 453 "ControlFlow.puma"
  {
# line 455 "ControlFlow.puma"
   ReplaceReturn (t->ACF_DO.DO_BODY, gotolabel);
  }
   return;

  case kACF_HOME:
# line 458 "ControlFlow.puma"
  {
# line 460 "ControlFlow.puma"
   ReplaceReturn (t->ACF_HOME.HOME_BODY, gotolabel);
  }
   return;

  case kACF_NEW:
# line 463 "ControlFlow.puma"
  {
# line 465 "ControlFlow.puma"
   ReplaceReturn (t->ACF_NEW.NEW_BODY, gotolabel);
  }
   return;

  case kACF_RESIDENT:
# line 468 "ControlFlow.puma"
  {
# line 470 "ControlFlow.puma"
   ReplaceReturn (t->ACF_RESIDENT.RESIDENT_BODY, gotolabel);
  }
   return;

  case kACF_REDUCTION:
# line 473 "ControlFlow.puma"
  {
# line 475 "ControlFlow.puma"
   ReplaceReturn (t->ACF_REDUCTION.REDUCTION_BODY, gotolabel);
  }
   return;

  case kACF_ENTRY:
# line 478 "ControlFlow.puma"
   return;

  }

# line 481 "ControlFlow.puma"
  {
# line 482 "ControlFlow.puma"
   failure_protocol (MODULE, "ReplaceReturn", t);
  }
   return;

;
}

static tTree NormalizeCF
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 496 "ControlFlow.puma"

tTree newacf;


  switch (t->Kind) {
  case kACF_LIST:
# line 500 "ControlFlow.puma"
  {
# line 501 "ControlFlow.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 502 "ControlFlow.puma"
 newacf = NormalizeCF (t->ACF_LIST.Elem);
      t->ACF_LIST.Next   = NormalizeCF (t->ACF_LIST.Next);
      newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
    
  }
   return newacf;

  case kACF_EMPTY:
# line 509 "ControlFlow.puma"
   return t;

  case kACF_LOOP:
# line 513 "ControlFlow.puma"
  {
# line 517 "ControlFlow.puma"
 t->ACF_LOOP.LOOP_BODY = NormalizeCF (t->ACF_LOOP.LOOP_BODY); 
  }
   return TranslateLoop (t);

  case kACF_WHILE:
# line 522 "ControlFlow.puma"
  {
# line 524 "ControlFlow.puma"
 t->ACF_WHILE.WHILE_BODY = NormalizeCF (t->ACF_WHILE.WHILE_BODY); 
  }
   return TranslateLoop (t);

  case kACF_DO:
# line 529 "ControlFlow.puma"
  {
# line 531 "ControlFlow.puma"
 t->ACF_DO.DO_BODY = NormalizeCF (t->ACF_DO.DO_BODY); 
  }
   return TranslateLoop (t);

  case kACF_FORALL:
# line 536 "ControlFlow.puma"
  {
# line 538 "ControlFlow.puma"
 t->ACF_FORALL.FORALL_BODY = NormalizeCF (t->ACF_FORALL.FORALL_BODY); 
  }
   return t;

  case kACF_IF:
# line 543 "ControlFlow.puma"
  {
# line 545 "ControlFlow.puma"
 t->ACF_IF.THEN_PART = NormalizeCF (t->ACF_IF.THEN_PART);
     t->ACF_IF.ELSE_PART = NormalizeCF (t->ACF_IF.ELSE_PART);
   
  }
   return t;

  case kACF_WHERE:
# line 551 "ControlFlow.puma"
   return t;

  case kACF_CASE:
# line 555 "ControlFlow.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 557 "ControlFlow.puma"
   if (! (NormalizeCF (t->ACF_CASE.CASE_ALTS))) goto yyL9;
  {
# line 559 "ControlFlow.puma"
   stmt_protocol ("Translation of CASE : ");
# line 561 "ControlFlow.puma"
   GetCaseDefault (t->ACF_CASE.CASE_ALTS, & yyV1, & yyV2);
# line 563 "ControlFlow.puma"
 t->ACF_CASE.CASE_ALTS = yyV1; 
# line 565 "ControlFlow.puma"
 newacf = TranslateCase (t, yyV2);
     tree_protocol ("New If construct :\n", newacf);
   
  }
  }
  {
   return newacf;
  }
 }
yyL9:;

  break;
  case kACF_HOME:
# line 571 "ControlFlow.puma"
  {
# line 573 "ControlFlow.puma"
 t->ACF_HOME.HOME_BODY = NormalizeCF (t->ACF_HOME.HOME_BODY); 
  }
   return t;

  case kACF_NEW:
# line 577 "ControlFlow.puma"
  {
# line 579 "ControlFlow.puma"
 t->ACF_NEW.NEW_BODY = NormalizeCF (t->ACF_NEW.NEW_BODY); 
  }
   return t;

  case kACF_RESIDENT:
# line 583 "ControlFlow.puma"
  {
# line 585 "ControlFlow.puma"
 t->ACF_RESIDENT.RESIDENT_BODY = NormalizeCF (t->ACF_RESIDENT.RESIDENT_BODY); 
  }
   return t;

  case kACF_REDUCTION:
# line 589 "ControlFlow.puma"
  {
# line 591 "ControlFlow.puma"
 t->ACF_REDUCTION.REDUCTION_BODY = NormalizeCF (t->ACF_REDUCTION.REDUCTION_BODY); 
  }
   return t;

  case kACF_TASK_REGION:
# line 595 "ControlFlow.puma"
  {
# line 597 "ControlFlow.puma"
 t->ACF_TASK_REGION.TASK_BODY = NormalizeCF (t->ACF_TASK_REGION.TASK_BODY); 
  }
   return t;

  case kSELECTED_ACF_LIST:
# line 601 "ControlFlow.puma"
  {
# line 602 "ControlFlow.puma"
 t->SELECTED_ACF_LIST.Elem = NormalizeCF (t->SELECTED_ACF_LIST.Elem); 
     t->SELECTED_ACF_LIST.Next = NormalizeCF (t->SELECTED_ACF_LIST.Next);
   
  }
   return t;

  case kSELECTED_ACF_EMPTY:
# line 608 "ControlFlow.puma"
   return t;

  case kSELECTED_ACF_NODE:
# line 612 "ControlFlow.puma"
  {
# line 613 "ControlFlow.puma"
 t->SELECTED_ACF_NODE.SELECT_ACFS = NormalizeCF (t->SELECTED_ACF_NODE.SELECT_ACFS);  
  }
   return t;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 617 "ControlFlow.puma"
   return TranslateIOStmt (t);

  }
# line 621 "ControlFlow.puma"
   return t;

  case kACF_DUMMY:
# line 625 "ControlFlow.puma"
   return t;

  }

# line 629 "ControlFlow.puma"
  {
# line 630 "ControlFlow.puma"
   failure_protocol ("ControlFlow", "NormalizeCF", t);
  }
   return t;

}

static void GetCaseDefault
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP2, register tTree * yyP1)
# else
(t, yyP2, yyP1)
 register tTree t;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (t->Kind == kSELECTED_ACF_EMPTY) {
# line 653 "ControlFlow.puma"
   * yyP2 = t;
   * yyP1 = NoTree;
   return;

  }
  if (t->Kind == kSELECTED_ACF_LIST) {
  if (t->SELECTED_ACF_LIST.Elem->SELECTED_ACF_NODE.SELECT_LIST->Kind == kBTE_EMPTY) {
# line 656 "ControlFlow.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 658 "ControlFlow.puma"
   GetCaseDefault (t->SELECTED_ACF_LIST.Next, & yyV1, & yyV2);
# line 660 "ControlFlow.puma"
 if (yyV2 != NoTree)
        error_protocol ("more than one CASE DEFAULT in CASE statement");
   
  }
   * yyP2 = t->SELECTED_ACF_LIST.Next;
   * yyP1 = t->SELECTED_ACF_LIST.Elem->SELECTED_ACF_NODE.SELECT_ACFS;
   return;
 }

  }
# line 665 "ControlFlow.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 667 "ControlFlow.puma"
   GetCaseDefault (t->SELECTED_ACF_LIST.Next, & yyV1, & yyV2);
# line 669 "ControlFlow.puma"
 t->SELECTED_ACF_LIST.Next = yyV1; 
  }
   * yyP2 = t;
   * yyP1 = yyV2;
   return;
 }

  }
# line 672 "ControlFlow.puma"
  {
# line 674 "ControlFlow.puma"
   failure_protocol (MODULE, "GetCaseDefault", t);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static tTree TranslateCase
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree def_stmts)
# else
(t, def_stmts)
 register tTree t;
 register tTree def_stmts;
# endif
{
# line 699 "ControlFlow.puma"
  {
# line 700 "ControlFlow.puma"
   if (! ((def_stmts == NoTree))) goto yyL1;
  }
   return TranslateCase (t, mACF_EMPTY ());
yyL1:;

  if (t->Kind == kACF_CASE) {
  if (t->ACF_CASE.CASE_ALTS->Kind == kSELECTED_ACF_EMPTY) {
# line 704 "ControlFlow.puma"
   return mACF_IF (mCONST_EXP (mBOOL_CONSTANT (1)), def_stmts, mACF_EMPTY ());

  }
  if (t->ACF_CASE.CASE_ALTS->Kind == kSELECTED_ACF_LIST) {
  if (t->ACF_CASE.CASE_ALTS->SELECTED_ACF_LIST.Next->Kind == kSELECTED_ACF_EMPTY) {
# line 710 "ControlFlow.puma"
   return MakeIf (t->ACF_CASE.CASE_ALTS->SELECTED_ACF_LIST.Elem, t->ACF_CASE.CASE_EXP, def_stmts, t->ACF_CASE.Label, t->ACF_CASE.Line);

  }
# line 716 "ControlFlow.puma"
 {
  tTree tail;
  tTree first;
  {
# line 718 "ControlFlow.puma"

# line 719 "ControlFlow.puma"

# line 721 "ControlFlow.puma"
 first = t->ACF_CASE.CASE_ALTS->SELECTED_ACF_LIST.Elem;   
      t->ACF_CASE.CASE_ALTS  = t->ACF_CASE.CASE_ALTS->SELECTED_ACF_LIST.Next;
      tail  = TranslateCase (t, def_stmts);
      tail  = mACF_LIST (tail, mACF_EMPTY ());   
      first = MakeIf (first, CopyTree (t->ACF_CASE.CASE_EXP), tail, t->ACF_CASE.Label, t->ACF_CASE.Line);
    
  }
  {
   return first;
  }
 }

  }
  }
# line 731 "ControlFlow.puma"
  {
# line 732 "ControlFlow.puma"
   failure_protocol ("ControlFlow", "TranslateCase", t);
  }
   return t;

}

static tTree MakeIf
# if defined __STDC__ | defined __cplusplus
(register tTree s, register tTree exp, register tTree else_part, register int label, register int line)
# else
(s, exp, else_part, label, line)
 register tTree s;
 register tTree exp;
 register tTree else_part;
 register int label;
 register int line;
# endif
{
  if (s->Kind == kSELECTED_ACF_NODE) {
# line 745 "ControlFlow.puma"
 {
  tTree if_stmt;
  {
# line 747 "ControlFlow.puma"

# line 749 "ControlFlow.puma"
 if_stmt = mACF_IF (TransCaseExp (exp, s->SELECTED_ACF_NODE.SELECT_LIST), s->SELECTED_ACF_NODE.SELECT_ACFS, else_part);
       SetACFNode (if_stmt, label, line);
     
  }
  {
   return if_stmt;
  }
 }

  }
 yyAbort ("MakeIf");
}

static tTree TransCaseExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree selector)
# else
(exp, selector)
 register tTree exp;
 register tTree selector;
# endif
{
  if (selector->Kind == kBTE_EMPTY) {
# line 763 "ControlFlow.puma"
   return mCONST_EXP (mBOOL_CONSTANT (1));

  }
  if (selector->Kind == kBTE_LIST) {
  if (selector->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 767 "ControlFlow.puma"
   return TransCaseExp (exp, selector->BTE_LIST.Elem);

  }
# line 771 "ControlFlow.puma"
   return mOP_EXP (mOP_OR (), TransCaseExp (CopyTree (exp), selector->BTE_LIST.Elem), TransCaseExp (exp, selector->BTE_LIST.Next));

  }
  if (selector->Kind == kSLICE_EXP) {
  if (selector->SLICE_EXP.START->Kind == kDUMMY_EXP) {
# line 776 "ControlFlow.puma"
   return mOP_EXP (mOP_LE (), exp, selector->SLICE_EXP.STOP);

  }
  if (selector->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
# line 780 "ControlFlow.puma"
   return mOP_EXP (mOP_LE (), selector->SLICE_EXP.START, exp);

  }
# line 784 "ControlFlow.puma"
   return mOP_EXP (mOP_AND (), mOP_EXP (mOP_LE (), selector->SLICE_EXP.START, CopyTree (exp)), mOP_EXP (mOP_LE (), exp, selector->SLICE_EXP.STOP));

  }
# line 789 "ControlFlow.puma"
   return mOP_EXP (mOP_EQ (), exp, selector);

}

static tTree TranslateLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LOOP) {
# line 813 "ControlFlow.puma"
 {
  tIdent id;
  tTree newloop;
  int exit_label;
  int cycle_label;
  bool yyV1;
  bool yyV2;
  {
# line 815 "ControlFlow.puma"

# line 816 "ControlFlow.puma"

# line 818 "ControlFlow.puma"

# line 819 "ControlFlow.puma"

# line 821 "ControlFlow.puma"
   set_protocol_stmt (t);
# line 822 "ControlFlow.puma"
   stmt_protocol ("translate LOOP statement");
# line 824 "ControlFlow.puma"
 if (t->ACF_LOOP.Label >= 0) 
         id = DefaultId();
       else
         { id = -t->ACF_LOOP.Label;
           t->ACF_LOOP.Label = 0;    
         }
 
    
# line 833 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_LOOP.LOOP_BODY, id, 0, & yyV1, & yyV2);
# line 837 "ControlFlow.puma"
 if (yyV2)
         { ++MaxLabel;
           cycle_label = MaxLabel;
           t->ACF_LOOP.LOOP_BODY = AppendEndLabel (t->ACF_LOOP.LOOP_BODY, cycle_label);
         }

      newloop = MakeWhileLoop (t);
      if (yyV1)
         { ++MaxLabel;
           exit_label = MaxLabel;
           newloop = mACF_LIST (newloop, 
                       mACF_LIST (ContinueStmt (exit_label), NoTree));
         }

      if (yyV1 || yyV2)
         ReplaceExitCycle (t->ACF_LOOP.LOOP_BODY, id, 0, exit_label, cycle_label);
    
# line 855 "ControlFlow.puma"
   tree_protocol ("new WHILE loop : \n", newloop);
  }
  {
   return newloop;
  }
 }

  }
  if (t->Kind == kACF_DO) {
# line 860 "ControlFlow.puma"
 {
  tIdent id;
  tTree newloop;
  int exit_label;
  int cycle_label;
  bool yyV1;
  bool yyV2;
  {
# line 862 "ControlFlow.puma"

# line 863 "ControlFlow.puma"

# line 865 "ControlFlow.puma"

# line 866 "ControlFlow.puma"

# line 868 "ControlFlow.puma"
 if (t->ACF_DO.Label >= 0) 
         id = DefaultId();
       else
         { id = -t->ACF_DO.Label;
           t->ACF_DO.Label = 0;    
         }
      newloop = t;
    
# line 877 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_DO.DO_BODY, id, 0, & yyV1, & yyV2);
# line 879 "ControlFlow.puma"
 if (yyV2)
         { ++MaxLabel;
           cycle_label = MaxLabel;
           t->ACF_DO.DO_BODY = AppendEndLabel (t->ACF_DO.DO_BODY, cycle_label);
         }

      if (yyV1)
         { ++MaxLabel;
           exit_label = MaxLabel;
           newloop = mACF_LIST (newloop, 
                       mACF_LIST (ContinueStmt (exit_label), NoTree));
         }

      if (yyV1 || yyV2)
         ReplaceExitCycle (t->ACF_DO.DO_BODY, id, 0, exit_label, cycle_label);
    
  }
  {
   return newloop;
  }
 }

  }
  if (t->Kind == kACF_WHILE) {
# line 899 "ControlFlow.puma"
 {
  tIdent id;
  tTree newloop;
  int exit_label;
  int cycle_label;
  bool yyV1;
  bool yyV2;
  {
# line 901 "ControlFlow.puma"

# line 902 "ControlFlow.puma"

# line 904 "ControlFlow.puma"

# line 905 "ControlFlow.puma"

# line 907 "ControlFlow.puma"
 if (t->ACF_WHILE.Label >= 0) 
         id = DefaultId();
       else
         { id = -t->ACF_WHILE.Label;
           t->ACF_WHILE.Label = 0;    
         }
      newloop = t;
    
# line 916 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_WHILE.WHILE_BODY, id, 0, & yyV1, & yyV2);
# line 918 "ControlFlow.puma"
 if (yyV2)
         { ++MaxLabel;
           cycle_label = MaxLabel;
           t->ACF_WHILE.WHILE_BODY = AppendEndLabel (t->ACF_WHILE.WHILE_BODY, cycle_label);
         }

      if (yyV1)
         { ++MaxLabel;
           exit_label = MaxLabel;
           newloop = mACF_LIST (newloop, 
                       mACF_LIST (ContinueStmt (exit_label), NoTree));
         }

      if (yyV1 || yyV2)
         ReplaceExitCycle (t->ACF_WHILE.WHILE_BODY, id, 0, exit_label, cycle_label);
    
  }
  {
   return newloop;
  }
 }

  }
# line 939 "ControlFlow.puma"
  {
# line 940 "ControlFlow.puma"
   failure_protocol (MODULE, "TranslateLoop", t);
  }
   return NoTree;

}

static tTree MakeWhileLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LOOP) {
# line 954 "ControlFlow.puma"
 {
  tTree new;
  {
# line 956 "ControlFlow.puma"

# line 958 "ControlFlow.puma"
 new = mCONST_EXP (mBOOL_CONSTANT (1));  
      new = mACF_WHILE (new, t->ACF_LOOP.LOOP_BODY);
      SetACFNode (new, t->ACF_LOOP.Label, t->ACF_LOOP.Line);
    
  }
  {
   return new;
  }
 }

  }
# line 966 "ControlFlow.puma"
  {
# line 967 "ControlFlow.puma"
   failure_protocol (MODULE, "MakeWhileLoop", t);
  }
   return t;

}

static void FindExitOrCycle
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register int level, register bool * yyP4, register bool * yyP3)
# else
(t, name, level, yyP4, yyP3)
 register tTree t;
 register tIdent name;
 register int level;
 register bool * yyP4;
 register bool * yyP3;
# endif
{

  switch (t->Kind) {
  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kEXIT_STMT) {
# line 979 "ControlFlow.puma"
  {
# line 980 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == DefaultId ()))) goto yyL1;
  {
# line 981 "ControlFlow.puma"
   if (! ((level == 0))) goto yyL1;
  }
  }
   * yyP4 = true;
   * yyP3 = false;
   return;
yyL1:;

# line 984 "ControlFlow.puma"
  {
# line 985 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == DefaultId ()))) goto yyL2;
  }
   * yyP4 = false;
   * yyP3 = false;
   return;
yyL2:;

# line 988 "ControlFlow.puma"
  {
# line 989 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == name))) goto yyL3;
  }
   * yyP4 = true;
   * yyP3 = false;
   return;
yyL3:;

# line 992 "ControlFlow.puma"
   * yyP4 = false;
   * yyP3 = false;
   return;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCYCLE_STMT) {
# line 995 "ControlFlow.puma"
  {
# line 996 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == DefaultId ()))) goto yyL5;
  {
# line 997 "ControlFlow.puma"
   if (! ((level == 0))) goto yyL5;
  }
  }
   * yyP4 = false;
   * yyP3 = true;
   return;
yyL5:;

# line 1000 "ControlFlow.puma"
  {
# line 1001 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == DefaultId ()))) goto yyL6;
  }
   * yyP4 = false;
   * yyP3 = false;
   return;
yyL6:;

# line 1004 "ControlFlow.puma"
  {
# line 1005 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == name))) goto yyL7;
  }
   * yyP4 = false;
   * yyP3 = true;
   return;
yyL7:;

  }
  break;
  case kACF_LIST:
# line 1008 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  bool yyV3;
  bool yyV4;
  {
# line 1009 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_LIST.Elem, name, level, & yyV1, & yyV2);
# line 1010 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_LIST.Next, name, level, & yyV3, & yyV4);
  }
   * yyP4 = (yyV1 || yyV3);
   * yyP3 = (yyV2 || yyV4);
   return;
 }

  case kACF_IF:
# line 1013 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  bool yyV3;
  bool yyV4;
  {
# line 1014 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_IF.THEN_PART, name, level, & yyV1, & yyV2);
# line 1015 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_IF.ELSE_PART, name, level, & yyV3, & yyV4);
  }
   * yyP4 = (yyV1 || yyV3);
   * yyP3 = (yyV2 || yyV4);
   return;
 }

  case kACF_DO:
# line 1018 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  {
# line 1020 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_DO.DO_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_HOME:
# line 1023 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  {
# line 1024 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_HOME.HOME_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_NEW:
# line 1027 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  {
# line 1028 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_NEW.NEW_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_RESIDENT:
# line 1031 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  {
# line 1032 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_RESIDENT.RESIDENT_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_REDUCTION:
# line 1035 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  {
# line 1037 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_REDUCTION.REDUCTION_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_WHILE:
# line 1040 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  {
# line 1041 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_WHILE.WHILE_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_LOOP:
# line 1044 "ControlFlow.puma"
 {
  bool yyV1;
  bool yyV2;
  {
# line 1045 "ControlFlow.puma"
   FindExitOrCycle (t->ACF_LOOP.LOOP_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  }

# line 1050 "ControlFlow.puma"
   * yyP4 = false;
   * yyP3 = false;
   return;

;
}

static void ReplaceExitCycle
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register int level, register int exit_label, register int cycle_label)
# else
(t, name, level, exit_label, cycle_label)
 register tTree t;
 register tIdent name;
 register int level;
 register int exit_label;
 register int cycle_label;
# endif
{

  switch (t->Kind) {
  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kEXIT_STMT) {
# line 1062 "ControlFlow.puma"
  {
# line 1063 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == DefaultId ()))) goto yyL1;
  {
# line 1064 "ControlFlow.puma"
   if (! ((level == 0))) goto yyL1;
  {
# line 1065 "ControlFlow.puma"
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (exit_label); 
  }
  }
  }
   return;
yyL1:;

# line 1068 "ControlFlow.puma"
  {
# line 1069 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == DefaultId ()))) goto yyL2;
  }
   return;
yyL2:;

# line 1072 "ControlFlow.puma"
  {
# line 1073 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == name))) goto yyL3;
  {
# line 1074 "ControlFlow.puma"
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (exit_label); 
  }
  }
   return;
yyL3:;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCYCLE_STMT) {
# line 1077 "ControlFlow.puma"
  {
# line 1078 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == DefaultId ()))) goto yyL4;
  {
# line 1079 "ControlFlow.puma"
   if (! ((level == 0))) goto yyL4;
  {
# line 1080 "ControlFlow.puma"
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (cycle_label); 
  }
  }
  }
   return;
yyL4:;

# line 1083 "ControlFlow.puma"
  {
# line 1084 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == DefaultId ()))) goto yyL5;
  }
   return;
yyL5:;

# line 1087 "ControlFlow.puma"
  {
# line 1088 "ControlFlow.puma"
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == name))) goto yyL6;
  {
# line 1089 "ControlFlow.puma"
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (cycle_label); 
  }
  }
   return;
yyL6:;

  }
  break;
  case kACF_LIST:
# line 1092 "ControlFlow.puma"
  {
# line 1093 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_LIST.Elem, name, level, exit_label, cycle_label);
# line 1094 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_LIST.Next, name, level, exit_label, cycle_label);
  }
   return;

  case kACF_IF:
# line 1097 "ControlFlow.puma"
  {
# line 1098 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_IF.THEN_PART, name, level, exit_label, cycle_label);
# line 1099 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_IF.ELSE_PART, name, level, exit_label, cycle_label);
  }
   return;

  case kACF_DO:
# line 1102 "ControlFlow.puma"
  {
# line 1104 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_DO.DO_BODY, name, level + 1, exit_label, cycle_label);
  }
   return;

  case kACF_HOME:
# line 1107 "ControlFlow.puma"
  {
# line 1109 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_HOME.HOME_BODY, name, level + 1, exit_label, cycle_label);
  }
   return;

  case kACF_NEW:
# line 1112 "ControlFlow.puma"
  {
# line 1113 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_NEW.NEW_BODY, name, level + 1, exit_label, cycle_label);
  }
   return;

  case kACF_RESIDENT:
# line 1116 "ControlFlow.puma"
  {
# line 1117 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_RESIDENT.RESIDENT_BODY, name, level + 1, exit_label, cycle_label);
  }
   return;

  case kACF_REDUCTION:
# line 1120 "ControlFlow.puma"
  {
# line 1122 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_REDUCTION.REDUCTION_BODY, name, level + 1, exit_label, cycle_label);
  }
   return;

  case kACF_WHILE:
# line 1125 "ControlFlow.puma"
  {
# line 1126 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_WHILE.WHILE_BODY, name, level + 1, exit_label, cycle_label);
  }
   return;

  case kACF_LOOP:
# line 1129 "ControlFlow.puma"
  {
# line 1130 "ControlFlow.puma"
   ReplaceExitCycle (t->ACF_LOOP.LOOP_BODY, name, level + 1, exit_label, cycle_label);
  }
   return;

  }

# line 1135 "ControlFlow.puma"
   return;

;
}

static tTree TranslateIOStmt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 1146 "ControlFlow.puma"
 {
  tTree new;
  tTree goto_stmt;
  {
# line 1148 "ControlFlow.puma"
   end_label = 0;
# line 1149 "ControlFlow.puma"
   err_label = 0;
# line 1150 "ControlFlow.puma"
   eor_label = 0;
# line 1152 "ControlFlow.puma"
   io_stat = NoTree;
# line 1153 "ControlFlow.puma"
   is_label = false;
# line 1155 "ControlFlow.puma"
   AnalyseIOSpecs (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS);
# line 1157 "ControlFlow.puma"

# line 1158 "ControlFlow.puma"

# line 1160 "ControlFlow.puma"
 new = t;

     if (is_label) stmt_protocol ("remove implicit gotos of IO stmt");

     

     if (is_label)  t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS = UpdateIOSpecs (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS);
       
     if (end_label != 0)

        {  

           goto_stmt = MakeJumpStmt (mOP_EQ(), IOSTAT_END_OF_FILE, end_label);

           new = CombineACF (new, goto_stmt);
        }

     if (eor_label != 0)

        {  

           goto_stmt = MakeJumpStmt (mOP_EQ(), IOSTAT_END_OF_RECORD, eor_label);

           new = CombineACF (new, goto_stmt);
        }

     if (err_label != 0)

        {  

           goto_stmt = MakeJumpStmt (mOP_GT(), 0, err_label);

           new = CombineACF (new, goto_stmt);
        }

     if (is_label)
        tree_protocol ("new io statement :\n", new);

   
  }
  {
   return new;
  }
 }

  }
  }
# line 1202 "ControlFlow.puma"
  {
# line 1203 "ControlFlow.puma"
   failure_protocol (MODULE, "TranslateIOStmt", t);
  }
   return NoTree;

}

static void AnalyseIOSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree specs)
# else
(specs)
 register tTree specs;
# endif
{
  if (specs->Kind == kBTP_LIST) {
# line 1215 "ControlFlow.puma"
  {
# line 1216 "ControlFlow.puma"
   AnalyseIOSpecs (specs->BTP_LIST.Elem);
# line 1217 "ControlFlow.puma"
   AnalyseIOSpecs (specs->BTP_LIST.Next);
  }
   return;

  }
  if (specs->Kind == kBTP_EMPTY) {
# line 1220 "ControlFlow.puma"
   return;

  }
  if (specs->Kind == kNAMED_PARAM) {
# line 1223 "ControlFlow.puma"
  {
# line 1224 "ControlFlow.puma"
   if (! ((specs->NAMED_PARAM.Name == MakeIdent ("ERR", 3)))) goto yyL3;
  {
# line 1225 "ControlFlow.puma"
   err_label = GetLabel (specs->NAMED_PARAM.VAL);
# line 1226 "ControlFlow.puma"
   is_label = true;
  }
  }
   return;
yyL3:;

# line 1229 "ControlFlow.puma"
  {
# line 1230 "ControlFlow.puma"
   if (! ((specs->NAMED_PARAM.Name == MakeIdent ("END", 3)))) goto yyL4;
  {
# line 1231 "ControlFlow.puma"
   end_label = GetLabel (specs->NAMED_PARAM.VAL);
# line 1232 "ControlFlow.puma"
   is_label = true;
  }
  }
   return;
yyL4:;

# line 1235 "ControlFlow.puma"
  {
# line 1236 "ControlFlow.puma"
   if (! ((specs->NAMED_PARAM.Name == MakeIdent ("EOR", 3)))) goto yyL5;
  {
# line 1237 "ControlFlow.puma"
   eor_label = GetLabel (specs->NAMED_PARAM.VAL);
# line 1238 "ControlFlow.puma"
   is_label = true;
  }
  }
   return;
yyL5:;

# line 1241 "ControlFlow.puma"
  {
# line 1242 "ControlFlow.puma"
   if (! ((specs->NAMED_PARAM.Name == MakeIdent ("IOSTAT", 6)))) goto yyL6;
  {
# line 1243 "ControlFlow.puma"
   GetIOStat (specs->NAMED_PARAM.VAL);
  }
  }
   return;
yyL6:;

  }
;
}

static int GetLabel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
# line 1254 "ControlFlow.puma"
   return GetLabel (t->VAR_PARAM.V->ADDR.E);

  }
  }
  if (t->Kind == kVALUE_PARAM) {
# line 1258 "ControlFlow.puma"
   return GetLabel (t->VALUE_PARAM.E);

  }
  if (t->Kind == kCONST_EXP) {
  if (t->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 1262 "ControlFlow.puma"
   return t->CONST_EXP.C->INT_CONSTANT.value;

  }
  }
# line 1266 "ControlFlow.puma"
  {
# line 1267 "ControlFlow.puma"
   error_protocol ("illegal label in IO statement");
# line 1268 "ControlFlow.puma"
   tree_protocol ("label is : ", t);
  }
   return 0;

}

static void GetIOStat
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 1280 "ControlFlow.puma"
  {
# line 1281 "ControlFlow.puma"
   io_stat = t->VAR_PARAM.V;
  }
   return;

  }
  }
  if (t->Kind == kVALUE_PARAM) {
  if (t->VALUE_PARAM.E->Kind == kVAR_EXP) {
  if (t->VALUE_PARAM.E->VAR_EXP.V->Kind == kUSED_VAR) {
# line 1284 "ControlFlow.puma"
  {
# line 1285 "ControlFlow.puma"
   io_stat = t->VALUE_PARAM.E->VAR_EXP.V;
  }
   return;

  }
  }
  }
# line 1288 "ControlFlow.puma"
  {
# line 1289 "ControlFlow.puma"
   error_protocol ("illegal IOSTAT in IO statement");
# line 1290 "ControlFlow.puma"
   tree_protocol ("IOSTAT var is : ", t);
  }
   return;

;
}

static tTree UpdateIOSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree specs)
# else
(specs)
 register tTree specs;
# endif
{
  if (specs->Kind == kBTP_LIST) {
# line 1301 "ControlFlow.puma"
  {
# line 1302 "ControlFlow.puma"
   if (! ((IsLabelSpec (specs->BTP_LIST.Elem)))) goto yyL1;
  }
   return UpdateIOSpecs (specs->BTP_LIST.Next);
yyL1:;

# line 1306 "ControlFlow.puma"
  {
# line 1307 "ControlFlow.puma"
 specs->BTP_LIST.Next = UpdateIOSpecs (specs->BTP_LIST.Next); 
  }
   return specs;

  }
  if (specs->Kind == kBTP_EMPTY) {
# line 1311 "ControlFlow.puma"
  {
# line 1313 "ControlFlow.puma"
   if (! ((io_stat == NoTree))) goto yyL3;
  {
# line 1315 "ControlFlow.puma"
   io_stat = GetScalarTemporary (MakeIntegerType (default_int_size));
  }
  }
   return mBTP_LIST (mNAMED_PARAM (MakeIdent ("IOSTAT", 6), mVAR_PARAM (CopyTree (io_stat))), specs);
yyL3:;

# line 1321 "ControlFlow.puma"
   return specs;

  }
# line 1325 "ControlFlow.puma"
  {
# line 1326 "ControlFlow.puma"
   failure_protocol (MODULE, "UpdateIOSpecs", specs);
  }
   return NoTree;

}

static bool IsLabelSpec
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kNAMED_PARAM) {
# line 1332 "ControlFlow.puma"
  {
# line 1333 "ControlFlow.puma"
   if (! ((spec->NAMED_PARAM.Name == MakeIdent ("ERR", 3)))) goto yyL1;
  }
   return true;
yyL1:;

# line 1336 "ControlFlow.puma"
  {
# line 1337 "ControlFlow.puma"
   if (! ((spec->NAMED_PARAM.Name == MakeIdent ("END", 3)))) goto yyL2;
  }
   return true;
yyL2:;

# line 1340 "ControlFlow.puma"
  {
# line 1341 "ControlFlow.puma"
   if (! ((spec->NAMED_PARAM.Name == MakeIdent ("EOR", 3)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static tTree MakeJumpStmt
# if defined __STDC__ | defined __cplusplus
(register tTree op, register int value, register int label)
# else
(op, value, label)
 register tTree op;
 register int value;
 register int label;
# endif
{
# line 1354 "ControlFlow.puma"
  {
# line 1355 "ControlFlow.puma"
   if (! ((label == 0))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 1359 "ControlFlow.puma"
 {
  tTree stmt;
  tTree condition;
  {
# line 1361 "ControlFlow.puma"

# line 1362 "ControlFlow.puma"

# line 1364 "ControlFlow.puma"
   stmt = mACF_BASIC (mGOTO_STMT (label));
# line 1365 "ControlFlow.puma"
   stmt = mACF_LIST (stmt, mACF_EMPTY ());
# line 1367 "ControlFlow.puma"
   condition = mOP_EXP (op, mVAR_EXP (CopyTree (io_stat)), MakeConstant (value));
# line 1370 "ControlFlow.puma"
   stmt = mACF_IF (condition, stmt, mACF_EMPTY ());
  }
  {
   return stmt;
  }
 }

}

void BeginControlFlow ()
{
}

void CloseControlFlow ()
{
}
