# include "Common.h"
# include "yyCommon.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 67 "Common.puma"


# define  MODULE "Common"

# include "Idents.h"
# include "StringMem.h"
# include "Objects.h"
# include "Types.h"
# include "protocol.h"
# include "DefTable.h"
# include "TreeOps.h" 
# include "Distributions.h"
# include "Expressions.h"
# include "Shapes.h"

# define NO_ERROR    0
# define SEQ_ERROR   1

static int error;          /* indicates an error            */
static int seq_diff;       /* difference in sequential size */

static int overlap_error;



static void yyExit () { Exit (1); }

void (* Common_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Common, routine %s failed\n", yyFunction);
 Common_Exit ();
}

void CheckCommonBlock ARGS((tTree t, bool is_main));
void CheckCommonDescriptors ARGS((tTree t, CompareRoutine p));
static void CompareGlobalLocal ARGS((tDefinitions t, tTree common, bool is_main));
static int CommonEntries ARGS((tTree cd));
static int GetCommonSize ARGS((tTree t));
static int GetTypeSize ARGS((tTree t));
static int GetIndexSize ARGS((tTree t));
static void MatchCommonBlocks ARGS((tDefinitions t, tTree common, CompareRoutine p));
static void MatchForDescriptors ARGS((tTree global, tTree local, tDefinitions scope, int diff, CompareRoutine p));
void CheckActualDescriptors ARGS((tTree t, CompareRoutine p));
static int GetObjSize ARGS((tDefinitions obj));
static bool IsSequential ARGS((tDefinitions obj));
void PrintCommonBlock ARGS((tTree decl, int dist_flag));
static void PrintCommonData ARGS((tTree decl, tDefinitions scope, int dist_flag));
void PrintCall ARGS((tTree call));
static void PrintParameters ARGS((tTree actuals, tTree dummies, tDefinitions dscope));
static void PrintParam ARGS((tTree actual, tDefinitions dummy));
static void MatchParameterList ARGS((tTree actuals, tTree dummies, tDefinitions dscope, CompareRoutine cp));
static void MatchSingleParameter ARGS((tTree actual, tDefinitions dummy, CompareRoutine p));
static void GetFullVarObject ARGS((tTree param, bool * yyP2, tDefinitions * yyP1));

void CheckCommonBlock
# if defined __STDC__ | defined __cplusplus
(register tTree t, register bool is_main)
# else
(t, is_main)
 register tTree t;
 register bool is_main;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
# line 103 "Common.puma"
 {
  tDefinitions global;
  {
# line 105 "Common.puma"

# line 107 "Common.puma"
   global = GetDeclEntry (t->COMMON_DECL.Ident, GetCommonEntries ());
# line 109 "Common.puma"
   CompareGlobalLocal (global, t, is_main);
  }
   return;
 }

  }
# line 112 "Common.puma"
  {
# line 113 "Common.puma"
   failure_protocol (MODULE, "CheckCommonBlock", t);
  }
   return;

;
}

void CheckCommonDescriptors
# if defined __STDC__ | defined __cplusplus
(register tTree t, CompareRoutine p)
# else
(t, p)
 register tTree t;
 CompareRoutine p;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
# line 127 "Common.puma"
 {
  tDefinitions global;
  {
# line 129 "Common.puma"

# line 131 "Common.puma"
   global = GetDeclEntry (t->COMMON_DECL.Ident, GetCommonEntries ());
# line 133 "Common.puma"
   MatchCommonBlocks (global, t, p);
  }
   return;
 }

  }
# line 136 "Common.puma"
  {
# line 137 "Common.puma"
   failure_protocol (MODULE, "CheckCommonDescriptors", t);
  }
   return;

;
}

static void CompareGlobalLocal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t, register tTree common, register bool is_main)
# else
(t, common, is_main)
 register tDefinitions t;
 register tTree common;
 register bool is_main;
# endif
{
# line 148 "Common.puma"

char msg[150];

# line 152 "Common.puma"
  {
# line 156 "Common.puma"
   if (! ((t == NoObject))) goto yyL1;
  {
# line 157 "Common.puma"
   tree_error_protocol ("No Object for Common", common);
  }
  }
   return;
yyL1:;

  if (t->Kind == kCommonObject) {
# line 160 "Common.puma"
  {
# line 163 "Common.puma"
   if (! ((t->CommonObject.decl == common))) goto yyL2;
  {
# line 166 "Common.puma"
 

     t->CommonObject.size     = GetCommonSize     (common);
     t->CommonObject.distributed_vars = 0;
     t->CommonObject.main     = is_main;

   
  }
  }
   return;
yyL2:;

# line 175 "Common.puma"
 {
  int size;
  {
# line 178 "Common.puma"
   if (! ((t->CommonObject.decl != common))) goto yyL3;
  {
# line 182 "Common.puma"

# line 184 "Common.puma"
 t->CommonObject.main = t->CommonObject.main || is_main;

         

     size = GetCommonSize (common);

     if (size != t->CommonObject.size)

       { simple_warning_protocol
              ("incompatible lengths for common block data");
         PrintCommonBlock (common, 0);
         sprintf (msg,"acutal has size %d , reference has size %d", 
                       size, t->CommonObject.size);
         print_protocol (msg);
       }
 
     if (CommonEntries (common) != CommonEntries (t->CommonObject.decl))
 
       { simple_warning_protocol
              ("different number of entries for common block data");
         PrintCommonBlock (common, 0);
         sprintf (msg,"acutal has %d entries, reference has %d entries", 
                       CommonEntries (common), CommonEntries (t->CommonObject.decl));
         print_protocol (msg);
       }
 
   
  }
  }
   return;
 }
yyL3:;

  }
# line 213 "Common.puma"
  {
# line 214 "Common.puma"
   failure_protocol (MODULE, "CheckGlobalLocal", common);
  }
   return;

;
}

static int CommonEntries
# if defined __STDC__ | defined __cplusplus
(register tTree cd)
# else
(cd)
 register tTree cd;
# endif
{
  if (cd->Kind == kCOMMON_DECL) {
# line 225 "Common.puma"
   return TreeListLength (cd->COMMON_DECL.IDS);

  }
 yyAbort ("CommonEntries");
}

static int GetCommonSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
# line 242 "Common.puma"
   return GetCommonSize (t->COMMON_DECL.IDS);

  }
  if (t->Kind == kDECL_LIST) {
# line 246 "Common.puma"
   return GetCommonSize (t->DECL_LIST.Elem) + GetCommonSize (t->DECL_LIST.Next);

  }
  if (t->Kind == kDECL_EMPTY) {
# line 250 "Common.puma"
   return 0;

  }
  if (t->Kind == kVAR_DECL) {
# line 254 "Common.puma"
 {
  tDefinitions Obj;
  {
# line 258 "Common.puma"

# line 259 "Common.puma"
   Obj = GetLocalObject (t->VAR_DECL.Ident);
  }
  {
   return GetTypeSize (Obj->VarObject.decl);
  }
 }

  }
# line 264 "Common.puma"
  {
# line 265 "Common.puma"
   failure_protocol (MODULE, "GetCommonSize", t);
  }
   return 0;

}

static int GetTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
# line 275 "Common.puma"
   return GetTypeSize (t->VAR_DECL.VAL);

  }
  if (t->Kind == kARRAY_TYPE) {
# line 279 "Common.puma"
   return GetIndexSize (t->ARRAY_TYPE.ARRAY_INDEX_TYPES) * TreeSize (t->ARRAY_TYPE.ARRAY_COMP_TYPE);

  }
# line 283 "Common.puma"
   return TreeSize (t);

}

static int GetIndexSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHAPE_LIST) {
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
# line 293 "Common.puma"
   return GetIndexSize (t->SHAPE_LIST.Elem);

  }
# line 297 "Common.puma"
   return GetIndexSize (t->SHAPE_LIST.Elem) * GetIndexSize (t->SHAPE_LIST.Next);

  }
  if (t->Kind == kEXPLICIT_SHAPE) {
# line 301 "Common.puma"
 {
  int lval;
  int hval;
  int size;
  bool found;
  {
# line 303 "Common.puma"

# line 304 "Common.puma"

# line 305 "Common.puma"

# line 306 "Common.puma"

# line 308 "Common.puma"
   GetIntConstValue (t->EXPLICIT_SHAPE.LOWER, & found, & lval);
# line 309 "Common.puma"
   if (! (found)) goto yyL3;
  {
# line 310 "Common.puma"
   GetIntConstValue (t->EXPLICIT_SHAPE.UPPER, & found, & hval);
# line 311 "Common.puma"
   if (! (found)) goto yyL3;
  {
# line 312 "Common.puma"
   size = hval - lval + 1;
  }
  }
  }
  {
   return size;
  }
 }
yyL3:;

  }
  if (Tree_IsType (t, kSHAPE_SPEC)) {
# line 316 "Common.puma"
   return 0;

  }
# line 320 "Common.puma"
  {
# line 321 "Common.puma"
   failure_protocol (MODULE, "GetIndexSize", t);
  }
   return 0;

}

static void MatchCommonBlocks
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t, register tTree common, CompareRoutine p)
# else
(t, common, p)
 register tDefinitions t;
 register tTree common;
 CompareRoutine p;
# endif
{
# line 333 "Common.puma"

char msg[150];

# line 337 "Common.puma"
  {
# line 341 "Common.puma"
   if (! ((t == NoObject))) goto yyL1;
  {
# line 342 "Common.puma"
   tree_error_protocol ("No Object for Common", common);
  }
  }
   return;
yyL1:;

  if (t->Kind == kCommonObject) {
# line 345 "Common.puma"
  {
# line 347 "Common.puma"
   if (! ((t->CommonObject.decl == common))) goto yyL2;
  }
   return;
yyL2:;

# line 350 "Common.puma"
  {
# line 353 "Common.puma"
   error = NO_ERROR;
# line 355 "Common.puma"
   MatchForDescriptors (t->CommonObject.decl, common, t->CommonObject.CommonElements, 0, p);
# line 357 "Common.puma"
 if (error == SEQ_ERROR)

      { simple_error_protocol ("COMMON BLOCK mismatch of sequential data");
        PrintCommonBlock (common, 1);  
        sprintf (msg, "difference for sequential data : %d", seq_diff);
        print_protocol (msg);
      }
   
  }
   return;

  }
# line 367 "Common.puma"
  {
# line 368 "Common.puma"
   failure_protocol (MODULE, "MatchCommonBlocks", common);
  }
   return;

;
}

static void MatchForDescriptors
# if defined __STDC__ | defined __cplusplus
(register tTree global, register tTree local, register tDefinitions scope, register int diff, CompareRoutine p)
# else
(global, local, scope, diff, p)
 register tTree global;
 register tTree local;
 register tDefinitions scope;
 register int diff;
 CompareRoutine p;
# endif
{
  if (global->Kind == kCOMMON_DECL) {
  if (local->Kind == kCOMMON_DECL) {
# line 384 "Common.puma"
  {
# line 386 "Common.puma"
   MatchForDescriptors (global->COMMON_DECL.IDS, local->COMMON_DECL.IDS, scope, diff, p);
  }
   return;

  }
  }
  if (global->Kind == kDECL_LIST) {
# line 389 "Common.puma"
 {
  tDefinitions global_obj;
  {
# line 391 "Common.puma"

# line 393 "Common.puma"
   global_obj = GetDeclEntry (global->DECL_LIST.Elem->DECL_NODE.Ident, scope);
# line 395 "Common.puma"
   if (! ((IsSequential (global_obj)))) goto yyL2;
  {
# line 397 "Common.puma"
   MatchForDescriptors (global->DECL_LIST.Next, local, scope, diff - GetObjSize (global_obj), p);
  }
  }
   return;
 }
yyL2:;

  if (local->Kind == kDECL_LIST) {
# line 413 "Common.puma"
  {
# line 416 "Common.puma"
   if (! ((diff == 0))) goto yyL4;
  {
# line 420 "Common.puma"
   p (GetLocalObject (local->DECL_LIST.Elem->DECL_NODE.Ident), GetDeclEntry (global->DECL_LIST.Elem->DECL_NODE.Ident, scope));
# line 422 "Common.puma"
   MatchForDescriptors (global->DECL_LIST.Next, local->DECL_LIST.Next, scope, diff, p);
  }
  }
   return;
yyL4:;

  }
  }
  if (local->Kind == kDECL_LIST) {
# line 401 "Common.puma"
 {
  tDefinitions local_obj;
  {
# line 403 "Common.puma"

# line 405 "Common.puma"
   local_obj = GetLocalObject (local->DECL_LIST.Elem->DECL_NODE.Ident);
# line 407 "Common.puma"
   if (! ((IsSequential (local_obj)))) goto yyL3;
  {
# line 409 "Common.puma"
   MatchForDescriptors (global, local->DECL_LIST.Next, scope, diff + GetObjSize (local_obj), p);
  }
  }
   return;
 }
yyL3:;

  }
  if (global->Kind == kDECL_EMPTY) {
  if (local->Kind == kDECL_EMPTY) {
# line 425 "Common.puma"
   return;

  }
  }
# line 431 "Common.puma"
  {
# line 437 "Common.puma"
   error = SEQ_ERROR;
# line 438 "Common.puma"
   seq_diff = diff;
  }
   return;

;
}

void CheckActualDescriptors
# if defined __STDC__ | defined __cplusplus
(register tTree t, CompareRoutine p)
# else
(t, p)
 register tTree t;
 CompareRoutine p;
# endif
{
  if (t->Kind == kCALL_STMT) {
# line 451 "Common.puma"
 {
  tTree Dummies;
  tDefinitions DummyScope;
  tDefinitions RefObject;
  {
# line 455 "Common.puma"

# line 456 "Common.puma"

# line 457 "Common.puma"

# line 459 "Common.puma"
   RefObject = GetReferenceObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Object);
# line 461 "Common.puma"
   if (! ((RefObject != NoObject))) goto yyL1;
  {
# line 465 "Common.puma"
   GetDummies (RefObject, & Dummies, & DummyScope);
# line 467 "Common.puma"
   error = NO_ERROR;
# line 469 "Common.puma"
 if ((Dummies == NoTree) || (DummyScope == NoDefinitions))
         { stmt_protocol ("illegal reference");
           obj_protocol ("call      object: ", t->CALL_STMT.CALL_ID->PROC_OBJ.Object);
           obj_protocol ("reference object: ", RefObject);
         }
       else
         MatchParameterList (t->CALL_STMT.CALL_PARAMS, Dummies, DummyScope, p);
    
# line 478 "Common.puma"
 if (error != NO_ERROR)
         { simple_error_protocol ("MISMATCH of ACTUALS/DUMMIES");
           PrintCall (t);
         }
    
  }
  }
   return;
 }
yyL1:;

# line 485 "Common.puma"
   return;

  }
  if (t->Kind == kFUNC_CALL_EXP) {
# line 490 "Common.puma"
 {
  tTree Dummies;
  tDefinitions DummyScope;
  tDefinitions RefObject;
  {
# line 494 "Common.puma"

# line 495 "Common.puma"

# line 496 "Common.puma"

# line 498 "Common.puma"
   RefObject = GetReferenceObject (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object);
# line 500 "Common.puma"
   if (! ((RefObject != NoObject))) goto yyL3;
  {
# line 502 "Common.puma"
   GetDummies (RefObject, & Dummies, & DummyScope);
# line 504 "Common.puma"
   error = NO_ERROR;
# line 506 "Common.puma"
 if ((Dummies == NoTree) || (DummyScope == NoDefinitions))

         { stmt_protocol ("illegal reference");
           obj_protocol ("call      object: ", t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object);
           obj_protocol ("reference object: ", RefObject);
         }

       else
         MatchParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS, Dummies, DummyScope, p);
    
# line 517 "Common.puma"
 if (error != NO_ERROR)
         { simple_error_protocol ("MISMATCH of ACTUALS/DUMMIES");
           PrintCall (t);
         }
    
  }
  }
   return;
 }
yyL3:;

# line 524 "Common.puma"
   return;

  }
# line 527 "Common.puma"
  {
# line 528 "Common.puma"
   failure_protocol (MODULE, "CheckActualDescriptors", t);
  }
   return;

;
}

static int GetObjSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 544 "Common.puma"
  {
# line 545 "Common.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 546 "Common.puma"
   failure_protocol (MODULE, "GetObjSize", NoTree);
  }
  }
   return 0;
yyL1:;

# line 550 "Common.puma"
   return GetTypeSize (obj->Object.decl);

}

static bool IsSequential
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 556 "Common.puma"
  {
# line 557 "Common.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 558 "Common.puma"
   failure_protocol (MODULE, "IsSequential", NoTree);
  }
  }
   return true;
yyL1:;

# line 561 "Common.puma"
  {
# line 562 "Common.puma"
   if (! ((VarDistribution (obj) == 0))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

void PrintCommonBlock
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register int dist_flag)
# else
(decl, dist_flag)
 register tTree decl;
 register int dist_flag;
# endif
{
  if (decl->Kind == kCOMMON_DECL) {
# line 577 "Common.puma"
 {
  tDefinitions global;
  {
# line 579 "Common.puma"

# line 581 "Common.puma"
   global = GetDeclEntry (decl->COMMON_DECL.Ident, GetCommonEntries ());
# line 583 "Common.puma"
   tree_protocol ("actual common block    :\n", decl);
# line 585 "Common.puma"
   PrintCommonData (decl, GetCurrentScope (), dist_flag);
# line 587 "Common.puma"
   tree_protocol ("reference common block :\n", global->CommonObject.decl);
# line 589 "Common.puma"
   PrintCommonData (global->CommonObject.decl, global->CommonObject.CommonElements, dist_flag);
  }
   return;
 }

  }
# line 592 "Common.puma"
  {
# line 594 "Common.puma"
   failure_protocol (MODULE, "PrintCommonBlock", decl);
  }
   return;

;
}

static void PrintCommonData
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions scope, register int dist_flag)
# else
(decl, scope, dist_flag)
 register tTree decl;
 register tDefinitions scope;
 register int dist_flag;
# endif
{
# line 599 "Common.puma"

char msg[150], string[100];

  if (decl->Kind == kCOMMON_DECL) {
# line 603 "Common.puma"
  {
# line 605 "Common.puma"
   PrintCommonData (decl->COMMON_DECL.IDS, scope, dist_flag);
# line 606 "Common.puma"
   print_protocol ("");
  }
   return;

  }
  if (decl->Kind == kDECL_LIST) {
# line 609 "Common.puma"
 {
  tDefinitions obj;
  int size;
  int is_dist;
  {
# line 611 "Common.puma"

# line 612 "Common.puma"

# line 613 "Common.puma"

# line 615 "Common.puma"
   obj = GetDeclEntry (decl->DECL_LIST.Elem->DECL_NODE.Ident, scope);
# line 616 "Common.puma"
   size = GetObjSize (obj);
# line 618 "Common.puma"
 GetString (decl->DECL_LIST.Elem->DECL_NODE.Ident, string);
  
     is_dist = 0;     

     if (dist_flag) 
        if (!IsSequential(obj)) is_dist = 1;

     if (is_dist)
        sprintf (msg, "         %s : %d bytes", string, size);
      else
        sprintf (msg, "         %s : %d bytes, mapped", string, size);

     print_protocol (msg);
   
# line 633 "Common.puma"
   PrintCommonData (decl->DECL_LIST.Next, scope, dist_flag);
  }
   return;
 }

  }
  if (decl->Kind == kDECL_EMPTY) {
# line 636 "Common.puma"
   return;

  }
# line 639 "Common.puma"
  {
# line 641 "Common.puma"
   failure_protocol (MODULE, "PrintCommonData", decl);
  }
   return;

;
}

void PrintCall
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
# line 654 "Common.puma"
 {
  tTree Dummies;
  tDefinitions DummyScope;
  {
# line 656 "Common.puma"
   tree_protocol ("subroutine call is : ", call);
# line 658 "Common.puma"

# line 659 "Common.puma"

# line 661 "Common.puma"
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetDeclEntry (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetUnitEntries ())))) goto yyL1;
  {
# line 663 "Common.puma"
   GetDummies (call->CALL_STMT.CALL_ID->PROC_OBJ.Object, & Dummies, & DummyScope);
# line 665 "Common.puma"
   PrintParameters (call->CALL_STMT.CALL_PARAMS, Dummies, DummyScope);
  }
  }
   return;
 }
yyL1:;

# line 668 "Common.puma"
  {
# line 670 "Common.puma"
   tree_protocol ("subroutine call is : ", call);
# line 671 "Common.puma"
   print_protocol ("no dummies are available");
  }
   return;

  }
  if (call->Kind == kFUNC_CALL_EXP) {
# line 674 "Common.puma"
 {
  tTree Dummies;
  tDefinitions DummyScope;
  {
# line 676 "Common.puma"
   tree_protocol ("function call is : ", call);
# line 678 "Common.puma"

# line 679 "Common.puma"

# line 681 "Common.puma"
   if (! ((call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == GetDeclEntry (call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, GetUnitEntries ())))) goto yyL3;
  {
# line 683 "Common.puma"
   GetDummies (call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object, & Dummies, & DummyScope);
# line 685 "Common.puma"
   PrintParameters (call->FUNC_CALL_EXP.FUNC_PARAMS, Dummies, DummyScope);
  }
  }
   return;
 }
yyL3:;

# line 688 "Common.puma"
  {
# line 690 "Common.puma"
   tree_protocol ("function call is : ", call);
# line 691 "Common.puma"
   print_protocol ("no dummies are available");
  }
   return;

  }
# line 694 "Common.puma"
  {
# line 695 "Common.puma"
   failure_protocol (MODULE, "PrintCall", call);
  }
   return;

;
}

static void PrintParameters
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree dummies, register tDefinitions dscope)
# else
(actuals, dummies, dscope)
 register tTree actuals;
 register tTree dummies;
 register tDefinitions dscope;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
  if (dummies->Kind == kDECL_LIST) {
  if (dummies->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
# line 701 "Common.puma"
  {
# line 704 "Common.puma"
   PrintParam (actuals->BTP_LIST.Elem, GetDeclEntry (dummies->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, dscope));
# line 705 "Common.puma"
   PrintParameters (actuals->BTP_LIST.Next, dummies->DECL_LIST.Next, dscope);
  }
   return;

  }
  }
  if (dummies->Kind == kDECL_EMPTY) {
# line 714 "Common.puma"
  {
# line 716 "Common.puma"
   PrintParam (actuals->BTP_LIST.Elem, NoObject);
# line 717 "Common.puma"
   PrintParameters (actuals->BTP_LIST.Next, dummies, dscope);
  }
   return;

  }
  }
  if (actuals->Kind == kBTP_EMPTY) {
  if (dummies->Kind == kDECL_LIST) {
  if (dummies->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
# line 708 "Common.puma"
  {
# line 710 "Common.puma"
   PrintParam (NoTree, GetDeclEntry (dummies->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, dscope));
# line 711 "Common.puma"
   PrintParameters (actuals, dummies->DECL_LIST.Next, dscope);
  }
   return;

  }
  }
  if (dummies->Kind == kDECL_EMPTY) {
# line 720 "Common.puma"
   return;

  }
  }
# line 723 "Common.puma"
  {
# line 724 "Common.puma"
   failure2_protocol (MODULE, "PrintParameters", actuals, dummies);
  }
   return;

;
}

static void PrintParam
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tDefinitions dummy)
# else
(actual, dummy)
 register tTree actual;
 register tDefinitions dummy;
# endif
{
# line 729 "Common.puma"
  {
# line 731 "Common.puma"
   if (! ((dummy == NoObject))) goto yyL1;
  {
# line 733 "Common.puma"
   tree_protocol ("  actual : ", actual);
# line 734 "Common.puma"
   print_protocol ("  dummy  : --");
# line 735 "Common.puma"
   print_protocol ("");
  }
  }
   return;
yyL1:;

# line 738 "Common.puma"
  {
# line 739 "Common.puma"
   tree_protocol ("  actual : ", actual);
# line 740 "Common.puma"
   tree_protocol ("  dummy  : ", dummy->Object.decl);
  }
   return;

;
}

static void MatchParameterList
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree dummies, register tDefinitions dscope, CompareRoutine cp)
# else
(actuals, dummies, dscope, cp)
 register tTree actuals;
 register tTree dummies;
 register tDefinitions dscope;
 CompareRoutine cp;
# endif
{
# line 754 "Common.puma"
  {
# line 756 "Common.puma"
   if (! ((TreeListLength (actuals) != TreeListLength (dummies)))) goto yyL1;
  {
# line 758 "Common.puma"
   error_protocol ("mismatch of actual parameters with their dummies");
# line 759 "Common.puma"
   tree_protocol ("actuals : ", actuals);
# line 760 "Common.puma"
   tree_protocol ("dummies : ", dummies);
  }
  }
   return;
yyL1:;

  if (actuals->Kind == kBTP_LIST) {
  if (dummies->Kind == kDECL_LIST) {
  if (dummies->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
# line 763 "Common.puma"
  {
# line 766 "Common.puma"
   MatchSingleParameter (actuals->BTP_LIST.Elem, GetDeclEntry (dummies->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, dscope), cp);
# line 767 "Common.puma"
   MatchParameterList (actuals->BTP_LIST.Next, dummies->DECL_LIST.Next, dscope, cp);
  }
   return;

  }
  }
  }
  if (actuals->Kind == kBTP_EMPTY) {
  if (dummies->Kind == kDECL_EMPTY) {
# line 770 "Common.puma"
   return;

  }
  }
# line 774 "Common.puma"
  {
# line 778 "Common.puma"
   failure2_protocol (MODULE, "MatchParameterList", actuals, dummies);
  }
   return;

;
}

static void MatchSingleParameter
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tDefinitions dummy, CompareRoutine p)
# else
(actual, dummy, p)
 register tTree actual;
 register tDefinitions dummy;
 CompareRoutine p;
# endif
{
  if (actual->Kind == kNO_PARAM) {
# line 793 "Common.puma"
   return;

  }
# line 796 "Common.puma"
  {
# line 798 "Common.puma"
   if (! ((dummy == NoObject))) goto yyL2;
  {
# line 800 "Common.puma"
 error_protocol ("dummy not found");
      tree_protocol ("acual argument is : ", actual);
    
  }
  }
   return;
yyL2:;

  if (actual->Kind == kVAR_PARAM) {
# line 805 "Common.puma"
 {
  bool yyV1;
  tDefinitions yyV2;
  {
# line 807 "Common.puma"
   GetFullVarObject (actual->VAR_PARAM.V, & yyV1, & yyV2);
# line 808 "Common.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 810 "Common.puma"
   p (yyV2, dummy);
  }
  }
   return;
 }
yyL3:;

  }
# line 813 "Common.puma"
  {
# line 815 "Common.puma"
   tree_protocol ("not applied for this actual argument : ", actual);
  }
   return;

;
}

static void GetFullVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree param, register bool * yyP2, register tDefinitions * yyP1)
# else
(param, yyP2, yyP1)
 register tTree param;
 register bool * yyP2;
 register tDefinitions * yyP1;
# endif
{
  if (param->Kind == kVAR_PARAM) {
# line 826 "Common.puma"
 {
  bool yyV1;
  tDefinitions yyV2;
  {
# line 828 "Common.puma"
   GetFullVarObject (param->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (param->Kind == kUSED_VAR) {
# line 831 "Common.puma"
   * yyP2 = true;
   * yyP1 = param->USED_VAR.VARNAME->VAR_OBJ.Object;
   return;

  }
  if (param->Kind == kINDEXED_VAR) {
# line 834 "Common.puma"
 {
  bool yyV1;
  tDefinitions yyV2;
  {
# line 836 "Common.puma"
   if (! ((IsWholeVar (param)))) goto yyL3;
  {
# line 838 "Common.puma"
   GetFullVarObject (param->INDEXED_VAR.IND_VAR, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

  }
# line 841 "Common.puma"
   * yyP2 = false;
   * yyP1 = NoObject;
   return;

;
}

void BeginCommon ()
{
}

void CloseCommon ()
{
}
