# include "CodeVars.h"
# include "yyCodeVars.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 55 "CodeVars.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Objects.h"
# include "Rank.h"             /* VarSize, VarRank, ...         */
# include "Transform.h"         /* CombineACF, ....              */
# include "TreeOps.h"
# include "Dalib.h"             /* MakeVarDecl, ...              */
# include "TriDenT.h"         
# include "DefTable.h"         
# include "FArguments.h"         

# include "Expressions.h"       /* AddConstant, MakeConstant     */

# include "Distributions.h"     /* DimListLength      */

# include "Nesting.h"
# include "CodeMapping.h"       /* DalibArrayCreate   */
# include "CodeGeneral.h"       /* DalibArrayCreate   */
# include "BuildTree.h"         /* ConcatDecls        */

tTree NewDefines;                /* stmts for a_low, a_high, a_os */

# define MODULE "CodeVars"

# define maddr_type MakeIntegerType (default_addr_size)



static void yyExit () { Exit (1); }

void (* CodeVars_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeVars, routine %s failed\n", yyFunction);
 CodeVars_Exit ();
}

tTree CodeProcDecl ARGS((tDefinitions t));
static tTree MakeDSPDecl ARGS((tTree var));
tTree CodeTemplateDecl ARGS((tTree temp, tDefinitions obj));
tTree CodeRaggedDecl ARGS((tTree decl, tDefinitions obj));
tTree CodeVarDecl ARGS((tTree var, tDefinitions obj));
static void SetUpOverlap ARGS((tTree t));
static void SetUpOverlapk ARGS((tTree t, int ndim));
static tTree MakeNewLocalRange ARGS((tTree val, int sdims, int maxsize));
tTree AdaptCommonVarDecl ARGS((tTree v, int dist));
tTree AdaptCreateDsp ARGS((tTree var, tTree indexes, int kind));
tTree AdaptInheritDsp ARGS((tTree var, tTree indexes, int kind, int safe));
tTree AdaptFreeDsp ARGS((tTree var, int kind));
static tTree CreateDescriptor ARGS((tTree var, tDefinitions obj, tTree indexes, int kind));
static tTree InheritDescriptor ARGS((tTree var, tDefinitions obj, tTree indexes, int kind));
static tTree FreeDescriptor ARGS((tTree var, tDefinitions obj, int kind));
tTree AdaptAllocate ARGS((tTree t));
static tTree AdaptAllocate1 ARGS((tTree v, int dist));
tTree AdaptDeallocate ARGS((tTree t));
static tTree AdaptDeallocate1 ARGS((tTree v));
static tTree DefineDistribution ARGS((tTree var, tDefinitions obj, int alloc_kind));
static bool IsAvailable ARGS((tDefinitions obj));
static tTree DescriptorAllocate ARGS((tTree var, tTree indexes, tDefinitions obj));
static tTree MakeAllocateStmt ARGS((tTree var));
static tTree MakeDeallocateStmt ARGS((tTree var));
tTree CodeRedistribute ARGS((tTree distributee, tDefinitions dist));
tTree CodeRealign ARGS((tTree alignee, tDefinitions dist));
static void ResetObjDistribution ARGS((tDefinitions obj, tDefinitions n, tDefinitions * yyP1));
tTree CodeDirtyStmt ARGS((tTree dirty_vars));

tTree CodeProcDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kTopologyObject) {
# line 102 "CodeVars.puma"
  {
# line 104 "CodeVars.puma"
   if (! ((t->TopologyObject.Ident == DefaultId ()))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 108 "CodeVars.puma"
  {
# line 112 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return NoTree;
yyL2:;

  if (t->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
# line 116 "CodeVars.puma"
 {
  tTree dsp;
  tTree topid;
  {
# line 119 "CodeVars.puma"

# line 120 "CodeVars.puma"

# line 122 "CodeVars.puma"
   dsp = MakeDSPDecl (t->TopologyObject.decl);
# line 123 "CodeVars.puma"
   topid = MakeVarDeclA (t->TopologyObject.Ident, "_TOPID", MakeIntegerType (default_int_size));
  }
  {
   return mDECL_LIST (dsp, mDECL_LIST (topid, NoTree));
  }
 }

  }
  }
# line 128 "CodeVars.puma"
  {
# line 130 "CodeVars.puma"
   obj_error_protocol ("Illegal Object in CodeProcDecl", t);
  }
   return NoTree;

}

static tTree MakeDSPDecl
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kVAR_DECL) {
# line 168 "CodeVars.puma"
   return MakeVarDeclA (var->VAR_DECL.Ident, "_DSP", maddr_type);

  }
  if (var->Kind == kRAGGED_DECL) {
# line 173 "CodeVars.puma"
   return MakeVarDeclA (var->RAGGED_DECL.Ident, "_DSP", maddr_type);

  }
  if (var->Kind == kPROCESSORS_DECL) {
# line 178 "CodeVars.puma"
   return MakeVarDeclA (var->PROCESSORS_DECL.Ident, "_DSP", maddr_type);

  }
# line 183 "CodeVars.puma"
  {
# line 184 "CodeVars.puma"
   failure_protocol (MODULE, "MakeDSPDecl", var);
  }
   return NoTree;

}

tTree CodeTemplateDecl
# if defined __STDC__ | defined __cplusplus
(register tTree temp, register tDefinitions obj)
# else
(temp, obj)
 register tTree temp;
 register tDefinitions obj;
# endif
{
# line 196 "CodeVars.puma"
  {
# line 198 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 203 "CodeVars.puma"
  {
# line 205 "CodeVars.puma"
   if (! ((VarDistribution (obj) == 0))) goto yyL2;
  }
   return NoTree;
yyL2:;

# line 211 "CodeVars.puma"
   return DistributionDecls (obj);

}

tTree CodeRaggedDecl
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions obj)
# else
(decl, obj)
 register tTree decl;
 register tDefinitions obj;
# endif
{
# line 224 "CodeVars.puma"
   return MakeDSPDecl (decl);

}

tTree CodeVarDecl
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj)
# else
(var, obj)
 register tTree var;
 register tDefinitions obj;
# endif
{
  if (var->Kind == kVAR_DECL) {
# line 251 "CodeVars.puma"
 {
  tTree new;
  {
# line 253 "CodeVars.puma"
   if (! ((FixedSizeArray (obj)))) goto yyL1;
  {
# line 255 "CodeVars.puma"

# line 257 "CodeVars.puma"
   new = mDECL_LIST (MakeDSPDecl (var), NoTree);
# line 259 "CodeVars.puma"
 if (VarDistribution (obj) != -1)

      { 

        SetUpOverlap (var->VAR_DECL.VAL);
        new = mDECL_LIST (var, new);
      }
   
  }
  }
  {
   return new;
  }
 }
yyL1:;

  }
# line 271 "CodeVars.puma"
   return ConcatDecls (DistributionDecls (obj), mDECL_LIST (var, NoTree));

}

static void SetUpOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kARRAY_TYPE) {
# line 296 "CodeVars.puma"
  {
# line 297 "CodeVars.puma"
   SetUpOverlapk (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, TreeListLength (t->ARRAY_TYPE.ARRAY_INDEX_TYPES));
  }
   return;

  }
# line 300 "CodeVars.puma"
  {
# line 301 "CodeVars.puma"
   failure_protocol (MODULE, "SetUpOverlap", t);
  }
   return;

;
}

static void SetUpOverlapk
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int ndim)
# else
(t, ndim)
 register tTree t;
 register int ndim;
# endif
{
  if (t->Kind == kARRAY_TYPE) {
# line 306 "CodeVars.puma"
  {
# line 308 "CodeVars.puma"
   SetUpOverlapk (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, ndim);
  }
   return;

  }
  if (t->Kind == kSHAPE_EMPTY) {
# line 311 "CodeVars.puma"
   return;

  }
  if (t->Kind == kSHAPE_LIST) {
# line 314 "CodeVars.puma"
  {
# line 316 "CodeVars.puma"
   if (! ((ndim == 0))) goto yyL3;
  }
   return;
yyL3:;

  if (t->SHAPE_LIST.Elem->Kind == kEXPLICIT_SHAPE) {
# line 319 "CodeVars.puma"
  {
# line 322 "CodeVars.puma"
 t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.LOWER = AddConstant (t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.LOWER, -t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.Overlap->OVERLAP_SPEC.left_size);
      t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.UPPER  = AddConstant (t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.UPPER,  t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.Overlap->OVERLAP_SPEC.right_size);
    
# line 325 "CodeVars.puma"
   SetUpOverlapk (t->SHAPE_LIST.Next, ndim - 1);
  }
   return;

  }
# line 328 "CodeVars.puma"
  {
# line 330 "CodeVars.puma"
   SetUpOverlapk (t->SHAPE_LIST.Next, ndim);
  }
   return;

  }
# line 333 "CodeVars.puma"
  {
# line 334 "CodeVars.puma"
   failure_protocol (MODULE, "SetUpOverlapk", t);
  }
   return;

;
}

static tTree MakeNewLocalRange
# if defined __STDC__ | defined __cplusplus
(register tTree val, register int sdims, register int maxsize)
# else
(val, sdims, maxsize)
 register tTree val;
 register int sdims;
 register int maxsize;
# endif
{
  if (val->Kind == kARRAY_TYPE) {
# line 351 "CodeVars.puma"
   return mARRAY_TYPE (MakeNewLocalRange (val->ARRAY_TYPE.ARRAY_INDEX_TYPES, sdims, maxsize), val->ARRAY_TYPE.ARRAY_COMP_TYPE);

  }
  if (val->Kind == kSHAPE_LIST) {
# line 356 "CodeVars.puma"
  {
# line 357 "CodeVars.puma"
   if (! ((sdims > 0))) goto yyL2;
  }
   return mSHAPE_LIST (val->SHAPE_LIST.Elem, MakeNewLocalRange (val->SHAPE_LIST.Next, sdims - 1, maxsize));
yyL2:;

# line 361 "CodeVars.puma"
 {
  tTree new;
  {
# line 369 "CodeVars.puma"

# line 371 "CodeVars.puma"
 new = mEXPLICIT_SHAPE (MakeConstant (1), 
                             MakeConstant (maxsize));
      new->EXPLICIT_SHAPE.Overlap = mOVERLAP_SPEC (0, 0, 0, 0);
    
  }
  {
   return mSHAPE_LIST (new, mSHAPE_EMPTY ());
  }
 }

  }
# line 379 "CodeVars.puma"
  {
# line 380 "CodeVars.puma"
   failure_protocol (MODULE, "MakeNewLocalRange", val);
  }
   return NoTree;

}

tTree AdaptCommonVarDecl
# if defined __STDC__ | defined __cplusplus
(register tTree v, register int dist)
# else
(v, dist)
 register tTree v;
 register int dist;
# endif
{
  if (v->Kind == kVAR_DECL) {
  if (equalint (dist, 0)) {
# line 396 "CodeVars.puma"
   return v;

  }
 {
  tTree var_dsp;
  if (equalint (dist, 1)) {
# line 405 "CodeVars.puma"
  {
# line 407 "CodeVars.puma"

# line 409 "CodeVars.puma"
   var_dsp = MakeVarDeclA (v->VAR_DECL.Ident, COMMON_SUFFIX, mDUMMY_TYPE ());
  }
  {
   return mDECL_LIST (v, mDECL_LIST (var_dsp, NoTree));
  }

  }
 }
 {
  tTree var_dsp;
  if (equalint (dist, 2)) {
# line 414 "CodeVars.puma"
  {
# line 416 "CodeVars.puma"

# line 418 "CodeVars.puma"
   var_dsp = MakeVarDeclA (v->VAR_DECL.Ident, COMMON_SUFFIX, mDUMMY_TYPE ());
  }
  {
   return mDECL_LIST (v, mDECL_LIST (var_dsp, NoTree));
  }

  }
 }
  }
# line 423 "CodeVars.puma"
  {
# line 425 "CodeVars.puma"
   failure_protocol (MODULE, "AdaptCommonVarDecl", v);
  }
   return v;

}

tTree AdaptCreateDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree indexes, register int kind)
# else
(var, indexes, kind)
 register tTree var;
 register tTree indexes;
 register int kind;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 438 "CodeVars.puma"
   return CreateDescriptor (var, var->USED_VAR.VARNAME->VAR_OBJ.Object, indexes, kind);

  }
  if (var->Kind == kSELECTED_VAR) {
# line 443 "CodeVars.puma"
   return CreateDescriptor (var, var->SELECTED_VAR.SELECTOR->REC_COMP.Object, indexes, kind);

  }
# line 448 "CodeVars.puma"
  {
# line 450 "CodeVars.puma"
   failure_protocol (MODULE, "AdaptCreateDsp", var);
  }
   return NoTree;

}

tTree AdaptInheritDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree indexes, register int kind, register int safe)
# else
(var, indexes, kind, safe)
 register tTree var;
 register tTree indexes;
 register int kind;
 register int safe;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 457 "CodeVars.puma"
   return InheritDescriptor (var, var->USED_VAR.VARNAME->VAR_OBJ.Object, indexes, kind);

  }
  if (var->Kind == kSELECTED_VAR) {
# line 462 "CodeVars.puma"
   return InheritDescriptor (var, var->SELECTED_VAR.SELECTOR->REC_COMP.Object, indexes, kind);

  }
 yyAbort ("AdaptInheritDsp");
}

tTree AdaptFreeDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 469 "CodeVars.puma"
   return FreeDescriptor (var, var->USED_VAR.VARNAME->VAR_OBJ.Object, kind);

  }
  if (var->Kind == kSELECTED_VAR) {
# line 474 "CodeVars.puma"
   return FreeDescriptor (var, var->SELECTED_VAR.SELECTOR->REC_COMP.Object, kind);

  }
# line 479 "CodeVars.puma"
  {
# line 481 "CodeVars.puma"
   failure_protocol (MODULE, "AdaptFreeDsp", var);
  }
   return NoTree;

}

static tTree CreateDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register tTree indexes, register int kind)
# else
(var, obj, indexes, kind)
 register tTree var;
 register tDefinitions obj;
 register tTree indexes;
 register int kind;
# endif
{
  if (obj->Kind == kVarObject) {
# line 501 "CodeVars.puma"
 {
  tTree defines;
  {
# line 503 "CodeVars.puma"
   if (! ((IsRaggedVarObject (obj)))) goto yyL1;
  {
# line 505 "CodeVars.puma"

# line 507 "CodeVars.puma"
 

     defines = CombineACF (TriDenTArrayMakeDsp (var, kind), NoTree);

   
  }
  }
  {
   return defines;
  }
 }
yyL1:;

# line 516 "CodeVars.puma"
 {
  tTree defines;
  {
# line 518 "CodeVars.puma"

# line 520 "CodeVars.puma"
 

     defines = CombineACF (DalibArrayMakeDsp (var, kind), NoTree);

     

     defines = CombineACF (defines, DefineDistribution (var, obj, kind));

     defines = CombineACF (defines, DalibArrayDynamic (var, kind));

     defines = CombineACF (defines, DalibArrayTrace (var));

     if (kind != kALLOCATE_DSP)

        defines = CombineACF (defines, 
                              DalibArrayDefine (var, indexes, kind));

     defines = CombineACF (defines, DalibArrayOverlap (var, kind));

     defines = CombineACF (defines, DalibCopyIn (var, kind));

     if (kind != kALLOCATE_DSP)

        defines = CombineACF (defines, DalibArrayAllocate (var, kind));

   
  }
  {
   return defines;
  }
 }

  }
  if (obj->Kind == kTemplateObject) {
# line 550 "CodeVars.puma"
  {
# line 552 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 564 "CodeVars.puma"
 {
  tTree defines;
  {
# line 566 "CodeVars.puma"

# line 568 "CodeVars.puma"
 

     defines = CombineACF (DalibArrayMakeDsp (var, kind), NoTree);

     

     defines = CombineACF (defines, DefineDistribution (var, obj, kind));

     defines = CombineACF (defines, DalibArrayDynamic (var, kind));

     defines = CombineACF (defines, 
                           DalibArrayDefine (var, indexes, kind));
   
  }
  {
   return defines;
  }
 }

  }
  if (obj->Kind == kTopologyObject) {
# line 557 "CodeVars.puma"
  {
# line 559 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL4;
  }
   return NoTree;
yyL4:;

# line 586 "CodeVars.puma"
 {
  tTree defines;
  {
# line 588 "CodeVars.puma"

# line 590 "CodeVars.puma"
 

     defines = CombineACF (DalibArrayMakeDsp (var, kind), NoTree);

     

     defines = CombineACF (defines, 
                           DalibArrayDefine (var, indexes, kind));

     defines = CombineACF (defines, DalibTopCreate (var));
   
  }
  {
   return defines;
  }
 }

  }
  if (obj->Kind == kRaggedObject) {
# line 606 "CodeVars.puma"
 {
  tTree defines;
  {
# line 608 "CodeVars.puma"

# line 610 "CodeVars.puma"
 

     defines = CombineACF (TriDenTMakeDsp (var, kind), NoTree);

     defines = CombineACF (defines, DefineDistribution (var, obj, kind));

   
  }
  {
   return defines;
  }
 }

  }
 yyAbort ("CreateDescriptor");
}

static tTree InheritDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register tTree indexes, register int kind)
# else
(var, obj, indexes, kind)
 register tTree var;
 register tDefinitions obj;
 register tTree indexes;
 register int kind;
# endif
{
  if (obj->Kind == kVarObject) {
# line 630 "CodeVars.puma"
 {
  tTree defines;
  {
# line 632 "CodeVars.puma"

# line 634 "CodeVars.puma"
 

     defines = CombineACF (DalibCopyDsp (var, kind), NoTree);

     if (kind != kALLOCATE_DSP)

        defines = CombineACF (defines, DalibArrayAllocate (var, kind));

   
  }
  {
   return defines;
  }
 }

  }
 yyAbort ("InheritDescriptor");
}

static tTree FreeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register int kind)
# else
(var, obj, kind)
 register tTree var;
 register tDefinitions obj;
 register int kind;
# endif
{
  if (obj->Kind == kVarObject) {
# line 657 "CodeVars.puma"
   return CombineACF (DalibArrayFree (var, kind), CombineACF (DalibCopyOut (var, kind), NoTree));

  }
  if (obj->Kind == kTemplateObject) {
# line 665 "CodeVars.puma"
  {
# line 667 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return NoTree;
yyL2:;

# line 679 "CodeVars.puma"
   return CombineACF (DalibArrayFree (var, kind), NoTree);

  }
  if (obj->Kind == kTopologyObject) {
# line 672 "CodeVars.puma"
  {
# line 674 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 684 "CodeVars.puma"
   return CombineACF (DalibArrayFree (var, kind), NoTree);

  }
  if (obj->Kind == kRaggedObject) {
# line 689 "CodeVars.puma"
   return CombineACF (TriDenTFree (var, kind), NoTree);

  }
 yyAbort ("FreeDescriptor");
}

tTree AdaptAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 704 "CodeVars.puma"
   return CombineACF (AdaptAllocate1 (t->BTP_LIST.Elem->VAR_PARAM.V, TreeWriteDistribution (t->BTP_LIST.Elem->VAR_PARAM.V)), AdaptAllocate (t->BTP_LIST.Next));

  }
  }
  if (t->Kind == kBTP_EMPTY) {
# line 710 "CodeVars.puma"
   return NoTree;

  }
# line 714 "CodeVars.puma"
  {
# line 715 "CodeVars.puma"
   failure_protocol (MODULE, "AdaptAllocate", t);
  }
   return NoTree;

}

static tTree AdaptAllocate1
# if defined __STDC__ | defined __cplusplus
(register tTree v, register int dist)
# else
(v, dist)
 register tTree v;
 register int dist;
# endif
{
  if (v->Kind == kINDEXED_VAR) {
  if (v->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 721 "CodeVars.puma"
   return DescriptorAllocate (v->INDEXED_VAR.IND_VAR, v->INDEXED_VAR.IND_EXPS, v->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object);

  }
  if (v->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 726 "CodeVars.puma"
   return DescriptorAllocate (v->INDEXED_VAR.IND_VAR, v->INDEXED_VAR.IND_EXPS, v->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELECTOR->REC_COMP.Object);

  }
  }
  if (v->Kind == kUSED_VAR) {
# line 733 "CodeVars.puma"
  {
# line 735 "CodeVars.puma"
   if (! ((IsRaggedVarObject (v->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL3;
  }
   return DescriptorAllocate (v, NoTree, v->USED_VAR.VARNAME->VAR_OBJ.Object);
yyL3:;

# line 740 "CodeVars.puma"
  {
# line 742 "CodeVars.puma"
   if (! ((IsTreeObject (v->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL4;
  }
   return DescriptorAllocate (v, NoTree, v->USED_VAR.VARNAME->VAR_OBJ.Object);
yyL4:;

# line 747 "CodeVars.puma"
   return MakeAllocateStmt (v);

  }
# line 754 "CodeVars.puma"
  {
# line 756 "CodeVars.puma"
   failure_protocol (MODULE, "AdaptAllocate1", v);
  }
   return NoTree;

}

tTree AdaptDeallocate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 770 "CodeVars.puma"
   return CombineACF (AdaptDeallocate1 (t->BTP_LIST.Elem->VAR_PARAM.V), AdaptDeallocate (t->BTP_LIST.Next));

  }
  }
  if (t->Kind == kBTP_EMPTY) {
# line 775 "CodeVars.puma"
   return NoTree;

  }
# line 779 "CodeVars.puma"
  {
# line 780 "CodeVars.puma"
   failure_protocol (MODULE, "AdaptDeallocate", t);
  }
   return NoTree;

}

static tTree AdaptDeallocate1
# if defined __STDC__ | defined __cplusplus
(register tTree v)
# else
(v)
 register tTree v;
# endif
{
  if (v->Kind == kUSED_VAR) {
  if (v->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kTemplateObject) {
# line 788 "CodeVars.puma"
  {
# line 790 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return NoTree;
yyL1:;

  }
# line 795 "CodeVars.puma"
  {
# line 797 "CodeVars.puma"
   if (! ((IsTreeObject (v->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL2;
  }
   return NoTree;
yyL2:;

# line 802 "CodeVars.puma"
   return CombineACF (DalibArrayDataFree (v), NoTree);

  }
  if (v->Kind == kSELECTED_VAR) {
# line 807 "CodeVars.puma"
   return CombineACF (DalibArrayDataFree (v), NoTree);

  }
# line 814 "CodeVars.puma"
  {
# line 815 "CodeVars.puma"
   failure_protocol (MODULE, "AdaptDeallocate1", v);
  }
   return NoTree;

}

static tTree DefineDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register int alloc_kind)
# else
(var, obj, alloc_kind)
 register tTree var;
 register tDefinitions obj;
 register int alloc_kind;
# endif
{
# line 843 "CodeVars.puma"
  {
# line 845 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 849 "CodeVars.puma"
  {
# line 851 "CodeVars.puma"
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL2;
  }
   return NoTree;
yyL2:;

# line 855 "CodeVars.puma"
  {
# line 857 "CodeVars.puma"
   if (! ((alloc_kind == kSTATIC_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

  if (obj->Kind == kRaggedObject) {
# line 861 "CodeVars.puma"
  {
# line 863 "CodeVars.puma"
   if (! ((IsDistributedObj (obj)))) goto yyL4;
  }
   return TriDenTDistribute (var, alloc_kind);
yyL4:;

  }
  if (obj->Kind == kVarObject) {
# line 868 "CodeVars.puma"
  {
# line 870 "CodeVars.puma"
   if (! ((IsDistributedObj (obj)))) goto yyL5;
  }
   return CombineACF (DalibArrayDistribute (var, alloc_kind), DalibArrayShared (var, alloc_kind));
yyL5:;

# line 883 "CodeVars.puma"
  {
# line 885 "CodeVars.puma"
   if (! ((IsAlignedObj (obj)))) goto yyL7;
  }
   return CombineACF (DalibAlignSource (var, alloc_kind), CombineACF (DalibAlignTarget (var, alloc_kind), DalibArrayShared (var, alloc_kind)));
yyL7:;

# line 892 "CodeVars.puma"
  {
# line 894 "CodeVars.puma"
   if (! ((IsTranscriptiveObj (obj)))) goto yyL8;
  }
   return NoTree;
yyL8:;

  }
  if (obj->Kind == kTemplateObject) {
# line 876 "CodeVars.puma"
  {
# line 878 "CodeVars.puma"
   if (! ((IsDistributedObj (obj)))) goto yyL6;
  }
   return CombineACF (DalibArrayDistribute (var, alloc_kind), NoTree);
yyL6:;

  }
# line 899 "CodeVars.puma"
   return NoTree;

}

static bool IsAvailable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 914 "CodeVars.puma"
  {
# line 915 "CodeVars.puma"
   if (! ((VarDistribution (obj) == 0))) goto yyL1;
  }
   return true;
yyL1:;

# line 918 "CodeVars.puma"
  {
# line 919 "CodeVars.puma"
   if (! ((IsDistributedObj (obj)))) goto yyL2;
  }
   return true;
yyL2:;

# line 922 "CodeVars.puma"
  {
# line 923 "CodeVars.puma"
   if (! ((IsAlignedObj (obj)))) goto yyL3;
  }
   return true;
yyL3:;

# line 926 "CodeVars.puma"
  {
# line 927 "CodeVars.puma"
   if (! ((IsTranscriptiveObj (obj)))) goto yyL4;
  }
   return true;
yyL4:;

  return false;
}

static tTree DescriptorAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree indexes, register tDefinitions obj)
# else
(var, indexes, obj)
 register tTree var;
 register tTree indexes;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 946 "CodeVars.puma"
 {
  tTree defines;
  {
# line 948 "CodeVars.puma"

# line 950 "CodeVars.puma"
 

     defines = CombineACF (NoTree, 
                           DalibArrayDefine (var, indexes, kALLOCATE_DSP));

     

     defines = CombineACF (defines, 
                           DalibArrayAllocate (var, kALLOCATE_DSP));

   
  }
  {
   return defines;
  }
 }

  }
  if (obj->Kind == kRaggedObject) {
# line 965 "CodeVars.puma"
  {
# line 967 "CodeVars.puma"
   if (! ((indexes == NoTree))) goto yyL2;
  }
   return TriDenTAllocate (var, kALLOCATE_DSP);
yyL2:;

# line 972 "CodeVars.puma"
   return TriDenTSetSize (var, indexes, kALLOCATE_DSP);

  }
# line 977 "CodeVars.puma"
  {
# line 979 "CodeVars.puma"
   failure_protocol (MODULE, "DescriptorAllocate", var);
  }
   return NoTree;

}

static tTree MakeAllocateStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 993 "CodeVars.puma"
 {
  tTree stmt;
  {
# line 995 "CodeVars.puma"

# line 997 "CodeVars.puma"
   stmt = mBTP_LIST (mVAR_PARAM (var), mBTP_EMPTY ());
# line 998 "CodeVars.puma"
   stmt = mALLOCATE_STMT (stmt, mDUMMY_VAR ());
# line 999 "CodeVars.puma"
   stmt = mACF_BASIC (stmt);
  }
  {
   return stmt;
  }
 }

}

static tTree MakeDeallocateStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 1006 "CodeVars.puma"
 {
  tTree stmt;
  {
# line 1008 "CodeVars.puma"

# line 1010 "CodeVars.puma"
   stmt = mBTP_LIST (mVAR_PARAM (var), mBTP_EMPTY ());
# line 1011 "CodeVars.puma"
   stmt = mDEALLOCATE_STMT (stmt, mDUMMY_VAR ());
# line 1012 "CodeVars.puma"
   stmt = mACF_BASIC (stmt);
  }
  {
   return stmt;
  }
 }

}

tTree CodeRedistribute
# if defined __STDC__ | defined __cplusplus
(register tTree distributee, register tDefinitions dist)
# else
(distributee, dist)
 register tTree distributee;
 register tDefinitions dist;
# endif
{
  if (distributee->Kind == kBTV_LIST) {
# line 1025 "CodeVars.puma"
   return CombineACF (CodeRedistribute (distributee->BTV_LIST.Elem, dist), CodeRedistribute (distributee->BTV_LIST.Next, dist));

  }
  if (distributee->Kind == kBTV_EMPTY) {
# line 1031 "CodeVars.puma"
   return NoTree;

  }
  if (distributee->Kind == kUSED_VAR) {
# line 1036 "CodeVars.puma"
 {
  tTree defines;
  tDefinitions yyV1;
  tDefinitions yyV2;
  {
# line 1038 "CodeVars.puma"

# line 1042 "CodeVars.puma"
   ResetObjDistribution (distributee->USED_VAR.VARNAME->VAR_OBJ.Object, dist, & yyV1);
# line 1044 "CodeVars.puma"
 
 
     defines = CombineACF (DalibArrayCreateCopy (distributee), NoTree);
 
     defines = CombineACF (defines,
                           DefineDistribution (distributee, distributee->USED_VAR.VARNAME->VAR_OBJ.Object, kALLOCATE_DSP));

     defines = CombineACF (defines,
                           DalibArrayRedistribute (distributee));

     if (IsAvailable (distributee->USED_VAR.VARNAME->VAR_OBJ.Object))
 
       defines = CombineACF (defines, 
                             DalibArrayAllocate (distributee, kDUMMY_DSP));
 
   
# line 1061 "CodeVars.puma"
   ResetObjDistribution (distributee->USED_VAR.VARNAME->VAR_OBJ.Object, yyV1, & yyV2);
  }
  {
   return defines;
  }
 }

  }
  if (distributee->Kind == kSELECTED_VAR) {
# line 1066 "CodeVars.puma"
  {
# line 1068 "CodeVars.puma"
   error_protocol ("redistribution of components not supported");
  }
   return NoTree;

  }
# line 1073 "CodeVars.puma"
  {
# line 1075 "CodeVars.puma"
   failure_protocol (MODULE, "CodeRedistribute", distributee);
  }
   return NoTree;

}

tTree CodeRealign
# if defined __STDC__ | defined __cplusplus
(register tTree alignee, register tDefinitions dist)
# else
(alignee, dist)
 register tTree alignee;
 register tDefinitions dist;
# endif
{
  if (alignee->Kind == kBTV_LIST) {
# line 1087 "CodeVars.puma"
   return CombineACF (CodeRealign (alignee->BTV_LIST.Elem, dist), CodeRealign (alignee->BTV_LIST.Next, dist));

  }
  if (alignee->Kind == kBTV_EMPTY) {
# line 1093 "CodeVars.puma"
   return NoTree;

  }
  if (alignee->Kind == kUSED_VAR) {
# line 1103 "CodeVars.puma"
 {
  tTree defines;
  tDefinitions yyV1;
  tDefinitions yyV2;
  {
# line 1106 "CodeVars.puma"

# line 1110 "CodeVars.puma"
   ResetObjDistribution (alignee->USED_VAR.VARNAME->VAR_OBJ.Object, dist, & yyV1);
# line 1112 "CodeVars.puma"
 
 
     defines = CombineACF (DalibArrayCreateCopy (alignee), NoTree);
 
     defines = CombineACF (defines,
                           DefineDistribution (alignee, alignee->USED_VAR.VARNAME->VAR_OBJ.Object, kALLOCATE_DSP));
 
     defines = CombineACF (defines,
                           DalibArrayRedistribute (alignee));

     if (IsAvailable (alignee->USED_VAR.VARNAME->VAR_OBJ.Object))
 
       defines = CombineACF (defines, 
                             DalibArrayAllocate (alignee, kDUMMY_DSP));
   
# line 1128 "CodeVars.puma"
   ResetObjDistribution (alignee->USED_VAR.VARNAME->VAR_OBJ.Object, yyV1, & yyV2);
  }
  {
   return defines;
  }
 }

  }
  if (alignee->Kind == kINDEXED_VAR) {
  if (alignee->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 1133 "CodeVars.puma"
  {
# line 1135 "CodeVars.puma"
   error_protocol ("realign of components not supported");
  }
   return NoTree;

  }
  }
# line 1140 "CodeVars.puma"
  {
# line 1141 "CodeVars.puma"
   failure_protocol (MODULE, "CodeRealign", alignee);
  }
   return NoTree;

}

static void ResetObjDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions n, register tDefinitions * yyP1)
# else
(obj, n, yyP1)
 register tDefinitions obj;
 register tDefinitions n;
 register tDefinitions * yyP1;
# endif
{
  if (obj->Kind == kVarObject) {
# line 1153 "CodeVars.puma"
 {
  tDefinitions old_distribution;
  {
# line 1155 "CodeVars.puma"

# line 1157 "CodeVars.puma"
   old_distribution = obj->VarObject.Dist;
# line 1159 "CodeVars.puma"
   obj->VarObject.Dist = n;
  }
   * yyP1 = old_distribution;
   return;
 }

  }
  if (obj->Kind == kTemplateObject) {
# line 1162 "CodeVars.puma"
 {
  tDefinitions old_distribution;
  {
# line 1164 "CodeVars.puma"

# line 1166 "CodeVars.puma"
   old_distribution = obj->TemplateObject.Dist;
# line 1168 "CodeVars.puma"
   obj->TemplateObject.Dist = n;
  }
   * yyP1 = old_distribution;
   return;
 }

  }
# line 1171 "CodeVars.puma"
  {
# line 1173 "CodeVars.puma"
   failure_protocol (MODULE, "ResetObjDistribution", obj->Object.decl);
  }
   * yyP1 = NoDefinitions;
   return;

;
}

tTree CodeDirtyStmt
# if defined __STDC__ | defined __cplusplus
(register tTree dirty_vars)
# else
(dirty_vars)
 register tTree dirty_vars;
# endif
{
  if (dirty_vars->Kind == kBTV_EMPTY) {
# line 1188 "CodeVars.puma"
   return NoTree;

  }
  if (dirty_vars->Kind == kBTV_LIST) {
# line 1193 "CodeVars.puma"
   return CombineACF (CodeDirtyStmt (dirty_vars->BTV_LIST.Elem), CodeDirtyStmt (dirty_vars->BTV_LIST.Next));

  }
  if (dirty_vars->Kind == kUSED_VAR) {
# line 1199 "CodeVars.puma"
 {
  tTree call;
  tTree params;
  {
# line 1201 "CodeVars.puma"

# line 1202 "CodeVars.puma"

# line 1204 "CodeVars.puma"
 params = mVAR_PARAM (MakeVarSuffixA (dirty_vars, LOCAL_SUFFIX));
     params = mBTP_LIST (params, mBTP_EMPTY ());
     call   = mPROC_OBJ (MakeDalibId ("array_set_dirty"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
   
  }
  {
   return call;
  }
 }

  }
# line 1213 "CodeVars.puma"
  {
# line 1215 "CodeVars.puma"
   failure_protocol (MODULE, "CodeDirtyStmt", dirty_vars);
  }
   return NoTree;

}

void BeginCodeVars ()
{
}

void CloseCodeVars ()
{
}
