# include "CodeOn.h"
# include "yyCodeOn.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 33 "CodeOn.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Objects.h"
# include "TreeOps.h"
# include "Types.h"
# include "Transform.h"        /* CombineACF, ReplaceACF  */
# include "Dalib.h"            
# include "TriDenT.h"          
# include "Expressions.h"      /* MakeConstant */
# include "Distributions.h"      /* MakeConstant */

# include "VarDescriptor.h"    /* var_descriptor */
# include "CodeGeneral.h"  /* DalibPid */
# include "CodeMapping.h"  /* MakeSubTopCreate */
# include "CodeDescriptors.h"  /* DalibPid */
# include "Selection.h"     /* */

# define MODULE "CodeOn"



static void yyExit () { Exit (1); }

void (* CodeOn_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeOn, routine %s failed\n", yyFunction);
 CodeOn_Exit ();
}

bool NeedsNoContext ARGS((tTree stmt));
tTree ApplyOnSpecs ARGS((tTree body, tTree top, tTree specs));
static tTree ApplyOnSpecList ARGS((tTree body, tTree top, tTree specs));
static tTree MakeTopMask ARGS((tTree topology));
static tTree MakeTopDimMask ARGS((tTree topology, tTree spec));
static tTree MakeIsLocal ARGS((tDefinitions on_id, int on_dim, tTree val));
static void TemplateDimInfo ARGS((tDefinitions template, int temp_dim, int * yyP2, tTree * yyP1));
static tTree GetLocalRange ARGS((tTree actual_range, int kind, int base, int stride, tDefinitions template_id, int template_dim));
static void GetTempSliceVars ARGS((tDefinitions template, int temp_dim, tTree * yyP4, tTree * yyP3));
static void GetTempRangeVars ARGS((tDefinitions template, int temp_dim, tTree * yyP7, tTree * yyP6, tTree * yyP5));
static tTree MakeLocalRangeStmt ARGS((tDefinitions template, int temp_dim, int base, int stride, tTree range));
static tTree MakeLocalSliceStmt ARGS((tDefinitions template, int template_dim, tTree range));
static bool IsBlockDistribution ARGS((int kind));
static bool IsMappedDistribution ARGS((int kind, tTree size));
static bool IsOne ARGS((tTree size));
tTree InitTaskRegion ARGS((tTree task_body));
tTree StartTasking ARGS(());
tTree StopTasking ARGS(());
tTree ApplyOnInfo ARGS((tTree t, bool push_flag));
static tTree PushContext ARGS((tDefinitions on_id, int on_dim));
static tTree PopContext ARGS((tDefinitions on_id, int on_dim));
tTree CodeONPushContext ARGS((tTree top, tTree specs));
tTree CodeONPopContext ARGS((tTree top, tTree specs));
static tTree MakePushParams ARGS((tTree specs));
static tTree MakePushHomeCall ARGS((tIdent id, tTree spec_params));
static tTree MakePopHomeCall ARGS(());

bool NeedsNoContext
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
# line 70 "CodeOn.puma"
  {
# line 72 "CodeOn.puma"
   if (! ((NeedsNoContext (stmt->ACF_LIST.Elem)))) goto yyL1;
  {
# line 73 "CodeOn.puma"
   if (! ((NeedsNoContext (stmt->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  break;
  case kACF_EMPTY:
# line 76 "CodeOn.puma"
   return true;

  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 79 "CodeOn.puma"
  {
# line 81 "CodeOn.puma"
   return false;
  }

  }
# line 84 "CodeOn.puma"
   return true;

  case kACF_DO:
# line 87 "CodeOn.puma"
  {
# line 89 "CodeOn.puma"
   if (! ((NeedsNoContext (stmt->ACF_DO.DO_BODY)))) goto yyL5;
  }
   return true;
yyL5:;

  break;
  case kACF_IF:
# line 92 "CodeOn.puma"
  {
# line 94 "CodeOn.puma"
   if (! ((NeedsNoContext (stmt->ACF_IF.THEN_PART)))) goto yyL6;
  {
# line 95 "CodeOn.puma"
   if (! ((NeedsNoContext (stmt->ACF_IF.ELSE_PART)))) goto yyL6;
  }
  }
   return true;
yyL6:;

  break;
  case kACF_ON:
# line 98 "CodeOn.puma"
  {
# line 100 "CodeOn.puma"
   if (! ((NeedsNoContext (stmt->ACF_ON.ON_BODY)))) goto yyL7;
  }
   return true;
yyL7:;

  break;
  case kACF_PARALLEL:
# line 103 "CodeOn.puma"
  {
# line 105 "CodeOn.puma"
   if (! ((NeedsNoContext (stmt->ACF_PARALLEL.PARALLEL_BODY)))) goto yyL8;
  }
   return true;
yyL8:;

  break;
  case kACF_CRITICAL:
# line 108 "CodeOn.puma"
  {
# line 110 "CodeOn.puma"
   if (! ((NeedsNoContext (stmt->ACF_CRITICAL.CRITICAL_BODY)))) goto yyL9;
  }
   return true;
yyL9:;

  break;
  }

  return false;
}

tTree ApplyOnSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree top, register tTree specs)
# else
(body, top, specs)
 register tTree body;
 register tTree top;
 register tTree specs;
# endif
{
  if (top->Kind == kON_ALL) {
# line 121 "CodeOn.puma"
   return body;

  }
  if (top->Kind == kON_HOST) {
# line 126 "CodeOn.puma"
 {
  tTree new_acf;
  {
# line 128 "CodeOn.puma"

# line 130 "CodeOn.puma"
 new_acf = mOP_EXP (mOP_EQ(), DalibPid(), MakeConstant (1));
      new_acf = mACF_IF (new_acf, MakeStmtList (body), mACF_EMPTY());
    
  }
  {
   return new_acf;
  }
 }

  }
  if (top->Kind == kON_VAR) {
  if (specs->Kind == kON_EMPTY) {
# line 137 "CodeOn.puma"
  {
# line 139 "CodeOn.puma"
   if (! ((IsFullTopologyObj (top->ON_VAR.topid)))) goto yyL3;
  }
   return body;
yyL3:;

# line 144 "CodeOn.puma"
 {
  tTree new_acf;
  {
# line 146 "CodeOn.puma"

# line 148 "CodeOn.puma"
 new_acf = MakeTopMask (top);
      new_acf = mACF_IF (new_acf, MakeStmtList (body), mACF_EMPTY());
    
  }
  {
   return new_acf;
  }
 }

  }
  if (specs->Kind == kON_LIST) {
# line 155 "CodeOn.puma"
   return ApplyOnSpecList (body, top, specs);

  }
  }
  if (top->Kind == kON_PROCS) {
# line 160 "CodeOn.puma"
 {
  tTree new_acf;
  tTree sub_top;
  {
# line 162 "CodeOn.puma"

# line 163 "CodeOn.puma"

# line 165 "CodeOn.puma"
 new_acf = MakeTopMask (top);
      new_acf = mACF_IF (new_acf, MakeStmtList (body), mACF_EMPTY());
 
      sub_top = MakeSubProcStmt (top->ON_PROCS.topid);

      if (sub_top != NoTree)

        new_acf = CombineACF (sub_top, CombineACF (new_acf, NoTree));

    
  }
  {
   return new_acf;
  }
 }

  }
# line 179 "CodeOn.puma"
  {
# line 181 "CodeOn.puma"
   failure2_protocol (MODULE, "ApplyOnSpecs", top, specs);
  }
   return body;

}

static tTree ApplyOnSpecList
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree top, register tTree specs)
# else
(body, top, specs)
 register tTree body;
 register tTree top;
 register tTree specs;
# endif
{
  if (specs->Kind == kON_EMPTY) {
# line 194 "CodeOn.puma"
   return body;

  }
  if (specs->Kind == kON_LIST) {
# line 199 "CodeOn.puma"
   return ApplyOnSpecList (ApplyOnSpecList (body, top, specs->ON_LIST.Next), top, specs->ON_LIST.Elem);

  }
  if (specs->Kind == kON_SPEC) {
# line 204 "CodeOn.puma"
 {
  tTree new_stmt;
  {
# line 206 "CodeOn.puma"

# line 208 "CodeOn.puma"
 new_stmt = mACF_IF (MakeTopDimMask (top, specs), body, mACF_EMPTY ());
     new_stmt = mACF_LIST (new_stmt, mACF_EMPTY ());
   
  }
  {
   return new_stmt;
  }
 }

  }
# line 215 "CodeOn.puma"
  {
# line 217 "CodeOn.puma"
   failure_protocol (MODULE, "ApplyOnSpecs", specs);
  }
   return body;

}

static tTree MakeTopMask
# if defined __STDC__ | defined __cplusplus
(register tTree topology)
# else
(topology)
 register tTree topology;
# endif
{
  if (topology->Kind == kON_VAR) {
  if (Definitions_IsType (topology->ON_VAR.arrayid, kObject)) {
# line 229 "CodeOn.puma"
 {
  tTree paramlist;
  tTree call;
  {
# line 231 "CodeOn.puma"

# line 232 "CodeOn.puma"

# line 234 "CodeOn.puma"
 paramlist = mBTP_EMPTY ();
    paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (0)), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (topology->ON_VAR.arrayid->Object.Ident, "_DSP")),
                           paramlist);
  
    call = mPROC_OBJ (MakeDalibId ("is_local"));
    DefineNewHelpFn (MakeDalibId ("is_local"));
    call = mFUNC_CALL_EXP (call, paramlist);
  
  }
  {
   return call;
  }
 }

  }
  }
  if (topology->Kind == kON_PROCS) {
  if (topology->ON_PROCS.topid->Kind == kTopologyObject) {
# line 247 "CodeOn.puma"
 {
  tTree paramlist;
  tTree call;
  {
# line 249 "CodeOn.puma"

# line 250 "CodeOn.puma"

# line 252 "CodeOn.puma"
 paramlist = mBTP_EMPTY ();
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (topology->ON_PROCS.topid->TopologyObject.Ident, "_TOPID")),
                           paramlist);
 
    call = mPROC_OBJ (MakeDalibId ("is_in_procs"));
    DefineNewHelpFn (MakeDalibId ("is_in_procs"));
    call = mFUNC_CALL_EXP (call, paramlist);
  
  }
  {
   return call;
  }
 }

  }
  }
# line 264 "CodeOn.puma"
  {
# line 266 "CodeOn.puma"
   failure_protocol (MODULE, "MakeTopMask", topology);
  }
   return NoTree;

}

static tTree MakeTopDimMask
# if defined __STDC__ | defined __cplusplus
(register tTree topology, register tTree spec)
# else
(topology, spec)
 register tTree topology;
 register tTree spec;
# endif
{
  if (topology->Kind == kON_VAR) {
# line 281 "CodeOn.puma"
  {
# line 283 "CodeOn.puma"
   if (! ((IsRaggedVarObject (topology->ON_VAR.arrayid)))) goto yyL1;
  }
   return TriDenTIsLocal (topology->ON_VAR.arrayid, spec->ON_SPEC.array_dim, spec->ON_SPEC.ON_VAL);
yyL1:;

# line 288 "CodeOn.puma"
   return MakeIsLocal (topology->ON_VAR.arrayid, spec->ON_SPEC.array_dim, spec->ON_SPEC.ON_VAL);

  }
# line 293 "CodeOn.puma"
  {
# line 295 "CodeOn.puma"
   failure2_protocol (MODULE, "MakeTopDimMask", topology, spec);
  }
   return NoTree;

}

static tTree MakeIsLocal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions on_id, register int on_dim, register tTree val)
# else
(on_id, on_dim, val)
 register tDefinitions on_id;
 register int on_dim;
 register tTree val;
# endif
{
# line 301 "CodeOn.puma"
 {
  tTree paramlist;
  tTree call;
  {
# line 303 "CodeOn.puma"

# line 304 "CodeOn.puma"

# line 306 "CodeOn.puma"
 paramlist = mBTP_EMPTY ();
     paramlist = mBTP_LIST (ExpToVarParam (CopyTree(val)), paramlist);
     paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (on_dim)),
                            paramlist);
     paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (on_id->Object.Ident, "_DSP")),
                            paramlist);
     call = mPROC_OBJ (MakeDalibId ("is_local"));
     DefineNewHelpFn (MakeDalibId ("is_local"));
     call = mFUNC_CALL_EXP (call, paramlist);
  
  }
  {
   return call;
  }
 }

}

static void TemplateDimInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int temp_dim, register int * yyP2, register tTree * yyP1)
# else
(template, temp_dim, yyP2, yyP1)
 register tDefinitions template;
 register int temp_dim;
 register int * yyP2;
 register tTree * yyP1;
# endif
{
# line 328 "CodeOn.puma"
 {
  int kind;
  tTree size;
  var_descriptor vard;
  {
# line 330 "CodeOn.puma"

# line 331 "CodeOn.puma"

# line 332 "CodeOn.puma"

# line 334 "CodeOn.puma"
   SetVarObjDescriptor (& vard, template, NoTree);
# line 336 "CodeOn.puma"
 kind = vard.distribution_kind [temp_dim - 1]; 
     size = vard.distribution_size [temp_dim - 1];
   
  }
   * yyP2 = kind;
   * yyP1 = size;
   return;
 }

;
}

static tTree GetLocalRange
# if defined __STDC__ | defined __cplusplus
(register tTree actual_range, register int kind, register int base, register int stride, register tDefinitions template_id, register int template_dim)
# else
(actual_range, kind, base, stride, template_id, template_dim)
 register tTree actual_range;
 register int kind;
 register int base;
 register int stride;
 register tDefinitions template_id;
 register int template_dim;
# endif
{
  if (actual_range->Kind == kSLICE_EXP) {
# line 361 "CodeOn.puma"
 {
  tTree stmt;
  tTree yyV1;
  tTree yyV2;
  {
# line 363 "CodeOn.puma"

# line 365 "CodeOn.puma"
   if (! ((base == 0))) goto yyL1;
  {
# line 366 "CodeOn.puma"
   if (! ((stride == 1))) goto yyL1;
  {
# line 367 "CodeOn.puma"
   if (! ((IsStride1 (actual_range->SLICE_EXP.INC)))) goto yyL1;
  {
# line 369 "CodeOn.puma"
   if (! ((IsBlockDistribution (kind)))) goto yyL1;
  {
# line 371 "CodeOn.puma"
   stmt = MakeLocalSliceStmt (template_id, template_dim, actual_range);
# line 373 "CodeOn.puma"
   GetTempSliceVars (template_id, template_dim, & yyV1, & yyV2);
# line 375 "CodeOn.puma"
   actual_range->SLICE_EXP.START = mVAR_EXP (yyV1);
# line 376 "CodeOn.puma"
   actual_range->SLICE_EXP.STOP = mVAR_EXP (yyV2);
  }
  }
  }
  }
  }
  {
   return stmt;
  }
 }
yyL1:;

# line 385 "CodeOn.puma"
 {
  tTree stmt;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 387 "CodeOn.puma"

# line 389 "CodeOn.puma"
   stmt = MakeLocalRangeStmt (template_id, template_dim, base, stride, actual_range);
# line 392 "CodeOn.puma"
   GetTempRangeVars (template_id, template_dim, & yyV1, & yyV2, & yyV3);
# line 394 "CodeOn.puma"
   actual_range->SLICE_EXP.START = mVAR_EXP (yyV1);
# line 395 "CodeOn.puma"
   actual_range->SLICE_EXP.STOP = mVAR_EXP (yyV2);
# line 397 "CodeOn.puma"
 if (!IsBlockDistribution (kind))  
        actual_range->SLICE_EXP.INC = mVAR_EXP (yyV3);
   
  }
  {
   return stmt;
  }
 }

  }
# line 404 "CodeOn.puma"
  {
# line 406 "CodeOn.puma"
   failure_protocol (MODULE, "GetLocalRange", actual_range);
  }
   return NoTree;

}

static void GetTempSliceVars
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int temp_dim, register tTree * yyP4, register tTree * yyP3)
# else
(template, temp_dim, yyP4, yyP3)
 register tDefinitions template;
 register int temp_dim;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
# line 418 "CodeOn.puma"
 {
  tTree low;
  tTree high;
  {
# line 420 "CodeOn.puma"

# line 421 "CodeOn.puma"

# line 423 "CodeOn.puma"
   low = MakeUsedVarAn (template->Object.Ident, "_START", temp_dim);
# line 424 "CodeOn.puma"
   DefineNewIntVar (TreeVarName (low));
# line 426 "CodeOn.puma"
   high = MakeUsedVarAn (template->Object.Ident, "_STOP", temp_dim);
# line 427 "CodeOn.puma"
   DefineNewIntVar (TreeVarName (high));
  }
   * yyP4 = low;
   * yyP3 = high;
   return;
 }

;
}

static void GetTempRangeVars
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int temp_dim, register tTree * yyP7, register tTree * yyP6, register tTree * yyP5)
# else
(template, temp_dim, yyP7, yyP6, yyP5)
 register tDefinitions template;
 register int temp_dim;
 register tTree * yyP7;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
# line 433 "CodeOn.puma"
 {
  tTree low;
  tTree high;
  tTree inc;
  {
# line 435 "CodeOn.puma"

# line 436 "CodeOn.puma"

# line 437 "CodeOn.puma"

# line 439 "CodeOn.puma"
   low = MakeUsedVarAn (template->Object.Ident, "_START", temp_dim);
# line 440 "CodeOn.puma"
   DefineNewIntVar (TreeVarName (low));
# line 442 "CodeOn.puma"
   high = MakeUsedVarAn (template->Object.Ident, "_STOP", temp_dim);
# line 443 "CodeOn.puma"
   DefineNewIntVar (TreeVarName (high));
# line 445 "CodeOn.puma"
   inc = MakeUsedVarAn (template->Object.Ident, "_INC", temp_dim);
# line 446 "CodeOn.puma"
   DefineNewIntVar (TreeVarName (inc));
  }
   * yyP7 = low;
   * yyP6 = high;
   * yyP5 = inc;
   return;
 }

;
}

static tTree MakeLocalRangeStmt
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int temp_dim, register int base, register int stride, register tTree range)
# else
(template, temp_dim, base, stride, range)
 register tDefinitions template;
 register int temp_dim;
 register int base;
 register int stride;
 register tTree range;
# endif
{
  if (range->Kind == kSLICE_EXP) {
# line 478 "CodeOn.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree paramlist;
  tIdent id;
  {
# line 481 "CodeOn.puma"
   GetTempRangeVars (template, temp_dim, & yyV1, & yyV2, & yyV3);
# line 483 "CodeOn.puma"

# line 484 "CodeOn.puma"

# line 486 "CodeOn.puma"
 paramlist = mBTP_EMPTY ();

    paramlist = mBTP_LIST (mVAR_PARAM (yyV3), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (yyV2), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (yyV1), paramlist);

    if (IsStride1 (range->SLICE_EXP.INC))   
       paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (1)), paramlist);
     else  
       paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.INC), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.STOP    ), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.START    ), paramlist);
    if ((base == 0) && (stride == 1))
        id = MakeDalibId ("array_lrange");
      else
        { id = MakeDalibId ("array_mrange");
          paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (base)),
                        mBTP_LIST (ExpToVarParam (MakeConstant (stride)),
                         paramlist));
        }
    paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (temp_dim)), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (template->Object.Ident, "_DSP")),
                           paramlist);
  
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (id), paramlist));
  }
 }

  }
# line 513 "CodeOn.puma"
  {
# line 514 "CodeOn.puma"
   failure_protocol (MODULE, "MakeLocalRangeStmt", range);
  }
   return NoTree;

}

static tTree MakeLocalSliceStmt
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int template_dim, register tTree range)
# else
(template, template_dim, range)
 register tDefinitions template;
 register int template_dim;
 register tTree range;
# endif
{
  if (range->Kind == kSLICE_EXP) {
# line 538 "CodeOn.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree paramlist;
  tTree call;
  {
# line 541 "CodeOn.puma"
   GetTempSliceVars (template, template_dim, & yyV1, & yyV2);
# line 543 "CodeOn.puma"

# line 544 "CodeOn.puma"

# line 546 "CodeOn.puma"
 paramlist = mBTP_EMPTY ();
    paramlist = mBTP_LIST (mVAR_PARAM (yyV2), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (yyV1), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.STOP    ), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.START    ), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (template_dim)),
                           paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (template->Object.Ident, "_DSP")),
                           paramlist);
    call = mPROC_OBJ (MakeDalibId ("array_lslice"));
    call = mACF_BASIC (mCALL_STMT (call, paramlist));
  
  }
  {
   return call;
  }
 }

  }
# line 561 "CodeOn.puma"
  {
# line 563 "CodeOn.puma"
   failure_protocol (MODULE, "MakeLocalSliceStmt", range);
  }
   return NoTree;

}

static bool IsBlockDistribution
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
# line 569 "CodeOn.puma"
  {
# line 570 "CodeOn.puma"
   if (! ((kind == kBLOCK_DIM))) goto yyL1;
  }
   return true;
yyL1:;

# line 573 "CodeOn.puma"
  {
# line 574 "CodeOn.puma"
   if (! ((kind == kGEN_BLOCK_DIM))) goto yyL2;
  }
   return true;
yyL2:;

# line 577 "CodeOn.puma"
  {
# line 578 "CodeOn.puma"
   if (! ((kind == kANY_BLOCK_DIM))) goto yyL3;
  }
   return true;
yyL3:;

# line 581 "CodeOn.puma"
  {
# line 582 "CodeOn.puma"
   if (! ((kind == kANY_GEN_BLOCK_DIM))) goto yyL4;
  }
   return true;
yyL4:;

  return false;
}

static bool IsMappedDistribution
# if defined __STDC__ | defined __cplusplus
(register int kind, register tTree size)
# else
(kind, size)
 register int kind;
 register tTree size;
# endif
{
# line 587 "CodeOn.puma"
  {
# line 589 "CodeOn.puma"
   if (! ((IsBlockDistribution (kind)))) goto yyL1;
  {
# line 590 "CodeOn.puma"
   return false;
  }
  }
yyL1:;

# line 593 "CodeOn.puma"
  {
# line 595 "CodeOn.puma"
   if (! ((kind == kCYCLIC_DIM))) goto yyL2;
  {
# line 596 "CodeOn.puma"
   if (! ((IsOne (size)))) goto yyL2;
  {
# line 597 "CodeOn.puma"
   return false;
  }
  }
  }
yyL2:;

# line 600 "CodeOn.puma"
   return true;

}

static bool IsOne
# if defined __STDC__ | defined __cplusplus
(register tTree size)
# else
(size)
 register tTree size;
# endif
{
# line 605 "CodeOn.puma"
  {
# line 607 "CodeOn.puma"
   if (! ((size == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

# line 610 "CodeOn.puma"
 {
  bool found;
  int val;
  {
# line 612 "CodeOn.puma"

# line 613 "CodeOn.puma"

# line 615 "CodeOn.puma"
   GetIntConstValue (size, & found, & val);
# line 616 "CodeOn.puma"
   if (! ((found))) goto yyL2;
  {
# line 617 "CodeOn.puma"
   if (! ((val == 1))) goto yyL2;
  }
  }
   return true;
 }
yyL2:;

  return false;
}

tTree InitTaskRegion
# if defined __STDC__ | defined __cplusplus
(register tTree task_body)
# else
(task_body)
 register tTree task_body;
# endif
{
  if (task_body->Kind == kACF_LIST) {
# line 628 "CodeOn.puma"
   return CombineACF (InitTaskRegion (task_body->ACF_LIST.Elem), InitTaskRegion (task_body->ACF_LIST.Next));

  }
  if (task_body->Kind == kACF_EMPTY) {
# line 633 "CodeOn.puma"
   return NoTree;

  }
  if (task_body->Kind == kACF_ON) {
  if (task_body->ACF_ON.ON_HOME->Kind == kON_VAR) {
  if (Definitions_IsType (task_body->ACF_ON.ON_HOME->ON_VAR.arrayid, kObject)) {
# line 638 "CodeOn.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 641 "CodeOn.puma"

# line 642 "CodeOn.puma"

# line 644 "CodeOn.puma"
 params = mBTP_EMPTY ();

     params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (task_body->ACF_ON.ON_HOME->ON_VAR.arrayid->Object.Ident, LOCAL_SUFFIX)),
                         params);

     stmt = mPROC_OBJ (MakeDalibId ("set_task_home"));
     stmt = mCALL_STMT (stmt, params);
     stmt = mACF_BASIC (stmt);
   
  }
  {
   return stmt;
  }
 }

  }
  }
  if (task_body->ACF_ON.ON_HOME->Kind == kON_PROCS) {
  if (Definitions_IsType (task_body->ACF_ON.ON_HOME->ON_PROCS.topid, kObject)) {
# line 657 "CodeOn.puma"
 {
  tTree create;
  tTree stmt;
  tTree params;
  {
# line 660 "CodeOn.puma"

# line 661 "CodeOn.puma"

# line 662 "CodeOn.puma"

# line 664 "CodeOn.puma"
 create = MakeSubProcStmt (task_body->ACF_ON.ON_HOME->ON_PROCS.topid);

     params = mBTP_EMPTY ();

     params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (task_body->ACF_ON.ON_HOME->ON_PROCS.topid->Object.Ident, "_TOPID")),
                         params);

     stmt = mPROC_OBJ (MakeDalibId ("set_task_procs"));
     stmt = mCALL_STMT (stmt, params);
     stmt = mACF_BASIC (stmt);
     stmt = mACF_LIST (stmt, NoTree);
   
  }
  {
   return CombineACF (create, stmt);
  }
 }

  }
  }
  }
  if (task_body->Kind == kACF_DO) {
# line 680 "CodeOn.puma"
 {
  tTree stmt;
  {
# line 682 "CodeOn.puma"

# line 684 "CodeOn.puma"
   stmt = CompleteACFs (InitTaskRegion (task_body->ACF_DO.DO_BODY));
# line 686 "CodeOn.puma"
   stmt = mACF_DO (CopyTree (task_body->ACF_DO.DO_ID), CopyTree (task_body->ACF_DO.DO_RANGE), stmt, CopyTree (task_body->ACF_DO.DO_DEP_INFO), CopyTree (task_body->ACF_DO.DO_HOME_INFO));
  }
  {
   return mACF_LIST (stmt, NoTree);
  }
 }

  }
# line 692 "CodeOn.puma"
  {
# line 693 "CodeOn.puma"
   failure_protocol (MODULE, "InitTaskRegion", task_body);
  }
   return NoTree;

}

tTree StartTasking
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 699 "CodeOn.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 700 "CodeOn.puma"

# line 701 "CodeOn.puma"

# line 703 "CodeOn.puma"
 params = mBTP_EMPTY ();

     stmt = mPROC_OBJ (MakeDalibId ("start_tasking"));
     stmt = mCALL_STMT (stmt, params);
     stmt = mACF_BASIC (stmt);
   
  }
  {
   return stmt;
  }
 }

}

tTree StopTasking
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 715 "CodeOn.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 716 "CodeOn.puma"

# line 717 "CodeOn.puma"

# line 719 "CodeOn.puma"
 params = mBTP_EMPTY ();

     stmt = mPROC_OBJ (MakeDalibId ("stop_tasking"));
     stmt = mCALL_STMT (stmt, params);
     stmt = mACF_BASIC (stmt);
   
  }
  {
   return stmt;
  }
 }

}

tTree ApplyOnInfo
# if defined __STDC__ | defined __cplusplus
(register tTree t, register bool push_flag)
# else
(t, push_flag)
 register tTree t;
 register bool push_flag;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_HOME_INFO->Kind == kON_INFO) {
# line 760 "CodeOn.puma"
 {
  int yyV1;
  tTree yyV2;
  tTree new_body;
  tTree val;
  {
# line 763 "CodeOn.puma"
   TemplateDimInfo (t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim, & yyV1, & yyV2);
# line 765 "CodeOn.puma"
   if (! ((IsMappedDistribution (yyV1, yyV2)))) goto yyL1;
  {
# line 767 "CodeOn.puma"

# line 768 "CodeOn.puma"

# line 770 "CodeOn.puma"
 val = mVAR_EXP (CopyTree (t->ACF_DO.DO_ID));
     val = MultConstant (val, t->ACF_DO.DO_HOME_INFO->ON_INFO.stride);
     val = AddConstant (val, t->ACF_DO.DO_HOME_INFO->ON_INFO.base);

     new_body = mACF_IF (MakeIsLocal (t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim, val), t->ACF_DO.DO_BODY, mACF_EMPTY ());

     t->ACF_DO.DO_BODY = MakeStmtList (new_body);
     t->ACF_DO.DO_HOME_INFO = mNO_HOME_INFO ();
   
# line 780 "CodeOn.puma"
   CodeParallelLoop (t);
  }
  }
  {
   return t;
  }
 }
yyL1:;

# line 784 "CodeOn.puma"
 {
  tTree range_stmt;
  tTree new_stmts;
  int yyV1;
  tTree yyV2;
  {
# line 787 "CodeOn.puma"

# line 788 "CodeOn.puma"

# line 790 "CodeOn.puma"
   TemplateDimInfo (t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim, & yyV1, & yyV2);
# line 792 "CodeOn.puma"
 range_stmt = GetLocalRange (t->ACF_DO.DO_RANGE, yyV1, t->ACF_DO.DO_HOME_INFO->ON_INFO.base, t->ACF_DO.DO_HOME_INFO->ON_INFO.stride, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim);

     new_stmts = t;

     if (push_flag)

       new_stmts = ComposeNewACF (PushContext (t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim), new_stmts,
                                  PopContext (t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim));

     if (range_stmt != NoTree)

        new_stmts = CombineACF (range_stmt, new_stmts);

     t->ACF_DO.DO_HOME_INFO = mNO_HOME_INFO ();

     CodeParallelLoop (t);

   
  }
  {
   return new_stmts;
  }
 }

  }
  }
# line 814 "CodeOn.puma"
  {
# line 816 "CodeOn.puma"
   failure_protocol (MODULE, "ApplyOnInfo", t);
  }
   return NoTree;

}

static tTree PushContext
# if defined __STDC__ | defined __cplusplus
(register tDefinitions on_id, register int on_dim)
# else
(on_id, on_dim)
 register tDefinitions on_id;
 register int on_dim;
# endif
{
# line 829 "CodeOn.puma"
 {
  tTree params;
  {
# line 831 "CodeOn.puma"

# line 833 "CodeOn.puma"
 params = mBTP_EMPTY ();
     params = mBTP_LIST (ExpToVarParam (MakeConstant (on_dim)), params);
   
  }
  {
   return MakePushHomeCall (on_id->Object.Ident, params);
  }
 }

}

static tTree PopContext
# if defined __STDC__ | defined __cplusplus
(register tDefinitions on_id, register int on_dim)
# else
(on_id, on_dim)
 register tDefinitions on_id;
 register int on_dim;
# endif
{
# line 842 "CodeOn.puma"
   return MakePopHomeCall ();

}

tTree CodeONPushContext
# if defined __STDC__ | defined __cplusplus
(register tTree top, register tTree specs)
# else
(top, specs)
 register tTree top;
 register tTree specs;
# endif
{
  if (top->Kind == kON_VAR) {
  if (Definitions_IsType (top->ON_VAR.arrayid, kObject)) {
# line 855 "CodeOn.puma"
   return MakePushHomeCall (top->ON_VAR.arrayid->Object.Ident, MakePushParams (specs));

  }
  }
  if (top->Kind == kON_PROCS) {
  if (Definitions_IsType (top->ON_PROCS.topid, kObject)) {
# line 860 "CodeOn.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 862 "CodeOn.puma"

# line 863 "CodeOn.puma"

# line 865 "CodeOn.puma"
 params = mBTP_EMPTY ();

      params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (top->ON_PROCS.topid->Object.Ident, "_TOPID")),
                          params);

      stmt = mPROC_OBJ (MakeDalibId ("push_procs_context"));
      stmt = mCALL_STMT (stmt, params);
      stmt = mACF_BASIC (stmt);
    
  }
  {
   return stmt;
  }
 }

  }
  }
  if (top->Kind == kON_HOST) {
# line 878 "CodeOn.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 880 "CodeOn.puma"

# line 881 "CodeOn.puma"

# line 883 "CodeOn.puma"
 params = mBTP_EMPTY ();

      stmt = mPROC_OBJ (MakeDalibId ("push_host_context"));
      stmt = mCALL_STMT (stmt, params);
      stmt = mACF_BASIC (stmt);
    
  }
  {
   return stmt;
  }
 }

  }
# line 893 "CodeOn.puma"
  {
# line 895 "CodeOn.puma"
   failure_protocol (MODULE, "CodeOnContext", top);
  }
   return NoTree;

}

tTree CodeONPopContext
# if defined __STDC__ | defined __cplusplus
(register tTree top, register tTree specs)
# else
(top, specs)
 register tTree top;
 register tTree specs;
# endif
{
  if (top->Kind == kON_VAR) {
# line 901 "CodeOn.puma"
   return MakePopHomeCall ();

  }
  if (top->Kind == kON_PROCS) {
# line 906 "CodeOn.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 908 "CodeOn.puma"

# line 909 "CodeOn.puma"

# line 911 "CodeOn.puma"
 params = mBTP_EMPTY ();

      stmt = mCALL_STMT (mPROC_OBJ (MakeDalibId ("pop_procs_context")), params);
      stmt = mACF_BASIC (stmt);
    
  }
  {
   return stmt;
  }
 }

  }
  if (top->Kind == kON_HOST) {
# line 920 "CodeOn.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 922 "CodeOn.puma"

# line 923 "CodeOn.puma"

# line 925 "CodeOn.puma"
 params = mBTP_EMPTY ();

      stmt = mCALL_STMT (mPROC_OBJ (MakeDalibId ("pop_host_context")), params);
      stmt = mACF_BASIC (stmt);
    
  }
  {
   return stmt;
  }
 }

  }
# line 934 "CodeOn.puma"
  {
# line 936 "CodeOn.puma"
   failure_protocol (MODULE, "CodeOnContext", top);
  }
   return NoTree;

}

static tTree MakePushParams
# if defined __STDC__ | defined __cplusplus
(register tTree specs)
# else
(specs)
 register tTree specs;
# endif
{
  if (specs->Kind == kON_EMPTY) {
# line 948 "CodeOn.puma"
   return mBTP_EMPTY ();

  }
  if (specs->Kind == kON_LIST) {
# line 953 "CodeOn.puma"
   return mBTP_LIST (MakePushParams (specs->ON_LIST.Elem), MakePushParams (specs->ON_LIST.Next));

  }
  if (specs->Kind == kON_SPEC) {
# line 959 "CodeOn.puma"
   return ExpToVarParam (MakeConstant (specs->ON_SPEC.array_dim));

  }
# line 964 "CodeOn.puma"
  {
# line 965 "CodeOn.puma"
   failure_protocol (MODULE, "MakePushParams", specs);
  }
   return NoTree;

}

static tTree MakePushHomeCall
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree spec_params)
# else
(id, spec_params)
 register tIdent id;
 register tTree spec_params;
# endif
{
# line 977 "CodeOn.puma"
 {
  int len;
  tTree params;
  tTree stmt;
  {
# line 979 "CodeOn.puma"

# line 980 "CodeOn.puma"

# line 981 "CodeOn.puma"

# line 983 "CodeOn.puma"
 len    = TreeListLength (spec_params);

      params = mBTP_LIST (ExpToVarParam (MakeConstant (len)), spec_params);
      params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (id, LOCAL_SUFFIX)),
                          params);

      stmt = mPROC_OBJ (MakeDalibId ("push_home_context"));
      stmt = mCALL_STMT (stmt, params);
      stmt = mACF_BASIC (stmt);
    
  }
  {
   return stmt;
  }
 }

}

static tTree MakePopHomeCall
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 999 "CodeOn.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 1001 "CodeOn.puma"

# line 1002 "CodeOn.puma"

# line 1004 "CodeOn.puma"
 params = mBTP_EMPTY ();

     stmt = mCALL_STMT (mPROC_OBJ (MakeDalibId ("pop_home_context")), params);
     stmt = mACF_BASIC (stmt);
   
  }
  {
   return stmt;
  }
 }

}

void BeginCodeOn ()
{
}

void CloseCodeOn ()
{
}
