# include "CodeMovement.h"
# include "yyCodeMovement.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 23 "CodeMovement.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"
# include "permutations.h"

# include "Types.h"
# include "Transform.h"      /* ExpToVarParam */
# include "Expressions.h"    /* MakeConstant  */
# include "MoveControl.h" 
# include "Dalib.h"

# include "CodeDescriptors.h"  /* DalibSectionTranslation */

# define MODULE "CodeMovement"



static void yyExit () { Exit (1); }

void (* CodeMovement_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeMovement, routine %s failed\n", yyFunction);
 CodeMovement_Exit ();
}

tTree CodeMovement ARGS((tTree t));
static tTree MakeStructuredMovement ARGS((tTree target, tTree source, tTree mask));
static tTree MakeCallStmt ARGS((tIdent id, tTree params));
static void MakeDescriptor ARGS((tTree var, int nr, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void MakeDescriptor2 ARGS((tTree var1, tTree var2, tTree * yyP6, tTree * yyP5, tTree * yyP4));
static void MakeDescriptor3 ARGS((tTree var1, tTree var2, tTree var3, tTree * yyP9, tTree * yyP8, tTree * yyP7));
static tTree MakePermuteParams ARGS((Permutation perm));

tTree CodeMovement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_MOVE) {
  if (t->ACF_MOVE.MOVE_STMT->Kind == kMOVE_STMT) {
# line 51 "CodeMovement.puma"
   return MakeStructuredMovement (t->ACF_MOVE.MOVE_STMT->MOVE_STMT.TARGET, t->ACF_MOVE.MOVE_STMT->MOVE_STMT.SOURCE, t->ACF_MOVE.MOVE_STMT->MOVE_STMT.MASK);

  }
  }
# line 56 "CodeMovement.puma"
  {
# line 57 "CodeMovement.puma"
   failure_protocol (MODULE, "CodeMovement", t);
  }
   return NoTree;

}

static tTree MakeStructuredMovement
# if defined __STDC__ | defined __cplusplus
(register tTree target, register tTree source, register tTree mask)
# else
(target, source, mask)
 register tTree target;
 register tTree source;
 register tTree mask;
# endif
{
  if (source->Kind == kPERM_VAR) {
  if (mask->Kind == kNO_PARAM) {
# line 75 "CodeMovement.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  {
# line 77 "CodeMovement.puma"
   MakeDescriptor2 (target, source->PERM_VAR.VAL, & yyV1, & yyV2, & yyV3);
# line 79 "CodeMovement.puma"

# line 81 "CodeMovement.puma"
   call = MakeCallStmt (MakeDalibId ("assign_permute"), CombineBTP (yyV1, MakePermuteParams (source->PERM_VAR.perm)));
  }
  {
   return CombineACF (yyV2, CombineACF (call, yyV3));
  }
 }

  }
# line 98 "CodeMovement.puma"
  {
# line 100 "CodeMovement.puma"
   error_protocol ("could not translate structured movement");
  }
   return NoTree;

  }
  if (mask->Kind == kNO_PARAM) {
# line 87 "CodeMovement.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  {
# line 89 "CodeMovement.puma"
   MakeDescriptor2 (target, source, & yyV1, & yyV2, & yyV3);
# line 91 "CodeMovement.puma"

# line 93 "CodeMovement.puma"
   call = MakeCallStmt (MakeDalibId ("assign"), CompleteBTPs (yyV1));
  }
  {
   return CombineACF (yyV2, CombineACF (call, yyV3));
  }
 }

  }
  if (mask->Kind == kVAR_PARAM) {
# line 105 "CodeMovement.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  {
# line 107 "CodeMovement.puma"
   if (! ((CountMovements (target, mask) == 0))) goto yyL4;
  {
# line 109 "CodeMovement.puma"
   MakeDescriptor3 (target, source, mask->VAR_PARAM.V, & yyV1, & yyV2, & yyV3);
# line 111 "CodeMovement.puma"

# line 113 "CodeMovement.puma"
   call = MakeCallStmt (MakeDalibId ("massign_rhs"), CompleteBTPs (yyV1));
  }
  }
  {
   return CombineACF (yyV2, CombineACF (call, yyV3));
  }
 }
yyL4:;

# line 118 "CodeMovement.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  {
# line 120 "CodeMovement.puma"
   MakeDescriptor3 (target, source, mask->VAR_PARAM.V, & yyV1, & yyV2, & yyV3);
# line 122 "CodeMovement.puma"

# line 124 "CodeMovement.puma"
   call = MakeCallStmt (MakeDalibId ("massign_lhs"), CompleteBTPs (yyV1));
  }
  {
   return CombineACF (yyV2, CombineACF (call, yyV3));
  }
 }

  }
 yyAbort ("MakeStructuredMovement");
}

static tTree MakeCallStmt
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree params)
# else
(id, params)
 register tIdent id;
 register tTree params;
# endif
{
# line 131 "CodeMovement.puma"
 {
  tTree call;
  {
# line 133 "CodeMovement.puma"

# line 135 "CodeMovement.puma"
   call = mPROC_OBJ (id);
# line 136 "CodeMovement.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

}

static void MakeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int nr, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(var, nr, yyP3, yyP2, yyP1)
 register tTree var;
 register int nr;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 149 "CodeMovement.puma"
 {
  tTree param;
  tTree pre_stmt;
  tTree post_stmt;
  {
# line 151 "CodeMovement.puma"

# line 152 "CodeMovement.puma"

# line 153 "CodeMovement.puma"

# line 155 "CodeMovement.puma"
   DalibSectionTranslation (nr, var, & pre_stmt, & param, & post_stmt);
  }
   * yyP3 = param;
   * yyP2 = pre_stmt;
   * yyP1 = post_stmt;
   return;
 }

;
}

static void MakeDescriptor2
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(var1, var2, yyP6, yyP5, yyP4)
 register tTree var1;
 register tTree var2;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
# line 160 "CodeMovement.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 164 "CodeMovement.puma"
   MakeDescriptor (var1, 1, & yyV1, & yyV2, & yyV3);
# line 165 "CodeMovement.puma"
   MakeDescriptor (var2, 2, & yyV4, & yyV5, & yyV6);
  }
   * yyP6 = mBTP_LIST (yyV1, mBTP_LIST (yyV4, NoTree));
   * yyP5 = CombineACF (yyV2, yyV5);
   * yyP4 = CombineACF (yyV6, yyV3);
   return;
 }

;
}

static void MakeDescriptor3
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2, register tTree var3, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(var1, var2, var3, yyP9, yyP8, yyP7)
 register tTree var1;
 register tTree var2;
 register tTree var3;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
# line 171 "CodeMovement.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 175 "CodeMovement.puma"
   MakeDescriptor2 (var1, var2, & yyV1, & yyV2, & yyV3);
# line 176 "CodeMovement.puma"
   MakeDescriptor (var3, 3, & yyV4, & yyV5, & yyV6);
  }
   * yyP9 = CombineBTP (yyV1, mBTP_LIST (yyV4, NoTree));
   * yyP8 = CombineACF (yyV2, yyV5);
   * yyP7 = CombineACF (yyV6, yyV3);
   return;
 }

;
}

static tTree MakePermuteParams
# if defined __STDC__ | defined __cplusplus
(Permutation perm)
# else
(perm)
 Permutation perm;
# endif
{
# line 187 "CodeMovement.puma"
 {
  int i;
  tTree params;
  tTree param;
  {
# line 188 "CodeMovement.puma"

# line 189 "CodeMovement.puma"

# line 190 "CodeMovement.puma"

# line 192 "CodeMovement.puma"
 params = mBTP_EMPTY();
     for (i = perm.n; i > 0; i--)
       { param = ExpToVarParam (MakeConstant (perm.pa[i-1]));
         params = mBTP_LIST (param, params);
       }
   
  }
  {
   return params;
  }
 }

}

void BeginCodeMovement ()
{
}

void CloseCodeMovement ()
{
}
