# include "CodeMapping.h"
# include "yyCodeMapping.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 55 "CodeMapping.puma"


# define  MODULE      "CodeMapping"

# include <stdio.h>
# include <string.h>

# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "DefTable.h"

# include "CodeGeneral.h"
# include "Types.h"           /* ArrayFormals */
# include "Objects.h"         /* */
# include "TreeOps.h"         /* TreeVarName */
# include "Rank.h"         /* TreeVarName */
# include "Transform.h"       /* ExpToVarParam */
# include "Dalib.h"           /* MakeDalibId, MakeUsedVarA */
# include "TriDenT.h"         /* MakeDalibId, MakeUsedVarA */
# include "Expressions.h"     /* MakeConstant */
# include "Shapes.h"          /* MakeFullShape */
# include "Distributions.h"   /* MakeFullShape */
# include "Nesting.h"



static void yyExit () { Exit (1); }

void (* CodeMapping_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeMapping, routine %s failed\n", yyFunction);
 CodeMapping_Exit ();
}

tTree DalibArrayMakeDsp ARGS((tTree var, int kind));
tTree DalibArrayDefine ARGS((tTree var, tTree dim_list, int kind));
tTree DalibArrayCreateCopy ARGS((tTree var));
tTree DalibArrayOverlap ARGS((tTree var, int kind));
static tTree MakeOverlapParams ARGS((tTree t));
static void GetDimOverlap ARGS((tTree formal, int * yyP2, int * yyP1));
tTree DalibArrayDataFree ARGS((tTree var));
tTree DalibArrayFree ARGS((tTree var, int kind));
tTree DalibArrayDistribute ARGS((tTree var, int kind));
tTree DalibArrayShared ARGS((tTree var, int kind));
tTree DalibAlignSource ARGS((tTree var, int kind));
tTree DalibAlignTarget ARGS((tTree var, int kind));
static tTree MakeSourceParams ARGS((tDefinitions ilist));
static tTree MakeTargetParams ARGS((tDefinitions plist));
tTree DalibArrayDynamic ARGS((tTree var, int kind));
tTree DalibArrayTrace ARGS((tTree var));
tTree DalibCopyDsp ARGS((tTree var, int kind));
tTree DalibCopyIn ARGS((tTree var, int kind));
tTree DalibCopyOut ARGS((tTree var, int kind));
tTree DalibArrayRedistribute ARGS((tTree var));
tTree DalibArrayAllocate ARGS((tTree var, int kind));
tTree DalibTopCreate ARGS((tTree var));
tTree MakeSubProcStmt ARGS((tDefinitions obj));
tTree DistributionDecls ARGS((tDefinitions obj));
static tTree MakeDescriptorDecls ARGS((tDefinitions obj));
static bool NoCopyInCopyOut ARGS((tDefinitions obj, int kind));
static void GetVarObject ARGS((tTree var, tDefinitions * yyP3));
static void GetSizeOfObject ARGS((tDefinitions obj, int * yyP4));
static void GetTopologyInfo ARGS((tDefinitions obj, tIdent * yyP6, tTree * yyP5));
static void GetDistOfObject ARGS((tDefinitions obj, tDefinitions * yyP7));
static void GetObjSharedInfo ARGS((tDefinitions obj, int * yyP8));
static void GetObjDistributionData ARGS((tDefinitions obj, tDefinitions * yyP12, tDefinitions * yyP11, tDefinitions * yyP10, tDefinitions * yyP9));
static void GetCopyInfo ARGS((tDefinitions obj, int * yyP14, int * yyP13));

tTree DalibArrayMakeDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 99 "CodeMapping.puma"

char var_string [MAXID_LENGTH];
int  var_length;

# line 104 "CodeMapping.puma"
  {
# line 106 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL1;
  {
# line 107 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

# line 112 "CodeMapping.puma"
  {
# line 114 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL2;
  {
# line 115 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

# line 120 "CodeMapping.puma"
  {
# line 122 "CodeMapping.puma"
   if (! ((kind == kLOCAL_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 126 "CodeMapping.puma"
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  tStringRef ref;
  tDefinitions yyV1;
  int yyV2;
  {
# line 128 "CodeMapping.puma"

# line 129 "CodeMapping.puma"

# line 130 "CodeMapping.puma"

# line 131 "CodeMapping.puma"

# line 132 "CodeMapping.puma"

# line 134 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 135 "CodeMapping.puma"
   GetSizeOfObject (yyV1, & yyV2);
# line 137 "CodeMapping.puma"
   params = mBTP_EMPTY ();
# line 139 "CodeMapping.puma"
   GetString (yyV1->Object.Ident, var_string);
# line 140 "CodeMapping.puma"
   var_length = strlen (var_string);
# line 142 "CodeMapping.puma"
   ref = PutString (var_string, var_length);
# line 144 "CodeMapping.puma"
   param = ExpToVarParam (MakeConstant (var_length));
# line 145 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 147 "CodeMapping.puma"
   param = ExpToVarParam (mCONST_EXP (mSTRING_CONSTANT (ref)));
# line 148 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 150 "CodeMapping.puma"
   param = ExpToVarParam (MakeConstant (yyV2));
# line 151 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 153 "CodeMapping.puma"
   param = ExpToVarParam (MakeConstant (VarRank (yyV1)));
# line 154 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 156 "CodeMapping.puma"
   cname = MakeDalibId ("array_make_dsp");
# line 158 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 159 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 161 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
  {
   return call;
  }
 }

}

tTree DalibArrayDefine
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree dim_list, register int kind)
# else
(var, dim_list, kind)
 register tTree var;
 register tTree dim_list;
 register int kind;
# endif
{
# line 183 "CodeMapping.puma"
  {
# line 185 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL1;
  {
# line 186 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

# line 191 "CodeMapping.puma"
  {
# line 193 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL2;
  {
# line 194 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

# line 199 "CodeMapping.puma"
  {
# line 201 "CodeMapping.puma"
   if (! ((kind == kLOCAL_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 206 "CodeMapping.puma"
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  {
# line 208 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL4;
  {
# line 210 "CodeMapping.puma"

# line 211 "CodeMapping.puma"

# line 212 "CodeMapping.puma"

# line 213 "CodeMapping.puma"

# line 215 "CodeMapping.puma"
   params = MakeExtensionParams (dim_list);
# line 217 "CodeMapping.puma"
   cname = MakeDalibId ("array_get_define");
# line 219 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, DUMMY_SUFFIX));
# line 220 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 221 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 222 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 224 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
  }
  {
   return call;
  }
 }
yyL4:;

# line 228 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  {
# line 230 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 232 "CodeMapping.puma"
   if (! ((IsRaggedVarObject (yyV1)))) goto yyL5;
  }
  {
   return TriDenTArrayDefine (var, dim_list, kind);
  }
 }
yyL5:;

# line 237 "CodeMapping.puma"
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  {
# line 239 "CodeMapping.puma"

# line 240 "CodeMapping.puma"

# line 241 "CodeMapping.puma"

# line 242 "CodeMapping.puma"

# line 244 "CodeMapping.puma"
   params = MakeExtensionParams (dim_list);
# line 246 "CodeMapping.puma"
   cname = MakeDalibId ("array_define");
# line 248 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 249 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 251 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
  {
   return call;
  }
 }

}

tTree DalibArrayCreateCopy
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 265 "CodeMapping.puma"
 {
  tTree param;
  tTree paramlist;
  tIdent cname;
  {
# line 267 "CodeMapping.puma"

# line 268 "CodeMapping.puma"

# line 269 "CodeMapping.puma"

# line 271 "CodeMapping.puma"
   paramlist = mBTP_EMPTY ();
# line 272 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 273 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 274 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, DYNAMIC_SUFFIX));
# line 275 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 277 "CodeMapping.puma"
   cname = MakeDalibId ("array_create_copy");
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), paramlist));
  }
 }

}

tTree DalibArrayOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 296 "CodeMapping.puma"
  {
# line 298 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL1;
  {
# line 299 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

# line 304 "CodeMapping.puma"
  {
# line 306 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL2;
  {
# line 307 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

# line 312 "CodeMapping.puma"
 {
  tTree dim_list;
  tDefinitions yyV1;
  tTree params;
  tIdent cname;
  {
# line 314 "CodeMapping.puma"

# line 316 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 318 "CodeMapping.puma"
   dim_list = ArrayFormals (yyV1);
# line 320 "CodeMapping.puma"
   if (! ((IsOverlappedShape (dim_list)))) goto yyL3;
  {
# line 322 "CodeMapping.puma"

# line 323 "CodeMapping.puma"

# line 325 "CodeMapping.puma"
   params = MakeOverlapParams (dim_list);
# line 327 "CodeMapping.puma"
   cname = MakeDalibId ("array_overlap");
# line 329 "CodeMapping.puma"
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX)), params);
  }
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
 }
yyL3:;

# line 335 "CodeMapping.puma"
   return NoTree;

}

static tTree MakeOverlapParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHAPE_EMPTY) {
# line 347 "CodeMapping.puma"
   return mBTP_EMPTY ();

  }
  if (t->Kind == kSHAPE_LIST) {
# line 351 "CodeMapping.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 353 "CodeMapping.puma"
   GetDimOverlap (t->SHAPE_LIST.Elem, & yyV1, & yyV2);
  }
  {
   return mBTP_LIST (ExpToVarParam (MakeConstant (yyV1)), mBTP_LIST (ExpToVarParam (MakeConstant (yyV2)), MakeOverlapParams (t->SHAPE_LIST.Next)));
  }
 }

  }
# line 360 "CodeMapping.puma"
  {
# line 361 "CodeMapping.puma"
   failure_protocol (MODULE, "MakeOverlapParams", t);
  }
   return NoTree;

}

static void GetDimOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree formal, register int * yyP2, register int * yyP1)
# else
(formal, yyP2, yyP1)
 register tTree formal;
 register int * yyP2;
 register int * yyP1;
# endif
{
  if (formal->Kind == kOVERLAP_SPEC) {
# line 373 "CodeMapping.puma"
   * yyP2 = formal->OVERLAP_SPEC.left_size;
   * yyP1 = formal->OVERLAP_SPEC.right_size;
   return;

  }
  if (Tree_IsType (formal, kSHAPE_SPEC)) {
# line 376 "CodeMapping.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 378 "CodeMapping.puma"
   GetDimOverlap (formal->SHAPE_SPEC.Overlap, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
# line 381 "CodeMapping.puma"
  {
# line 382 "CodeMapping.puma"
   failure_protocol (MODULE, "GetDimOverlap", formal);
  }
   * yyP2 = 0;
   * yyP1 = 0;
   return;

;
}

tTree DalibArrayDataFree
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 397 "CodeMapping.puma"
 {
  tTree params;
  tTree call;
  {
# line 399 "CodeMapping.puma"

# line 400 "CodeMapping.puma"

# line 402 "CodeMapping.puma"
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX)), mBTP_EMPTY ());
# line 405 "CodeMapping.puma"
 call  = mPROC_OBJ (MakeDalibId ("array_data_free")); 
# line 407 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

}

tTree DalibArrayFree
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 424 "CodeMapping.puma"
  {
# line 426 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 430 "CodeMapping.puma"
  {
# line 432 "CodeMapping.puma"
   if (! ((kind == kLOCAL_DSP))) goto yyL2;
  }
   return NoTree;
yyL2:;

# line 436 "CodeMapping.puma"
  {
# line 438 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 442 "CodeMapping.puma"
 {
  tTree params;
  tTree call;
  {
# line 444 "CodeMapping.puma"

# line 445 "CodeMapping.puma"

# line 447 "CodeMapping.puma"
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX)), mBTP_EMPTY ());
# line 450 "CodeMapping.puma"
 call  = mPROC_OBJ (MakeDalibId ("array_free")); 
# line 452 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

}

tTree DalibArrayDistribute
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 471 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  {
# line 473 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 475 "CodeMapping.puma"
   if (! ((NoCopyInCopyOut (yyV1, kind)))) goto yyL1;
  }
  {
   return NoTree;
  }
 }
yyL1:;

# line 480 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  tDefinitions yyV4;
  tDefinitions yyV5;
  tTree params;
  tIdent cname;
  tTree d_stmt;
  tTree s_stmt;
  {
# line 482 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 484 "CodeMapping.puma"
   GetObjDistributionData (yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 486 "CodeMapping.puma"
   if (! ((yyV1 == yyV2))) goto yyL2;
  {
# line 488 "CodeMapping.puma"

# line 489 "CodeMapping.puma"

# line 490 "CodeMapping.puma"

# line 491 "CodeMapping.puma"

# line 493 "CodeMapping.puma"
   params = MakeDistributeParams (yyV5);
# line 494 "CodeMapping.puma"
   params = mBTP_LIST (MakeTopologyParam (GetTopologyObj (yyV2)), params);
# line 496 "CodeMapping.puma"
   cname = MakeDalibId ("distribute");
# line 498 "CodeMapping.puma"
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX)), params);
# line 501 "CodeMapping.puma"
   d_stmt = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
# line 502 "CodeMapping.puma"
   d_stmt = mACF_LIST (d_stmt, NoTree);
# line 504 "CodeMapping.puma"
   s_stmt = MakeSubProcStmt (GetTopologyObj (yyV2));
  }
  }
  {
   return CombineACF (s_stmt, d_stmt);
  }
 }
yyL2:;

# line 509 "CodeMapping.puma"
   return NoTree;

}

tTree DalibArrayShared
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 530 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  {
# line 532 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 534 "CodeMapping.puma"
   GetObjSharedInfo (yyV1, & yyV2);
# line 536 "CodeMapping.puma"
   if (! ((! yyV2))) goto yyL1;
  }
  {
   return NoTree;
  }
 }
yyL1:;

# line 541 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  tTree params;
  tIdent cname;
  {
# line 543 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 545 "CodeMapping.puma"
   GetObjSharedInfo (yyV1, & yyV2);
# line 547 "CodeMapping.puma"

# line 548 "CodeMapping.puma"

# line 550 "CodeMapping.puma"
   params = mBTP_EMPTY ();
# line 552 "CodeMapping.puma"
 if (yyV2 == 1) 
         cname = MakeDalibId ("array_shared");
       else
         cname = MakeDalibId ("array_rma");
    
# line 558 "CodeMapping.puma"
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX)), params);
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
 }

}

tTree DalibAlignSource
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 579 "CodeMapping.puma"
  {
# line 581 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL1;
  {
# line 582 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

# line 587 "CodeMapping.puma"
  {
# line 589 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL2;
  {
# line 590 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

# line 595 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  tDefinitions yyV4;
  tDefinitions yyV5;
  tTree param;
  tTree params;
  tIdent cname;
  {
# line 597 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 599 "CodeMapping.puma"
   GetObjDistributionData (yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 601 "CodeMapping.puma"
   if (! ((yyV1 != yyV2))) goto yyL3;
  {
# line 603 "CodeMapping.puma"

# line 604 "CodeMapping.puma"

# line 605 "CodeMapping.puma"

# line 607 "CodeMapping.puma"
   params = MakeSourceParams (yyV5);
# line 608 "CodeMapping.puma"
   param = mVAR_PARAM (MakeUsedVarA (yyV2->Object.Ident, LOCAL_SUFFIX));
# line 609 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 611 "CodeMapping.puma"
   cname = MakeDalibId ("align_source");
# line 613 "CodeMapping.puma"
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX)), params);
  }
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
 }
yyL3:;

# line 619 "CodeMapping.puma"
  {
# line 620 "CodeMapping.puma"
   failure_protocol (MODULE, "DalibAlignSource", NoTree);
  }
   return NoTree;

}

tTree DalibAlignTarget
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 632 "CodeMapping.puma"
  {
# line 634 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL1;
  {
# line 635 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

# line 640 "CodeMapping.puma"
  {
# line 642 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL2;
  {
# line 643 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

# line 648 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  tDefinitions yyV4;
  tDefinitions yyV5;
  tTree param;
  tTree params;
  tIdent cname;
  {
# line 650 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 652 "CodeMapping.puma"
   GetObjDistributionData (yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 654 "CodeMapping.puma"
   if (! ((yyV1 != yyV2))) goto yyL3;
  {
# line 656 "CodeMapping.puma"

# line 657 "CodeMapping.puma"

# line 658 "CodeMapping.puma"

# line 660 "CodeMapping.puma"
   params = MakeTargetParams (yyV4);
# line 661 "CodeMapping.puma"
   param = mVAR_PARAM (MakeUsedVarA (yyV2->Object.Ident, LOCAL_SUFFIX));
# line 662 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 664 "CodeMapping.puma"
   cname = MakeDalibId ("align_target");
# line 666 "CodeMapping.puma"
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX)), params);
  }
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
 }
yyL3:;

# line 672 "CodeMapping.puma"
  {
# line 673 "CodeMapping.puma"
   failure_protocol (MODULE, "DalibAlignTarget", NoTree);
  }
   return NoTree;

}

static tTree MakeSourceParams
# if defined __STDC__ | defined __cplusplus
(register tDefinitions ilist)
# else
(ilist)
 register tDefinitions ilist;
# endif
{
  if (ilist->Kind == kDIM_EMPTY) {
# line 679 "CodeMapping.puma"
   return mBTP_EMPTY ();

  }
  if (ilist->Kind == kDIM_LIST) {
  if (ilist->DIM_LIST.Elem->Kind == kAlignedDimension) {
# line 683 "CodeMapping.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (kALIGNED_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DIM_LIST.Elem->AlignedDimension.template_dim)), mBTP_LIST (ExpToVarParam (ilist->DIM_LIST.Elem->AlignedDimension.add), mBTP_LIST (ExpToVarParam (ilist->DIM_LIST.Elem->AlignedDimension.mult), MakeSourceParams (ilist->DIM_LIST.Next)))));

  }
  if (ilist->DIM_LIST.Elem->Kind == kSerialDimension) {
# line 693 "CodeMapping.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (kSERIAL_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DIM_LIST.Elem->SerialDimension.dimension)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (1)), MakeSourceParams (ilist->DIM_LIST.Next)))));

  }
  }
 yyAbort ("MakeSourceParams");
}

static tTree MakeTargetParams
# if defined __STDC__ | defined __cplusplus
(register tDefinitions plist)
# else
(plist)
 register tDefinitions plist;
# endif
{
  if (plist->Kind == kDIM_EMPTY) {
# line 703 "CodeMapping.puma"
   return mBTP_EMPTY ();

  }
  if (plist->Kind == kDIM_LIST) {
  if (plist->DIM_LIST.Elem->Kind == kAlignedDimension) {
# line 707 "CodeMapping.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (kSOURCE_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (plist->DIM_LIST.Elem->AlignedDimension.dimension)), MakeTargetParams (plist->DIM_LIST.Next)));

  }
  if (plist->DIM_LIST.Elem->Kind == kReplicatedDimension) {
# line 714 "CodeMapping.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (kREPLICATED_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (plist->DIM_LIST.Elem->ReplicatedDimension.dimension)), MakeTargetParams (plist->DIM_LIST.Next)));

  }
  if (plist->DIM_LIST.Elem->Kind == kEmbeddedDimension) {
# line 721 "CodeMapping.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (kEMBEDDED_DIM)), mBTP_LIST (ExpToVarParam (CopyTree (plist->DIM_LIST.Elem->EmbeddedDimension.val)), MakeTargetParams (plist->DIM_LIST.Next)));

  }
  }
# line 728 "CodeMapping.puma"
  {
# line 730 "CodeMapping.puma"
   failure_protocol (MODULE, "MakeTargetParams (unknown dim)", NoTree);
  }
   return NoTree;

}

tTree DalibArrayDynamic
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 742 "CodeMapping.puma"
  {
# line 744 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL1;
  {
# line 745 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

# line 750 "CodeMapping.puma"
  {
# line 752 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL2;
  {
# line 753 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

# line 758 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  {
# line 760 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 762 "CodeMapping.puma"
   if (! ((IsDynamic (yyV1)))) goto yyL3;
  {
# line 764 "CodeMapping.puma"

# line 765 "CodeMapping.puma"

# line 766 "CodeMapping.puma"

# line 767 "CodeMapping.puma"

# line 769 "CodeMapping.puma"
   params = mBTP_EMPTY ();
# line 771 "CodeMapping.puma"
   cname = MakeDalibId ("array_dynamic");
# line 773 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 774 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 776 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
  }
  {
   return call;
  }
 }
yyL3:;

# line 780 "CodeMapping.puma"
   return NoTree;

}

tTree DalibArrayTrace
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 793 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  {
# line 795 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 797 "CodeMapping.puma"
   if (! ((IsVarTraced (yyV1)))) goto yyL1;
  {
# line 799 "CodeMapping.puma"

# line 800 "CodeMapping.puma"

# line 801 "CodeMapping.puma"

# line 802 "CodeMapping.puma"

# line 804 "CodeMapping.puma"
   params = mBTP_EMPTY ();
# line 806 "CodeMapping.puma"
   cname = MakeDalibId ("array_trace");
# line 808 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 809 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 811 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
  }
  {
   return call;
  }
 }
yyL1:;

# line 815 "CodeMapping.puma"
   return NoTree;

}

tTree DalibCopyDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 828 "CodeMapping.puma"
 {
  tTree lhs;
  tTree rhs;
  tDefinitions yyV1;
  int yyV2;
  int yyV3;
  {
# line 830 "CodeMapping.puma"

# line 831 "CodeMapping.puma"

# line 833 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 835 "CodeMapping.puma"
   GetCopyInfo (yyV1, & yyV2, & yyV3);
# line 837 "CodeMapping.puma"
 if (IsVarDummy (yyV1))
         rhs =  mVAR_EXP (MakeVarSuffixA (var, DUMMY_SUFFIX));
       else
         rhs =  mVAR_EXP (MakeVarSuffixA (var, COMMON_SUFFIX));

      lhs = MakeVarSuffixA (var, LOCAL_SUFFIX);
    
  }
  {
   return mACF_BASIC (mASSIGN_STMT (lhs, rhs));
  }
 }

}

tTree DalibCopyIn
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 857 "CodeMapping.puma"

tTree param, paramlist;

  if (var->Kind == kSELECTED_VAR) {
# line 861 "CodeMapping.puma"
   return NoTree;

  }
# line 866 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  tTree lhs;
  tTree rhs;
  int yyV2;
  int yyV3;
  {
# line 868 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 870 "CodeMapping.puma"
   if (! ((IsVarDummy (yyV1)))) goto yyL2;
  {
# line 872 "CodeMapping.puma"
   if (! ((NoCopyInCopyOut (yyV1, kind)))) goto yyL2;
  {
# line 874 "CodeMapping.puma"

# line 875 "CodeMapping.puma"

# line 877 "CodeMapping.puma"
   GetCopyInfo (yyV1, & yyV2, & yyV3);
# line 879 "CodeMapping.puma"
 if (IsVarDummy (yyV1))
         rhs =  mVAR_EXP (MakeVarSuffixA (var, DUMMY_SUFFIX));
       else
         rhs =  mVAR_EXP (MakeVarSuffixA (var, COMMON_SUFFIX));

      lhs = MakeVarSuffixA (var, LOCAL_SUFFIX);
    
  }
  }
  }
  {
   return mACF_BASIC (mASSIGN_STMT (lhs, rhs));
  }
 }
yyL2:;

# line 891 "CodeMapping.puma"
  {
# line 893 "CodeMapping.puma"
   if (! ((kind == kSTATIC_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 897 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  int yyV3;
  bool is_char;
  {
# line 899 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 901 "CodeMapping.puma"
   if (! ((IsVarDummy (yyV1)))) goto yyL4;
  {
# line 903 "CodeMapping.puma"
   GetCopyInfo (yyV1, & yyV2, & yyV3);
# line 905 "CodeMapping.puma"

# line 907 "CodeMapping.puma"
   is_char = IsStringType (GetBaseType (GetObjectType (yyV1)));
# line 909 "CodeMapping.puma"
   paramlist = mBTP_EMPTY ();
# line 910 "CodeMapping.puma"
   param = ExpToVarParam (MakeConstant (yyV2));
# line 911 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 912 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, ""));
# line 913 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 914 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, DUMMY_SUFFIX));
# line 915 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 916 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 917 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
  }
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (MakeDalibCId ("copy_in", is_char)), paramlist));
  }
 }
yyL4:;

# line 924 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  int yyV3;
  {
# line 926 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 928 "CodeMapping.puma"
   if (! ((IsVarCommon (yyV1)))) goto yyL5;
  {
# line 929 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL5;
  {
# line 931 "CodeMapping.puma"
   GetCopyInfo (yyV1, & yyV2, & yyV3);
# line 933 "CodeMapping.puma"
   paramlist = mBTP_EMPTY ();
# line 934 "CodeMapping.puma"
   param = ExpToVarParam (MakeConstant (yyV2));
# line 935 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 936 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, ""));
# line 937 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 938 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, COMMON_SUFFIX));
# line 939 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 940 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 941 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
  }
  }
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (MakeDalibId ("copy_in")), paramlist));
  }
 }
yyL5:;

# line 949 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  tTree lhs;
  tTree rhs;
  {
# line 951 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 953 "CodeMapping.puma"
   if (! ((IsVarCommon (yyV1)))) goto yyL6;
  {
# line 954 "CodeMapping.puma"
   if (! ((kind == kALLOCATE_DSP))) goto yyL6;
  {
# line 956 "CodeMapping.puma"

# line 957 "CodeMapping.puma"

# line 959 "CodeMapping.puma"
   lhs = MakeVarSuffixA (var, COMMON_SUFFIX);
# line 960 "CodeMapping.puma"
   rhs = mVAR_EXP (MakeVarSuffixA (var, LOCAL_SUFFIX));
  }
  }
  }
  {
   return mACF_BASIC (mASSIGN_STMT (lhs, rhs));
  }
 }
yyL6:;

# line 965 "CodeMapping.puma"
   return NoTree;

}

tTree DalibCopyOut
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 972 "CodeMapping.puma"

tTree param, paramlist;

  if (var->Kind == kSELECTED_VAR) {
# line 976 "CodeMapping.puma"
   return NoTree;

  }
# line 981 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  {
# line 983 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 985 "CodeMapping.puma"
   if (! ((NoCopyInCopyOut (yyV1, kind)))) goto yyL2;
  }
  {
   return NoTree;
  }
 }
yyL2:;

# line 990 "CodeMapping.puma"
  {
# line 991 "CodeMapping.puma"
   if (! ((kind == kSTATIC_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 995 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  int yyV3;
  {
# line 997 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 999 "CodeMapping.puma"
   if (! ((IsVarDummy (yyV1)))) goto yyL4;
  {
# line 1001 "CodeMapping.puma"
   GetCopyInfo (yyV1, & yyV2, & yyV3);
# line 1003 "CodeMapping.puma"
   paramlist = mBTP_EMPTY ();
# line 1004 "CodeMapping.puma"
   param = ExpToVarParam (MakeConstant (yyV3));
# line 1005 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 1006 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, DUMMY_SUFFIX));
# line 1007 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 1008 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 1009 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
  }
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (MakeDalibId ("copy_out")), paramlist));
  }
 }
yyL4:;

# line 1015 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  int yyV3;
  {
# line 1017 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 1019 "CodeMapping.puma"
   if (! ((IsVarCommon (yyV1)))) goto yyL5;
  {
# line 1020 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL5;
  {
# line 1022 "CodeMapping.puma"
   GetCopyInfo (yyV1, & yyV2, & yyV3);
# line 1024 "CodeMapping.puma"
   paramlist = mBTP_EMPTY ();
# line 1025 "CodeMapping.puma"
   param = ExpToVarParam (MakeConstant (yyV3));
# line 1026 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 1027 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, COMMON_SUFFIX));
# line 1028 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 1029 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 1030 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
  }
  }
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (MakeDalibId ("copy_out")), paramlist));
  }
 }
yyL5:;

# line 1036 "CodeMapping.puma"
   return NoTree;

}

tTree DalibArrayRedistribute
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 1048 "CodeMapping.puma"
 {
  tTree param;
  tTree paramlist;
  tIdent cname;
  {
# line 1050 "CodeMapping.puma"

# line 1051 "CodeMapping.puma"

# line 1052 "CodeMapping.puma"

# line 1054 "CodeMapping.puma"
   paramlist = mBTP_EMPTY ();
# line 1055 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, DYNAMIC_SUFFIX));
# line 1056 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 1057 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 1058 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 1060 "CodeMapping.puma"
   cname = MakeDalibId ("redistribute");
  }
  {
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), paramlist));
  }
 }

}

tTree DalibArrayAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 1073 "CodeMapping.puma"
 {
  tDefinitions yyV1;
  {
# line 1075 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 1077 "CodeMapping.puma"
   if (! ((IsTreeObject (yyV1)))) goto yyL1;
  }
  {
   return TriDenTAllocate (var, kind);
  }
 }
yyL1:;

# line 1082 "CodeMapping.puma"
 {
  tTree paramlist;
  tTree param;
  tTree call;
  int rank;
  int i;
  tDefinitions yyV1;
  bool is_char;
  {
# line 1084 "CodeMapping.puma"

# line 1085 "CodeMapping.puma"

# line 1086 "CodeMapping.puma"

# line 1087 "CodeMapping.puma"

# line 1088 "CodeMapping.puma"

# line 1090 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 1092 "CodeMapping.puma"
   rank = VarRank (yyV1);
# line 1094 "CodeMapping.puma"
 if (IsRaggedVarObject (yyV1)) rank = 1; 
# line 1096 "CodeMapping.puma"
   paramlist = mBTP_EMPTY ();
# line 1098 "CodeMapping.puma"
 if (kind != kSTATIC_DSP)

       { for (i=rank; i>=1; i--)
            { param = mVAR_PARAM (MakeVarSuffixAn (var, "_DIM", i));
              paramlist = mBTP_LIST (param, paramlist);
            }
         param     = mVAR_PARAM (MakeVarSuffixA (var, "_ZERO"));
         paramlist = mBTP_LIST (param, paramlist);
       }
    
# line 1109 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, ""));
# line 1110 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 1111 "CodeMapping.puma"
   param = mVAR_PARAM (MakeVarSuffixA (var, LOCAL_SUFFIX));
# line 1112 "CodeMapping.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 1114 "CodeMapping.puma"

# line 1116 "CodeMapping.puma"
 is_char = IsStringType (GetBaseType (GetObjectType (yyV1)));

      if (kind == kALLOCATE_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_allocate", is_char));
      if (kind == kDUMMY_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
      if (kind == kASSUMED_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
      if (kind == kLOCAL_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
      if (kind == kSTATIC_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_setdata", is_char));
      if (kind == kTEMPLATE_DSP)
         { call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
           error_protocol ("cannot access/allocate templates");
         }
    
# line 1134 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (call, paramlist));
  }
  {
   return call;
  }
 }

}

tTree DalibTopCreate
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 1149 "CodeMapping.puma"
 {
  tTree param;
  tTree paramlist;
  tTree call;
  tDefinitions yyV1;
  tIdent yyV2;
  tTree yyV3;
  {
# line 1151 "CodeMapping.puma"

# line 1152 "CodeMapping.puma"

# line 1153 "CodeMapping.puma"

# line 1155 "CodeMapping.puma"
   GetVarObject (var, & yyV1);
# line 1156 "CodeMapping.puma"
   GetTopologyInfo (yyV1, & yyV2, & yyV3);
# line 1158 "CodeMapping.puma"
 paramlist = mBTP_EMPTY ();

    if (yyV3 == NoTree)
       param = ExpToVarParam (MakeConstant (1));
     else
       param = ExpToVarParam (yyV3);
    paramlist = mBTP_LIST (param, paramlist);

    param = mVAR_PARAM (MakeUsedVarA (yyV2, "_DSP"));
    paramlist = mBTP_LIST (param, paramlist);

    param = mVAR_PARAM (MakeUsedVarA (yyV2, "_TOPID"));
    paramlist = mBTP_LIST (param, paramlist);

    call = mPROC_OBJ (MakeDalibId ("top_create"));
    call = mACF_BASIC (mCALL_STMT (call, paramlist));
    call = mACF_LIST (call, NoTree);
  
  }
  {
   return call;
  }
 }

}

tTree MakeSubProcStmt
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1195 "CodeMapping.puma"
  {
# line 1197 "CodeMapping.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (obj->Kind == kTopologyObject) {
# line 1201 "CodeMapping.puma"
  {
# line 1203 "CodeMapping.puma"
   if (! ((obj->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  }
   return NoTree;
yyL2:;

  if (obj->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
# line 1207 "CodeMapping.puma"
   return NoTree;

  }
  if (obj->TopologyObject.decl->Kind == kSUB_PROCS_DECL) {
# line 1212 "CodeMapping.puma"
 {
  tTree call;
  tTree params;
  tTree param;
  {
# line 1216 "CodeMapping.puma"
   if (! ((! obj->TopologyObject.defined))) goto yyL4;
  {
# line 1218 "CodeMapping.puma"

# line 1219 "CodeMapping.puma"

# line 1220 "CodeMapping.puma"

# line 1222 "CodeMapping.puma"
   params = MakeSectionParams (obj->TopologyObject.decl->SUB_PROCS_DECL.DIMENSIONS);
# line 1223 "CodeMapping.puma"
   param = mVAR_PARAM (MakeUsedVarA (obj->TopologyObject.decl->SUB_PROCS_DECL.TOP->TOP_OBJ.Ident, "_DSP"));
# line 1224 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 1225 "CodeMapping.puma"
   param = MakeUsedVarA (obj->TopologyObject.decl->SUB_PROCS_DECL.Ident, "_TOPID");
# line 1226 "CodeMapping.puma"
   DefineNewIntVar (TreeVarName (param));
# line 1227 "CodeMapping.puma"
   param = mVAR_PARAM (param);
# line 1228 "CodeMapping.puma"
   params = mBTP_LIST (param, params);
# line 1229 "CodeMapping.puma"
   call = mPROC_OBJ (MakeDalibId ("subtop_create"));
# line 1230 "CodeMapping.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
# line 1232 "CodeMapping.puma"
   obj->TopologyObject.defined = 1;
  }
  }
  {
   return mACF_LIST (call, NoTree);
  }
 }
yyL4:;

  }
  }
# line 1237 "CodeMapping.puma"
   return NoTree;

}

tTree DistributionDecls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1252 "CodeMapping.puma"
  {
# line 1253 "CodeMapping.puma"
   if (! ((VarDistribution (obj) <= 0))) goto yyL1;
  }
   return MakeDescriptorDecls (obj);
yyL1:;

# line 1257 "CodeMapping.puma"
  {
# line 1258 "CodeMapping.puma"
   if (! ((IsAlignedObj (obj)))) goto yyL2;
  }
   return MakeDescriptorDecls (obj);
yyL2:;

# line 1262 "CodeMapping.puma"
  {
# line 1263 "CodeMapping.puma"
   if (! ((IsTranscriptiveObj (obj)))) goto yyL3;
  }
   return MakeDescriptorDecls (obj);
yyL3:;

# line 1267 "CodeMapping.puma"
  {
# line 1269 "CodeMapping.puma"
   if (! ((IsDistributedObj (obj)))) goto yyL4;
  }
   return MakeDescriptorDecls (obj);
yyL4:;

 yyAbort ("DistributionDecls");
}

static tTree MakeDescriptorDecls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1281 "CodeMapping.puma"
 {
  tTree descriptor;
  tTree vtype;
  {
# line 1283 "CodeMapping.puma"

# line 1284 "CodeMapping.puma"

# line 1286 "CodeMapping.puma"
   vtype = MakeIntegerType (default_addr_size);
# line 1288 "CodeMapping.puma"
   descriptor = mDECL_LIST (MakeVarDeclA (obj->Object.Ident, LOCAL_SUFFIX, vtype), NoTree);
# line 1291 "CodeMapping.puma"
 if (IsVarCommon (obj))
       descriptor = mDECL_LIST (MakeVarDeclA (obj->Object.Ident, COMMON_SUFFIX, vtype), 
                                descriptor);
   
# line 1296 "CodeMapping.puma"
 if (IsDynamic (obj))
       descriptor = mDECL_LIST (MakeVarDeclA (obj->Object.Ident, DYNAMIC_SUFFIX, vtype), 
                                descriptor);
   
  }
  {
   return descriptor;
  }
 }

}

static bool NoCopyInCopyOut
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int kind)
# else
(obj, kind)
 register tDefinitions obj;
 register int kind;
# endif
{
# line 1312 "CodeMapping.puma"
  {
# line 1314 "CodeMapping.puma"
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL1;
  }
   return true;
yyL1:;

# line 1317 "CodeMapping.puma"
  {
# line 1319 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL2;
  {
# line 1320 "CodeMapping.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 1323 "CodeMapping.puma"
  {
# line 1325 "CodeMapping.puma"
   if (! ((safety == 0))) goto yyL3;
  {
# line 1326 "CodeMapping.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL3;
  }
  }
   return true;
yyL3:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Kind == kRangeDistribution) {
# line 1329 "CodeMapping.puma"
   return true;

  }
  }
  return false;
}

static void GetVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions * yyP3)
# else
(var, yyP3)
 register tTree var;
 register tDefinitions * yyP3;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 1351 "CodeMapping.puma"
   * yyP3 = var->USED_VAR.VARNAME->VAR_OBJ.Object;
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 1354 "CodeMapping.puma"
   * yyP3 = var->SELECTED_VAR.SELECTOR->REC_COMP.Object;
   return;

  }
# line 1357 "CodeMapping.puma"
  {
# line 1359 "CodeMapping.puma"
   failure_protocol (MODULE, "GetVarObject", var);
  }
   * yyP3 = NoObject;
   return;

;
}

static void GetSizeOfObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int * yyP4)
# else
(obj, yyP4)
 register tDefinitions obj;
 register int * yyP4;
# endif
{
# line 1370 "CodeMapping.puma"
  {
# line 1372 "CodeMapping.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 1373 "CodeMapping.puma"
   failure_protocol (MODULE, "GetSizeOfObject", NoTree);
  }
  }
   * yyP4 = 0;
   return;
yyL1:;

  if (obj->Kind == kTemplateObject) {
# line 1376 "CodeMapping.puma"
   * yyP4 = 0;
   return;

  }
  if (obj->Kind == kTopologyObject) {
# line 1379 "CodeMapping.puma"
   * yyP4 = 0;
   return;

  }
  if (obj->Kind == kVarObject) {
# line 1382 "CodeMapping.puma"
   * yyP4 = TreeSize (GetBaseType (GetObjectType (obj)));
   return;

  }
# line 1385 "CodeMapping.puma"
  {
# line 1387 "CodeMapping.puma"
   failure_protocol (MODULE, "GetSizeOfObject", obj->Object.decl);
  }
   * yyP4 = 0;
   return;

;
}

static void GetTopologyInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tIdent * yyP6, register tTree * yyP5)
# else
(obj, yyP6, yyP5)
 register tDefinitions obj;
 register tIdent * yyP6;
 register tTree * yyP5;
# endif
{
  if (obj->Kind == kTopologyObject) {
# line 1398 "CodeMapping.puma"
   * yyP6 = obj->TopologyObject.Ident;
   * yyP5 = obj->TopologyObject.target;
   return;

  }
# line 1401 "CodeMapping.puma"
  {
# line 1403 "CodeMapping.puma"
   failure_protocol (MODULE, "GetTopologyInfo", obj->Object.decl);
  }
   * yyP6 = DefaultId ();
   * yyP5 = NoTree;
   return;

;
}

static void GetDistOfObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions * yyP7)
# else
(obj, yyP7)
 register tDefinitions obj;
 register tDefinitions * yyP7;
# endif
{
# line 1415 "CodeMapping.puma"
  {
# line 1417 "CodeMapping.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 1418 "CodeMapping.puma"
   failure_protocol (MODULE, "GetDistOfObject", NoTree);
  }
  }
   * yyP7 = NoDistribution;
   return;
yyL1:;

  if (obj->Kind == kTemplateObject) {
# line 1421 "CodeMapping.puma"
   * yyP7 = obj->TemplateObject.Dist;
   return;

  }
  if (obj->Kind == kVarObject) {
# line 1424 "CodeMapping.puma"
   * yyP7 = obj->VarObject.Dist;
   return;

  }
# line 1427 "CodeMapping.puma"
  {
# line 1429 "CodeMapping.puma"
   failure_protocol (MODULE, "GetDistOfObject", obj->Object.decl);
  }
   * yyP7 = NoDistribution;
   return;

;
}

static void GetObjSharedInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int * yyP8)
# else
(obj, yyP8)
 register tDefinitions obj;
 register int * yyP8;
# endif
{
# line 1439 "CodeMapping.puma"
  {
# line 1441 "CodeMapping.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 1442 "CodeMapping.puma"
   failure_protocol (MODULE, "GetObjSharedInfo", NoTree);
  }
  }
   * yyP8 = 0;
   return;
yyL1:;

  if (obj->Kind == kTemplateObject) {
# line 1445 "CodeMapping.puma"
   * yyP8 = obj->TemplateObject.Dist->Distribution.shared;
   return;

  }
  if (obj->Kind == kVarObject) {
# line 1448 "CodeMapping.puma"
   * yyP8 = obj->VarObject.Dist->Distribution.shared;
   return;

  }
# line 1451 "CodeMapping.puma"
  {
# line 1453 "CodeMapping.puma"
   failure_protocol (MODULE, "GetObjSharedInfo", obj->Object.decl);
  }
   * yyP8 = 0;
   return;

;
}

static void GetObjDistributionData
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions * yyP12, register tDefinitions * yyP11, register tDefinitions * yyP10, register tDefinitions * yyP9)
# else
(obj, yyP12, yyP11, yyP10, yyP9)
 register tDefinitions obj;
 register tDefinitions * yyP12;
 register tDefinitions * yyP11;
 register tDefinitions * yyP10;
 register tDefinitions * yyP9;
# endif
{
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Kind == kNodeDistribution) {
# line 1465 "CodeMapping.puma"
   * yyP12 = obj;
   * yyP11 = obj->TemplateObject.Dist;
   * yyP10 = obj->TemplateObject.Dist->NodeDistribution.ArrayList;
   * yyP9 = obj->TemplateObject.Dist->NodeDistribution.ArrayList;
   return;

  }
  }
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Kind == kNodeDistribution) {
# line 1469 "CodeMapping.puma"
   * yyP12 = obj;
   * yyP11 = obj->VarObject.Dist;
   * yyP10 = obj->VarObject.Dist->NodeDistribution.ArrayList;
   * yyP9 = obj->VarObject.Dist->NodeDistribution.ArrayList;
   return;

  }
  if (obj->VarObject.Dist->Kind == kAlignDistribution) {
# line 1473 "CodeMapping.puma"
   * yyP12 = obj->VarObject.Dist->AlignDistribution.template_obj;
   * yyP11 = obj->VarObject.Dist;
   * yyP10 = obj->VarObject.Dist->AlignDistribution.TargetList;
   * yyP9 = obj->VarObject.Dist->AlignDistribution.SourceList;
   return;

  }
  }
# line 1478 "CodeMapping.puma"
  {
# line 1479 "CodeMapping.puma"
   obj_error_protocol ("no distribution for this object", obj);
# line 1480 "CodeMapping.puma"
   failure_protocol (MODULE, "GetObjDistributionData", obj->Object.decl);
  }
   * yyP12 = NoObject;
   * yyP11 = NoObject;
   * yyP10 = NoObject;
   * yyP9 = NoObject;
   return;

;
}

static void GetCopyInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int * yyP14, register int * yyP13)
# else
(obj, yyP14, yyP13)
 register tDefinitions obj;
 register int * yyP14;
 register int * yyP13;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 1491 "CodeMapping.puma"
  {
# line 1493 "CodeMapping.puma"
   if (! ((obj->VarObject.Kind->VarDummy.Intent == IntentIn))) goto yyL1;
  }
   * yyP14 = 1;
   * yyP13 = 0;
   return;
yyL1:;

# line 1496 "CodeMapping.puma"
  {
# line 1498 "CodeMapping.puma"
   if (! ((obj->VarObject.Kind->VarDummy.Intent == IntentOut))) goto yyL2;
  }
   * yyP14 = 0;
   * yyP13 = 1;
   return;
yyL2:;

  }
# line 1501 "CodeMapping.puma"
   * yyP14 = 1;
   * yyP13 = 1;
   return;

  }
;
}

void BeginCodeMapping ()
{
}

void CloseCodeMapping ()
{
}
