# include "CodeGeneration.h"
# include "yyCodeGeneration.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 31 "CodeGeneration.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "Types.h"

# include "DefTable.h"

# include "protocol.h"

# include "Objects.h"

# include "Transform.h"       /* Replace*, Make*                        */
# include "Dalib.h"           /* MakeDalibId, ...                       */

# include "ArrayData.h"       /* SetActualOverlap                       */
# include "CodeVars.h"        /* all exported functions */
# include "CodeDescriptors.h" /* all exported functions */
# include "CodeMapping.h"     /* all exported functions */
# include "CodeMovement.h"
# include "Selection.h"
# include "CodeGlobal.h"      /* CodeReduction, CodeBroadcast         */
# include "Expressions.h"
# include "Scatter.h"         /* CodeScatterStmt */
# include "CodeCalling.h"     /* CodeCalling, UpdateLocalCall */
# include "CodeOn.h"          /* ApplyOnSpecs                  */
# include "CodeGeneral.h"
# include "Nesting.h"
# include "Distributions.h"
# include "Intrinsics.h"

# include "Localization.h"    /* Localize */

# define MODULE "CodeGeneration"

static int section_counter;

static int is_task_region   = 0;  /* within TASK_REGION > 0 */

tIdent MakeDalibRoutine (name)

tIdent name;

{ /* replace name with corresponding dalib id */

  char new_name[100];
 
  GetString (name, new_name);
 
  return MakeDalibId (new_name);

} /* MakeDalibRoutine */
 


static void yyExit () { Exit (1); }

void (* CodeGeneration_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeGeneration, routine %s failed\n", yyFunction);
 CodeGeneration_Exit ();
}

void NodeAdapt ARGS((tTree t));
static tTree UnitsAdapt ARGS((tTree t));
static tTree CodeBody ARGS((tTree body));
static tTree CodeBody1 ARGS((tTree body));
static tTree TransformDECL ARGS((tTree t));
static tTree CodeACFNodes ARGS((tTree t));
static tTree TransformCommonDECL ARGS((tTree t));
static void CodeDummyList ARGS((tTree t));
static void TranslateFormals ARGS((tTree dummies, tTree * yyP2, tTree * yyP1));
static void InsertDecls ARGS((tTree body, tTree dummy_decls));
static tTree CodeInterface ARGS((tTree t));
static tTree CodeInterfaceRoutines ARGS((tTree items));
static tTree MergeDecls ARGS((tTree item, tTree tail));
static tTree CodeInterfaceRoutine ARGS((tTree item));

void NodeAdapt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
# line 94 "CodeGeneration.puma"
  {
# line 96 "CodeGeneration.puma"
   open_protocol ("adaptor.code");
# line 97 "CodeGeneration.puma"
 t->COMP_UNIT.COMP_ELEMENTS = UnitsAdapt (t->COMP_UNIT.COMP_ELEMENTS); 
# line 98 "CodeGeneration.puma"
   close_protocol ();
  }
   return;

  }
;
}

static tTree UnitsAdapt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kUNIT_LIST:
# line 109 "CodeGeneration.puma"
 {
  tTree new_decl;
  {
# line 111 "CodeGeneration.puma"

# line 113 "CodeGeneration.puma"
 new_decl = UnitsAdapt (t->UNIT_LIST.Elem);
     t->UNIT_LIST.Next     = UnitsAdapt (t->UNIT_LIST.Next);
     new_decl = ReplaceUNIT (t, new_decl, t->UNIT_LIST.Next);
   
  }
  {
   return new_decl;
  }
 }

  case kUNIT_EMPTY:
# line 121 "CodeGeneration.puma"
   return t;

  case kPROGRAM_DECL:
# line 126 "CodeGeneration.puma"
  {
# line 128 "CodeGeneration.puma"
   NestOpenUnit (t);
# line 129 "CodeGeneration.puma"
 t->PROGRAM_DECL.PROGRAM_BODY = CodeBody (t->PROGRAM_DECL.PROGRAM_BODY); 
# line 130 "CodeGeneration.puma"
   NestCloseUnit (t);
  }
   return t;

  case kPROC_DECL:
# line 134 "CodeGeneration.puma"
  {
# line 136 "CodeGeneration.puma"
   NestOpenUnit (t);
# line 138 "CodeGeneration.puma"
 t->PROC_DECL.PROC_BODY = CodeBody (t->PROC_DECL.PROC_BODY); 
# line 139 "CodeGeneration.puma"
   CodeDummyList (t);
# line 140 "CodeGeneration.puma"
   NestCloseUnit (t);
  }
   return t;

  case kFUNC_DECL:
# line 144 "CodeGeneration.puma"
  {
# line 146 "CodeGeneration.puma"
   error_protocol ("no longer any functions");
  }
   return NoTree;

  case kMODULE_DECL:
# line 150 "CodeGeneration.puma"
  {
# line 152 "CodeGeneration.puma"
   NestOpenUnit (t);
# line 153 "CodeGeneration.puma"
 t->MODULE_DECL.MODULE_BODY = CodeBody (t->MODULE_DECL.MODULE_BODY); 
# line 154 "CodeGeneration.puma"
   NestCloseUnit (t);
  }
   return t;

  case kBLOCK_DATA_DECL:
# line 158 "CodeGeneration.puma"
  {
# line 160 "CodeGeneration.puma"
   NestOpenUnit (t);
# line 161 "CodeGeneration.puma"
 t->BLOCK_DATA_DECL.DATA_BODY = CodeBody1 (t->BLOCK_DATA_DECL.DATA_BODY); 
# line 162 "CodeGeneration.puma"
   NestCloseUnit (t);
  }
   return t;

  }

# line 166 "CodeGeneration.puma"
  {
# line 167 "CodeGeneration.puma"
   failure_protocol (MODULE, "UnitsAdapt", t);
  }
   return NoTree;

}

static tTree CodeBody
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 182 "CodeGeneration.puma"
  {
# line 184 "CodeGeneration.puma"
 NewDefines  = NoTree;              
     NewHelpVars = mDECL_EMPTY();       
     body->BODY_NODE.STATS = CodeACFNodes (body->BODY_NODE.STATS);
     body->BODY_NODE.DECLS = TransformDECL (body->BODY_NODE.DECLS);
     body->BODY_NODE.STATS = CombineACF (NewDefines, body->BODY_NODE.STATS);
     
     Localize (body);
     

     body->BODY_NODE.DECLS = AppendDECLS (body->BODY_NODE.DECLS, NewHelpVars);

   
# line 197 "CodeGeneration.puma"
   if (! (UnitsAdapt (body->BODY_NODE.INTERNALS))) goto yyL1;
  }
   return body;
yyL1:;

  }
# line 201 "CodeGeneration.puma"
  {
# line 202 "CodeGeneration.puma"
   failure_protocol (MODULE, "CodeBody", body);
  }
   return NoTree;

}

static tTree CodeBody1
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 208 "CodeGeneration.puma"
  {
# line 210 "CodeGeneration.puma"
 NewDefines  = NoTree;              
     NewHelpVars = mDECL_EMPTY();       
     body->BODY_NODE.DECLS = TransformDECL (body->BODY_NODE.DECLS);
     
     Localize (body);
     body->BODY_NODE.DECLS = AppendDECLS (body->BODY_NODE.DECLS, NewHelpVars);
   
# line 218 "CodeGeneration.puma"
   if (! (UnitsAdapt (body->BODY_NODE.INTERNALS))) goto yyL1;
  }
   return body;
yyL1:;

  }
# line 222 "CodeGeneration.puma"
  {
# line 223 "CodeGeneration.puma"
   failure_protocol (MODULE, "CodeBody1", body);
  }
   return NoTree;

}

static tTree TransformDECL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kDECL_LIST:
# line 235 "CodeGeneration.puma"
 {
  tTree new_decl;
  {
# line 237 "CodeGeneration.puma"

# line 239 "CodeGeneration.puma"
 new_decl = TransformDECL (t->DECL_LIST.Elem);
       t->DECL_LIST.Next     = TransformDECL (t->DECL_LIST.Next);
       new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);
     
  }
  {
   return new_decl;
  }
 }

  case kDECL_EMPTY:
# line 247 "CodeGeneration.puma"
   return t;

  case kVAR_DECL:
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 251 "CodeGeneration.puma"
   return CodeVarDecl (t, GetLocalObject (t->VAR_DECL.Ident));

  }
# line 256 "CodeGeneration.puma"
  {
# line 260 "CodeGeneration.puma"
   if (! ((IsFuncObj (GetLocalObject (t->VAR_DECL.Ident))))) goto yyL4;
  {
# line 261 "CodeGeneration.puma"
   if (! ((IsStmtFunction (GetLocalObject (t->VAR_DECL.Ident))))) goto yyL4;
  }
  }
   return t;
yyL4:;

# line 266 "CodeGeneration.puma"
  {
# line 270 "CodeGeneration.puma"
   if (! ((IsFuncObj (GetLocalObject (t->VAR_DECL.Ident))))) goto yyL5;
  }
   return NoTree;
yyL5:;

# line 274 "CodeGeneration.puma"
 {
  tDefinitions Obj;
  {
# line 276 "CodeGeneration.puma"

# line 277 "CodeGeneration.puma"
   Obj = GetLocalObject (t->VAR_DECL.Ident);
  }
  {
   return t;
  }
 }

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
# line 281 "CodeGeneration.puma"
  {
# line 285 "CodeGeneration.puma"
   NestOpenType (t->TYPE_DECL.VAL);
# line 287 "CodeGeneration.puma"
 t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS = TransformDECL (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS); 
# line 289 "CodeGeneration.puma"
   NestCloseType (t->TYPE_DECL.VAL);
  }
   return t;

  }
  break;
  case kPARAMETER_DECL:
# line 294 "CodeGeneration.puma"
   return t;

  case kEXTERNAL_DECL:
# line 299 "CodeGeneration.puma"
   return t;

  case kINTRINSIC_DECL:
# line 304 "CodeGeneration.puma"
  {
# line 306 "CodeGeneration.puma"
   if (! ((IntrFuncRed (t->INTRINSIC_DECL.Ident)))) goto yyL10;
  }
   return NoTree;
yyL10:;

# line 311 "CodeGeneration.puma"
  {
# line 313 "CodeGeneration.puma"
   if (! ((t->INTRINSIC_DECL.Ident == IsIdent ("TRANSPOSE")))) goto yyL11;
  }
   return NoTree;
yyL11:;

# line 318 "CodeGeneration.puma"
   return t;

  case kIMPLICIT_DECL:
# line 323 "CodeGeneration.puma"
   return t;

  case kCOMMON_DECL:
# line 328 "CodeGeneration.puma"
  {
# line 329 "CodeGeneration.puma"
 t->COMMON_DECL.IDS = TransformCommonDECL (t->COMMON_DECL.IDS); 
  }
   return t;

  case kNAMELIST_DECL:
# line 333 "CodeGeneration.puma"
   return t;

  case kDATA_DECL:
# line 337 "CodeGeneration.puma"
   return t;

  case kSAVE_DECL:
# line 341 "CodeGeneration.puma"
   return t;

  case kSEQUENCE_DECL:
# line 345 "CodeGeneration.puma"
   return NoTree;

  case kHPF_SEQUENCE_DECL:
# line 349 "CodeGeneration.puma"
   return NoTree;

  case kNOSEQUENCE_DECL:
# line 353 "CodeGeneration.puma"
   return NoTree;

  case kEQV_DECL:
# line 357 "CodeGeneration.puma"
   return t;

  case kTEMPLATE_DECL:
# line 361 "CodeGeneration.puma"
   return CodeTemplateDecl (t, GetLocalObject (t->TEMPLATE_DECL.Ident));

  case kRAGGED_DECL:
# line 366 "CodeGeneration.puma"
   return CodeRaggedDecl (t, GetLocalObject (t->RAGGED_DECL.Ident));

  case kPROCESSORS_DECL:
# line 371 "CodeGeneration.puma"
   return CodeProcDecl (GetLocalObject (t->PROCESSORS_DECL.Ident));

  case kALIGN_DECL:
# line 376 "CodeGeneration.puma"
   return NoTree;

  case kDISTRIBUTE_DECL:
# line 381 "CodeGeneration.puma"
   return NoTree;

  case kRANGE_DECL:
# line 386 "CodeGeneration.puma"
   return NoTree;

  case kMAP_DECL:
# line 391 "CodeGeneration.puma"
   return NoTree;

  case kSHARED_DECL:
# line 396 "CodeGeneration.puma"
   return NoTree;

  case kOVERLAP_DECL:
# line 403 "CodeGeneration.puma"
   return NoTree;

  case kINHERIT_DECL:
# line 408 "CodeGeneration.puma"
   return NoTree;

  case kDYNAMIC_DECL:
# line 413 "CodeGeneration.puma"
   return NoTree;

  case kTRACE_DECL:
# line 418 "CodeGeneration.puma"
   return NoTree;

  case kSELECT_DECL:
# line 423 "CodeGeneration.puma"
   return NoTree;

  case kTREE_DECL:
# line 428 "CodeGeneration.puma"
   return NoTree;

  case kALLOCATABLE_DECL:
# line 433 "CodeGeneration.puma"
   return NoTree;

  case kPOINTER_DECL:
# line 438 "CodeGeneration.puma"
   return t;

  case kTARGET_DECL:
# line 443 "CodeGeneration.puma"
   return t;

  case kINTENT_DECL:
# line 448 "CodeGeneration.puma"
   return NoTree;

  case kOPTIONAL_DECL:
# line 453 "CodeGeneration.puma"
   return NoTree;

  case kLAYOUT_DECL:
# line 458 "CodeGeneration.puma"
   return NoTree;

  case kPASS_BY_DECL:
# line 463 "CodeGeneration.puma"
   return NoTree;

  case kMAP_TO_DECL:
# line 467 "CodeGeneration.puma"
   return NoTree;

  case kINTERFACE_DECL:
# line 471 "CodeGeneration.puma"
   return CodeInterface (t);

  case kSTMT_FUNC_DECL:
# line 476 "CodeGeneration.puma"
   return t;

  case kUSE_DECL:
# line 481 "CodeGeneration.puma"
   return t;

  case kONLY_USE_DECL:
# line 485 "CodeGeneration.puma"
   return t;

  case kPUBLIC_DECL:
# line 489 "CodeGeneration.puma"
   return t;

  case kPRIVATE_DECL:
# line 493 "CodeGeneration.puma"
   return t;

  case kFORMAT_DECL:
# line 497 "CodeGeneration.puma"
   return t;

  }

# line 501 "CodeGeneration.puma"
  {
# line 502 "CodeGeneration.puma"
   failure_protocol (MODULE, "TransformDECL", t);
  }
   return t;

}

static tTree CodeACFNodes
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 514 "CodeGeneration.puma"
 {
  tTree newacf;
  {
# line 516 "CodeGeneration.puma"

# line 518 "CodeGeneration.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 520 "CodeGeneration.puma"
 newacf = CodeACFNodes (t->ACF_LIST.Elem);            
     t->ACF_LIST.Next   = CodeACFNodes (t->ACF_LIST.Next);            
   
# line 524 "CodeGeneration.puma"
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
  {
   return newacf;
  }
 }

  case kACF_EMPTY:
# line 529 "CodeGeneration.puma"
   return t;

  case kACF_WHILE:
# line 538 "CodeGeneration.puma"
  {
# line 540 "CodeGeneration.puma"
 t->ACF_WHILE.WHILE_BODY = CodeACFNodes (t->ACF_WHILE.WHILE_BODY);
     UpdateLocalCalls (t->ACF_WHILE.WHILE_EXP);
   
  }
   return t;

  case kACF_DO:
  if (t->ACF_DO.DO_HOME_INFO->Kind == kON_INFO) {
# line 550 "CodeGeneration.puma"
 {
  tTree new;
  bool push_home;
  {
# line 552 "CodeGeneration.puma"

# line 553 "CodeGeneration.puma"

# line 555 "CodeGeneration.puma"
 push_home = (!NeedsNoContext (t->ACF_DO.DO_BODY));

     t->ACF_DO.DO_BODY = CodeACFNodes (t->ACF_DO.DO_BODY);
     UpdateLocalCalls (t->ACF_DO.DO_RANGE);

     new = ApplyOnInfo (t, push_home);

   
  }
  {
   return new;
  }
 }

  }
# line 571 "CodeGeneration.puma"
  {
# line 573 "CodeGeneration.puma"
 t->ACF_DO.DO_BODY = CodeACFNodes (t->ACF_DO.DO_BODY);
     UpdateLocalCalls (t->ACF_DO.DO_RANGE);
     CodeParallelLoop (t);
   
  }
   return t;

  case kACF_IF:
# line 585 "CodeGeneration.puma"
  {
# line 587 "CodeGeneration.puma"
 t->ACF_IF.THEN_PART = CodeACFNodes (t->ACF_IF.THEN_PART);
     t->ACF_IF.ELSE_PART = CodeACFNodes (t->ACF_IF.ELSE_PART);
     UpdateLocalCalls (t->ACF_IF.IF_EXP);
   
  }
   return t;

  case kACF_WHERE:
# line 599 "CodeGeneration.puma"
  {
# line 601 "CodeGeneration.puma"
   error_protocol ("WHERE should already be a local operation");
  }
   return NoTree;

  case kACF_TASK_REGION:
# line 609 "CodeGeneration.puma"
 {
  tTree init;
  tTree final;
  tTree new;
  {
# line 611 "CodeGeneration.puma"

# line 612 "CodeGeneration.puma"

# line 613 "CodeGeneration.puma"

# line 615 "CodeGeneration.puma"
 is_task_region++;
     init = NoTree;
     if (t->ACF_TASK_REGION.task_flag) init = CombineACF (StartTasking (), InitTaskRegion (t->ACF_TASK_REGION.TASK_BODY));
     new= CodeACFNodes (t->ACF_TASK_REGION.TASK_BODY);
     final = NoTree;
     if (t->ACF_TASK_REGION.task_flag) final = StopTasking ();
     is_task_region--;
     new = CombineACF (init, CombineACF (new, final));
   
  }
  {
   return new;
  }
 }

  case kACF_ON:
# line 638 "CodeGeneration.puma"
 {
  tTree new;
  {
# line 640 "CodeGeneration.puma"

# line 642 "CodeGeneration.puma"
 if (!NeedsNoContext (t->ACF_ON.ON_BODY))

       { new = CodeACFNodes (t->ACF_ON.ON_BODY);
         new = AppendBody (new, CodeONPopContext (t->ACF_ON.ON_HOME, t->ACF_ON.ON_SPECS));
         new = CombineACF (CodeONPushContext (t->ACF_ON.ON_HOME, t->ACF_ON.ON_SPECS), new);
       }

      else

         new = CodeACFNodes (t->ACF_ON.ON_BODY);

     new = ApplyOnSpecs (new, t->ACF_ON.ON_HOME, t->ACF_ON.ON_SPECS);
   
  }
  {
   return new;
  }
 }

  case kACF_CRITICAL:
# line 663 "CodeGeneration.puma"
  {
# line 665 "CodeGeneration.puma"
 t->ACF_CRITICAL.CRITICAL_BODY = CodeACFNodes (t->ACF_CRITICAL.CRITICAL_BODY); 
  }
   return t;

  case kACF_PARALLEL:
# line 674 "CodeGeneration.puma"
  {
# line 676 "CodeGeneration.puma"
 t->ACF_PARALLEL.PARALLEL_BODY = CodeACFNodes (t->ACF_PARALLEL.PARALLEL_BODY); 
  }
   return t;

  case kACF_BASIC:

  switch (t->ACF_BASIC.BASIC_STMT->Kind) {
  case kCALL_STMT:
# line 685 "CodeGeneration.puma"
   return CodeCalling (t);

  case kSCATTER_STMT:
# line 694 "CodeGeneration.puma"
 {
  tTree new;
  {
# line 696 "CodeGeneration.puma"

# line 698 "CodeGeneration.puma"
 stmt_protocol ("translate SCATTER");
      new = CodeScatterStmt (t->ACF_BASIC.BASIC_STMT);
      tree_protocol ("generated code : \n", new);
    
  }
  {
   return new;
  }
 }

  case kIO_STMT:
# line 787 "CodeGeneration.puma"
   return t;

  case kCREATE_DSP_STMT:
# line 796 "CodeGeneration.puma"
 {
  tTree new;
  {
# line 798 "CodeGeneration.puma"

# line 800 "CodeGeneration.puma"
   stmt_protocol ("translate of CREATE DSP");
# line 802 "CodeGeneration.puma"
   new = AdaptCreateDsp (t->ACF_BASIC.BASIC_STMT->CREATE_DSP_STMT.VAR, t->ACF_BASIC.BASIC_STMT->CREATE_DSP_STMT.SHAPE, t->ACF_BASIC.BASIC_STMT->CREATE_DSP_STMT.flag);
# line 804 "CodeGeneration.puma"
 if (new != NoTree)
        tree_protocol ("new CREATE DSP statements :\n", new);
   
  }
  {
   return new;
  }
 }

  case kINHERIT_DSP_STMT:
# line 815 "CodeGeneration.puma"
 {
  tTree new;
  {
# line 817 "CodeGeneration.puma"

# line 819 "CodeGeneration.puma"
   stmt_protocol ("translate of INHERIT DSP");
# line 821 "CodeGeneration.puma"
   new = AdaptInheritDsp (t->ACF_BASIC.BASIC_STMT->INHERIT_DSP_STMT.VAR, t->ACF_BASIC.BASIC_STMT->INHERIT_DSP_STMT.SHAPE, t->ACF_BASIC.BASIC_STMT->INHERIT_DSP_STMT.flag, t->ACF_BASIC.BASIC_STMT->INHERIT_DSP_STMT.safety);
# line 823 "CodeGeneration.puma"
   tree_protocol ("new INHERIT DSP statements :\n", new);
  }
  {
   return new;
  }
 }

  case kFREE_DSP_STMT:
# line 832 "CodeGeneration.puma"
   return AdaptFreeDsp (t->ACF_BASIC.BASIC_STMT->FREE_DSP_STMT.VAR, t->ACF_BASIC.BASIC_STMT->FREE_DSP_STMT.flag);

  case kALLOCATE_STMT:
# line 841 "CodeGeneration.puma"
 {
  tTree new;
  {
# line 843 "CodeGeneration.puma"

# line 845 "CodeGeneration.puma"
   stmt_protocol ("translate of ALLOCATE");
# line 847 "CodeGeneration.puma"
   new = AdaptAllocate (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS);
# line 849 "CodeGeneration.puma"
   tree_protocol ("new ALLOCATE statements :\n", new);
  }
  {
   return new;
  }
 }

  case kDEALLOCATE_STMT:
# line 854 "CodeGeneration.puma"
   return AdaptDeallocate (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS);

  case kREALIGN_STMT:
# line 859 "CodeGeneration.puma"
   return CodeRealign (t->ACF_BASIC.BASIC_STMT->REALIGN_STMT.ALIGNEE, t->ACF_BASIC.BASIC_STMT->REALIGN_STMT.distribution);

  case kREDISTRIBUTE_STMT:
# line 864 "CodeGeneration.puma"
   return CodeRedistribute (t->ACF_BASIC.BASIC_STMT->REDISTRIBUTE_STMT.DISTRIBUTEE, t->ACF_BASIC.BASIC_STMT->REDISTRIBUTE_STMT.distribution);

  case kREG_SHADOW_GET:
# line 869 "CodeGeneration.puma"
   return DalibArrayOverlapUpdate (t->ACF_BASIC.BASIC_STMT->REG_SHADOW_GET.SHADOW_VAR, t->ACF_BASIC.BASIC_STMT->REG_SHADOW_GET.SHADOW_SIZE);

  case kIND_SHADOW_CREATE:
# line 874 "CodeGeneration.puma"
   return CodeIndShadow (t->ACF_BASIC.BASIC_STMT);

  case kIND_SHADOW_FREE:
# line 879 "CodeGeneration.puma"
   return CodeIndShadow (t->ACF_BASIC.BASIC_STMT);

  case kIND_SHADOW_GET:
# line 884 "CodeGeneration.puma"
   return CodeIndShadow (t->ACF_BASIC.BASIC_STMT);

  case kIND_SHADOW_PUT:
# line 889 "CodeGeneration.puma"
   return CodeIndShadow (t->ACF_BASIC.BASIC_STMT);

  case kIND_SHADOW_SET:
# line 894 "CodeGeneration.puma"
   return CodeIndShadow (t->ACF_BASIC.BASIC_STMT);

  case kREDUCTION_STMT:
# line 899 "CodeGeneration.puma"
   return CodeReduction (t->ACF_BASIC.BASIC_STMT);

  case kBROADCAST_STMT:
# line 904 "CodeGeneration.puma"
   return CodeBroadcast (t->ACF_BASIC.BASIC_STMT);

  case kDIRTY_STMT:
# line 909 "CodeGeneration.puma"
   return CodeDirtyStmt (t->ACF_BASIC.BASIC_STMT->DIRTY_STMT.ELEMS);

  case kGOTO_STMT:
# line 914 "CodeGeneration.puma"
   return t;

  case kCOMP_IF_STMT:
# line 918 "CodeGeneration.puma"
   return t;

  case kASSIGN_STMT:
# line 928 "CodeGeneration.puma"
  {
# line 932 "CodeGeneration.puma"
   UpdateLocalCalls (t);
  }
   return t;

  }

# line 937 "CodeGeneration.puma"
   return t;

  case kACF_RM_READ:
# line 709 "CodeGeneration.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 711 "CodeGeneration.puma"

# line 712 "CodeGeneration.puma"

# line 714 "CodeGeneration.puma"
 params = MakeRemoteParams (t->ACF_RM_READ.REMOTE_VAR);
     params = mBTP_LIST (mVAR_PARAM (t->ACF_RM_READ.LOCAL_VAR), params);

     stmt = mPROC_OBJ (MakeDalibId ("rma_read"));
     stmt = mACF_BASIC (mCALL_STMT (stmt, params));
   
  }
  {
   return stmt;
  }
 }

  case kACF_RM_WRITE:
# line 728 "CodeGeneration.puma"
 {
  tTree stmt;
  tTree params;
  {
# line 730 "CodeGeneration.puma"

# line 731 "CodeGeneration.puma"

# line 733 "CodeGeneration.puma"
 params = MakeRemoteParams (t->ACF_RM_WRITE.REMOTE_VAR);
     params = mBTP_LIST (ExpToVarParam (t->ACF_RM_WRITE.LOCAL_DATA), params);

     if (t->ACF_RM_WRITE.op != 0) 
        params = mBTP_LIST (ExpToVarParam (MakeConstant (t->ACF_RM_WRITE.op)), params);

     if (t->ACF_RM_WRITE.op == 0)
        stmt = mPROC_OBJ (MakeDalibId ("rma_write"));
      else
        stmt = mPROC_OBJ (MakeDalibId ("rma_update"));

     stmt = mACF_BASIC (mCALL_STMT (stmt, params));
   
  }
  {
   return stmt;
  }
 }

  case kACF_BARRIER:
# line 754 "CodeGeneration.puma"
 {
  tTree stmt;
  {
# line 756 "CodeGeneration.puma"

# line 758 "CodeGeneration.puma"
 stmt = mPROC_OBJ (MakeDalibId ("barrier"));
     stmt = mACF_BASIC (mCALL_STMT (stmt, mBTP_EMPTY()));
   
  }
  {
   return stmt;
  }
 }

  case kACF_MOVE:
  if (t->ACF_MOVE.MOVE_STMT->Kind == kASSIGN_STMT) {
# line 769 "CodeGeneration.puma"
   return CodeMovement (t);

  }
  if (t->ACF_MOVE.MOVE_STMT->Kind == kMOVE_STMT) {
# line 778 "CodeGeneration.puma"
   return CodeMovement (t);

  }
  break;
  case kACF_DUMMY:
# line 942 "CodeGeneration.puma"
   return t;

  }

# line 947 "CodeGeneration.puma"
  {
# line 949 "CodeGeneration.puma"
   failure_protocol (MODULE, "CodeACFNodes", t);
  }
   return NoTree;

}

static tTree TransformCommonDECL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 961 "CodeGeneration.puma"
 {
  tTree new_decl;
  {
# line 963 "CodeGeneration.puma"

# line 965 "CodeGeneration.puma"
 new_decl = TransformCommonDECL (t->DECL_LIST.Elem);
       t->DECL_LIST.Next     = TransformCommonDECL (t->DECL_LIST.Next);
       new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);
     
  }
  {
   return new_decl;
  }
 }

  }
  if (t->Kind == kDECL_EMPTY) {
# line 972 "CodeGeneration.puma"
   return t;

  }
  if (t->Kind == kVAR_DECL) {
# line 976 "CodeGeneration.puma"
   return AdaptCommonVarDecl (t, VarDistribution (GetLocalObject (t->VAR_DECL.Ident)));

  }
# line 980 "CodeGeneration.puma"
  {
# line 981 "CodeGeneration.puma"
   failure_protocol (MODULE, "TransformCommonDECL", t);
  }
   return t;

}

static void CodeDummyList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
# line 996 "CodeGeneration.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 998 "CodeGeneration.puma"
   TranslateFormals (t->PROC_DECL.FORMALS, & yyV1, & yyV2);
# line 1000 "CodeGeneration.puma"
 t->PROC_DECL.FORMALS = AppendDECLS (t->PROC_DECL.FORMALS, yyV1); 
# line 1002 "CodeGeneration.puma"
   InsertDecls (t->PROC_DECL.PROC_BODY, yyV2);
  }
   return;
 }

  }
  if (t->Kind == kFUNC_DECL) {
# line 1005 "CodeGeneration.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 1007 "CodeGeneration.puma"
   TranslateFormals (t->FUNC_DECL.FORMALS, & yyV1, & yyV2);
# line 1009 "CodeGeneration.puma"
 t->FUNC_DECL.FORMALS = AppendDECLS (t->FUNC_DECL.FORMALS, yyV1); 
# line 1011 "CodeGeneration.puma"
   InsertDecls (t->FUNC_DECL.FUNC_BODY, yyV2);
  }
   return;
 }

  }
;
}

static void TranslateFormals
# if defined __STDC__ | defined __cplusplus
(register tTree dummies, register tTree * yyP2, register tTree * yyP1)
# else
(dummies, yyP2, yyP1)
 register tTree dummies;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (dummies->Kind == kDECL_LIST) {
# line 1016 "CodeGeneration.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 1019 "CodeGeneration.puma"
   TranslateFormals (dummies->DECL_LIST.Elem, & yyV1, & yyV2);
# line 1020 "CodeGeneration.puma"
   TranslateFormals (dummies->DECL_LIST.Next, & yyV3, & yyV4);
  }
   * yyP2 = mDECL_LIST (yyV1, yyV3);
   * yyP1 = mDECL_LIST (yyV2, yyV4);
   return;
 }

  }
  if (dummies->Kind == kDECL_EMPTY) {
# line 1023 "CodeGeneration.puma"
   * yyP2 = dummies;
   * yyP1 = mDECL_EMPTY ();
   return;

  }
  if (dummies->Kind == kVAR_PARAM_DECL) {
# line 1026 "CodeGeneration.puma"
 {
  tTree descr_dummy;
  tTree descr_decl;
  tTree vtype;
  {
# line 1028 "CodeGeneration.puma"

# line 1029 "CodeGeneration.puma"

# line 1030 "CodeGeneration.puma"

# line 1032 "CodeGeneration.puma"
 descr_dummy = MakeVarParamDeclA (dummies->VAR_PARAM_DECL.Ident, DUMMY_SUFFIX);
      vtype       = MakeIntegerType (default_addr_size);
      descr_decl  = MakeVarDeclA (dummies->VAR_PARAM_DECL.Ident, DUMMY_SUFFIX, vtype);
    
  }
   * yyP2 = descr_dummy;
   * yyP1 = descr_decl;
   return;
 }

  }
# line 1038 "CodeGeneration.puma"
  {
# line 1040 "CodeGeneration.puma"
   failure_protocol (MODULE, "TranslateFormals", dummies);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void InsertDecls
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree dummy_decls)
# else
(body, dummy_decls)
 register tTree body;
 register tTree dummy_decls;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 1045 "CodeGeneration.puma"
  {
# line 1047 "CodeGeneration.puma"
 body->BODY_NODE.DECLS = AppendDECLS (body->BODY_NODE.DECLS, dummy_decls); 
  }
   return;

  }
# line 1050 "CodeGeneration.puma"
  {
# line 1051 "CodeGeneration.puma"
   failure_protocol (MODULE, "InsertDecls", body);
  }
   return;

;
}

static tTree CodeInterface
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINTERFACE_DECL) {
# line 1072 "CodeGeneration.puma"
   return CodeInterfaceRoutines (t->INTERFACE_DECL.ITEMS);

  }
# line 1077 "CodeGeneration.puma"
  {
# line 1078 "CodeGeneration.puma"
   failure_protocol (MODULE, "CodeInterface", t);
  }
   return NoTree;

}

static tTree CodeInterfaceRoutines
# if defined __STDC__ | defined __cplusplus
(register tTree items)
# else
(items)
 register tTree items;
# endif
{
  if (items->Kind == kUNIT_LIST) {
# line 1090 "CodeGeneration.puma"
   return MergeDecls (CodeInterfaceRoutine (items->UNIT_LIST.Elem), CodeInterfaceRoutines (items->UNIT_LIST.Next));

  }
  if (items->Kind == kUNIT_EMPTY) {
# line 1096 "CodeGeneration.puma"
   return NoTree;

  }
# line 1101 "CodeGeneration.puma"
  {
# line 1102 "CodeGeneration.puma"
   failure_protocol (MODULE, "CodeInterfaceRoutines", items);
  }
   return NoTree;

}

static tTree MergeDecls
# if defined __STDC__ | defined __cplusplus
(register tTree item, register tTree tail)
# else
(item, tail)
 register tTree item;
 register tTree tail;
# endif
{
# line 1108 "CodeGeneration.puma"
  {
# line 1110 "CodeGeneration.puma"
   if (! ((item == NoTree))) goto yyL1;
  }
   return tail;
yyL1:;

# line 1114 "CodeGeneration.puma"
   return mDECL_LIST (item, tail);

}

static tTree CodeInterfaceRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree item)
# else
(item)
 register tTree item;
# endif
{
  if (item->Kind == kPROC_DECL) {
# line 1127 "CodeGeneration.puma"
   return mEXTERNAL_DECL (item->PROC_DECL.Ident, item->PROC_DECL.Line);

  }
  if (item->Kind == kFUNC_DECL) {
# line 1132 "CodeGeneration.puma"
  {
# line 1134 "CodeGeneration.puma"
   if (! ((IsF77Unit (item)))) goto yyL2;
  }
   return mVAR_DECL (item->FUNC_DECL.Ident, item->FUNC_DECL.Line, GetObjectType (GetLocalObject (item->FUNC_DECL.Ident)));
yyL2:;

  }
# line 1141 "CodeGeneration.puma"
   return NoTree;

}

void BeginCodeGeneration ()
{
}

void CloseCodeGeneration ()
{
}
