# include "CodeGeneral.h"
# include "yyCodeGeneral.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 49 "CodeGeneral.puma"


# define  MODULE      "CodeGeneral"

# include <stdio.h>
# include "protocol.h"
# include "Idents.h"
# include "StringMem.h"
# include "Types.h"
# include "TreeOps.h"    /* TreeVarName */

# include "DefTable.h"

# include "Expressions.h"
# include "Transform.h"
# include "Shapes.h"



static void yyExit () { Exit (1); }

void (* CodeGeneral_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeGeneral, routine %s failed\n", yyFunction);
 CodeGeneral_Exit ();
}

tTree FirstArrayElement ARGS((tTree t));
tTree MakeRemoteParams ARGS((tTree var));
tTree MakeDistributeParams ARGS((tDefinitions ilist));
tTree MakeTopologyParam ARGS((tDefinitions top_obj));
tTree MakeTreeSizeParam ARGS((tTree t));
void DefineNewIntVar ARGS((tIdent name));
void DefineNewCommonVar ARGS((tIdent cname, tIdent vname));
void DefineNewAddrVar ARGS((tIdent name));
static bool IsAlreadyNewHelpVar ARGS((tIdent name, tTree decls));
void DefineNewHelpFn ARGS((tIdent name));
static bool IsAlreadyNewHelpFn ARGS((tIdent name, tTree decls));
tTree MakeExtensionParams ARGS((tTree t));
tTree MakeSectionParams ARGS((tTree indexes));
static tTree MakeIncParameter ARGS((tTree inc));

tTree FirstArrayElement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 78 "CodeGeneral.puma"
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 83 "CodeGeneral.puma"
   return mINDEXED_VAR (t->INDEXED_VAR.IND_VAR, FirstArrayElement (t->INDEXED_VAR.IND_EXPS));

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 88 "CodeGeneral.puma"
   return mBTE_LIST (t->BTE_LIST.Elem->SLICE_EXP.START, FirstArrayElement (t->BTE_LIST.Next));

  }
# line 93 "CodeGeneral.puma"
   return mBTE_LIST (t->BTE_LIST.Elem, FirstArrayElement (t->BTE_LIST.Next));

  }
  if (t->Kind == kBTE_EMPTY) {
# line 98 "CodeGeneral.puma"
   return t;

  }
# line 103 "CodeGeneral.puma"
  {
# line 105 "CodeGeneral.puma"
   failure_protocol ("Dalib", "FirstArrayElement", t);
  }
   return NoTree;

}

tTree MakeRemoteParams
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 116 "CodeGeneral.puma"
 {
  tTree dsp;
  {
# line 118 "CodeGeneral.puma"

# line 120 "CodeGeneral.puma"
   dsp = mVAR_PARAM (MakeUsedVarA (TreeVarName (var->INDEXED_VAR.IND_VAR), "_DSP"));
  }
  {
   return mBTP_LIST (dsp, MakeRemoteParams (var->INDEXED_VAR.IND_EXPS));
  }
 }

  }
  if (var->Kind == kBTE_LIST) {
# line 125 "CodeGeneral.puma"
   return mBTP_LIST (ExpToVarParam (var->BTE_LIST.Elem), MakeRemoteParams (var->BTE_LIST.Next));

  }
  if (var->Kind == kBTE_EMPTY) {
# line 130 "CodeGeneral.puma"
   return mBTP_EMPTY ();

  }
 yyAbort ("MakeRemoteParams");
}

tTree MakeDistributeParams
# if defined __STDC__ | defined __cplusplus
(register tDefinitions ilist)
# else
(ilist)
 register tDefinitions ilist;
# endif
{
  if (ilist->Kind == kDIM_EMPTY) {
# line 143 "CodeGeneral.puma"
   return mBTP_EMPTY ();

  }
  if (ilist->Kind == kDIM_LIST) {
# line 148 "CodeGeneral.puma"
   return CombineBTP (MakeDistributeParams (ilist->DIM_LIST.Elem), MakeDistributeParams (ilist->DIM_LIST.Next));

  }
  if (ilist->Kind == kDistributedDimension) {
# line 154 "CodeGeneral.puma"
 {
  tTree len_array;
  tTree map_array;
  {
# line 156 "CodeGeneral.puma"
   if (! ((ilist->DistributedDimension.kind == kARBITRARY_DIM))) goto yyL3;
  {
# line 158 "CodeGeneral.puma"

# line 159 "CodeGeneral.puma"

# line 161 "CodeGeneral.puma"
 len_array = CopyTree (ilist->DistributedDimension.len);
     len_array = FirstArrayElement (MakeFullShape (len_array));
     
     map_array = CopyTree (ilist->DistributedDimension.map);
     map_array = FirstArrayElement (MakeFullShape (map_array));
   
  }
  }
  {
   return mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DistributedDimension.kind)), mBTP_LIST (ExpToVarParam (CopyTree (ilist->DistributedDimension.size)), mBTP_LIST (mVAR_PARAM (len_array), mBTP_LIST (mVAR_PARAM (map_array), NoTree))));
  }
 }
yyL3:;

# line 174 "CodeGeneral.puma"
 {
  tTree size_array;
  {
# line 176 "CodeGeneral.puma"
   if (! (((ilist->DistributedDimension.kind == kGEN_BLOCK_DIM) || (ilist->DistributedDimension.kind == kINDIRECT_DIM)))) goto yyL4;
  {
# line 181 "CodeGeneral.puma"

# line 183 "CodeGeneral.puma"
 size_array = CopyTree (ilist->DistributedDimension.size);
     size_array = FirstArrayElement (MakeFullShape (size_array));
   
  }
  }
  {
   return mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DistributedDimension.kind)), mBTP_LIST (mVAR_PARAM (size_array), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), NoTree))));
  }
 }
yyL4:;

# line 193 "CodeGeneral.puma"
  {
# line 195 "CodeGeneral.puma"
   if (! ((ilist->DistributedDimension.size == NoTree))) goto yyL5;
  }
   return mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DistributedDimension.kind)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), NoTree))));
yyL5:;

# line 203 "CodeGeneral.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DistributedDimension.kind)), mBTP_LIST (ExpToVarParam (CopyTree (ilist->DistributedDimension.size)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), NoTree))));

  }
  if (ilist->Kind == kSerialDimension) {
# line 211 "CodeGeneral.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (kSERIAL_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), NoTree))));

  }
# line 219 "CodeGeneral.puma"
  {
# line 221 "CodeGeneral.puma"
   failure_protocol (MODULE, "MakeDistributeParams", NoTree);
  }
   return NoTree;

}

tTree MakeTopologyParam
# if defined __STDC__ | defined __cplusplus
(register tDefinitions top_obj)
# else
(top_obj)
 register tDefinitions top_obj;
# endif
{
# line 236 "CodeGeneral.puma"
  {
# line 238 "CodeGeneral.puma"
   if (! ((top_obj == NoObject))) goto yyL1;
  }
   return ExpToVarParam (MakeConstant (kANY_TOPOLOGY));
yyL1:;

  if (top_obj->Kind == kTopologyObject) {
# line 243 "CodeGeneral.puma"
  {
# line 245 "CodeGeneral.puma"
   if (! ((top_obj->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  }
   return ExpToVarParam (MakeConstant (top_obj->TopologyObject.rank));
yyL2:;

# line 249 "CodeGeneral.puma"
   return mVAR_PARAM (MakeUsedVarA (top_obj->TopologyObject.Ident, "_TOPID"));

  }
# line 254 "CodeGeneral.puma"
  {
# line 256 "CodeGeneral.puma"
   failure_protocol (MODULE, "MakeTopologyParam", top_obj->Object.decl);
  }
   return NoTree;

}

tTree MakeTreeSizeParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
# line 268 "CodeGeneral.puma"
   return MakeTreeSizeParam (t->INDEXED_VAR.IND_VAR);

  }
  if (t->Kind == kUSED_VAR) {
# line 272 "CodeGeneral.puma"
   return ExpToVarParam (MakeConstant (TreeSize (t)));

  }
# line 276 "CodeGeneral.puma"
  {
# line 277 "CodeGeneral.puma"
   failure_protocol ("Dalib", "MakeTreeSizeParam", t);
  }
   return NoTree;

}

void DefineNewIntVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 289 "CodeGeneral.puma"
  {
# line 290 "CodeGeneral.puma"
   if (! ((IsAlreadyNewHelpVar (name, NewHelpVars)))) goto yyL1;
  }
   return;
yyL1:;

# line 293 "CodeGeneral.puma"
 {
  tTree var;
  {
# line 294 "CodeGeneral.puma"

# line 296 "CodeGeneral.puma"
 var = mVAR_DECL (name, 0, MakeIntegerType (default_int_size));
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
  
  }
   return;
 }

;
}

void DefineNewCommonVar
# if defined __STDC__ | defined __cplusplus
(register tIdent cname, register tIdent vname)
# else
(cname, vname)
 register tIdent cname;
 register tIdent vname;
# endif
{
# line 313 "CodeGeneral.puma"
  {
# line 315 "CodeGeneral.puma"
   if (! ((IsAlreadyNewHelpVar (vname, NewHelpVars)))) goto yyL1;
  }
   return;
yyL1:;

# line 318 "CodeGeneral.puma"
 {
  tTree var;
  tTree type;
  tTree common;
  {
# line 320 "CodeGeneral.puma"

# line 321 "CodeGeneral.puma"

# line 322 "CodeGeneral.puma"

# line 324 "CodeGeneral.puma"
 if (vname == MakeDalibId ("1"))
      type = MakeStringType (2);
     else if (vname == MakeDalibId ("0"))
      type = MakeIntegerType (default_addr_size);
     else
      type = MakeIntegerType (default_int_size);
    var = mVAR_DECL (vname, 0, type);
    common = mVAR_DECL (vname, 0, mDUMMY_TYPE ());
    common = mDECL_LIST (common, mDECL_EMPTY ());
    common = mCOMMON_DECL (cname, 0, common);
    NewHelpVars = mDECL_LIST (common, NewHelpVars);
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
  
  }
   return;
 }

;
}

void DefineNewAddrVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 341 "CodeGeneral.puma"
  {
# line 342 "CodeGeneral.puma"
   if (! ((IsAlreadyNewHelpVar (name, NewHelpVars)))) goto yyL1;
  }
   return;
yyL1:;

# line 345 "CodeGeneral.puma"
 {
  tTree var;
  {
# line 346 "CodeGeneral.puma"

# line 348 "CodeGeneral.puma"
 var = mVAR_DECL (name, 0, MakeIntegerType (default_addr_size));
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
  
  }
   return;
 }

;
}

static bool IsAlreadyNewHelpVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree decls)
# else
(name, decls)
 register tIdent name;
 register tTree decls;
# endif
{
  if (decls->Kind == kDECL_LIST) {
  if (decls->DECL_LIST.Elem->Kind == kVAR_DECL) {
# line 355 "CodeGeneral.puma"
  {
# line 356 "CodeGeneral.puma"
   if (! ((name == decls->DECL_LIST.Elem->VAR_DECL.Ident))) goto yyL1;
  }
   return true;
yyL1:;

  }
# line 359 "CodeGeneral.puma"
  {
# line 360 "CodeGeneral.puma"
   if (! ((IsAlreadyNewHelpVar (name, decls->DECL_LIST.Next)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

void DefineNewHelpFn
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 371 "CodeGeneral.puma"
  {
# line 372 "CodeGeneral.puma"
   if (! ((IsAlreadyNewHelpFn (name, NewHelpVars)))) goto yyL1;
  }
   return;
yyL1:;

# line 375 "CodeGeneral.puma"
 {
  tTree type;
  tTree var;
  {
# line 377 "CodeGeneral.puma"

# line 378 "CodeGeneral.puma"

# line 380 "CodeGeneral.puma"
 if (name == MakeDalibId("PRESENT"))
        type = MakeLogicalType (default_int_size);
     else if (name == MakeDalibId("ALLOCATED"))
        type = MakeLogicalType (default_int_size);
     else if (name == MakeDalibId("is_local"))
        type = MakeLogicalType (default_int_size);
     else if (name == MakeDalibId("is_in_procs"))
        type = MakeLogicalType (default_int_size);
      else
       type = MakeIntegerType (default_int_size);

    var = mVAR_DECL (name, 0, type);
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
    var = mEXTERNAL_DECL (name, 0);
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
  
  }
   return;
 }

;
}

static bool IsAlreadyNewHelpFn
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree decls)
# else
(name, decls)
 register tIdent name;
 register tTree decls;
# endif
{
  if (decls->Kind == kDECL_LIST) {
  if (decls->DECL_LIST.Elem->Kind == kVAR_DECL) {
# line 400 "CodeGeneral.puma"
  {
# line 401 "CodeGeneral.puma"
   if (! ((name == decls->DECL_LIST.Elem->VAR_DECL.Ident))) goto yyL1;
  }
   return true;
yyL1:;

  }
# line 404 "CodeGeneral.puma"
  {
# line 405 "CodeGeneral.puma"
   if (! ((IsAlreadyNewHelpFn (name, decls->DECL_LIST.Next)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

tTree MakeExtensionParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_EMPTY) {
# line 416 "CodeGeneral.puma"
   return mBTP_EMPTY ();

  }
  if (t->Kind == kSHAPE_EMPTY) {
# line 420 "CodeGeneral.puma"
   return mBTP_EMPTY ();

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 424 "CodeGeneral.puma"
   return mBTP_LIST (ExpToVarParam (CopyTree (t->BTE_LIST.Elem->SLICE_EXP.START)), mBTP_LIST (ExpToVarParam (CopyTree (t->BTE_LIST.Elem->SLICE_EXP.STOP)), MakeExtensionParams (t->BTE_LIST.Next)));

  }
  }
  if (t->Kind == kSHAPE_LIST) {
  if (t->SHAPE_LIST.Elem->Kind == kEXPLICIT_SHAPE) {
# line 430 "CodeGeneral.puma"
   return mBTP_LIST (ExpToVarParam (CopyTree (t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.LOWER)), mBTP_LIST (ExpToVarParam (CopyTree (t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.UPPER)), MakeExtensionParams (t->SHAPE_LIST.Next)));

  }
  if (t->SHAPE_LIST.Elem->Kind == kDEFERRED_SHAPE) {
# line 436 "CodeGeneral.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), MakeExtensionParams (t->SHAPE_LIST.Next)));

  }
  if (t->SHAPE_LIST.Elem->Kind == kASSUMED_SHAPE) {
# line 442 "CodeGeneral.puma"
   return mBTP_LIST (ExpToVarParam (MakeConstant (1)), mBTP_LIST (ExpToVarParam (CopyTree (t->SHAPE_LIST.Elem->ASSUMED_SHAPE.LOWER)), MakeExtensionParams (t->SHAPE_LIST.Next)));

  }
  }
# line 448 "CodeGeneral.puma"
  {
# line 449 "CodeGeneral.puma"
   failure_protocol (MODULE, "MakeExtensionParams", t);
  }
   return NoTree;

}

tTree MakeSectionParams
# if defined __STDC__ | defined __cplusplus
(register tTree indexes)
# else
(indexes)
 register tTree indexes;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 464 "CodeGeneral.puma"
 {
  tTree params;
  {
# line 466 "CodeGeneral.puma"

# line 468 "CodeGeneral.puma"
   params = MakeSectionParams (indexes->BTE_LIST.Next);
# line 469 "CodeGeneral.puma"
   params = mBTP_LIST (MakeIncParameter (indexes->BTE_LIST.Elem->SLICE_EXP.INC), params);
# line 470 "CodeGeneral.puma"
   params = mBTP_LIST (ExpToVarParam (CopyTree (indexes->BTE_LIST.Elem->SLICE_EXP.STOP)), params);
# line 471 "CodeGeneral.puma"
   params = mBTP_LIST (ExpToVarParam (CopyTree (indexes->BTE_LIST.Elem->SLICE_EXP.START)), params);
# line 472 "CodeGeneral.puma"
   params = mBTP_LIST (ExpToVarParam (MakeConstant (1)), params);
  }
  {
   return params;
  }
 }

  }
# line 477 "CodeGeneral.puma"
 {
  tTree params;
  tTree zero;
  {
# line 479 "CodeGeneral.puma"

# line 480 "CodeGeneral.puma"

# line 482 "CodeGeneral.puma"
   zero = ExpToVarParam (MakeConstant (0));
# line 484 "CodeGeneral.puma"
   params = MakeSectionParams (indexes->BTE_LIST.Next);
# line 485 "CodeGeneral.puma"
   params = mBTP_LIST (zero, params);
# line 486 "CodeGeneral.puma"
   params = mBTP_LIST (zero, params);
# line 487 "CodeGeneral.puma"
   params = mBTP_LIST (ExpToVarParam (CopyTree (indexes->BTE_LIST.Elem)), params);
# line 488 "CodeGeneral.puma"
   params = mBTP_LIST (zero, params);
  }
  {
   return params;
  }
 }

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 493 "CodeGeneral.puma"
   return mBTP_EMPTY ();

  }
 yyAbort ("MakeSectionParams");
}

static tTree MakeIncParameter
# if defined __STDC__ | defined __cplusplus
(register tTree inc)
# else
(inc)
 register tTree inc;
# endif
{
# line 499 "CodeGeneral.puma"
  {
# line 500 "CodeGeneral.puma"
   if (! ((inc == NoTree))) goto yyL1;
  }
   return ExpToVarParam (MakeConstant (1));
yyL1:;

  if (inc->Kind == kDUMMY_EXP) {
# line 504 "CodeGeneral.puma"
   return ExpToVarParam (MakeConstant (1));

  }
# line 508 "CodeGeneral.puma"
   return ExpToVarParam (CopyTree (inc));

}

void BeginCodeGeneral ()
{
}

void CloseCodeGeneral ()
{
}
