# include "CodeDescriptors.h"
# include "yyCodeDescriptors.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 33 "CodeDescriptors.puma"


# define  MODULE      "CodeDescriptors"

# include <stdio.h>

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Types.h"       /* ArrayFormals */
# include "TreeOps.h"     /* TreeVarName */
# include "Rank.h"
# include "Transform.h"   /* ExpToVarParam */
# include "Dalib.h"       /* MakeDalibId, MakeUsedVarA */
# include "Expressions.h" /* MakeConstant */
# include "Shapes.h"      /* MakeFullShape */
# include "CodeGeneral.h"



static void yyExit () { Exit (1); }

void (* CodeDescriptors_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeDescriptors, routine %s failed\n", yyFunction);
 CodeDescriptors_Exit ();
}

tTree DalibArrayOverlapUpdate ARGS((tTree var, tTree size));
static tTree OverlapSizeParams ARGS((tTree size));
static tTree DalibSectionCreate ARGS((int section_id, tTree var));
tTree DalibSectionDescriptor ARGS((int section_id));
static tTree DalibSectionFree ARGS((int section_id));
void DalibSectionTranslation ARGS((int nr, tTree var, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static tTree DalibLocalCreate ARGS((int local_id, int pack, tTree var));
static tTree DalibLocalDescriptor ARGS((int local_id));
static tTree DalibLocalFree ARGS((int local_id));
void DalibLocalTranslation ARGS((int nr, int pack, tTree var, tTree * yyP6, tTree * yyP5, tTree * yyP4));
tTree DalibPid ARGS(());
tTree DalibFindOwner ARGS((tTree topology, tTree specs));
static tTree FindOwnerParams ARGS((tTree specs));
tTree DalibDimBroadcast ARGS((tTree var, tTree on_top, tTree on_val));
tTree DalibNodeGet ARGS((tTree var));
tTree DalibBroadcast ARGS((tTree var, tTree from));
tTree DalibLocExchange ARGS((tTree var));

tTree DalibArrayOverlapUpdate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree size)
# else
(var, size)
 register tTree var;
 register tTree size;
# endif
{
  if (size->Kind == kBTE_EMPTY) {
# line 66 "CodeDescriptors.puma"
   return NoTree;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 73 "CodeDescriptors.puma"
 {
  tTree param;
  tTree paramlist;
  tTree call;
  int sec_id;
  {
# line 75 "CodeDescriptors.puma"

# line 76 "CodeDescriptors.puma"

# line 77 "CodeDescriptors.puma"

# line 78 "CodeDescriptors.puma"

# line 80 "CodeDescriptors.puma"
   sec_id = 1;
# line 82 "CodeDescriptors.puma"
   paramlist = OverlapSizeParams (size);
# line 84 "CodeDescriptors.puma"
   param = DalibSectionDescriptor (sec_id);
# line 85 "CodeDescriptors.puma"
   paramlist = mBTP_LIST (param, paramlist);
# line 87 "CodeDescriptors.puma"
   call = mPROC_OBJ (MakeDalibId ("overlap_update"));
# line 88 "CodeDescriptors.puma"
   call = mACF_BASIC (mCALL_STMT (call, paramlist));
  }
  {
   return mACF_LIST (DalibSectionCreate (sec_id, var), mACF_LIST (call, mACF_LIST (DalibSectionFree (sec_id), NoTree)));
  }
 }

  }
# line 95 "CodeDescriptors.puma"
  {
# line 96 "CodeDescriptors.puma"
   failure_protocol (MODULE, "DalibArrayOverlapUpdate", var);
  }
   return NoTree;

}

static tTree OverlapSizeParams
# if defined __STDC__ | defined __cplusplus
(register tTree size)
# else
(size)
 register tTree size;
# endif
{
  if (size->Kind == kBTE_EMPTY) {
# line 102 "CodeDescriptors.puma"
   return mBTP_EMPTY ();

  }
  if (size->Kind == kBTE_LIST) {
# line 106 "CodeDescriptors.puma"
   return ConcatParams (OverlapSizeParams (size->BTE_LIST.Elem), OverlapSizeParams (size->BTE_LIST.Next));

  }
  if (size->Kind == kSLICE_EXP) {
# line 111 "CodeDescriptors.puma"
   return mBTP_LIST (ExpToVarParam (size->SLICE_EXP.START), mBTP_LIST (ExpToVarParam (size->SLICE_EXP.STOP), NoTree));

  }
# line 116 "CodeDescriptors.puma"
  {
# line 117 "CodeDescriptors.puma"
   failure_protocol (MODULE, "OverlapSizeParams", size);
  }
   return NoTree;

}

static tTree DalibSectionCreate
# if defined __STDC__ | defined __cplusplus
(register int section_id, register tTree var)
# else
(section_id, var)
 register int section_id;
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 141 "CodeDescriptors.puma"
 {
  tTree param;
  tTree params;
  tTree call;
  {
# line 143 "CodeDescriptors.puma"

# line 144 "CodeDescriptors.puma"

# line 145 "CodeDescriptors.puma"

# line 147 "CodeDescriptors.puma"
   params = MakeSectionParams (var->INDEXED_VAR.IND_EXPS);
# line 148 "CodeDescriptors.puma"
   param = mVAR_PARAM (MakeUsedVarA (TreeVarName (var->INDEXED_VAR.IND_VAR), "_DSP"));
# line 149 "CodeDescriptors.puma"
   params = mBTP_LIST (param, params);
# line 150 "CodeDescriptors.puma"
   param = DalibSectionDescriptor (section_id);
# line 151 "CodeDescriptors.puma"
   params = mBTP_LIST (param, params);
# line 152 "CodeDescriptors.puma"
   call = mPROC_OBJ (MakeDalibId ("section_create"));
# line 153 "CodeDescriptors.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

  }
# line 158 "CodeDescriptors.puma"
  {
# line 159 "CodeDescriptors.puma"
   failure_protocol (MODULE, "DalibSectionCreate", var);
  }
   return NoTree;

}

tTree DalibSectionDescriptor
# if defined __STDC__ | defined __cplusplus
(register int section_id)
# else
(section_id)
 register int section_id;
# endif
{
# line 171 "CodeDescriptors.puma"
 {
  tTree var;
  {
# line 172 "CodeDescriptors.puma"

# line 174 "CodeDescriptors.puma"
   var = MakeUsedVarAn (MakeIdent ("ISEC", 4), "_DSP", section_id);
# line 175 "CodeDescriptors.puma"
   DefineNewAddrVar (TreeVarName (var));
  }
  {
   return mVAR_PARAM (var);
  }
 }

}

static tTree DalibSectionFree
# if defined __STDC__ | defined __cplusplus
(register int section_id)
# else
(section_id)
 register int section_id;
# endif
{
# line 187 "CodeDescriptors.puma"
 {
  tTree param;
  tTree params;
  tTree call;
  {
# line 189 "CodeDescriptors.puma"

# line 190 "CodeDescriptors.puma"

# line 191 "CodeDescriptors.puma"

# line 193 "CodeDescriptors.puma"
   params = mBTP_EMPTY ();
# line 194 "CodeDescriptors.puma"
   param = DalibSectionDescriptor (section_id);
# line 195 "CodeDescriptors.puma"
   params = mBTP_LIST (param, params);
# line 196 "CodeDescriptors.puma"
   call = mPROC_OBJ (MakeDalibId ("section_free"));
# line 197 "CodeDescriptors.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

}

void DalibSectionTranslation
# if defined __STDC__ | defined __cplusplus
(register int nr, register tTree var, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(nr, var, yyP3, yyP2, yyP1)
 register int nr;
 register tTree var;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 211 "CodeDescriptors.puma"
 {
  tTree param;
  {
# line 213 "CodeDescriptors.puma"

# line 214 "CodeDescriptors.puma"
   param = mVAR_PARAM (MakeUsedVarA (TreeVarName (var->USED_VAR.VARNAME), "_DSP"));
  }
   * yyP3 = NoTree;
   * yyP2 = param;
   * yyP1 = NoTree;
   return;
 }

  }
  if (var->Kind == kINDEXED_VAR) {
# line 217 "CodeDescriptors.puma"
 {
  tTree param;
  {
# line 219 "CodeDescriptors.puma"
   if (! ((IsWholeVar (var)))) goto yyL2;
  {
# line 221 "CodeDescriptors.puma"

# line 222 "CodeDescriptors.puma"
   param = mVAR_PARAM (MakeUsedVarA (TreeVarName (var->INDEXED_VAR.IND_VAR), "_DSP"));
  }
  }
   * yyP3 = NoTree;
   * yyP2 = param;
   * yyP1 = NoTree;
   return;
 }
yyL2:;

# line 225 "CodeDescriptors.puma"
   * yyP3 = DalibSectionCreate (nr, var);
   * yyP2 = DalibSectionDescriptor (nr);
   * yyP1 = DalibSectionFree (nr);
   return;

  }
# line 232 "CodeDescriptors.puma"
  {
# line 234 "CodeDescriptors.puma"
   error_protocol ("cannot create a descriptor here");
# line 235 "CodeDescriptors.puma"
   tree_protocol ("this is the illegal variable : ", var);
  }
   * yyP3 = NoTree;
   * yyP2 = DalibSectionDescriptor (nr);
   * yyP1 = NoTree;
   return;

;
}

static tTree DalibLocalCreate
# if defined __STDC__ | defined __cplusplus
(register int local_id, register int pack, register tTree var)
# else
(local_id, pack, var)
 register int local_id;
 register int pack;
 register tTree var;
# endif
{
# line 259 "CodeDescriptors.puma"
 {
  tTree param;
  tTree params;
  tTree call;
  {
# line 261 "CodeDescriptors.puma"

# line 262 "CodeDescriptors.puma"

# line 263 "CodeDescriptors.puma"

# line 265 "CodeDescriptors.puma"
   param = ExpToVarParam (MakeConstant (pack));
# line 266 "CodeDescriptors.puma"
   params = mBTP_LIST (param, mBTP_EMPTY ());
# line 267 "CodeDescriptors.puma"
   param = CopyTree (var);
# line 268 "CodeDescriptors.puma"
   params = mBTP_LIST (param, params);
# line 269 "CodeDescriptors.puma"
   param = DalibLocalDescriptor (local_id);
# line 270 "CodeDescriptors.puma"
   params = mBTP_LIST (param, params);
# line 271 "CodeDescriptors.puma"
   call = mPROC_OBJ (MakeDalibId ("local_create"));
# line 272 "CodeDescriptors.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

}

static tTree DalibLocalDescriptor
# if defined __STDC__ | defined __cplusplus
(register int local_id)
# else
(local_id)
 register int local_id;
# endif
{
# line 291 "CodeDescriptors.puma"
 {
  tTree var;
  {
# line 292 "CodeDescriptors.puma"

# line 294 "CodeDescriptors.puma"
   var = MakeUsedVarAn (MakeIdent ("ILOC", 4), "_DSP", local_id);
# line 295 "CodeDescriptors.puma"
   DefineNewAddrVar (TreeVarName (var));
  }
  {
   return mVAR_PARAM (var);
  }
 }

}

static tTree DalibLocalFree
# if defined __STDC__ | defined __cplusplus
(register int local_id)
# else
(local_id)
 register int local_id;
# endif
{
# line 307 "CodeDescriptors.puma"
 {
  tTree param;
  tTree params;
  tTree call;
  {
# line 309 "CodeDescriptors.puma"

# line 310 "CodeDescriptors.puma"

# line 311 "CodeDescriptors.puma"

# line 313 "CodeDescriptors.puma"
   params = mBTP_EMPTY ();
# line 314 "CodeDescriptors.puma"
   param = DalibLocalDescriptor (local_id);
# line 315 "CodeDescriptors.puma"
   params = mBTP_LIST (param, params);
# line 316 "CodeDescriptors.puma"
   call = mPROC_OBJ (MakeDalibId ("local_free"));
# line 317 "CodeDescriptors.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

}

void DalibLocalTranslation
# if defined __STDC__ | defined __cplusplus
(register int nr, register int pack, register tTree var, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(nr, pack, var, yyP6, yyP5, yyP4)
 register int nr;
 register int pack;
 register tTree var;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
# line 332 "CodeDescriptors.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 334 "CodeDescriptors.puma"
   DalibSectionTranslation (nr, var, & yyV1, & yyV2, & yyV3);
# line 336 "CodeDescriptors.puma"
   yyV1 = CombineACF (yyV1, DalibLocalCreate (nr, pack, yyV2));
# line 338 "CodeDescriptors.puma"
   yyV3 = CombineACF (DalibLocalFree (nr), yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = DalibLocalDescriptor (nr);
   * yyP4 = yyV3;
   return;
 }

;
}

tTree DalibPid
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 351 "CodeDescriptors.puma"
 {
  tTree call;
  {
# line 352 "CodeDescriptors.puma"

# line 354 "CodeDescriptors.puma"
 call = mPROC_OBJ (MakeDalibId ("pid"));
     DefineNewHelpFn (MakeDalibId ("pid"));
     call = mFUNC_CALL_EXP (call, mBTP_EMPTY());
   
  }
  {
   return call;
  }
 }

}

tTree DalibFindOwner
# if defined __STDC__ | defined __cplusplus
(register tTree topology, register tTree specs)
# else
(topology, specs)
 register tTree topology;
 register tTree specs;
# endif
{
  if (topology->Kind == kON_VAR) {
  if (Definitions_IsType (topology->ON_VAR.arrayid, kObject)) {
# line 373 "CodeDescriptors.puma"
 {
  int nr;
  tTree params;
  tTree stmt;
  {
# line 377 "CodeDescriptors.puma"

# line 378 "CodeDescriptors.puma"

# line 379 "CodeDescriptors.puma"

# line 381 "CodeDescriptors.puma"
 params = FindOwnerParams (specs);
     nr     = TreeListLength (params) / 2;

     params = mBTP_LIST (ExpToVarParam (MakeConstant (nr)), params);
     params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (topology->ON_VAR.arrayid->Object.Ident, "_DSP")), params);

     stmt = mPROC_OBJ (MakeDalibId ("find_owner"));
     stmt = mACF_BASIC (mCALL_STMT (stmt, params));

   
  }
  {
   return stmt;
  }
 }

  }
  }
 yyAbort ("DalibFindOwner");
}

static tTree FindOwnerParams
# if defined __STDC__ | defined __cplusplus
(register tTree specs)
# else
(specs)
 register tTree specs;
# endif
{
  if (specs->Kind == kON_LIST) {
# line 397 "CodeDescriptors.puma"
 {
  tTree new_params;
  {
# line 399 "CodeDescriptors.puma"

# line 401 "CodeDescriptors.puma"
 new_params = FindOwnerParams (specs->ON_LIST.Next);
    new_params = mBTP_LIST (ExpToVarParam (specs->ON_LIST.Elem->ON_SPEC.ON_VAL), new_params);
    new_params = mBTP_LIST (ExpToVarParam (MakeConstant (specs->ON_LIST.Elem->ON_SPEC.array_dim)),
                            new_params);
  
  }
  {
   return new_params;
  }
 }

  }
  if (specs->Kind == kON_EMPTY) {
# line 410 "CodeDescriptors.puma"
   return mBTP_EMPTY ();

  }
 yyAbort ("FindOwnerParams");
}

tTree DalibDimBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree on_top, register tTree on_val)
# else
(var, on_top, on_val)
 register tTree var;
 register tTree on_top;
 register tTree on_val;
# endif
{
  if (on_top->Kind == kON_VAR) {
  if (Definitions_IsType (on_top->ON_VAR.tempid, kObject)) {
  if (on_val->Kind == kON_SPEC) {
# line 425 "CodeDescriptors.puma"
 {
  tTree stmt;
  tTree paramlist;
  tTree param;
  {
# line 428 "CodeDescriptors.puma"

# line 429 "CodeDescriptors.puma"

# line 430 "CodeDescriptors.puma"

# line 432 "CodeDescriptors.puma"
 paramlist = mBTP_EMPTY();

     param     = ExpToVarParam (MakeSizeExp (MakeFullShape (var)));
     paramlist = mBTP_LIST (param, paramlist);

     param     = mVAR_PARAM (var);
     paramlist = mBTP_LIST (param, paramlist);

     param     = ExpToVarParam (on_val->ON_SPEC.ON_VAL);
     paramlist = mBTP_LIST (param, paramlist);

     param     = ExpToVarParam (MakeConstant (on_val->ON_SPEC.temp_dim));
     paramlist = mBTP_LIST (param, paramlist);

     param = mVAR_PARAM (MakeUsedVarA (on_top->ON_VAR.tempid->Object.Ident, "_DSP"));
     paramlist = mBTP_LIST (param, paramlist);

     stmt = mPROC_OBJ (MakeDalibId ("array_broadcast"));
     stmt = mACF_BASIC (mCALL_STMT (stmt, paramlist));

   
  }
  {
   return stmt;
  }
 }

  }
  }
  }
# line 456 "CodeDescriptors.puma"
  {
# line 457 "CodeDescriptors.puma"
   failure2_protocol (MODULE, "DalibDimBroadcast", on_top, on_val);
  }
   return NoTree;

}

tTree DalibNodeGet
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 471 "CodeDescriptors.puma"
 {
  tTree stmt;
  tTree param;
  tTree paramlist;
  {
# line 473 "CodeDescriptors.puma"

# line 474 "CodeDescriptors.puma"

# line 475 "CodeDescriptors.puma"

# line 477 "CodeDescriptors.puma"
 paramlist = mBTP_EMPTY();

     param     = ExpToVarParam (MakeSizeExp (var));
     paramlist = mBTP_LIST (param, paramlist);

     param     = mVAR_PARAM (var);
     paramlist = mBTP_LIST (param, paramlist);

     stmt = mPROC_OBJ (MakeDalibId ("node_get"));
     stmt = mACF_BASIC (mCALL_STMT (stmt, paramlist));

   
  }
  {
   return stmt;
  }
 }

}

tTree DalibBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree from)
# else
(var, from)
 register tTree var;
 register tTree from;
# endif
{
# line 502 "CodeDescriptors.puma"
 {
  tTree stmt;
  tTree param;
  tTree paramlist;
  {
# line 504 "CodeDescriptors.puma"

# line 505 "CodeDescriptors.puma"

# line 506 "CodeDescriptors.puma"

# line 508 "CodeDescriptors.puma"
 paramlist = mBTP_EMPTY();

     param     = ExpToVarParam (from);
     paramlist = mBTP_LIST (param, paramlist);

     param     = ExpToVarParam (MakeSizeExp (MakeFullShape (var)));
     paramlist = mBTP_LIST (param, paramlist);

     if (TreeRank (var) >= 1)
        param  = mVAR_PARAM (FirstArrayElement (MakeFullShape (var)));
      else
        param  = mVAR_PARAM (var);
     paramlist = mBTP_LIST (param, paramlist);

     

     if (IsStringType (TreeType(var)))
       stmt = mPROC_OBJ (MakeDalibId ("string_broadcast"));
      else
       stmt = mPROC_OBJ (MakeDalibId ("broadcast"));

     stmt = mACF_BASIC (mCALL_STMT (stmt, paramlist));

   
  }
  {
   return stmt;
  }
 }

}

tTree DalibLocExchange
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 545 "CodeDescriptors.puma"
 {
  tTree stmt;
  tTree param;
  tTree paramlist;
  {
# line 547 "CodeDescriptors.puma"

# line 548 "CodeDescriptors.puma"

# line 549 "CodeDescriptors.puma"

# line 551 "CodeDescriptors.puma"
 paramlist = mBTP_EMPTY();

     param     = ExpToVarParam (MakeSizeExp (MakeFullShape (var)));
     paramlist = mBTP_LIST (param, paramlist);

     param     = mVAR_PARAM (var);
     paramlist = mBTP_LIST (param, paramlist);

     stmt = mPROC_OBJ (MakeDalibId ("loc_exchange"));
     stmt = mACF_BASIC (mCALL_STMT (stmt, paramlist));

   
  }
  {
   return stmt;
  }
 }

}

void BeginCodeDescriptors ()
{
}

void CloseCodeDescriptors ()
{
}
