# include "CodeCalling.h"
# include "yyCodeCalling.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 26 "CodeCalling.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "Types.h"

# include "protocol.h"

# include "Objects.h"
# include "Intrinsics.h"
# include "Rank.h"

# include "Expressions.h"         /* MakeConstant            */
# include "Transform.h"           /* CombineACF, CombineBTP  */
# include "Traverse.h"
# include "Dalib.h"               /* FirstArrayElement       */
# include "Nesting.h"             /* GetCurrentModel         */
# include "CodeDescriptors.h"
# include "CodeGeneral.h"         /* DUMMY_SUFFIX            */

# define MODULE "CodeCalling"

static int section_counter;



static void yyExit () { Exit (1); }

void (* CodeCalling_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeCalling, routine %s failed\n", yyFunction);
 CodeCalling_Exit ();
}

tTree CodeCalling ARGS((tTree t));
static void CodeCallStmt ARGS((tTree call, tTree * yyP2, tTree * yyP1));
static tTree DoubleArguments ARGS((tTree arguments));
static tTree MakeDataParams ARGS((tTree arguments));
static void SetDataParamAttributes ARGS((tTree t));
static tTree MakeHandleParams ARGS((tTree arguments));
static void SetHandleParamAttributes ARGS((tTree t));
static void TranslateArguments ARGS((tTree arguments, tTree * yyP4, tTree * yyP3));
static void TranslateArg ARGS((tTree arg, tTree * yyP7, tTree * yyP6, tTree * yyP5));
static void MakeDescriptorParameter ARGS((tTree param, tTree * yyP10, tTree * yyP9, tTree * yyP8));
void UpdateLocalCalls ARGS((tTree t));
static void UpdateCalling ARGS((tTree t));
static tTree TranslateActualParams ARGS((tTree call, tTree params));
static tTree FirstLocalDataElement ARGS((tTree t));
static tTree LocalIndex ARGS((tTree v, pvar vard, int dim));
static void TranslateHPFSend ARGS((tTree call));
static void TranslateHPFSendInit ARGS((tTree call));
static void TranslateHPFRecv ARGS((tTree call));
static void TranslateHPFRecvInit ARGS((tTree call));

tTree CodeCalling
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 61 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 63 "CodeCalling.puma"
   UpdateLocalCalls (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
# line 65 "CodeCalling.puma"
   CodeCallStmt (t->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
# line 67 "CodeCalling.puma"
 t->Kind = kACF_BASIC; 
  }
  {
   return CombineACF (yyV1, CombineACF (t, yyV2));
  }
 }

  }
  }
# line 72 "CodeCalling.puma"
  {
# line 73 "CodeCalling.puma"
   failure_protocol (MODULE, "CodeCalling", t);
  }
   return NoTree;

}

static void CodeCallStmt
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree * yyP2, register tTree * yyP1)
# else
(call, yyP2, yyP1)
 register tTree call;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (call->Kind == kCALL_STMT) {
# line 85 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 87 "CodeCalling.puma"
   if (! ((IsIntrCall (call)))) goto yyL1;
  {
# line 88 "CodeCalling.puma"
   if (! ((IntrFuncDalib (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident)))) goto yyL1;
  {
# line 90 "CodeCalling.puma"
 call->CALL_STMT.CALL_PARAMS = DoubleArguments (call->CALL_STMT.CALL_PARAMS); 
# line 92 "CodeCalling.puma"
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

# line 95 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 99 "CodeCalling.puma"
   if (! ((IsIntrCall (call)))) goto yyL2;
  {
# line 100 "CodeCalling.puma"
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_SEND")))) goto yyL2;
  {
# line 102 "CodeCalling.puma"
   TranslateHPFSend (call);
# line 103 "CodeCalling.puma"
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL2:;

# line 106 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 110 "CodeCalling.puma"
   if (! ((IsIntrCall (call)))) goto yyL3;
  {
# line 111 "CodeCalling.puma"
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_SEND_INIT")))) goto yyL3;
  {
# line 113 "CodeCalling.puma"
   TranslateHPFSendInit (call);
# line 114 "CodeCalling.puma"
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

# line 117 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 121 "CodeCalling.puma"
   if (! ((IsIntrCall (call)))) goto yyL4;
  {
# line 122 "CodeCalling.puma"
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_RECV")))) goto yyL4;
  {
# line 124 "CodeCalling.puma"
   TranslateHPFRecv (call);
# line 125 "CodeCalling.puma"
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL4:;

# line 128 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 132 "CodeCalling.puma"
   if (! ((IsIntrCall (call)))) goto yyL5;
  {
# line 133 "CodeCalling.puma"
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_RECV_INIT")))) goto yyL5;
  {
# line 135 "CodeCalling.puma"
   TranslateHPFRecvInit (call);
# line 136 "CodeCalling.puma"
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL5:;

# line 139 "CodeCalling.puma"
  {
# line 143 "CodeCalling.puma"
   if (! ((IsIntrCall (call)))) goto yyL6;
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
yyL6:;

# line 146 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 150 "CodeCalling.puma"
 if (!IsF77Call (call))

       call->CALL_STMT.CALL_PARAMS = DoubleArguments (call->CALL_STMT.CALL_PARAMS);
   
# line 155 "CodeCalling.puma"
   stmt_protocol ("translate arguments of call");
# line 156 "CodeCalling.puma"
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
# line 157 "CodeCalling.puma"
   stmt_protocol ("arguments are translated");
# line 159 "CodeCalling.puma"
 if ( (IsLocalCall (call)) && (GetCurrentModel() == HPF_GLOBAL) )

       { tTree stmt;

         stmt = mPROC_OBJ (MakeDalibId ("push_local_context"));
         stmt = mCALL_STMT (stmt, mBTP_EMPTY ());
         stmt = mACF_BASIC (stmt);

         yyV1 = CombineACF (yyV1, stmt);

         stmt = mPROC_OBJ (MakeDalibId ("pop_local_context"));
         stmt = mCALL_STMT (stmt, mBTP_EMPTY ());
         stmt = mACF_BASIC (stmt);

         yyV2 = CombineACF (yyV2, stmt);
       }
   
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
# line 178 "CodeCalling.puma"
  {
# line 180 "CodeCalling.puma"
   failure_protocol (MODULE, "CodeCallStmt", call);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static tTree DoubleArguments
# if defined __STDC__ | defined __cplusplus
(register tTree arguments)
# else
(arguments)
 register tTree arguments;
# endif
{
# line 195 "CodeCalling.puma"
   return CombineBTP (MakeDataParams (arguments), MakeHandleParams (arguments));

}

static tTree MakeDataParams
# if defined __STDC__ | defined __cplusplus
(register tTree arguments)
# else
(arguments)
 register tTree arguments;
# endif
{
  if (arguments->Kind == kBTP_EMPTY) {
# line 211 "CodeCalling.puma"
   return arguments;

  }
  if (arguments->Kind == kBTP_LIST) {
# line 216 "CodeCalling.puma"
   return mBTP_LIST (MakeDataParams (arguments->BTP_LIST.Elem), MakeDataParams (arguments->BTP_LIST.Next));

  }
  if (arguments->Kind == kVAR_PARAM) {
# line 221 "CodeCalling.puma"
 {
  tTree t;
  {
# line 223 "CodeCalling.puma"

# line 225 "CodeCalling.puma"
 t = mVAR_PARAM (arguments->VAR_PARAM.V);
      SetDataParamAttributes (t);
    
  }
  {
   return t;
  }
 }

  }
# line 232 "CodeCalling.puma"
   return arguments;

}

static void SetDataParamAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 239 "CodeCalling.puma"
  {
# line 241 "CodeCalling.puma"
 t->VAR_PARAM.pass_by = kDATA_PASS_BY; 
  }
   return;

  }
  if (t->Kind == kNO_PARAM) {
# line 244 "CodeCalling.puma"
   return;

  }
# line 247 "CodeCalling.puma"
  {
# line 248 "CodeCalling.puma"
   failure_protocol (MODULE, "SetDataParamAttributes", t);
  }
   return;

;
}

static tTree MakeHandleParams
# if defined __STDC__ | defined __cplusplus
(register tTree arguments)
# else
(arguments)
 register tTree arguments;
# endif
{
  if (arguments->Kind == kBTP_EMPTY) {
# line 262 "CodeCalling.puma"
   return arguments;

  }
  if (arguments->Kind == kBTP_LIST) {
# line 267 "CodeCalling.puma"
  {
# line 269 "CodeCalling.puma"
 arguments->BTP_LIST.Elem = MakeHandleParams (arguments->BTP_LIST.Elem);
      arguments->BTP_LIST.Next = MakeHandleParams (arguments->BTP_LIST.Next);
    
  }
   return arguments;

  }
  if (arguments->Kind == kVAR_PARAM) {
# line 276 "CodeCalling.puma"
  {
# line 278 "CodeCalling.puma"
   SetHandleParamAttributes (arguments);
  }
   return arguments;

  }
# line 283 "CodeCalling.puma"
   return mNO_PARAM (kDUMMY_TYPE);

}

static void SetHandleParamAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 290 "CodeCalling.puma"
  {
# line 292 "CodeCalling.puma"
 t->VAR_PARAM.pass_by = kHPF_HANDLE_PASS_BY; 
  }
   return;

  }
;
}

static void TranslateArguments
# if defined __STDC__ | defined __cplusplus
(register tTree arguments, register tTree * yyP4, register tTree * yyP3)
# else
(arguments, yyP4, yyP3)
 register tTree arguments;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (arguments->Kind == kBTP_EMPTY) {
# line 313 "CodeCalling.puma"
  {
# line 315 "CodeCalling.puma"
 section_counter = 1; 
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }
  if (arguments->Kind == kBTP_LIST) {
# line 318 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 321 "CodeCalling.puma"
   TranslateArguments (arguments->BTP_LIST.Next, & yyV1, & yyV2);
# line 322 "CodeCalling.puma"
   TranslateArg (arguments->BTP_LIST.Elem, & yyV3, & yyV4, & yyV5);
# line 324 "CodeCalling.puma"
 arguments->BTP_LIST.Elem = yyV3; 
  }
   * yyP4 = CombineACF (yyV4, yyV1);
   * yyP3 = CombineACF (yyV2, yyV5);
   return;
 }

  }
# line 327 "CodeCalling.puma"
  {
# line 329 "CodeCalling.puma"
   failure_protocol (MODULE, "TranslateArguments", arguments);
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

;
}

static void TranslateArg
# if defined __STDC__ | defined __cplusplus
(register tTree arg, register tTree * yyP7, register tTree * yyP6, register tTree * yyP5)
# else
(arg, yyP7, yyP6, yyP5)
 register tTree arg;
 register tTree * yyP7;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (arg->Kind == kVAR_PARAM) {
# line 334 "CodeCalling.puma"
  {
# line 336 "CodeCalling.puma"
   if (! ((arg->VAR_PARAM.pass_by == kDEFAULT_PASS_BY))) goto yyL1;
  {
# line 337 "CodeCalling.puma"
 arg->VAR_PARAM.pass_by = kDATA_PASS_BY; 
# line 338 "CodeCalling.puma"
   goto yyL1;
  }
  }
yyL1:;

  if (arg->VAR_PARAM.V->Kind == kINDEXED_VAR) {
# line 341 "CodeCalling.puma"
  {
# line 343 "CodeCalling.puma"
   if (! ((arg->VAR_PARAM.pass_by == kDATA_PASS_BY))) goto yyL2;
  {
# line 345 "CodeCalling.puma"
 arg->VAR_PARAM.V = FirstLocalDataElement (arg->VAR_PARAM.V); 
  }
  }
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL2:;

  }
# line 348 "CodeCalling.puma"
  {
# line 350 "CodeCalling.puma"
   if (! ((arg->VAR_PARAM.pass_by == kDATA_PASS_BY))) goto yyL3;
  }
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL3:;

# line 353 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 355 "CodeCalling.puma"
   if (! ((arg->VAR_PARAM.pass_by == kHPF_HANDLE_PASS_BY))) goto yyL4;
  {
# line 357 "CodeCalling.puma"
   MakeDescriptorParameter (arg, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP7 = yyV1;
   * yyP6 = yyV2;
   * yyP5 = yyV3;
   return;
 }
yyL4:;

  }
  if (arg->Kind == kNO_PARAM) {
# line 360 "CodeCalling.puma"
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
  if (arg->Kind == kPROC_PARAM) {
# line 363 "CodeCalling.puma"
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
  if (arg->Kind == kFUNC_PARAM) {
# line 366 "CodeCalling.puma"
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
;
}

static void MakeDescriptorParameter
# if defined __STDC__ | defined __cplusplus
(register tTree param, register tTree * yyP10, register tTree * yyP9, register tTree * yyP8)
# else
(param, yyP10, yyP9, yyP8)
 register tTree param;
 register tTree * yyP10;
 register tTree * yyP9;
 register tTree * yyP8;
# endif
{
  if (param->Kind == kVAR_PARAM) {
# line 378 "CodeCalling.puma"
 {
  tTree pre;
  tTree post;
  tTree dsp;
  int pack;
  {
# line 380 "CodeCalling.puma"
   if (! (((param->VAR_PARAM.layout == kHPF_LOCAL_LAYOUT) || (param->VAR_PARAM.layout == kF77_LOCAL_LAYOUT)))) goto yyL1;
  {
# line 382 "CodeCalling.puma"
   if (! ((TreeRank (param->VAR_PARAM.V) > 0))) goto yyL1;
  {
# line 384 "CodeCalling.puma"

# line 385 "CodeCalling.puma"

# line 386 "CodeCalling.puma"

# line 388 "CodeCalling.puma"

# line 390 "CodeCalling.puma"
 if (param->VAR_PARAM.layout == kF77_LOCAL_LAYOUT)
        pack = 1;
       else
        pack = 0;
   
# line 396 "CodeCalling.puma"
   DalibLocalTranslation (section_counter, pack, param->VAR_PARAM.V, & pre, & dsp, & post);
# line 398 "CodeCalling.puma"
 if (pre != NoTree) section_counter ++; 
  }
  }
  }
   * yyP10 = dsp;
   * yyP9 = pre;
   * yyP8 = post;
   return;
 }
yyL1:;

# line 401 "CodeCalling.puma"
 {
  tTree pre;
  tTree post;
  tTree dsp;
  {
# line 409 "CodeCalling.puma"
   if (! ((TreeRank (param->VAR_PARAM.V) > 0))) goto yyL2;
  {
# line 411 "CodeCalling.puma"

# line 412 "CodeCalling.puma"

# line 413 "CodeCalling.puma"

# line 415 "CodeCalling.puma"
   DalibSectionTranslation (section_counter, param->VAR_PARAM.V, & pre, & dsp, & post);
# line 417 "CodeCalling.puma"
 if (pre != NoTree) section_counter ++; 
  }
  }
   * yyP10 = dsp;
   * yyP9 = pre;
   * yyP8 = post;
   return;
 }
yyL2:;

  if (param->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 424 "CodeCalling.puma"
 {
  tTree dsp;
  {
# line 427 "CodeCalling.puma"
   if (! ((VarRank (param->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object) == 0))) goto yyL3;
  {
# line 428 "CodeCalling.puma"
   if (! ((IsVarDummy (param->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL3;
  {
# line 430 "CodeCalling.puma"

# line 432 "CodeCalling.puma"
   dsp = mVAR_PARAM (MakeUsedVarA (param->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Ident, DUMMY_SUFFIX));
  }
  }
  }
   * yyP10 = dsp;
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   return;
 }
yyL3:;

  }
  }
# line 437 "CodeCalling.puma"
   * yyP10 = mNO_PARAM (kDUMMY_TYPE);
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   return;

;
}

void UpdateLocalCalls
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 450 "CodeCalling.puma"
  {
# line 452 "CodeCalling.puma"
   FullTraverseAST (t, UpdateCalling);
  }
   return;

;
}

static void UpdateCalling
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCALL_STMT) {
# line 467 "CodeCalling.puma"
  {
# line 469 "CodeCalling.puma"
   if (! ((IsIntrCall (t)))) goto yyL1;
  }
   return;
yyL1:;

# line 472 "CodeCalling.puma"
  {
# line 474 "CodeCalling.puma"
   if (! ((IsPureCall (t)))) goto yyL2;
  }
   return;
yyL2:;

# line 477 "CodeCalling.puma"
  {
# line 479 "CodeCalling.puma"
 

     t->CALL_STMT.CALL_PARAMS = TranslateActualParams (t, t->CALL_STMT.CALL_PARAMS);

   
  }
   return;

  }
  if (t->Kind == kFUNC_CALL_EXP) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
# line 486 "CodeCalling.puma"
  {
# line 488 "CodeCalling.puma"
   if (! ((IsIntrCall (t)))) goto yyL4;
  {
# line 490 "CodeCalling.puma"
   if (! ((t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("PRESENT")))) goto yyL4;
  {
# line 492 "CodeCalling.puma"
   SetDataParamAttributes (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
  }
  }
  }
   return;
yyL4:;

# line 495 "CodeCalling.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 497 "CodeCalling.puma"
   if (! ((IsIntrCall (t)))) goto yyL5;
  {
# line 499 "CodeCalling.puma"
   if (! ((t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("ALLOCATED")))) goto yyL5;
  {
# line 501 "CodeCalling.puma"
   SetHandleParamAttributes (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
# line 502 "CodeCalling.puma"
   TranslateArg (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 504 "CodeCalling.puma"
 t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem = yyV1;

     if ((yyV2 != NoTree) || (yyV3 != NoTree))
        error_protocol ("ALLOCATED only with full array");
   
  }
  }
  }
   return;
 }
yyL5:;

  }
# line 511 "CodeCalling.puma"
  {
# line 513 "CodeCalling.puma"
   if (! ((IsUserCall (t)))) goto yyL6;
  {
# line 515 "CodeCalling.puma"
 

     t->FUNC_CALL_EXP.FUNC_PARAMS = TranslateActualParams (t, t->FUNC_CALL_EXP.FUNC_PARAMS);

   
  }
  }
   return;
yyL6:;

  }
;
}

static tTree TranslateActualParams
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree params)
# else
(call, params)
 register tTree call;
 register tTree params;
# endif
{
# line 530 "CodeCalling.puma"
 {
  tTree new;
  tTree yyV1;
  tTree yyV2;
  {
# line 532 "CodeCalling.puma"

# line 534 "CodeCalling.puma"
 if (IsF77Call (call))
        new = params;
      else
        new = DoubleArguments (params); 
   
# line 540 "CodeCalling.puma"
   TranslateArguments (new, & yyV1, & yyV2);
# line 542 "CodeCalling.puma"
 if ((yyV1 != NoTree) || (yyV2 != NoTree))

      { warning_protocol ("descriptors are not validated");
        print_protocol ("descriptor is needed");
      }
   
  }
  {
   return new;
  }
 }

}

static tTree FirstLocalDataElement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 562 "CodeCalling.puma"
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 566 "CodeCalling.puma"
 {
  var_descriptor vard;
  int dim;
  tTree new_indexes;
  {
# line 568 "CodeCalling.puma"

# line 569 "CodeCalling.puma"

# line 570 "CodeCalling.puma"

# line 572 "CodeCalling.puma"
   SetVarDescriptor (t, & vard);
# line 574 "CodeCalling.puma"
 new_indexes = mBTE_EMPTY ();
 
     
  
     for (dim=vard.formal_rank; dim>=1; dim--)

        new_indexes = mBTE_LIST (LocalIndex (t->INDEXED_VAR.IND_VAR, &vard, dim), new_indexes);

   
  }
  {
   return mINDEXED_VAR (t->INDEXED_VAR.IND_VAR, new_indexes);
  }
 }

  }
# line 587 "CodeCalling.puma"
  {
# line 589 "CodeCalling.puma"
   failure_protocol (MODULE, "FirstLocalElement", t);
  }
   return t;

}

static tTree LocalIndex
# if defined __STDC__ | defined __cplusplus
(register tTree v, pvar vard, register int dim)
# else
(v, vard, dim)
 register tTree v;
 pvar vard;
 register int dim;
# endif
{
# line 595 "CodeCalling.puma"
  {
# line 599 "CodeCalling.puma"
   if (! ((vard -> actual_shape [dim - 1] [0] == vard -> actual_shape [dim - 1] [1]))) goto yyL1;
  }
   return vard -> actual_shape [dim - 1] [0];
yyL1:;

# line 604 "CodeCalling.puma"
  {
# line 608 "CodeCalling.puma"
   if (! ((vard -> distribution_kind [dim - 1] == kSERIAL_DIM))) goto yyL2;
  }
   return vard -> actual_shape [dim - 1] [0];
yyL2:;

# line 613 "CodeCalling.puma"
   return mBOUND_EXP (v, dim, 0, 1);

}

static void TranslateHPFSend
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 628 "CodeCalling.puma"
 {
  tTree size;
  {
# line 631 "CodeCalling.puma"
   if (! ((TreeRank (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem) == 0))) goto yyL1;
  {
# line 633 "CodeCalling.puma"

# line 635 "CodeCalling.puma"
   size = ExpToVarParam (MakeConstant (TreeSize (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem)));
# line 637 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem);
# line 638 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
# line 639 "CodeCalling.puma"
   SetDataParamAttributes (size);
# line 641 "CodeCalling.puma"
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next = mBTP_LIST (size, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next);
# line 643 "CodeCalling.puma"
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_SEND_SCALAR");
  }
  }
   return;
 }
yyL1:;

  }
  }
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 646 "CodeCalling.puma"
 {
  tTree ptr_data;
  {
# line 649 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
# line 651 "CodeCalling.puma"

# line 654 "CodeCalling.puma"
   if (! (ptr_data = CopyTree (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem))) goto yyL2;
  {
# line 655 "CodeCalling.puma"
   SetDataParamAttributes (ptr_data);
# line 657 "CodeCalling.puma"
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next = mBTP_LIST (ptr_data, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next);
# line 659 "CodeCalling.puma"
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_SEND_ARRAY");
  }
  }
   return;
 }
yyL2:;

  }
  }
  }
  }
;
}

static void TranslateHPFSendInit
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 672 "CodeCalling.puma"
  {
# line 675 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
# line 676 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
  }
  }
;
}

static void TranslateHPFRecv
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 687 "CodeCalling.puma"
 {
  tTree size;
  {
# line 690 "CodeCalling.puma"
   if (! ((TreeRank (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem) == 0))) goto yyL1;
  {
# line 692 "CodeCalling.puma"

# line 694 "CodeCalling.puma"
   size = ExpToVarParam (MakeConstant (TreeSize (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem)));
# line 696 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem);
# line 697 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
# line 698 "CodeCalling.puma"
   SetDataParamAttributes (size);
# line 700 "CodeCalling.puma"
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next = mBTP_LIST (size, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next);
# line 702 "CodeCalling.puma"
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_RECV_SCALAR");
  }
  }
   return;
 }
yyL1:;

  }
  }
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 705 "CodeCalling.puma"
 {
  tTree ptr_data;
  {
# line 708 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
# line 710 "CodeCalling.puma"

# line 713 "CodeCalling.puma"
   if (! (ptr_data = CopyTree (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem))) goto yyL2;
  {
# line 714 "CodeCalling.puma"
   SetDataParamAttributes (ptr_data);
# line 716 "CodeCalling.puma"
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next = mBTP_LIST (ptr_data, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next);
# line 718 "CodeCalling.puma"
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_RECV_ARRAY");
  }
  }
   return;
 }
yyL2:;

  }
  }
  }
  }
;
}

static void TranslateHPFRecvInit
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 729 "CodeCalling.puma"
  {
# line 733 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
# line 734 "CodeCalling.puma"
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
  }
  }
;
}

void BeginCodeCalling ()
{
}

void CloseCodeCalling ()
{
}
