# include "Classification.h"
# include "yyClassification.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 23 "Classification.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Types.h"
# include "Objects.h"
# include "Intrinsics.h"
# include "Loops.h"
# include "Distributions.h"
# include "Transform.h"      /* CombineACF, CombineBTV, ... */

# include "Nesting.h"        /* GetCurrentUnit   */
# include "Independence.h"

    /*******************************************
    *                                          *
    *  PrePhases : Movement, MakeOn            *
    *                                          *
    *******************************************/
 
# include "MakeMovement.h"      /* MakeMovement */
# include "MakeOn.h"            /* MakeOn        */

    /*******************************************
    *                                          *
    *  used for own phase of classification    *
    *                                          *
    *******************************************/
 
# include "UserFunctions.h"  /* TranslateUserFunction */
# include "Barriers.h"       
# include "Scatter.h"
# include "Traverse.h"
# include "Reductions.h"      /* ResolveReduce         */

# include "VarDescriptor.h"
# include "Ownership.h"
# include "ReductionComm.h"

# include "SMParallel.h"
# include "RemoteAccess.h"
# include "MoveControl.h"
# include "ExpDescriptor.h"
# include "Rank.h"

# define MODULE "Classification"



static void yyExit () { Exit (1); }

void (* Classification_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Classification, routine %s failed\n", yyFunction);
 Classification_Exit ();
}

void Classification ARGS((tTree t));
static void ClassifyBody ARGS((tTree t));
static bool StopClassification ARGS((tTree t));
static tTree DoClassification ARGS((tTree t));
static tTree ClassifySimple ARGS((tTree t));
static tTree ClassifyAssignment ARGS((tTree stmt, tTree var, tTree exp));
static tTree ClassifyMovement ARGS((tTree t));
static tTree MakeMoveBroadcast ARGS((tTree t));
static tTree MakeOwnerBroadcast ARGS((tTree var, tTree on_stmt));
static void VarOwnership ARGS((tTree var, tTree * yyP2, tTree * yyP1));
static tTree OnOwnership ARGS((tTree stmt, tTree var));
static void CheckMovement ARGS((tTree target_var, tTree source_exp));
static tTree ClassifyOnStatement ARGS((tTree on_stmt));
static void UpdateOnBody ARGS((tTree t));
static void ClassifyRMA ARGS((tTree t));
static bool StopRMA ARGS((tTree t));
static tTree DoRMA ARGS((tTree t));

void Classification
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
# line 87 "Classification.puma"
  {
# line 89 "Classification.puma"
   open_protocol ("adaptor.class");
# line 90 "Classification.puma"
   Classification (t->COMP_UNIT.COMP_ELEMENTS);
# line 91 "Classification.puma"
   close_protocol ();
  }
   return;

  }
  if (t->Kind == kUNIT_EMPTY) {
# line 94 "Classification.puma"
   return;

  }
  if (t->Kind == kUNIT_LIST) {
  if (t->UNIT_LIST.Elem->Kind == kPROGRAM_DECL) {
# line 97 "Classification.puma"
  {
# line 99 "Classification.puma"
   NestOpenUnit (t->UNIT_LIST.Elem);
# line 100 "Classification.puma"
   Classification (t->UNIT_LIST.Elem->PROGRAM_DECL.PROGRAM_BODY);
# line 101 "Classification.puma"
   NestCloseUnit (t->UNIT_LIST.Elem);
# line 102 "Classification.puma"
   Classification (t->UNIT_LIST.Next);
  }
   return;

  }
  if (t->UNIT_LIST.Elem->Kind == kPROC_DECL) {
# line 105 "Classification.puma"
  {
# line 107 "Classification.puma"
   NestOpenUnit (t->UNIT_LIST.Elem);
# line 108 "Classification.puma"
   Classification (t->UNIT_LIST.Elem->PROC_DECL.PROC_BODY);
# line 109 "Classification.puma"
   NestCloseUnit (t->UNIT_LIST.Elem);
# line 110 "Classification.puma"
   Classification (t->UNIT_LIST.Next);
  }
   return;

  }
  if (t->UNIT_LIST.Elem->Kind == kFUNC_DECL) {
# line 113 "Classification.puma"
 {
  tTree p;
  {
# line 115 "Classification.puma"

# line 117 "Classification.puma"
   NestOpenUnit (t->UNIT_LIST.Elem);
# line 118 "Classification.puma"
   Classification (t->UNIT_LIST.Elem->FUNC_DECL.FUNC_BODY);
# line 119 "Classification.puma"
 p = TranslateUserFunction (t->UNIT_LIST.Elem); 
# line 120 "Classification.puma"
   NestCloseUnit (t->UNIT_LIST.Elem);
# line 121 "Classification.puma"
 t->UNIT_LIST.Elem = p; 
# line 122 "Classification.puma"
   Classification (t->UNIT_LIST.Next);
  }
   return;
 }

  }
  if (t->UNIT_LIST.Elem->Kind == kBLOCK_DATA_DECL) {
# line 125 "Classification.puma"
  {
# line 127 "Classification.puma"
   NestOpenUnit (t->UNIT_LIST.Elem);
# line 128 "Classification.puma"
   Classification (t->UNIT_LIST.Elem->BLOCK_DATA_DECL.DATA_BODY);
# line 129 "Classification.puma"
   NestCloseUnit (t->UNIT_LIST.Elem);
# line 130 "Classification.puma"
   Classification (t->UNIT_LIST.Next);
  }
   return;

  }
  if (t->UNIT_LIST.Elem->Kind == kMODULE_DECL) {
# line 133 "Classification.puma"
  {
# line 135 "Classification.puma"
   NestOpenUnit (t->UNIT_LIST.Elem);
# line 136 "Classification.puma"
   Classification (t->UNIT_LIST.Elem->MODULE_DECL.MODULE_BODY);
# line 137 "Classification.puma"
   NestCloseUnit (t->UNIT_LIST.Elem);
# line 138 "Classification.puma"
   Classification (t->UNIT_LIST.Next);
  }
   return;

  }
  }
  if (t->Kind == kBODY_NODE) {
# line 141 "Classification.puma"
  {
# line 143 "Classification.puma"
   print_protocol ("Step 1 : classification of movements");
# line 144 "Classification.puma"
   print_protocol ("====================================");
# line 145 "Classification.puma"
   MakeMovement (t);
# line 146 "Classification.puma"
   print_protocol ("");
# line 147 "Classification.puma"
   print_protocol ("Step 2 : check independence");
# line 148 "Classification.puma"
   print_protocol ("===========================");
# line 149 "Classification.puma"
   CheckIndependence (t);
# line 150 "Classification.puma"
   print_protocol ("");
# line 151 "Classification.puma"
   print_protocol ("Step 2a : find SM parallelism");
# line 152 "Classification.puma"
   print_protocol ("=============================");
# line 153 "Classification.puma"
   FindSMParallel (t);
# line 154 "Classification.puma"
   print_protocol ("");
# line 155 "Classification.puma"
   print_protocol ("Step 2b : identify reductions");
# line 156 "Classification.puma"
   print_protocol ("=============================");
# line 157 "Classification.puma"
   ReductionCommunication (t);
# line 158 "Classification.puma"
   print_protocol ("");
# line 159 "Classification.puma"
   tree_protocol (" after step 2 : \n", t);
# line 160 "Classification.puma"
   print_protocol ("Step 3 : ownership for local loops");
# line 161 "Classification.puma"
   print_protocol ("==================================");
# line 162 "Classification.puma"
   MakeOn (t);
# line 163 "Classification.puma"
   print_protocol ("");
# line 164 "Classification.puma"
   print_protocol ("Step 4 : identify SM parallelism");
# line 165 "Classification.puma"
   print_protocol ("================================");
# line 166 "Classification.puma"
   MakeSMParallel (t);
# line 167 "Classification.puma"
   print_protocol ("");
# line 168 "Classification.puma"
   print_protocol ("Step 5 : classification");
# line 169 "Classification.puma"
   print_protocol ("=======================");
# line 170 "Classification.puma"
   ClassifyBody (t);
# line 171 "Classification.puma"
   print_protocol ("");
# line 172 "Classification.puma"
   print_protocol ("Step 6 : RMA accesses");
# line 173 "Classification.puma"
   print_protocol ("=====================");
# line 174 "Classification.puma"
   ClassifyRMA (t);
# line 176 "Classification.puma"
   Classification (t->BODY_NODE.INTERNALS);
  }
   return;

  }
;
}

static void ClassifyBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 187 "Classification.puma"
  {
# line 189 "Classification.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopClassification, DoClassification); 
  }
   return;

  }
# line 192 "Classification.puma"
  {
# line 193 "Classification.puma"
   failure_protocol (MODULE, "ClassifyBody", t);
  }
   return;

;
}

static bool StopClassification
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_ON) {
# line 207 "Classification.puma"
   return true;

  }
  if (Tree_IsType (t, kBT_STMT)) {
# line 210 "Classification.puma"
   return true;

  }
  if (t->Kind == kACF_WHERE) {
# line 221 "Classification.puma"
  {
# line 222 "Classification.puma"
   if (! ((IsParallelLoop (t)))) goto yyL3;
  {
# line 223 "Classification.puma"
   error_protocol ("here should be no where statements");
  }
  }
   return true;
yyL3:;

  }
  return false;
}

static tTree DoClassification
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_ON:
# line 244 "Classification.puma"
 {
  tTree new;
  {
# line 246 "Classification.puma"

# line 248 "Classification.puma"
 new = GetBarriers (t);
     new = CombineACF (CopyTree(new), 
             CombineACF (ClassifyOnStatement (t), 
               CombineACF (new, GetUpdates(t))));
   
  }
  {
   return new;
  }
 }

  case kACF_BASIC:
# line 256 "Classification.puma"
 {
  tTree barriers;
  tTree updates;
  tTree new;
  {
# line 258 "Classification.puma"

# line 259 "Classification.puma"

# line 261 "Classification.puma"

# line 263 "Classification.puma"
 barriers = GetBarriers (t);
     updates  = GetUpdates  (t);

     new = ComposeNewACF (CopyTree(barriers), ClassifySimple (t), barriers);

     if (t != new)
        stmt_protocol ("basic statement has been new classified");

     new = CombineACF (new, updates);

   
  }
  {
   return new;
  }
 }

  case kACF_WHILE:
# line 278 "Classification.puma"
  {
# line 280 "Classification.puma"
   if (! ((TreeReadDistribution (t->ACF_WHILE.WHILE_EXP) != 0))) goto yyL3;
  {
# line 281 "Classification.puma"
   error_protocol ("boolean expression in DO WHILE is not replicated");
  }
  }
   return t;
yyL3:;

# line 286 "Classification.puma"
   return t;

  case kACF_DO:
# line 291 "Classification.puma"
  {
# line 293 "Classification.puma"
   if (! ((TreeReadDistribution (t->ACF_DO.DO_RANGE) != 0))) goto yyL5;
  {
# line 295 "Classification.puma"
   set_protocol_stmt (t);
# line 296 "Classification.puma"
   error_protocol ("range in DO loop is not replicated");
  }
  }
   return t;
yyL5:;

# line 301 "Classification.puma"
   return t;

  case kACF_REDUCTION:
# line 308 "Classification.puma"
   return t->ACF_REDUCTION.REDUCTION_BODY;

  case kACF_FORALL:
# line 313 "Classification.puma"
  {
# line 315 "Classification.puma"
   if (! ((TreeReadDistribution (t->ACF_FORALL.FORALL_RANGE) != 0))) goto yyL8;
  {
# line 316 "Classification.puma"
   error_protocol ("range in FORALL statement/construct is not replicated");
  }
  }
   return t;
yyL8:;

# line 321 "Classification.puma"
   return t;

  case kACF_IF:
# line 326 "Classification.puma"
  {
# line 328 "Classification.puma"
   if (! ((TreeReadDistribution (t->ACF_IF.IF_EXP) != 0))) goto yyL10;
  {
# line 329 "Classification.puma"
   error_protocol ("boolean expression in IF statement is not replicated");
  }
  }
   return t;
yyL10:;

# line 334 "Classification.puma"
   return t;

  case kACF_WHERE:
# line 339 "Classification.puma"
  {
# line 341 "Classification.puma"
   error_protocol ("where statements do not exist here");
  }
   return t;

  }

# line 345 "Classification.puma"
   return t;

}

static tTree ClassifySimple
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 366 "Classification.puma"
 {
  tTree new;
  {
# line 369 "Classification.puma"
   if (! ((IsIntrCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  {
# line 370 "Classification.puma"
   if (! ((IntrFuncScatter (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL1;
  {
# line 372 "Classification.puma"

# line 374 "Classification.puma"
 stmt_protocol ("translate scatter operation");
      new = MakeScatterStmt (t);
      tree_protocol ("new scatter stmt : \n", new);
    
  }
  }
  }
  {
   return ClassifySimple (new);
  }
 }
yyL1:;

# line 389 "Classification.puma"
 {
  tTree param;
  {
# line 391 "Classification.puma"
   if (! ((FunctionBecomesSubroutine (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID)))) goto yyL2;
  {
# line 393 "Classification.puma"

# line 395 "Classification.puma"
 param = mVAR_PARAM (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
      t->ACF_BASIC.BASIC_STMT  = mCALL_STMT (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID, mBTP_LIST (param, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS));
    
  }
  }
  {
   return ClassifySimple (t);
  }
 }
yyL2:;

  }
# line 419 "Classification.puma"
   return ClassifyAssignment (t, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 408 "Classification.puma"
   return ResolveReduce (t);

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 433 "Classification.puma"
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kSCATTER_STMT) {
# line 438 "Classification.puma"
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
# line 443 "Classification.puma"
   return ClassifyMovement (t);

  }
# line 457 "Classification.puma"
   return t;

  }
# line 462 "Classification.puma"
  {
# line 463 "Classification.puma"
   failure_protocol (MODULE, "ClassifySimple", t);
  }
   return t;

}

static tTree ClassifyAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree var, register tTree exp)
# else
(stmt, var, exp)
 register tTree stmt;
 register tTree var;
 register tTree exp;
# endif
{
# line 483 "Classification.puma"
  {
# line 485 "Classification.puma"
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL1;
  {
# line 486 "Classification.puma"
   stmt_protocol ("statement not changed in PURE procedure");
  }
  }
   return stmt;
yyL1:;

# line 490 "Classification.puma"
  {
# line 492 "Classification.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL2;
  {
# line 493 "Classification.puma"
   stmt_protocol ("statement not changed in LOCAL procedure");
  }
  }
   return stmt;
yyL2:;

# line 503 "Classification.puma"
  {
# line 505 "Classification.puma"
   if (! ((CountMovements (var, exp) == 0))) goto yyL3;
  {
# line 507 "Classification.puma"
   stmt_protocol ("local statement");
  }
  }
   return stmt;
yyL3:;

  if (stmt->Kind == kACF_BASIC) {
# line 521 "Classification.puma"
  {
# line 523 "Classification.puma"
   if (! ((TreeRank (exp) != TreeRank (var)))) goto yyL4;
  {
# line 524 "Classification.puma"
   error_protocol ("illegal data movement (rank mismatch)");
  }
  }
   return stmt;
yyL4:;

# line 529 "Classification.puma"
  {
# line 531 "Classification.puma"
   CheckMovement (var, exp);
# line 532 "Classification.puma"
 stmt->Kind = kACF_MOVE; 
# line 533 "Classification.puma"
   stmt_protocol ("data movement");
  }
   return stmt;

  }
 yyAbort ("ClassifyAssignment");
}

static tTree ClassifyMovement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK->Kind == kNO_PARAM) {
# line 550 "Classification.puma"
  {
# line 552 "Classification.puma"
   if (! ((TreeRank (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET) == 0))) goto yyL1;
  {
# line 553 "Classification.puma"
   if (! ((CountMovements (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE, t->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET) == 0))) goto yyL1;
  {
# line 555 "Classification.puma"
 

     t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET, mVAR_EXP (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE));

   
  }
  }
  }
   return MakeMoveBroadcast (t);
yyL1:;

  }
# line 564 "Classification.puma"
  {
# line 566 "Classification.puma"
 t->Kind = kACF_MOVE; 
  }
   return t;

  }
  }
 yyAbort ("ClassifyMovement");
}

static tTree MakeMoveBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 578 "Classification.puma"
 {
  tTree new;
  {
# line 580 "Classification.puma"

# line 582 "Classification.puma"
 new = OnOwnership (t, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
     new = CombineACF (new, MakeOwnerBroadcast (CopyTree (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), new));
   
  }
  {
   return new;
  }
 }

  }
  }
  }
 yyAbort ("MakeMoveBroadcast");
}

static tTree MakeOwnerBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree on_stmt)
# else
(var, on_stmt)
 register tTree var;
 register tTree on_stmt;
# endif
{
  if (on_stmt->Kind == kACF_ON) {
# line 597 "Classification.puma"
   return mACF_BASIC (mBROADCAST_STMT (mBTV_LIST (var, mBTV_EMPTY ()), on_stmt->ACF_ON.ON_HOME, on_stmt->ACF_ON.ON_SPECS));

  }
 yyAbort ("MakeOwnerBroadcast");
}

static void VarOwnership
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree * yyP2, register tTree * yyP1)
# else
(var, yyP2, yyP1)
 register tTree var;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 613 "Classification.puma"
 {
  var_descriptor owner;
  tTree on_top;
  tTree on_spec;
  bool found;
  {
# line 615 "Classification.puma"

# line 616 "Classification.puma"

# line 617 "Classification.puma"

# line 618 "Classification.puma"

# line 620 "Classification.puma"
   GetVarDescriptor (var, & found, & owner);
# line 621 "Classification.puma"
   if (! ((found))) goto yyL1;
  {
# line 623 "Classification.puma"
 

   if (owner.topology_rank < -1 )
     { error_protocol ("illegal ownerhip");
       tree_protocol ("illegal variable is : ", var);
     }

   on_top  = MakeOnTopology (&owner);
   on_spec = MakeOnSpecs   (&owner);
 
  }
  }
   * yyP2 = on_top;
   * yyP1 = on_spec;
   return;
 }
yyL1:;

# line 635 "Classification.puma"
  {
# line 636 "Classification.puma"
   error_protocol ("problems to get ownership");
# line 637 "Classification.puma"
   tree_protocol ("no var descriptor for this variable : ", var);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static tTree OnOwnership
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree var)
# else
(stmt, var)
 register tTree stmt;
 register tTree var;
# endif
{
# line 642 "Classification.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 644 "Classification.puma"
   VarOwnership (var, & yyV1, & yyV2);
  }
  {
   return mACF_ON (yyV1, yyV2, mACF_LIST (stmt, mACF_EMPTY ()));
  }
 }

}

static void CheckMovement
# if defined __STDC__ | defined __cplusplus
(register tTree target_var, register tTree source_exp)
# else
(target_var, source_exp)
 register tTree target_var;
 register tTree source_exp;
# endif
{
  if (source_exp->Kind == kVAR_EXP) {
# line 657 "Classification.puma"
  {
# line 659 "Classification.puma"
   CheckMovement (target_var, source_exp->VAR_EXP.V);
  }
   return;

  }
  if (source_exp->Kind == kPERM_EXP) {
  if (source_exp->PERM_EXP.VAL->Kind == kVAR_EXP) {
# line 662 "Classification.puma"
  {
# line 664 "Classification.puma"
   CheckMovement (target_var, source_exp->PERM_EXP.VAL->VAR_EXP.V);
  }
   return;

  }
  }
  if (source_exp->Kind == kFUNC_CALL_EXP) {
  if (source_exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (source_exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 667 "Classification.puma"
  {
# line 670 "Classification.puma"
   if (! ((IsIntrCall (source_exp)))) goto yyL3;
  {
# line 672 "Classification.puma"
   if (! ((source_exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("TRANSPOSE", 9)))) goto yyL3;
  {
# line 673 "Classification.puma"
   CheckMovement (target_var, source_exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
  }
  }
  }
   return;
yyL3:;

  }
  }
  }
  if (source_exp->Kind == kINDEXED_VAR) {
# line 677 "Classification.puma"
 {
  bool okay;
  {
# line 679 "Classification.puma"

# line 681 "Classification.puma"
 okay = IsSameExpType (source_exp, target_var);

     if (!okay)
        { error_protocol ("Movement requires same type");
          tree_protocol ("Source type is ", TreeType (source_exp));
          tree_protocol ("Target type is ", TreeType (target_var));
        }
   
  }
   return;
 }

  }
# line 691 "Classification.puma"
  {
# line 692 "Classification.puma"
   error_protocol ("illegal movement (could not be classified)");
  }
   return;

;
}

static tTree ClassifyOnStatement
# if defined __STDC__ | defined __cplusplus
(register tTree on_stmt)
# else
(on_stmt)
 register tTree on_stmt;
# endif
{
  if (on_stmt->Kind == kACF_ON) {
# line 731 "Classification.puma"
  {
# line 733 "Classification.puma"
   set_protocol_stmt (on_stmt);
# line 735 "Classification.puma"
 stmt_protocol ("ON classification");

      

      UpdateOnBody (on_stmt->ACF_ON.ON_BODY);  

    
  }
   return on_stmt;

  }
 yyAbort ("ClassifyOnStatement");
}

static void UpdateOnBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_ON:
# line 754 "Classification.puma"
  {
# line 755 "Classification.puma"
   UpdateOnBody (t->ACF_ON.ON_BODY);
  }
   return;

  case kACF_TASK_REGION:
# line 758 "Classification.puma"
  {
# line 760 "Classification.puma"
   UpdateOnBody (t->ACF_TASK_REGION.TASK_BODY);
  }
   return;

  case kACF_PARALLEL:
# line 763 "Classification.puma"
  {
# line 765 "Classification.puma"
   UpdateOnBody (t->ACF_PARALLEL.PARALLEL_BODY);
  }
   return;

  case kACF_DO:
# line 768 "Classification.puma"
  {
# line 770 "Classification.puma"
   if (! ((IsParallelLoop (t)))) goto yyL4;
  {
# line 772 "Classification.puma"
   UpdateOnBody (t->ACF_DO.DO_BODY);
  }
  }
   return;
yyL4:;

# line 817 "Classification.puma"
  {
# line 819 "Classification.puma"
   UpdateOnBody (t->ACF_DO.DO_BODY);
  }
   return;

  case kACF_LIST:
  if (t->ACF_LIST.Elem->Kind == kACF_BASIC) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 775 "Classification.puma"
 {
  tTree param;
  {
# line 778 "Classification.puma"
   if (! ((FunctionBecomesSubroutine (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID)))) goto yyL5;
  {
# line 782 "Classification.puma"

# line 784 "Classification.puma"
 param = mVAR_PARAM (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
      t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT  = mCALL_STMT (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID, mBTP_LIST (param, t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS));
    
# line 788 "Classification.puma"
   UpdateOnBody (t->ACF_LIST.Next);
  }
  }
   return;
 }
yyL5:;

  }
  }
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 791 "Classification.puma"
  {
# line 795 "Classification.puma"
 t->ACF_LIST.Elem = ResolveReduce (t->ACF_LIST.Elem); 
# line 797 "Classification.puma"
   UpdateOnBody (t->ACF_LIST.Next);
  }
   return;

  }
  }
# line 800 "Classification.puma"
  {
# line 801 "Classification.puma"
   UpdateOnBody (t->ACF_LIST.Elem);
# line 802 "Classification.puma"
   UpdateOnBody (t->ACF_LIST.Next);
  }
   return;

  case kACF_EMPTY:
# line 805 "Classification.puma"
   return;

  case kACF_IF:
# line 808 "Classification.puma"
  {
# line 809 "Classification.puma"
   UpdateOnBody (t->ACF_IF.THEN_PART);
# line 810 "Classification.puma"
   UpdateOnBody (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHILE:
# line 813 "Classification.puma"
  {
# line 814 "Classification.puma"
   UpdateOnBody (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 826 "Classification.puma"
   return;

  }
# line 829 "Classification.puma"
   return;

  case kACF_DUMMY:
# line 832 "Classification.puma"
   return;

  }

# line 835 "Classification.puma"
  {
# line 836 "Classification.puma"
   failure_protocol (MODULE, "UpdateOnBody", t);
  }
   return;

;
}

static void ClassifyRMA
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 847 "Classification.puma"
  {
# line 849 "Classification.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopRMA, DoRMA); 
  }
   return;

  }
# line 852 "Classification.puma"
  {
# line 853 "Classification.puma"
   failure_protocol (MODULE, "ClassifyRMA", t);
  }
   return;

;
}

static bool StopRMA
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 864 "Classification.puma"
  {
# line 865 "Classification.puma"
   return false;
  }

}

static tTree DoRMA
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 870 "Classification.puma"
   return TranslateRMA (t);

  }
  }
# line 875 "Classification.puma"
   return t;

}

void BeginClassification ()
{
}

void CloseClassification ()
{
}
