# include "CheckComm.h"
# include "yyCheckComm.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 37 "CheckComm.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Nesting.h"
# include "ParNest.h"

# include "Descriptor.h"
# include "Extraction.h"

# include "Objects.h"
# include "Rank.h"
# include "VarComm.h"
# include "HomeDescriptor.h"
# include "MoveDescriptor.h"
# include "MoveControl.h"
# include "ExpDescriptor.h"
# include "Accepted.h"        /* IsDescriptorVar */
# include "Loops.h"
# include "IndShadow.h"

# define MODULE "CheckComm"

static int communication_errors;



static void yyExit () { Exit (1); }

void (* CheckComm_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CheckComm, routine %s failed\n", yyFunction);
 CheckComm_Exit ();
}

int CheckCommunication ARGS((tTree stmt));
int CheckCommunicationExp ARGS((tTree exp));
static void CheckCommACF ARGS((tTree stmt, pvar home));
static void CheckCommExp ARGS((tTree exp, pvar home));
static void CheckCommParams ARGS((tTree params, pvar home));
static void CheckCommVarParam ARGS((tTree var, int intent, pvar home));
static void CheckCommVarIndexes ARGS((tTree var, pvar home));
static bool LocalVarIndexes ARGS((tTree var, pvar home));
static void CheckCommScalarParam ARGS((tTree var, int intent, pvar home));
static void CheckCommArrayParam ARGS((pvar vard, int intent, pvar home));
static void CheckCommReduceParams ARGS((tTree params, pvar home));
static bool NoReplicatedIndex ARGS((tTree var));
static void GetTheBodyHome ARGS((tTree s, pvar home));
bool IsLocalAssignment ARGS((tTree var, tTree exp, pvar home));
bool IsCopyInAssignment ARGS((tTree var, tTree exp, pvar home));
bool IsCopyOutAssignment ARGS((tTree var, tTree exp, pvar home));
static bool IsLegalIndirect ARGS((tTree var, pvar home));
static bool LegalIndexExpression ARGS((tTree explist, pvar home));
static bool AcceptedIndirectIndex ARGS((tTree index_exp, pvar home));

int CheckCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (Tree_IsType (stmt, kACF_NODE)) {
# line 78 "CheckComm.puma"
 {
  var_descriptor home;
  {
# line 80 "CheckComm.puma"

# line 82 "CheckComm.puma"
   MakeReplicatedDescriptor (& home);
# line 84 "CheckComm.puma"
   communication_errors = 0;
# line 86 "CheckComm.puma"
   set_protocol_stmt (stmt);
# line 88 "CheckComm.puma"
   CheckCommACF (stmt, & home);
  }
  {
   return communication_errors;
  }
 }

  }
# line 93 "CheckComm.puma"
  {
# line 94 "CheckComm.puma"
   failure_protocol (MODULE, "CheckCommunication", stmt);
  }
   return 1;

}

int CheckCommunicationExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (Tree_IsType (exp, kBT_EXP)) {
# line 101 "CheckComm.puma"
 {
  var_descriptor home;
  {
# line 103 "CheckComm.puma"

# line 105 "CheckComm.puma"
   MakeReplicatedDescriptor (& home);
# line 107 "CheckComm.puma"
   communication_errors = 0;
# line 109 "CheckComm.puma"
   tree_protocol ("CHECK EXP COMMUNICATION for : ", exp);
# line 111 "CheckComm.puma"
   CheckCommExp (exp, & home);
  }
  {
   return communication_errors;
  }
 }

  }
# line 116 "CheckComm.puma"
  {
# line 117 "CheckComm.puma"
   failure_protocol (MODULE, "CheckCommunicationExp", exp);
  }
   return 1;

}

static void CheckCommACF
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home)
# else
(stmt, home)
 register tTree stmt;
 pvar home;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
# line 132 "CheckComm.puma"
  {
# line 134 "CheckComm.puma"
   set_protocol_stmt (stmt->ACF_LIST.Elem);
# line 136 "CheckComm.puma"
   CheckCommACF (stmt->ACF_LIST.Elem, home);
# line 137 "CheckComm.puma"
   CheckCommACF (stmt->ACF_LIST.Next, home);
  }
   return;

  case kACF_EMPTY:
# line 140 "CheckComm.puma"
   return;

  case kACF_DUMMY:
# line 143 "CheckComm.puma"
   return;

  case kACF_HOME:
# line 152 "CheckComm.puma"
 {
  var_descriptor body_home;
  {
# line 154 "CheckComm.puma"

# line 156 "CheckComm.puma"
   GetTheBodyHome (stmt, & body_home);
# line 158 "CheckComm.puma"
   IncParNesting (stmt);
# line 159 "CheckComm.puma"
   CheckCommACF (stmt->ACF_HOME.HOME_BODY, & body_home);
# line 160 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;
 }

  case kACF_DO:
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 169 "CheckComm.puma"
 {
  var_descriptor body_home;
  {
# line 172 "CheckComm.puma"
   CheckCommExp (stmt->ACF_DO.DO_RANGE, home);
# line 174 "CheckComm.puma"

# line 176 "CheckComm.puma"
   GetTheBodyHome (stmt, & body_home);
# line 178 "CheckComm.puma"
   IncParNesting (stmt);
# line 179 "CheckComm.puma"
   CheckCommACF (stmt->ACF_DO.DO_BODY, & body_home);
# line 180 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;
 }

  }
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
# line 189 "CheckComm.puma"
  {
# line 191 "CheckComm.puma"
   CheckCommExp (stmt->ACF_DO.DO_RANGE, home);
# line 193 "CheckComm.puma"
   IncParNesting (stmt);
# line 194 "CheckComm.puma"
   CheckCommACF (stmt->ACF_DO.DO_BODY, home);
# line 195 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;

  }
  break;
  case kACF_FORALL:
# line 206 "CheckComm.puma"
 {
  var_descriptor body_home;
  {
# line 208 "CheckComm.puma"
   CheckCommExp (stmt->ACF_FORALL.FORALL_RANGE, home);
# line 210 "CheckComm.puma"

# line 212 "CheckComm.puma"
   GetTheBodyHome (stmt, & body_home);
# line 214 "CheckComm.puma"
   IncParNesting (stmt);
# line 215 "CheckComm.puma"
   CheckCommACF (stmt->ACF_FORALL.FORALL_BODY, & body_home);
# line 216 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;
 }

  case kACF_NEW:
# line 225 "CheckComm.puma"
  {
# line 227 "CheckComm.puma"
   IncParNesting (stmt);
# line 228 "CheckComm.puma"
   CheckCommACF (stmt->ACF_NEW.NEW_BODY, home);
# line 229 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;

  case kACF_RESIDENT:
# line 238 "CheckComm.puma"
  {
# line 240 "CheckComm.puma"
   IncParNesting (stmt);
# line 241 "CheckComm.puma"
   CheckCommACF (stmt->ACF_RESIDENT.RESIDENT_BODY, home);
# line 242 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;

  case kACF_TASK_REGION:
# line 251 "CheckComm.puma"
  {
# line 253 "CheckComm.puma"
   IncParNesting (stmt);
# line 254 "CheckComm.puma"
   CheckCommACF (stmt->ACF_TASK_REGION.TASK_BODY, home);
# line 255 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;

  case kACF_REDUCTION:
# line 264 "CheckComm.puma"
  {
# line 266 "CheckComm.puma"
   IncParNesting (stmt);
# line 267 "CheckComm.puma"
   CheckCommACF (stmt->ACF_REDUCTION.REDUCTION_BODY, home);
# line 268 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;

  case kACF_WHILE:
# line 277 "CheckComm.puma"
  {
# line 279 "CheckComm.puma"
   IncParNesting (stmt);
# line 280 "CheckComm.puma"
   CheckCommExp (stmt->ACF_WHILE.WHILE_EXP, home);
# line 281 "CheckComm.puma"
   CheckCommACF (stmt->ACF_WHILE.WHILE_BODY, home);
# line 282 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;

  case kACF_IF:
# line 291 "CheckComm.puma"
  {
# line 293 "CheckComm.puma"
   CheckCommExp (stmt->ACF_IF.IF_EXP, home);
# line 295 "CheckComm.puma"
   IncParNesting (stmt);
# line 296 "CheckComm.puma"
   CheckCommACF (stmt->ACF_IF.THEN_PART, home);
# line 297 "CheckComm.puma"
   CheckCommACF (stmt->ACF_IF.ELSE_PART, home);
# line 298 "CheckComm.puma"
   DecParNesting (stmt);
  }
   return;

  case kACF_BASIC:

  switch (stmt->ACF_BASIC.BASIC_STMT->Kind) {
  case kREDUCE_STMT:
# line 307 "CheckComm.puma"
  {
# line 309 "CheckComm.puma"
   CheckCommReduceParams (stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, home);
  }
   return;

  case kCALL_STMT:
# line 318 "CheckComm.puma"
  {
# line 322 "CheckComm.puma"
   CheckCommParams (stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, home);
  }
   return;

  case kASSIGN_STMT:
  if (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 331 "CheckComm.puma"
 {
  tTree new;
  {
# line 333 "CheckComm.puma"

# line 335 "CheckComm.puma"
 new = CheckWriteComm (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home); 

     CheckCommVarIndexes (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home);

     CheckCommParams (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, home);

     if (TreeRank (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) == 0)
        CheckCommScalarParam (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, IntentOut, home);
      else

        { var_descriptor vard;
          SetVarDescriptor (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, &vard);
          if ((!IsNewVariable (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)) && (!IsResidentVariable (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)))
             CheckCommArrayParam (&vard, IntentOut, home);
        }

     if (new == NoTree) communication_errors++;

        else stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = new;   
   
  }
   return;
 }

  }
# line 363 "CheckComm.puma"
 {
  tTree new;
  {
# line 365 "CheckComm.puma"

# line 367 "CheckComm.puma"
 new = CheckWriteComm (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home); 
# line 369 "CheckComm.puma"
   CheckCommVarIndexes (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home);
# line 370 "CheckComm.puma"
   CheckCommExp (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home);
# line 372 "CheckComm.puma"
 if (IsLocalAssignment (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home))
        tree_protocol ("LOCAL   : ", stmt->ACF_BASIC.BASIC_STMT);
      else if (IsCopyInAssignment (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home))
        tree_protocol ("COPY IN : ", stmt->ACF_BASIC.BASIC_STMT);
      else if (IsCopyOutAssignment (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home))
        tree_protocol ("COPY OUT: ", stmt->ACF_BASIC.BASIC_STMT);

     if (new == NoTree) communication_errors++;

       else stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = new;  
   
  }
   return;
 }

  case kIO_STMT:
# line 391 "CheckComm.puma"
  {
# line 393 "CheckComm.puma"
   CheckCommParams (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, home);
  }
   return;

  case kALLOCATE_STMT:
# line 396 "CheckComm.puma"
   return;

  case kDEALLOCATE_STMT:
# line 399 "CheckComm.puma"
   return;

  case kCREATE_DSP_STMT:
# line 402 "CheckComm.puma"
   return;

  case kFREE_DSP_STMT:
# line 405 "CheckComm.puma"
   return;

  case kCOMP_IF_STMT:
# line 408 "CheckComm.puma"
  {
# line 410 "CheckComm.puma"
   CheckCommExp (stmt->ACF_BASIC.BASIC_STMT->COMP_IF_STMT.IF_EXP, home);
  }
   return;

  }

  break;
  }

# line 413 "CheckComm.puma"
  {
# line 415 "CheckComm.puma"
   if (! ((IsReplicatedDescriptor (home)))) goto yyL24;
  }
   return;
yyL24:;

# line 418 "CheckComm.puma"
  {
# line 420 "CheckComm.puma"
   serious_warning_protocol ("this statement in parallel loop not supported");
# line 422 "CheckComm.puma"
   communication_errors = communication_errors + 1;
  }
   return;

;
}

static void CheckCommExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home)
# else
(exp, home)
 register tTree exp;
 pvar home;
# endif
{

  switch (exp->Kind) {
  case kDUMMY_EXP:
# line 435 "CheckComm.puma"
   return;

  case kCONST_EXP:
# line 438 "CheckComm.puma"
   return;

  case kBOUND_EXP:
# line 441 "CheckComm.puma"
   return;

  case kRANK_EXP:
# line 444 "CheckComm.puma"
   return;

  case kOP_EXP:
# line 447 "CheckComm.puma"
  {
# line 449 "CheckComm.puma"
   CheckCommExp (exp->OP_EXP.OPND1, home);
# line 450 "CheckComm.puma"
   CheckCommExp (exp->OP_EXP.OPND2, home);
  }
   return;

  case kOP1_EXP:
# line 453 "CheckComm.puma"
  {
# line 455 "CheckComm.puma"
   CheckCommExp (exp->OP1_EXP.OPND, home);
  }
   return;

  case kFUNC_CALL_EXP:
# line 458 "CheckComm.puma"
  {
# line 460 "CheckComm.puma"
   if (! ((IsPureCall (exp)))) goto yyL7;
  {
# line 462 "CheckComm.puma"
   CheckCommParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home);
  }
  }
   return;
yyL7:;

# line 465 "CheckComm.puma"
  {
# line 467 "CheckComm.puma"
   if (! ((IsSerialCall (exp)))) goto yyL8;
  {
# line 469 "CheckComm.puma"
   CheckCommParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home);
  }
  }
   return;
yyL8:;

# line 472 "CheckComm.puma"
  {
# line 474 "CheckComm.puma"
   if (! ((IsStmtCall (exp)))) goto yyL9;
  {
# line 476 "CheckComm.puma"
   CheckCommParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home);
  }
  }
   return;
yyL9:;

# line 479 "CheckComm.puma"
  {
# line 481 "CheckComm.puma"
   CheckCommParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home);
  }
   return;

  case kTYPE_EXP:
# line 498 "CheckComm.puma"
  {
# line 500 "CheckComm.puma"
   CheckCommExp (exp->TYPE_EXP.ELEMENTS, home);
  }
   return;

  case kARRAY_EXP:
# line 509 "CheckComm.puma"
  {
# line 511 "CheckComm.puma"
   CheckCommExp (exp->ARRAY_EXP.ELEMENTS, home);
  }
   return;

  case kBTE_LIST:
# line 514 "CheckComm.puma"
  {
# line 516 "CheckComm.puma"
   CheckCommExp (exp->BTE_LIST.Elem, home);
# line 517 "CheckComm.puma"
   CheckCommExp (exp->BTE_LIST.Next, home);
  }
   return;

  case kBTE_EMPTY:
# line 520 "CheckComm.puma"
   return;

  case kSLICE_EXP:
# line 523 "CheckComm.puma"
  {
# line 525 "CheckComm.puma"
   CheckCommExp (exp->SLICE_EXP.START, home);
# line 526 "CheckComm.puma"
   CheckCommExp (exp->SLICE_EXP.STOP, home);
# line 527 "CheckComm.puma"
   CheckCommExp (exp->SLICE_EXP.INC, home);
  }
   return;

  case kDO_EXP:
# line 530 "CheckComm.puma"
  {
# line 532 "CheckComm.puma"
   CheckCommExp (exp->DO_EXP.RANGE, home);
# line 534 "CheckComm.puma"
   IncParNesting (exp);
# line 535 "CheckComm.puma"
   CheckCommExp (exp->DO_EXP.BODY, home);
# line 536 "CheckComm.puma"
   DecParNesting (exp);
  }
   return;

  case kVAR_EXP:
# line 539 "CheckComm.puma"
 {
  tTree new;
  {
# line 541 "CheckComm.puma"
   CheckCommVarIndexes (exp->VAR_EXP.V, home);
# line 543 "CheckComm.puma"

# line 545 "CheckComm.puma"
 new = CheckReadComm (exp->VAR_EXP.V, home);

     if (new == NoTree)
        communication_errors ++;
      else
        exp->VAR_EXP.V = new;   
   
  }
   return;
 }

  }

# line 554 "CheckComm.puma"
  {
# line 556 "CheckComm.puma"
   serious_warning_protocol ("illegal expression found");
# line 557 "CheckComm.puma"
   tree_protocol ("illegal expresion = ", exp);
# line 559 "CheckComm.puma"
   communication_errors = communication_errors + 1;
  }
   return;

;
}

static void CheckCommParams
# if defined __STDC__ | defined __cplusplus
(register tTree params, pvar home)
# else
(params, home)
 register tTree params;
 pvar home;
# endif
{
  if (params->Kind == kBTP_LIST) {
# line 570 "CheckComm.puma"
  {
# line 572 "CheckComm.puma"
   CheckCommParams (params->BTP_LIST.Elem, home);
# line 573 "CheckComm.puma"
   CheckCommParams (params->BTP_LIST.Next, home);
  }
   return;

  }
  if (params->Kind == kBTP_EMPTY) {
# line 576 "CheckComm.puma"
   return;

  }
  if (params->Kind == kVAR_PARAM) {
  if (params->VAR_PARAM.V->Kind == kADDR) {
# line 579 "CheckComm.puma"
  {
# line 581 "CheckComm.puma"
   CheckCommExp (params->VAR_PARAM.V->ADDR.E, home);
  }
   return;

  }
# line 584 "CheckComm.puma"
  {
# line 586 "CheckComm.puma"
   CheckCommVarParam (params->VAR_PARAM.V, params->VAR_PARAM.intent, home);
  }
   return;

  }
  if (params->Kind == kNO_PARAM) {
# line 589 "CheckComm.puma"
   return;

  }
  if (params->Kind == kFUNC_PARAM) {
# line 592 "CheckComm.puma"
   return;

  }
  if (params->Kind == kPROC_PARAM) {
# line 595 "CheckComm.puma"
   return;

  }
# line 598 "CheckComm.puma"
  {
# line 600 "CheckComm.puma"
   serious_warning_protocol ("illegal parameter found");
# line 601 "CheckComm.puma"
   tree_protocol ("illegal parameter is : ", params);
# line 603 "CheckComm.puma"
   communication_errors = communication_errors + 1;
  }
   return;

;
}

static void CheckCommVarParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pvar home)
# else
(var, intent, home)
 register tTree var;
 register int intent;
 pvar home;
# endif
{
  if (var->Kind == kDO_VAR) {
# line 615 "CheckComm.puma"
  {
# line 617 "CheckComm.puma"
   IncParNesting (var);
# line 618 "CheckComm.puma"
   CheckCommVarParam (var->DO_VAR.BODY, intent, home);
# line 619 "CheckComm.puma"
   DecParNesting (var);
  }
   return;

  }
  if (var->Kind == kBTV_LIST) {
# line 622 "CheckComm.puma"
  {
# line 624 "CheckComm.puma"
   CheckCommVarParam (var->BTV_LIST.Elem, intent, home);
# line 625 "CheckComm.puma"
   CheckCommVarParam (var->BTV_LIST.Next, intent, home);
  }
   return;

  }
  if (var->Kind == kBTV_EMPTY) {
# line 628 "CheckComm.puma"
   return;

  }
# line 631 "CheckComm.puma"
  {
# line 633 "CheckComm.puma"
   if (! ((IsNewVariable (var)))) goto yyL4;
  }
   return;
yyL4:;

# line 636 "CheckComm.puma"
  {
# line 638 "CheckComm.puma"
   if (! ((TreeRank (var) == 0))) goto yyL5;
  {
# line 640 "CheckComm.puma"
   CheckCommVarIndexes (var, home);
# line 642 "CheckComm.puma"
   CheckCommScalarParam (var, intent, home);
  }
  }
   return;
yyL5:;

# line 645 "CheckComm.puma"
 {
  var_descriptor vard;
  {
# line 647 "CheckComm.puma"
   CheckCommVarIndexes (var, home);
# line 649 "CheckComm.puma"

# line 651 "CheckComm.puma"
   SetVarDescriptor (var, & vard);
# line 653 "CheckComm.puma"
   if (! ((! IsNewVariable (var)))) goto yyL6;
  {
# line 654 "CheckComm.puma"
   if (! ((! IsResidentVariable (var)))) goto yyL6;
  {
# line 656 "CheckComm.puma"
   CheckCommArrayParam (& vard, intent, home);
  }
  }
  }
   return;
 }
yyL6:;

;
}

static void CheckCommVarIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
# line 667 "CheckComm.puma"
  {
# line 669 "CheckComm.puma"
   CheckCommVarIndexes (var->REMOTE_VAR.VAR, home);
  }
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 672 "CheckComm.puma"
  {
# line 674 "CheckComm.puma"
   CheckCommVarIndexes (var->SELECTED_VAR.SELEC_VAR, home);
  }
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 677 "CheckComm.puma"
  {
# line 679 "CheckComm.puma"
   CheckCommVarIndexes (var->INDEXED_VAR.IND_VAR, home);
# line 680 "CheckComm.puma"
   CheckCommExp (var->INDEXED_VAR.IND_EXPS, home);
  }
   return;

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 683 "CheckComm.puma"
  {
# line 685 "CheckComm.puma"
   CheckCommVarIndexes (var->SUBSTRING_VAR.IND_VAR, home);
# line 686 "CheckComm.puma"
   CheckCommExp (var->SUBSTRING_VAR.IND_EXP, home);
  }
   return;

  }
  if (var->Kind == kUSED_VAR) {
# line 689 "CheckComm.puma"
   return;

  }
  if (var->Kind == kLOOP_VAR) {
# line 692 "CheckComm.puma"
   return;

  }
# line 695 "CheckComm.puma"
  {
# line 697 "CheckComm.puma"
   failure_protocol (MODULE, "CheckCommVarIndexes", var);
  }
   return;

;
}

static bool LocalVarIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kSELECTED_VAR) {
# line 708 "CheckComm.puma"
  {
# line 710 "CheckComm.puma"
   if (! ((LocalVarIndexes (var->SELECTED_VAR.SELEC_VAR, home)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 713 "CheckComm.puma"
  {
# line 715 "CheckComm.puma"
   if (! ((LocalVarIndexes (var->INDEXED_VAR.IND_VAR, home)))) goto yyL2;
  {
# line 716 "CheckComm.puma"
   if (! ((! CountCommunication (home, var->INDEXED_VAR.IND_EXPS)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 719 "CheckComm.puma"
  {
# line 721 "CheckComm.puma"
   if (! ((LocalVarIndexes (var->SUBSTRING_VAR.IND_VAR, home)))) goto yyL3;
  {
# line 722 "CheckComm.puma"
   if (! ((! CountCommunication (home, var->SUBSTRING_VAR.IND_EXP)))) goto yyL3;
  }
  }
   return true;
yyL3:;

  }
  if (var->Kind == kUSED_VAR) {
# line 725 "CheckComm.puma"
   return true;

  }
  if (var->Kind == kLOOP_VAR) {
# line 728 "CheckComm.puma"
   return true;

  }
  return false;
}

static void CheckCommScalarParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pvar home)
# else
(var, intent, home)
 register tTree var;
 register int intent;
 pvar home;
# endif
{
# line 742 "CheckComm.puma"
 {
  tTree new;
  {
# line 744 "CheckComm.puma"
   if (! ((intent == IntentIn))) goto yyL1;
  {
# line 746 "CheckComm.puma"

# line 748 "CheckComm.puma"
 new = CheckReadComm (var, home);
      if (new == NoTree) communication_errors++;
    
  }
  }
   return;
 }
yyL1:;

# line 753 "CheckComm.puma"
 {
  tTree new;
  {
# line 755 "CheckComm.puma"
   if (! ((intent == IntentOut))) goto yyL2;
  {
# line 757 "CheckComm.puma"

# line 759 "CheckComm.puma"
 new = CheckWriteComm (var, home);
      if (new == NoTree) communication_errors++;
    
  }
  }
   return;
 }
yyL2:;

# line 764 "CheckComm.puma"
 {
  tTree new;
  {
# line 766 "CheckComm.puma"
 if (intent == IntentNo)
         tree_warning_protocol ("param has no intention : ", var);
    
# line 770 "CheckComm.puma"

# line 772 "CheckComm.puma"
 new = CheckReadComm (var, home);
      if (new == NoTree) communication_errors++;
        else { new = CheckWriteComm (var, home);
               if (new == NoTree) communication_errors++;
             }
    
  }
   return;
 }

;
}

static void CheckCommArrayParam
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int intent, pvar home)
# else
(vard, intent, home)
 pvar vard;
 register int intent;
 pvar home;
# endif
{
# line 798 "CheckComm.puma"
  {
# line 800 "CheckComm.puma"
   if (! ((IsReplicatedDescriptor (home)))) goto yyL1;
  }
   return;
yyL1:;

# line 809 "CheckComm.puma"
  {
# line 811 "CheckComm.puma"
   if (! ((VDIsSubSet (vard, home)))) goto yyL2;
  }
   return;
yyL2:;

# line 814 "CheckComm.puma"
  {
# line 816 "CheckComm.puma"
   if (! ((intent == IntentIn))) goto yyL3;
  {
# line 817 "CheckComm.puma"
   if (! ((VDIsOwner (home, vard)))) goto yyL3;
  }
  }
   return;
yyL3:;

# line 826 "CheckComm.puma"
  {
# line 828 "CheckComm.puma"
   if (! ((IsHostDescriptor (home)))) goto yyL4;
  {
# line 829 "CheckComm.puma"
   if (! ((IsReplicatedDescriptor (vard)))) goto yyL4;
  }
  }
   return;
yyL4:;

# line 832 "CheckComm.puma"
  {
# line 834 "CheckComm.puma"
 
     error_protocol ("array argument not local");
     tree_protocol ("illegal arg is : ", PrintableDescriptorVar (vard));
   
  }
   return;

;
}

static void CheckCommReduceParams
# if defined __STDC__ | defined __cplusplus
(register tTree params, pvar home)
# else
(params, home)
 register tTree params;
 pvar home;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 850 "CheckComm.puma"
 {
  tTree new;
  {
# line 852 "CheckComm.puma"

# line 854 "CheckComm.puma"
 new = CheckReductionComm  (params->BTP_LIST.Elem->VAR_PARAM.V, home);
     if (new == NoTree) communication_errors++; 
   
# line 858 "CheckComm.puma"
   CheckCommVarIndexes (params->BTP_LIST.Elem->VAR_PARAM.V, home);
# line 859 "CheckComm.puma"
   CheckCommParams (params->BTP_LIST.Next->BTP_LIST.Elem, home);
# line 861 "CheckComm.puma"
   CheckCommReduceParams (params->BTP_LIST.Next->BTP_LIST.Next, home);
  }
   return;
 }

  }
  }
  }
  if (params->Kind == kBTP_EMPTY) {
# line 864 "CheckComm.puma"
   return;

  }
# line 867 "CheckComm.puma"
  {
# line 869 "CheckComm.puma"
   error_protocol ("illegal reduce parameter list");
# line 870 "CheckComm.puma"
   tree_protocol ("illegal list : ", params);
  }
   return;

;
}

static bool NoReplicatedIndex
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 896 "CheckComm.puma"
 {
  bool okay;
  var_descriptor vard;
  {
# line 898 "CheckComm.puma"

# line 899 "CheckComm.puma"

# line 901 "CheckComm.puma"
   GetVarDescriptor (var, & okay, & vard);
# line 903 "CheckComm.puma"
   if (! ((okay))) goto yyL1;
  {
# line 905 "CheckComm.puma"
   if (! ((vard . var_tree != NoTree))) goto yyL1;
  {
# line 907 "CheckComm.puma"
 int i, n;

     okay = true;

     n = vard.formal_rank;

     for (i=0; i<n; i++)

        { if ((vard.distribution_kind[i] == kSERIAL_DIM) && okay)

             okay = NoParallelLoopIndex (vard.actual_shape[i][0]);

          
        }
   
# line 923 "CheckComm.puma"
   if (! ((okay))) goto yyL1;
  }
  }
  }
   return true;
 }
yyL1:;

  return false;
}

static void GetTheBodyHome
# if defined __STDC__ | defined __cplusplus
(register tTree s, pvar home)
# else
(s, home)
 register tTree s;
 pvar home;
# endif
{
  if (s->Kind == kACF_DO) {
  if (s->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
# line 933 "CheckComm.puma"
  {
# line 935 "CheckComm.puma"
   SetVarDescriptor (s->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, home);
  }
   return;

  }
  }
  if (s->Kind == kACF_FORALL) {
  if (s->ACF_FORALL.FORALL_HOME_INFO->Kind == kCOMM_INFO) {
# line 938 "CheckComm.puma"
  {
# line 940 "CheckComm.puma"
   SetVarDescriptor (s->ACF_FORALL.FORALL_HOME_INFO->COMM_INFO.home_var, home);
  }
   return;

  }
  }
  if (s->Kind == kACF_HOME) {
# line 943 "CheckComm.puma"
  {
# line 945 "CheckComm.puma"
   MakeClauseDescriptor (s->ACF_HOME.HOME_VAR, home);
  }
   return;

  }
# line 948 "CheckComm.puma"
  {
# line 950 "CheckComm.puma"
   MakeReplicatedDescriptor (home);
# line 952 "CheckComm.puma"
   error_protocol ("should not happen here");
  }
   return;

;
}

bool IsLocalAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, pvar home)
# else
(var, exp, home)
 register tTree var;
 register tTree exp;
 pvar home;
# endif
{
  if (exp->Kind == kVAR_EXP) {
# line 970 "CheckComm.puma"
  {
# line 972 "CheckComm.puma"
   if (! ((LocalVarIndexes (var, home)))) goto yyL1;
  {
# line 973 "CheckComm.puma"
   if (! ((LocalVarIndexes (exp->VAR_EXP.V, home)))) goto yyL1;
  {
# line 974 "CheckComm.puma"
   if (! ((IsLocalVarRead (exp->VAR_EXP.V, home)))) goto yyL1;
  {
# line 975 "CheckComm.puma"
   if (! ((IsLocalVarWrite (var, home)))) goto yyL1;
  }
  }
  }
  }
   return true;
yyL1:;

  }
  return false;
}

bool IsCopyInAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, pvar home)
# else
(var, exp, home)
 register tTree var;
 register tTree exp;
 pvar home;
# endif
{
  if (exp->Kind == kVAR_EXP) {
# line 995 "CheckComm.puma"
  {
# line 997 "CheckComm.puma"
   if (! ((! IsParallelMasked ()))) goto yyL1;
  {
# line 999 "CheckComm.puma"
   if (! ((LocalVarIndexes (var, home)))) goto yyL1;
  {
# line 1000 "CheckComm.puma"
   if (! ((LocalVarIndexes (exp->VAR_EXP.V, home)))) goto yyL1;
  {
# line 1002 "CheckComm.puma"
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  {
# line 1003 "CheckComm.puma"
   if (! ((IsDescriptorVar (exp->VAR_EXP.V)))) goto yyL1;
  {
# line 1005 "CheckComm.puma"
   if (! ((! IsIndShadowVariable (exp->VAR_EXP.V, home)))) goto yyL1;
  {
# line 1006 "CheckComm.puma"
   if (! ((IsLocalVarGlobal (var, home)))) goto yyL1;
  {
# line 1007 "CheckComm.puma"
   if (! ((IsFullParLoopVar (exp->VAR_EXP.V)))) goto yyL1;
  }
  }
  }
  }
  }
  }
  }
  }
   return true;
yyL1:;

# line 1010 "CheckComm.puma"
  {
# line 1012 "CheckComm.puma"
   if (! ((OuterLoops () > 0))) goto yyL2;
  {
# line 1013 "CheckComm.puma"
   if (! ((IsLocalVarWrite (var, home)))) goto yyL2;
  {
# line 1014 "CheckComm.puma"
   if (! ((IsLegalIndirect (exp->VAR_EXP.V, home)))) goto yyL2;
  {
# line 1015 "CheckComm.puma"
   if (! ((! IsLocalVarRead (exp->VAR_EXP.V, home)))) goto yyL2;
  {
# line 1016 "CheckComm.puma"
   if (! ((! IsIndShadowVariable (exp->VAR_EXP.V, home)))) goto yyL2;
  }
  }
  }
  }
  }
   return true;
yyL2:;

  }
  return false;
}

bool IsCopyOutAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, pvar home)
# else
(var, exp, home)
 register tTree var;
 register tTree exp;
 pvar home;
# endif
{
  if (exp->Kind == kVAR_EXP) {
# line 1027 "CheckComm.puma"
  {
# line 1029 "CheckComm.puma"
   if (! ((! IsParallelMasked ()))) goto yyL1;
  {
# line 1031 "CheckComm.puma"
   if (! ((IsLocalVarWrite (exp->VAR_EXP.V, home)))) goto yyL1;
  {
# line 1032 "CheckComm.puma"
   if (! ((! IsIndShadowVariable (var, home)))) goto yyL1;
  {
# line 1033 "CheckComm.puma"
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  }
  }
  }
  }
   return true;
yyL1:;

# line 1036 "CheckComm.puma"
  {
# line 1038 "CheckComm.puma"
   if (! ((OuterLoops () > 0))) goto yyL2;
  {
# line 1039 "CheckComm.puma"
   if (! ((IsLocalVarWrite (exp->VAR_EXP.V, home)))) goto yyL2;
  {
# line 1040 "CheckComm.puma"
   if (! ((! IsLocalVarWrite (var, home)))) goto yyL2;
  {
# line 1041 "CheckComm.puma"
   if (! ((! IsIndShadowVariable (var, home)))) goto yyL2;
  {
# line 1042 "CheckComm.puma"
   if (! ((IsLegalIndirect (var, home)))) goto yyL2;
  }
  }
  }
  }
  }
   return true;
yyL2:;

  }
  return false;
}

static bool IsLegalIndirect
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 1055 "CheckComm.puma"
  {
# line 1057 "CheckComm.puma"
   if (! ((LegalIndexExpression (var->INDEXED_VAR.IND_EXPS, home)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static bool LegalIndexExpression
# if defined __STDC__ | defined __cplusplus
(register tTree explist, pvar home)
# else
(explist, home)
 register tTree explist;
 pvar home;
# endif
{
  if (explist->Kind == kBTE_LIST) {
# line 1062 "CheckComm.puma"
  {
# line 1064 "CheckComm.puma"
   if (! ((AcceptedIndirectIndex (explist->BTE_LIST.Elem, home)))) goto yyL1;
  {
# line 1065 "CheckComm.puma"
   if (! ((LegalIndexExpression (explist->BTE_LIST.Next, home)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  if (explist->Kind == kBTE_EMPTY) {
# line 1068 "CheckComm.puma"
   return true;

  }
  return false;
}

static bool AcceptedIndirectIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index_exp, pvar home)
# else
(index_exp, home)
 register tTree index_exp;
 pvar home;
# endif
{
  if (index_exp->Kind == kVAR_EXP) {
# line 1082 "CheckComm.puma"
  {
# line 1084 "CheckComm.puma"
   if (! ((IsLocalVarWrite (index_exp->VAR_EXP.V, home)))) goto yyL1;
  }
   return true;
yyL1:;

  }
# line 1087 "CheckComm.puma"
  {
# line 1089 "CheckComm.puma"
   if (! ((TreeRank (index_exp) == 0))) goto yyL2;
  {
# line 1090 "CheckComm.puma"
   if (! ((IsParallelInvariant (index_exp)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  return false;
}

void BeginCheckComm ()
{
}

void CloseCheckComm ()
{
}
