# include "ChangeDefs.h"
# include "yyChangeDefs.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 53 "ChangeDefs.puma"


# include <string.h>

# include "Idents.h"
# include "StringMem.h"

# include "Objects.h"
# include "protocol.h"

# include "DefTable.h"
# include "TreeOps.h"
# include "Types.h"
# include "Rank.h"

# define MODULE "ChangeDefs"

/*********************************************************************
*                                                                    *
*  void attribute_error_protocol (char msg[], Object obj)            *
*                                                                    *
*  - special error message for illegal attribute                     *
*                                                                    *
*      SELECT attribute already set for VarObject A                  *
*      type attribute illegal for TemplateObject T                   *
*                                                                    *
*********************************************************************/

void attribute_error_protocol (msg, obj)

char msg[]; 
tObject obj;

{ char full_msg [256];
  char string   [60];
  char *kind_name;

  GetString (obj->Object.Ident, string);
  kind_name = Definitions_NodeName [obj->Kind];
 
  sprintf (full_msg, "%s %s %s", msg, kind_name, string);
  error_protocol (full_msg);
  obj_protocol ("object is : ", obj);

} /* attribute_error_protocol */
   


static void yyExit () { Exit (1); }

void (* ChangeDefs_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ChangeDefs, routine %s failed\n", yyFunction);
 ChangeDefs_Exit ();
}

tDefinitions GetLocalVarEntity ARGS((tIdent name, int pos, tDefinitions unit));
static bool OwnObject ARGS((tDefinitions obj, tDefinitions unit));
void MakeObjType ARGS((tTree type, tDefinitions obj));
void MakeObjParameter ARGS((tTree val, tDefinitions obj));
void MakeObjDimension ARGS((tTree indexes, tDefinitions obj));
void MakeObjIntent ARGS((tDefinitions obj, int intent));
void MakeObjOptional ARGS((tDefinitions obj));
void MakeObjAllocatable ARGS((tDefinitions obj));
void MakeObjTarget ARGS((tDefinitions obj));
void MakeObjPointer ARGS((tDefinitions obj));
void MakeObjPrivate ARGS((tDefinitions obj));
void MakeObjPublic ARGS((tDefinitions obj));
void MakeObjShared ARGS((tDefinitions obj, int kind));
void MakeObjDynamic ARGS((tDefinitions obj));
void MakeObjTrace ARGS((tDefinitions obj));
void MakeObjTree ARGS((tDefinitions obj));
void MakeObjSelection ARGS((tDefinitions obj, tTree selection));
void MakeObjInherited ARGS((tDefinitions obj));
void MakeObjActive ARGS((tDefinitions obj));
void MakeObjLayout ARGS((tStringRef kind, tDefinitions obj));
void MakeObjPassBy ARGS((tStringRef kind, tDefinitions obj));
void MakeObjMapTo ARGS((tStringRef kind, tDefinitions obj));
void MakeObjCommon ARGS((tTree decl, tDefinitions obj));
void MakeObjSequential ARGS((tDefinitions v));
void MakeObjNoSequential ARGS((tDefinitions v));
void MakeObjSave ARGS((tDefinitions v));
static tDefinitions MakeNewRoutineObject ARGS((tTree decl, int kind, tDefinitions unit));
void MakeObjExternal ARGS((tDefinitions oldobj));
static tDefinitions MakeObjSubroutine ARGS((tDefinitions oldobj));
static tDefinitions MakeObjFunction ARGS((tDefinitions oldobj));
static bool UnUsedDummy ARGS((tDefinitions obj));
static tTree MakeProcDecl ARGS((tIdent name, int pos));
static tTree MakeFuncDecl ARGS((tIdent name, int pos, tTree type));
tDefinitions GetFuncObject ARGS((tIdent name, tDefinitions unit));
static bool IsValidFuncObject ARGS((tDefinitions obj));
tDefinitions GetProcObject ARGS((tIdent name, tDefinitions unit));
void SetExternalEntry ARGS((tDefinitions obj));
static tTree SetCompType ARGS((tDefinitions obj, tTree old_type, tTree new_type));
static tTree NewCompType ARGS((tTree type, tTree comp));

tDefinitions GetLocalVarEntity
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int pos, register tDefinitions unit)
# else
(name, pos, unit)
 register tIdent name;
 register int pos;
 register tDefinitions unit;
# endif
{
# line 109 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 111 "ChangeDefs.puma"

# line 113 "ChangeDefs.puma"
   Obj = GetLocalObject (name);
# line 115 "ChangeDefs.puma"
 if (Obj == NoObject)
 
       { Obj = MakeNewObject (mVAR_DECL (name, pos, mDUMMY_TYPE ()), unit);
         InsertEntry (Obj);
       }

      else if (!OwnObject (Obj, unit))

      { 

        error_protocol ("cannot define objects from other units");
        obj_protocol ("this is used object", Obj);
        failure_protocol ("ERROR", "ERROR", Obj->Object.decl);

      }

   
  }
  {
   return Obj;
  }
 }

}

static bool OwnObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions unit)
# else
(obj, unit)
 register tDefinitions obj;
 register tDefinitions unit;
# endif
{
# line 146 "ChangeDefs.puma"
  {
# line 148 "ChangeDefs.puma"
   if (! ((unit == NoObject))) goto yyL1;
  }
   return true;
yyL1:;

  if (obj->Kind == kFuncObject) {
# line 151 "ChangeDefs.puma"
  {
# line 154 "ChangeDefs.puma"
   if (! ((unit == obj))) goto yyL2;
  }
   return true;
yyL2:;

  }
# line 159 "ChangeDefs.puma"
  {
# line 161 "ChangeDefs.puma"
   if (! ((obj->Object.in == NoObject))) goto yyL3;
  {
# line 163 "ChangeDefs.puma"
   obj_error_protocol ("object in no unit defined", obj);
# line 165 "ChangeDefs.puma"
   failure_protocol (MODULE, "OwnObject", obj->Object.decl);
  }
  }
   return true;
yyL3:;

  if (obj->Object.in->Kind == kRaggedObject) {
# line 168 "ChangeDefs.puma"
  {
# line 170 "ChangeDefs.puma"
   if (! ((obj->Object.in->RaggedObject.in == unit))) goto yyL4;
  }
   return true;
yyL4:;

  }
# line 173 "ChangeDefs.puma"
  {
# line 175 "ChangeDefs.puma"
   if (! ((obj->Object.in == unit))) goto yyL5;
  }
   return true;
yyL5:;

  return false;
}

void MakeObjType
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tDefinitions obj)
# else
(type, obj)
 register tTree type;
 register tDefinitions obj;
# endif
{
  if (type->Kind == kARRAY_TYPE) {
# line 192 "ChangeDefs.puma"
  {
# line 194 "ChangeDefs.puma"
   MakeObjDimension (type->ARRAY_TYPE.ARRAY_INDEX_TYPES, obj);
# line 195 "ChangeDefs.puma"
   MakeObjType (type->ARRAY_TYPE.ARRAY_COMP_TYPE, obj);
  }
   return;

  }
  if (type->Kind == kDUMMY_TYPE) {
# line 198 "ChangeDefs.puma"
   return;

  }
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
# line 201 "ChangeDefs.puma"
  {
# line 209 "ChangeDefs.puma"
 obj->VarObject.decl->VAR_DECL.VAL = SetCompType (obj, obj->VarObject.decl->VAR_DECL.VAL, type); 
  }
   return;

  }
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 212 "ChangeDefs.puma"
  {
# line 214 "ChangeDefs.puma"
 obj->VarObject.decl->VAR_PARAM_DECL.VAL = SetCompType (obj, obj->VarObject.decl->VAR_PARAM_DECL.VAL, type); 
  }
   return;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 217 "ChangeDefs.puma"
  {
# line 219 "ChangeDefs.puma"
 obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE = SetCompType (obj, obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE, type); 
  }
   return;

  }
  }
  if (obj->Kind == kExternalObject) {
  if (obj->ExternalObject.decl->Kind == kEXTERNAL_DECL) {
# line 222 "ChangeDefs.puma"
  {
# line 226 "ChangeDefs.puma"
 obj->ExternalObject.decl = MakeFuncDecl (obj->ExternalObject.Ident, obj->ExternalObject.decl->EXTERNAL_DECL.Line, type);
      obj->Kind = kFuncObject;
    
  }
   return;

  }
  }
# line 231 "ChangeDefs.puma"
  {
# line 233 "ChangeDefs.puma"
   attribute_error_protocol ("type attribute illegal for", obj);
  }
   return;

;
}

void MakeObjParameter
# if defined __STDC__ | defined __cplusplus
(register tTree val, register tDefinitions obj)
# else
(val, obj)
 register tTree val;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 246 "ChangeDefs.puma"
  {
# line 249 "ChangeDefs.puma"
   obj->VarObject.Kind = mVarParameter (val);
  }
   return;

  }
  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 252 "ChangeDefs.puma"
  {
# line 254 "ChangeDefs.puma"
   attribute_error_protocol ("PARAMETER not allowed for dummy", obj);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarCommon) {
# line 257 "ChangeDefs.puma"
  {
# line 259 "ChangeDefs.puma"
   attribute_error_protocol ("PARAMETER not allowed for COMMON", obj);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarParameter) {
# line 262 "ChangeDefs.puma"
  {
# line 264 "ChangeDefs.puma"
   attribute_error_protocol ("PARAMETER used twice for", obj);
  }
   return;

  }
  }
# line 267 "ChangeDefs.puma"
  {
# line 269 "ChangeDefs.puma"
   attribute_error_protocol ("PARAMETER not allowed for", obj);
  }
   return;

;
}

void MakeObjDimension
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register tDefinitions obj)
# else
(indexes, obj)
 register tTree indexes;
 register tDefinitions obj;
# endif
{
# line 280 "ChangeDefs.puma"
  {
# line 282 "ChangeDefs.puma"
   if (! ((TreeListLength (indexes) > MAX_DIMENSIONS))) goto yyL1;
  {
# line 283 "ChangeDefs.puma"
   error_protocol ("too many formal dimensions");
  }
  }
   return;
yyL1:;

# line 286 "ChangeDefs.puma"
  {
# line 288 "ChangeDefs.puma"
   if (! ((IsArrayType (GetObjectType (obj))))) goto yyL2;
  {
# line 290 "ChangeDefs.puma"
   attribute_error_protocol ("DIMENSION already defined for", obj);
  }
  }
   return;
yyL2:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
# line 293 "ChangeDefs.puma"
  {
# line 295 "ChangeDefs.puma"
 obj->VarObject.decl->VAR_DECL.VAL = mARRAY_TYPE (indexes, obj->VarObject.decl->VAR_DECL.VAL); 
  }
   return;

  }
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 298 "ChangeDefs.puma"
  {
# line 300 "ChangeDefs.puma"
 obj->VarObject.decl->VAR_PARAM_DECL.VAL = mARRAY_TYPE (indexes, obj->VarObject.decl->VAR_PARAM_DECL.VAL); 
  }
   return;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 303 "ChangeDefs.puma"
  {
# line 305 "ChangeDefs.puma"
 obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE = mARRAY_TYPE (indexes, obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE); 
  }
   return;

  }
  }
# line 308 "ChangeDefs.puma"
  {
# line 310 "ChangeDefs.puma"
   attribute_error_protocol ("DIMENSION illegal for", obj);
  }
   return;

;
}

void MakeObjIntent
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int intent)
# else
(obj, intent)
 register tDefinitions obj;
 register int intent;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 321 "ChangeDefs.puma"
  {
# line 323 "ChangeDefs.puma"
   if (! ((obj->VarObject.Kind->VarDummy.Intent != IntentNo))) goto yyL1;
  {
# line 325 "ChangeDefs.puma"
   attribute_error_protocol ("INTENT attribute already set for", obj);
  }
  }
   return;
yyL1:;

# line 328 "ChangeDefs.puma"
  {
# line 330 "ChangeDefs.puma"
 obj->VarObject.Kind->VarDummy.Intent = intent;
  }
   return;

  }
  }
# line 333 "ChangeDefs.puma"
  {
# line 335 "ChangeDefs.puma"
   attribute_error_protocol ("INTENT attribute illegal for", obj);
  }
   return;

;
}

void MakeObjOptional
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 346 "ChangeDefs.puma"
  {
# line 348 "ChangeDefs.puma"
   if (! ((obj->VarObject.Kind->VarDummy.optional))) goto yyL1;
  {
# line 350 "ChangeDefs.puma"
   attribute_error_protocol ("OPTIONAL already set for", obj);
  }
  }
   return;
yyL1:;

# line 353 "ChangeDefs.puma"
  {
# line 355 "ChangeDefs.puma"
 obj->VarObject.Kind->VarDummy.optional = true; 
  }
   return;

  }
  }
# line 358 "ChangeDefs.puma"
  {
# line 360 "ChangeDefs.puma"
   attribute_error_protocol ("OPTIONAL illegal for", obj);
  }
   return;

;
}

void MakeObjAllocatable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 371 "ChangeDefs.puma"
  {
# line 373 "ChangeDefs.puma"
   if (! ((obj->VarObject.Kind->VarLocal.dynamic == arr_allocatable))) goto yyL1;
  {
# line 374 "ChangeDefs.puma"
   error_protocol ("object has already the ALLOCATABLE attribute");
  }
  }
   return;
yyL1:;

# line 377 "ChangeDefs.puma"
  {
# line 381 "ChangeDefs.puma"
 obj->VarObject.Kind->VarLocal.dynamic = arr_allocatable; 
  }
   return;

  }
  }
  if (obj->Kind == kTemplateObject) {
# line 384 "ChangeDefs.puma"
   return;

  }
# line 389 "ChangeDefs.puma"
  {
# line 390 "ChangeDefs.puma"
   error_protocol ("ALLOCATABLE illegal for this entity");
# line 391 "ChangeDefs.puma"
   obj_protocol ("this entity can not be allocatable", obj);
  }
   return;

;
}

void MakeObjTarget
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 402 "ChangeDefs.puma"
  {
# line 404 "ChangeDefs.puma"
   if (! ((obj->VarObject.Kind->VarDummy.target))) goto yyL1;
  {
# line 405 "ChangeDefs.puma"
   error_protocol ("object has already TARGET attribute");
  }
  }
   return;
yyL1:;

# line 408 "ChangeDefs.puma"
  {
# line 410 "ChangeDefs.puma"
 obj->VarObject.Kind->VarDummy.target = true; 
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 413 "ChangeDefs.puma"
  {
# line 415 "ChangeDefs.puma"
   if (! ((obj->VarObject.Kind->VarLocal.target))) goto yyL3;
  {
# line 416 "ChangeDefs.puma"
   error_protocol ("object has already target attribute");
  }
  }
   return;
yyL3:;

# line 419 "ChangeDefs.puma"
  {
# line 421 "ChangeDefs.puma"
 obj->VarObject.Kind->VarLocal.target = true; 
  }
   return;

  }
  }
# line 424 "ChangeDefs.puma"
  {
# line 425 "ChangeDefs.puma"
   error_protocol ("TARGET attribute illegal for this entity");
# line 426 "ChangeDefs.puma"
   obj_protocol ("this entity can not be a target", obj);
  }
   return;

;
}

void MakeObjPointer
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 437 "ChangeDefs.puma"
  {
# line 439 "ChangeDefs.puma"
   if (! ((IsPointerType (GetObjectType (obj))))) goto yyL1;
  {
# line 440 "ChangeDefs.puma"
   error_protocol ("entity has already pointer attribute");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
# line 443 "ChangeDefs.puma"
  {
# line 445 "ChangeDefs.puma"
 obj->VarObject.decl->VAR_DECL.VAL = mPOINTER_TYPE (obj->VarObject.decl->VAR_DECL.VAL); 
  }
   return;

  }
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 448 "ChangeDefs.puma"
  {
# line 450 "ChangeDefs.puma"
 obj->VarObject.decl->VAR_PARAM_DECL.VAL = mPOINTER_TYPE (obj->VarObject.decl->VAR_PARAM_DECL.VAL); 
  }
   return;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 453 "ChangeDefs.puma"
  {
# line 455 "ChangeDefs.puma"
 obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE = mPOINTER_TYPE (obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE); 
  }
   return;

  }
  }
# line 458 "ChangeDefs.puma"
  {
# line 459 "ChangeDefs.puma"
   error_protocol ("illegal pointer statement");
# line 460 "ChangeDefs.puma"
   obj_protocol ("this object cannot be a pointer", obj);
  }
   return;

;
}

void MakeObjPrivate
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 471 "ChangeDefs.puma"
  {
# line 473 "ChangeDefs.puma"
   if (! ((obj->Object.private != Default))) goto yyL1;
  {
# line 475 "ChangeDefs.puma"
   error_protocol ("object has already been defined PUBLIC/PRIVATE");
  }
  }
   return;
yyL1:;

# line 478 "ChangeDefs.puma"
  {
# line 480 "ChangeDefs.puma"
   obj->Object.private = Private;
  }
   return;

;
}

void MakeObjPublic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 485 "ChangeDefs.puma"
  {
# line 487 "ChangeDefs.puma"
   if (! ((obj->Object.private != Default))) goto yyL1;
  {
# line 489 "ChangeDefs.puma"
   error_protocol ("object has already been defined PUBLIC/PRIVATE");
  }
  }
   return;
yyL1:;

# line 492 "ChangeDefs.puma"
  {
# line 494 "ChangeDefs.puma"
   obj->Object.private = Public;
  }
   return;

;
}

void MakeObjShared
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int kind)
# else
(obj, kind)
 register tDefinitions obj;
 register int kind;
# endif
{
  if (obj->Kind == kVarObject) {
# line 508 "ChangeDefs.puma"
  {
# line 509 "ChangeDefs.puma"
   if (! ((obj->VarObject.Dist->Distribution.shared))) goto yyL1;
  {
# line 510 "ChangeDefs.puma"
   error_protocol ("object is already SHARED");
# line 511 "ChangeDefs.puma"
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

# line 514 "ChangeDefs.puma"
  {
# line 515 "ChangeDefs.puma"
 obj->VarObject.Dist->Distribution.shared = kind; 
  }
   return;

  }
# line 518 "ChangeDefs.puma"
  {
# line 519 "ChangeDefs.puma"
   error_protocol ("object cannot be shared");
# line 520 "ChangeDefs.puma"
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 533 "ChangeDefs.puma"
  {
# line 535 "ChangeDefs.puma"
   if (! ((obj->VarObject.Dist->Distribution.dynamic))) goto yyL1;
  {
# line 536 "ChangeDefs.puma"
   error_protocol ("object is already DYNAMIC");
# line 537 "ChangeDefs.puma"
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

# line 540 "ChangeDefs.puma"
  {
# line 542 "ChangeDefs.puma"
 obj->VarObject.Dist->Distribution.dynamic = 1; 
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
# line 545 "ChangeDefs.puma"
  {
# line 547 "ChangeDefs.puma"
   if (! ((obj->TemplateObject.Dist->Distribution.dynamic))) goto yyL3;
  {
# line 548 "ChangeDefs.puma"
   error_protocol ("TEMPLATE is already DYNAMIC");
# line 549 "ChangeDefs.puma"
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL3:;

# line 552 "ChangeDefs.puma"
  {
# line 554 "ChangeDefs.puma"
 obj->TemplateObject.Dist->Distribution.dynamic = 1; 
  }
   return;

  }
# line 557 "ChangeDefs.puma"
  {
# line 558 "ChangeDefs.puma"
   error_protocol ("object cannot be DYNAMIC");
# line 559 "ChangeDefs.puma"
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjTrace
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 570 "ChangeDefs.puma"
  {
# line 572 "ChangeDefs.puma"
   if (! ((obj->VarObject.trace))) goto yyL1;
  {
# line 573 "ChangeDefs.puma"
   error_protocol ("object has already TRACE attribute");
# line 574 "ChangeDefs.puma"
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

# line 577 "ChangeDefs.puma"
  {
# line 578 "ChangeDefs.puma"
 obj->VarObject.trace = 1; 
  }
   return;

  }
# line 581 "ChangeDefs.puma"
  {
# line 582 "ChangeDefs.puma"
   error_protocol ("object cannot be TRACEd");
# line 583 "ChangeDefs.puma"
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjTree
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 594 "ChangeDefs.puma"
  {
# line 595 "ChangeDefs.puma"
   if (! ((obj->VarObject.tree))) goto yyL1;
  {
# line 596 "ChangeDefs.puma"
   error_protocol ("object has already TREE attribute");
# line 597 "ChangeDefs.puma"
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

# line 600 "ChangeDefs.puma"
  {
# line 601 "ChangeDefs.puma"
 obj->VarObject.tree = 1; 
  }
   return;

  }
# line 604 "ChangeDefs.puma"
  {
# line 605 "ChangeDefs.puma"
   error_protocol ("object cannot have TREE attribute");
# line 606 "ChangeDefs.puma"
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjSelection
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree selection)
# else
(obj, selection)
 register tDefinitions obj;
 register tTree selection;
# endif
{
  if (obj->Kind == kVarObject) {
# line 622 "ChangeDefs.puma"
  {
# line 624 "ChangeDefs.puma"
   if (! ((obj->VarObject.select != NoTree))) goto yyL1;
  {
# line 626 "ChangeDefs.puma"
   attribute_error_protocol ("SELECT attribute already set for", obj);
  }
  }
   return;
yyL1:;

# line 636 "ChangeDefs.puma"
  {
# line 640 "ChangeDefs.puma"
 if (VarRank (obj) != TreeListLength (selection))

        attribute_error_protocol ("SELECT mismatches dimensions for", obj);

      else

        obj->VarObject.select = selection; 
   
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
# line 629 "ChangeDefs.puma"
  {
# line 631 "ChangeDefs.puma"
   if (! ((obj->TemplateObject.select != NoTree))) goto yyL2;
  {
# line 633 "ChangeDefs.puma"
   attribute_error_protocol ("SELECT attribute already set for", obj);
  }
  }
   return;
yyL2:;

# line 650 "ChangeDefs.puma"
  {
# line 654 "ChangeDefs.puma"
 if (VarRank (obj) != TreeListLength (selection))

        error_protocol ("SELECT mismatches dimensions");

      else

        obj->TemplateObject.select = selection; 
   
  }
   return;

  }
# line 664 "ChangeDefs.puma"
  {
# line 666 "ChangeDefs.puma"
   attribute_error_protocol ("SELECT attribute illegal for", obj);
  }
   return;

;
}

void MakeObjInherited
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 677 "ChangeDefs.puma"
  {
# line 678 "ChangeDefs.puma"
   if (! ((obj->VarObject.Dist->Distribution.inherited))) goto yyL1;
  {
# line 679 "ChangeDefs.puma"
   error_protocol ("object is already INHERITED");
# line 680 "ChangeDefs.puma"
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 683 "ChangeDefs.puma"
  {
# line 686 "ChangeDefs.puma"
 obj->VarObject.Dist->Distribution.inherited = 1; 
  }
   return;

  }
  }
# line 689 "ChangeDefs.puma"
  {
# line 690 "ChangeDefs.puma"
   error_protocol ("only dummy var arguments can be INHERITED");
# line 691 "ChangeDefs.puma"
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjActive
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kTopologyObject) {
# line 702 "ChangeDefs.puma"
  {
# line 704 "ChangeDefs.puma"
   if (! ((obj->TopologyObject.active))) goto yyL1;
  {
# line 705 "ChangeDefs.puma"
   error_protocol ("object is already ACITVE");
# line 706 "ChangeDefs.puma"
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

# line 709 "ChangeDefs.puma"
  {
# line 711 "ChangeDefs.puma"
 obj->TopologyObject.active = 1; 
  }
   return;

  }
# line 714 "ChangeDefs.puma"
  {
# line 715 "ChangeDefs.puma"
   error_protocol ("only processor arrangement can be ACTIVE");
# line 716 "ChangeDefs.puma"
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjLayout
# if defined __STDC__ | defined __cplusplus
(register tStringRef kind, register tDefinitions obj)
# else
(kind, obj)
 register tStringRef kind;
 register tDefinitions obj;
# endif
{
# line 727 "ChangeDefs.puma"

char str_layout[20];
char msg[50];

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 732 "ChangeDefs.puma"
  {
# line 734 "ChangeDefs.puma"
   if (! ((obj->VarObject.Kind->VarDummy.layout))) goto yyL1;
  {
# line 736 "ChangeDefs.puma"
   error_protocol ("LAYOUT already set for this dummy argument");
# line 737 "ChangeDefs.puma"
   obj_protocol ("dummy is", obj);
  }
  }
   return;
yyL1:;

# line 740 "ChangeDefs.puma"
 {
  bool is_f77;
  {
# line 742 "ChangeDefs.puma"

# line 744 "ChangeDefs.puma"
   StGetString (kind, str_layout);
# line 746 "ChangeDefs.puma"
 if (strcmp (str_layout, "HPF_ARRAY") == 0)

        { is_f77 = false;

          obj->VarObject.Kind->VarDummy.layout = GetLayout (is_f77, GetCurrentModel ());
        }
           
      else if (strcmp (str_layout, "F77_ARRAY") == 0)

        { is_f77 = true;

          obj->VarObject.Kind->VarDummy.layout = GetLayout (is_f77, GetCurrentModel ());
        }
           
      else 

        { sprintf (msg, "%s is unknown layout", str_layout);
          error_protocol (msg);
        }
   
  }
   return;
 }

  }
  }
# line 768 "ChangeDefs.puma"
  {
# line 770 "ChangeDefs.puma"
   error_protocol ("LAYOUT illegal for this entity");
# line 771 "ChangeDefs.puma"
   obj_protocol ("this object can not have a layout attribute", obj);
  }
   return;

;
}

void MakeObjPassBy
# if defined __STDC__ | defined __cplusplus
(register tStringRef kind, register tDefinitions obj)
# else
(kind, obj)
 register tStringRef kind;
 register tDefinitions obj;
# endif
{
# line 782 "ChangeDefs.puma"

char str_pass_by [20];

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 786 "ChangeDefs.puma"
  {
# line 788 "ChangeDefs.puma"
   StGetString (kind, str_pass_by);
# line 790 "ChangeDefs.puma"
 if (strcmp (str_pass_by, "*") == 0)
        obj->VarObject.Kind->VarDummy.pass_by = kDATA_PASS_BY;
      else if (strcmp (str_pass_by, "HPF_HANDLE") == 0)
        obj->VarObject.Kind->VarDummy.pass_by = kHPF_HANDLE_PASS_BY;
      else 
        obj->VarObject.Kind->VarDummy.pass_by = kDEFAULT_PASS_BY;
   
  }
   return;

  }
  }
# line 799 "ChangeDefs.puma"
  {
# line 801 "ChangeDefs.puma"
   error_protocol ("PASS_BY illegal for this entity");
# line 802 "ChangeDefs.puma"
   obj_protocol ("this object can not have a PASS_BY attribute", obj);
  }
   return;

;
}

void MakeObjMapTo
# if defined __STDC__ | defined __cplusplus
(register tStringRef kind, register tDefinitions obj)
# else
(kind, obj)
 register tStringRef kind;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 813 "ChangeDefs.puma"
  {
# line 815 "ChangeDefs.puma"
 obj->VarObject.Kind->VarDummy.map_to = 1; 
  }
   return;

  }
  }
# line 818 "ChangeDefs.puma"
  {
# line 820 "ChangeDefs.puma"
   error_protocol ("MAP_TO illegal for this entity");
# line 821 "ChangeDefs.puma"
   obj_protocol ("this object can not have a MAP_TO attribute", obj);
  }
   return;

;
}

void MakeObjCommon
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions obj)
# else
(decl, obj)
 register tTree decl;
 register tDefinitions obj;
# endif
{
# line 832 "ChangeDefs.puma"
 char string [100], msg[150]; 
# line 834 "ChangeDefs.puma"
  {
# line 836 "ChangeDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 837 "ChangeDefs.puma"
   error_protocol ("no object for item in COMMON");
  }
  }
   return;
yyL1:;

  if (decl->Kind == kCOMMON_DECL) {
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 840 "ChangeDefs.puma"
  {
# line 843 "ChangeDefs.puma"
   GetString (obj->VarObject.Ident, string);
# line 844 "ChangeDefs.puma"
 if (obj->VarObject.Kind->VarLocal.save != 0)
        { obj_error_protocol ("Save Variabe not in COMMON : ", obj);
          tree_protocol ("Declaration is : ", decl);
        }
      if (obj->VarObject.Kind->VarLocal.dynamic != 0)
        { obj_error_protocol ("Dynamic Variabe not in COMMON : ", obj);
          tree_protocol ("Declaration is : ", decl);
        }
    
# line 853 "ChangeDefs.puma"
   obj->VarObject.Kind = mVarCommon (decl->COMMON_DECL.Ident, NoObject);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 856 "ChangeDefs.puma"
  {
# line 859 "ChangeDefs.puma"
   obj_error_protocol ("Dummy variable must not be in COMMON: ", obj);
# line 860 "ChangeDefs.puma"
   tree_protocol ("COMMON is : ", decl);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarCommon) {
# line 863 "ChangeDefs.puma"
  {
# line 866 "ChangeDefs.puma"
   GetString (obj->VarObject.Kind->VarCommon.Block, string);
# line 867 "ChangeDefs.puma"
   sprintf (msg, "Variable is already in COMMON %s : ", string);
# line 868 "ChangeDefs.puma"
   tree_error_protocol (msg, obj->VarObject.decl);
# line 869 "ChangeDefs.puma"
   tree_protocol ("New COMMON is : ", decl);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarParameter) {
# line 872 "ChangeDefs.puma"
  {
# line 875 "ChangeDefs.puma"
   error_protocol ("parameter object cannot be in COMMON");
# line 876 "ChangeDefs.puma"
   tree_error_protocol ("this is old definition : ", obj->VarObject.decl);
  }
   return;

  }
  }
  }
# line 879 "ChangeDefs.puma"
  {
# line 880 "ChangeDefs.puma"
   obj_error_protocol ("Object", obj);
# line 881 "ChangeDefs.puma"
   tree_protocol ("object must not be in this COMMON", decl);
  }
   return;

;
}

void MakeObjSequential
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
# line 892 "ChangeDefs.puma"
  {
# line 894 "ChangeDefs.puma"
 if (v->VarObject.sequence == IsNoSequence)
        error_protocol ("object has already NO SEQUENCE association");
      else if (v->VarObject.sequence == IsSequence)
        error_protocol ("object has already SEQUENCE association");
      else
        v->VarObject.sequence = IsSequence;   
   
  }
   return;

  }
  if (v->Kind == kCommonObject) {
# line 903 "ChangeDefs.puma"
  {
# line 905 "ChangeDefs.puma"
 if (v->CommonObject.sequence == IsNoSequence)
        error_protocol ("COMMON has already NO SEQUENCE association");
      else if (v->CommonObject.sequence == IsSequence)
        error_protocol ("COMMON has already SEQUENCE association");
      else
        v->CommonObject.sequence = IsSequence;   
   
  }
   return;

  }
# line 914 "ChangeDefs.puma"
  {
# line 915 "ChangeDefs.puma"
   error_protocol ("SEQUENCE not supported for this object");
  }
   return;

;
}

void MakeObjNoSequential
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
# line 926 "ChangeDefs.puma"
  {
# line 928 "ChangeDefs.puma"
 if (v->VarObject.sequence == IsNoSequence)
        error_protocol ("object has already NO SEQUENCE association");
      else if (v->VarObject.sequence == IsSequence)
        error_protocol ("object has already SEQUENCE association");
      else
        v->VarObject.sequence = IsNoSequence;   
   
  }
   return;

  }
  if (v->Kind == kCommonObject) {
# line 937 "ChangeDefs.puma"
  {
# line 939 "ChangeDefs.puma"
 if (v->CommonObject.sequence == IsNoSequence)
        error_protocol ("COMMON has already NO SEQUENCE association");
      else if (v->CommonObject.sequence == IsSequence)
        error_protocol ("COMMON has already SEQUENCE association");
      else
        v->CommonObject.sequence = IsNoSequence;   
   
  }
   return;

  }
# line 948 "ChangeDefs.puma"
  {
# line 949 "ChangeDefs.puma"
   error_protocol ("NO SEQUENCE not supported for this object");
  }
   return;

;
}

void MakeObjSave
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
# line 960 "ChangeDefs.puma"
  {
# line 962 "ChangeDefs.puma"
 if (v->VarObject.Kind->VarLocal.save)
       error_protocol ("Local Variable is already save");
     v->VarObject.Kind->VarLocal.save = true;
   
  }
   return;

  }
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 968 "ChangeDefs.puma"
  {
# line 970 "ChangeDefs.puma"
   error_protocol ("dummy argument cannot be save");
  }
   return;

  }
  if (v->VarObject.Kind->Kind == kVarParameter) {
# line 973 "ChangeDefs.puma"
  {
# line 974 "ChangeDefs.puma"
   error_protocol ("parameter cannot be save");
  }
   return;

  }
  if (v->VarObject.Kind->Kind == kVarCommon) {
# line 977 "ChangeDefs.puma"
  {
# line 978 "ChangeDefs.puma"
   error_protocol ("only a whole common block can be save");
  }
   return;

  }
  }
# line 981 "ChangeDefs.puma"
  {
# line 982 "ChangeDefs.puma"
   error_protocol ("entity cannot be save");
  }
   return;

;
}

static tDefinitions MakeNewRoutineObject
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register int kind, register tDefinitions unit)
# else
(decl, kind, unit)
 register tTree decl;
 register int kind;
 register tDefinitions unit;
# endif
{
  if (decl->Kind == kFUNC_DECL) {
# line 995 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 997 "ChangeDefs.puma"

# line 999 "ChangeDefs.puma"
 Obj = mFuncObject (decl->FUNC_DECL.Ident, decl, Default, NoObject,
                         kind, mENTRY_EMPTY ());
      SetExternalEntry (Obj);
    
  }
  {
   return Obj;
  }
 }

  }
  if (decl->Kind == kEXTERNAL_DECL) {
# line 1007 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1009 "ChangeDefs.puma"

# line 1011 "ChangeDefs.puma"
 Obj = mExternalObject (decl->EXTERNAL_DECL.Ident, decl, Default, NoObject,
                             kind, mENTRY_EMPTY ());
      SetExternalEntry (Obj);
    
  }
  {
   return Obj;
  }
 }

  }
  if (decl->Kind == kPROC_DECL) {
# line 1019 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1021 "ChangeDefs.puma"

# line 1023 "ChangeDefs.puma"
 Obj = mProcObject (decl->PROC_DECL.Ident, decl, Default, NoObject,
                         kind, mENTRY_EMPTY ());
      SetExternalEntry (Obj);
    
  }
  {
   return Obj;
  }
 }

  }
# line 1031 "ChangeDefs.puma"
  {
# line 1032 "ChangeDefs.puma"
   failure_protocol (MODULE, "MakeNewRoutineObject", decl);
  }
   return NoObject;

}

void MakeObjExternal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions oldobj)
# else
(oldobj)
 register tDefinitions oldobj;
# endif
{
  if (oldobj->Kind == kVarObject) {
  if (oldobj->VarObject.decl->Kind == kVAR_DECL) {
  if (oldobj->VarObject.Kind->Kind == kVarLocal) {
# line 1045 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1048 "ChangeDefs.puma"

# line 1052 "ChangeDefs.puma"
   Obj = MakeNewRoutineObject (MakeFuncDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_DECL.Line, oldobj->VarObject.decl->VAR_DECL.VAL), UserRoutine, oldobj->VarObject.in);
# line 1057 "ChangeDefs.puma"
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
   return;
 }

  }
  }
  if (oldobj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (oldobj->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kDUMMY_TYPE) {
# line 1069 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1072 "ChangeDefs.puma"

# line 1074 "ChangeDefs.puma"
   Obj = MakeNewRoutineObject (mEXTERNAL_DECL (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_PARAM_DECL.Line), DummyRoutine, oldobj->VarObject.in);
# line 1077 "ChangeDefs.puma"
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
   return;
 }

  }
# line 1088 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1090 "ChangeDefs.puma"

# line 1094 "ChangeDefs.puma"
   Obj = MakeNewRoutineObject (MakeFuncDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_PARAM_DECL.Line, oldobj->VarObject.decl->VAR_PARAM_DECL.VAL), DummyRoutine, oldobj->VarObject.in);
# line 1097 "ChangeDefs.puma"
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
   return;
 }

  }
  }
# line 1100 "ChangeDefs.puma"
  {
# line 1101 "ChangeDefs.puma"
   error_protocol ("this entity cannot be external");
  }
   return;

;
}

static tDefinitions MakeObjSubroutine
# if defined __STDC__ | defined __cplusplus
(register tDefinitions oldobj)
# else
(oldobj)
 register tDefinitions oldobj;
# endif
{
  if (oldobj->Kind == kProcObject) {
  if (oldobj->ProcObject.decl->Kind == kPROGRAM_DECL) {
# line 1115 "ChangeDefs.puma"
  {
# line 1117 "ChangeDefs.puma"
   error_protocol ("cannot call main program");
# line 1118 "ChangeDefs.puma"
   obj_protocol ("object for main program is ", oldobj);
  }
   return oldobj;

  }
# line 1122 "ChangeDefs.puma"
   return oldobj;

  }
  if (oldobj->Kind == kGenericObject) {
# line 1127 "ChangeDefs.puma"
   return oldobj;

  }
  if (oldobj->Kind == kExternalObject) {
  if (oldobj->ExternalObject.decl->Kind == kEXTERNAL_DECL) {
# line 1142 "ChangeDefs.puma"
  {
# line 1146 "ChangeDefs.puma"
 oldobj->ExternalObject.decl = MakeProcDecl (oldobj->ExternalObject.Ident, oldobj->ExternalObject.decl->EXTERNAL_DECL.Line); 
      oldobj->Kind = kProcObject; 
    
  }
   return oldobj;

  }
  }
  if (oldobj->Kind == kVarObject) {
  if (oldobj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (oldobj->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kDUMMY_TYPE) {
# line 1160 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1163 "ChangeDefs.puma"
   if (! ((UnUsedDummy (oldobj)))) goto yyL5;
  {
# line 1165 "ChangeDefs.puma"

# line 1167 "ChangeDefs.puma"
   Obj = MakeNewRoutineObject (MakeProcDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_PARAM_DECL.Line), DummyRoutine, oldobj->VarObject.in);
# line 1170 "ChangeDefs.puma"
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
  }
  {
   return Obj;
  }
 }
yyL5:;

  }
  }
  }
# line 1174 "ChangeDefs.puma"
  {
# line 1175 "ChangeDefs.puma"
   error_protocol ("name is not a subroutine");
# line 1176 "ChangeDefs.puma"
   obj_protocol ("object is ", oldobj);
  }
   return oldobj;

}

static tDefinitions MakeObjFunction
# if defined __STDC__ | defined __cplusplus
(register tDefinitions oldobj)
# else
(oldobj)
 register tDefinitions oldobj;
# endif
{
  if (oldobj->Kind == kFuncObject) {
# line 1191 "ChangeDefs.puma"
   return oldobj;

  }
  if (oldobj->Kind == kGenericObject) {
# line 1198 "ChangeDefs.puma"
   return oldobj;

  }
  if (oldobj->Kind == kExternalObject) {
  if (oldobj->ExternalObject.decl->Kind == kEXTERNAL_DECL) {
# line 1205 "ChangeDefs.puma"
  {
# line 1209 "ChangeDefs.puma"
 oldobj->ExternalObject.decl = MakeFuncDecl (oldobj->ExternalObject.Ident, oldobj->ExternalObject.decl->EXTERNAL_DECL.Line, mDUMMY_TYPE());
      oldobj->Kind = kFuncObject; 
    
  }
   return oldobj;

  }
  }
  if (oldobj->Kind == kVarObject) {
  if (oldobj->VarObject.decl->Kind == kVAR_DECL) {
  if (oldobj->VarObject.Kind->Kind == kVarLocal) {
# line 1221 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1225 "ChangeDefs.puma"

# line 1227 "ChangeDefs.puma"
   Obj = MakeNewRoutineObject (MakeFuncDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_DECL.Line, oldobj->VarObject.decl->VAR_DECL.VAL), UserRoutine, oldobj->VarObject.in);
# line 1232 "ChangeDefs.puma"
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
  {
   return Obj;
  }
 }

  }
  }
  if (oldobj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (oldobj->VarObject.Kind->Kind == kVarDummy) {
# line 1245 "ChangeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1249 "ChangeDefs.puma"
   if (! ((UnUsedDummy (oldobj)))) goto yyL5;
  {
# line 1251 "ChangeDefs.puma"

# line 1253 "ChangeDefs.puma"
   Obj = MakeNewRoutineObject (MakeFuncDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_PARAM_DECL.Line, oldobj->VarObject.decl->VAR_PARAM_DECL.VAL), DummyRoutine, oldobj->VarObject.in);
# line 1256 "ChangeDefs.puma"
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
  }
  {
   return Obj;
  }
 }
yyL5:;

  }
  }
  }
# line 1261 "ChangeDefs.puma"
  {
# line 1262 "ChangeDefs.puma"
   error_protocol ("name is not a function");
# line 1263 "ChangeDefs.puma"
   obj_protocol ("object is ", oldobj);
  }
   return oldobj;

}

static bool UnUsedDummy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 1278 "ChangeDefs.puma"
  {
# line 1281 "ChangeDefs.puma"
   if (! ((obj->VarObject.uses->VarUse.ArrayUse == 0))) goto yyL1;
  {
# line 1282 "ChangeDefs.puma"
   if (! ((obj->VarObject.uses->VarUse.ReadUse == 0))) goto yyL1;
  {
# line 1283 "ChangeDefs.puma"
   if (! ((obj->VarObject.uses->VarUse.WriteUse == 0))) goto yyL1;
  }
  }
  }
   return true;
yyL1:;

  }
  }
  return false;
}

static tTree MakeProcDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int pos)
# else
(name, pos)
 register tIdent name;
 register int pos;
# endif
{
# line 1295 "ChangeDefs.puma"
 {
  tTree decl;
  {
# line 1297 "ChangeDefs.puma"

# line 1298 "ChangeDefs.puma"
   decl = mPROC_DECL (name, pos, mDECL_EMPTY (), NoTree);
# line 1300 "ChangeDefs.puma"
   decl->PROC_DECL.IsPure = false;
# line 1301 "ChangeDefs.puma"
   decl->PROC_DECL.IsRecursive = false;
# line 1302 "ChangeDefs.puma"
   decl->PROC_DECL.HPFExtrinsic = DefaultId ();
  }
  {
   return decl;
  }
 }

}

static tTree MakeFuncDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int pos, register tTree type)
# else
(name, pos, type)
 register tIdent name;
 register int pos;
 register tTree type;
# endif
{
# line 1309 "ChangeDefs.puma"
 {
  tTree decl;
  {
# line 1311 "ChangeDefs.puma"

# line 1312 "ChangeDefs.puma"
   decl = mFUNC_DECL (name, pos, mDECL_EMPTY (), NoTree, type, DefaultId ());
# line 1314 "ChangeDefs.puma"
   decl->FUNC_DECL.IsPure = false;
# line 1315 "ChangeDefs.puma"
   decl->FUNC_DECL.IsRecursive = false;
# line 1316 "ChangeDefs.puma"
   decl->FUNC_DECL.HPFExtrinsic = DefaultId ();
  }
  {
   return decl;
  }
 }

}

tDefinitions GetFuncObject
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tDefinitions unit)
# else
(name, unit)
 register tIdent name;
 register tDefinitions unit;
# endif
{
# line 1331 "ChangeDefs.puma"

tObject Obj;

# line 1339 "ChangeDefs.puma"
  {
# line 1341 "ChangeDefs.puma"
   Obj = GetLocalObject (name);
# line 1343 "ChangeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL1;
  {
# line 1345 "ChangeDefs.puma"
   if (! ((! IsValidFuncObject (Obj)))) goto yyL1;
  }
  }
   return MakeObjFunction (Obj);
yyL1:;

# line 1354 "ChangeDefs.puma"
  {
# line 1356 "ChangeDefs.puma"
   Obj = GetGlobalObject (name);
# line 1358 "ChangeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL2;
  {
# line 1360 "ChangeDefs.puma"
   if (! ((IsValidFuncObject (Obj)))) goto yyL2;
  }
  }
   return Obj;
yyL2:;

# line 1369 "ChangeDefs.puma"
  {
# line 1371 "ChangeDefs.puma"
   Obj = GetDeclEntry (name, GetIntrinsicEntries ());
# line 1373 "ChangeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL3;
  {
# line 1375 "ChangeDefs.puma"
   if (! ((IsValidFuncObject (Obj)))) goto yyL3;
  }
  }
   return Obj;
yyL3:;

# line 1384 "ChangeDefs.puma"
  {
# line 1386 "ChangeDefs.puma"
   Obj = MakeNewRoutineObject (MakeFuncDecl (name, 0, mDUMMY_TYPE ()), UserRoutine, unit);
# line 1389 "ChangeDefs.puma"
   InsertEntry (Obj);
  }
   return Obj;

}

static bool IsValidFuncObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kFuncObject) {
# line 1396 "ChangeDefs.puma"
   return true;

  }
  if (obj->Kind == kGenericObject) {
# line 1401 "ChangeDefs.puma"
   return true;

  }
  return false;
}

tDefinitions GetProcObject
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tDefinitions unit)
# else
(name, unit)
 register tIdent name;
 register tDefinitions unit;
# endif
{
# line 1416 "ChangeDefs.puma"

tObject Obj;

# line 1420 "ChangeDefs.puma"
  {
# line 1422 "ChangeDefs.puma"
   Obj = GetLocalObject (name);
# line 1424 "ChangeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL1;
  }
   return MakeObjSubroutine (Obj);
yyL1:;

# line 1429 "ChangeDefs.puma"
  {
# line 1431 "ChangeDefs.puma"
   Obj = GetDeclEntry (name, GetIntrinsicEntries ());
# line 1433 "ChangeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL2;
  {
# line 1435 "ChangeDefs.puma"
   if (! ((Obj -> Kind == kProcObject))) goto yyL2;
  }
  }
   return Obj;
yyL2:;

# line 1440 "ChangeDefs.puma"
 {
  tTree Decl;
  {
# line 1442 "ChangeDefs.puma"

# line 1444 "ChangeDefs.puma"
   Obj = MakeNewRoutineObject (MakeProcDecl (name, 0), UserRoutine, unit);
# line 1447 "ChangeDefs.puma"
   InsertEntry (Obj);
  }
  {
   return Obj;
  }
 }

}

void SetExternalEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1462 "ChangeDefs.puma"
  {
# line 1464 "ChangeDefs.puma"
   if (! ((GetDeclEntry (obj->Object.Ident, GetUnitEntries ()) != NoObject))) goto yyL1;
  }
   return;
yyL1:;

# line 1467 "ChangeDefs.puma"
  {
# line 1469 "ChangeDefs.puma"
   if (! ((GetDeclEntry (obj->Object.Ident, GetExternalEntries ()) != NoObject))) goto yyL2;
  }
   return;
yyL2:;

# line 1472 "ChangeDefs.puma"
  {
# line 1474 "ChangeDefs.puma"
   InsertExternalEntry (obj);
  }
   return;

;
}

static tTree SetCompType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree old_type, register tTree new_type)
# else
(obj, old_type, new_type)
 register tDefinitions obj;
 register tTree old_type;
 register tTree new_type;
# endif
{
# line 1485 "ChangeDefs.puma"
  {
# line 1487 "ChangeDefs.puma"
   if (! ((IsSameBaseType (GetBaseType (old_type), new_type)))) goto yyL1;
  {
# line 1488 "ChangeDefs.puma"
   serious_warning_protocol ("same type defined twice");
  }
  }
   return old_type;
yyL1:;

# line 1492 "ChangeDefs.puma"
  {
# line 1494 "ChangeDefs.puma"
   if (! ((! IsDummyType (old_type)))) goto yyL2;
  {
# line 1495 "ChangeDefs.puma"
   error_protocol ("illegal retyping");
# line 1496 "ChangeDefs.puma"
   tree_protocol ("this is the old type : ", old_type);
# line 1497 "ChangeDefs.puma"
   tree_protocol ("this is the new type : ", new_type);
  }
  }
   return old_type;
yyL2:;

# line 1502 "ChangeDefs.puma"
   return NewCompType (old_type, new_type);

}

static tTree NewCompType
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tTree comp)
# else
(type, comp)
 register tTree type;
 register tTree comp;
# endif
{
  if (type->Kind == kDUMMY_TYPE) {
# line 1518 "ChangeDefs.puma"
   return comp;

  }
  if (type->Kind == kARRAY_TYPE) {
  if (type->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
# line 1523 "ChangeDefs.puma"
   return mARRAY_TYPE (type->ARRAY_TYPE.ARRAY_INDEX_TYPES, comp);

  }
  }
  if (type->Kind == kPOINTER_TYPE) {
  if (type->POINTER_TYPE.PTR_COMP->Kind == kDUMMY_TYPE) {
# line 1528 "ChangeDefs.puma"
   return mPOINTER_TYPE (comp);

  }
  if (type->POINTER_TYPE.PTR_COMP->Kind == kARRAY_TYPE) {
  if (type->POINTER_TYPE.PTR_COMP->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
# line 1533 "ChangeDefs.puma"
   return mPOINTER_TYPE (mARRAY_TYPE (type->POINTER_TYPE.PTR_COMP->ARRAY_TYPE.ARRAY_INDEX_TYPES, comp));

  }
  }
  }
# line 1538 "ChangeDefs.puma"
  {
# line 1540 "ChangeDefs.puma"
   failure_protocol (MODULE, "NewCompType", type);
  }
   return type;

}

void BeginChangeDefs ()
{
}

void CloseChangeDefs ()
{
}
