# include "CallGraphFns.h"
# include "yyCallGraphFns.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"
# include "CallGraph.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 37 "CallGraphFns.puma"

#define NoCallNodes NoCallGraph
#define NoCallNode  NoCallGraph
#define NoCallEdges NoCallGraph

static tCallGraph FoundCallNode;

tCallGraph  TheCallGraph;   /* for Output */

void CallGraphError (s)
char s[];
{  fprintf (stderr, "Internal Error for Call Graph : %s\n", s);
}



static void yyExit () { Exit (1); }

void (* CallGraphFns_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CallGraphFns, routine %s failed\n", yyFunction);
 CallGraphFns_Exit ();
}

static tCallGraph InsertNode ARGS((tCallGraph NodeList, tObject nobj, int kind));
static bool SameNode ARGS((tDefinitions obj1, tDefinitions obj2));
tCallGraph CallGraphSearchNode ARGS((tObject nobj, int kind));
static tCallGraph LocalSearchNode ARGS((tCallGraph CG, tObject nobj, int kind));
static tCallGraph EdgeListInsert ARGS((tCallGraph edgelist, tCallGraph node));
void CallGraphInsertEdge ARGS((tCallGraph source, tCallGraph target));

static tCallGraph InsertNode
# if defined __STDC__ | defined __cplusplus
(register tCallGraph NodeList, tObject nobj, register int kind)
# else
(NodeList, nobj, kind)
 register tCallGraph NodeList;
 tObject nobj;
 register int kind;
# endif
{
# line 90 "CallGraphFns.puma"
 {
  register tCallGraph yyV1;
  {
# line 92 "CallGraphFns.puma"
   if (! ((NodeList == NoCallGraph))) goto yyL1;
  {
# line 94 "CallGraphFns.puma"
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolMaxPtr,CallGraph_Alloc,CallGraph_NodeSize,MakeCallGraph,yyV1,kCallNode)
    yyV1->CallNode.val = nobj;
    yyV1->CallNode.unitkind = kind;
    yyV1->CallNode.calling = NoCallEdges;
    yyV1->CallNode.called_by = NoCallEdges;
   FoundCallNode = yyV1;
  }
  }
  {
  register tCallGraph yyV2;
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolMaxPtr,CallGraph_Alloc,CallGraph_NodeSize,MakeCallGraph,yyV2,kCallNodeList)
    yyV2->CallNodeList.Elem = FoundCallNode;
    yyV2->CallNodeList.Next = NoCallNodes;
   return yyV2;
  }
 }
yyL1:;

# line 98 "CallGraphFns.puma"
  {
# line 100 "CallGraphFns.puma"
   if (! ((SameNode (NodeList->CallNodeList.Elem->CallNode.val, nobj)))) goto yyL2;
  {
# line 102 "CallGraphFns.puma"
   FoundCallNode = NodeList->CallNodeList.Elem;
  }
  }
   return NodeList;
yyL2:;

# line 106 "CallGraphFns.puma"
  {
# line 107 "CallGraphFns.puma"
   NodeList->CallNodeList.Next = InsertNode (NodeList->CallNodeList.Next, nobj, kind);
  }
   return NodeList;

}

static bool SameNode
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj1, register tDefinitions obj2)
# else
(obj1, obj2)
 register tDefinitions obj1;
 register tDefinitions obj2;
# endif
{
  if (obj1->Kind == kFuncObject) {
  if (obj2->Kind == kFuncObject) {
# line 121 "CallGraphFns.puma"
  {
# line 124 "CallGraphFns.puma"
   if (! ((obj1->FuncObject.Ident == obj2->FuncObject.Ident))) goto yyL1;
  {
# line 125 "CallGraphFns.puma"
   if (! ((obj1->FuncObject.in == obj2->FuncObject.in))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  if (obj1->Kind == kProcObject) {
  if (obj2->Kind == kProcObject) {
# line 128 "CallGraphFns.puma"
  {
# line 131 "CallGraphFns.puma"
   if (! ((obj1->ProcObject.Ident == obj2->ProcObject.Ident))) goto yyL2;
  {
# line 132 "CallGraphFns.puma"
   if (! ((obj1->ProcObject.in == obj2->ProcObject.in))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  }
  return false;
}

tCallGraph CallGraphSearchNode
# if defined __STDC__ | defined __cplusplus
(tObject nobj, register int kind)
# else
(nobj, kind)
 tObject nobj;
 register int kind;
# endif
{
# line 145 "CallGraphFns.puma"
   return LocalSearchNode (TheCallGraph, nobj, kind);

}

static tCallGraph LocalSearchNode
# if defined __STDC__ | defined __cplusplus
(register tCallGraph CG, tObject nobj, register int kind)
# else
(CG, nobj, kind)
 register tCallGraph CG;
 tObject nobj;
 register int kind;
# endif
{
# line 151 "CallGraphFns.puma"
  {
# line 152 "CallGraphFns.puma"
   if (! ((nobj == NoObject))) goto yyL1;
  {
# line 153 "CallGraphFns.puma"
   CallGraphError ("no object for searching node");
  }
  }
   return NoCallNode;
yyL1:;

  if (CG->Kind == kCallGraph) {
  if (equalint (kind, 0)) {
# line 157 "CallGraphFns.puma"
  {
# line 158 "CallGraphFns.puma"
   CG->CallGraph.UserNodes = InsertNode (CG->CallGraph.UserNodes, nobj, kind);
  }
   return FoundCallNode;

  }
  if (equalint (kind, 1)) {
# line 162 "CallGraphFns.puma"
  {
# line 163 "CallGraphFns.puma"
   CG->CallGraph.IntrinsicNodes = InsertNode (CG->CallGraph.IntrinsicNodes, nobj, kind);
  }
   return FoundCallNode;

  }
  if (equalint (kind, 2)) {
# line 167 "CallGraphFns.puma"
  {
# line 168 "CallGraphFns.puma"
   CG->CallGraph.ExternalNodes = InsertNode (CG->CallGraph.ExternalNodes, nobj, kind);
  }
   return FoundCallNode;

  }
  }
 yyAbort ("LocalSearchNode");
}

static tCallGraph EdgeListInsert
# if defined __STDC__ | defined __cplusplus
(register tCallGraph edgelist, register tCallGraph node)
# else
(edgelist, node)
 register tCallGraph edgelist;
 register tCallGraph node;
# endif
{
# line 182 "CallGraphFns.puma"
 {
  {
# line 183 "CallGraphFns.puma"
   if (! ((edgelist == NoCallEdges))) goto yyL1;
  }
  {
  register tCallGraph yyV1;
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolMaxPtr,CallGraph_Alloc,CallGraph_NodeSize,MakeCallGraph,yyV1,kCallEdgeList)
    yyV1->CallEdgeList.Node = node;
    yyV1->CallEdgeList.count = 1;
    yyV1->CallEdgeList.Next = NoCallEdges;
   return yyV1;
  }
 }
yyL1:;

# line 187 "CallGraphFns.puma"
  {
# line 188 "CallGraphFns.puma"
   if (! ((edgelist->CallEdgeList.Node == node))) goto yyL2;
  {
# line 189 "CallGraphFns.puma"
   edgelist->CallEdgeList.count = edgelist->CallEdgeList.count + 1;
  }
  }
   return edgelist;
yyL2:;

# line 193 "CallGraphFns.puma"
  {
# line 194 "CallGraphFns.puma"
   edgelist->CallEdgeList.Next = EdgeListInsert (edgelist->CallEdgeList.Next, node);
  }
   return edgelist;

}

void CallGraphInsertEdge
# if defined __STDC__ | defined __cplusplus
(register tCallGraph source, register tCallGraph target)
# else
(source, target)
 register tCallGraph source;
 register tCallGraph target;
# endif
{
# line 206 "CallGraphFns.puma"
  {
# line 207 "CallGraphFns.puma"
   if (! ((source == NoCallNode))) goto yyL1;
  {
# line 208 "CallGraphFns.puma"
   CallGraphError ("Insert edge with source == NIL");
  }
  }
   return;
yyL1:;

# line 211 "CallGraphFns.puma"
  {
# line 212 "CallGraphFns.puma"
   if (! ((target == NoCallNode))) goto yyL2;
  {
# line 213 "CallGraphFns.puma"
   CallGraphError ("Insert edge with target == NIL");
  }
  }
   return;
yyL2:;

# line 216 "CallGraphFns.puma"
  {
# line 218 "CallGraphFns.puma"
   source->CallNode.calling = EdgeListInsert (source->CallNode.calling, target);
# line 219 "CallGraphFns.puma"
   target->CallNode.called_by = EdgeListInsert (target->CallNode.called_by, source);
  }
   return;

;
}

void BeginCallGraphFns ()
{
# line 74 "CallGraphFns.puma"


TheCallGraph  = mCallGraph (NoCallNodes, NoCallNodes, NoCallNodes);
                /* all three lists are empty */


}

void CloseCallGraphFns ()
{
}
