# include "CallGraph.h"
# define yyALLOC(ptr, size)	if ((ptr = (tCallGraph) CallGraph_PoolFreePtr) >= (tCallGraph) CallGraph_PoolMaxPtr) \
  ptr = CallGraph_Alloc (); \
  CallGraph_PoolFreePtr += size;
# define yyFREE(ptr, size)	
# ifdef __cplusplus
extern "C" {
# include <stdio.h>
# include "yyCallGraph.w"
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
}
# else
# include <stdio.h>
# include "yyCallGraph.w"
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
# endif

/* line 43 "fortran.call" */


# include <string.h>



static void yyExit () { Exit (1); }

void (* CallGraph_Exit) () = yyExit;

# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tCallGraph CallGraphRoot;
unsigned long CallGraph_HeapUsed = 0;

static yytBlockPtr yyBlockList	= (yytBlockPtr) NoCallGraph;
char * CallGraph_PoolFreePtr	= (char *) NoCallGraph;
char * CallGraph_PoolMaxPtr	= (char *) NoCallGraph;
static unsigned short yyMaxSize	= 0;
unsigned short CallGraph_NodeSize [4 + 1] = { 0,
 sizeof (yCallGraph),
 sizeof (yCallNode),
 sizeof (yCallNodeList),
 sizeof (yCallEdgeList),
};
char * CallGraph_NodeName [4 + 1] = {
 "NoCallGraph",
 "CallGraph",
 "CallNode",
 "CallNodeList",
 "CallEdgeList",
};
static CallGraph_tKind yyTypeRange [4 + 1] = { 0,
 kCallGraph,
 kCallNode,
 kCallNodeList,
 kCallEdgeList,
};

tCallGraph CallGraph_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 4; i ++) {
   CallGraph_NodeSize [i] = (CallGraph_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (CallGraph_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 CallGraph_PoolFreePtr = yyBlockList->yyBlock;
 CallGraph_PoolMaxPtr = CallGraph_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 CallGraph_HeapUsed += yyBlockSize;
 return (tCallGraph) CallGraph_PoolFreePtr;
}

tCallGraph MakeCallGraph
# if defined __STDC__ | defined __cplusplus
 (CallGraph_tKind yyKind)
# else
 (yyKind) CallGraph_tKind yyKind;
# endif
{
 register tCallGraph yyt;
 yyALLOC (yyt, CallGraph_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

bool CallGraph_IsType
# if defined __STDC__ | defined __cplusplus
 (register tCallGraph yyt, register CallGraph_tKind yyKind)
# else
 (yyt, yyKind) register tCallGraph yyt; register CallGraph_tKind yyKind;
# endif
{
 return yyt != NoCallGraph && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}


tCallGraph mCallGraph
# if defined __STDC__ | defined __cplusplus
(tCallGraph pUserNodes, tCallGraph pIntrinsicNodes, tCallGraph pExternalNodes)
# else
(pUserNodes, pIntrinsicNodes, pExternalNodes)
tCallGraph pUserNodes;
tCallGraph pIntrinsicNodes;
tCallGraph pExternalNodes;
# endif
{
 register tCallGraph yyt;
 yyALLOC (yyt, CallGraph_NodeSize [kCallGraph])
 yyt->Kind = kCallGraph;
 yyt->yyHead.yyMark = 0;
 yyt->CallGraph.UserNodes = pUserNodes;
 yyt->CallGraph.IntrinsicNodes = pIntrinsicNodes;
 yyt->CallGraph.ExternalNodes = pExternalNodes;
 return yyt;
}

tCallGraph mCallNode
# if defined __STDC__ | defined __cplusplus
(tObject pval, int punitkind, tCallGraph pcalling, tCallGraph pcalled_by)
# else
(pval, punitkind, pcalling, pcalled_by)
tObject pval;
int punitkind;
tCallGraph pcalling;
tCallGraph pcalled_by;
# endif
{
 register tCallGraph yyt;
 yyALLOC (yyt, CallGraph_NodeSize [kCallNode])
 yyt->Kind = kCallNode;
 yyt->yyHead.yyMark = 0;
 yyt->CallNode.val = pval;
 yyt->CallNode.unitkind = punitkind;
 yyt->CallNode.calling = pcalling;
 yyt->CallNode.called_by = pcalled_by;
 return yyt;
}

tCallGraph mCallNodeList
# if defined __STDC__ | defined __cplusplus
(tCallGraph pElem, tCallGraph pNext)
# else
(pElem, pNext)
tCallGraph pElem;
tCallGraph pNext;
# endif
{
 register tCallGraph yyt;
 yyALLOC (yyt, CallGraph_NodeSize [kCallNodeList])
 yyt->Kind = kCallNodeList;
 yyt->yyHead.yyMark = 0;
 yyt->CallNodeList.Elem = pElem;
 yyt->CallNodeList.Next = pNext;
 return yyt;
}

tCallGraph mCallEdgeList
# if defined __STDC__ | defined __cplusplus
(tCallGraph pNode, int pcount, tCallGraph pNext)
# else
(pNode, pcount, pNext)
tCallGraph pNode;
int pcount;
tCallGraph pNext;
# endif
{
 register tCallGraph yyt;
 yyALLOC (yyt, CallGraph_NodeSize [kCallEdgeList])
 yyt->Kind = kCallEdgeList;
 yyt->yyHead.yyMark = 0;
 yyt->CallEdgeList.Node = pNode;
 yyt->CallEdgeList.count = pcount;
 yyt->CallEdgeList.Next = pNext;
 return yyt;
}

typedef tCallGraph * yyPtrtTree;

static FILE * yyf;

static void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tCallGraph yyt)
# else
 (yyt) register tCallGraph yyt;
# endif
{
 for (;;) {
  if (yyt == NoCallGraph || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kCallGraph:
yyMark (yyt->CallGraph.UserNodes);
yyMark (yyt->CallGraph.IntrinsicNodes);
yyt = yyt->CallGraph.ExternalNodes; break;
case kCallNode:
yyMark (yyt->CallNode.calling);
yyt = yyt->CallNode.called_by; break;
case kCallNodeList:
yyMark (yyt->CallNodeList.Elem);
yyt = yyt->CallNodeList.Next; break;
case kCallEdgeList:
yyMark (yyt->CallEdgeList.Node);
yyt = yyt->CallEdgeList.Next; break;
  default: return;
  }
 }
}

# define yyInitTreeStoreSize 32
# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tCallGraph yyTreeStore [yyInitTreeStoreSize];
static tCallGraph * yyTreeStorePtr = yyTreeStore;
static int yyLabelCount;
static short yyRecursionLevel = 0;

static CallGraph_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++) if (yyTreeStorePtr [yyi] == yyt) return yyi;
 if (++ yyLabelCount == yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize, sizeof (tCallGraph));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return yyLabelCount;
}

static void yyWriteCallGraph ();

static void yyWriteNl () { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++) (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static void yyWriteAdr
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 if (yyt == NoCallGraph) (void) fputs ("NoCallGraph", yyf);
 else yyWriteHex ((unsigned char *) & yyt, sizeof (yyt));
 yyWriteNl ();
}

static void yWriteNodeCallGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyWriteSelector ("UserNodes"); yyWriteAdr (yyt->CallGraph.UserNodes);
 yyWriteSelector ("IntrinsicNodes"); yyWriteAdr (yyt->CallGraph.IntrinsicNodes);
 yyWriteSelector ("ExternalNodes"); yyWriteAdr (yyt->CallGraph.ExternalNodes);
}

static void yWriteNodeCallNode
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyWriteSelector ("val"); writetObject (yyt->CallNode.val) yyWriteNl ();
 yyWriteSelector ("unitkind"); writeint (yyt->CallNode.unitkind) yyWriteNl ();
 yyWriteSelector ("calling"); yyWriteAdr (yyt->CallNode.calling);
 yyWriteSelector ("called_by"); yyWriteAdr (yyt->CallNode.called_by);
}

static void yWriteNodeCallNodeList
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->CallNodeList.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->CallNodeList.Next);
}

static void yWriteNodeCallEdgeList
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyWriteSelector ("Node"); yyWriteAdr (yyt->CallEdgeList.Node);
 yyWriteSelector ("count"); writeint (yyt->CallEdgeList.count) yyWriteNl ();
 yyWriteSelector ("Next"); yyWriteAdr (yyt->CallEdgeList.Next);
}

void WriteCallGraphNode
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tCallGraph yyt)
# else
 (yyyf, yyt) FILE * yyyf; tCallGraph yyt;
# endif
{
 yyf = yyyf;
 if (yyt == NoCallGraph) { (void) fputs ("NoCallGraph\n", yyf); return; }

 switch (yyt->Kind) {
case kCallGraph: (void) fputs (CallGraph_NodeName [kCallGraph], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCallGraph (yyt); break;
case kCallNode: (void) fputs (CallGraph_NodeName [kCallNode], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCallNode (yyt); break;
case kCallNodeList: (void) fputs (CallGraph_NodeName [kCallNodeList], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCallNodeList (yyt); break;
case kCallEdgeList: (void) fputs (CallGraph_NodeName [kCallEdgeList], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCallEdgeList (yyt); break;
 default: ;
 }
}

static short yyIndentLevel;

void WriteCallGraph
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tCallGraph yyt)
# else
 (yyyf, yyt) FILE * yyyf; tCallGraph yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyWriteCallGraph (yyt);
 yyIndentLevel = yySaveLevel;
 yyRecursionLevel --;
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tCallGraph yyt)
# else
 (yys, yyt) char * yys; tCallGraph yyt;
# endif
{ yyIndentSelector (yys); writetCallGraph (yyt) }

static void yWriteCallGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 (void) fputs (CallGraph_NodeName [kCallGraph], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("UserNodes", yyt->CallGraph.UserNodes);
 yyIndentSelectorTree ("IntrinsicNodes", yyt->CallGraph.IntrinsicNodes);
}

static void yWriteCallNode
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 (void) fputs (CallGraph_NodeName [kCallNode], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("val"); writetObject (yyt->CallNode.val) yyWriteNl ();
 yyIndentSelector ("unitkind"); writeint (yyt->CallNode.unitkind) yyWriteNl ();
 yyIndentSelectorTree ("calling", yyt->CallNode.calling);
}

static void yWriteCallNodeList
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 (void) fputs (CallGraph_NodeName [kCallNodeList], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->CallNodeList.Elem);
}

static void yWriteCallEdgeList
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 (void) fputs (CallGraph_NodeName [kCallEdgeList], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Node", yyt->CallEdgeList.Node);
 yyIndentSelector ("count"); writeint (yyt->CallEdgeList.count) yyWriteNl ();
}

static void yyWriteCallGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoCallGraph) { (void) fputs (" NoCallGraph\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) { (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  switch (yyt->Kind) {
case kCallGraph: yWriteCallGraph (yyt); yyIndentSelector ("ExternalNodes"); yyt = yyt->CallGraph.ExternalNodes; break;
case kCallNode: yWriteCallNode (yyt); yyIndentSelector ("called_by"); yyt = yyt->CallNode.called_by; break;
case kCallNodeList: yWriteCallNodeList (yyt); yyIndentSelector ("Next"); yyt = yyt->CallNodeList.Next; break;
case kCallEdgeList: yWriteCallEdgeList (yyt); yyIndentSelector ("Next"); yyt = yyt->CallEdgeList.Next; break;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

# define yyNil	0374
# define yyNoLabel	0375
# define yyLabelDef	0376
# define yyLabelUse	0377

static bool yyCheckCallGraph ARGS((tCallGraph yyt));

bool CheckCallGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyMark (yyt);
 return yyCheckCallGraph (yyt);
}

static bool yyCheckChild
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyParent, tCallGraph yyyChild, CallGraph_tKind yyType, char * yySelector)
# else
 (yyParent, yyyChild, yyType, yySelector)
 tCallGraph yyParent, yyyChild;
 CallGraph_tKind yyType;
 char * yySelector;
# endif
{
 bool yySuccess = CallGraph_IsType (yyyChild, yyType);
 if (! yySuccess) {
  (void) fputs ("CheckTree: parent = ", stderr);
  WriteCallGraphNode (stderr, yyParent);
  (void) fprintf (stderr, "\nselector: %s child = ", yySelector);
  WriteCallGraphNode (stderr, yyyChild);
  (void) fputc ('\n', stderr);
 }
 return yyCheckCallGraph (yyyChild) && yySuccess;
}

static bool yyCheckCallGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 bool yyResult;
 if (yyt == NoCallGraph) return false;
 else if (yyt->yyHead.yyMark == 0) return true;
 yyt->yyHead.yyMark = 0;

 yyResult = true;
 switch (yyt->Kind) {
case kCallGraph:
yyResult = yyCheckChild (yyt, yyt->CallGraph.UserNodes, kCallNodeList, "UserNodes") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CallGraph.IntrinsicNodes, kCallNodeList, "IntrinsicNodes") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CallGraph.ExternalNodes, kCallNodeList, "ExternalNodes") && yyResult;
break;
case kCallNode:
yyResult = yyCheckChild (yyt, yyt->CallNode.calling, kCallEdgeList, "calling") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CallNode.called_by, kCallEdgeList, "called_by") && yyResult;
break;
case kCallNodeList:
yyResult = yyCheckChild (yyt, yyt->CallNodeList.Elem, kCallNode, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CallNodeList.Next, kCallNodeList, "Next") && yyResult;
break;
case kCallEdgeList:
yyResult = yyCheckChild (yyt, yyt->CallEdgeList.Node, kCallNode, "Node") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CallEdgeList.Next, kCallEdgeList, "Next") && yyResult;
break;
 default: ;
 }
 return yyResult;
}

void BeginCallGraph ()
{
}

void CloseCallGraph ()
{
/* line 49 "fortran.call" */


}
