# include "BuildTree.h"
# include "yyBuildTree.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 73 "BuildTree.puma"


# include <string.h>
# include <ctype.h>

# include "Idents.h"     
# include "StringMem.h"    /* GetString, ... */

# define MODEL_GLOBAL  1
# define MODEL_LOCAL   2
# define MODEL_SERIAL  4

# define LANGUAGE_HPF  8
# define LANGUAGE_F77 16

  /***********************************************************
  *                                                          *
  *  void BuildTreeError (char error_message[])              *
  *                                                          *
  ***********************************************************/

void BuildTreeError (error_message)
char error_message[];

{ fprintf (stderr, "serious error when building the AST : %s\n",
                   error_message);

} /* BuildTreeError */



static void yyExit () { Exit (1); }

void (* BuildTree_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module BuildTree, routine %s failed\n", yyFunction);
 BuildTree_Exit ();
}

tTree ConcatUnits ARGS((tTree list1, tTree list2));
tTree CompleteUnits ARGS((tTree list));
tTree ConcatDecls ARGS((tTree list1, tTree list2));
tTree CompleteDecls ARGS((tTree list));
tTree SetDefaultSize ARGS((tTree type));
tTree SetTypeSize ARGS((tTree type, int size));
tTree SetTypeKind ARGS((tTree type, tTree kind));
void SetImplicitType ARGS((tTree declist, tTree type));
void SetIntent ARGS((tTree declist, int intent));
static void SetNewAttributes ARGS((tTree attlist, tTree entity, bool is_last));
void SetAttributes ARGS((tTree attlist, tTree entlist));
void SetACFNode ARGS((tTree node, int label, int line));
void SetACFNodeLine ARGS((tTree node, int line));
void SetACFNodeLabel ARGS((tTree node, int label));
static void ResetACFNode ARGS((tTree node, int label, int line));
void Spec_Exec_Separation ARGS((tTree body));
static void ExtractSpecifications ARGS((tTree stats, tTree * yyP2, tTree * yyP1));
static bool IsSpecification ARGS((tTree elem));
void LabelForEnd ARGS((tTree body, int label, int line));
static tTree AppendStmt ARGS((tTree stmtlist, tTree new));
void SetDefinitionLabel ARGS((tTree decls, int label));
void MakePrivateDecls ARGS((tTree t));
void MakePublicDecls ARGS((tTree t));
tTree MakeComplexConstant ARGS((tTree exp1, tTree exp2));
static tStringRef RealValue ARGS((tTree exp));
tTree SetParInfoNew ARGS((tTree info, tTree new));
tTree SetParInfoReduction ARGS((tTree info, tTree new));
tTree SetParInfoHome ARGS((tTree info, tTree home));
tTree SetParInfoResident ARGS((tTree info, tTree res_var));
void SetIndependent ARGS((tTree loop));
void SetSerial ARGS((tTree loop));
tTree ApplyParInfo ARGS((tTree stmt, tTree info, int line));
void ApplyNewClause ARGS((tTree stmt, tTree new_vars, int line));
void ApplyResidentClause ARGS((tTree stmt, tTree res_vars, int line));
static void ApplyHomeClause ARGS((tTree stmt, tTree home_var, int line));
void SetBody ARGS((tTree stmt, tTree new_body));
void SetProcessorId ARGS((tTree spec, tTree id));
void CheckSameIdent ARGS((tIdent id1, tIdent id2));
void SetMapKind ARGS((int kind, tStringRef val, tTree decls));
tTree BuildSingleReductions ARGS((tTree t));
void SpreadSelection ARGS((tTree selectees, tTree selections));
tIdent DecodeExtrinsic ARGS((int kind));
int CodeExtrinsic ARGS((tStringRef t));
int CodeExtrinsic1 ARGS((tIdent id, tStringRef t));
int MixExtrinsic ARGS((int kind1, int kind2));

tTree ConcatUnits
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
# line 115 "BuildTree.puma"
  {
# line 116 "BuildTree.puma"
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kUNIT_EMPTY) {
# line 120 "BuildTree.puma"
   return list2;

  }
  if (list1->Kind == kUNIT_LIST) {
# line 124 "BuildTree.puma"
  {
# line 125 "BuildTree.puma"
 list1->UNIT_LIST.Next = ConcatUnits (list1->UNIT_LIST.Next, list2); 
  }
   return list1;

  }
# line 129 "BuildTree.puma"
  {
# line 130 "BuildTree.puma"
   BuildTreeError ("ConcatUnits failed");
  }
   return NoTree;

}

tTree CompleteUnits
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
# line 136 "BuildTree.puma"
  {
# line 137 "BuildTree.puma"
   if (! ((list == NoTree))) goto yyL1;
  }
   return mUNIT_EMPTY ();
yyL1:;

  if (list->Kind == kUNIT_EMPTY) {
# line 141 "BuildTree.puma"
   return list;

  }
  if (list->Kind == kUNIT_LIST) {
# line 145 "BuildTree.puma"
  {
# line 146 "BuildTree.puma"
 list->UNIT_LIST.Next = CompleteUnits (list->UNIT_LIST.Next); 
  }
   return list;

  }
 yyAbort ("CompleteUnits");
}

tTree ConcatDecls
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
# line 161 "BuildTree.puma"
  {
# line 162 "BuildTree.puma"
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kDECL_EMPTY) {
# line 166 "BuildTree.puma"
   return list2;

  }
  if (list1->Kind == kDECL_LIST) {
# line 171 "BuildTree.puma"
  {
# line 173 "BuildTree.puma"
 list1->DECL_LIST.Next = ConcatDecls (list1->DECL_LIST.Next, list2); 
  }
   return list1;

  }
# line 177 "BuildTree.puma"
  {
# line 178 "BuildTree.puma"
   BuildTreeError ("ConcatDecls failed");
# line 179 "BuildTree.puma"
   WriteTree (stdout, list1);
# line 180 "BuildTree.puma"
   WriteTree (stdout, list2);
  }
   return NoTree;

}

tTree CompleteDecls
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
# line 186 "BuildTree.puma"
  {
# line 187 "BuildTree.puma"
   if (! ((list == NoTree))) goto yyL1;
  }
   return mDECL_EMPTY ();
yyL1:;

  if (list->Kind == kDECL_EMPTY) {
# line 191 "BuildTree.puma"
   return list;

  }
  if (list->Kind == kDECL_LIST) {
# line 195 "BuildTree.puma"
  {
# line 196 "BuildTree.puma"
 list->DECL_LIST.Next = CompleteDecls (list->DECL_LIST.Next); 
  }
   return list;

  }
 yyAbort ("CompleteDecls");
}

tTree SetDefaultSize
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
  if (type->Kind == kINTEGER_TYPE) {
# line 208 "BuildTree.puma"
  {
# line 209 "BuildTree.puma"
   type->INTEGER_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (default_int_size));
  }
   return type;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
# line 213 "BuildTree.puma"
  {
# line 214 "BuildTree.puma"
   type->BOOLEAN_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (default_int_size));
  }
   return type;

  }
  if (type->Kind == kREAL_TYPE) {
# line 218 "BuildTree.puma"
  {
# line 220 "BuildTree.puma"
   if (! ((is_double_precision))) goto yyL3;
  {
# line 221 "BuildTree.puma"
   type->REAL_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (2 * default_real_size));
  }
  }
   return type;
yyL3:;

# line 225 "BuildTree.puma"
  {
# line 227 "BuildTree.puma"
   type->REAL_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (default_real_size));
  }
   return type;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
# line 231 "BuildTree.puma"
  {
# line 232 "BuildTree.puma"
   type->COMPLEX_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (2 * default_real_size));
  }
   return type;

  }
 yyAbort ("SetDefaultSize");
}

tTree SetTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree type, register int size)
# else
(type, size)
 register tTree type;
 register int size;
# endif
{
  if (type->Kind == kINTEGER_TYPE) {
# line 244 "BuildTree.puma"
  {
# line 245 "BuildTree.puma"
   type->INTEGER_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (size));
  }
   return type;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
# line 249 "BuildTree.puma"
  {
# line 250 "BuildTree.puma"
   type->BOOLEAN_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (size));
  }
   return type;

  }
  if (type->Kind == kREAL_TYPE) {
# line 254 "BuildTree.puma"
  {
# line 255 "BuildTree.puma"
   type->REAL_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (size));
  }
   return type;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
# line 259 "BuildTree.puma"
  {
# line 260 "BuildTree.puma"
   type->COMPLEX_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (size));
  }
   return type;

  }
 yyAbort ("SetTypeSize");
}

tTree SetTypeKind
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tTree kind)
# else
(type, kind)
 register tTree type;
 register tTree kind;
# endif
{
  if (type->Kind == kINTEGER_TYPE) {
# line 272 "BuildTree.puma"
  {
# line 273 "BuildTree.puma"
   type->INTEGER_TYPE.SIZE = kind;
  }
   return type;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
# line 277 "BuildTree.puma"
  {
# line 278 "BuildTree.puma"
   type->BOOLEAN_TYPE.SIZE = kind;
  }
   return type;

  }
  if (type->Kind == kREAL_TYPE) {
# line 282 "BuildTree.puma"
  {
# line 283 "BuildTree.puma"
   type->REAL_TYPE.SIZE = kind;
  }
   return type;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
# line 287 "BuildTree.puma"
  {
# line 288 "BuildTree.puma"
   type->COMPLEX_TYPE.SIZE = kind;
  }
   return type;

  }
 yyAbort ("SetTypeKind");
}

void SetImplicitType
# if defined __STDC__ | defined __cplusplus
(register tTree declist, register tTree type)
# else
(declist, type)
 register tTree declist;
 register tTree type;
# endif
{
# line 300 "BuildTree.puma"
  {
# line 301 "BuildTree.puma"
   if (! ((declist == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (declist->Kind == kDECL_LIST) {
  if (declist->DECL_LIST.Elem->Kind == kIMPLICIT_DECL) {
# line 304 "BuildTree.puma"
  {
# line 306 "BuildTree.puma"
 declist->DECL_LIST.Elem->IMPLICIT_DECL.TYPE = type; 
# line 307 "BuildTree.puma"
   SetImplicitType (declist->DECL_LIST.Next, type);
  }
   return;

  }
# line 310 "BuildTree.puma"
  {
# line 311 "BuildTree.puma"
   SetImplicitType (declist->DECL_LIST.Next, type);
  }
   return;

  }
# line 314 "BuildTree.puma"
  {
# line 315 "BuildTree.puma"
   printf ("illegal call of SetImplicitType\n");
# line 316 "BuildTree.puma"
   WriteTree (stdout, declist);
  }
   return;

;
}

void SetIntent
# if defined __STDC__ | defined __cplusplus
(register tTree declist, register int intent)
# else
(declist, intent)
 register tTree declist;
 register int intent;
# endif
{
# line 327 "BuildTree.puma"
  {
# line 328 "BuildTree.puma"
   if (! ((declist == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (declist->Kind == kDECL_LIST) {
  if (declist->DECL_LIST.Elem->Kind == kINTENT_DECL) {
# line 331 "BuildTree.puma"
  {
# line 333 "BuildTree.puma"
 declist->DECL_LIST.Elem->INTENT_DECL.intent = intent; 
# line 334 "BuildTree.puma"
   SetIntent (declist->DECL_LIST.Next, intent);
  }
   return;

  }
  }
# line 337 "BuildTree.puma"
  {
# line 338 "BuildTree.puma"
   printf ("illegal call of SetIntent\n");
# line 339 "BuildTree.puma"
   WriteTree (stdout, declist);
  }
   return;

;
}

static void SetNewAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree attlist, register tTree entity, register bool is_last)
# else
(attlist, entity, is_last)
 register tTree attlist;
 register tTree entity;
 register bool is_last;
# endif
{
# line 356 "BuildTree.puma"
  {
# line 357 "BuildTree.puma"
   if (! ((attlist == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (attlist->Kind == kDECL_LIST) {
  if (entity->Kind == kENTITY_DECL) {
# line 360 "BuildTree.puma"
  {
# line 362 "BuildTree.puma"
   if (! ((is_last == true))) goto yyL2;
  {
# line 363 "BuildTree.puma"
   SetNewAttributes (attlist->DECL_LIST.Next, entity, is_last);
# line 364 "BuildTree.puma"
 attlist->DECL_LIST.Next       = entity->ENTITY_DECL.ATTRIBUTES;
    entity->ENTITY_DECL.ATTRIBUTES = attlist;
  
  }
  }
   return;
yyL2:;

# line 369 "BuildTree.puma"
  {
# line 370 "BuildTree.puma"
   if (! ((is_last != true))) goto yyL3;
  {
# line 371 "BuildTree.puma"
   SetNewAttributes (attlist->DECL_LIST.Next, entity, is_last);
# line 372 "BuildTree.puma"
 entity->ENTITY_DECL.ATTRIBUTES = mDECL_LIST (CopyTree (attlist->DECL_LIST.Elem), entity->ENTITY_DECL.ATTRIBUTES); 
  }
  }
   return;
yyL3:;

  }
  }
# line 375 "BuildTree.puma"
  {
# line 376 "BuildTree.puma"
   printf ("illegal call of SetNewAttributes\n");
# line 377 "BuildTree.puma"
   WriteTree (stdout, attlist);
  }
   return;

;
}

void SetAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree attlist, register tTree entlist)
# else
(attlist, entlist)
 register tTree attlist;
 register tTree entlist;
# endif
{
# line 395 "BuildTree.puma"
  {
# line 396 "BuildTree.puma"
   if (! ((entlist == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (entlist->Kind == kDECL_LIST) {
  if (entlist->DECL_LIST.Elem->Kind == kENTITY_DECL) {
# line 400 "BuildTree.puma"
 {
  bool is_last;
  {
# line 402 "BuildTree.puma"

# line 404 "BuildTree.puma"
 is_last = (entlist->DECL_LIST.Next == NoTree); 
    SetNewAttributes (attlist, entlist->DECL_LIST.Elem, is_last);
  
# line 407 "BuildTree.puma"
   SetAttributes (attlist, entlist->DECL_LIST.Next);
  }
   return;
 }

  }
  }
# line 410 "BuildTree.puma"
  {
# line 411 "BuildTree.puma"
   printf ("illegal call of SetAttributes\n");
# line 412 "BuildTree.puma"
   WriteTree (stdout, entlist);
  }
   return;

;
}

void SetACFNode
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int label, register int line)
# else
(node, label, line)
 register tTree node;
 register int label;
 register int line;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
# line 425 "BuildTree.puma"
  {
# line 427 "BuildTree.puma"
   node->ACF_NODE.Label = label;
# line 428 "BuildTree.puma"
   node->ACF_NODE.Line = line;
  }
   return;

  }
;
}

void SetACFNodeLine
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int line)
# else
(node, line)
 register tTree node;
 register int line;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
# line 433 "BuildTree.puma"
  {
# line 435 "BuildTree.puma"
   node->ACF_NODE.Line = line;
  }
   return;

  }
;
}

void SetACFNodeLabel
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int label)
# else
(node, label)
 register tTree node;
 register int label;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
# line 440 "BuildTree.puma"
  {
# line 442 "BuildTree.puma"
   if (! ((label == 0))) goto yyL1;
  }
   return;
yyL1:;

# line 445 "BuildTree.puma"
  {
# line 447 "BuildTree.puma"
   if (! ((node->ACF_NODE.Label == 0))) goto yyL2;
  {
# line 449 "BuildTree.puma"
   node->ACF_NODE.Label = label;
  }
  }
   return;
yyL2:;

# line 452 "BuildTree.puma"
  {
# line 454 "BuildTree.puma"
 char msg[100];
     sprintf (msg, "two labels for a node (old=%d,new=%d)", 
                   node->ACF_NODE.Label, label);
     BuildTreeError (msg);
   
  }
   return;

  }
;
}

static void ResetACFNode
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int label, register int line)
# else
(node, label, line)
 register tTree node;
 register int label;
 register int line;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
# line 469 "BuildTree.puma"
  {
# line 471 "BuildTree.puma"
   if (! ((node->ACF_NODE.Label != 0))) goto yyL1;
  {
# line 472 "BuildTree.puma"
   if (! ((label != 0))) goto yyL1;
  {
# line 474 "BuildTree.puma"
   fprintf (stderr, "ERROR: Statement is labelled twice, old label = %d, new label = %d\n", node->ACF_NODE.Label, label);
# line 478 "BuildTree.puma"
   node->ACF_NODE.Line = line;
  }
  }
  }
   return;
yyL1:;

# line 481 "BuildTree.puma"
  {
# line 485 "BuildTree.puma"
   if (! ((node->ACF_NODE.Label != 0))) goto yyL2;
  {
# line 486 "BuildTree.puma"
   node->ACF_NODE.Line = line;
  }
  }
   return;
yyL2:;

# line 489 "BuildTree.puma"
  {
# line 491 "BuildTree.puma"
   node->ACF_NODE.Label = label;
# line 492 "BuildTree.puma"
   node->ACF_NODE.Line = line;
  }
   return;

  }
;
}

void Spec_Exec_Separation
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 505 "BuildTree.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 507 "BuildTree.puma"
   ExtractSpecifications (body->BODY_NODE.STATS, & yyV1, & yyV2);
# line 509 "BuildTree.puma"
 body->BODY_NODE.STATS = yyV1; 
     if (yyV2 != NoTree)
       body->BODY_NODE.DECLS = ConcatDecls (body->BODY_NODE.DECLS, CompleteDecls (yyV2));
   
  }
   return;
 }

  }
;
}

static void ExtractSpecifications
# if defined __STDC__ | defined __cplusplus
(register tTree stats, register tTree * yyP2, register tTree * yyP1)
# else
(stats, yyP2, yyP1)
 register tTree stats;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{

  switch (stats->Kind) {
  case kACF_LIST:
# line 517 "BuildTree.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 519 "BuildTree.puma"
   if (! ((IsSpecification (stats->ACF_LIST.Elem)))) goto yyL1;
  {
# line 520 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_LIST.Next, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = ConcatDecls (stats->ACF_LIST.Elem, yyV2);
   return;
 }
yyL1:;

# line 523 "BuildTree.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 525 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_LIST.Elem, & yyV1, & yyV2);
# line 526 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_LIST.Next, & yyV3, & yyV4);
# line 527 "BuildTree.puma"
 stats->ACF_LIST.Next = yyV3; 
  }
   * yyP2 = stats;
   * yyP1 = ConcatDecls (yyV2, yyV4);
   return;
 }

  case kACF_EMPTY:
# line 530 "BuildTree.puma"
   * yyP2 = stats;
   * yyP1 = NoTree;
   return;

  case kACF_DO:
# line 533 "BuildTree.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 535 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_DO.DO_BODY, & yyV1, & yyV2);
# line 536 "BuildTree.puma"
 stats->ACF_DO.DO_BODY = yyV1; 
  }
   * yyP2 = stats;
   * yyP1 = yyV2;
   return;
 }

  case kACF_FORALL:
# line 539 "BuildTree.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 541 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_FORALL.FORALL_BODY, & yyV1, & yyV2);
# line 542 "BuildTree.puma"
 stats->ACF_FORALL.FORALL_BODY = yyV1; 
  }
   * yyP2 = stats;
   * yyP1 = yyV2;
   return;
 }

  case kACF_WHILE:
# line 545 "BuildTree.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 547 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_WHILE.WHILE_BODY, & yyV1, & yyV2);
# line 548 "BuildTree.puma"
 stats->ACF_WHILE.WHILE_BODY = yyV1; 
  }
   * yyP2 = stats;
   * yyP1 = yyV2;
   return;
 }

  case kACF_IF:
# line 551 "BuildTree.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 553 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_IF.THEN_PART, & yyV1, & yyV2);
# line 554 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_IF.ELSE_PART, & yyV3, & yyV4);
# line 555 "BuildTree.puma"
 stats->ACF_IF.THEN_PART = yyV1; stats->ACF_IF.ELSE_PART = yyV3; 
  }
   * yyP2 = stats;
   * yyP1 = ConcatDecls (yyV2, yyV4);
   return;
 }

  case kACF_WHERE:
# line 558 "BuildTree.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 560 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_WHERE.TRUE_PART, & yyV1, & yyV2);
# line 561 "BuildTree.puma"
   ExtractSpecifications (stats->ACF_WHERE.FALSE_PART, & yyV3, & yyV4);
# line 562 "BuildTree.puma"
 stats->ACF_WHERE.TRUE_PART = yyV1; stats->ACF_WHERE.FALSE_PART = yyV3; 
  }
   * yyP2 = stats;
   * yyP1 = ConcatDecls (yyV2, yyV4);
   return;
 }

  case kACF_NODE:
  case kACF_DUMMY:
  case kACF_BASIC:
  case kACF_CASE:
  case kACF_REPEAT:
  case kACF_LOOP:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
  case kACF_HOME:
  case kACF_RESIDENT:
  case kACF_NEW:
  case kACF_REDUCTION:
  case kACF_TASK_REGION:
  case kACF_PARALLEL:
  case kACF_CRITICAL:
  case kACF_ON:
  case kACF_RM_READ:
  case kACF_RM_WRITE:
  case kACF_MOVE:
  case kACF_BARRIER:
  case kACF_UPDATE:
# line 565 "BuildTree.puma"
   * yyP2 = stats;
   * yyP1 = NoTree;
   return;

  }

# line 568 "BuildTree.puma"
  {
# line 569 "BuildTree.puma"
   fprintf (stderr, "illegal tree in ExtractSpecifications");
  }
   * yyP2 = stats;
   * yyP1 = NoTree;
   return;

;
}

static bool IsSpecification
# if defined __STDC__ | defined __cplusplus
(register tTree elem)
# else
(elem)
 register tTree elem;
# endif
{
  if (elem->Kind == kDECL_LIST) {
# line 574 "BuildTree.puma"
   return true;

  }
  return false;
}

void LabelForEnd
# if defined __STDC__ | defined __cplusplus
(register tTree body, register int label, register int line)
# else
(body, label, line)
 register tTree body;
 register int label;
 register int line;
# endif
{
# line 597 "BuildTree.puma"
  {
# line 598 "BuildTree.puma"
   if (! ((label == 0))) goto yyL1;
  }
   return;
yyL1:;

  if (body->Kind == kBODY_NODE) {
# line 601 "BuildTree.puma"
 {
  tTree cont;
  {
# line 603 "BuildTree.puma"

# line 605 "BuildTree.puma"
 cont = mACF_DUMMY ();
     cont->ACF_NODE.Label = label;
     cont->ACF_NODE.Line  = line;

     body->BODY_NODE.STATS = AppendStmt (body->BODY_NODE.STATS, cont);
   
  }
   return;
 }

  }
;
}

static tTree AppendStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmtlist, register tTree new)
# else
(stmtlist, new)
 register tTree stmtlist;
 register tTree new;
# endif
{
  if (stmtlist->Kind == kACF_EMPTY) {
# line 615 "BuildTree.puma"
   return mACF_LIST (new, stmtlist);

  }
  if (stmtlist->Kind == kACF_LIST) {
# line 619 "BuildTree.puma"
  {
# line 620 "BuildTree.puma"
 stmtlist->ACF_LIST.Next = AppendStmt (stmtlist->ACF_LIST.Next, new); 
  }
   return stmtlist;

  }
 yyAbort ("AppendStmt");
}

void SetDefinitionLabel
# if defined __STDC__ | defined __cplusplus
(register tTree decls, register int label)
# else
(decls, label)
 register tTree decls;
 register int label;
# endif
{
# line 634 "BuildTree.puma"
  {
# line 635 "BuildTree.puma"
   if (! ((label == 0))) goto yyL1;
  }
   return;
yyL1:;

# line 638 "BuildTree.puma"
  {
# line 639 "BuildTree.puma"
   if (! ((decls == NoTree))) goto yyL2;
  }
   return;
yyL2:;

  if (decls->Kind == kDECL_LIST) {
  if (decls->DECL_LIST.Elem->Kind == kFORMAT_DECL) {
# line 642 "BuildTree.puma"
  {
# line 644 "BuildTree.puma"
   decls->DECL_LIST.Elem->FORMAT_DECL.label = label;
# line 645 "BuildTree.puma"
   SetDefinitionLabel (decls->DECL_LIST.Next, label);
  }
   return;

  }
  }
;
}

void MakePrivateDecls
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 656 "BuildTree.puma"
  {
# line 657 "BuildTree.puma"
   if (! ((t == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kDECL_LIST) {
# line 660 "BuildTree.puma"
  {
# line 661 "BuildTree.puma"
   MakePrivateDecls (t->DECL_LIST.Elem);
# line 662 "BuildTree.puma"
   MakePrivateDecls (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kNAME_DECL) {
# line 665 "BuildTree.puma"
  {
# line 666 "BuildTree.puma"
 t->Kind = kPRIVATE_DECL; 
  }
   return;

  }
;
}

void MakePublicDecls
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 671 "BuildTree.puma"
  {
# line 672 "BuildTree.puma"
   if (! ((t == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kDECL_LIST) {
# line 675 "BuildTree.puma"
  {
# line 676 "BuildTree.puma"
   MakePublicDecls (t->DECL_LIST.Elem);
# line 677 "BuildTree.puma"
   MakePublicDecls (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kNAME_DECL) {
# line 680 "BuildTree.puma"
  {
# line 681 "BuildTree.puma"
 t->Kind = kPUBLIC_DECL; 
  }
   return;

  }
;
}

tTree MakeComplexConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register tTree exp2)
# else
(exp1, exp2)
 register tTree exp1;
 register tTree exp2;
# endif
{
# line 692 "BuildTree.puma"
   return mCOMPLEX_CONSTANT (RealValue (exp1), RealValue (exp2));

}

static tStringRef RealValue
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kCONST_EXP) {
# line 699 "BuildTree.puma"
   return RealValue (exp->CONST_EXP.C);

  }
  if (exp->Kind == kREAL_CONSTANT) {
# line 704 "BuildTree.puma"
   return exp->REAL_CONSTANT.value;

  }
  if (exp->Kind == kINT_CONSTANT) {
# line 709 "BuildTree.puma"
 {
  tStringRef p;
  {
# line 711 "BuildTree.puma"

# line 713 "BuildTree.puma"
 char number[20];
     sprintf (number, "%d", exp->INT_CONSTANT.value);
     p = PutString (number, strlen (number));
   
  }
  {
   return p;
  }
 }

  }
  if (exp->Kind == kOP1_EXP) {
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_PSIGN) {
# line 721 "BuildTree.puma"
   return RealValue (exp->OP1_EXP.OPND);

  }
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 726 "BuildTree.puma"
 {
  tStringRef p;
  {
# line 728 "BuildTree.puma"

# line 730 "BuildTree.puma"
 char number[40], number1[40];
     p = RealValue (exp->OP1_EXP.OPND);
     StGetString (p, number1);
     sprintf (number, "-%s", number1);
     p = PutString (number, strlen (number));
   
  }
  {
   return p;
  }
 }

  }
  }
# line 740 "BuildTree.puma"
  {
# line 742 "BuildTree.puma"
 extern void SourceError();   

     SourceError ("illegal complex constant");
     fprintf (stderr, " (please use unsigned real numbers)\n");
   
  }
   return PutString ("1.0", 3);

}

tTree SetParInfoNew
# if defined __STDC__ | defined __cplusplus
(register tTree info, register tTree new)
# else
(info, new)
 register tTree info;
 register tTree new;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
# line 759 "BuildTree.puma"
  {
# line 761 "BuildTree.puma"
   if (! ((info->PARALLEL_INFO.new_vars == NoTree))) goto yyL1;
  {
# line 763 "BuildTree.puma"
   info->PARALLEL_INFO.new_vars = new;
  }
  }
   return info;
yyL1:;

  }
# line 768 "BuildTree.puma"
   return info;

}

tTree SetParInfoReduction
# if defined __STDC__ | defined __cplusplus
(register tTree info, register tTree new)
# else
(info, new)
 register tTree info;
 register tTree new;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
# line 775 "BuildTree.puma"
  {
# line 777 "BuildTree.puma"
   if (! ((info->PARALLEL_INFO.reduction_vars == NoTree))) goto yyL1;
  {
# line 779 "BuildTree.puma"
   info->PARALLEL_INFO.reduction_vars = new;
  }
  }
   return info;
yyL1:;

  }
# line 784 "BuildTree.puma"
   return info;

}

tTree SetParInfoHome
# if defined __STDC__ | defined __cplusplus
(register tTree info, register tTree home)
# else
(info, home)
 register tTree info;
 register tTree home;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
# line 791 "BuildTree.puma"
  {
# line 793 "BuildTree.puma"
   if (! ((info->PARALLEL_INFO.home_var == NoTree))) goto yyL1;
  {
# line 795 "BuildTree.puma"
   info->PARALLEL_INFO.home_var = home;
  }
  }
   return info;
yyL1:;

  }
# line 800 "BuildTree.puma"
   return info;

}

tTree SetParInfoResident
# if defined __STDC__ | defined __cplusplus
(register tTree info, register tTree res_var)
# else
(info, res_var)
 register tTree info;
 register tTree res_var;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
# line 807 "BuildTree.puma"
  {
# line 809 "BuildTree.puma"
   if (! ((info->PARALLEL_INFO.resident_vars == NoTree))) goto yyL1;
  {
# line 811 "BuildTree.puma"
   info->PARALLEL_INFO.resident_vars = res_var;
  }
  }
   return info;
yyL1:;

  }
# line 816 "BuildTree.puma"
   return info;

}

void SetIndependent
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
# line 832 "BuildTree.puma"
  {
# line 836 "BuildTree.puma"
 loop->ACF_DO.DO_DEP_INFO = mINDEP_INFO (true, 0, NoTree, NoTree); 
  }
   return;

  }
  if (loop->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_BODY->Kind == kACF_LIST) {
  if (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 840 "BuildTree.puma"
  {
# line 844 "BuildTree.puma"
   SetIndependent (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem);
# line 846 "BuildTree.puma"
   goto yyL2;
  }
yyL2:;

  }
  }
  }
# line 849 "BuildTree.puma"
  {
# line 851 "BuildTree.puma"
   if (! ((loop->ACF_FORALL.FORALL_DEP_INFO == NoTree))) goto yyL3;
  {
# line 855 "BuildTree.puma"
 loop->ACF_FORALL.FORALL_DEP_INFO = mINDEP_INFO (true, 0, NoTree, NoTree); 
  }
  }
   return;
yyL3:;

  }
;
}

void SetSerial
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_BODY->Kind == kACF_LIST) {
  if (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 866 "BuildTree.puma"
  {
# line 870 "BuildTree.puma"
   SetSerial (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem);
# line 872 "BuildTree.puma"
   goto yyL1;
  }
yyL1:;

  }
  }
  }
# line 875 "BuildTree.puma"
  {
# line 877 "BuildTree.puma"
   if (! ((loop->ACF_FORALL.FORALL_DEP_INFO == NoTree))) goto yyL2;
  {
# line 879 "BuildTree.puma"
 loop->ACF_FORALL.FORALL_DEP_INFO = mSERIAL_INFO (); 
  }
  }
   return;
yyL2:;

  }
;
}

tTree ApplyParInfo
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree info, register int line)
# else
(stmt, info, line)
 register tTree stmt;
 register tTree info;
 register int line;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
# line 890 "BuildTree.puma"
  {
# line 892 "BuildTree.puma"
   if (! ((info->PARALLEL_INFO.new_vars != NoTree))) goto yyL1;
  {
# line 894 "BuildTree.puma"
   ApplyNewClause (stmt, info->PARALLEL_INFO.new_vars, line);
# line 896 "BuildTree.puma"
 info->PARALLEL_INFO.new_vars = NoTree;    
  }
  }
   return ApplyParInfo (stmt, info, line);
yyL1:;

# line 901 "BuildTree.puma"
  {
# line 903 "BuildTree.puma"
   if (! ((info->PARALLEL_INFO.resident_vars != NoTree))) goto yyL2;
  {
# line 905 "BuildTree.puma"
   ApplyResidentClause (stmt, info->PARALLEL_INFO.resident_vars, line);
# line 907 "BuildTree.puma"
 info->PARALLEL_INFO.resident_vars = NoTree;    
  }
  }
   return ApplyParInfo (stmt, info, line);
yyL2:;

# line 912 "BuildTree.puma"
  {
# line 914 "BuildTree.puma"
   if (! ((info->PARALLEL_INFO.home_var != NoTree))) goto yyL3;
  {
# line 916 "BuildTree.puma"
   ApplyHomeClause (stmt, info->PARALLEL_INFO.home_var, line);
# line 918 "BuildTree.puma"
 info->PARALLEL_INFO.home_var = NoTree;    
  }
  }
   return ApplyParInfo (stmt, info, line);
yyL3:;

# line 923 "BuildTree.puma"
 {
  tTree new;
  tTree h_red_vars;
  {
# line 925 "BuildTree.puma"
   if (! ((info->PARALLEL_INFO.reduction_vars != NoTree))) goto yyL4;
  {
# line 927 "BuildTree.puma"

# line 929 "BuildTree.puma"

# line 931 "BuildTree.puma"
   h_red_vars = info->PARALLEL_INFO.reduction_vars;
# line 932 "BuildTree.puma"
   info->PARALLEL_INFO.reduction_vars = NoTree;
# line 934 "BuildTree.puma"
   new = ApplyParInfo (stmt, info, line);
# line 935 "BuildTree.puma"
   new = mACF_LIST (new, mACF_EMPTY ());
# line 936 "BuildTree.puma"
   new = mACF_REDUCTION (false, h_red_vars, mBTV_EMPTY (), mPROC_OBJ (DefaultId ()), new);
# line 938 "BuildTree.puma"
   SetACFNodeLine (new, line);
# line 939 "BuildTree.puma"
   new = BuildSingleReductions (new);
  }
  }
  {
   return new;
  }
 }
yyL4:;

  }
# line 944 "BuildTree.puma"
   return stmt;

}

void ApplyNewClause
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree new_vars, register int line)
# else
(stmt, new_vars, line)
 register tTree stmt;
 register tTree new_vars;
 register int line;
# endif
{
  if (stmt->Kind == kACF_DO) {
# line 957 "BuildTree.puma"
 {
  tTree help;
  {
# line 959 "BuildTree.puma"

# line 961 "BuildTree.puma"
 help = mACF_NEW (new_vars, stmt->ACF_DO.DO_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_DO.DO_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_HOME) {
# line 967 "BuildTree.puma"
 {
  tTree help;
  {
# line 969 "BuildTree.puma"

# line 971 "BuildTree.puma"
 help = mACF_NEW (new_vars, stmt->ACF_HOME.HOME_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_HOME.HOME_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_FORALL) {
# line 977 "BuildTree.puma"
  {
# line 979 "BuildTree.puma"
   fprintf (stderr, "NEW not allowed for FORALL statement/construct\n");
  }
   return;

  }
;
}

void ApplyResidentClause
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree res_vars, register int line)
# else
(stmt, res_vars, line)
 register tTree stmt;
 register tTree res_vars;
 register int line;
# endif
{
  if (stmt->Kind == kACF_DO) {
# line 992 "BuildTree.puma"
 {
  tTree help;
  {
# line 994 "BuildTree.puma"

# line 996 "BuildTree.puma"
 help = mACF_RESIDENT (res_vars, stmt->ACF_DO.DO_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_DO.DO_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_HOME) {
# line 1002 "BuildTree.puma"
 {
  tTree help;
  {
# line 1004 "BuildTree.puma"

# line 1006 "BuildTree.puma"
 help = mACF_RESIDENT (res_vars, stmt->ACF_HOME.HOME_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_HOME.HOME_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_FORALL) {
# line 1012 "BuildTree.puma"
  {
# line 1014 "BuildTree.puma"
   fprintf (stderr, "RESIDENT not allowed for FORALL statement/construct\n");
  }
   return;

  }
;
}

static void ApplyHomeClause
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree home_var, register int line)
# else
(stmt, home_var, line)
 register tTree stmt;
 register tTree home_var;
 register int line;
# endif
{
  if (stmt->Kind == kACF_DO) {
# line 1027 "BuildTree.puma"
 {
  tTree help;
  {
# line 1029 "BuildTree.puma"

# line 1031 "BuildTree.puma"
 help = mACF_HOME (home_var, true, stmt->ACF_DO.DO_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_DO.DO_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_FORALL) {
# line 1037 "BuildTree.puma"
  {
# line 1039 "BuildTree.puma"
   fprintf (stderr, "HOME not allowed for FORALL statement/construct\n");
  }
   return;

  }
;
}

void SetBody
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree new_body)
# else
(stmt, new_body)
 register tTree stmt;
 register tTree new_body;
# endif
{
  if (stmt->Kind == kACF_LIST) {
  if (stmt->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 1052 "BuildTree.puma"
  {
# line 1054 "BuildTree.puma"
   SetBody (stmt->ACF_LIST.Elem, new_body);
  }
   return;

  }
  }
  if (stmt->Kind == kACF_HOME) {
# line 1057 "BuildTree.puma"
  {
# line 1059 "BuildTree.puma"
   if (! ((stmt->ACF_HOME.HOME_BODY == NoTree))) goto yyL2;
  {
# line 1061 "BuildTree.puma"
 stmt->ACF_HOME.HOME_BODY = new_body; 
  }
  }
   return;
yyL2:;

# line 1064 "BuildTree.puma"
  {
# line 1066 "BuildTree.puma"
   SetBody (stmt->ACF_HOME.HOME_BODY, new_body);
  }
   return;

  }
  if (stmt->Kind == kACF_NEW) {
# line 1069 "BuildTree.puma"
  {
# line 1071 "BuildTree.puma"
   if (! ((stmt->ACF_NEW.NEW_BODY == NoTree))) goto yyL4;
  {
# line 1073 "BuildTree.puma"
 stmt->ACF_NEW.NEW_BODY = new_body; 
  }
  }
   return;
yyL4:;

# line 1076 "BuildTree.puma"
  {
# line 1078 "BuildTree.puma"
   SetBody (stmt->ACF_NEW.NEW_BODY, new_body);
  }
   return;

  }
  if (stmt->Kind == kACF_RESIDENT) {
# line 1081 "BuildTree.puma"
  {
# line 1083 "BuildTree.puma"
   if (! ((stmt->ACF_RESIDENT.RESIDENT_BODY == NoTree))) goto yyL6;
  {
# line 1085 "BuildTree.puma"
 stmt->ACF_RESIDENT.RESIDENT_BODY = new_body; 
  }
  }
   return;
yyL6:;

# line 1088 "BuildTree.puma"
  {
# line 1090 "BuildTree.puma"
   SetBody (stmt->ACF_RESIDENT.RESIDENT_BODY, new_body);
  }
   return;

  }
;
}

void SetProcessorId
# if defined __STDC__ | defined __cplusplus
(register tTree spec, register tTree id)
# else
(spec, id)
 register tTree spec;
 register tTree id;
# endif
{
  if (spec->Kind == kPROCESSOR_ARRAY) {
# line 1101 "BuildTree.puma"
  {
# line 1103 "BuildTree.puma"
 spec->PROCESSOR_ARRAY.TOPNAME = id; 
  }
   return;

  }
  if (spec->Kind == kPROCESSOR_SUBSET) {
# line 1106 "BuildTree.puma"
  {
# line 1108 "BuildTree.puma"
 spec->PROCESSOR_SUBSET.FULLTOP = id; 
     spec->PROCESSOR_SUBSET.SUBTOP  = CopyTree (id); 
   
  }
   return;

  }
;
}

void CheckSameIdent
# if defined __STDC__ | defined __cplusplus
(register tIdent id1, register tIdent id2)
# else
(id1, id2)
 register tIdent id1;
 register tIdent id2;
# endif
{
# line 1121 "BuildTree.puma"
  {
# line 1123 "BuildTree.puma"
   if (! ((id2 == DefaultId ()))) goto yyL1;
  }
   return;
yyL1:;

# line 1126 "BuildTree.puma"
  {
# line 1128 "BuildTree.puma"
   if (! ((id1 == id2))) goto yyL2;
  }
   return;
yyL2:;

# line 1131 "BuildTree.puma"
  {
# line 1133 "BuildTree.puma"
 char name1[100], name2[100], msg[200];

    GetString (id1, name1);
    GetString (id2, name2);

    sprintf (msg, "illegal nesting : ... %s   END %s", name1, name2);

    BuildTreeError (msg);
  
  }
   return;

;
}

void SetMapKind
# if defined __STDC__ | defined __cplusplus
(register int kind, register tStringRef val, register tTree decls)
# else
(kind, val, decls)
 register int kind;
 register tStringRef val;
 register tTree decls;
# endif
{
# line 1155 "BuildTree.puma"
  {
# line 1157 "BuildTree.puma"
   if (! ((decls == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (decls->Kind == kDECL_LIST) {
# line 1160 "BuildTree.puma"
  {
# line 1162 "BuildTree.puma"
   SetMapKind (kind, val, decls->DECL_LIST.Elem);
# line 1163 "BuildTree.puma"
   SetMapKind (kind, val, decls->DECL_LIST.Next);
  }
   return;

  }
  if (decls->Kind == kMAP_TO_DECL) {
# line 1166 "BuildTree.puma"
  {
# line 1168 "BuildTree.puma"
 decls->MAP_TO_DECL.kind = val;
     decls->Kind = kind;
   
  }
   return;

  }
;
}

tTree BuildSingleReductions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_REDUCTION) {
  if (t->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (t->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_LIST) {
# line 1188 "BuildTree.puma"
 {
  tTree new_body;
  {
# line 1193 "BuildTree.puma"

# line 1195 "BuildTree.puma"
 new_body = mACF_REDUCTION (t->ACF_REDUCTION.is_zero, t->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next, mBTV_EMPTY (),
                                mPROC_OBJ (DefaultId()), t->ACF_REDUCTION.REDUCTION_BODY);
     SetACFNodeLine (new_body, t->ACF_REDUCTION.Line);
     new_body = BuildSingleReductions (new_body);
     new_body = mACF_LIST (new_body, mACF_EMPTY ());
     t->ACF_REDUCTION.REDUCTION_BODY     = new_body;
     t->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next     = mBTV_EMPTY ();
   
  }
  {
   return t;
  }
 }

  }
  }
  }
# line 1207 "BuildTree.puma"
   return t;

}

void SpreadSelection
# if defined __STDC__ | defined __cplusplus
(register tTree selectees, register tTree selections)
# else
(selectees, selections)
 register tTree selectees;
 register tTree selections;
# endif
{
  if (selectees->Kind == kDECL_LIST) {
  if (selectees->DECL_LIST.Elem->Kind == kSELECT_DECL) {
# line 1222 "BuildTree.puma"
  {
# line 1224 "BuildTree.puma"
   if (! ((selectees->DECL_LIST.Next == NoTree))) goto yyL1;
  {
# line 1226 "BuildTree.puma"
 selectees->DECL_LIST.Elem->SELECT_DECL.SELECTIONS = selections; 
  }
  }
   return;
yyL1:;

# line 1229 "BuildTree.puma"
  {
# line 1231 "BuildTree.puma"
 selectees->DECL_LIST.Elem->SELECT_DECL.SELECTIONS = CopyTree (selections); 
# line 1233 "BuildTree.puma"
   SpreadSelection (selectees->DECL_LIST.Next, selections);
  }
   return;

  }
  }
# line 1236 "BuildTree.puma"
  {
# line 1238 "BuildTree.puma"
   BuildTreeError ("SpreadSelection fails");
  }
   return;

;
}

tIdent DecodeExtrinsic
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
# line 1251 "BuildTree.puma"
  {
# line 1253 "BuildTree.puma"
   if (! ((kind & LANGUAGE_HPF))) goto yyL1;
  {
# line 1254 "BuildTree.puma"
   if (! ((kind & MODEL_GLOBAL))) goto yyL1;
  }
  }
   return IsIdent ("HPF_GLOBAL");
yyL1:;

# line 1259 "BuildTree.puma"
  {
# line 1261 "BuildTree.puma"
   if (! ((kind & LANGUAGE_HPF))) goto yyL2;
  {
# line 1262 "BuildTree.puma"
   if (! ((kind & MODEL_LOCAL))) goto yyL2;
  }
  }
   return IsIdent ("HPF_LOCAL");
yyL2:;

# line 1267 "BuildTree.puma"
  {
# line 1269 "BuildTree.puma"
   if (! ((kind & LANGUAGE_HPF))) goto yyL3;
  {
# line 1270 "BuildTree.puma"
   if (! ((kind & MODEL_SERIAL))) goto yyL3;
  }
  }
   return IsIdent ("HPF_SERIAL");
yyL3:;

# line 1275 "BuildTree.puma"
  {
# line 1277 "BuildTree.puma"
   if (! ((kind & LANGUAGE_HPF))) goto yyL4;
  }
   return IsIdent ("HPF_GLOBAL");
yyL4:;

# line 1282 "BuildTree.puma"
  {
# line 1284 "BuildTree.puma"
   if (! ((kind & LANGUAGE_F77))) goto yyL5;
  {
# line 1285 "BuildTree.puma"
   if (! ((kind & MODEL_LOCAL))) goto yyL5;
  }
  }
   return IsIdent ("F77_LOCAL");
yyL5:;

# line 1290 "BuildTree.puma"
  {
# line 1292 "BuildTree.puma"
   if (! ((kind & LANGUAGE_F77))) goto yyL6;
  {
# line 1293 "BuildTree.puma"
   if (! ((kind & MODEL_SERIAL))) goto yyL6;
  }
  }
   return IsIdent ("F77_SERIAL");
yyL6:;

# line 1298 "BuildTree.puma"
  {
# line 1300 "BuildTree.puma"
   if (! ((kind & LANGUAGE_F77))) goto yyL7;
  }
   return IsIdent ("F77_SERIAL");
yyL7:;

# line 1305 "BuildTree.puma"
   return IsIdent ("UNKNOWN");

}

int CodeExtrinsic
# if defined __STDC__ | defined __cplusplus
(register tStringRef t)
# else
(t)
 register tStringRef t;
# endif
{
# line 1320 "BuildTree.puma"

char name[60], msg[100];
int i, len;
int kind;

# line 1326 "BuildTree.puma"
  {
# line 1328 "BuildTree.puma"
 StGetString (t, name);
     len = strlen (name);

     

     for (i=0; i<len; i++) name[i] = toupper(name[i]);

     kind = 0;

     if (strcmp (name, "HPF") == 0) kind = LANGUAGE_HPF;
     if (strcmp (name, "F77") == 0) kind = LANGUAGE_F77;

     if (strcmp (name, "LOCAL") == 0)  kind = MODEL_LOCAL;
     if (strcmp (name, "SERIAL") == 0) kind = MODEL_SERIAL;
     if (strcmp (name, "GLOBAL") == 0) kind = MODEL_GLOBAL;

     if (kind == 0)
 
        { sprintf (msg, "%s is unknown EXTRINISC specification", name);
          BuildTreeError (msg);
        }

   
  }
   return kind;

}

int CodeExtrinsic1
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tStringRef t)
# else
(id, t)
 register tIdent id;
 register tStringRef t;
# endif
{
# line 1366 "BuildTree.puma"
   return CodeExtrinsic (t);

}

int MixExtrinsic
# if defined __STDC__ | defined __cplusplus
(register int kind1, register int kind2)
# else
(kind1, kind2)
 register int kind1;
 register int kind2;
# endif
{
# line 1381 "BuildTree.puma"
   return (kind1 | kind2);

}

void BeginBuildTree ()
{
}

void CloseBuildTree ()
{
}
