# include "Barriers.h"
# include "yyBarriers.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 29 "Barriers.puma"


# define MODULE "Barriers"

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Types.h"
# include "Transform.h"       /* CompleteBTVs */
# include "Distributions.h"



static void yyExit () { Exit (1); }

void (* Barriers_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Barriers, routine %s failed\n", yyFunction);
 Barriers_Exit ();
}

tTree GetBarriers ARGS((tTree stmt));
tTree GetUpdates ARGS((tTree stmt));
static tTree GetSharedWriteAccesses ARGS((tTree stmt, tTree varlist));
static tTree GetSharedVars ARGS((tTree var, tTree varlist));
static tTree SpecWriteAccesses ARGS((tTree p, tTree varlist));
static tTree MergeVars ARGS((tTree var, tTree varlist));
static tTree GetTracedUpdates ARGS((tTree stmt, tTree varlist));
static tTree GetTracedVars ARGS((tTree var, tTree varlist));

tTree GetBarriers
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
# line 52 "Barriers.puma"
 {
  tTree write_vars;
  {
# line 54 "Barriers.puma"

# line 56 "Barriers.puma"
 write_vars = NoTree;
     write_vars = GetSharedWriteAccesses (stmt, write_vars);
     if (write_vars != NoTree)
        write_vars = mACF_BARRIER (CompleteBTVs(write_vars));
   
  }
  {
   return write_vars;
  }
 }

}

tTree GetUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
# line 67 "Barriers.puma"
 {
  tTree trace_vars;
  {
# line 69 "Barriers.puma"

# line 71 "Barriers.puma"
 trace_vars = NoTree;
     trace_vars = GetTracedUpdates (stmt, trace_vars);
     if (trace_vars != NoTree)
        trace_vars = mACF_BASIC (mDIRTY_STMT (CompleteBTVs(trace_vars)));
   
  }
  {
   return trace_vars;
  }
 }

}

static tTree GetSharedWriteAccesses
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree varlist)
# else
(stmt, varlist)
 register tTree stmt;
 register tTree varlist;
# endif
{

  switch (stmt->Kind) {
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 97 "Barriers.puma"
   return GetSharedVars (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, varlist);

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 108 "Barriers.puma"
  {
# line 110 "Barriers.puma"
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == MakeIdent ("READ", 4)))) goto yyL2;
  }
   return GetSharedVars (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, varlist);
yyL2:;

# line 121 "Barriers.puma"
   return varlist;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 132 "Barriers.puma"
   return GetSharedVars (stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, varlist);

  }
# line 137 "Barriers.puma"
   return varlist;

  case kACF_ON:
# line 141 "Barriers.puma"
   return GetSharedWriteAccesses (stmt->ACF_ON.ON_BODY, varlist);

  case kACF_TASK_REGION:
# line 146 "Barriers.puma"
   return GetSharedWriteAccesses (stmt->ACF_TASK_REGION.TASK_BODY, varlist);

  case kACF_PARALLEL:
# line 151 "Barriers.puma"
   return GetSharedWriteAccesses (stmt->ACF_PARALLEL.PARALLEL_BODY, varlist);

  case kACF_LIST:
# line 156 "Barriers.puma"
   return GetSharedWriteAccesses (stmt->ACF_LIST.Elem, GetSharedWriteAccesses (stmt->ACF_LIST.Next, varlist));

  case kACF_EMPTY:
# line 161 "Barriers.puma"
   return varlist;

  case kACF_DUMMY:
# line 165 "Barriers.puma"
   return varlist;

  case kACF_IF:
# line 169 "Barriers.puma"
   return GetSharedWriteAccesses (stmt->ACF_IF.THEN_PART, GetSharedWriteAccesses (stmt->ACF_IF.ELSE_PART, varlist));

  case kACF_WHILE:
# line 175 "Barriers.puma"
   return GetSharedWriteAccesses (stmt->ACF_WHILE.WHILE_BODY, varlist);

  case kACF_HOME:
# line 180 "Barriers.puma"
   return GetSharedWriteAccesses (stmt->ACF_HOME.HOME_BODY, varlist);

  case kACF_DO:
# line 185 "Barriers.puma"
   return GetSharedWriteAccesses (stmt->ACF_DO.DO_BODY, varlist);

  }

# line 190 "Barriers.puma"
  {
# line 191 "Barriers.puma"
   failure_protocol (MODULE, "GetSharedWriteAccesses", stmt);
  }
   return varlist;

}

static tTree GetSharedVars
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree varlist)
# else
(var, varlist)
 register tTree var;
 register tTree varlist;
# endif
{

  switch (var->Kind) {
  case kUSED_VAR:
# line 203 "Barriers.puma"
  {
# line 205 "Barriers.puma"
   if (! ((TreeWriteDistribution (var) == 2))) goto yyL1;
  }
   return MergeVars (var, varlist);
yyL1:;

  break;
  case kINDEXED_VAR:
# line 209 "Barriers.puma"
   return GetSharedVars (var->INDEXED_VAR.IND_VAR, varlist);

  case kBTP_LIST:
# line 214 "Barriers.puma"
   return GetSharedVars (var->BTP_LIST.Elem, GetSharedVars (var->BTP_LIST.Next, varlist));

  case kBTP_EMPTY:
# line 219 "Barriers.puma"
   return varlist;

  case kVAR_PARAM:
  if (var->VAR_PARAM.V->Kind == kADDR) {
# line 223 "Barriers.puma"
   return varlist;

  }
# line 228 "Barriers.puma"
   return GetSharedVars (var->VAR_PARAM.V, varlist);

  case kDO_VAR:
# line 233 "Barriers.puma"
   return GetSharedVars (var->DO_VAR.BODY, varlist);

  case kBTV_LIST:
# line 237 "Barriers.puma"
   return GetSharedVars (var->BTV_LIST.Elem, GetSharedVars (var->BTV_LIST.Next, varlist));

  case kBTV_EMPTY:
# line 242 "Barriers.puma"
   return varlist;

  }

# line 246 "Barriers.puma"
   return varlist;

}

static tTree SpecWriteAccesses
# if defined __STDC__ | defined __cplusplus
(register tTree p, register tTree varlist)
# else
(p, varlist)
 register tTree p;
 register tTree varlist;
# endif
{
  if (p->Kind == kBTP_LIST) {
# line 258 "Barriers.puma"
   return SpecWriteAccesses (p->BTP_LIST.Elem, SpecWriteAccesses (p->BTP_LIST.Next, varlist));

  }
  if (p->Kind == kBTP_EMPTY) {
# line 264 "Barriers.puma"
   return varlist;

  }
  if (p->Kind == kNAMED_PARAM) {
# line 268 "Barriers.puma"
  {
# line 270 "Barriers.puma"
   if (! (((p->NAMED_PARAM.Name == MakeIdent ("EXISTS", 6)) || (p->NAMED_PARAM.Name == MakeIdent ("IOSTAT", 6))))) goto yyL3;
  }
   return GetSharedVars (p->NAMED_PARAM.VAL, varlist);
yyL3:;

# line 276 "Barriers.puma"
   return varlist;

  }
  if (p->Kind == kVAR_PARAM) {
  if (p->VAR_PARAM.V->Kind == kUSED_VAR) {
  if (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kNameListObject) {
  if (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->NameListObject.decl->Kind == kNAMELIST_DECL) {
# line 280 "Barriers.puma"
   return varlist;

  }
  }
  }
# line 287 "Barriers.puma"
   return varlist;

  }
# line 291 "Barriers.puma"
  {
# line 292 "Barriers.puma"
   failure_protocol (MODULE, "SpecWriteAccesses", p);
  }
   return varlist;

}

static tTree MergeVars
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree varlist)
# else
(var, varlist)
 register tTree var;
 register tTree varlist;
# endif
{
# line 306 "Barriers.puma"
  {
# line 307 "Barriers.puma"
   if (! ((varlist == NoTree))) goto yyL1;
  }
   return mBTV_LIST (var, varlist);
yyL1:;

  if (varlist->Kind == kBTV_LIST) {
# line 311 "Barriers.puma"
  {
# line 312 "Barriers.puma"
 varlist->BTV_LIST.Next = MergeVars (var, varlist->BTV_LIST.Next); 
  }
   return varlist;

  }
 yyAbort ("MergeVars");
}

static tTree GetTracedUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree varlist)
# else
(stmt, varlist)
 register tTree stmt;
 register tTree varlist;
# endif
{

  switch (stmt->Kind) {
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 333 "Barriers.puma"
   return GetTracedVars (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, varlist);

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 344 "Barriers.puma"
  {
# line 346 "Barriers.puma"
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == MakeIdent ("READ", 4)))) goto yyL2;
  }
   return GetTracedVars (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, varlist);
yyL2:;

# line 357 "Barriers.puma"
   return varlist;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 368 "Barriers.puma"
   return GetTracedVars (stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, varlist);

  }
# line 373 "Barriers.puma"
   return varlist;

  case kACF_ON:
# line 377 "Barriers.puma"
   return GetTracedUpdates (stmt->ACF_ON.ON_BODY, varlist);

  case kACF_TASK_REGION:
# line 382 "Barriers.puma"
   return GetTracedUpdates (stmt->ACF_TASK_REGION.TASK_BODY, varlist);

  case kACF_PARALLEL:
# line 387 "Barriers.puma"
   return GetTracedUpdates (stmt->ACF_PARALLEL.PARALLEL_BODY, varlist);

  case kACF_LIST:
# line 392 "Barriers.puma"
   return GetTracedUpdates (stmt->ACF_LIST.Elem, GetTracedUpdates (stmt->ACF_LIST.Next, varlist));

  case kACF_EMPTY:
# line 397 "Barriers.puma"
   return varlist;

  case kACF_DUMMY:
# line 401 "Barriers.puma"
   return varlist;

  case kACF_IF:
# line 405 "Barriers.puma"
   return GetTracedUpdates (stmt->ACF_IF.THEN_PART, GetTracedUpdates (stmt->ACF_IF.ELSE_PART, varlist));

  case kACF_WHILE:
# line 411 "Barriers.puma"
   return GetTracedUpdates (stmt->ACF_WHILE.WHILE_BODY, varlist);

  case kACF_HOME:
# line 416 "Barriers.puma"
   return GetTracedUpdates (stmt->ACF_HOME.HOME_BODY, varlist);

  case kACF_DO:
# line 421 "Barriers.puma"
   return GetTracedUpdates (stmt->ACF_DO.DO_BODY, varlist);

  }

# line 426 "Barriers.puma"
  {
# line 427 "Barriers.puma"
   failure_protocol (MODULE, "GetTracedUpdates", stmt);
  }
   return varlist;

}

static tTree GetTracedVars
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree varlist)
# else
(var, varlist)
 register tTree var;
 register tTree varlist;
# endif
{

  switch (var->Kind) {
  case kUSED_VAR:
  if (var->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kVarObject) {
# line 439 "Barriers.puma"
  {
# line 441 "Barriers.puma"
   if (! ((var->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.trace))) goto yyL1;
  }
   return MergeVars (var, varlist);
yyL1:;

  }
  break;
  case kINDEXED_VAR:
# line 446 "Barriers.puma"
   return GetTracedVars (var->INDEXED_VAR.IND_VAR, varlist);

  case kBTP_LIST:
# line 451 "Barriers.puma"
   return GetTracedVars (var->BTP_LIST.Elem, GetTracedVars (var->BTP_LIST.Next, varlist));

  case kBTP_EMPTY:
# line 456 "Barriers.puma"
   return varlist;

  case kVAR_PARAM:
  if (var->VAR_PARAM.V->Kind == kADDR) {
# line 461 "Barriers.puma"
   return varlist;

  }
# line 466 "Barriers.puma"
  {
# line 468 "Barriers.puma"
   if (! ((var->VAR_PARAM.intent == IntentIn))) goto yyL6;
  }
   return varlist;
yyL6:;

# line 473 "Barriers.puma"
  {
# line 475 "Barriers.puma"
   if (! ((var->VAR_PARAM.trace))) goto yyL7;
  }
   return varlist;
yyL7:;

# line 480 "Barriers.puma"
   return GetTracedVars (var->VAR_PARAM.V, varlist);

  case kDO_VAR:
# line 485 "Barriers.puma"
   return GetTracedVars (var->DO_VAR.BODY, varlist);

  case kBTV_LIST:
# line 490 "Barriers.puma"
   return GetTracedVars (var->BTV_LIST.Elem, GetTracedVars (var->BTV_LIST.Next, varlist));

  case kBTV_EMPTY:
# line 495 "Barriers.puma"
   return varlist;

  }

# line 499 "Barriers.puma"
   return varlist;

}

void BeginBarriers ()
{
}

void CloseBarriers ()
{
}
