# include "ArrayData.h"
# include "yyArrayData.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 24 "ArrayData.puma"


# define MODULE "ArrayData"

# include "protocol.h"

# include "Types.h"   /* ArrayFormals */
# include "Expressions.h"



static void yyExit () { Exit (1); }

void (* ArrayData_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ArrayData, routine %s failed\n", yyFunction);
 ArrayData_Exit ();
}

void SetActualData ARGS((tTree stmt));
void SetActualOverlap ARGS((tTree stmt));
static void ResetValidOverlap ARGS((tTree formals));
static void SetValidOverlap ARGS((tTree formals, tTree size));

void SetActualData
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
# line 43 "ArrayData.puma"
  {
# line 45 "ArrayData.puma"
   SetActualData (stmt->ACF_BASIC.BASIC_STMT);
  }
   return;

  }
  if (stmt->Kind == kREG_SHADOW_GET) {
# line 48 "ArrayData.puma"
  {
# line 50 "ArrayData.puma"
   SetActualOverlap (stmt);
  }
   return;

  }
;
}

void SetActualOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kREG_SHADOW_GET) {
  if (stmt->REG_SHADOW_GET.SHADOW_VAR->Kind == kUSED_VAR) {
  if (stmt->REG_SHADOW_GET.SHADOW_SIZE->Kind == kBTE_EMPTY) {
# line 64 "ArrayData.puma"
  {
# line 65 "ArrayData.puma"
   ResetValidOverlap (ArrayFormals (stmt->REG_SHADOW_GET.SHADOW_VAR->USED_VAR.VARNAME->VAR_OBJ.Object));
  }
   return;

  }
  }
  if (stmt->REG_SHADOW_GET.SHADOW_VAR->Kind == kINDEXED_VAR) {
  if (stmt->REG_SHADOW_GET.SHADOW_VAR->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 68 "ArrayData.puma"
  {
# line 69 "ArrayData.puma"
   SetValidOverlap (ArrayFormals (stmt->REG_SHADOW_GET.SHADOW_VAR->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object), stmt->REG_SHADOW_GET.SHADOW_SIZE);
  }
   return;

  }
  }
  }
# line 72 "ArrayData.puma"
  {
# line 73 "ArrayData.puma"
   failure_protocol (MODULE, "SetActualOverlap", stmt);
  }
   return;

;
}

static void ResetValidOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
  if (formals->Kind == kSHAPE_EMPTY) {
# line 78 "ArrayData.puma"
   return;

  }
  if (formals->Kind == kSHAPE_LIST) {
# line 81 "ArrayData.puma"
  {
# line 82 "ArrayData.puma"
   ResetValidOverlap (formals->SHAPE_LIST.Elem);
# line 83 "ArrayData.puma"
   ResetValidOverlap (formals->SHAPE_LIST.Next);
  }
   return;

  }
  if (Tree_IsType (formals, kSHAPE_SPEC)) {
# line 86 "ArrayData.puma"
  {
# line 87 "ArrayData.puma"
   ResetValidOverlap (formals->SHAPE_SPEC.Overlap);
  }
   return;

  }
  if (formals->Kind == kOVERLAP_SPEC) {
# line 90 "ArrayData.puma"
  {
# line 91 "ArrayData.puma"
 formals->OVERLAP_SPEC.left_update = 0;
     formals->OVERLAP_SPEC.right_update = 0;
   
  }
   return;

  }
# line 96 "ArrayData.puma"
  {
# line 97 "ArrayData.puma"
   failure_protocol (MODULE, "ResetValidOverlap", formals);
  }
   return;

;
}

static void SetValidOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree size)
# else
(formals, size)
 register tTree formals;
 register tTree size;
# endif
{
  if (formals->Kind == kSHAPE_EMPTY) {
  if (size->Kind == kBTE_EMPTY) {
# line 102 "ArrayData.puma"
   return;

  }
  }
  if (formals->Kind == kSHAPE_LIST) {
  if (size->Kind == kBTE_LIST) {
# line 105 "ArrayData.puma"
  {
# line 106 "ArrayData.puma"
   SetValidOverlap (formals->SHAPE_LIST.Elem, size->BTE_LIST.Elem);
# line 107 "ArrayData.puma"
   SetValidOverlap (formals->SHAPE_LIST.Next, size->BTE_LIST.Next);
  }
   return;

  }
  }
  if (Tree_IsType (formals, kSHAPE_SPEC)) {
# line 110 "ArrayData.puma"
  {
# line 111 "ArrayData.puma"
   SetValidOverlap (formals->SHAPE_SPEC.Overlap, size);
  }
   return;

  }
  if (formals->Kind == kOVERLAP_SPEC) {
  if (size->Kind == kSLICE_EXP) {
# line 114 "ArrayData.puma"
 {
  bool found;
  int val;
  {
# line 116 "ArrayData.puma"

# line 117 "ArrayData.puma"

# line 119 "ArrayData.puma"
   GetIntConstValue (size->SLICE_EXP.START, & found, & val);
# line 120 "ArrayData.puma"
   if (! ((found))) goto yyL4;
  {
# line 121 "ArrayData.puma"
 if (val>formals->OVERLAP_SPEC.left_update) formals->OVERLAP_SPEC.left_update = val; 
# line 123 "ArrayData.puma"
   GetIntConstValue (size->SLICE_EXP.STOP, & found, & val);
# line 124 "ArrayData.puma"
   if (! ((found))) goto yyL4;
  {
# line 125 "ArrayData.puma"
 if (val>formals->OVERLAP_SPEC.right_update) formals->OVERLAP_SPEC.right_update = val; 
  }
  }
  }
   return;
 }
yyL4:;

  }
  }
# line 128 "ArrayData.puma"
  {
# line 129 "ArrayData.puma"
   failure2_protocol (MODULE, "SetValidOverlap", formals, size);
  }
   return;

;
}

void BeginArrayData ()
{
}

void CloseArrayData ()
{
}
