# include "AnaOverlap.h"
# include "yyAnaOverlap.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 33 "AnaOverlap.puma"


# define MODULE "AnaOverlap"

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Types.h"
# include "Transform.h"             /* ReplaceACF       */
# include "Expressions.h"           /* MakeConstant     */

# include "Traverse.h"              /* FullTraverseAST  */

# include "MoveControl.h"           /* GetShifting, ... */
# include "Rank.h"
# include "Objects.h"
# include "Nesting.h"
# include "Intrinsics.h"

# include "OverlapUpdate.h"         /* SetOverlapUpdate, ... */

/*********************************************************************
*                                                                    * 
*    global variable for a WHERE statement                           *
*                                                                    * 
*    - necessary as overlapping is not possible for                  * 
*      variables updated inside the where body                       * 
*                                                                    * 
*********************************************************************/

static tTree global_where_stmt = NoTree;



static void yyExit () { Exit (1); }

void (* AnaOverlap_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AnaOverlap, routine %s failed\n", yyFunction);
 AnaOverlap_Exit ();
}

void OverlapAnalysis ARGS((tTree t));
static void DetermineOverlapSize ARGS((tTree t));
static void CheckForMaskOverlap ARGS((tTree stmt, tTree mask));
static void CheckForOverlap ARGS((tTree var, tTree exp));
static void CheckIndexOverlap ARGS((tTree owner, tTree var));
static void CheckForVarOverlap ARGS((tTree left_var, tTree right_var));
static void CheckCShiftOverlap ARGS((tTree exp));
static void UpdateOverlapArea ARGS((tTree var, pshift pos));
static void PrintNewVarDecl ARGS((tDefinitions obj));
static void SetVarOverlap ARGS((tTree indexes, int dim, pshift pos));
static void SetOverlapIndex ARGS((tTree index, int pos));

void OverlapAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 82 "AnaOverlap.puma"
  {
# line 84 "AnaOverlap.puma"
   open_protocol ("adaptor.ovl");
# line 85 "AnaOverlap.puma"
   OverlapAnalysis (t->COMP_UNIT.COMP_ELEMENTS);
# line 86 "AnaOverlap.puma"
   close_protocol ();
  }
   return;

  case kUNIT_EMPTY:
# line 89 "AnaOverlap.puma"
   return;

  case kUNIT_LIST:
# line 92 "AnaOverlap.puma"
  {
# line 93 "AnaOverlap.puma"
   OverlapAnalysis (t->UNIT_LIST.Elem);
# line 94 "AnaOverlap.puma"
   OverlapAnalysis (t->UNIT_LIST.Next);
  }
   return;

  case kPROGRAM_DECL:
# line 105 "AnaOverlap.puma"
  {
# line 107 "AnaOverlap.puma"
   NestOpenUnit (t);
# line 108 "AnaOverlap.puma"
   OverlapAnalysis (t->PROGRAM_DECL.PROGRAM_BODY);
# line 109 "AnaOverlap.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 112 "AnaOverlap.puma"
  {
# line 114 "AnaOverlap.puma"
   NestOpenUnit (t);
# line 115 "AnaOverlap.puma"
   OverlapAnalysis (t->PROC_DECL.PROC_BODY);
# line 116 "AnaOverlap.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 119 "AnaOverlap.puma"
  {
# line 121 "AnaOverlap.puma"
   NestOpenUnit (t);
# line 122 "AnaOverlap.puma"
   OverlapAnalysis (t->FUNC_DECL.FUNC_BODY);
# line 123 "AnaOverlap.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 126 "AnaOverlap.puma"
  {
# line 128 "AnaOverlap.puma"
   NestOpenUnit (t);
# line 129 "AnaOverlap.puma"
   OverlapAnalysis (t->BLOCK_DATA_DECL.DATA_BODY);
# line 130 "AnaOverlap.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 133 "AnaOverlap.puma"
  {
# line 135 "AnaOverlap.puma"
   NestOpenUnit (t);
# line 136 "AnaOverlap.puma"
   OverlapAnalysis (t->MODULE_DECL.MODULE_BODY);
# line 137 "AnaOverlap.puma"
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
# line 140 "AnaOverlap.puma"
  {
# line 142 "AnaOverlap.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

# line 145 "AnaOverlap.puma"
  {
# line 147 "AnaOverlap.puma"
   if (! ((optimization == 0))) goto yyL10;
  }
   return;
yyL10:;

# line 150 "AnaOverlap.puma"
  {
# line 152 "AnaOverlap.puma"
   FullTraverseAST (t, DetermineOverlapSize);
  }
   return;

  }

# line 155 "AnaOverlap.puma"
  {
# line 156 "AnaOverlap.puma"
   failure_protocol (MODULE, "OverlapAnalysis", t);
  }
   return;

;
}

static void DetermineOverlapSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kASSIGN_STMT) {
# line 175 "AnaOverlap.puma"
  {
# line 177 "AnaOverlap.puma"
   CheckForOverlap (t->ASSIGN_STMT.ASSIGN_VAR, t->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  }
  if (t->Kind == kACF_WHERE) {
# line 180 "AnaOverlap.puma"
  {
# line 182 "AnaOverlap.puma"
   CheckForMaskOverlap (t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.WHERE_EXP);
# line 183 "AnaOverlap.puma"
   CheckForMaskOverlap (t->ACF_WHERE.FALSE_PART, t->ACF_WHERE.WHERE_EXP);
  }
   return;

  }
  if (t->Kind == kACF_IF) {
# line 186 "AnaOverlap.puma"
  {
# line 188 "AnaOverlap.puma"
   CheckForMaskOverlap (t->ACF_IF.THEN_PART, t->ACF_IF.IF_EXP);
# line 189 "AnaOverlap.puma"
   CheckForMaskOverlap (t->ACF_IF.ELSE_PART, t->ACF_IF.IF_EXP);
  }
   return;

  }
;
}

static void CheckForMaskOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree mask)
# else
(stmt, mask)
 register tTree stmt;
 register tTree mask;
# endif
{
  if (stmt->Kind == kACF_EMPTY) {
# line 206 "AnaOverlap.puma"
   return;

  }
  if (stmt->Kind == kACF_LIST) {
# line 209 "AnaOverlap.puma"
  {
# line 211 "AnaOverlap.puma"
   CheckForMaskOverlap (stmt->ACF_LIST.Elem, mask);
# line 212 "AnaOverlap.puma"
   CheckForMaskOverlap (stmt->ACF_LIST.Next, mask);
  }
   return;

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 215 "AnaOverlap.puma"
  {
# line 217 "AnaOverlap.puma"
   CheckForOverlap (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, mask);
  }
   return;

  }
  }
  if (stmt->Kind == kACF_WHERE) {
# line 220 "AnaOverlap.puma"
  {
# line 222 "AnaOverlap.puma"
   CheckForMaskOverlap (stmt->ACF_WHERE.TRUE_PART, mask);
# line 223 "AnaOverlap.puma"
   CheckForMaskOverlap (stmt->ACF_WHERE.FALSE_PART, mask);
  }
   return;

  }
  if (stmt->Kind == kACF_IF) {
# line 226 "AnaOverlap.puma"
  {
# line 228 "AnaOverlap.puma"
   CheckForMaskOverlap (stmt->ACF_IF.THEN_PART, mask);
# line 229 "AnaOverlap.puma"
   CheckForMaskOverlap (stmt->ACF_IF.ELSE_PART, mask);
  }
   return;

  }
;
}

static void CheckForOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kDUMMY_EXP:
# line 242 "AnaOverlap.puma"
   return;

  case kCONST_EXP:
# line 245 "AnaOverlap.puma"
   return;

  case kARRAY_EXP:
# line 248 "AnaOverlap.puma"
   return;

  case kBOUND_EXP:
# line 251 "AnaOverlap.puma"
   return;

  case kTYPE_EXP:
# line 254 "AnaOverlap.puma"
   return;

  case kSLICE_EXP:
# line 257 "AnaOverlap.puma"
   return;

  case kOP_EXP:
# line 260 "AnaOverlap.puma"
  {
# line 261 "AnaOverlap.puma"
   CheckForOverlap (var, exp->OP_EXP.OPND1);
# line 262 "AnaOverlap.puma"
   CheckForOverlap (var, exp->OP_EXP.OPND2);
  }
   return;

  case kOP1_EXP:
# line 265 "AnaOverlap.puma"
  {
# line 266 "AnaOverlap.puma"
   CheckForOverlap (var, exp->OP1_EXP.OPND);
  }
   return;

  case kPERM_EXP:
# line 269 "AnaOverlap.puma"
   return;

  case kVAR_EXP:
# line 272 "AnaOverlap.puma"
  {
# line 273 "AnaOverlap.puma"
   CheckForVarOverlap (var, exp->VAR_EXP.V);
# line 274 "AnaOverlap.puma"
   CheckIndexOverlap (var, exp->VAR_EXP.V);
  }
   return;

  case kFUNC_CALL_EXP:
# line 277 "AnaOverlap.puma"
  {
# line 278 "AnaOverlap.puma"
   if (! ((IsIntrCall (exp)))) goto yyL11;
  {
# line 279 "AnaOverlap.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("CSHIFT", 6)))) goto yyL11;
  {
# line 280 "AnaOverlap.puma"
   CheckCShiftOverlap (exp);
  }
  }
  }
   return;
yyL11:;

# line 283 "AnaOverlap.puma"
  {
# line 284 "AnaOverlap.puma"
   if (! ((IsIntrCall (exp)))) goto yyL12;
  {
# line 285 "AnaOverlap.puma"
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL12;
  {
# line 286 "AnaOverlap.puma"
   CheckForOverlap (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
  }
   return;
yyL12:;

# line 289 "AnaOverlap.puma"
   return;

  case kBTP_LIST:
# line 293 "AnaOverlap.puma"
  {
# line 294 "AnaOverlap.puma"
   CheckForOverlap (var, exp->BTP_LIST.Elem);
# line 295 "AnaOverlap.puma"
   CheckForOverlap (var, exp->BTP_LIST.Next);
  }
   return;

  case kBTP_EMPTY:
# line 298 "AnaOverlap.puma"
   return;

  case kBTE_LIST:
# line 301 "AnaOverlap.puma"
  {
# line 302 "AnaOverlap.puma"
   CheckForOverlap (var, exp->BTE_LIST.Elem);
# line 303 "AnaOverlap.puma"
   CheckForOverlap (var, exp->BTE_LIST.Next);
  }
   return;

  case kBTE_EMPTY:
# line 306 "AnaOverlap.puma"
   return;

  case kNO_PARAM:
# line 309 "AnaOverlap.puma"
   return;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
# line 312 "AnaOverlap.puma"
  {
# line 313 "AnaOverlap.puma"
   CheckForOverlap (var, exp->VAR_PARAM.V->ADDR.E);
  }
   return;

  }
# line 316 "AnaOverlap.puma"
  {
# line 317 "AnaOverlap.puma"
   CheckForVarOverlap (var, exp->VAR_PARAM.V);
  }
   return;

  }

# line 320 "AnaOverlap.puma"
  {
# line 321 "AnaOverlap.puma"
   failure_protocol (MODULE, "CheckForOverlap", exp);
  }
   return;

;
}

static void CheckIndexOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree owner, register tTree var)
# else
(owner, var)
 register tTree owner;
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 326 "AnaOverlap.puma"
  {
# line 328 "AnaOverlap.puma"
   CheckIndexOverlap (owner, var->INDEXED_VAR.IND_VAR);
# line 329 "AnaOverlap.puma"
   CheckForOverlap (owner, var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 332 "AnaOverlap.puma"
  {
# line 334 "AnaOverlap.puma"
   CheckIndexOverlap (owner, var->SELECTED_VAR.SELEC_VAR);
  }
   return;

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 337 "AnaOverlap.puma"
  {
# line 339 "AnaOverlap.puma"
   CheckIndexOverlap (owner, var->SUBSTRING_VAR.IND_VAR);
# line 340 "AnaOverlap.puma"
   CheckForOverlap (owner, var->SUBSTRING_VAR.IND_EXP);
  }
   return;

  }
;
}

static void CheckForVarOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree left_var, register tTree right_var)
# else
(left_var, right_var)
 register tTree left_var;
 register tTree right_var;
# endif
{
# line 351 "AnaOverlap.puma"
 {
  shift_vector pos;
  bool found;
  {
# line 353 "AnaOverlap.puma"

# line 354 "AnaOverlap.puma"

# line 356 "AnaOverlap.puma"
   GetShifting (left_var, right_var, & found, & pos);
# line 358 "AnaOverlap.puma"
   if (! ((found))) goto yyL1;
  {
# line 360 "AnaOverlap.puma"
   if (! ((IsOverlapUpdate (& pos)))) goto yyL1;
  {
# line 362 "AnaOverlap.puma"
   stmt_protocol ("overlap reduces movement");
# line 364 "AnaOverlap.puma"
   UpdateOverlapArea (right_var, & pos);
  }
  }
  }
   return;
 }
yyL1:;

# line 367 "AnaOverlap.puma"
   return;

;
}

static void CheckCShiftOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
# line 378 "AnaOverlap.puma"
 {
  shift_vector pos;
  bool found;
  tTree var;
  {
# line 380 "AnaOverlap.puma"

# line 381 "AnaOverlap.puma"

# line 382 "AnaOverlap.puma"

# line 384 "AnaOverlap.puma"
   GetCircularShifting (exp, & found, & var, & pos);
# line 386 "AnaOverlap.puma"
   if (! ((found))) goto yyL1;
  {
# line 388 "AnaOverlap.puma"
   stmt_protocol ("overlap will remove circular shifting");
# line 390 "AnaOverlap.puma"
   if (! ((IsOverlapUpdate (& pos)))) goto yyL1;
  {
# line 392 "AnaOverlap.puma"
   UpdateOverlapArea (var, & pos);
  }
  }
  }
   return;
 }
yyL1:;

  }
# line 395 "AnaOverlap.puma"
   return;

;
}

static void UpdateOverlapArea
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift pos)
# else
(var, pos)
 register tTree var;
 pshift pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 408 "AnaOverlap.puma"
  {
# line 409 "AnaOverlap.puma"
   UpdateOverlapArea (var->INDEXED_VAR.IND_VAR, pos);
  }
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 412 "AnaOverlap.puma"
  {
# line 413 "AnaOverlap.puma"
   UpdateOverlapArea (var->SELECTED_VAR.SELEC_VAR, pos);
  }
   return;

  }
  if (var->Kind == kUSED_VAR) {
# line 416 "AnaOverlap.puma"
  {
# line 417 "AnaOverlap.puma"
   UpdateOverlapArea (var->USED_VAR.VARNAME, pos);
  }
   return;

  }
  if (var->Kind == kVAR_OBJ) {
# line 420 "AnaOverlap.puma"
  {
# line 422 "AnaOverlap.puma"
   if (! ((VarRank (var->VAR_OBJ.Object) == pos -> shift_rank))) goto yyL4;
  {
# line 423 "AnaOverlap.puma"
   SetVarOverlap (ArrayFormals (var->VAR_OBJ.Object), 0, pos);
# line 424 "AnaOverlap.puma"
   PrintNewVarDecl (var->VAR_OBJ.Object);
  }
  }
   return;
yyL4:;

# line 427 "AnaOverlap.puma"
  {
# line 428 "AnaOverlap.puma"
   PrintNewVarDecl (var->VAR_OBJ.Object);
  }
   return;

  }
# line 431 "AnaOverlap.puma"
  {
# line 432 "AnaOverlap.puma"
   failure_protocol (MODULE, "UpdateOverlapArea", var);
  }
   return;

;
}

static void PrintNewVarDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 444 "AnaOverlap.puma"
  {
# line 445 "AnaOverlap.puma"
   tree_protocol ("array with overlap : \n", obj->VarObject.decl);
  }
   return;

  }
;
}

static void SetVarOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int dim, pshift pos)
# else
(indexes, dim, pos)
 register tTree indexes;
 register int dim;
 pshift pos;
# endif
{
  if (indexes->Kind == kSHAPE_EMPTY) {
# line 456 "AnaOverlap.puma"
   return;

  }
  if (indexes->Kind == kSHAPE_LIST) {
# line 461 "AnaOverlap.puma"
  {
# line 462 "AnaOverlap.puma"
   SetOverlapIndex (indexes->SHAPE_LIST.Elem, pos -> shift_pos [dim]);
# line 463 "AnaOverlap.puma"
   SetVarOverlap (indexes->SHAPE_LIST.Next, dim + 1, pos);
  }
   return;

  }
;
}

static void SetOverlapIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index, register int pos)
# else
(index, pos)
 register tTree index;
 register int pos;
# endif
{
  if (index->Kind == kOVERLAP_SPEC) {
# line 474 "AnaOverlap.puma"
  {
# line 476 "AnaOverlap.puma"
   if (! ((pos < 0))) goto yyL1;
  {
# line 477 "AnaOverlap.puma"
   if (! ((- pos <= MAX_OVERLAP_SIZE))) goto yyL1;
  {
# line 478 "AnaOverlap.puma"
   if (! ((- pos > index->OVERLAP_SPEC.right_size))) goto yyL1;
  {
# line 480 "AnaOverlap.puma"
   index->OVERLAP_SPEC.right_size = - pos;
  }
  }
  }
  }
   return;
yyL1:;

# line 483 "AnaOverlap.puma"
  {
# line 485 "AnaOverlap.puma"
   if (! ((pos > 0))) goto yyL2;
  {
# line 486 "AnaOverlap.puma"
   if (! ((pos <= MAX_OVERLAP_SIZE))) goto yyL2;
  {
# line 487 "AnaOverlap.puma"
   if (! ((pos > index->OVERLAP_SPEC.left_size))) goto yyL2;
  {
# line 489 "AnaOverlap.puma"
   index->OVERLAP_SPEC.left_size = pos;
  }
  }
  }
  }
   return;
yyL2:;

# line 492 "AnaOverlap.puma"
   return;

  }
  if (Tree_IsType (index, kSHAPE_SPEC)) {
# line 497 "AnaOverlap.puma"
  {
# line 499 "AnaOverlap.puma"
   SetOverlapIndex (index->SHAPE_SPEC.Overlap, pos);
  }
   return;

  }
# line 502 "AnaOverlap.puma"
  {
# line 503 "AnaOverlap.puma"
   failure_protocol (MODULE, "SetOverlapIndex", index);
  }
   return;

;
}

void BeginAnaOverlap ()
{
}

void CloseAnaOverlap ()
{
}
