# include "AlignCheck.h"
# include "yyAlignCheck.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 38 "AlignCheck.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "Types.h"

# include "Expressions.h"    /* GetConstDifference */
# include "Descriptor.h"     /* SameDescriptorTopology */

# define MODULE "AlignCheck"

# undef DEBUG



static void yyExit () { Exit (1); }

void (* AlignCheck_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AlignCheck, routine %s failed\n", yyFunction);
 AlignCheck_Exit ();
}

static void GetMultConstDifference ARGS((tTree exp1, int c1, tTree exp2, int c2, bool * yyP2, int * yyP1));
static bool EqualVar ARGS((int a1, tTree v1, int a2, tTree v2));
static void GetActualDiff ARGS((pvar vd1, int ind1, int c1, pvar vd2, int ind2, int c2, bool * yyP4, int * yyP3));
static void GetFormalDiff ARGS((pvar vd1, int ind1, pvar vd2, int ind2, bool * yyP6, int * yyP5));
static void GetTemplate ARGS((pvar vd, int ind, tDefinitions * yyP8, int * yyP7));
static void GetTopology ARGS((pvar vd, int ind, tDefinitions * yyP10, int * yyP9));
static void GetDistributionKind ARGS((pvar vd, int ind, int * yyP12, tTree * yyP11));
static void GetFormalShape ARGS((pvar vd, int ind, tTree * yyP14, tTree * yyP13));
static bool EqualDistributionSpec ARGS((int kind1, tTree size1, int kind2, tTree size2));
static bool EqualSize ARGS((tTree size1, tTree size2));
void GetAlignment ARGS((pvar vd1, int ind1, pvar vd2, int ind2, bool * yyP18, int * yyP17, int * yyP16, int * yyP15));
void GetSimpleAlignment ARGS((pvar vd1, int ind1, pvar vd2, int ind2, bool * yyP20, int * yyP19));
static void BuildSimpleAlignment ARGS((int c1, int c2, int diff, bool * yyP22, int * yyP21));

static void GetMultConstDifference
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register int c1, register tTree exp2, register int c2, register bool * yyP2, register int * yyP1)
# else
(exp1, c1, exp2, c2, yyP2, yyP1)
 register tTree exp1;
 register int c1;
 register tTree exp2;
 register int c2;
 register bool * yyP2;
 register int * yyP1;
# endif
{
# line 65 "AlignCheck.puma"
 {
  bool found;
  int val;
  {
# line 67 "AlignCheck.puma"

# line 68 "AlignCheck.puma"

# line 70 "AlignCheck.puma"
   if (! ((c1 == c2))) goto yyL1;
  {
# line 71 "AlignCheck.puma"
   GetConstDifference (exp1, exp2, & found, & val);
# line 72 "AlignCheck.puma"
   if (! ((found))) goto yyL1;
  }
  }
   * yyP2 = true;
   * yyP1 = c1 * val;
   return;
 }
yyL1:;

# line 75 "AlignCheck.puma"
 {
  bool found1;
  bool found2;
  int a1;
  int a2;
  int b1;
  int b2;
  tTree v1;
  tTree v2;
  {
# line 77 "AlignCheck.puma"

# line 78 "AlignCheck.puma"

# line 80 "AlignCheck.puma"

# line 80 "AlignCheck.puma"

# line 81 "AlignCheck.puma"

# line 81 "AlignCheck.puma"

# line 82 "AlignCheck.puma"

# line 82 "AlignCheck.puma"

# line 84 "AlignCheck.puma"
   ResolveExpression (exp1, & found1, & a1, & b1, & v1);
# line 85 "AlignCheck.puma"
   if (! ((found1))) goto yyL2;
  {
# line 86 "AlignCheck.puma"
   ResolveExpression (exp2, & found2, & a2, & b2, & v2);
# line 87 "AlignCheck.puma"
   if (! ((found2))) goto yyL2;
  {
# line 91 "AlignCheck.puma"
   if (! (EqualVar (a1 * c1, v1, a2 * c2, v2))) goto yyL2;
  }
  }
  }
   * yyP2 = true;
   * yyP1 = c1 * b1 - c2 * b2;
   return;
 }
yyL2:;

# line 94 "AlignCheck.puma"
   * yyP2 = false;
   * yyP1 = 0;
   return;

;
}

static bool EqualVar
# if defined __STDC__ | defined __cplusplus
(register int a1, register tTree v1, register int a2, register tTree v2)
# else
(a1, v1, a2, v2)
 register int a1;
 register tTree v1;
 register int a2;
 register tTree v2;
# endif
{
# line 109 "AlignCheck.puma"
  {
# line 111 "AlignCheck.puma"
   if (! (((v1 == NoTree) || (a1 == 0)))) goto yyL1;
  {
# line 112 "AlignCheck.puma"
   if (! (((v2 == NoTree) || (a2 == 0)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 119 "AlignCheck.puma"
  {
# line 121 "AlignCheck.puma"
   if (! ((v1 != NoTree))) goto yyL2;
  {
# line 122 "AlignCheck.puma"
   if (! ((v2 != NoTree))) goto yyL2;
  {
# line 123 "AlignCheck.puma"
   if (! ((EqualExpression (v1, v2)))) goto yyL2;
  {
# line 124 "AlignCheck.puma"
   if (! ((a1 == a2))) goto yyL2;
  }
  }
  }
  }
   return true;
yyL2:;

  return false;
}

static void GetActualDiff
# if defined __STDC__ | defined __cplusplus
(pvar vd1, register int ind1, register int c1, pvar vd2, register int ind2, register int c2, register bool * yyP4, register int * yyP3)
# else
(vd1, ind1, c1, vd2, ind2, c2, yyP4, yyP3)
 pvar vd1;
 register int ind1;
 register int c1;
 pvar vd2;
 register int ind2;
 register int c2;
 register bool * yyP4;
 register int * yyP3;
# endif
{
# line 140 "AlignCheck.puma"
 {
  tTree l1;
  tTree l2;
  tTree u1;
  tTree u2;
  int val1;
  int val2;
  bool found;
  {
# line 142 "AlignCheck.puma"

# line 142 "AlignCheck.puma"

# line 143 "AlignCheck.puma"

# line 143 "AlignCheck.puma"

# line 145 "AlignCheck.puma"

# line 145 "AlignCheck.puma"

# line 147 "AlignCheck.puma"

# line 149 "AlignCheck.puma"
 l1 = vd1->actual_shape[ind1-1][0];
     u1 = vd1->actual_shape[ind1-1][1];
 
     l2 = vd2->actual_shape[ind2-1][0];
     u2 = vd2->actual_shape[ind2-1][1];
 
#ifdef DEBUG
     FileUnparse (stdout, l1); printf (" * %d is low 1\n", c1);
     FileUnparse (stdout, l2); printf (" * %d is low 2\n", c2);
     FileUnparse (stdout, u1); printf (" * %d is up 1\n", c1);
     FileUnparse (stdout, u2); printf (" * %d is up 2\n", c2);
#endif

     GetMultConstDifference (l1, c1, l2, c2, &found, &val1);

     
 
     if (found)
        GetMultConstDifference (u1, c1, u2, c2, &found, &val2);
 
     if (found)
        found = (val1 == val2);

#ifdef DEBUG
     if (found)
        printf ("actuals match with difference %d\n", val1);
#endif

   
  }
   * yyP4 = found;
   * yyP3 = val1;
   return;
 }

;
}

static void GetFormalDiff
# if defined __STDC__ | defined __cplusplus
(pvar vd1, register int ind1, pvar vd2, register int ind2, register bool * yyP6, register int * yyP5)
# else
(vd1, ind1, vd2, ind2, yyP6, yyP5)
 pvar vd1;
 register int ind1;
 pvar vd2;
 register int ind2;
 register bool * yyP6;
 register int * yyP5;
# endif
{
# line 201 "AlignCheck.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  tDefinitions yyV3;
  int yyV4;
  {
# line 203 "AlignCheck.puma"
   GetTopology (vd1, ind1, & yyV1, & yyV2);
# line 204 "AlignCheck.puma"
   GetTopology (vd2, ind2, & yyV3, & yyV4);
# line 206 "AlignCheck.puma"
   if (! ((yyV2 == 0))) goto yyL1;
  {
# line 207 "AlignCheck.puma"
   if (! ((yyV4 == 0))) goto yyL1;
  }
  }
   * yyP6 = true;
   * yyP5 = 0;
   return;
 }
yyL1:;

# line 214 "AlignCheck.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  tDefinitions yyV3;
  int yyV4;
  {
# line 216 "AlignCheck.puma"
   GetTemplate (vd1, ind1, & yyV1, & yyV2);
# line 217 "AlignCheck.puma"
   GetTemplate (vd2, ind2, & yyV3, & yyV4);
# line 219 "AlignCheck.puma"
   if (! ((yyV1 == yyV3))) goto yyL2;
  {
# line 220 "AlignCheck.puma"
   if (! ((yyV2 == yyV4))) goto yyL2;
  }
  }
   * yyP6 = true;
   * yyP5 = 0;
   return;
 }
yyL2:;

# line 223 "AlignCheck.puma"
 {
  tDefinitions yyV1;
  int yyV2;
  tDefinitions yyV3;
  int yyV4;
  int yyV5;
  tTree yyV6;
  int yyV7;
  tTree yyV8;
  tTree yyV9;
  tTree yyV10;
  tTree yyV11;
  tTree yyV12;
  int val1;
  int val2;
  bool found;
  {
# line 229 "AlignCheck.puma"
   GetTopology (vd1, ind1, & yyV1, & yyV2);
# line 230 "AlignCheck.puma"
   GetTopology (vd2, ind2, & yyV3, & yyV4);
# line 232 "AlignCheck.puma"
   if (! ((SameDescriptorTopology (vd1, vd2)))) goto yyL3;
  {
# line 234 "AlignCheck.puma"
   if (! ((yyV2 == yyV4))) goto yyL3;
  {
# line 236 "AlignCheck.puma"
   GetDistributionKind (vd1, ind1, & yyV5, & yyV6);
# line 237 "AlignCheck.puma"
   GetDistributionKind (vd2, ind2, & yyV7, & yyV8);
# line 239 "AlignCheck.puma"
   if (! ((EqualDistributionSpec (yyV5, yyV6, yyV7, yyV8)))) goto yyL3;
  {
# line 241 "AlignCheck.puma"
   GetFormalShape (vd1, ind1, & yyV9, & yyV10);
# line 242 "AlignCheck.puma"
   GetFormalShape (vd2, ind2, & yyV11, & yyV12);
# line 244 "AlignCheck.puma"
   if (! ((yyV9 != NoTree))) goto yyL3;
  {
# line 245 "AlignCheck.puma"
   if (! ((yyV11 != NoTree))) goto yyL3;
  {
# line 246 "AlignCheck.puma"
   if (! ((yyV10 != NoTree))) goto yyL3;
  {
# line 247 "AlignCheck.puma"
   if (! ((yyV12 != NoTree))) goto yyL3;
  {
# line 249 "AlignCheck.puma"

# line 249 "AlignCheck.puma"

# line 250 "AlignCheck.puma"

# line 252 "AlignCheck.puma"
   GetConstDifference (yyV9, yyV11, & found, & val1);
# line 253 "AlignCheck.puma"
   if (! ((found))) goto yyL3;
  {
# line 255 "AlignCheck.puma"
   GetConstDifference (yyV10, yyV12, & found, & val2);
# line 256 "AlignCheck.puma"
   if (! ((found))) goto yyL3;
  {
# line 258 "AlignCheck.puma"
   if (! ((val1 == val2))) goto yyL3;
  }
  }
  }
  }
  }
  }
  }
  }
  }
  }
   * yyP6 = true;
   * yyP5 = val1;
   return;
 }
yyL3:;

# line 261 "AlignCheck.puma"
   * yyP6 = false;
   * yyP5 = 0;
   return;

;
}

static void GetTemplate
# if defined __STDC__ | defined __cplusplus
(pvar vd, register int ind, register tDefinitions * yyP8, register int * yyP7)
# else
(vd, ind, yyP8, yyP7)
 pvar vd;
 register int ind;
 register tDefinitions * yyP8;
 register int * yyP7;
# endif
{
# line 274 "AlignCheck.puma"
 {
  tDefinitions template_id;
  int tdim;
  {
# line 276 "AlignCheck.puma"

# line 277 "AlignCheck.puma"

# line 279 "AlignCheck.puma"
 template_id = vd->template_obj;
     tdim = vd->template_dim [ind-1];
   
  }
   * yyP8 = template_id;
   * yyP7 = tdim;
   return;
 }

;
}

static void GetTopology
# if defined __STDC__ | defined __cplusplus
(pvar vd, register int ind, register tDefinitions * yyP10, register int * yyP9)
# else
(vd, ind, yyP10, yyP9)
 pvar vd;
 register int ind;
 register tDefinitions * yyP10;
 register int * yyP9;
# endif
{
# line 286 "AlignCheck.puma"
 {
  tDefinitions top_obj;
  int top_dim;
  {
# line 288 "AlignCheck.puma"

# line 289 "AlignCheck.puma"

# line 291 "AlignCheck.puma"
 top_obj  = vd->topology_obj;
     top_dim  = vd->topology_dim [ind-1];
   
  }
   * yyP10 = top_obj;
   * yyP9 = top_dim;
   return;
 }

;
}

static void GetDistributionKind
# if defined __STDC__ | defined __cplusplus
(pvar vd, register int ind, register int * yyP12, register tTree * yyP11)
# else
(vd, ind, yyP12, yyP11)
 pvar vd;
 register int ind;
 register int * yyP12;
 register tTree * yyP11;
# endif
{
# line 298 "AlignCheck.puma"
 {
  int kind;
  tTree size;
  {
# line 300 "AlignCheck.puma"

# line 301 "AlignCheck.puma"

# line 303 "AlignCheck.puma"
 kind = vd->distribution_kind [ind-1]; 
     size = vd->distribution_size [ind-1];
   
  }
   * yyP12 = kind;
   * yyP11 = size;
   return;
 }

;
}

static void GetFormalShape
# if defined __STDC__ | defined __cplusplus
(pvar vd, register int ind, register tTree * yyP14, register tTree * yyP13)
# else
(vd, ind, yyP14, yyP13)
 pvar vd;
 register int ind;
 register tTree * yyP14;
 register tTree * yyP13;
# endif
{
# line 310 "AlignCheck.puma"
 {
  tTree lb;
  tTree ub;
  {
# line 312 "AlignCheck.puma"

# line 312 "AlignCheck.puma"

# line 314 "AlignCheck.puma"
 lb = vd->formal_shape[ind-1][0];
     ub = vd->formal_shape[ind-1][1];
   
  }
   * yyP14 = lb;
   * yyP13 = ub;
   return;
 }

;
}

static bool EqualDistributionSpec
# if defined __STDC__ | defined __cplusplus
(register int kind1, register tTree size1, register int kind2, register tTree size2)
# else
(kind1, size1, kind2, size2)
 register int kind1;
 register tTree size1;
 register int kind2;
 register tTree size2;
# endif
{
# line 330 "AlignCheck.puma"
  {
# line 332 "AlignCheck.puma"
   if (! ((kind1 == kSERIAL_DIM))) goto yyL1;
  {
# line 333 "AlignCheck.puma"
   if (! ((kind2 == kSERIAL_DIM))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 336 "AlignCheck.puma"
  {
# line 338 "AlignCheck.puma"
   if (! ((kind1 == kBLOCK_DIM))) goto yyL2;
  {
# line 339 "AlignCheck.puma"
   if (! ((kind2 == kBLOCK_DIM))) goto yyL2;
  {
# line 340 "AlignCheck.puma"
   if (! ((EqualSize (size1, size2)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

# line 343 "AlignCheck.puma"
  {
# line 345 "AlignCheck.puma"
   if (! ((kind1 == kCYCLIC_DIM))) goto yyL3;
  {
# line 346 "AlignCheck.puma"
   if (! ((kind2 == kCYCLIC_DIM))) goto yyL3;
  {
# line 347 "AlignCheck.puma"
   if (! ((EqualSize (size1, size2)))) goto yyL3;
  }
  }
  }
   return true;
yyL3:;

  return false;
}

static bool EqualSize
# if defined __STDC__ | defined __cplusplus
(register tTree size1, register tTree size2)
# else
(size1, size2)
 register tTree size1;
 register tTree size2;
# endif
{
# line 352 "AlignCheck.puma"
  {
# line 354 "AlignCheck.puma"
   if (! ((size1 == NoTree))) goto yyL1;
  {
# line 355 "AlignCheck.puma"
   if (! ((size2 == NoTree))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 358 "AlignCheck.puma"
  {
# line 360 "AlignCheck.puma"
   if (! ((size1 != NoTree))) goto yyL2;
  {
# line 361 "AlignCheck.puma"
   if (! ((size2 != NoTree))) goto yyL2;
  {
# line 362 "AlignCheck.puma"
   if (! ((EqualExpression (size1, size2)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  return false;
}

void GetAlignment
# if defined __STDC__ | defined __cplusplus
(pvar vd1, register int ind1, pvar vd2, register int ind2, register bool * yyP18, register int * yyP17, register int * yyP16, register int * yyP15)
# else
(vd1, ind1, vd2, ind2, yyP18, yyP17, yyP16, yyP15)
 pvar vd1;
 register int ind1;
 pvar vd2;
 register int ind2;
 register bool * yyP18;
 register int * yyP17;
 register int * yyP16;
 register int * yyP15;
# endif
{
# line 382 "AlignCheck.puma"
 {
  bool yyV1;
  int yyV2;
  int c1;
  int c2;
  bool yyV3;
  int yyV4;
  {
# line 384 "AlignCheck.puma"
   GetFormalDiff (vd1, ind1, vd2, ind2, & yyV1, & yyV2);
# line 385 "AlignCheck.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 389 "AlignCheck.puma"

# line 390 "AlignCheck.puma"

# line 392 "AlignCheck.puma"
 c1 = vd1->align_mult [ind1-1];
      c2 = vd2->align_mult [ind2-1];

      yyV2 = yyV2 - vd1->align_add[ind1-1] + vd2->align_add[ind2-1];
#ifdef DEBUG
      printf ("align is now : c1 = %d, c2 = %d, diff = %d\n", c1, c2, yyV2);
#endif 
    
# line 401 "AlignCheck.puma"
   GetActualDiff (vd1, ind1, c1, vd2, ind2, c2, & yyV3, & yyV4);
# line 402 "AlignCheck.puma"
   if (! ((yyV3))) goto yyL1;
  }
  }
   * yyP18 = yyV1;
   * yyP17 = c1;
   * yyP16 = c2;
   * yyP15 = yyV4 - yyV2;
   return;
 }
yyL1:;

# line 407 "AlignCheck.puma"
   * yyP18 = false;
   * yyP17 = 1;
   * yyP16 = 1;
   * yyP15 = 0;
   return;

;
}

void GetSimpleAlignment
# if defined __STDC__ | defined __cplusplus
(pvar vd1, register int ind1, pvar vd2, register int ind2, register bool * yyP20, register int * yyP19)
# else
(vd1, ind1, vd2, ind2, yyP20, yyP19)
 pvar vd1;
 register int ind1;
 pvar vd2;
 register int ind2;
 register bool * yyP20;
 register int * yyP19;
# endif
{
# line 413 "AlignCheck.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  bool yyV5;
  int yyV6;
  {
# line 415 "AlignCheck.puma"

#ifdef DEBUG
       printf ("call of GetSimpleAlignment\n");
#endif
     
# line 421 "AlignCheck.puma"
   GetAlignment (vd1, ind1, vd2, ind2, & yyV1, & yyV2, & yyV3, & yyV4);
# line 422 "AlignCheck.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 424 "AlignCheck.puma"
   BuildSimpleAlignment (yyV2, yyV3, yyV4, & yyV5, & yyV6);
  }
  }
   * yyP20 = yyV5;
   * yyP19 = yyV6;
   return;
 }
yyL1:;

# line 427 "AlignCheck.puma"
   * yyP20 = false;
   * yyP19 = 0;
   return;

;
}

static void BuildSimpleAlignment
# if defined __STDC__ | defined __cplusplus
(register int c1, register int c2, register int diff, register bool * yyP22, register int * yyP21)
# else
(c1, c2, diff, yyP22, yyP21)
 register int c1;
 register int c2;
 register int diff;
 register bool * yyP22;
 register int * yyP21;
# endif
{
# line 443 "AlignCheck.puma"
  {
# line 445 "AlignCheck.puma"
   if (! ((diff == 0))) goto yyL1;
  }
   * yyP22 = true;
   * yyP21 = 0;
   return;
yyL1:;

# line 448 "AlignCheck.puma"
  {
# line 450 "AlignCheck.puma"
   if (! ((c2 == 1))) goto yyL2;
  }
   * yyP22 = true;
   * yyP21 = diff;
   return;
yyL2:;

# line 453 "AlignCheck.puma"
  {
# line 455 "AlignCheck.puma"
   if (! ((c2 > 0))) goto yyL3;
  {
# line 456 "AlignCheck.puma"
   if (! ((diff > 0))) goto yyL3;
  }
  }
   * yyP22 = true;
   * yyP21 = (diff + c2 - 1) / c2;
   return;
yyL3:;

# line 459 "AlignCheck.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 461 "AlignCheck.puma"
   if (! ((c2 > 0))) goto yyL4;
  {
# line 462 "AlignCheck.puma"
   if (! ((diff < 0))) goto yyL4;
  {
# line 463 "AlignCheck.puma"
   BuildSimpleAlignment (c1, c2, - diff, & yyV1, & yyV2);
  }
  }
  }
   * yyP22 = yyV1;
   * yyP21 = - yyV2;
   return;
 }
yyL4:;

# line 466 "AlignCheck.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 468 "AlignCheck.puma"
   if (! ((c2 < 0))) goto yyL5;
  {
# line 469 "AlignCheck.puma"
   BuildSimpleAlignment (c1, - c2, diff, & yyV1, & yyV2);
  }
  }
   * yyP22 = yyV1;
   * yyP21 = - yyV2;
   return;
 }
yyL5:;

# line 472 "AlignCheck.puma"
   * yyP22 = false;
   * yyP21 = 0;
   return;

;
}

void BeginAlignCheck ()
{
}

void CloseAlignCheck ()
{
}
