# include "AdaptF77.h"
# include "yyAdaptF77.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 41 "AdaptF77.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Types.h"
# include "Transform.h"    /* AppendDECLS, CombineACF  */
# include "Shapes.h"
# include "Rank.h"
# include "Distributions.h"
# include "Loops.h"

# include "Temporary.h"    /* GetLoopTemporary */

# include "Expressions.h"
# include "Reductions.h"

# include "IndexShapes.h"  /* FindShapeExp */
# include "ReplaceExp.h"   /* RenameLoopId */

# include "Accepted.h"     /* DoLoopExpression */
# include "MakeLoops.h" 

# include "VarDescriptor.h"  
# include "ExpDescriptor.h"   
# include "MoveControl.h"

# undef DEBUG

# define MODULE "AdaptF77"

       /***************************************
       *                                      *
       *  split_shape :     dim  = d          *
       *                                      *
       *                                      *
       *   ug1:og1:str1                       *
       *   ....                               *
       *   ugd:ogd:strd   -> move to s1       *
       *   ....                               *
       *   ugn:ogn:strn                       *
       *                                      *
       ***************************************/

void split_shape (s, s1, dim)
shape s, s1;
int dim;
{ int i, j;

  if ((dim < 1) || (dim > s->rank))

     { failure_protocol (MODULE, 
           "split_shape: Illegal shape - dim in split_shape", NoTree);
     }

  /* set up one-dimensional shape for reduction loop */

  s1->rank = 1;
  for (i = 0; i < 3; i ++)
    s1->bounds[0][i] = s->bounds[dim-1][i];
  s1->perm[0] = s->perm[dim-1];

  /* reduced shape back in s */

  for (j = 0; j < s->rank; j ++)
    if (j >= dim)
      for (i = 0; i < 3; i++)
        { s->bounds[j-1][i] = s->bounds[j][i];
          s->perm[j-1] = s->perm[j];
        }

  s->rank = s->rank - 1;

} /* split_shape */



static void yyExit () { Exit (1); }

void (* AdaptF77_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptF77, routine %s failed\n", yyFunction);
 AdaptF77_Exit ();
}

static void FreeTemporaries0 ARGS(());
tTree F77Where ARGS((tTree t));
tTree F77Merge ARGS((tTree var, tTree params));
void F77IO ARGS((tTree t));
tTree F77Assign ARGS((tTree t));
tTree F77Reduction ARGS((int line, tTree var, tTree exp));
static tTree MaskExp ARGS((tTree mask));
static tTree MakeFullReduction ARGS((int line, tTree var, tTree f, tTree pexp, tTree mask));
static tTree MakeDimReduction ARGS((int line, int dim, tTree var, tTree f, tTree pexp, tTree mask));
tTree F77LocReduction ARGS((int line, tTree var, tTree exp));
static void FindValVar ARGS((tTree array, tTree mask, tTree * yyP2, tTree * yyP1));
static void InsertLocParams ARGS((tTree var, tTree stmt, int n, tTree p));
static tTree MakePosParams ARGS((tTree var, int n, tTree id, tTree slice));
static tTree NthPos ARGS((tTree var, int n));
tTree F77ManyAssign ARGS((tTree t));
static tTree MakeAssignments ARGS((tTree var, int n, tTree elements));
static tTree MakeAssignment ARGS((tTree var, int n, tTree elem));
static void SetIndexValue ARGS((tTree indexes, int n));
static void GetExpShape ARGS((tTree exp, shape s));

static void FreeTemporaries0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 130 "AdaptF77.puma"
 {
  tTree help;
  {
# line 131 "AdaptF77.puma"

# line 133 "AdaptF77.puma"
 FreeTemporaries (&help, &help); 
  }
   return;
 }

;
}

tTree F77Where
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_WHERE) {
# line 150 "AdaptF77.puma"
 {
  struct_shape shp;
  tTree new;
  {
# line 152 "AdaptF77.puma"

# line 153 "AdaptF77.puma"

# line 155 "AdaptF77.puma"
 GetActualShape (t, &shp);

     if (shp.rank == 0)

        { error_protocol ("where statement: no shape found");
          new = NoTree;
        }

      else

        { 

          t->ACF_WHERE.WHERE_EXP   = SetActualShape (t->ACF_WHERE.WHERE_EXP, &shp);
          t->ACF_WHERE.TRUE_PART = SetActualShape (t->ACF_WHERE.TRUE_PART, &shp);
          t->ACF_WHERE.FALSE_PART = SetActualShape (t->ACF_WHERE.FALSE_PART, &shp);

          

          new = mACF_IF (t->ACF_WHERE.WHERE_EXP, t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.FALSE_PART);
          SetACFNode (new, 0, t->ACF_WHERE.Line);

          
          new = MakeOuterLoops (t->ACF_WHERE.Line, &shp, new, GEN_DO_INDEPENDENT); 
        }
   
# line 181 "AdaptF77.puma"
   FreeTemporaries0 ();
  }
  {
   return new;
  }
 }

  }
# line 185 "AdaptF77.puma"
  {
# line 187 "AdaptF77.puma"
   failure_protocol (MODULE, "F77Where", t);
  }
   return NoTree;

}

tTree F77Merge
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree params)
# else
(var, params)
 register tTree var;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 201 "AdaptF77.puma"
 {
  struct_shape shp;
  tTree new;
  tTree hnew;
  {
# line 203 "AdaptF77.puma"

# line 204 "AdaptF77.puma"

# line 205 "AdaptF77.puma"

# line 207 "AdaptF77.puma"
 GetActualShape (var, &shp);

     if (shp.rank > 0)

        { var   = SetActualShape (var, &shp);
          params->BTP_LIST.Elem = SetActualShape (params->BTP_LIST.Elem, &shp);
          params->BTP_LIST.Next->BTP_LIST.Elem = SetActualShape (params->BTP_LIST.Next->BTP_LIST.Elem, &shp);
          params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem  = SetActualShape (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, &shp);
        }

     

     hnew = mASSIGN_STMT (CopyTree (var), VarParamToExp (params->BTP_LIST.Next->BTP_LIST.Elem));
     hnew = mACF_LIST (mACF_BASIC (hnew), mACF_EMPTY ());
   
     

     new = mASSIGN_STMT (var, VarParamToExp (params->BTP_LIST.Elem));
     new = mACF_LIST (mACF_BASIC (new), mACF_EMPTY ());

     

     new = mACF_IF (VarParamToExp (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem), new, hnew);

     

     if (shp.rank > 0)
        new = MakeOuterLoops (0, &shp, new, GEN_DO_INDEPENDENT);

   
# line 237 "AdaptF77.puma"
   FreeTemporaries0 ();
  }
  {
   return new;
  }
 }

  }
  }
  }
  }
# line 242 "AdaptF77.puma"
  {
# line 244 "AdaptF77.puma"
   failure_protocol (MODULE, "F77Merge", params);
  }
   return NoTree;

}

void F77IO
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 258 "AdaptF77.puma"

struct_shape shp;
tTree new;

  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
  if (t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->Kind == kDO_EXP) {
# line 263 "AdaptF77.puma"
  {
# line 265 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }
   return;

  }
# line 275 "AdaptF77.puma"
  {
# line 277 "AdaptF77.puma"
   if (! ((TreeRank (t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E) > 0))) goto yyL3;
  {
# line 281 "AdaptF77.puma"
 GetExpShape (t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &shp);
     new = SetActualShape (t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &shp);
     new = MakeOuterImpliedLoops (&shp, new);
     t->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E = new;
   
# line 287 "AdaptF77.puma"
   FreeTemporaries0 ();
# line 288 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }
  }
   return;
yyL3:;

  }
  if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kDO_VAR) {
# line 268 "AdaptF77.puma"
  {
# line 272 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 291 "AdaptF77.puma"
  {
# line 295 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }
   return;

  }
# line 298 "AdaptF77.puma"
  {
# line 300 "AdaptF77.puma"
   if (! ((TreeRank (t->BTP_LIST.Elem->VAR_PARAM.V) > 0))) goto yyL5;
  {
# line 304 "AdaptF77.puma"
 GetExpShape (t->BTP_LIST.Elem->VAR_PARAM.V, &shp);

     new = SetActualShape (t->BTP_LIST.Elem->VAR_PARAM.V, &shp);
     new = MakeOuterImpliedLoopsV (&shp, new);
     t->BTP_LIST.Elem->VAR_PARAM.V = new;
   
# line 311 "AdaptF77.puma"
   FreeTemporaries0 ();
# line 312 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }
  }
   return;
yyL5:;

  }
# line 315 "AdaptF77.puma"
  {
# line 317 "AdaptF77.puma"
   F77IO (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 320 "AdaptF77.puma"
   return;

  }
# line 323 "AdaptF77.puma"
  {
# line 324 "AdaptF77.puma"
   failure_protocol (MODULE, "IOF77", t);
  }
   return;

;
}

tTree F77Assign
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 335 "AdaptF77.puma"
 {
  struct_shape shp;
  tTree new;
  {
# line 337 "AdaptF77.puma"

# line 338 "AdaptF77.puma"

# line 340 "AdaptF77.puma"
 GetActualShape (t, &shp);

# ifdef DEBUG
     printf ("Call of F77 Assign\n"); FileUnparse (stdout, t);
     printf ("Here is the Actual shape of the lhs variable\n");
     PrintShape (&shp);
     printf ("Will actualize shape in var and exp\n");
# endif

     if (shp.rank > 0)

       { 

         t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = SetActualShape (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, &shp);
         t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = SetActualShape (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, &shp); 
         new = MakeOuterLoops (t->ACF_BASIC.Line, &shp, t, GEN_DO_INDEPENDENT); 
       }

     else

       new = t;

   
# line 364 "AdaptF77.puma"
   FreeTemporaries0 ();
  }
  {
   return new;
  }
 }

  }
  }
# line 368 "AdaptF77.puma"
  {
# line 370 "AdaptF77.puma"
   failure_protocol (MODULE, "F77Assign", t);
  }
   return NoTree;

}

tTree F77Reduction
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree var, register tTree exp)
# else
(line, var, exp)
 register int line;
 register tTree var;
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 392 "AdaptF77.puma"
   return MakeFullReduction (line, var, exp->FUNC_CALL_EXP.FUNC_ID, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, MaskExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem));

  }
  }
  }
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 404 "AdaptF77.puma"
 {
  int idim;
  bool found;
  {
# line 407 "AdaptF77.puma"

# line 408 "AdaptF77.puma"

# line 410 "AdaptF77.puma"
   GetIntConstValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, & found, & idim);
# line 411 "AdaptF77.puma"
   if (! ((found))) goto yyL2;
  }
  {
   return MakeDimReduction (line, idim, var, exp->FUNC_CALL_EXP.FUNC_ID, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, MaskExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem));
  }
 }
yyL2:;

# line 416 "AdaptF77.puma"
  {
# line 419 "AdaptF77.puma"
   error_protocol ("dim parameter of reduction unknown at compile time");
  }
   return NoTree;

  }
  }
  }
  }
  }
# line 423 "AdaptF77.puma"
  {
# line 425 "AdaptF77.puma"
   failure_protocol (MODULE, "F77Reduction", exp);
  }
   return NoTree;

}

static tTree MaskExp
# if defined __STDC__ | defined __cplusplus
(register tTree mask)
# else
(mask)
 register tTree mask;
# endif
{
# line 437 "AdaptF77.puma"
  {
# line 438 "AdaptF77.puma"
   if (! ((mask == NoTree))) goto yyL1;
  }
   return mask;
yyL1:;

  if (mask->Kind == kVAR_PARAM) {
  if (mask->VAR_PARAM.V->Kind == kADDR) {
# line 442 "AdaptF77.puma"
   return mask->VAR_PARAM.V->ADDR.E;

  }
# line 446 "AdaptF77.puma"
   return mVAR_EXP (mask->VAR_PARAM.V);

  }
  if (mask->Kind == kNO_PARAM) {
# line 450 "AdaptF77.puma"
   return NoTree;

  }
# line 454 "AdaptF77.puma"
  {
# line 456 "AdaptF77.puma"
   failure_protocol (MODULE, "MaskExp", mask);
  }
   return mask;

}

static tTree MakeFullReduction
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree var, register tTree f, register tTree pexp, register tTree mask)
# else
(line, var, f, pexp, mask)
 register int line;
 register tTree var;
 register tTree f;
 register tTree pexp;
 register tTree mask;
# endif
{
  if (pexp->Kind == kVAR_PARAM) {
# line 482 "AdaptF77.puma"
 {
  tTree stmt;
  tTree init;
  struct_shape shp;
  tTree params;
  {
# line 484 "AdaptF77.puma"

# line 485 "AdaptF77.puma"

# line 486 "AdaptF77.puma"

# line 487 "AdaptF77.puma"

# line 489 "AdaptF77.puma"
 GetActualShape (pexp->VAR_PARAM.V, &shp);
     pexp->VAR_PARAM.V = SetActualShape (pexp->VAR_PARAM.V, &shp);
     params = mBTP_EMPTY();
     params = mBTP_LIST (pexp, params);
     params = mBTP_LIST (mVAR_PARAM (var), params);
     stmt   = mREDUCE_STMT (f, params);
     stmt   = mACF_BASIC (stmt);
     LineACFNode (stmt, line);
     if (mask != NoTree)
        { mask = SetActualShape (mask, &shp);
          stmt = mACF_LIST (stmt, mACF_EMPTY ());
          stmt = mACF_IF (mask, stmt, mACF_EMPTY());
        }
     stmt   = MakeOuterLoops (line, &shp, stmt, GEN_DO_INDEPENDENT); 
     stmt   = mACF_LIST (stmt, mACF_EMPTY());
     stmt   = mACF_REDUCTION (true,
                              mBTV_LIST (CopyTree (var), mBTV_EMPTY()), 
                              mBTV_EMPTY (),
                              CopyTree (f), stmt);
     LineACFNode (stmt, line);
     stmt   = mACF_LIST (stmt, NoTree);
     init   = InitReductionStmt (CopyTree(var), TreeType(var), f);
     LineACFNode (init, line);
     stmt   = mACF_LIST (init, stmt);
   
# line 515 "AdaptF77.puma"
   FreeTemporaries0 ();
  }
  {
   return stmt;
  }
 }

  }
 yyAbort ("MakeFullReduction");
}

static tTree MakeDimReduction
# if defined __STDC__ | defined __cplusplus
(register int line, register int dim, register tTree var, register tTree f, register tTree pexp, register tTree mask)
# else
(line, dim, var, f, pexp, mask)
 register int line;
 register int dim;
 register tTree var;
 register tTree f;
 register tTree pexp;
 register tTree mask;
# endif
{
  if (pexp->Kind == kVAR_PARAM) {
# line 543 "AdaptF77.puma"
 {
  tTree stmt;
  tTree init;
  struct_shape shp;
  struct_shape shp_red;
  tTree params;
  tTree var1;
  tTree red_var;
  {
# line 545 "AdaptF77.puma"

# line 546 "AdaptF77.puma"

# line 547 "AdaptF77.puma"

# line 548 "AdaptF77.puma"

# line 549 "AdaptF77.puma"

# line 550 "AdaptF77.puma"

# line 551 "AdaptF77.puma"

# line 553 "AdaptF77.puma"
  red_var = CopyTree (var);

      GetActualShape (pexp->VAR_PARAM.V, &shp);
      pexp->VAR_PARAM.V = SetActualShape (pexp->VAR_PARAM.V, &shp);

      if (mask != NoTree)
         mask = SetActualShape (mask, &shp);

      split_shape (&shp, &shp_red, dim);  
      var1 = SetActualShape (var, &shp);

      params = mBTP_EMPTY();
      params = mBTP_LIST (pexp, params);
      params = mBTP_LIST (mVAR_PARAM (var1), params);
      stmt   = mREDUCE_STMT (f, params);
      stmt   = mACF_BASIC (stmt);
      LineACFNode (stmt, line);

      

      if (mask != NoTree)

         { stmt = MakeStmtList (stmt);
           stmt = mACF_IF (mask, stmt, mACF_EMPTY());
         }

      stmt   = MakeOuterLoops (line, &shp_red, stmt, GEN_DO_INDEPENDENT); 

      stmt   = MakeStmtList (stmt);   

      stmt   = MakeOuterLoops (line, &shp, stmt, GEN_DO_INDEPENDENT); 

      stmt   = MakeStmtList (stmt);   

      stmt   = mACF_REDUCTION (true,
                               mBTV_LIST (red_var, mBTV_EMPTY()), 
                               mBTV_EMPTY (),
                               CopyTree (f), stmt);

      

      init   = InitReductionStmt (CopyTree(var1), TreeType(var1), f);
      LineACFNode (init, line);

      init   = MakeOuterLoops (line, &shp, init, GEN_DO_INDEPENDENT);

      

      stmt   = CombineACF (init, mACF_LIST (stmt, NoTree));

    
# line 605 "AdaptF77.puma"
   FreeTemporaries0 ();
  }
  {
   return stmt;
  }
 }

  }
 yyAbort ("MakeDimReduction");
}

tTree F77LocReduction
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree var, register tTree exp)
# else
(line, var, exp)
 register int line;
 register tTree var;
 register tTree exp;
# endif
{
# line 618 "AdaptF77.puma"
  {
# line 620 "AdaptF77.puma"
   if (! ((TreeWriteDistribution (var) != 0))) goto yyL1;
  {
# line 621 "AdaptF77.puma"
   error_protocol ("pos array must be replicated for minloc/maxloc");
  }
  }
   return NoTree;
yyL1:;

  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 631 "AdaptF77.puma"
 {
  int rank;
  tTree minval_var;
  tTree stmt;
  {
# line 637 "AdaptF77.puma"

# line 638 "AdaptF77.puma"

# line 640 "AdaptF77.puma"
   rank = TreeRank (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
# line 644 "AdaptF77.puma"
   if (! (minval_var = MakeScalarTemporary (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V))) goto yyL2;
  {
# line 648 "AdaptF77.puma"
 if (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("MINLOC")) exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = IsIdent ("MINVAL");
     if (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("MAXLOC")) exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = IsIdent ("MAXVAL");
   
# line 652 "AdaptF77.puma"

# line 654 "AdaptF77.puma"
 stmt = MakeFullReduction (line, minval_var, exp->FUNC_CALL_EXP.FUNC_ID, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, MaskExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem)); 
     InsertLocParams (var, stmt, rank, mBTP_EMPTY());
   
# line 657 "AdaptF77.puma"
   FreeTemporaries0 ();
  }
  }
  {
   return stmt;
  }
 }
yyL2:;

  }
  }
  }
  }
  }
  }
# line 661 "AdaptF77.puma"
  {
# line 662 "AdaptF77.puma"
   error_protocol ("MINLOC / MAXLOC : do not support DIM argument");
  }
   return mACF_DUMMY ();

  }
 yyAbort ("F77LocReduction");
}

static void FindValVar
# if defined __STDC__ | defined __cplusplus
(register tTree array, register tTree mask, register tTree * yyP2, register tTree * yyP1)
# else
(array, mask, yyP2, yyP1)
 register tTree array;
 register tTree mask;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 668 "AdaptF77.puma"
 {
  tTree new_var;
  tTree maj_var;
  int code;
  {
# line 670 "AdaptF77.puma"

# line 671 "AdaptF77.puma"

# line 672 "AdaptF77.puma"

# line 674 "AdaptF77.puma"
   GetMajorityVar (array, & code, & maj_var);
# line 676 "AdaptF77.puma"
 new_var = NoTree;
      if (code == -1)
        error_protocol ("implicit movement for array in minloc/maxloc");
      else if (code == 0)  
        error_protocol ("problem: cannot create var for value");
      else 
        { 

          new_var = GetScalarTemporary (TreeType (maj_var));
        }
    
  }
   * yyP2 = new_var;
   * yyP1 = maj_var;
   return;
 }

;
}

static void InsertLocParams
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt, register int n, register tTree p)
# else
(var, stmt, n, p)
 register tTree var;
 register tTree stmt;
 register int n;
 register tTree p;
# endif
{
# line 707 "AdaptF77.puma"
  {
# line 708 "AdaptF77.puma"
   if (! ((stmt == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (stmt->Kind == kACF_REDUCTION) {
  if (stmt->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (stmt->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 711 "AdaptF77.puma"
 {
  tTree red_vars;
  int i;
  {
# line 714 "AdaptF77.puma"

# line 715 "AdaptF77.puma"

# line 717 "AdaptF77.puma"
 red_vars = stmt->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next;
     for (i=n; i>=1; i--)
         red_vars = mBTV_LIST (NthPos (var, i), red_vars);
     stmt->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next = red_vars;
   
# line 723 "AdaptF77.puma"
   InsertLocParams (var, stmt->ACF_REDUCTION.REDUCTION_BODY, n, p);
  }
   return;
 }

  }
  }
  }
  if (stmt->Kind == kACF_LIST) {
# line 726 "AdaptF77.puma"
  {
# line 727 "AdaptF77.puma"
   if (! ((stmt->ACF_LIST.Next == NoTree))) goto yyL3;
  {
# line 728 "AdaptF77.puma"
   InsertLocParams (var, stmt->ACF_LIST.Elem, n, p);
  }
  }
   return;
yyL3:;

# line 731 "AdaptF77.puma"
  {
# line 732 "AdaptF77.puma"
   InsertLocParams (var, stmt->ACF_LIST.Elem, n, p);
# line 733 "AdaptF77.puma"
   InsertLocParams (var, stmt->ACF_LIST.Next, n, p);
  }
   return;

  }
  if (stmt->Kind == kACF_EMPTY) {
# line 736 "AdaptF77.puma"
   return;

  }
  if (stmt->Kind == kACF_DO) {
# line 739 "AdaptF77.puma"
 {
  tTree params;
  {
# line 741 "AdaptF77.puma"
   if (! ((IsParallelLoop (stmt)))) goto yyL6;
  {
# line 743 "AdaptF77.puma"

# line 745 "AdaptF77.puma"
 params = MakePosParams (var, n, stmt->ACF_DO.DO_ID, stmt->ACF_DO.DO_RANGE);
     params = ConcatParams (params, p);
   
# line 748 "AdaptF77.puma"
   InsertLocParams (var, stmt->ACF_DO.DO_BODY, n - 1, params);
  }
  }
   return;
 }
yyL6:;

  }
  if (stmt->Kind == kACF_IF) {
# line 751 "AdaptF77.puma"
  {
# line 752 "AdaptF77.puma"
   InsertLocParams (var, stmt->ACF_IF.THEN_PART, n, p);
# line 753 "AdaptF77.puma"
   InsertLocParams (var, stmt->ACF_IF.ELSE_PART, n, p);
  }
   return;

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 756 "AdaptF77.puma"
   return;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 759 "AdaptF77.puma"
  {
# line 761 "AdaptF77.puma"
 stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS = ConcatParams (stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, p); 
  }
   return;

  }
  }
# line 764 "AdaptF77.puma"
  {
# line 765 "AdaptF77.puma"
   failure_protocol ("AdaptF77", "InsertLocParams", stmt);
  }
   return;

;
}

static tTree MakePosParams
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n, register tTree id, register tTree slice)
# else
(var, n, id, slice)
 register tTree var;
 register int n;
 register tTree id;
 register tTree slice;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (slice->Kind == kSLICE_EXP) {
# line 770 "AdaptF77.puma"
 {
  tTree param1;
  tTree param2;
  {
# line 772 "AdaptF77.puma"

# line 773 "AdaptF77.puma"

# line 775 "AdaptF77.puma"
 param1 = mVAR_PARAM (NthPos (var, n));

     param2 = mVAR_EXP (CopyTree (id));
     param2 = MakeRangeExp (slice->SLICE_EXP.START, param2, slice->SLICE_EXP.INC);   
     param2 = ExpToVarParam (param2);

   
  }
  {
   return mBTP_LIST (param1, mBTP_LIST (param2, NoTree));
  }
 }

  }
  }
# line 785 "AdaptF77.puma"
  {
# line 786 "AdaptF77.puma"
   failure_protocol ("AdaptF77", "MakePosParams", var);
  }
   return NoTree;

}

static tTree NthPos
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n)
# else
(var, n)
 register tTree var;
 register int n;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 804 "AdaptF77.puma"
   return mINDEXED_VAR (var->INDEXED_VAR.IND_VAR, NthPos (var->INDEXED_VAR.IND_EXPS, n));

  }
  if (var->Kind == kBTE_LIST) {
# line 808 "AdaptF77.puma"
   return mBTE_LIST (NthPos (var->BTE_LIST.Elem, n), NthPos (var->BTE_LIST.Next, n));

  }
  if (var->Kind == kBTE_EMPTY) {
# line 812 "AdaptF77.puma"
   return var;

  }
  if (var->Kind == kSLICE_EXP) {
# line 816 "AdaptF77.puma"
 {
  bool found;
  int val;
  {
# line 818 "AdaptF77.puma"

# line 819 "AdaptF77.puma"

# line 821 "AdaptF77.puma"
   SliceIncrement (var, & found, & val);
# line 822 "AdaptF77.puma"
   if (! ((found))) goto yyL4;
  }
  {
   return AddConstant (CopyTree (var->SLICE_EXP.START), (n - 1) * val);
  }
 }
yyL4:;

# line 826 "AdaptF77.puma"
 {
  tTree exp;
  {
# line 828 "AdaptF77.puma"

# line 829 "AdaptF77.puma"
 exp = MultConstant (CopyTree(var->SLICE_EXP.INC), n-1);
     exp = mOP_EXP (mOP_PLUS(), CopyTree(var->SLICE_EXP.START), exp);
   
  }
  {
   return exp;
  }
 }

  }
# line 835 "AdaptF77.puma"
   return CopyTree (var);

}

tTree F77ManyAssign
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kARRAY_EXP) {
# line 851 "AdaptF77.puma"
   return MakeAssignments (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, 0, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->ARRAY_EXP.ELEMENTS);

  }
  }
  }
# line 856 "AdaptF77.puma"
  {
# line 857 "AdaptF77.puma"
   failure_protocol (MODULE, "F77ManyAssign", t);
  }
   return NoTree;

}

static tTree MakeAssignments
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n, register tTree elements)
# else
(var, n, elements)
 register tTree var;
 register int n;
 register tTree elements;
# endif
{
  if (elements->Kind == kBTE_LIST) {
# line 863 "AdaptF77.puma"
   return mACF_LIST (MakeAssignment (CopyTree (var), n, elements->BTE_LIST.Elem), MakeAssignments (var, n + 1, elements->BTE_LIST.Next));

  }
  if (elements->Kind == kBTE_EMPTY) {
# line 868 "AdaptF77.puma"
   return NoTree;

  }
# line 872 "AdaptF77.puma"
  {
# line 873 "AdaptF77.puma"
   failure_protocol (MODULE, "MakeAssignments", var);
  }
   return NoTree;

}

static tTree MakeAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n, register tTree elem)
# else
(var, n, elem)
 register tTree var;
 register int n;
 register tTree elem;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 885 "AdaptF77.puma"
  {
# line 887 "AdaptF77.puma"
   SetIndexValue (var->INDEXED_VAR.IND_EXPS, n);
  }
   return mACF_BASIC (mASSIGN_STMT (var, elem));

  }
# line 891 "AdaptF77.puma"
  {
# line 893 "AdaptF77.puma"
   failure_protocol (MODULE, "MakeAssignment", var);
  }
   return NoTree;

}

static void SetIndexValue
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int n)
# else
(indexes, n)
 register tTree indexes;
 register int n;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 899 "AdaptF77.puma"
 {
  bool found;
  int val;
  {
# line 901 "AdaptF77.puma"

# line 902 "AdaptF77.puma"

# line 904 "AdaptF77.puma"
   SliceIncrement (indexes->BTE_LIST.Elem, & found, & val);
# line 905 "AdaptF77.puma"
   if (! ((found))) goto yyL1;
  {
# line 907 "AdaptF77.puma"
 indexes->BTE_LIST.Elem = AddConstant (indexes->BTE_LIST.Elem->SLICE_EXP.START, val*n); 
  }
  }
   return;
 }
yyL1:;

# line 910 "AdaptF77.puma"
  {
# line 912 "AdaptF77.puma"
 indexes->BTE_LIST.Elem = mOP_EXP (mOP_PLUS(), indexes->BTE_LIST.Elem->SLICE_EXP.START, MultConstant (indexes->BTE_LIST.Elem->SLICE_EXP.INC, n)); 
  }
   return;

  }
# line 915 "AdaptF77.puma"
  {
# line 916 "AdaptF77.puma"
   SetIndexValue (indexes->BTE_LIST.Next, n);
  }
   return;

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 919 "AdaptF77.puma"
  {
# line 920 "AdaptF77.puma"
   error_protocol ("could not make single assignments");
  }
   return;

  }
;
}

static void GetExpShape
# if defined __STDC__ | defined __cplusplus
(register tTree exp, shape s)
# else
(exp, s)
 register tTree exp;
 shape s;
# endif
{
# line 933 "AdaptF77.puma"
  {
# line 935 "AdaptF77.puma"
   if (! ((! DoLoopExpression (exp)))) goto yyL1;
  {
# line 937 "AdaptF77.puma"
   failure_protocol (MODULE, "GetExpShape (illegal tree)", exp);
  }
  }
   return;
yyL1:;

# line 940 "AdaptF77.puma"
  {
# line 942 "AdaptF77.puma"
   GetActualShape (exp, s);
  }
   return;

;
}

void BeginAdaptF77 ()
{
}

void CloseAdaptF77 ()
{
}
