# include "AdaptAnalysis.h"
# include "yyAdaptAnalysis.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 62 "AdaptAnalysis.puma"


# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "ShowDefs.h"

# include "TreeOps.h"
# include "Objects.h"
# include "Types.h"
# include "Rank.h"
# include "Intrinsics.h"

# include "DefTable.h"
# include "Distributions.h"

# include "ArrayData.h"        /* SetActualOverlap                  */

# include "Common.h"           /* CheckCommonDistributions         */
# include "Expressions.h"      /* GetIntConstValue                 */

# include "Nesting.h"          /* always needed with units         */
# include "Traverse.h"         /* FullTraverse                     */

static int match_error;      /* global error flag */
static int overlap_error;    /* global error flag */

# define MODULE "AdaptAnalysis"

/*********************************************************************
*                                                                    * 
*    A s s e r t   F o r t r a n 9 0                                 * 
*                                                                    * 
*********************************************************************/

static void AssertFortran90 (kind)
char *kind;

{ char msg[MAX_LINE_LENGTH];

  if (target_language == FORTRAN_90) return;
  if (target_language == FORTRAN_95) return;
 
  sprintf (msg, "%s unsupported if not Fortran 90 (use flag -F90)", kind);
  error_protocol (msg);

} /* AssertFortran90 */

/*********************************************************************
*                                                                    * 
*    A s s e r t   F o r t r a n 9 0                                 * 
*                                                                    * 
*********************************************************************/

static void Unsupported (kind)
char *kind;

{ char msg[MAX_LINE_LENGTH];

  if (test_flag) return;

  sprintf (msg, "%s unsupported in ADAPTOR", kind);
  error_protocol (msg);

} /* Unsupported */



static void yyExit () { Exit (1); }

void (* AdaptAnalysis_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptAnalysis, routine %s failed\n", yyFunction);
 AdaptAnalysis_Exit ();
}

static void AssertFullHPF ARGS(());
void AdaptAnalysis ARGS((tTree t));
static void CheckRecursion ARGS((tTree t));
static void CheckUnsupported ARGS((tTree t));
static void CheckInternals ARGS((tTree internals));
static void CheckReplicatedVars ARGS((tTree t, tTree decl));
static void CheckNameListVars ARGS((tTree t, tTree nl));
static void AdaptAnaDistributions ARGS((tDefinitions t));
static void CheckObjDistribution ARGS((tDefinitions Obj));
static void CheckObjKind ARGS((tDefinitions obj));
static void VerifyDistribution ARGS((tDefinitions d, tDefinitions Obj));
static void CheckAlignSourceList ARGS((tDefinitions dl));
static void ValidateActual ARGS((tDefinitions actual_obj, tDefinitions formal_obj));
static void AnaIntrinsicFunction ARGS((tIdent name, tTree params));
static void AnaReductionParameters ARGS((tTree params));
static void AdaptAnalReduceParams ARGS((tTree t));
static bool DistributedParameters ARGS((tTree plist));
static bool ReplicatedParameters ARGS((tTree plist));
static void CheckCommons ARGS((tDefinitions t));
static void AnaPureCheck ARGS((tTree t));
static void PureCheck ARGS((tTree t));
static void AdaptAnaOverlaps ARGS((tDefinitions t));
static tTree GetCommonDeclarations ARGS((tDefinitions obj));
static void CheckDistributeSpec ARGS((tTree spec));
static void CheckProcessorsSpec ARGS((tTree p));

static void AssertFullHPF
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 134 "AdaptAnalysis.puma"
  {
# line 136 "AdaptAnalysis.puma"
   if (! ((source_language != HPF_FULL))) goto yyL1;
  {
# line 137 "AdaptAnalysis.puma"
   error_protocol ("not included in Subset HPF (use flag -HPF)");
  }
  }
   return;
yyL1:;

;
}

void AdaptAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 148 "AdaptAnalysis.puma"
  {
# line 150 "AdaptAnalysis.puma"
   open_protocol ("adaptor.ana");
# line 151 "AdaptAnalysis.puma"
   AdaptAnalysis (t->COMP_UNIT.COMP_ELEMENTS);
# line 152 "AdaptAnalysis.puma"
   CheckCommons (GetCommonEntries ());
# line 153 "AdaptAnalysis.puma"
   close_protocol ();
  }
   return;

  case kUNIT_EMPTY:
# line 156 "AdaptAnalysis.puma"
   return;

  case kUNIT_LIST:
# line 159 "AdaptAnalysis.puma"
  {
# line 160 "AdaptAnalysis.puma"
   AdaptAnalysis (t->UNIT_LIST.Elem);
# line 161 "AdaptAnalysis.puma"
   AdaptAnalysis (t->UNIT_LIST.Next);
  }
   return;

  case kPROGRAM_DECL:
# line 173 "AdaptAnalysis.puma"
  {
# line 175 "AdaptAnalysis.puma"
   NestOpenUnit (t);
# line 176 "AdaptAnalysis.puma"
   AdaptAnalysis (t->PROGRAM_DECL.PROGRAM_BODY);
# line 177 "AdaptAnalysis.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 180 "AdaptAnalysis.puma"
  {
# line 182 "AdaptAnalysis.puma"
   CheckRecursion (t);
# line 183 "AdaptAnalysis.puma"
   NestOpenUnit (t);
# line 184 "AdaptAnalysis.puma"
   AdaptAnalysis (t->PROC_DECL.PROC_BODY);
# line 185 "AdaptAnalysis.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 188 "AdaptAnalysis.puma"
  {
# line 190 "AdaptAnalysis.puma"
   CheckRecursion (t);
# line 191 "AdaptAnalysis.puma"
   NestOpenUnit (t);
# line 192 "AdaptAnalysis.puma"
   AdaptAnalysis (t->FUNC_DECL.FUNC_BODY);
# line 193 "AdaptAnalysis.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 196 "AdaptAnalysis.puma"
  {
# line 198 "AdaptAnalysis.puma"
   AssertFortran90 ("MODULE");
# line 199 "AdaptAnalysis.puma"
   NestOpenUnit (t);
# line 200 "AdaptAnalysis.puma"
   AdaptAnalysis (t->MODULE_DECL.MODULE_BODY);
# line 201 "AdaptAnalysis.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 204 "AdaptAnalysis.puma"
  {
# line 206 "AdaptAnalysis.puma"
   NestOpenUnit (t);
# line 207 "AdaptAnalysis.puma"
   AdaptAnalysis (t->BLOCK_DATA_DECL.DATA_BODY);
# line 208 "AdaptAnalysis.puma"
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
# line 211 "AdaptAnalysis.puma"
  {
# line 213 "AdaptAnalysis.puma"
   FullTraverseAST (t, CheckUnsupported);
  }
   return;

  }

;
}

static void CheckRecursion
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
# line 224 "AdaptAnalysis.puma"
  {
# line 226 "AdaptAnalysis.puma"
   if (! ((t->PROC_DECL.IsRecursive))) goto yyL1;
  {
# line 227 "AdaptAnalysis.puma"
   set_protocol_unit (t);
# line 228 "AdaptAnalysis.puma"
   set_protocol_stmt (NoTree);
# line 229 "AdaptAnalysis.puma"
   AssertFortran90 ("RECURSIVE");
  }
  }
   return;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
# line 232 "AdaptAnalysis.puma"
  {
# line 234 "AdaptAnalysis.puma"
   if (! ((t->FUNC_DECL.IsRecursive))) goto yyL2;
  {
# line 235 "AdaptAnalysis.puma"
   set_protocol_unit (t);
# line 236 "AdaptAnalysis.puma"
   set_protocol_stmt (NoTree);
# line 237 "AdaptAnalysis.puma"
   AssertFortran90 ("RECURSIVE");
  }
  }
   return;
yyL2:;

  }
;
}

static void CheckUnsupported
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kBODY_NODE:
# line 251 "AdaptAnalysis.puma"
  {
# line 253 "AdaptAnalysis.puma"
   AdaptAnaDistributions (GetCurrentScope ());
# line 254 "AdaptAnalysis.puma"
   AdaptAnaOverlaps (GetCurrentScope ());
# line 256 "AdaptAnalysis.puma"
   AnaPureCheck (t);
# line 258 "AdaptAnalysis.puma"
   CheckInternals (t->BODY_NODE.INTERNALS);
  }
   return;

  case kPROCESSORS_DECL:
# line 261 "AdaptAnalysis.puma"
  {
# line 263 "AdaptAnalysis.puma"
   if (! ((TreeListLength (t->PROCESSORS_DECL.DIMENSIONS) > MAX_TORUS_RANK))) goto yyL2;
  {
# line 265 "AdaptAnalysis.puma"
   error_protocol ("too many dimensions for PROCESSOR ARRAY");
  }
  }
   return;
yyL2:;

  break;
  case kINIT_DATA_DECL:
# line 268 "AdaptAnalysis.puma"
  {
# line 270 "AdaptAnalysis.puma"
   error_protocol ("INIT not allowed (make initial statements)");
  }
   return;

  case kTARGET_DECL:
# line 273 "AdaptAnalysis.puma"
  {
# line 275 "AdaptAnalysis.puma"
   Unsupported ("TARGET attribute");
  }
   return;

  case kPOINTER_DECL:
# line 278 "AdaptAnalysis.puma"
   return;

  case kPRIVATE_DECL:
# line 283 "AdaptAnalysis.puma"
  {
# line 285 "AdaptAnalysis.puma"
   AssertFortran90 ("PRIVATE");
  }
   return;

  case kSEQUENCE_DECL:
# line 288 "AdaptAnalysis.puma"
  {
# line 290 "AdaptAnalysis.puma"
   AssertFortran90 ("SEQUENCE");
  }
   return;

  case kRANGE_DECL:
# line 293 "AdaptAnalysis.puma"
  {
# line 295 "AdaptAnalysis.puma"
   CheckDistributeSpec (t->RANGE_DECL.RANGES);
  }
   return;

  case kDYNAMIC_DECL:
# line 298 "AdaptAnalysis.puma"
  {
# line 300 "AdaptAnalysis.puma"
   AssertFullHPF ();
  }
   return;

  case kNAMELIST_DECL:
# line 303 "AdaptAnalysis.puma"
  {
# line 307 "AdaptAnalysis.puma"
   CheckNameListVars (t->NAMELIST_DECL.IDS, t);
  }
   return;

  case kCOMMON_DECL:
# line 310 "AdaptAnalysis.puma"
  {
# line 315 "AdaptAnalysis.puma"
   match_error = 0;
# line 317 "AdaptAnalysis.puma"
   CheckCommonDescriptors (t, ValidateActual);
# line 319 "AdaptAnalysis.puma"
 if (match_error != 0)
        { simple_error_protocol ("MISMATCH of COMMON BLOCK");
          PrintCommonBlock (t, 1);
        }
    
  }
   return;

  case kEQV_DECL:
# line 326 "AdaptAnalysis.puma"
  {
# line 328 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->EQV_DECL.VARS, t);
  }
   return;

  case kDATA_DECL:
# line 331 "AdaptAnalysis.puma"
  {
# line 333 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->DATA_DECL.VARS, t);
  }
   return;

  case kUSE_DECL:
# line 336 "AdaptAnalysis.puma"
  {
# line 338 "AdaptAnalysis.puma"
   if (! ((t->USE_DECL.use == IsIdent ("HPF_LIBRARY")))) goto yyL14;
  }
   return;
yyL14:;

# line 341 "AdaptAnalysis.puma"
  {
# line 343 "AdaptAnalysis.puma"
   if (! ((t->USE_DECL.use == IsIdent ("HPF_LOCAL_LIBRARY")))) goto yyL15;
  }
   return;
yyL15:;

# line 346 "AdaptAnalysis.puma"
  {
# line 348 "AdaptAnalysis.puma"
   if (! ((t->USE_DECL.use == IsIdent ("HPF_TASK_LIBRARY")))) goto yyL16;
  }
   return;
yyL16:;

  if (t->USE_DECL.RENAMINGS->Kind == kDECL_EMPTY) {
# line 351 "AdaptAnalysis.puma"
  {
# line 353 "AdaptAnalysis.puma"
   AssertFortran90 ("USE");
  }
   return;

  }
# line 356 "AdaptAnalysis.puma"
  {
# line 358 "AdaptAnalysis.puma"
   AssertFortran90 ("USE");
# line 359 "AdaptAnalysis.puma"
   Unsupported ("USE with renaming");
  }
   return;

  case kONLY_USE_DECL:
  if (t->ONLY_USE_DECL.NAMES->Kind == kDECL_EMPTY) {
# line 362 "AdaptAnalysis.puma"
  {
# line 364 "AdaptAnalysis.puma"
   AssertFortran90 ("USE ONLY");
  }
   return;

  }
# line 367 "AdaptAnalysis.puma"
  {
# line 369 "AdaptAnalysis.puma"
   AssertFortran90 ("USE ONLY");
# line 370 "AdaptAnalysis.puma"
   Unsupported ("USE with renaming");
  }
   return;

  case kACF_CASE:
# line 373 "AdaptAnalysis.puma"
  {
# line 375 "AdaptAnalysis.puma"
   error_protocol ("CASE should have been converted");
  }
   return;

  case kACF_LOOP:
# line 378 "AdaptAnalysis.puma"
  {
# line 380 "AdaptAnalysis.puma"
   error_protocol ("LOOP should have been converted");
  }
   return;

  case kACF_TASK_REGION:
# line 383 "AdaptAnalysis.puma"
  {
# line 385 "AdaptAnalysis.puma"
   Unsupported ("TASK_REGION");
  }
   return;

  case kCALL_STMT:
# line 388 "AdaptAnalysis.puma"
  {
# line 392 "AdaptAnalysis.puma"
   match_error = 0;
# line 394 "AdaptAnalysis.puma"
   CheckActualDescriptors (t, ValidateActual);
# line 396 "AdaptAnalysis.puma"
 if (match_error > 0)
       { print_protocol ("MISMATCH of ACTUAL arguments with DUMMIES");
         PrintCall (t);
       }
   
  }
   return;

  case kREDUCE_STMT:
# line 403 "AdaptAnalysis.puma"
  {
# line 405 "AdaptAnalysis.puma"
   AdaptAnalReduceParams (t->REDUCE_STMT.RED_PARAMS);
  }
   return;

  case kREDISTRIBUTE_STMT:
# line 408 "AdaptAnalysis.puma"
  {
# line 410 "AdaptAnalysis.puma"
   CheckDistributeSpec (t->REDISTRIBUTE_STMT.DISTRIBUTION);
  }
   return;

  case kCYCLE_STMT:
# line 413 "AdaptAnalysis.puma"
  {
# line 415 "AdaptAnalysis.puma"
   error_protocol ("illegal CYCLE statement");
  }
   return;

  case kEXIT_STMT:
# line 418 "AdaptAnalysis.puma"
  {
# line 420 "AdaptAnalysis.puma"
   error_protocol ("illegal EXIT statement");
  }
   return;

  case kRETURN_STMT:
# line 423 "AdaptAnalysis.puma"
  {
# line 425 "AdaptAnalysis.puma"
   error_protocol ("Remove RETURN, jump to END of subroutine/function");
  }
   return;

  case kTYPE_EXP:
# line 428 "AdaptAnalysis.puma"
  {
# line 430 "AdaptAnalysis.puma"
   AssertFortran90 ("derived type");
  }
   return;

  case kFUNC_CALL_EXP:
# line 433 "AdaptAnalysis.puma"
  {
# line 435 "AdaptAnalysis.puma"
   if (! ((IsIntrCall (t)))) goto yyL31;
  {
# line 437 "AdaptAnalysis.puma"
   AnaIntrinsicFunction (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL31:;

  break;
  }

# line 441 "AdaptAnalysis.puma"
   return;

;
}

static void CheckInternals
# if defined __STDC__ | defined __cplusplus
(register tTree internals)
# else
(internals)
 register tTree internals;
# endif
{
  if (internals->Kind == kUNIT_EMPTY) {
# line 454 "AdaptAnalysis.puma"
   return;

  }
  if (internals->Kind == kUNIT_LIST) {
# line 457 "AdaptAnalysis.puma"
  {
# line 459 "AdaptAnalysis.puma"
   AssertFortran90 ("Internal Routines");
  }
   return;

  }
;
}

static void CheckReplicatedVars
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree decl)
# else
(t, decl)
 register tTree t;
 register tTree decl;
# endif
{

  switch (t->Kind) {
  case kBTV_LIST:
# line 472 "AdaptAnalysis.puma"
  {
# line 474 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->BTV_LIST.Elem, decl);
# line 475 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->BTV_LIST.Next, decl);
  }
   return;

  case kBTV_EMPTY:
# line 478 "AdaptAnalysis.puma"
   return;

  case kUSED_VAR:
# line 481 "AdaptAnalysis.puma"
  {
# line 483 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->USED_VAR.VARNAME, decl);
  }
   return;

  case kINDEXED_VAR:
# line 486 "AdaptAnalysis.puma"
  {
# line 488 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->INDEXED_VAR.IND_VAR, decl);
  }
   return;

  case kSUBSTRING_VAR:
# line 491 "AdaptAnalysis.puma"
  {
# line 493 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->SUBSTRING_VAR.IND_VAR, decl);
  }
   return;

  case kSELECTED_VAR:
# line 496 "AdaptAnalysis.puma"
  {
# line 498 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->SELECTED_VAR.SELEC_VAR, decl);
  }
   return;

  case kVAR_OBJ:
# line 501 "AdaptAnalysis.puma"
  {
# line 503 "AdaptAnalysis.puma"
   if (! ((TreeWriteDistribution (t) != 0))) goto yyL7;
  {
# line 505 "AdaptAnalysis.puma"
   Unsupported ("DATA, EQUIVALENCE with distributed varaibles");
# line 507 "AdaptAnalysis.puma"
   tree_protocol ("Illegal declaration is : \n", decl);
# line 508 "AdaptAnalysis.puma"
   tree_protocol ("Illegal variable is : ", t);
  }
  }
   return;
yyL7:;

# line 511 "AdaptAnalysis.puma"
   return;

  case kDO_VAR:
# line 514 "AdaptAnalysis.puma"
  {
# line 516 "AdaptAnalysis.puma"
   CheckReplicatedVars (t->DO_VAR.BODY, decl);
  }
   return;

  }

# line 519 "AdaptAnalysis.puma"
  {
# line 521 "AdaptAnalysis.puma"
   failure_protocol (MODULE, "CheckReplicatedVars", t);
  }
   return;

;
}

static void CheckNameListVars
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree nl)
# else
(t, nl)
 register tTree t;
 register tTree nl;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 534 "AdaptAnalysis.puma"
  {
# line 536 "AdaptAnalysis.puma"
   CheckNameListVars (t->DECL_LIST.Elem, nl);
# line 537 "AdaptAnalysis.puma"
   CheckNameListVars (t->DECL_LIST.Next, nl);
  }
   return;

  }
  if (t->Kind == kVAR_DECL) {
# line 540 "AdaptAnalysis.puma"
  {
# line 542 "AdaptAnalysis.puma"
   if (! ((VarDistribution (GetGlobalObject (t->VAR_DECL.Ident)) == 1))) goto yyL2;
  {
# line 544 "AdaptAnalysis.puma"
   Unsupported ("distributed variable in NAMELIST");
# line 545 "AdaptAnalysis.puma"
   tree_protocol ("namelist        : ", nl);
# line 546 "AdaptAnalysis.puma"
   tree_protocol ("distributed var : ", t);
  }
  }
   return;
yyL2:;

  }
;
}

static void AdaptAnaDistributions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kENTRY_LIST) {
# line 560 "AdaptAnalysis.puma"
  {
# line 562 "AdaptAnalysis.puma"
   set_protocol_stmt (t->ENTRY_LIST.Elem->Object.decl);
# line 564 "AdaptAnalysis.puma"
   CheckObjKind (t->ENTRY_LIST.Elem);
# line 565 "AdaptAnalysis.puma"
   CheckObjDistribution (t->ENTRY_LIST.Elem);
# line 566 "AdaptAnalysis.puma"
   AdaptAnaDistributions (t->ENTRY_LIST.Next);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 569 "AdaptAnalysis.puma"
   return;

  }
;
}

static void CheckObjDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
  if (Obj->Kind == kVarObject) {
  if (Obj->VarObject.Dist->Kind == kDefaultDistribution) {
# line 580 "AdaptAnalysis.puma"
  {
# line 582 "AdaptAnalysis.puma"
   obj_error_protocol ("default distribution should not happen", Obj);
  }
   return;

  }
  if (Obj->VarObject.Dist->Kind == kDeclDistribution) {
# line 585 "AdaptAnalysis.puma"
  {
# line 587 "AdaptAnalysis.puma"
   obj_error_protocol ("not evaluated distribution should not happen", Obj);
  }
   return;

  }
  if (Obj->VarObject.Dist->Kind == kReplicatedDistribution) {
# line 590 "AdaptAnalysis.puma"
   return;

  }
# line 593 "AdaptAnalysis.puma"
  {
# line 595 "AdaptAnalysis.puma"
   VerifyDistribution (Obj->VarObject.Dist, Obj);
  }
   return;

  }
  if (Obj->Kind == kTemplateObject) {
# line 598 "AdaptAnalysis.puma"
  {
# line 600 "AdaptAnalysis.puma"
   VerifyDistribution (Obj->TemplateObject.Dist, Obj);
  }
   return;

  }
;
}

static void CheckObjKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
  if (obj->VarObject.Dist->Kind == kNodeDistribution) {
# line 613 "AdaptAnalysis.puma"
  {
# line 615 "AdaptAnalysis.puma"
   if (! ((obj->VarObject.Kind->VarLocal.save))) goto yyL1;
  {
# line 616 "AdaptAnalysis.puma"
   Unsupported ("SAVE for distributed arrays");
# line 617 "AdaptAnalysis.puma"
   obj_protocol ("illegal obj : ", obj);
  }
  }
   return;
yyL1:;

  }
# line 620 "AdaptAnalysis.puma"
  {
# line 622 "AdaptAnalysis.puma"
   if (! ((obj->VarObject.Kind->VarLocal.dynamic == arr_assumed_size))) goto yyL2;
  {
# line 624 "AdaptAnalysis.puma"
   error_protocol ("assumed size not allowed for local variables");
# line 625 "AdaptAnalysis.puma"
   obj_protocol ("illegal obj : ", obj);
  }
  }
   return;
yyL2:;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
  if (obj->VarObject.Dist->Kind == kNodeDistribution) {
# line 628 "AdaptAnalysis.puma"
  {
# line 630 "AdaptAnalysis.puma"
   if (! ((obj->VarObject.Kind->VarDummy.dynamic == arr_assumed_size))) goto yyL3;
  {
# line 632 "AdaptAnalysis.puma"
   error_protocol ("assumed size arrays must not be distributed");
# line 633 "AdaptAnalysis.puma"
   obj_protocol ("illegal obj : ", obj);
  }
  }
   return;
yyL3:;

  }
  }
# line 636 "AdaptAnalysis.puma"
  {
# line 638 "AdaptAnalysis.puma"
   if (! ((obj->VarObject.Dist->Distribution.inherited == 1))) goto yyL4;
  {
# line 639 "AdaptAnalysis.puma"
   if (! ((VarRank (obj) == 0))) goto yyL4;
  {
# line 640 "AdaptAnalysis.puma"
   error_protocol ("dummy scalar cannot be inherited");
# line 641 "AdaptAnalysis.puma"
   obj_protocol ("illegal obj : ", obj);
  }
  }
  }
   return;
yyL4:;

# line 644 "AdaptAnalysis.puma"
  {
# line 646 "AdaptAnalysis.puma"
   if (! ((obj->VarObject.trace))) goto yyL5;
  {
# line 647 "AdaptAnalysis.puma"
   if (! ((VarRank (obj) == 0))) goto yyL5;
  {
# line 648 "AdaptAnalysis.puma"
   error_protocol ("scalar cannot be traced");
# line 649 "AdaptAnalysis.puma"
   obj_protocol ("illegal obj : ", obj);
  }
  }
  }
   return;
yyL5:;

  }
# line 652 "AdaptAnalysis.puma"
   return;

;
}

static void VerifyDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tDefinitions Obj)
# else
(d, Obj)
 register tDefinitions d;
 register tDefinitions Obj;
# endif
{
  if (d->Kind == kDefaultDistribution) {
# line 663 "AdaptAnalysis.puma"
  {
# line 665 "AdaptAnalysis.puma"
   obj_error_protocol ("object has still default distribution", Obj);
  }
   return;

  }
  if (d->Kind == kDeclDistribution) {
# line 668 "AdaptAnalysis.puma"
  {
# line 670 "AdaptAnalysis.puma"
   obj_error_protocol ("layout directive should have been evaluated", Obj);
  }
   return;

  }
  if (d->Kind == kReplicatedDistribution) {
# line 673 "AdaptAnalysis.puma"
   return;

  }
  if (d->Kind == kRangeDistribution) {
  if (Obj->Kind == kVarObject) {
# line 676 "AdaptAnalysis.puma"
   return;

  }
  }
  if (d->Kind == kNodeDistribution) {
  if (Obj->Kind == kVarObject) {
# line 679 "AdaptAnalysis.puma"
  {
# line 681 "AdaptAnalysis.puma"
 

    if (VarRank (d->NodeDistribution.top_obj) > MAX_TORUS_RANK)

      { char msg [MAX_LINE_LENGTH];

        sprintf (msg,"ARRAY has %d distributed dims, only %d are allowed",
                 VarRank (d->NodeDistribution.top_obj), MAX_TORUS_RANK);
        error_protocol (msg);
        obj_protocol ("illegal object : ", Obj);
      }
   
  }
   return;

  }
  if (Obj->Kind == kTemplateObject) {
# line 695 "AdaptAnalysis.puma"
  {
# line 697 "AdaptAnalysis.puma"
 if (VarRank (d->NodeDistribution.top_obj) > MAX_TORUS_RANK)

      { char msg [MAX_LINE_LENGTH];

        sprintf (msg,"ARRAY has %d distributed dims, only %d are allowed",
                 VarRank(d->NodeDistribution.top_obj), MAX_TORUS_RANK);
        error_protocol (msg);
        obj_protocol ("illegal object : ", Obj);
      }
   
  }
   return;

  }
  }
  if (d->Kind == kAlignDistribution) {
# line 709 "AdaptAnalysis.puma"
  {
# line 711 "AdaptAnalysis.puma"
   CheckAlignSourceList (d->AlignDistribution.SourceList);
  }
   return;

  }
# line 716 "AdaptAnalysis.puma"
  {
# line 718 "AdaptAnalysis.puma"
   error_protocol ("not supported distribution");
# line 719 "AdaptAnalysis.puma"
   obj_protocol ("illegal obj : ", Obj);
  }
   return;

;
}

static void CheckAlignSourceList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dl)
# else
(dl)
 register tDefinitions dl;
# endif
{
  if (dl->Kind == kDIM_LIST) {
# line 730 "AdaptAnalysis.puma"
  {
# line 732 "AdaptAnalysis.puma"
   CheckAlignSourceList (dl->DIM_LIST.Elem);
# line 733 "AdaptAnalysis.puma"
   CheckAlignSourceList (dl->DIM_LIST.Next);
  }
   return;

  }
  if (dl->Kind == kDIM_EMPTY) {
# line 736 "AdaptAnalysis.puma"
   return;

  }
  if (dl->Kind == kAlignedDimension) {
# line 739 "AdaptAnalysis.puma"
 {
  bool found;
  int val;
  {
# line 741 "AdaptAnalysis.puma"

# line 742 "AdaptAnalysis.puma"

# line 744 "AdaptAnalysis.puma"
 GetIntConstValue (dl->AlignedDimension.mult, &found, &val);
     if (!found)
      { error_protocol ("mult val in alignment must be known at compile time");
        tree_protocol ("unknown the val of : ", dl->AlignedDimension.mult);
      }
     GetIntConstValue (dl->AlignedDimension.add, &found, &val);
     if (!found)
      { error_protocol ("add val in alignment must be known at compile time");
        tree_protocol ("unknown the val of : ", dl->AlignedDimension.add);
      }
   
  }
   return;
 }

  }
;
}

static void ValidateActual
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_obj, register tDefinitions formal_obj)
# else
(actual_obj, formal_obj)
 register tDefinitions actual_obj;
 register tDefinitions formal_obj;
# endif
{
# line 771 "AdaptAnalysis.puma"
   return;

;
}

static void AnaIntrinsicFunction
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
# line 782 "AdaptAnalysis.puma"
  {
# line 784 "AdaptAnalysis.puma"
   if (! ((name == IsIdent ("MODULO")))) goto yyL1;
  {
# line 785 "AdaptAnalysis.puma"
   AssertFortran90 ("intrinsic MODULO");
  }
  }
   return;
yyL1:;

# line 788 "AdaptAnalysis.puma"
  {
# line 790 "AdaptAnalysis.puma"
   if (! ((IntrFuncRed (name)))) goto yyL2;
  {
# line 791 "AdaptAnalysis.puma"
   AnaReductionParameters (params);
  }
  }
   return;
yyL2:;

  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
# line 794 "AdaptAnalysis.puma"
  {
# line 796 "AdaptAnalysis.puma"
   if (! ((IntrFuncLocRed (name)))) goto yyL3;
  }
   return;
yyL3:;

  }
  }
  }
# line 799 "AdaptAnalysis.puma"
  {
# line 801 "AdaptAnalysis.puma"
   if (! ((IntrFuncLocRed (name)))) goto yyL4;
  {
# line 803 "AdaptAnalysis.puma"
   error_protocol ("dim argument must be available in MINLOC/MAXLOC");
  }
  }
   return;
yyL4:;

  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 806 "AdaptAnalysis.puma"
  {
# line 809 "AdaptAnalysis.puma"
   if (! (((name == IsIdent ("LBOUND")) || (name == IsIdent ("UBOUND"))))) goto yyL5;
  {
# line 812 "AdaptAnalysis.puma"
   error_protocol ("dim argument must be available in LBOUND/UBOUND");
  }
  }
   return;
yyL5:;

  }
  }
  }
  }
;
}

static void AnaReductionParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
# line 820 "AdaptAnalysis.puma"
   return;

  }
# line 825 "AdaptAnalysis.puma"
 {
  int idim;
  bool found;
  {
# line 829 "AdaptAnalysis.puma"

# line 830 "AdaptAnalysis.puma"

# line 832 "AdaptAnalysis.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, & found, & idim);
# line 833 "AdaptAnalysis.puma"
   if (! ((found))) goto yyL2;
  }
   return;
 }
yyL2:;

  }
  }
# line 836 "AdaptAnalysis.puma"
  {
# line 838 "AdaptAnalysis.puma"
   error_protocol ("dim of reduction must be known at compile time");
  }
   return;

;
}

static void AdaptAnalReduceParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_EMPTY) {
# line 857 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 860 "AdaptAnalysis.puma"
  {
# line 862 "AdaptAnalysis.puma"
 if (TreeWriteDistribution (t->BTP_LIST.Elem->VAR_PARAM.V) != 0)
       { warning_protocol ("REDUCE variable is not replicated");
         tree_protocol ("REDUCE variable is : ", t->BTP_LIST.Elem->VAR_PARAM.V);
       }
   
# line 867 "AdaptAnalysis.puma"
   AdaptAnalReduceParams (t->BTP_LIST.Next->BTP_LIST.Next);
  }
   return;

  }
  }
  }
;
}

static bool DistributedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree plist)
# else
(plist)
 register tTree plist;
# endif
{
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 880 "AdaptAnalysis.puma"
  {
# line 881 "AdaptAnalysis.puma"
   if (! ((TreeWriteDistribution (plist->BTP_LIST.Elem->VAR_PARAM.V) == 1))) goto yyL1;
  {
# line 882 "AdaptAnalysis.puma"
   if (! (DistributedParameters (plist->BTP_LIST.Next))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 885 "AdaptAnalysis.puma"
   return true;

  }
  }
  }
  if (plist->Kind == kBTP_EMPTY) {
# line 889 "AdaptAnalysis.puma"
   return true;

  }
  return false;
}

static bool ReplicatedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree plist)
# else
(plist)
 register tTree plist;
# endif
{
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 902 "AdaptAnalysis.puma"
  {
# line 903 "AdaptAnalysis.puma"
   if (! ((TreeWriteDistribution (plist->BTP_LIST.Elem->VAR_PARAM.V) == 0))) goto yyL1;
  {
# line 904 "AdaptAnalysis.puma"
   if (! (ReplicatedParameters (plist->BTP_LIST.Next))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 907 "AdaptAnalysis.puma"
   return true;

  }
  }
  }
  if (plist->Kind == kBTP_EMPTY) {
# line 911 "AdaptAnalysis.puma"
   return true;

  }
  return false;
}

static void CheckCommons
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kENTRY_LIST) {
# line 925 "AdaptAnalysis.puma"
  {
# line 927 "AdaptAnalysis.puma"
   set_protocol_stmt (t->ENTRY_LIST.Elem->Object.decl);
# line 929 "AdaptAnalysis.puma"
   CheckCommons (t->ENTRY_LIST.Next);
# line 930 "AdaptAnalysis.puma"
   CheckCommons (t->ENTRY_LIST.Elem);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 933 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kCommonObject) {
# line 936 "AdaptAnalysis.puma"
  {
# line 938 "AdaptAnalysis.puma"
   if (! ((t->CommonObject.sequence == 1))) goto yyL3;
  {
# line 939 "AdaptAnalysis.puma"
   if (! ((t->CommonObject.distributed_vars > 0))) goto yyL3;
  {
# line 941 "AdaptAnalysis.puma"
   error_protocol ("SEQUENCE association for COMMON with distributed vars");
  }
  }
  }
   return;
yyL3:;

# line 944 "AdaptAnalysis.puma"
  {
# line 946 "AdaptAnalysis.puma"
   if (! ((t->CommonObject.main != true))) goto yyL4;
  {
# line 950 "AdaptAnalysis.puma"
   if (! ((t->CommonObject.distributed_vars > 0))) goto yyL4;
  {
# line 951 "AdaptAnalysis.puma"
   error_protocol ("COMMON with distributed variables not defined in main");
  }
  }
  }
   return;
yyL4:;

  }
;
}

static void AnaPureCheck
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 966 "AdaptAnalysis.puma"
  {
# line 968 "AdaptAnalysis.puma"
   if (! ((! IsPureUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kBODY_NODE) {
# line 971 "AdaptAnalysis.puma"
  {
# line 973 "AdaptAnalysis.puma"
   FullTraverseAST (t->BODY_NODE.DECLS, PureCheck);
# line 974 "AdaptAnalysis.puma"
   FullTraverseAST (t->BODY_NODE.STATS, PureCheck);
  }
   return;

  }
;
}

static void PureCheck
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 979 "AdaptAnalysis.puma"
  {
# line 981 "AdaptAnalysis.puma"
   serious_warning_protocol ("IO in PURE subprograms not allowed");
  }
   return;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 984 "AdaptAnalysis.puma"
  {
# line 988 "AdaptAnalysis.puma"
   if (! ((! IsPureCall (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID)))) goto yyL2;
  {
# line 989 "AdaptAnalysis.puma"
   error_protocol ("CALL of not pure subroutine in PURE subprogram");
  }
  }
   return;
yyL2:;

  }
  }
  if (t->Kind == kFUNC_CALL_EXP) {
# line 992 "AdaptAnalysis.puma"
  {
# line 994 "AdaptAnalysis.puma"
   if (! ((! IsPureCall (t)))) goto yyL3;
  {
# line 995 "AdaptAnalysis.puma"
   error_protocol ("CALL of a not pure function in PURE subprogram");
  }
  }
   return;
yyL3:;

  }
;
}

static void AdaptAnaOverlaps
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kENTRY_LIST) {
# line 1009 "AdaptAnalysis.puma"
  {
# line 1011 "AdaptAnalysis.puma"
   AdaptAnaOverlaps (t->ENTRY_LIST.Elem);
# line 1012 "AdaptAnalysis.puma"
   AdaptAnaOverlaps (t->ENTRY_LIST.Next);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 1015 "AdaptAnalysis.puma"
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Kind->Kind == kVarCommon) {
# line 1024 "AdaptAnalysis.puma"
   return;

  }
  }
;
}

static tTree GetCommonDeclarations
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1035 "AdaptAnalysis.puma"
  {
# line 1036 "AdaptAnalysis.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (obj->Kind == kCommonObject) {
  if (obj->CommonObject.decl->Kind == kCOMMON_DECL) {
# line 1040 "AdaptAnalysis.puma"
   return obj->CommonObject.decl->COMMON_DECL.IDS;

  }
  }
 yyAbort ("GetCommonDeclarations");
}

static void CheckDistributeSpec
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{

  switch (spec->Kind) {
  case kNODE_DISTRIBUTION:
# line 1054 "AdaptAnalysis.puma"
  {
# line 1056 "AdaptAnalysis.puma"
   CheckDistributeSpec (spec->NODE_DISTRIBUTION.MAPPING);
  }
   return;

  case kDEFAULT_DISTRIBUTION:
# line 1059 "AdaptAnalysis.puma"
  {
# line 1061 "AdaptAnalysis.puma"
   error_protocol ("default distribution not evaluated");
  }
   return;

  case kANY_DISTRIBUTION:
# line 1064 "AdaptAnalysis.puma"
  {
# line 1066 "AdaptAnalysis.puma"
   error_protocol ("DISTRIBUTE * not supported yet");
  }
   return;

  case kREPL_DISTRIBUTION:
# line 1069 "AdaptAnalysis.puma"
   return;

  case kRANGE_EMPTY:
# line 1072 "AdaptAnalysis.puma"
   return;

  case kRANGE_LIST:
# line 1075 "AdaptAnalysis.puma"
  {
# line 1077 "AdaptAnalysis.puma"
   CheckDistributeSpec (spec->RANGE_LIST.Elem);
# line 1078 "AdaptAnalysis.puma"
   CheckDistributeSpec (spec->RANGE_LIST.Next);
  }
   return;

  case kDIST_EMPTY:
# line 1081 "AdaptAnalysis.puma"
   return;

  case kDIST_LIST:
# line 1084 "AdaptAnalysis.puma"
  {
# line 1086 "AdaptAnalysis.puma"
   CheckDistributeSpec (spec->DIST_LIST.Elem);
# line 1087 "AdaptAnalysis.puma"
   CheckDistributeSpec (spec->DIST_LIST.Next);
  }
   return;

  case kBLOCK_DISTRIBUTION:
  if (spec->BLOCK_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
# line 1090 "AdaptAnalysis.puma"
   return;

  }
# line 1093 "AdaptAnalysis.puma"
 {
  int size;
  bool found;
  {
# line 1095 "AdaptAnalysis.puma"

# line 1096 "AdaptAnalysis.puma"

# line 1098 "AdaptAnalysis.puma"
   GetIntConstValue (spec->BLOCK_DISTRIBUTION.SIZE, & found, & size);
# line 1100 "AdaptAnalysis.puma"
 if (!found)
         error_protocol ("size of BLOCK unknown at compile time");
    
  }
   return;
 }

  case kCYCLIC_DISTRIBUTION:
  if (spec->CYCLIC_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
# line 1105 "AdaptAnalysis.puma"
   return;

  }
# line 1108 "AdaptAnalysis.puma"
 {
  int size;
  bool found;
  {
# line 1110 "AdaptAnalysis.puma"

# line 1111 "AdaptAnalysis.puma"

# line 1113 "AdaptAnalysis.puma"
   GetIntConstValue (spec->CYCLIC_DISTRIBUTION.SIZE, & found, & size);
# line 1115 "AdaptAnalysis.puma"
 if (!found)
         error_protocol ("size of CYCLIC unknown at compile time");
       else if (size != 1);
         error_protocol ("CYCLIC(N) for N > 1 not supported yet");
    
  }
   return;
 }

  case kSERIAL_DISTRIBUTION:
# line 1122 "AdaptAnalysis.puma"
   return;

  case kGEN_BLOCK_DISTRIBUTION:
# line 1125 "AdaptAnalysis.puma"
  {
# line 1127 "AdaptAnalysis.puma"
 if (TreeWriteDistribution (spec->GEN_BLOCK_DISTRIBUTION.ARRAY) != 0)

       { error_protocol ("array for GEN_BLOCK distribution must be replicated");
         tree_protocol ("illegal array is : ", spec->GEN_BLOCK_DISTRIBUTION.ARRAY);
       }
   
  }
   return;

  case kINDIRECT_DISTRIBUTION:
# line 1135 "AdaptAnalysis.puma"
  {
# line 1137 "AdaptAnalysis.puma"
   Unsupported ("INDIRECT distribution");
  }
   return;

  case kARBITRARY_DISTRIBUTION:
# line 1140 "AdaptAnalysis.puma"
  {
# line 1142 "AdaptAnalysis.puma"
   Unsupported ("ARBITRARY distribution");
  }
   return;

  case kANY_BLOCK_DISTRIBUTION:
# line 1145 "AdaptAnalysis.puma"
   return;

  case kANY_CYCLIC_DISTRIBUTION:
# line 1148 "AdaptAnalysis.puma"
  {
# line 1150 "AdaptAnalysis.puma"
   Unsupported ("CYCLIC() for dummies");
  }
   return;

  case kANY_GEN_BLOCK_DISTRIBUTION:
# line 1153 "AdaptAnalysis.puma"
  {
# line 1155 "AdaptAnalysis.puma"
   Unsupported ("GEN_BLOCK() for dummies");
  }
   return;

  case kANY_INDIRECT_DISTRIBUTION:
# line 1158 "AdaptAnalysis.puma"
  {
# line 1160 "AdaptAnalysis.puma"
   Unsupported ("INDIRECT() for dummies");
  }
   return;

  case kANY_ARBITRARY_DISTRIBUTION:
# line 1163 "AdaptAnalysis.puma"
  {
# line 1165 "AdaptAnalysis.puma"
   Unsupported ("ARBITRARY() for dummies");
  }
   return;

  case kANY_DIM_DISTRIBUTION:
# line 1168 "AdaptAnalysis.puma"
   return;

  }

# line 1171 "AdaptAnalysis.puma"
  {
# line 1172 "AdaptAnalysis.puma"
   failure_protocol (MODULE, "CheckDistributeSpec", spec);
  }
   return;

;
}

static void CheckProcessorsSpec
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
  if (p->Kind == kANY_PROCESSOR_ARRAY) {
# line 1177 "AdaptAnalysis.puma"
   return;

  }
  if (p->Kind == kDEFAULT_PROCESSOR_ARRAY) {
# line 1182 "AdaptAnalysis.puma"
  {
# line 1184 "AdaptAnalysis.puma"
   error_protocol ("default processor array not replaced");
  }
   return;

  }
;
}

void BeginAdaptAnalysis ()
{
}

void CloseAdaptAnalysis ()
{
}
