      program CALC_PI
      integer*4 I
      integer*4 N
      real*8 W
      real*8 GSUM
      integer*4 V_DSP
      real*8 V (1:2)
      integer*4 V_DIM1
      integer*4 V_ZERO
      integer*4 TICKSTART
      integer*4 TICKSTOP
      integer*4 TICKRATE
      integer*4 NP
      real*4 TIME
      real*4 MFLOPS
      integer*4 I3
      integer*4 I2
      integer*4 I1
      character*2 DALIB_1
      common /DALIB_data1/ DALIB_1
      external DALIB_all_procs
      integer*4 DALIB_all_procs
      integer*4 DALIB_0
      common /DALIB_data0/ DALIB_0
      call DALIB_init (4,4,4)
      call DALIB_set_present (DALIB_0,DALIB_1)
      call DALIB_start_subroutine ('CALC_PI',7)
      call DALIB_array_make_dsp (V_DSP,1,8,'V',1)
      print *,'Input number of stripes : '
      read *, N
      call DALIB_SYSTEM_CLOCK (TICKSTART,TICKRATE,DALIB_0)
      W = DBLE(1.0/REAL(N))
      call DALIB_array_define (V_DSP,1,N)
      call DALIB_array_allocate (V_DSP,V,V_ZERO,V_DIM1)
      do I=1,N
         V(V_ZERO+I) = DBLE(I)
         V(V_ZERO+I) = (V(V_ZERO+I)-DBLE(0.5))*W
         V(V_ZERO+I) = DBLE(4.0)/(DBLE(1.0)+V(V_ZERO+I)*V(V_ZERO+I))
      end do
      GSUM = 0.0d0
      do I3=1,N
         GSUM = GSUM+V(V_ZERO+I3)
      end do
      call DALIB_SYSTEM_CLOCK (TICKSTOP,DALIB_0,DALIB_0)
      NP = DALIB_all_procs(DALIB_0)
      TIME = FLOAT(TICKSTOP-TICKSTART)/FLOAT(TICKRATE)
      MFLOPS = REAL(9*N)/(1000000.0*TIME)
      print *,'pi ist approximated with ',GSUM*W
      print *,'time   = ',TIME,' seconds'
      print *,'mflops = ',MFLOPS,' on ',NP,' processors'
      print *,'mflops = ',MFLOPS/REAL(NP),' for one processor'
      call DALIB_array_data_free (V_DSP)
      call DALIB_array_free (V_DSP)
      call DALIB_end_subroutine ()
      call DALIB_exit ()
      end

