#undef DEBUG

#include <stdlib.h>   /* NULL */
#include "dalib.h"

struct SharedRecord
 
{ int  shared_kind;

};

/**************************************************************************
*                                                                         *
*   int dalib_is_globally_shared (Shared info)                            *
*                                                                         *
*     - returns 0 if local memory on each processor (local addresses)     *
*     - returns 1 if global memory for all processors (global addresses)  *
*                                                                         *
**************************************************************************/

int dalib_is_globally_shared (info)

Shared info;

{ 

  return (0);

} /* dalib_is_globally_shared */

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/
 
void FUNCTION(dalib_array_shared) (array_id, kind)
 
array_info *array_id;
int        *kind;
 
{ Shared shared_ptr;

  /* allocate the pointer of Shared Record structure */

  shared_ptr = (Shared) dalib_malloc (sizeof (struct SharedRecord),
                                      "dalib_array_shared");
  /* set the shared_kind */

  shared_ptr->shared_kind = *kind;

  /* assign the array_id->SharedInfo */

  (*array_id)->SharedInfo = shared_ptr;
 
  FUNCTION(dalib_barrier) ();

} /* dalib_array_shared */

void FUNCTION(dalib_array_vshared) (array_id, dummy_id, kind)
 
array_info *array_id;
 
{
}

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/

void dalib_array_shared_alloc (array_id)
 
array_info array_id;

{ /* memory is created as for a usual array */

  dalib_array_malloc (array_id);

  /* nothing else is to do */

  FUNCTION(dalib_barrier) ();
 
  /* make remote access possible */

  dalib_array_remote_init (array_id);

}  /* dalib_array_shared_alloc */
 
/**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_array_read) (data, array_id, ind1, ind2, ind3, ind4,
                                                 ind5 ,ind6, ind7)

unsigned char *data;
array_info *array_id;
int *ind1, *ind2, *ind3, *ind4, *ind5, *ind6, *ind7;
 

{ int owner;
  int offset;

  int global_indices[MAX_DIMENSIONS];
  int i, rank, size;

  int top_id;
  array_info template_dsp;

  unsigned char *pdata;

  /* pack indices for local and remote address computation */

  rank = (*array_id)->rank;
  size = (*array_id)->size;

  dalib_array_info (*array_id, &template_dsp, &top_id);

  /* initialization */

  for (i=0; i<MAX_DIMENSIONS; i++) global_indices[i] = 0;
 
  switch (rank) {
    case 7: global_indices[6] = *ind7;
    case 6: global_indices[5] = *ind6;
    case 5: global_indices[4] = *ind5;
    case 4: global_indices[3] = *ind4;
    case 3: global_indices[2] = *ind3;
    case 2: global_indices[1] = *ind2;
    case 1: global_indices[0] = *ind1;
  } /* end switch */
 
  /* compute ownership */

  if (pcb.p == 1)

      { owner = 1;
        offset = dalib_local_offset (*array_id, global_indices);
        pdata  = (*array_id)->data;
        pdata  += offset * size;
      }
       
    else

      { owner  = dalib_multidim_owner (*array_id, global_indices);
        offset = dalib_remote_offset (*array_id, owner, global_indices);
        pdata  = (unsigned char *) dalib_array_remote_data (*array_id, owner);
        pdata  += offset * size;
        owner  = dalib_top_elem (top_id, owner);
      }

  if (owner == pcb.i)          /* then it is a local data access */

    { 

#ifdef DEBUG
      printf ("%d: dalib_array_read, index = %d, local, offset = %d\n",
               pcb.i, *ind1, offset);
#endif

      dalib_memcopy (data, pdata, size);

    }

   else              /* remote data access */

    { int rtn;

#ifdef DEBUG
      printf ("%d: dalib_array_read, index = %d, remote on = %d, offset = %d\n",
               pcb.i, *ind1, owner, offset);
#endif

      rtn = CJrmread (pdata, owner-1, data, size);
 
      if (rtn != size) 

       {
         dalib_internal_error ("CJrmread failed; %d\n", rtn);
       }
 
    } /* end rpc */

}  /* dalib_array_read */

/**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_array_write) (data, array_id, ind1, ind2, ind3, ind4,
                                                 ind5 ,ind6, ind7)

unsigned char *data;
array_info *array_id;
int *ind1, *ind2, *ind3, *ind4, *ind5, *ind6, *ind7;
 

{ int owner;
  int offset;

  int global_indices[MAX_DIMENSIONS];
  int i, rank, size;

  int top_id;
  array_info template_dsp;

  unsigned char *pdata;

  /* pack indices for local and remote address computation */

  rank = (*array_id)->rank;
  size = (*array_id)->size;

  dalib_array_info (*array_id, &template_dsp, &top_id);

  /* initialization */

  for (i=0; i<MAX_DIMENSIONS; i++) global_indices[i] = 0;
 
  switch (rank) {
    case 7: global_indices[6] = *ind7;
    case 6: global_indices[5] = *ind6;
    case 5: global_indices[4] = *ind5;
    case 4: global_indices[3] = *ind4;
    case 3: global_indices[2] = *ind3;
    case 2: global_indices[1] = *ind2;
    case 1: global_indices[0] = *ind1;
  } /* end switch */
 
  /* compute ownership */

  if (pcb.p == 1)

      { owner = 1;
        offset = dalib_local_offset (*array_id, global_indices);
        pdata  = (*array_id)->data;
        pdata  += offset * size;
      }
       
    else

      { owner  = dalib_multidim_owner (*array_id, global_indices);
        offset = dalib_remote_offset (*array_id, owner, global_indices);
        pdata  = (unsigned char *) dalib_array_remote_data (*array_id, owner);
        pdata  += offset * size;
        owner  = dalib_top_elem (top_id, owner);
      }

  if (owner == pcb.i)          /* then it is a local data access */

    { 

#ifdef DEBUG
      printf ("%d: dalib_array_write, index = %d, local, offset = %d\n",
               pcb.i, *ind1, offset);
#endif

      dalib_memcopy (pdata, data, size);

    }

   else              /* remote data access */

    { int rtn;

#ifdef DEBUG
      printf ("%d: dalib_array_write, index = %d, remote on = %d, offset = %d\n",
               pcb.i, *ind1, owner, offset);
#endif

      rtn = CJrmwrite (data, owner-1, pdata, size);
 
      if (rtn != size) 

       {
         dalib_internal_error ("CJrmwrite failed; %d\n", rtn);
       }
 
    } /* end rpc */

}  /* dalib_array_write */

/**************************************************************************
*                                                                         *
*  dalib_shared_free (descriptor, data_flag)                              *
*                                                                         *
*   - delete data only if data_flag is set                                *
*                                                                         *
**************************************************************************/

void dalib_shared_free (descriptor, data_flag)

array_info descriptor;
int        data_flag;

{ Shared shared_ptr;

  FUNCTION(dalib_barrier) ();

  shared_ptr  = descriptor->SharedInfo;
 
  /* detach/deallocate distributed memory region */

  free (descriptor->data);
  free (shared_ptr);

  if (descriptor->data != NO_DATA)
 
     { /* deallocate local data of the array if data_flag */
 
       if (data_flag) free (descriptor->data);
     }

} /* dalib_shared_free */
 
