/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Feb 96                                                   *
*  Last Update : Feb 96                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : remote.m4                                                *
*                                                                         *
*  Function    : remote addressing / local offsets                        *
*                                                                         *
*  int dalib_remote_offset (array_info array_id, int pid,                 *
*                           int global_indices[]         )                *
*                                                                         *
*  unsigned char *dalib_array_remote_data (array_info array_id, int pid)  *
*                                                                         *
*  void dalib_make_remote_offsets (local_offsets, nr, base_dsp,           *
*                                  owner, mask, indexes)                  *
*                                                                         *
*   in   :  nr (number of indexes)                                        *
*           base_dsp (descriptor of accessed array)                       *
*           owner[nr] are the owner of the indexes                        *
*           mask[nr] if access is masked                                  *
*           indexes*[rank] pointers to the index arrays                   *
*                                                                         *
*   out  :  local_offsets is array of local offsets                       *
*                                                                         *
**************************************************************************/

#include "dalib.h"

#undef DEBUG
#define CHECK

/*******************************************************************
*                                                                  *
*  dalib_make_remote_offsets (local_offsets, nr, base_dsp,         *
*                             owner, mask, indexes)                *
*                                                                  *
*   in   :  nr (number of indexes)                                 *
*           base_dsp (descriptor of accessed array)                *
*           owner[nr] are the owner of the indexes                 *
*           mask[nr] if access is masked                           *
*           indexes*[rank] pointers to the index arrays            *
*                                                                  *
*   out  :  local_offsets is array of local offsets                *
*                                                                  *
*******************************************************************/

void dalib_make_remote_offsets (local_offsets, nr, base_dsp,
                                owner, mask, indexes)

int local_offsets[];
int nr;
int *indexes[];
int owner[];
int mask[];
array_info base_dsp;

{ int i, dim, rank;
  int zero;
  int extensions[MAX_DIMENSIONS+1];

  /* can be that this is called for computing schedule */

#ifdef DEBUG
  printf ("%d: make_remote_offsets for %d pointers\n",
           pcb.i, nr;
#endif

  dalib_array_remote_init (base_dsp); 

  rank = base_dsp->rank;

  if (mask == (int *) 0)

     { /* there is no mask */

       for (i=0; i<nr; i++)

          { dalib_array_remote_addressing (base_dsp, owner[i],
                                           &zero, extensions);
            local_offsets[i] = -zero;
            for (dim=0; dim < rank; dim++) 
                local_offsets[i] += *(indexes[dim]+i) * extensions[dim];

#ifdef DEBUG
  printf ("%d: global %d -> local %d\n",
           pcb.i, *(indexes[0]+i), local_offsets[i]);
#endif
          } /* end for */
     }

    else 

     { /* there is a mask avaialable */

       for (i=0; i<nr; i++)

         if (mask[i])

            { dalib_array_remote_addressing (base_dsp, owner[i],
                                             &zero, extensions);
              local_offsets[i] = -zero;
              for (dim=0; dim < rank; dim++) 
                  local_offsets[i] += *(indexes[dim]+i) * extensions[dim];
            } /* end for */
         else
              local_offsets[i] = -1;
     }

} /* dalib_make_remote_offsets */

/**************************************************************************
*                                                                         *
*  int dalib_global_is_local (array_info array_id, int *indices)          *
*                                                                         *
*   - returns true if array (global_indices) is local                     *
*   - returns false otherwise                                             *
*                                                                         *
**************************************************************************/

int dalib_global_is_local (array_id, global_indices)

        array_info *array_id;
        int *global_indices;

{ DimInfo *array_dim;
  int     *local_size;
  int     rank;
  int     offset;
  int     cnt;
  int     is_local;

  is_local = 1;
  rank = (*array_id)->rank;
  array_dim = (*array_id)->dimensions;
  cnt = 0;

  while (is_local && cnt<rank) {

    local_size = array_dim->local_size;

    /* true if index_val in lb : ub : str */

    if (*(global_indices+cnt) < local_size[0]) is_local = 0;
    if (*(global_indices+cnt) > local_size[1]) is_local = 0;

    if (is_local && (local_size[2] != 1)) {
      offset = *(global_indices+cnt) - local_size[0];

      if ((offset % local_size[2]) != 0)
        is_local = 0;
    } /* end if */

    array_dim++;
    cnt++;

  } /* end while */

  return (is_local);

} /* dalib_global_is_local */

