/* X Interface for displaying two-dimension pictures  */

#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xresource.h>

/* Definitions for Display */

XImage *xi;                    /* Structure for colored image  */
Display  *mydisplay;	/* pointer to Xdata structure controlling */
			/* the connection to the workstation.     */
Window   mywindow;	/* Data item for window and               */
GC       mygc;		/* data item for graphic context.         */
XEvent   myevent;	/* Data structure which contain informa-  */
			/* tion about each input event the        */
			/* program receives from the workstation. */
KeySym   mykey;		/* Identifier which key was pressed.      */
XSizeHints myhint;	/* Data structure which inform other      */
   			/* applications running on the same       */
			/* workstation.				  */
int      myscreen;	/* following variables are used for:      */
unsigned long myforeground; /* setting foreground                 */
unsigned long mybackground; /* setting background                 */

int WIDTH, HEIGHT;

char titel[] = "Image";

void FUNCTION(x_display_init) (dwidth, dheight)
int *dwidth, *dheight;
{
	mydisplay = XOpenDisplay("");
				/* - initiate a display connection from   */
				/*   application to the workstation       */
				/* - fill the Display structure           */
				/* - returns a pointer to the Display     */
				/*   structure                            */

        WIDTH = *dwidth;         /* global save of WIDTH */
        HEIGHT = *dheight;       /*        and HEIGHT    */

	myscreen = DefaultScreen (mydisplay);
	mybackground = BlackPixel (mydisplay, myscreen);
	myforeground = WhitePixel (mydisplay, myscreen);
				/* determine the pixel values for drawing */
				/* the window.                            */
	myhint.x = 100; myhint.y = 100;
				/* position of the window.                */
	myhint.width = *dwidth; myhint.height = *dheight;
				/* size of the window.                    */
	myhint.flags = PPosition | PSize;
				/* indicate which fields in XSizeHints    */
				/* structure are filled in.               */
	mywindow = XCreateSimpleWindow (mydisplay,
		DefaultRootWindow (mydisplay),
		myhint.x, myhint.y, myhint.width, myhint.height,
		5, myforeground, mybackground);
				/* - creates a sample application window, */
				/*   but itis not viewable.               */
				/* - in mywindow returns the window's     */
				/*   resource idnetifier.                 */
	XSetStandardProperties (mydisplay, mywindow, titel, titel,
			        None, NULL, 0, &myhint);
				/* describes new window to other applica- */
				/* tions running on that workstation      */
				/* (e.g. name and size).                  */
	mygc = XCreateGC (mydisplay, mywindow, 0, 0);
	XSetBackground (mydisplay, mygc, mybackground);
	XSetForeground (mydisplay, mygc, myforeground);
				/* create a graphical context.            */
				/* a graphical context contains attribu-  */
				/* tes for graphical output (e.g. line    */
				/* width, text font).                     */
				/* here set the foreground and background */
				/* values, the other attributes are       */
				/* default.                               */
	XSelectInput (mydisplay, mywindow,
		      ButtonPressMask | KeyPressMask
                      | ResizeRedirectMask          ); 
				/* program want to receive notification   */
				/* when a mouse button or a keyboard key  */
				/* is pressed in mywindow.                */
				/* It tells the workstation to send       */
				/* Expose events. (Event to ask the       */
				/* program to redraw the graphical image) */
	XMapRaised (mydisplay, mywindow);
				/* Displays the window on the screen.     */
				/* Send an expose event to the program to */
				/* redraw the contents of the window.     */

        setcolormap (mydisplay,mygc,mywindow);

        xi = XGetImage (mydisplay,mywindow,0,0,
                        WIDTH, HEIGHT,
                        AllPlanes, ZPixmap);
}

void FUNCTION(x_display_exit) ()
{
	XFreeGC (mydisplay, mygc);
				/* destroy graphic context                */
	XDestroyWindow (mydisplay, mywindow);
				/* destroy window                         */
	XCloseDisplay (mydisplay);
				/* closes the display                     */
}

void FUNCTION(x_show_bild) (bild)
int *bild;
{
   int i, j;
   int (*pp)();
   char *data;
   int  *hbild;
   char d;

   /* printf("Mandel transfers the image \n"); */
   pp = xi->f.put_pixel;
   data = xi->data;

   hbild = bild;
   for (j=0; j<HEIGHT;j++)  /* column order, width is 2nd dimension */
    { hbild = bild + j;
      for (i=0;i<WIDTH;i++)
        {  *data = *hbild;
           /* j is x-position, i is y-position */
           /* XPutPixel (xi, j, i, d); */
           data += 1;
           hbild += HEIGHT;
        }
    }
   /* printf("put image\n"); */
   XPutImage (mydisplay,mywindow,mygc,xi,0,0,0,0,
              WIDTH,HEIGHT);
}

static void setcolormap (mydisplay,mygc,mywindow)
Display *mydisplay;
GC mygc;
Window mywindow;
{
  XVisualInfo vtemp;
  XVisualInfo *vlist;
  int myscreen;
  int visMatched;
  int i;
  Colormap cmap;

  myscreen = DefaultScreen (mydisplay);
  vtemp.screen = myscreen;
  vtemp.depth = 8;
  vtemp.class = PseudoColor;
  vlist = XGetVisualInfo (mydisplay,
           VisualScreenMask | VisualDepthMask | VisualClassMask,
           &vtemp, &visMatched);
  cmap = XCreateColormap (mydisplay,mywindow,
        vlist[0].visual, AllocNone);
  setcolors (mydisplay,cmap);
  XSetWindowColormap (mydisplay,mywindow,cmap);
}

static void setcolors (mydisplay,cmap)
Display *mydisplay;
Colormap cmap;
{ 
  XColor color;

  static float bands [7][8] = {
   { 0.0, 0.0, 0.0, 0.5, 1.0, 0.6, 0.5, 0.95 },
   { 0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 0.5, 0.95 },
   { 0.0, 0.5, 0.9, 0.3, 0.0, 0.0, 1.0, 0.0 },

   { 0.0, 0.0, 0.6, 0.8, 0.7, 1.0, 0.85, 1.0 },
   { 0.0, 0.0, 0.0, 0.0, 0.6, 1.0, 0.85, 1.0 },
   { 0.6, 0.8, 0.5, 0.0, 0.0, 0.0, 0.0, 1.0 },
   
   { 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.2, 0.2 }};

  float fraction ;

  int i, b;

  float fred, fgreen, fblue;

  fraction = 0.0;
  b = 0;
 
  for (i=0;i<256;i++)
   {
     if (fraction > bands[6][b])
        { fraction = fraction - bands [6][b];
          b = b + 1;
          if (b >= 8) break;
        }
     fred = bands[0][b] + (bands[3][b] - bands[0][b]) *
                  (fraction / bands[6][b]);
     fgreen = bands[1][b] + (bands[4][b] - bands[1][b]) *
                  (fraction / bands[6][b]);
     fblue = bands[2][b] + (bands[5][b] - bands[2][b]) *
                  (fraction / bands[6][b]);
     fraction = fraction + 1.0 / 256;
     color.red = (fred*65535);
     color.blue = (fblue*65535);
     color.green = (fgreen*65535);
     XAllocColor(mydisplay,cmap,&color);
   }
}

void FUNCTION(x_new_action) (hx1,hx2,hy1,hy2)
int *hx1, *hx2, *hy1, *hy2;
{  int done;
   int first;
   int i;
   XEvent myevent;
   char text[10];

   done = 0;
   first = 0;
   *hx1 = 0;
   *hx2 = 0; 
   while ( done == 0 )
     {
	XNextEvent (mydisplay, &myevent);
	switch (myevent.type) {
	case MappingNotify:
		XRefreshKeyboardMapping (&myevent);
		break;
	case ButtonPress:
               if (first == 0)
                 { first = 1;
                   *hx1 = myevent.xbutton.x;
                   *hy1 = myevent.xbutton.y;
                 }
                else
                 {
                   done = 1;
                   *hx2 = myevent.xbutton.x;
                   *hy2 = myevent.xbutton.y;
                 }
		break;
	case KeyPress:
		i = XLookupString (&myevent, text, 10, &mykey, 0);
		if (i == 1 && text[0] == 'q') done = 1;
		break;
        }
    }        		/* while (done == 0)     */
} 				/* main */

