/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                 *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 94                                            *
*  Last Update : Feb 94                                            *
*                                                                  *
*  This Module is part of the DALIB                                *
*                                                                  *
*  INITIALIZATION OF PROGRAM with Shared Memory Segments           *
*                                                                  *
*  MODULE : init.c                                                 *
*                                                                  *
*  Function: Realization of System Dependent Operations            *
*                                                                  *
*******************************************************************/

#undef DEBUG

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/errno.h>
#include <string.h>
#include "dalib.h"
#include "system.h"

#define PAGE_SIZE 4096

int NP;          /* number of node processes */
int my_id;       /* number of my process: 0 (host), 1 .. NP */
int PID[MAXP];   /* number of process ids */

int sem_id;      /* id for the semaphores */
int shm_id;      /* id for the shared memory region */

mailbox * mail_memory;

extern int errno;

void system_start ()

{  /* initialization of shared memory segment and semaphores */

   /* note NP has defined here already */

  int memsize, smemsize;
  int k;

#if defined(SUN4) || defined(SGI)
  union semun arg;
#elif defined(SX4)
  union semun {
     int val;
     struct semid_ds *buf;
     ushort *array;
  };
  union semun arg;
#endif 

  memsize = 0;   /* real created size */

  smemsize = sizeof (mailbox);
  smemsize = smemsize * (NP + 1);
 
  while (memsize < smemsize) memsize += PAGE_SIZE;

#ifdef DEBUG
  printf ("Size of shared memory: needed = %d, allocated = %d\n",
           smemsize, memsize);        
#endif

  shm_id = shmget (IPC_PRIVATE, memsize, 255*256+255);

  if (shm_id == -1)
    { printf ("Creating Shared Memory failed, shm_id = %d\n", shm_id);
      if (errno == EINVAL) printf ("illegal size\n");
       else if (errno == ENOMEM) printf ("not enough memoyr\n");
       else if (errno == ENOSPC) printf ("system shared memory exceeded\n");
       else printf ("error number = %d\n", errno);
      exit (-1);
    }

  /* now attach to the new created shared memory region */

  mail_memory = (mailbox *) shmat (shm_id, (char *) 0, SHM_RND);

  if (mail_memory == (mailbox *) -1)
    { printf ("Attaching to shared memory segement failed\n");
      exit (-1);
    }

#ifdef DEBUG
  printf ("will create %d semaphores\n", NP+2); 
#endif 

  sem_id = semget (IPC_PRIVATE, NP+2, 256*255+255);

  if (sem_id == -1)
   { printf ("creating semaphores, semget failed\n");
     if (errno == ENOSPC)
        printf ("system-imposed  limit  on  the  maximum number exceeded\n");
     if (errno == ENOENT) 
        printf ("key not existent\n");
     if (errno == EINVAL) 
        printf ("number %d out of range\n", NP+2);
     if (errno == EACCES) 
        printf ("access problems\n");
     exit (-1);
   }

#ifdef DEBUG
  printf ("semaphores created, now set control\n");
#endif

#if defined(SUN4) || defined(SGI) || defined(SX4)
  arg.val = 1;
  for (k=0; k < NP + 2; k++)
     semctl (sem_id, k, SETVAL, arg); 
#else
  for (k=0; k < NP + 2; k++)
    semctl (sem_id, k, SETVAL, 1); 
#endif

#ifdef DEBUG
  printf ("semaphores initialized\n");
#endif

  init_mailboxes (NP);    /* initialize mailing system */

#ifdef DEBUG
  printf("Mailboxes initialized\n"); 
#endif

}

static void system_stop ()

{ int i, waitid, status, offset;

  /* removed shared region and semaphores */

  offset = 1 + 1;

#if defined(SGI)
#else
  for (i=offset;i<=NP;i++)
    waitid = wait (&status);
#endif

  semctl (sem_id, 0, IPC_RMID, 0);
  shmctl (shm_id, IPC_RMID, 0);

  printf ("ADAPTOR PARALLEL EXECUTION STOP \n");
}

void dalib_machine_enroll (UsedNP)

int *UsedNP;

{ int i;
  int offset;

  /* evaluation of parameters */

  NP = 0;

  eval_arg (0, MAXP);

  NP = pcb.p;
  pcb.trace_flag = 0;   /* not realized yet */

  system_start ();   /* creating shared memory region */

  my_id = 1;

#if defined(SGI)

  /* we use start_pes to fork processes */

  start_pes (NP);

  my_id = _my_pe () + 1;

#ifdef DEBUG
  printf ("I am %d of %d processes \n", my_id, _num_pes());
#endif

#else

  /* printf ("Node 1 will fork for nodes\n"); */
   
  offset = 2;

  for (i=offset; i<=NP; i++)
    if (my_id == 1)
      { /* host or first cube node creates a new process */
        PID [i-1] = fork ();
        if (PID[i-1] == 0)
           { /* I am the new created child */
             my_id = i;
           }
#ifdef DEBUG
         else printf ("process %d created\n", PID[i-1]);
#endif
      }

#endif

  /* definition of the process control block */

  pcb.i       = my_id;
  pcb.p       = NP;

  *UsedNP = NP;
  
#ifdef DEBUG
  printf ("%d has enrolled\n", pcb.i);
#endif

}

/*******************************************************************
*                                                                  *
*  number and ids of processes                                     *
*                                                                  *
*******************************************************************/

/* managing semaphores that lock / unlock mailboxes */

void my_lock (p)
int p;
{ /* set semaphore to zero if one or wait for one */
 
   struct sembuf op;
   int status;

   op.sem_num = p;
   op.sem_op = -1;
   op.sem_flg = 0;

   status = semop (sem_id, &op, 1);

   if (status == -1)
    { printf ("Status after lock %d is %d \n", p, status);
      exit (-1);
    }
}

void my_unlock (p)
int p;
{  /* set semaphore to one */
 
   struct sembuf op;
   int status;

   op.sem_num = p;
   op.sem_op = 1;
   op.sem_flg = 0;

   status = semop (sem_id, &op, 1);

   if (status == -1)
    { printf ("Status after unlock %d is %d \n", p, status);
      exit (-1);
    }
}

/*******************************************************************
*                                                                  *
*  Initialization functions                                        *
*                                                                  *
*******************************************************************/

void dalib_machine_exit ()

{
  if (pcb.i == 1)
     system_stop ();
}
