/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Oct 97                                                   *
*  Last Update : Oct 97                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : tensor                                                   *
*                                                                         *
*  Function    : tensor execuction of communication schedules             *
*                                                                         *
*                                                                         *
**************************************************************************/

typedef struct

   { array_info CommArray;      /* array for which we communicate */

     int is_permutation;
     int permuatation [MAX_DIMENSIONS];

     int dim_type [MAX_DIMENSIONS];   /* 0 for single element, 1 for range */
     int dim_range [MAX_DIMENSIONS];

     int topology;
     int topology_ref; 
     int topology_mask;
     int top_dims[MAX_RANK];

   } CommDescriptor;


typedef struct

   { int schedule_kind;
     int schedule_id;

     int source_index_dim;
     int source_top_dim;

     int target_index_dim;
     int target_top_dim;
     
   } TensorScheduleEntry;


void dalib_tensor_send (schedules, no, source)

TensorScheduleEntry *schedules;
int                 no;
CommDescriptor      *source;

{ int p1, p_low1, p_high1;
  int top_id, pid;
  int lb1, ub1, str1, N1;

  int dim1, s1, dist1;

  if (no == 0)

     { /* no more schedules, so we can send everyting fixed in source */

       dalib_tensor_send_now (source);
       return;

     }

  /* schedule maps one index dimension to a topology dimension */

  s_id      = source->schedule_id;
  index_dim = source->source_index_dim;
  top_dim   = source->target_top_dim;

  dist = dalib_top_distance (source->topology, top_dim);

  dalib_schedule_psends (s_id, &p_low, &p_high);

  for (p = p_low; p <= p_high; p++)

    { dalib_schedule_send_range (s, p, 1, &lb, &ub, &str, &N);

      source->dim_range[index_dim-1][0] = lb;
      source->dim_range[index_dim-1][1] = ub;
      source->dim_range[index_dim-1][2] = str; 

      source->topology_ref = pid_ref + (p - 1) * dist;

      dalib_tensor_send (schedules+1, no-1, source);

    }

  source->topology_ref = pid_ref;

} /* dalib_tensor_send */
