/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                 *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 94                                            *
*  Last Update : Aug 97                                            *
*                                                                  *
*  This Module is part of the DALIB                                *
*                                                                  *
*  INITIALIZATION OF PROGRAM for MPI (Version xxx)                 *
*                                                                  *
*  MODULE : init.m4                                                *
*                                                                  *
*  Function: Realization of System Dependent Operations            *
*                                                                  *
*******************************************************************/

#include <stdio.h>
#include <string.h>
#include "dalib.h"

#ifdef CENJU3
#include "/vol/local/mpich/include/mpi.h" 
#else
#include "mpi.h"
#endif


# undef DEBUG

# define INIT_MSGID  9999

void dalib_machine_exit ()

{
   MPI_Finalize ();
}

void dalib_machine_enroll (NP) 

int *NP;

{   int rank, size;
    int error;
    int i;

    MPI_Status status;

#ifdef DEBUG
    printf( "start mpi_init\n");
#endif

    FUNCTION(mpi_init) (&error); 

#ifdef DEBUG
    printf( "end mpi_init\n");
#endif

    MPI_Comm_rank( MPI_COMM_WORLD, &rank );
    MPI_Comm_size( MPI_COMM_WORLD, &size );

#ifdef DEBUG
    printf( "Process %d of %d is alive\n", rank, size );
#endif

    pcb.i = rank+1;  /* numbering from 1 to NP instead of 0 .. NP-1 */
    *NP   = size;

    if (pcb.i == 1)

      { /* only first process gets the parameters */

        eval_arg (*NP, *NP);

      }

} /* dalib_machine_enroll */
